// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack23.h"



static void unpack_1_23bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit signed
	// Skip 0 bits, read 23 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit unsigned
	// Skip 0 bits, read 23 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit signed
	// Skip 1 bits, read 23 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit unsigned
	// Skip 1 bits, read 23 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit signed
	// Skip 2 bits, read 23 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit unsigned
	// Skip 2 bits, read 23 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit signed
	// Skip 3 bits, read 23 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit unsigned
	// Skip 3 bits, read 23 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit signed
	// Skip 4 bits, read 23 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit unsigned
	// Skip 4 bits, read 23 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit signed
	// Skip 5 bits, read 23 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit unsigned
	// Skip 5 bits, read 23 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit signed
	// Skip 6 bits, read 23 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit unsigned
	// Skip 6 bits, read 23 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit signed
	// Skip 7 bits, read 23 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);
}

static void unpack_1_23bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 23-bit unsigned
	// Skip 7 bits, read 23 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);
}

static void unpack_2_23bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit signed
	// Skip 0 bits, read 46 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit unsigned
	// Skip 0 bits, read 46 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit signed
	// Skip 1 bits, read 46 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit unsigned
	// Skip 1 bits, read 46 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit signed
	// Skip 2 bits, read 46 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit unsigned
	// Skip 2 bits, read 46 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit signed
	// Skip 3 bits, read 46 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit unsigned
	// Skip 3 bits, read 46 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit signed
	// Skip 4 bits, read 46 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit unsigned
	// Skip 4 bits, read 46 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit signed
	// Skip 5 bits, read 46 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit unsigned
	// Skip 5 bits, read 46 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit signed
	// Skip 6 bits, read 46 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit unsigned
	// Skip 6 bits, read 46 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit signed
	// Skip 7 bits, read 46 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);
}

static void unpack_2_23bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 23-bit unsigned
	// Skip 7 bits, read 46 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);
}

static void unpack_3_23bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit signed
	// Skip 0 bits, read 69 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 46 to 68
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf8) << 6);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit unsigned
	// Skip 0 bits, read 69 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 46 to 68
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf8) << 6);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit signed
	// Skip 1 bits, read 69 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 47 to 69
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xfc) << 7);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit unsigned
	// Skip 1 bits, read 69 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 47 to 69
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xfc) << 7);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit signed
	// Skip 2 bits, read 69 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 48 to 70
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfe) << 8);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit unsigned
	// Skip 2 bits, read 69 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 48 to 70
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfe) << 8);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit signed
	// Skip 3 bits, read 69 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 49 to 71
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit unsigned
	// Skip 3 bits, read 69 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 49 to 71
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit signed
	// Skip 4 bits, read 69 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 50 to 72
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0x80) << 2);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit unsigned
	// Skip 4 bits, read 69 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 50 to 72
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0x80) << 2);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit signed
	// Skip 5 bits, read 69 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 51 to 73
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xc0) << 3);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit unsigned
	// Skip 5 bits, read 69 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 51 to 73
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xc0) << 3);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit signed
	// Skip 6 bits, read 69 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 52 to 74
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xe0) << 4);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit unsigned
	// Skip 6 bits, read 69 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 52 to 74
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xe0) << 4);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit signed
	// Skip 7 bits, read 69 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 53 to 75
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf0) << 5);
	output[2] = (double)(value >> 9);
}

static void unpack_3_23bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 23-bit unsigned
	// Skip 7 bits, read 69 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 53 to 75
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf0) << 5);
	output[2] = (double)(value >> 9);
}

static void unpack_4_23bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit signed
	// Skip 0 bits, read 92 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 46 to 68
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf8) << 6);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 69 to 91
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xf0) << 5);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit unsigned
	// Skip 0 bits, read 92 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 46 to 68
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf8) << 6);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 69 to 91
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xf0) << 5);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit signed
	// Skip 1 bits, read 92 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 47 to 69
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xfc) << 7);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 70 to 92
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf8) << 6);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit unsigned
	// Skip 1 bits, read 92 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 47 to 69
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xfc) << 7);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 70 to 92
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf8) << 6);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit signed
	// Skip 2 bits, read 92 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 48 to 70
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfe) << 8);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 71 to 93
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xfc) << 7);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit unsigned
	// Skip 2 bits, read 92 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 48 to 70
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfe) << 8);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 71 to 93
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xfc) << 7);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit signed
	// Skip 3 bits, read 92 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 49 to 71
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 72 to 94
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfe) << 8);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit unsigned
	// Skip 3 bits, read 92 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 49 to 71
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 72 to 94
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfe) << 8);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit signed
	// Skip 4 bits, read 92 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 50 to 72
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0x80) << 2);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 73 to 95
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit unsigned
	// Skip 4 bits, read 92 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 50 to 72
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0x80) << 2);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 73 to 95
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit signed
	// Skip 5 bits, read 92 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 51 to 73
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xc0) << 3);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 74 to 96
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0x80) << 2);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit unsigned
	// Skip 5 bits, read 92 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 51 to 73
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xc0) << 3);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 74 to 96
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0x80) << 2);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit signed
	// Skip 6 bits, read 92 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 52 to 74
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xe0) << 4);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 75 to 97
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xc0) << 3);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit unsigned
	// Skip 6 bits, read 92 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 52 to 74
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xe0) << 4);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 75 to 97
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xc0) << 3);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit signed
	// Skip 7 bits, read 92 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 53 to 75
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf0) << 5);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 76 to 98
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xe0) << 4);
	output[3] = (double)(value >> 9);
}

static void unpack_4_23bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 23-bit unsigned
	// Skip 7 bits, read 92 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 53 to 75
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf0) << 5);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 76 to 98
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xe0) << 4);
	output[3] = (double)(value >> 9);
}

static void unpack_5_23bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit signed
	// Skip 0 bits, read 115 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 46 to 68
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf8) << 6);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 69 to 91
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xf0) << 5);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 92 to 114
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xe0) << 4);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit unsigned
	// Skip 0 bits, read 115 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 46 to 68
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf8) << 6);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 69 to 91
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xf0) << 5);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 92 to 114
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xe0) << 4);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit signed
	// Skip 1 bits, read 115 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 47 to 69
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xfc) << 7);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 70 to 92
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf8) << 6);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 93 to 115
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xf0) << 5);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit unsigned
	// Skip 1 bits, read 115 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 47 to 69
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xfc) << 7);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 70 to 92
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf8) << 6);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 93 to 115
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xf0) << 5);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit signed
	// Skip 2 bits, read 115 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 48 to 70
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfe) << 8);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 71 to 93
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xfc) << 7);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 94 to 116
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf8) << 6);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit unsigned
	// Skip 2 bits, read 115 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 48 to 70
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfe) << 8);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 71 to 93
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xfc) << 7);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 94 to 116
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf8) << 6);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit signed
	// Skip 3 bits, read 115 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 49 to 71
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 72 to 94
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfe) << 8);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 95 to 117
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xfc) << 7);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit unsigned
	// Skip 3 bits, read 115 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 49 to 71
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 72 to 94
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfe) << 8);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 95 to 117
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xfc) << 7);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit signed
	// Skip 4 bits, read 115 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 50 to 72
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0x80) << 2);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 73 to 95
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 96 to 118
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xfe) << 8);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit unsigned
	// Skip 4 bits, read 115 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 50 to 72
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0x80) << 2);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 73 to 95
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 96 to 118
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xfe) << 8);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit signed
	// Skip 5 bits, read 115 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 51 to 73
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xc0) << 3);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 74 to 96
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0x80) << 2);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 97 to 119
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit unsigned
	// Skip 5 bits, read 115 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 51 to 73
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xc0) << 3);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 74 to 96
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0x80) << 2);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 97 to 119
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit signed
	// Skip 6 bits, read 115 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 52 to 74
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xe0) << 4);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 75 to 97
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xc0) << 3);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 98 to 120
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0x80) << 2);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit unsigned
	// Skip 6 bits, read 115 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 52 to 74
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xe0) << 4);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 75 to 97
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xc0) << 3);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 98 to 120
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0x80) << 2);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit signed
	// Skip 7 bits, read 115 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 53 to 75
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf0) << 5);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 76 to 98
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xe0) << 4);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 99 to 121
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xc0) << 3);
	output[4] = (double)(value >> 9);
}

static void unpack_5_23bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 23-bit unsigned
	// Skip 7 bits, read 115 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 53 to 75
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf0) << 5);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 76 to 98
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xe0) << 4);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 99 to 121
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xc0) << 3);
	output[4] = (double)(value >> 9);
}

static void unpack_6_23bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit signed
	// Skip 0 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 46 to 68
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf8) << 6);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 69 to 91
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xf0) << 5);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 92 to 114
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xe0) << 4);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 115 to 137
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xc0) << 3);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit unsigned
	// Skip 0 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 46 to 68
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf8) << 6);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 69 to 91
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xf0) << 5);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 92 to 114
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xe0) << 4);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 115 to 137
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xc0) << 3);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit signed
	// Skip 1 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 47 to 69
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xfc) << 7);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 70 to 92
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf8) << 6);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 93 to 115
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xf0) << 5);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 116 to 138
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xe0) << 4);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit unsigned
	// Skip 1 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 47 to 69
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xfc) << 7);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 70 to 92
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf8) << 6);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 93 to 115
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xf0) << 5);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 116 to 138
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xe0) << 4);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit signed
	// Skip 2 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 48 to 70
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfe) << 8);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 71 to 93
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xfc) << 7);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 94 to 116
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf8) << 6);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 117 to 139
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xf0) << 5);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit unsigned
	// Skip 2 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 48 to 70
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfe) << 8);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 71 to 93
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xfc) << 7);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 94 to 116
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf8) << 6);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 117 to 139
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xf0) << 5);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit signed
	// Skip 3 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 49 to 71
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 72 to 94
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfe) << 8);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 95 to 117
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xfc) << 7);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 118 to 140
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)(input[17] & 0xf8) << 6);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit unsigned
	// Skip 3 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 49 to 71
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 72 to 94
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfe) << 8);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 95 to 117
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xfc) << 7);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 118 to 140
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)(input[17] & 0xf8) << 6);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit signed
	// Skip 4 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 50 to 72
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0x80) << 2);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 73 to 95
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 96 to 118
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xfe) << 8);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 119 to 141
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)(input[17] & 0xfc) << 7);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit unsigned
	// Skip 4 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 50 to 72
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0x80) << 2);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 73 to 95
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 96 to 118
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xfe) << 8);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 119 to 141
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)(input[17] & 0xfc) << 7);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit signed
	// Skip 5 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 51 to 73
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xc0) << 3);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 74 to 96
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0x80) << 2);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 97 to 119
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 120 to 142
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xfe) << 8);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit unsigned
	// Skip 5 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 51 to 73
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xc0) << 3);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 74 to 96
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0x80) << 2);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 97 to 119
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 120 to 142
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xfe) << 8);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit signed
	// Skip 6 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 52 to 74
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xe0) << 4);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 75 to 97
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xc0) << 3);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 98 to 120
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0x80) << 2);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 121 to 143
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit unsigned
	// Skip 6 bits, read 138 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 52 to 74
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xe0) << 4);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 75 to 97
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xc0) << 3);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 98 to 120
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0x80) << 2);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 121 to 143
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit signed
	// Skip 7 bits, read 138 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 53 to 75
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf0) << 5);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 76 to 98
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xe0) << 4);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 99 to 121
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xc0) << 3);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 122 to 144
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0x80) << 2);
	output[5] = (double)(value >> 9);
}

static void unpack_6_23bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 23-bit unsigned
	// Skip 7 bits, read 138 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 53 to 75
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf0) << 5);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 76 to 98
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xe0) << 4);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 99 to 121
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xc0) << 3);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 122 to 144
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0x80) << 2);
	output[5] = (double)(value >> 9);
}

static void unpack_7_23bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit signed
	// Skip 0 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 46 to 68
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf8) << 6);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 69 to 91
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xf0) << 5);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 92 to 114
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xe0) << 4);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 115 to 137
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xc0) << 3);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 138 to 160
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10) |
			((uint32_t)(input[20] & 0x80) << 2);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit unsigned
	// Skip 0 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 46 to 68
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf8) << 6);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 69 to 91
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xf0) << 5);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 92 to 114
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xe0) << 4);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 115 to 137
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xc0) << 3);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 138 to 160
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10) |
			((uint32_t)(input[20] & 0x80) << 2);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit signed
	// Skip 1 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 47 to 69
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xfc) << 7);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 70 to 92
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf8) << 6);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 93 to 115
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xf0) << 5);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 116 to 138
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xe0) << 4);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 139 to 161
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0xc0) << 3);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit unsigned
	// Skip 1 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 47 to 69
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xfc) << 7);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 70 to 92
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf8) << 6);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 93 to 115
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xf0) << 5);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 116 to 138
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xe0) << 4);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 139 to 161
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0xc0) << 3);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit signed
	// Skip 2 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 48 to 70
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfe) << 8);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 71 to 93
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xfc) << 7);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 94 to 116
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf8) << 6);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 117 to 139
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xf0) << 5);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 140 to 162
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)(input[20] & 0xe0) << 4);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit unsigned
	// Skip 2 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 48 to 70
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfe) << 8);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 71 to 93
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xfc) << 7);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 94 to 116
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf8) << 6);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 117 to 139
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xf0) << 5);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 140 to 162
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)(input[20] & 0xe0) << 4);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit signed
	// Skip 3 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 49 to 71
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 72 to 94
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfe) << 8);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 95 to 117
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xfc) << 7);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 118 to 140
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)(input[17] & 0xf8) << 6);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 141 to 163
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0xf0) << 5);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit unsigned
	// Skip 3 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 49 to 71
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 72 to 94
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfe) << 8);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 95 to 117
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xfc) << 7);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 118 to 140
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)(input[17] & 0xf8) << 6);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 141 to 163
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0xf0) << 5);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit signed
	// Skip 4 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 50 to 72
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0x80) << 2);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 73 to 95
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 96 to 118
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xfe) << 8);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 119 to 141
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)(input[17] & 0xfc) << 7);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 142 to 164
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xf8) << 6);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit unsigned
	// Skip 4 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 50 to 72
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0x80) << 2);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 73 to 95
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 96 to 118
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xfe) << 8);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 119 to 141
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)(input[17] & 0xfc) << 7);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 142 to 164
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xf8) << 6);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit signed
	// Skip 5 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 51 to 73
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xc0) << 3);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 74 to 96
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0x80) << 2);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 97 to 119
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 120 to 142
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xfe) << 8);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 143 to 165
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xfc) << 7);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit unsigned
	// Skip 5 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 51 to 73
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xc0) << 3);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 74 to 96
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0x80) << 2);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 97 to 119
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 120 to 142
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xfe) << 8);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 143 to 165
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xfc) << 7);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit signed
	// Skip 6 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 52 to 74
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xe0) << 4);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 75 to 97
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xc0) << 3);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 98 to 120
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0x80) << 2);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 121 to 143
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 144 to 166
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xfe) << 8);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit unsigned
	// Skip 6 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 52 to 74
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xe0) << 4);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 75 to 97
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xc0) << 3);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 98 to 120
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0x80) << 2);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 121 to 143
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 144 to 166
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xfe) << 8);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit signed
	// Skip 7 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 53 to 75
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf0) << 5);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 76 to 98
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xe0) << 4);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 99 to 121
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xc0) << 3);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 122 to 144
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0x80) << 2);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 145 to 167
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9);
	output[6] = (double)(value >> 9);
}

static void unpack_7_23bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 23-bit unsigned
	// Skip 7 bits, read 161 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 53 to 75
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf0) << 5);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 76 to 98
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xe0) << 4);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 99 to 121
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xc0) << 3);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 122 to 144
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0x80) << 2);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 145 to 167
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9);
	output[6] = (double)(value >> 9);
}

static void unpack_8_23bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit signed
	// Skip 0 bits, read 184 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 46 to 68
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf8) << 6);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 69 to 91
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xf0) << 5);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 92 to 114
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xe0) << 4);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 115 to 137
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xc0) << 3);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 138 to 160
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10) |
			((uint32_t)(input[20] & 0x80) << 2);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 161 to 183
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit unsigned
	// Skip 0 bits, read 184 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 22
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfe) << 8);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 23 to 45
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xfc) << 7);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 46 to 68
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf8) << 6);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 69 to 91
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xf0) << 5);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 92 to 114
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xe0) << 4);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 115 to 137
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xc0) << 3);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 138 to 160
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10) |
			((uint32_t)(input[20] & 0x80) << 2);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 161 to 183
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit signed
	// Skip 1 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 47 to 69
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xfc) << 7);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 70 to 92
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf8) << 6);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 93 to 115
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xf0) << 5);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 116 to 138
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xe0) << 4);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 139 to 161
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0xc0) << 3);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 162 to 184
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0x80) << 2);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit unsigned
	// Skip 1 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 23
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 24 to 46
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfe) << 8);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 47 to 69
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xfc) << 7);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 70 to 92
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf8) << 6);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 93 to 115
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xf0) << 5);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 116 to 138
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xe0) << 4);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 139 to 161
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0xc0) << 3);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 162 to 184
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0x80) << 2);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit signed
	// Skip 2 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 48 to 70
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfe) << 8);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 71 to 93
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xfc) << 7);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 94 to 116
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf8) << 6);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 117 to 139
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xf0) << 5);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 140 to 162
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)(input[20] & 0xe0) << 4);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 163 to 185
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xc0) << 3);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit unsigned
	// Skip 2 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 24
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0x80) << 2);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 25 to 47
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 48 to 70
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfe) << 8);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 71 to 93
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xfc) << 7);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 94 to 116
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf8) << 6);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 117 to 139
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xf0) << 5);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 140 to 162
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)(input[20] & 0xe0) << 4);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 163 to 185
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xc0) << 3);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit signed
	// Skip 3 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 49 to 71
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 72 to 94
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfe) << 8);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 95 to 117
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xfc) << 7);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 118 to 140
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)(input[17] & 0xf8) << 6);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 141 to 163
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0xf0) << 5);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 164 to 186
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)(input[23] & 0xe0) << 4);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit unsigned
	// Skip 3 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 25
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xc0) << 3);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 26 to 48
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0x80) << 2);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 49 to 71
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 72 to 94
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfe) << 8);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 95 to 117
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xfc) << 7);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 118 to 140
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)(input[17] & 0xf8) << 6);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 141 to 163
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0xf0) << 5);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 164 to 186
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)(input[23] & 0xe0) << 4);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit signed
	// Skip 4 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 50 to 72
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0x80) << 2);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 73 to 95
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 96 to 118
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xfe) << 8);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 119 to 141
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)(input[17] & 0xfc) << 7);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 142 to 164
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xf8) << 6);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 165 to 187
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0xf0) << 5);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit unsigned
	// Skip 4 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 26
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xe0) << 4);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 27 to 49
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xc0) << 3);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 50 to 72
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0x80) << 2);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 73 to 95
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 96 to 118
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xfe) << 8);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 119 to 141
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)(input[17] & 0xfc) << 7);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 142 to 164
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xf8) << 6);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 165 to 187
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0xf0) << 5);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit signed
	// Skip 5 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 51 to 73
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xc0) << 3);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 74 to 96
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0x80) << 2);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 97 to 119
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 120 to 142
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xfe) << 8);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 143 to 165
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xfc) << 7);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 166 to 188
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xf8) << 6);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit unsigned
	// Skip 5 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 27
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf0) << 5);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 28 to 50
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xe0) << 4);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 51 to 73
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xc0) << 3);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 74 to 96
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0x80) << 2);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 97 to 119
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 120 to 142
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xfe) << 8);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 143 to 165
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xfc) << 7);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 166 to 188
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xf8) << 6);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit signed
	// Skip 6 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 52 to 74
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xe0) << 4);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 75 to 97
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xc0) << 3);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 98 to 120
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0x80) << 2);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 121 to 143
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 144 to 166
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xfe) << 8);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 167 to 189
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xfc) << 7);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit unsigned
	// Skip 6 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 28
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf8) << 6);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 29 to 51
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf0) << 5);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 52 to 74
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xe0) << 4);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 75 to 97
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xc0) << 3);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 98 to 120
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0x80) << 2);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 121 to 143
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 144 to 166
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xfe) << 8);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 167 to 189
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xfc) << 7);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit signed
	// Skip 7 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 53 to 75
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf0) << 5);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 76 to 98
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xe0) << 4);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 99 to 121
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xc0) << 3);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 122 to 144
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0x80) << 2);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 145 to 167
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 168 to 190
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xfe) << 8);
	output[7] = (double)(value >> 9);
}

static void unpack_8_23bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 23-bit unsigned
	// Skip 7 bits, read 184 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 29
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfc) << 7);
	output[0] = (double)(value >> 9);

	// read output[1]: from bit 30 to 52
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xf8) << 6);
	output[1] = (double)(value >> 9);

	// read output[2]: from bit 53 to 75
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf0) << 5);
	output[2] = (double)(value >> 9);

	// read output[3]: from bit 76 to 98
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xe0) << 4);
	output[3] = (double)(value >> 9);

	// read output[4]: from bit 99 to 121
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xc0) << 3);
	output[4] = (double)(value >> 9);

	// read output[5]: from bit 122 to 144
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0x80) << 2);
	output[5] = (double)(value >> 9);

	// read output[6]: from bit 145 to 167
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9);
	output[6] = (double)(value >> 9);

	// read output[7]: from bit 168 to 190
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xfe) << 8);
	output[7] = (double)(value >> 9);
}


unpack_func_t unpack_23bit[UNPACK_23BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_23bit_unsigned_0off,
			unpack_1_23bit_signed_0off,
		},
		{
			unpack_1_23bit_unsigned_1off,
			unpack_1_23bit_signed_1off,
		},
		{
			unpack_1_23bit_unsigned_2off,
			unpack_1_23bit_signed_2off,
		},
		{
			unpack_1_23bit_unsigned_3off,
			unpack_1_23bit_signed_3off,
		},
		{
			unpack_1_23bit_unsigned_4off,
			unpack_1_23bit_signed_4off,
		},
		{
			unpack_1_23bit_unsigned_5off,
			unpack_1_23bit_signed_5off,
		},
		{
			unpack_1_23bit_unsigned_6off,
			unpack_1_23bit_signed_6off,
		},
		{
			unpack_1_23bit_unsigned_7off,
			unpack_1_23bit_signed_7off,
		},
	},
	{
		{
			unpack_2_23bit_unsigned_0off,
			unpack_2_23bit_signed_0off,
		},
		{
			unpack_2_23bit_unsigned_1off,
			unpack_2_23bit_signed_1off,
		},
		{
			unpack_2_23bit_unsigned_2off,
			unpack_2_23bit_signed_2off,
		},
		{
			unpack_2_23bit_unsigned_3off,
			unpack_2_23bit_signed_3off,
		},
		{
			unpack_2_23bit_unsigned_4off,
			unpack_2_23bit_signed_4off,
		},
		{
			unpack_2_23bit_unsigned_5off,
			unpack_2_23bit_signed_5off,
		},
		{
			unpack_2_23bit_unsigned_6off,
			unpack_2_23bit_signed_6off,
		},
		{
			unpack_2_23bit_unsigned_7off,
			unpack_2_23bit_signed_7off,
		},
	},
	{
		{
			unpack_3_23bit_unsigned_0off,
			unpack_3_23bit_signed_0off,
		},
		{
			unpack_3_23bit_unsigned_1off,
			unpack_3_23bit_signed_1off,
		},
		{
			unpack_3_23bit_unsigned_2off,
			unpack_3_23bit_signed_2off,
		},
		{
			unpack_3_23bit_unsigned_3off,
			unpack_3_23bit_signed_3off,
		},
		{
			unpack_3_23bit_unsigned_4off,
			unpack_3_23bit_signed_4off,
		},
		{
			unpack_3_23bit_unsigned_5off,
			unpack_3_23bit_signed_5off,
		},
		{
			unpack_3_23bit_unsigned_6off,
			unpack_3_23bit_signed_6off,
		},
		{
			unpack_3_23bit_unsigned_7off,
			unpack_3_23bit_signed_7off,
		},
	},
	{
		{
			unpack_4_23bit_unsigned_0off,
			unpack_4_23bit_signed_0off,
		},
		{
			unpack_4_23bit_unsigned_1off,
			unpack_4_23bit_signed_1off,
		},
		{
			unpack_4_23bit_unsigned_2off,
			unpack_4_23bit_signed_2off,
		},
		{
			unpack_4_23bit_unsigned_3off,
			unpack_4_23bit_signed_3off,
		},
		{
			unpack_4_23bit_unsigned_4off,
			unpack_4_23bit_signed_4off,
		},
		{
			unpack_4_23bit_unsigned_5off,
			unpack_4_23bit_signed_5off,
		},
		{
			unpack_4_23bit_unsigned_6off,
			unpack_4_23bit_signed_6off,
		},
		{
			unpack_4_23bit_unsigned_7off,
			unpack_4_23bit_signed_7off,
		},
	},
	{
		{
			unpack_5_23bit_unsigned_0off,
			unpack_5_23bit_signed_0off,
		},
		{
			unpack_5_23bit_unsigned_1off,
			unpack_5_23bit_signed_1off,
		},
		{
			unpack_5_23bit_unsigned_2off,
			unpack_5_23bit_signed_2off,
		},
		{
			unpack_5_23bit_unsigned_3off,
			unpack_5_23bit_signed_3off,
		},
		{
			unpack_5_23bit_unsigned_4off,
			unpack_5_23bit_signed_4off,
		},
		{
			unpack_5_23bit_unsigned_5off,
			unpack_5_23bit_signed_5off,
		},
		{
			unpack_5_23bit_unsigned_6off,
			unpack_5_23bit_signed_6off,
		},
		{
			unpack_5_23bit_unsigned_7off,
			unpack_5_23bit_signed_7off,
		},
	},
	{
		{
			unpack_6_23bit_unsigned_0off,
			unpack_6_23bit_signed_0off,
		},
		{
			unpack_6_23bit_unsigned_1off,
			unpack_6_23bit_signed_1off,
		},
		{
			unpack_6_23bit_unsigned_2off,
			unpack_6_23bit_signed_2off,
		},
		{
			unpack_6_23bit_unsigned_3off,
			unpack_6_23bit_signed_3off,
		},
		{
			unpack_6_23bit_unsigned_4off,
			unpack_6_23bit_signed_4off,
		},
		{
			unpack_6_23bit_unsigned_5off,
			unpack_6_23bit_signed_5off,
		},
		{
			unpack_6_23bit_unsigned_6off,
			unpack_6_23bit_signed_6off,
		},
		{
			unpack_6_23bit_unsigned_7off,
			unpack_6_23bit_signed_7off,
		},
	},
	{
		{
			unpack_7_23bit_unsigned_0off,
			unpack_7_23bit_signed_0off,
		},
		{
			unpack_7_23bit_unsigned_1off,
			unpack_7_23bit_signed_1off,
		},
		{
			unpack_7_23bit_unsigned_2off,
			unpack_7_23bit_signed_2off,
		},
		{
			unpack_7_23bit_unsigned_3off,
			unpack_7_23bit_signed_3off,
		},
		{
			unpack_7_23bit_unsigned_4off,
			unpack_7_23bit_signed_4off,
		},
		{
			unpack_7_23bit_unsigned_5off,
			unpack_7_23bit_signed_5off,
		},
		{
			unpack_7_23bit_unsigned_6off,
			unpack_7_23bit_signed_6off,
		},
		{
			unpack_7_23bit_unsigned_7off,
			unpack_7_23bit_signed_7off,
		},
	},
	{
		{
			unpack_8_23bit_unsigned_0off,
			unpack_8_23bit_signed_0off,
		},
		{
			unpack_8_23bit_unsigned_1off,
			unpack_8_23bit_signed_1off,
		},
		{
			unpack_8_23bit_unsigned_2off,
			unpack_8_23bit_signed_2off,
		},
		{
			unpack_8_23bit_unsigned_3off,
			unpack_8_23bit_signed_3off,
		},
		{
			unpack_8_23bit_unsigned_4off,
			unpack_8_23bit_signed_4off,
		},
		{
			unpack_8_23bit_unsigned_5off,
			unpack_8_23bit_signed_5off,
		},
		{
			unpack_8_23bit_unsigned_6off,
			unpack_8_23bit_signed_6off,
		},
		{
			unpack_8_23bit_unsigned_7off,
			unpack_8_23bit_signed_7off,
		},
	},
};
