// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack24.h"



static void unpack_1_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 24 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 24 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);
}

static void unpack_1_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);
}

static void unpack_2_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 48 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 48 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);
}

static void unpack_2_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);
}

static void unpack_3_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 72 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 72 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);
}

static void unpack_3_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);
}

static void unpack_4_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 96 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 96 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);
}

static void unpack_4_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);
}

static void unpack_5_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 120 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 120 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);
}

static void unpack_5_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);
}

static void unpack_6_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 144 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 144 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);
}

static void unpack_6_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);
}

static void unpack_7_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 168 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 168 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);
}

static void unpack_7_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);
}

static void unpack_8_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 192 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 192 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);
}

static void unpack_8_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);
}

static void unpack_9_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 216 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 216 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);
}

static void unpack_9_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);
}

static void unpack_10_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 240 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 240 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);
}

static void unpack_10_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);
}

static void unpack_11_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 264 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 264 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);
}

static void unpack_11_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);
}

static void unpack_12_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 288 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 288 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);
}

static void unpack_12_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);
}

static void unpack_13_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 312 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 312 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);
}

static void unpack_13_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);
}

static void unpack_14_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 336 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 336 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);
}

static void unpack_14_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);
}

static void unpack_15_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 360 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 360 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);
}

static void unpack_15_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);
}

static void unpack_16_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 384 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 384 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 367 to 390
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xfe) << 7);
	output[15] = (double)(value >> 8);
}

static void unpack_16_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 367 to 390
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xfe) << 7);
	output[15] = (double)(value >> 8);
}

static void unpack_17_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 408 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 384 to 407
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 408 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 384 to 407
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 385 to 408
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)(input[51] & 0x80) << 1);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 385 to 408
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)(input[51] & 0x80) << 1);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 386 to 409
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)(input[51] & 0xc0) << 2);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 386 to 409
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)(input[51] & 0xc0) << 2);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 387 to 410
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)(input[51] & 0xe0) << 3);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 387 to 410
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)(input[51] & 0xe0) << 3);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 388 to 411
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)(input[51] & 0xf0) << 4);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 388 to 411
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)(input[51] & 0xf0) << 4);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 389 to 412
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)(input[51] & 0xf8) << 5);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 389 to 412
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)(input[51] & 0xf8) << 5);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 390 to 413
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)(input[51] & 0xfc) << 6);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 390 to 413
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)(input[51] & 0xfc) << 6);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 367 to 390
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xfe) << 7);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 391 to 414
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)(input[51] & 0xfe) << 7);
	output[16] = (double)(value >> 8);
}

static void unpack_17_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 408 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 367 to 390
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xfe) << 7);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 391 to 414
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)(input[51] & 0xfe) << 7);
	output[16] = (double)(value >> 8);
}

static void unpack_18_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 432 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 384 to 407
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 408 to 431
	value = ((uint32_t)input[51] << 24) |
			((uint32_t)input[52] << 16) |
			((uint32_t)input[53] << 8);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 432 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 384 to 407
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 408 to 431
	value = ((uint32_t)input[51] << 24) |
			((uint32_t)input[52] << 16) |
			((uint32_t)input[53] << 8);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 385 to 408
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)(input[51] & 0x80) << 1);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 409 to 432
	value = ((uint32_t)(input[51] & 0x7f) << 25) |
			((uint32_t)input[52] << 17) |
			((uint32_t)input[53] << 9) |
			((uint32_t)(input[54] & 0x80) << 1);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 385 to 408
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)(input[51] & 0x80) << 1);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 409 to 432
	value = ((uint32_t)(input[51] & 0x7f) << 25) |
			((uint32_t)input[52] << 17) |
			((uint32_t)input[53] << 9) |
			((uint32_t)(input[54] & 0x80) << 1);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 386 to 409
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)(input[51] & 0xc0) << 2);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 410 to 433
	value = ((uint32_t)(input[51] & 0x3f) << 26) |
			((uint32_t)input[52] << 18) |
			((uint32_t)input[53] << 10) |
			((uint32_t)(input[54] & 0xc0) << 2);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 386 to 409
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)(input[51] & 0xc0) << 2);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 410 to 433
	value = ((uint32_t)(input[51] & 0x3f) << 26) |
			((uint32_t)input[52] << 18) |
			((uint32_t)input[53] << 10) |
			((uint32_t)(input[54] & 0xc0) << 2);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 387 to 410
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)(input[51] & 0xe0) << 3);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 411 to 434
	value = ((uint32_t)(input[51] & 0x1f) << 27) |
			((uint32_t)input[52] << 19) |
			((uint32_t)input[53] << 11) |
			((uint32_t)(input[54] & 0xe0) << 3);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 387 to 410
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)(input[51] & 0xe0) << 3);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 411 to 434
	value = ((uint32_t)(input[51] & 0x1f) << 27) |
			((uint32_t)input[52] << 19) |
			((uint32_t)input[53] << 11) |
			((uint32_t)(input[54] & 0xe0) << 3);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 388 to 411
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)(input[51] & 0xf0) << 4);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 412 to 435
	value = ((uint32_t)(input[51] & 0x0f) << 28) |
			((uint32_t)input[52] << 20) |
			((uint32_t)input[53] << 12) |
			((uint32_t)(input[54] & 0xf0) << 4);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 388 to 411
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)(input[51] & 0xf0) << 4);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 412 to 435
	value = ((uint32_t)(input[51] & 0x0f) << 28) |
			((uint32_t)input[52] << 20) |
			((uint32_t)input[53] << 12) |
			((uint32_t)(input[54] & 0xf0) << 4);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 389 to 412
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)(input[51] & 0xf8) << 5);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 413 to 436
	value = ((uint32_t)(input[51] & 0x07) << 29) |
			((uint32_t)input[52] << 21) |
			((uint32_t)input[53] << 13) |
			((uint32_t)(input[54] & 0xf8) << 5);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 389 to 412
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)(input[51] & 0xf8) << 5);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 413 to 436
	value = ((uint32_t)(input[51] & 0x07) << 29) |
			((uint32_t)input[52] << 21) |
			((uint32_t)input[53] << 13) |
			((uint32_t)(input[54] & 0xf8) << 5);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 390 to 413
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)(input[51] & 0xfc) << 6);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 414 to 437
	value = ((uint32_t)(input[51] & 0x03) << 30) |
			((uint32_t)input[52] << 22) |
			((uint32_t)input[53] << 14) |
			((uint32_t)(input[54] & 0xfc) << 6);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 390 to 413
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)(input[51] & 0xfc) << 6);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 414 to 437
	value = ((uint32_t)(input[51] & 0x03) << 30) |
			((uint32_t)input[52] << 22) |
			((uint32_t)input[53] << 14) |
			((uint32_t)(input[54] & 0xfc) << 6);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 367 to 390
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xfe) << 7);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 391 to 414
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)(input[51] & 0xfe) << 7);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 415 to 438
	value = ((uint32_t)(input[51] & 0x01) << 31) |
			((uint32_t)input[52] << 23) |
			((uint32_t)input[53] << 15) |
			((uint32_t)(input[54] & 0xfe) << 7);
	output[17] = (double)(value >> 8);
}

static void unpack_18_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 432 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 367 to 390
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xfe) << 7);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 391 to 414
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)(input[51] & 0xfe) << 7);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 415 to 438
	value = ((uint32_t)(input[51] & 0x01) << 31) |
			((uint32_t)input[52] << 23) |
			((uint32_t)input[53] << 15) |
			((uint32_t)(input[54] & 0xfe) << 7);
	output[17] = (double)(value >> 8);
}

static void unpack_19_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 456 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 384 to 407
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 408 to 431
	value = ((uint32_t)input[51] << 24) |
			((uint32_t)input[52] << 16) |
			((uint32_t)input[53] << 8);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 432 to 455
	value = ((uint32_t)input[54] << 24) |
			((uint32_t)input[55] << 16) |
			((uint32_t)input[56] << 8);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 456 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 384 to 407
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 408 to 431
	value = ((uint32_t)input[51] << 24) |
			((uint32_t)input[52] << 16) |
			((uint32_t)input[53] << 8);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 432 to 455
	value = ((uint32_t)input[54] << 24) |
			((uint32_t)input[55] << 16) |
			((uint32_t)input[56] << 8);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 385 to 408
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)(input[51] & 0x80) << 1);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 409 to 432
	value = ((uint32_t)(input[51] & 0x7f) << 25) |
			((uint32_t)input[52] << 17) |
			((uint32_t)input[53] << 9) |
			((uint32_t)(input[54] & 0x80) << 1);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 433 to 456
	value = ((uint32_t)(input[54] & 0x7f) << 25) |
			((uint32_t)input[55] << 17) |
			((uint32_t)input[56] << 9) |
			((uint32_t)(input[57] & 0x80) << 1);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 385 to 408
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)(input[51] & 0x80) << 1);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 409 to 432
	value = ((uint32_t)(input[51] & 0x7f) << 25) |
			((uint32_t)input[52] << 17) |
			((uint32_t)input[53] << 9) |
			((uint32_t)(input[54] & 0x80) << 1);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 433 to 456
	value = ((uint32_t)(input[54] & 0x7f) << 25) |
			((uint32_t)input[55] << 17) |
			((uint32_t)input[56] << 9) |
			((uint32_t)(input[57] & 0x80) << 1);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 386 to 409
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)(input[51] & 0xc0) << 2);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 410 to 433
	value = ((uint32_t)(input[51] & 0x3f) << 26) |
			((uint32_t)input[52] << 18) |
			((uint32_t)input[53] << 10) |
			((uint32_t)(input[54] & 0xc0) << 2);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 434 to 457
	value = ((uint32_t)(input[54] & 0x3f) << 26) |
			((uint32_t)input[55] << 18) |
			((uint32_t)input[56] << 10) |
			((uint32_t)(input[57] & 0xc0) << 2);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 386 to 409
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)(input[51] & 0xc0) << 2);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 410 to 433
	value = ((uint32_t)(input[51] & 0x3f) << 26) |
			((uint32_t)input[52] << 18) |
			((uint32_t)input[53] << 10) |
			((uint32_t)(input[54] & 0xc0) << 2);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 434 to 457
	value = ((uint32_t)(input[54] & 0x3f) << 26) |
			((uint32_t)input[55] << 18) |
			((uint32_t)input[56] << 10) |
			((uint32_t)(input[57] & 0xc0) << 2);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 387 to 410
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)(input[51] & 0xe0) << 3);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 411 to 434
	value = ((uint32_t)(input[51] & 0x1f) << 27) |
			((uint32_t)input[52] << 19) |
			((uint32_t)input[53] << 11) |
			((uint32_t)(input[54] & 0xe0) << 3);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 435 to 458
	value = ((uint32_t)(input[54] & 0x1f) << 27) |
			((uint32_t)input[55] << 19) |
			((uint32_t)input[56] << 11) |
			((uint32_t)(input[57] & 0xe0) << 3);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 387 to 410
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)(input[51] & 0xe0) << 3);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 411 to 434
	value = ((uint32_t)(input[51] & 0x1f) << 27) |
			((uint32_t)input[52] << 19) |
			((uint32_t)input[53] << 11) |
			((uint32_t)(input[54] & 0xe0) << 3);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 435 to 458
	value = ((uint32_t)(input[54] & 0x1f) << 27) |
			((uint32_t)input[55] << 19) |
			((uint32_t)input[56] << 11) |
			((uint32_t)(input[57] & 0xe0) << 3);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 388 to 411
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)(input[51] & 0xf0) << 4);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 412 to 435
	value = ((uint32_t)(input[51] & 0x0f) << 28) |
			((uint32_t)input[52] << 20) |
			((uint32_t)input[53] << 12) |
			((uint32_t)(input[54] & 0xf0) << 4);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 436 to 459
	value = ((uint32_t)(input[54] & 0x0f) << 28) |
			((uint32_t)input[55] << 20) |
			((uint32_t)input[56] << 12) |
			((uint32_t)(input[57] & 0xf0) << 4);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 388 to 411
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)(input[51] & 0xf0) << 4);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 412 to 435
	value = ((uint32_t)(input[51] & 0x0f) << 28) |
			((uint32_t)input[52] << 20) |
			((uint32_t)input[53] << 12) |
			((uint32_t)(input[54] & 0xf0) << 4);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 436 to 459
	value = ((uint32_t)(input[54] & 0x0f) << 28) |
			((uint32_t)input[55] << 20) |
			((uint32_t)input[56] << 12) |
			((uint32_t)(input[57] & 0xf0) << 4);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 389 to 412
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)(input[51] & 0xf8) << 5);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 413 to 436
	value = ((uint32_t)(input[51] & 0x07) << 29) |
			((uint32_t)input[52] << 21) |
			((uint32_t)input[53] << 13) |
			((uint32_t)(input[54] & 0xf8) << 5);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 437 to 460
	value = ((uint32_t)(input[54] & 0x07) << 29) |
			((uint32_t)input[55] << 21) |
			((uint32_t)input[56] << 13) |
			((uint32_t)(input[57] & 0xf8) << 5);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 389 to 412
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)(input[51] & 0xf8) << 5);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 413 to 436
	value = ((uint32_t)(input[51] & 0x07) << 29) |
			((uint32_t)input[52] << 21) |
			((uint32_t)input[53] << 13) |
			((uint32_t)(input[54] & 0xf8) << 5);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 437 to 460
	value = ((uint32_t)(input[54] & 0x07) << 29) |
			((uint32_t)input[55] << 21) |
			((uint32_t)input[56] << 13) |
			((uint32_t)(input[57] & 0xf8) << 5);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 390 to 413
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)(input[51] & 0xfc) << 6);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 414 to 437
	value = ((uint32_t)(input[51] & 0x03) << 30) |
			((uint32_t)input[52] << 22) |
			((uint32_t)input[53] << 14) |
			((uint32_t)(input[54] & 0xfc) << 6);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 438 to 461
	value = ((uint32_t)(input[54] & 0x03) << 30) |
			((uint32_t)input[55] << 22) |
			((uint32_t)input[56] << 14) |
			((uint32_t)(input[57] & 0xfc) << 6);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 390 to 413
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)(input[51] & 0xfc) << 6);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 414 to 437
	value = ((uint32_t)(input[51] & 0x03) << 30) |
			((uint32_t)input[52] << 22) |
			((uint32_t)input[53] << 14) |
			((uint32_t)(input[54] & 0xfc) << 6);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 438 to 461
	value = ((uint32_t)(input[54] & 0x03) << 30) |
			((uint32_t)input[55] << 22) |
			((uint32_t)input[56] << 14) |
			((uint32_t)(input[57] & 0xfc) << 6);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 367 to 390
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xfe) << 7);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 391 to 414
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)(input[51] & 0xfe) << 7);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 415 to 438
	value = ((uint32_t)(input[51] & 0x01) << 31) |
			((uint32_t)input[52] << 23) |
			((uint32_t)input[53] << 15) |
			((uint32_t)(input[54] & 0xfe) << 7);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 439 to 462
	value = ((uint32_t)(input[54] & 0x01) << 31) |
			((uint32_t)input[55] << 23) |
			((uint32_t)input[56] << 15) |
			((uint32_t)(input[57] & 0xfe) << 7);
	output[18] = (double)(value >> 8);
}

static void unpack_19_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 456 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 367 to 390
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xfe) << 7);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 391 to 414
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)(input[51] & 0xfe) << 7);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 415 to 438
	value = ((uint32_t)(input[51] & 0x01) << 31) |
			((uint32_t)input[52] << 23) |
			((uint32_t)input[53] << 15) |
			((uint32_t)(input[54] & 0xfe) << 7);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 439 to 462
	value = ((uint32_t)(input[54] & 0x01) << 31) |
			((uint32_t)input[55] << 23) |
			((uint32_t)input[56] << 15) |
			((uint32_t)(input[57] & 0xfe) << 7);
	output[18] = (double)(value >> 8);
}

static void unpack_20_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 480 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 384 to 407
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 408 to 431
	value = ((uint32_t)input[51] << 24) |
			((uint32_t)input[52] << 16) |
			((uint32_t)input[53] << 8);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 432 to 455
	value = ((uint32_t)input[54] << 24) |
			((uint32_t)input[55] << 16) |
			((uint32_t)input[56] << 8);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 456 to 479
	value = ((uint32_t)input[57] << 24) |
			((uint32_t)input[58] << 16) |
			((uint32_t)input[59] << 8);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 480 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 384 to 407
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 408 to 431
	value = ((uint32_t)input[51] << 24) |
			((uint32_t)input[52] << 16) |
			((uint32_t)input[53] << 8);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 432 to 455
	value = ((uint32_t)input[54] << 24) |
			((uint32_t)input[55] << 16) |
			((uint32_t)input[56] << 8);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 456 to 479
	value = ((uint32_t)input[57] << 24) |
			((uint32_t)input[58] << 16) |
			((uint32_t)input[59] << 8);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 385 to 408
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)(input[51] & 0x80) << 1);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 409 to 432
	value = ((uint32_t)(input[51] & 0x7f) << 25) |
			((uint32_t)input[52] << 17) |
			((uint32_t)input[53] << 9) |
			((uint32_t)(input[54] & 0x80) << 1);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 433 to 456
	value = ((uint32_t)(input[54] & 0x7f) << 25) |
			((uint32_t)input[55] << 17) |
			((uint32_t)input[56] << 9) |
			((uint32_t)(input[57] & 0x80) << 1);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 457 to 480
	value = ((uint32_t)(input[57] & 0x7f) << 25) |
			((uint32_t)input[58] << 17) |
			((uint32_t)input[59] << 9) |
			((uint32_t)(input[60] & 0x80) << 1);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 385 to 408
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)(input[51] & 0x80) << 1);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 409 to 432
	value = ((uint32_t)(input[51] & 0x7f) << 25) |
			((uint32_t)input[52] << 17) |
			((uint32_t)input[53] << 9) |
			((uint32_t)(input[54] & 0x80) << 1);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 433 to 456
	value = ((uint32_t)(input[54] & 0x7f) << 25) |
			((uint32_t)input[55] << 17) |
			((uint32_t)input[56] << 9) |
			((uint32_t)(input[57] & 0x80) << 1);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 457 to 480
	value = ((uint32_t)(input[57] & 0x7f) << 25) |
			((uint32_t)input[58] << 17) |
			((uint32_t)input[59] << 9) |
			((uint32_t)(input[60] & 0x80) << 1);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 386 to 409
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)(input[51] & 0xc0) << 2);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 410 to 433
	value = ((uint32_t)(input[51] & 0x3f) << 26) |
			((uint32_t)input[52] << 18) |
			((uint32_t)input[53] << 10) |
			((uint32_t)(input[54] & 0xc0) << 2);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 434 to 457
	value = ((uint32_t)(input[54] & 0x3f) << 26) |
			((uint32_t)input[55] << 18) |
			((uint32_t)input[56] << 10) |
			((uint32_t)(input[57] & 0xc0) << 2);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 458 to 481
	value = ((uint32_t)(input[57] & 0x3f) << 26) |
			((uint32_t)input[58] << 18) |
			((uint32_t)input[59] << 10) |
			((uint32_t)(input[60] & 0xc0) << 2);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 386 to 409
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)(input[51] & 0xc0) << 2);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 410 to 433
	value = ((uint32_t)(input[51] & 0x3f) << 26) |
			((uint32_t)input[52] << 18) |
			((uint32_t)input[53] << 10) |
			((uint32_t)(input[54] & 0xc0) << 2);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 434 to 457
	value = ((uint32_t)(input[54] & 0x3f) << 26) |
			((uint32_t)input[55] << 18) |
			((uint32_t)input[56] << 10) |
			((uint32_t)(input[57] & 0xc0) << 2);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 458 to 481
	value = ((uint32_t)(input[57] & 0x3f) << 26) |
			((uint32_t)input[58] << 18) |
			((uint32_t)input[59] << 10) |
			((uint32_t)(input[60] & 0xc0) << 2);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 387 to 410
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)(input[51] & 0xe0) << 3);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 411 to 434
	value = ((uint32_t)(input[51] & 0x1f) << 27) |
			((uint32_t)input[52] << 19) |
			((uint32_t)input[53] << 11) |
			((uint32_t)(input[54] & 0xe0) << 3);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 435 to 458
	value = ((uint32_t)(input[54] & 0x1f) << 27) |
			((uint32_t)input[55] << 19) |
			((uint32_t)input[56] << 11) |
			((uint32_t)(input[57] & 0xe0) << 3);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 459 to 482
	value = ((uint32_t)(input[57] & 0x1f) << 27) |
			((uint32_t)input[58] << 19) |
			((uint32_t)input[59] << 11) |
			((uint32_t)(input[60] & 0xe0) << 3);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 387 to 410
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)(input[51] & 0xe0) << 3);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 411 to 434
	value = ((uint32_t)(input[51] & 0x1f) << 27) |
			((uint32_t)input[52] << 19) |
			((uint32_t)input[53] << 11) |
			((uint32_t)(input[54] & 0xe0) << 3);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 435 to 458
	value = ((uint32_t)(input[54] & 0x1f) << 27) |
			((uint32_t)input[55] << 19) |
			((uint32_t)input[56] << 11) |
			((uint32_t)(input[57] & 0xe0) << 3);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 459 to 482
	value = ((uint32_t)(input[57] & 0x1f) << 27) |
			((uint32_t)input[58] << 19) |
			((uint32_t)input[59] << 11) |
			((uint32_t)(input[60] & 0xe0) << 3);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 388 to 411
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)(input[51] & 0xf0) << 4);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 412 to 435
	value = ((uint32_t)(input[51] & 0x0f) << 28) |
			((uint32_t)input[52] << 20) |
			((uint32_t)input[53] << 12) |
			((uint32_t)(input[54] & 0xf0) << 4);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 436 to 459
	value = ((uint32_t)(input[54] & 0x0f) << 28) |
			((uint32_t)input[55] << 20) |
			((uint32_t)input[56] << 12) |
			((uint32_t)(input[57] & 0xf0) << 4);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 460 to 483
	value = ((uint32_t)(input[57] & 0x0f) << 28) |
			((uint32_t)input[58] << 20) |
			((uint32_t)input[59] << 12) |
			((uint32_t)(input[60] & 0xf0) << 4);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 388 to 411
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)(input[51] & 0xf0) << 4);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 412 to 435
	value = ((uint32_t)(input[51] & 0x0f) << 28) |
			((uint32_t)input[52] << 20) |
			((uint32_t)input[53] << 12) |
			((uint32_t)(input[54] & 0xf0) << 4);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 436 to 459
	value = ((uint32_t)(input[54] & 0x0f) << 28) |
			((uint32_t)input[55] << 20) |
			((uint32_t)input[56] << 12) |
			((uint32_t)(input[57] & 0xf0) << 4);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 460 to 483
	value = ((uint32_t)(input[57] & 0x0f) << 28) |
			((uint32_t)input[58] << 20) |
			((uint32_t)input[59] << 12) |
			((uint32_t)(input[60] & 0xf0) << 4);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 389 to 412
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)(input[51] & 0xf8) << 5);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 413 to 436
	value = ((uint32_t)(input[51] & 0x07) << 29) |
			((uint32_t)input[52] << 21) |
			((uint32_t)input[53] << 13) |
			((uint32_t)(input[54] & 0xf8) << 5);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 437 to 460
	value = ((uint32_t)(input[54] & 0x07) << 29) |
			((uint32_t)input[55] << 21) |
			((uint32_t)input[56] << 13) |
			((uint32_t)(input[57] & 0xf8) << 5);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 461 to 484
	value = ((uint32_t)(input[57] & 0x07) << 29) |
			((uint32_t)input[58] << 21) |
			((uint32_t)input[59] << 13) |
			((uint32_t)(input[60] & 0xf8) << 5);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 389 to 412
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)(input[51] & 0xf8) << 5);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 413 to 436
	value = ((uint32_t)(input[51] & 0x07) << 29) |
			((uint32_t)input[52] << 21) |
			((uint32_t)input[53] << 13) |
			((uint32_t)(input[54] & 0xf8) << 5);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 437 to 460
	value = ((uint32_t)(input[54] & 0x07) << 29) |
			((uint32_t)input[55] << 21) |
			((uint32_t)input[56] << 13) |
			((uint32_t)(input[57] & 0xf8) << 5);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 461 to 484
	value = ((uint32_t)(input[57] & 0x07) << 29) |
			((uint32_t)input[58] << 21) |
			((uint32_t)input[59] << 13) |
			((uint32_t)(input[60] & 0xf8) << 5);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 390 to 413
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)(input[51] & 0xfc) << 6);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 414 to 437
	value = ((uint32_t)(input[51] & 0x03) << 30) |
			((uint32_t)input[52] << 22) |
			((uint32_t)input[53] << 14) |
			((uint32_t)(input[54] & 0xfc) << 6);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 438 to 461
	value = ((uint32_t)(input[54] & 0x03) << 30) |
			((uint32_t)input[55] << 22) |
			((uint32_t)input[56] << 14) |
			((uint32_t)(input[57] & 0xfc) << 6);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 462 to 485
	value = ((uint32_t)(input[57] & 0x03) << 30) |
			((uint32_t)input[58] << 22) |
			((uint32_t)input[59] << 14) |
			((uint32_t)(input[60] & 0xfc) << 6);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 390 to 413
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)(input[51] & 0xfc) << 6);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 414 to 437
	value = ((uint32_t)(input[51] & 0x03) << 30) |
			((uint32_t)input[52] << 22) |
			((uint32_t)input[53] << 14) |
			((uint32_t)(input[54] & 0xfc) << 6);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 438 to 461
	value = ((uint32_t)(input[54] & 0x03) << 30) |
			((uint32_t)input[55] << 22) |
			((uint32_t)input[56] << 14) |
			((uint32_t)(input[57] & 0xfc) << 6);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 462 to 485
	value = ((uint32_t)(input[57] & 0x03) << 30) |
			((uint32_t)input[58] << 22) |
			((uint32_t)input[59] << 14) |
			((uint32_t)(input[60] & 0xfc) << 6);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 367 to 390
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xfe) << 7);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 391 to 414
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)(input[51] & 0xfe) << 7);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 415 to 438
	value = ((uint32_t)(input[51] & 0x01) << 31) |
			((uint32_t)input[52] << 23) |
			((uint32_t)input[53] << 15) |
			((uint32_t)(input[54] & 0xfe) << 7);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 439 to 462
	value = ((uint32_t)(input[54] & 0x01) << 31) |
			((uint32_t)input[55] << 23) |
			((uint32_t)input[56] << 15) |
			((uint32_t)(input[57] & 0xfe) << 7);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 463 to 486
	value = ((uint32_t)(input[57] & 0x01) << 31) |
			((uint32_t)input[58] << 23) |
			((uint32_t)input[59] << 15) |
			((uint32_t)(input[60] & 0xfe) << 7);
	output[19] = (double)(value >> 8);
}

static void unpack_20_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 367 to 390
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xfe) << 7);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 391 to 414
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)(input[51] & 0xfe) << 7);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 415 to 438
	value = ((uint32_t)(input[51] & 0x01) << 31) |
			((uint32_t)input[52] << 23) |
			((uint32_t)input[53] << 15) |
			((uint32_t)(input[54] & 0xfe) << 7);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 439 to 462
	value = ((uint32_t)(input[54] & 0x01) << 31) |
			((uint32_t)input[55] << 23) |
			((uint32_t)input[56] << 15) |
			((uint32_t)(input[57] & 0xfe) << 7);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 463 to 486
	value = ((uint32_t)(input[57] & 0x01) << 31) |
			((uint32_t)input[58] << 23) |
			((uint32_t)input[59] << 15) |
			((uint32_t)(input[60] & 0xfe) << 7);
	output[19] = (double)(value >> 8);
}

static void unpack_21_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 504 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 384 to 407
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 408 to 431
	value = ((uint32_t)input[51] << 24) |
			((uint32_t)input[52] << 16) |
			((uint32_t)input[53] << 8);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 432 to 455
	value = ((uint32_t)input[54] << 24) |
			((uint32_t)input[55] << 16) |
			((uint32_t)input[56] << 8);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 456 to 479
	value = ((uint32_t)input[57] << 24) |
			((uint32_t)input[58] << 16) |
			((uint32_t)input[59] << 8);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 480 to 503
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 504 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 384 to 407
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 408 to 431
	value = ((uint32_t)input[51] << 24) |
			((uint32_t)input[52] << 16) |
			((uint32_t)input[53] << 8);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 432 to 455
	value = ((uint32_t)input[54] << 24) |
			((uint32_t)input[55] << 16) |
			((uint32_t)input[56] << 8);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 456 to 479
	value = ((uint32_t)input[57] << 24) |
			((uint32_t)input[58] << 16) |
			((uint32_t)input[59] << 8);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 480 to 503
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 385 to 408
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)(input[51] & 0x80) << 1);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 409 to 432
	value = ((uint32_t)(input[51] & 0x7f) << 25) |
			((uint32_t)input[52] << 17) |
			((uint32_t)input[53] << 9) |
			((uint32_t)(input[54] & 0x80) << 1);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 433 to 456
	value = ((uint32_t)(input[54] & 0x7f) << 25) |
			((uint32_t)input[55] << 17) |
			((uint32_t)input[56] << 9) |
			((uint32_t)(input[57] & 0x80) << 1);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 457 to 480
	value = ((uint32_t)(input[57] & 0x7f) << 25) |
			((uint32_t)input[58] << 17) |
			((uint32_t)input[59] << 9) |
			((uint32_t)(input[60] & 0x80) << 1);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 481 to 504
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)(input[63] & 0x80) << 1);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 385 to 408
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)(input[51] & 0x80) << 1);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 409 to 432
	value = ((uint32_t)(input[51] & 0x7f) << 25) |
			((uint32_t)input[52] << 17) |
			((uint32_t)input[53] << 9) |
			((uint32_t)(input[54] & 0x80) << 1);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 433 to 456
	value = ((uint32_t)(input[54] & 0x7f) << 25) |
			((uint32_t)input[55] << 17) |
			((uint32_t)input[56] << 9) |
			((uint32_t)(input[57] & 0x80) << 1);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 457 to 480
	value = ((uint32_t)(input[57] & 0x7f) << 25) |
			((uint32_t)input[58] << 17) |
			((uint32_t)input[59] << 9) |
			((uint32_t)(input[60] & 0x80) << 1);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 481 to 504
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)(input[63] & 0x80) << 1);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 386 to 409
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)(input[51] & 0xc0) << 2);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 410 to 433
	value = ((uint32_t)(input[51] & 0x3f) << 26) |
			((uint32_t)input[52] << 18) |
			((uint32_t)input[53] << 10) |
			((uint32_t)(input[54] & 0xc0) << 2);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 434 to 457
	value = ((uint32_t)(input[54] & 0x3f) << 26) |
			((uint32_t)input[55] << 18) |
			((uint32_t)input[56] << 10) |
			((uint32_t)(input[57] & 0xc0) << 2);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 458 to 481
	value = ((uint32_t)(input[57] & 0x3f) << 26) |
			((uint32_t)input[58] << 18) |
			((uint32_t)input[59] << 10) |
			((uint32_t)(input[60] & 0xc0) << 2);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 482 to 505
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)(input[63] & 0xc0) << 2);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 386 to 409
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)(input[51] & 0xc0) << 2);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 410 to 433
	value = ((uint32_t)(input[51] & 0x3f) << 26) |
			((uint32_t)input[52] << 18) |
			((uint32_t)input[53] << 10) |
			((uint32_t)(input[54] & 0xc0) << 2);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 434 to 457
	value = ((uint32_t)(input[54] & 0x3f) << 26) |
			((uint32_t)input[55] << 18) |
			((uint32_t)input[56] << 10) |
			((uint32_t)(input[57] & 0xc0) << 2);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 458 to 481
	value = ((uint32_t)(input[57] & 0x3f) << 26) |
			((uint32_t)input[58] << 18) |
			((uint32_t)input[59] << 10) |
			((uint32_t)(input[60] & 0xc0) << 2);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 482 to 505
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)(input[63] & 0xc0) << 2);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 387 to 410
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)(input[51] & 0xe0) << 3);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 411 to 434
	value = ((uint32_t)(input[51] & 0x1f) << 27) |
			((uint32_t)input[52] << 19) |
			((uint32_t)input[53] << 11) |
			((uint32_t)(input[54] & 0xe0) << 3);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 435 to 458
	value = ((uint32_t)(input[54] & 0x1f) << 27) |
			((uint32_t)input[55] << 19) |
			((uint32_t)input[56] << 11) |
			((uint32_t)(input[57] & 0xe0) << 3);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 459 to 482
	value = ((uint32_t)(input[57] & 0x1f) << 27) |
			((uint32_t)input[58] << 19) |
			((uint32_t)input[59] << 11) |
			((uint32_t)(input[60] & 0xe0) << 3);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 483 to 506
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)(input[63] & 0xe0) << 3);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 387 to 410
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)(input[51] & 0xe0) << 3);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 411 to 434
	value = ((uint32_t)(input[51] & 0x1f) << 27) |
			((uint32_t)input[52] << 19) |
			((uint32_t)input[53] << 11) |
			((uint32_t)(input[54] & 0xe0) << 3);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 435 to 458
	value = ((uint32_t)(input[54] & 0x1f) << 27) |
			((uint32_t)input[55] << 19) |
			((uint32_t)input[56] << 11) |
			((uint32_t)(input[57] & 0xe0) << 3);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 459 to 482
	value = ((uint32_t)(input[57] & 0x1f) << 27) |
			((uint32_t)input[58] << 19) |
			((uint32_t)input[59] << 11) |
			((uint32_t)(input[60] & 0xe0) << 3);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 483 to 506
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)(input[63] & 0xe0) << 3);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 388 to 411
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)(input[51] & 0xf0) << 4);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 412 to 435
	value = ((uint32_t)(input[51] & 0x0f) << 28) |
			((uint32_t)input[52] << 20) |
			((uint32_t)input[53] << 12) |
			((uint32_t)(input[54] & 0xf0) << 4);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 436 to 459
	value = ((uint32_t)(input[54] & 0x0f) << 28) |
			((uint32_t)input[55] << 20) |
			((uint32_t)input[56] << 12) |
			((uint32_t)(input[57] & 0xf0) << 4);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 460 to 483
	value = ((uint32_t)(input[57] & 0x0f) << 28) |
			((uint32_t)input[58] << 20) |
			((uint32_t)input[59] << 12) |
			((uint32_t)(input[60] & 0xf0) << 4);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 484 to 507
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)(input[63] & 0xf0) << 4);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 388 to 411
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)(input[51] & 0xf0) << 4);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 412 to 435
	value = ((uint32_t)(input[51] & 0x0f) << 28) |
			((uint32_t)input[52] << 20) |
			((uint32_t)input[53] << 12) |
			((uint32_t)(input[54] & 0xf0) << 4);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 436 to 459
	value = ((uint32_t)(input[54] & 0x0f) << 28) |
			((uint32_t)input[55] << 20) |
			((uint32_t)input[56] << 12) |
			((uint32_t)(input[57] & 0xf0) << 4);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 460 to 483
	value = ((uint32_t)(input[57] & 0x0f) << 28) |
			((uint32_t)input[58] << 20) |
			((uint32_t)input[59] << 12) |
			((uint32_t)(input[60] & 0xf0) << 4);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 484 to 507
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)(input[63] & 0xf0) << 4);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 389 to 412
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)(input[51] & 0xf8) << 5);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 413 to 436
	value = ((uint32_t)(input[51] & 0x07) << 29) |
			((uint32_t)input[52] << 21) |
			((uint32_t)input[53] << 13) |
			((uint32_t)(input[54] & 0xf8) << 5);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 437 to 460
	value = ((uint32_t)(input[54] & 0x07) << 29) |
			((uint32_t)input[55] << 21) |
			((uint32_t)input[56] << 13) |
			((uint32_t)(input[57] & 0xf8) << 5);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 461 to 484
	value = ((uint32_t)(input[57] & 0x07) << 29) |
			((uint32_t)input[58] << 21) |
			((uint32_t)input[59] << 13) |
			((uint32_t)(input[60] & 0xf8) << 5);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 485 to 508
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)(input[63] & 0xf8) << 5);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 389 to 412
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)(input[51] & 0xf8) << 5);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 413 to 436
	value = ((uint32_t)(input[51] & 0x07) << 29) |
			((uint32_t)input[52] << 21) |
			((uint32_t)input[53] << 13) |
			((uint32_t)(input[54] & 0xf8) << 5);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 437 to 460
	value = ((uint32_t)(input[54] & 0x07) << 29) |
			((uint32_t)input[55] << 21) |
			((uint32_t)input[56] << 13) |
			((uint32_t)(input[57] & 0xf8) << 5);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 461 to 484
	value = ((uint32_t)(input[57] & 0x07) << 29) |
			((uint32_t)input[58] << 21) |
			((uint32_t)input[59] << 13) |
			((uint32_t)(input[60] & 0xf8) << 5);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 485 to 508
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)(input[63] & 0xf8) << 5);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 390 to 413
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)(input[51] & 0xfc) << 6);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 414 to 437
	value = ((uint32_t)(input[51] & 0x03) << 30) |
			((uint32_t)input[52] << 22) |
			((uint32_t)input[53] << 14) |
			((uint32_t)(input[54] & 0xfc) << 6);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 438 to 461
	value = ((uint32_t)(input[54] & 0x03) << 30) |
			((uint32_t)input[55] << 22) |
			((uint32_t)input[56] << 14) |
			((uint32_t)(input[57] & 0xfc) << 6);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 462 to 485
	value = ((uint32_t)(input[57] & 0x03) << 30) |
			((uint32_t)input[58] << 22) |
			((uint32_t)input[59] << 14) |
			((uint32_t)(input[60] & 0xfc) << 6);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 486 to 509
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)(input[63] & 0xfc) << 6);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 390 to 413
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)(input[51] & 0xfc) << 6);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 414 to 437
	value = ((uint32_t)(input[51] & 0x03) << 30) |
			((uint32_t)input[52] << 22) |
			((uint32_t)input[53] << 14) |
			((uint32_t)(input[54] & 0xfc) << 6);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 438 to 461
	value = ((uint32_t)(input[54] & 0x03) << 30) |
			((uint32_t)input[55] << 22) |
			((uint32_t)input[56] << 14) |
			((uint32_t)(input[57] & 0xfc) << 6);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 462 to 485
	value = ((uint32_t)(input[57] & 0x03) << 30) |
			((uint32_t)input[58] << 22) |
			((uint32_t)input[59] << 14) |
			((uint32_t)(input[60] & 0xfc) << 6);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 486 to 509
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)(input[63] & 0xfc) << 6);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit signed
	// Skip 7 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 367 to 390
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xfe) << 7);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 391 to 414
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)(input[51] & 0xfe) << 7);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 415 to 438
	value = ((uint32_t)(input[51] & 0x01) << 31) |
			((uint32_t)input[52] << 23) |
			((uint32_t)input[53] << 15) |
			((uint32_t)(input[54] & 0xfe) << 7);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 439 to 462
	value = ((uint32_t)(input[54] & 0x01) << 31) |
			((uint32_t)input[55] << 23) |
			((uint32_t)input[56] << 15) |
			((uint32_t)(input[57] & 0xfe) << 7);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 463 to 486
	value = ((uint32_t)(input[57] & 0x01) << 31) |
			((uint32_t)input[58] << 23) |
			((uint32_t)input[59] << 15) |
			((uint32_t)(input[60] & 0xfe) << 7);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 487 to 510
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)(input[63] & 0xfe) << 7);
	output[20] = (double)(value >> 8);
}

static void unpack_21_24bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 24-bit unsigned
	// Skip 7 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 30
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xfe) << 7);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 31 to 54
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)(input[6] & 0xfe) << 7);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 55 to 78
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0xfe) << 7);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 79 to 102
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xfe) << 7);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 103 to 126
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xfe) << 7);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 127 to 150
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xfe) << 7);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 151 to 174
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xfe) << 7);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 175 to 198
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)(input[24] & 0xfe) << 7);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 199 to 222
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xfe) << 7);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 223 to 246
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xfe) << 7);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 247 to 270
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xfe) << 7);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 271 to 294
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xfe) << 7);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 295 to 318
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0xfe) << 7);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 319 to 342
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)(input[42] & 0xfe) << 7);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 343 to 366
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xfe) << 7);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 367 to 390
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xfe) << 7);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 391 to 414
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)(input[51] & 0xfe) << 7);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 415 to 438
	value = ((uint32_t)(input[51] & 0x01) << 31) |
			((uint32_t)input[52] << 23) |
			((uint32_t)input[53] << 15) |
			((uint32_t)(input[54] & 0xfe) << 7);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 439 to 462
	value = ((uint32_t)(input[54] & 0x01) << 31) |
			((uint32_t)input[55] << 23) |
			((uint32_t)input[56] << 15) |
			((uint32_t)(input[57] & 0xfe) << 7);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 463 to 486
	value = ((uint32_t)(input[57] & 0x01) << 31) |
			((uint32_t)input[58] << 23) |
			((uint32_t)input[59] << 15) |
			((uint32_t)(input[60] & 0xfe) << 7);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 487 to 510
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)(input[63] & 0xfe) << 7);
	output[20] = (double)(value >> 8);
}

static void unpack_22_24bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit signed
	// Skip 0 bits, read 528 bits of data.
	// Input must be at least 66 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 384 to 407
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 408 to 431
	value = ((uint32_t)input[51] << 24) |
			((uint32_t)input[52] << 16) |
			((uint32_t)input[53] << 8);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 432 to 455
	value = ((uint32_t)input[54] << 24) |
			((uint32_t)input[55] << 16) |
			((uint32_t)input[56] << 8);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 456 to 479
	value = ((uint32_t)input[57] << 24) |
			((uint32_t)input[58] << 16) |
			((uint32_t)input[59] << 8);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 480 to 503
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8);
	output[20] = (double)(value >> 8);

	// read output[21]: from bit 504 to 527
	value = ((uint32_t)input[63] << 24) |
			((uint32_t)input[64] << 16) |
			((uint32_t)input[65] << 8);
	output[21] = (double)(value >> 8);
}

static void unpack_22_24bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit unsigned
	// Skip 0 bits, read 528 bits of data.
	// Input must be at least 66 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 23
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 24 to 47
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)input[5] << 8);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 48 to 71
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)input[8] << 8);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 72 to 95
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)input[11] << 8);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 96 to 119
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 120 to 143
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 144 to 167
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 168 to 191
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 192 to 215
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 216 to 239
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 240 to 263
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 264 to 287
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 288 to 311
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 312 to 335
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 336 to 359
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 360 to 383
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 384 to 407
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 408 to 431
	value = ((uint32_t)input[51] << 24) |
			((uint32_t)input[52] << 16) |
			((uint32_t)input[53] << 8);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 432 to 455
	value = ((uint32_t)input[54] << 24) |
			((uint32_t)input[55] << 16) |
			((uint32_t)input[56] << 8);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 456 to 479
	value = ((uint32_t)input[57] << 24) |
			((uint32_t)input[58] << 16) |
			((uint32_t)input[59] << 8);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 480 to 503
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8);
	output[20] = (double)(value >> 8);

	// read output[21]: from bit 504 to 527
	value = ((uint32_t)input[63] << 24) |
			((uint32_t)input[64] << 16) |
			((uint32_t)input[65] << 8);
	output[21] = (double)(value >> 8);
}

static void unpack_22_24bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit signed
	// Skip 1 bits, read 528 bits of data.
	// Input must be at least 67 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 385 to 408
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)(input[51] & 0x80) << 1);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 409 to 432
	value = ((uint32_t)(input[51] & 0x7f) << 25) |
			((uint32_t)input[52] << 17) |
			((uint32_t)input[53] << 9) |
			((uint32_t)(input[54] & 0x80) << 1);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 433 to 456
	value = ((uint32_t)(input[54] & 0x7f) << 25) |
			((uint32_t)input[55] << 17) |
			((uint32_t)input[56] << 9) |
			((uint32_t)(input[57] & 0x80) << 1);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 457 to 480
	value = ((uint32_t)(input[57] & 0x7f) << 25) |
			((uint32_t)input[58] << 17) |
			((uint32_t)input[59] << 9) |
			((uint32_t)(input[60] & 0x80) << 1);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 481 to 504
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)(input[63] & 0x80) << 1);
	output[20] = (double)(value >> 8);

	// read output[21]: from bit 505 to 528
	value = ((uint32_t)(input[63] & 0x7f) << 25) |
			((uint32_t)input[64] << 17) |
			((uint32_t)input[65] << 9) |
			((uint32_t)(input[66] & 0x80) << 1);
	output[21] = (double)(value >> 8);
}

static void unpack_22_24bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit unsigned
	// Skip 1 bits, read 528 bits of data.
	// Input must be at least 67 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 24
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0x80) << 1);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 25 to 48
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0x80) << 1);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 49 to 72
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)input[8] << 9) |
			((uint32_t)(input[9] & 0x80) << 1);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 73 to 96
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)input[11] << 9) |
			((uint32_t)(input[12] & 0x80) << 1);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 97 to 120
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0x80) << 1);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 121 to 144
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0x80) << 1);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 145 to 168
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0x80) << 1);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 169 to 192
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0x80) << 1);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 193 to 216
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0x80) << 1);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 217 to 240
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0x80) << 1);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 241 to 264
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0x80) << 1);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 265 to 288
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0x80) << 1);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 289 to 312
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0x80) << 1);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 313 to 336
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0x80) << 1);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 337 to 360
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0x80) << 1);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 361 to 384
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0x80) << 1);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 385 to 408
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)(input[51] & 0x80) << 1);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 409 to 432
	value = ((uint32_t)(input[51] & 0x7f) << 25) |
			((uint32_t)input[52] << 17) |
			((uint32_t)input[53] << 9) |
			((uint32_t)(input[54] & 0x80) << 1);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 433 to 456
	value = ((uint32_t)(input[54] & 0x7f) << 25) |
			((uint32_t)input[55] << 17) |
			((uint32_t)input[56] << 9) |
			((uint32_t)(input[57] & 0x80) << 1);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 457 to 480
	value = ((uint32_t)(input[57] & 0x7f) << 25) |
			((uint32_t)input[58] << 17) |
			((uint32_t)input[59] << 9) |
			((uint32_t)(input[60] & 0x80) << 1);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 481 to 504
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)(input[63] & 0x80) << 1);
	output[20] = (double)(value >> 8);

	// read output[21]: from bit 505 to 528
	value = ((uint32_t)(input[63] & 0x7f) << 25) |
			((uint32_t)input[64] << 17) |
			((uint32_t)input[65] << 9) |
			((uint32_t)(input[66] & 0x80) << 1);
	output[21] = (double)(value >> 8);
}

static void unpack_22_24bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit signed
	// Skip 2 bits, read 528 bits of data.
	// Input must be at least 67 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 386 to 409
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)(input[51] & 0xc0) << 2);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 410 to 433
	value = ((uint32_t)(input[51] & 0x3f) << 26) |
			((uint32_t)input[52] << 18) |
			((uint32_t)input[53] << 10) |
			((uint32_t)(input[54] & 0xc0) << 2);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 434 to 457
	value = ((uint32_t)(input[54] & 0x3f) << 26) |
			((uint32_t)input[55] << 18) |
			((uint32_t)input[56] << 10) |
			((uint32_t)(input[57] & 0xc0) << 2);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 458 to 481
	value = ((uint32_t)(input[57] & 0x3f) << 26) |
			((uint32_t)input[58] << 18) |
			((uint32_t)input[59] << 10) |
			((uint32_t)(input[60] & 0xc0) << 2);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 482 to 505
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)(input[63] & 0xc0) << 2);
	output[20] = (double)(value >> 8);

	// read output[21]: from bit 506 to 529
	value = ((uint32_t)(input[63] & 0x3f) << 26) |
			((uint32_t)input[64] << 18) |
			((uint32_t)input[65] << 10) |
			((uint32_t)(input[66] & 0xc0) << 2);
	output[21] = (double)(value >> 8);
}

static void unpack_22_24bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit unsigned
	// Skip 2 bits, read 528 bits of data.
	// Input must be at least 67 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 25
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xc0) << 2);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 26 to 49
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xc0) << 2);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 50 to 73
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xc0) << 2);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 74 to 97
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)input[11] << 10) |
			((uint32_t)(input[12] & 0xc0) << 2);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 98 to 121
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)(input[15] & 0xc0) << 2);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 122 to 145
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xc0) << 2);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 146 to 169
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xc0) << 2);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 170 to 193
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xc0) << 2);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 194 to 217
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xc0) << 2);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 218 to 241
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)(input[30] & 0xc0) << 2);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 242 to 265
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)(input[33] & 0xc0) << 2);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 266 to 289
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xc0) << 2);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 290 to 313
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xc0) << 2);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 314 to 337
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xc0) << 2);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 338 to 361
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xc0) << 2);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 362 to 385
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)(input[48] & 0xc0) << 2);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 386 to 409
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)(input[51] & 0xc0) << 2);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 410 to 433
	value = ((uint32_t)(input[51] & 0x3f) << 26) |
			((uint32_t)input[52] << 18) |
			((uint32_t)input[53] << 10) |
			((uint32_t)(input[54] & 0xc0) << 2);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 434 to 457
	value = ((uint32_t)(input[54] & 0x3f) << 26) |
			((uint32_t)input[55] << 18) |
			((uint32_t)input[56] << 10) |
			((uint32_t)(input[57] & 0xc0) << 2);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 458 to 481
	value = ((uint32_t)(input[57] & 0x3f) << 26) |
			((uint32_t)input[58] << 18) |
			((uint32_t)input[59] << 10) |
			((uint32_t)(input[60] & 0xc0) << 2);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 482 to 505
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)(input[63] & 0xc0) << 2);
	output[20] = (double)(value >> 8);

	// read output[21]: from bit 506 to 529
	value = ((uint32_t)(input[63] & 0x3f) << 26) |
			((uint32_t)input[64] << 18) |
			((uint32_t)input[65] << 10) |
			((uint32_t)(input[66] & 0xc0) << 2);
	output[21] = (double)(value >> 8);
}

static void unpack_22_24bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit signed
	// Skip 3 bits, read 528 bits of data.
	// Input must be at least 67 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 387 to 410
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)(input[51] & 0xe0) << 3);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 411 to 434
	value = ((uint32_t)(input[51] & 0x1f) << 27) |
			((uint32_t)input[52] << 19) |
			((uint32_t)input[53] << 11) |
			((uint32_t)(input[54] & 0xe0) << 3);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 435 to 458
	value = ((uint32_t)(input[54] & 0x1f) << 27) |
			((uint32_t)input[55] << 19) |
			((uint32_t)input[56] << 11) |
			((uint32_t)(input[57] & 0xe0) << 3);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 459 to 482
	value = ((uint32_t)(input[57] & 0x1f) << 27) |
			((uint32_t)input[58] << 19) |
			((uint32_t)input[59] << 11) |
			((uint32_t)(input[60] & 0xe0) << 3);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 483 to 506
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)(input[63] & 0xe0) << 3);
	output[20] = (double)(value >> 8);

	// read output[21]: from bit 507 to 530
	value = ((uint32_t)(input[63] & 0x1f) << 27) |
			((uint32_t)input[64] << 19) |
			((uint32_t)input[65] << 11) |
			((uint32_t)(input[66] & 0xe0) << 3);
	output[21] = (double)(value >> 8);
}

static void unpack_22_24bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit unsigned
	// Skip 3 bits, read 528 bits of data.
	// Input must be at least 67 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 26
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xe0) << 3);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 27 to 50
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xe0) << 3);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 51 to 74
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xe0) << 3);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 75 to 98
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xe0) << 3);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 99 to 122
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)(input[15] & 0xe0) << 3);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 123 to 146
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)(input[18] & 0xe0) << 3);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 147 to 170
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xe0) << 3);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 171 to 194
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xe0) << 3);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 195 to 218
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xe0) << 3);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 219 to 242
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)(input[30] & 0xe0) << 3);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 243 to 266
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0xe0) << 3);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 267 to 290
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xe0) << 3);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 291 to 314
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xe0) << 3);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 315 to 338
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xe0) << 3);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 339 to 362
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xe0) << 3);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 363 to 386
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)(input[48] & 0xe0) << 3);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 387 to 410
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)(input[51] & 0xe0) << 3);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 411 to 434
	value = ((uint32_t)(input[51] & 0x1f) << 27) |
			((uint32_t)input[52] << 19) |
			((uint32_t)input[53] << 11) |
			((uint32_t)(input[54] & 0xe0) << 3);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 435 to 458
	value = ((uint32_t)(input[54] & 0x1f) << 27) |
			((uint32_t)input[55] << 19) |
			((uint32_t)input[56] << 11) |
			((uint32_t)(input[57] & 0xe0) << 3);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 459 to 482
	value = ((uint32_t)(input[57] & 0x1f) << 27) |
			((uint32_t)input[58] << 19) |
			((uint32_t)input[59] << 11) |
			((uint32_t)(input[60] & 0xe0) << 3);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 483 to 506
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)(input[63] & 0xe0) << 3);
	output[20] = (double)(value >> 8);

	// read output[21]: from bit 507 to 530
	value = ((uint32_t)(input[63] & 0x1f) << 27) |
			((uint32_t)input[64] << 19) |
			((uint32_t)input[65] << 11) |
			((uint32_t)(input[66] & 0xe0) << 3);
	output[21] = (double)(value >> 8);
}

static void unpack_22_24bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit signed
	// Skip 4 bits, read 528 bits of data.
	// Input must be at least 67 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 388 to 411
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)(input[51] & 0xf0) << 4);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 412 to 435
	value = ((uint32_t)(input[51] & 0x0f) << 28) |
			((uint32_t)input[52] << 20) |
			((uint32_t)input[53] << 12) |
			((uint32_t)(input[54] & 0xf0) << 4);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 436 to 459
	value = ((uint32_t)(input[54] & 0x0f) << 28) |
			((uint32_t)input[55] << 20) |
			((uint32_t)input[56] << 12) |
			((uint32_t)(input[57] & 0xf0) << 4);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 460 to 483
	value = ((uint32_t)(input[57] & 0x0f) << 28) |
			((uint32_t)input[58] << 20) |
			((uint32_t)input[59] << 12) |
			((uint32_t)(input[60] & 0xf0) << 4);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 484 to 507
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)(input[63] & 0xf0) << 4);
	output[20] = (double)(value >> 8);

	// read output[21]: from bit 508 to 531
	value = ((uint32_t)(input[63] & 0x0f) << 28) |
			((uint32_t)input[64] << 20) |
			((uint32_t)input[65] << 12) |
			((uint32_t)(input[66] & 0xf0) << 4);
	output[21] = (double)(value >> 8);
}

static void unpack_22_24bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit unsigned
	// Skip 4 bits, read 528 bits of data.
	// Input must be at least 67 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 27
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf0) << 4);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 28 to 51
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf0) << 4);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 52 to 75
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf0) << 4);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 76 to 99
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf0) << 4);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 100 to 123
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf0) << 4);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 124 to 147
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)(input[18] & 0xf0) << 4);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 148 to 171
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0xf0) << 4);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 172 to 195
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)(input[24] & 0xf0) << 4);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 196 to 219
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xf0) << 4);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 220 to 243
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xf0) << 4);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 244 to 267
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xf0) << 4);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 268 to 291
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xf0) << 4);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 292 to 315
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xf0) << 4);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 316 to 339
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xf0) << 4);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 340 to 363
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xf0) << 4);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 364 to 387
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xf0) << 4);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 388 to 411
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)(input[51] & 0xf0) << 4);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 412 to 435
	value = ((uint32_t)(input[51] & 0x0f) << 28) |
			((uint32_t)input[52] << 20) |
			((uint32_t)input[53] << 12) |
			((uint32_t)(input[54] & 0xf0) << 4);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 436 to 459
	value = ((uint32_t)(input[54] & 0x0f) << 28) |
			((uint32_t)input[55] << 20) |
			((uint32_t)input[56] << 12) |
			((uint32_t)(input[57] & 0xf0) << 4);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 460 to 483
	value = ((uint32_t)(input[57] & 0x0f) << 28) |
			((uint32_t)input[58] << 20) |
			((uint32_t)input[59] << 12) |
			((uint32_t)(input[60] & 0xf0) << 4);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 484 to 507
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)(input[63] & 0xf0) << 4);
	output[20] = (double)(value >> 8);

	// read output[21]: from bit 508 to 531
	value = ((uint32_t)(input[63] & 0x0f) << 28) |
			((uint32_t)input[64] << 20) |
			((uint32_t)input[65] << 12) |
			((uint32_t)(input[66] & 0xf0) << 4);
	output[21] = (double)(value >> 8);
}

static void unpack_22_24bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit signed
	// Skip 5 bits, read 528 bits of data.
	// Input must be at least 67 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 389 to 412
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)(input[51] & 0xf8) << 5);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 413 to 436
	value = ((uint32_t)(input[51] & 0x07) << 29) |
			((uint32_t)input[52] << 21) |
			((uint32_t)input[53] << 13) |
			((uint32_t)(input[54] & 0xf8) << 5);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 437 to 460
	value = ((uint32_t)(input[54] & 0x07) << 29) |
			((uint32_t)input[55] << 21) |
			((uint32_t)input[56] << 13) |
			((uint32_t)(input[57] & 0xf8) << 5);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 461 to 484
	value = ((uint32_t)(input[57] & 0x07) << 29) |
			((uint32_t)input[58] << 21) |
			((uint32_t)input[59] << 13) |
			((uint32_t)(input[60] & 0xf8) << 5);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 485 to 508
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)(input[63] & 0xf8) << 5);
	output[20] = (double)(value >> 8);

	// read output[21]: from bit 509 to 532
	value = ((uint32_t)(input[63] & 0x07) << 29) |
			((uint32_t)input[64] << 21) |
			((uint32_t)input[65] << 13) |
			((uint32_t)(input[66] & 0xf8) << 5);
	output[21] = (double)(value >> 8);
}

static void unpack_22_24bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit unsigned
	// Skip 5 bits, read 528 bits of data.
	// Input must be at least 67 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 28
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xf8) << 5);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 29 to 52
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xf8) << 5);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 53 to 76
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xf8) << 5);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 77 to 100
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xf8) << 5);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 101 to 124
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xf8) << 5);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 125 to 148
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xf8) << 5);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 149 to 172
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xf8) << 5);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 173 to 196
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)(input[24] & 0xf8) << 5);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 197 to 220
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)(input[27] & 0xf8) << 5);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 221 to 244
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xf8) << 5);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 245 to 268
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xf8) << 5);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 269 to 292
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xf8) << 5);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 293 to 316
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xf8) << 5);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 317 to 340
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xf8) << 5);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 341 to 364
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xf8) << 5);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 365 to 388
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xf8) << 5);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 389 to 412
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)(input[51] & 0xf8) << 5);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 413 to 436
	value = ((uint32_t)(input[51] & 0x07) << 29) |
			((uint32_t)input[52] << 21) |
			((uint32_t)input[53] << 13) |
			((uint32_t)(input[54] & 0xf8) << 5);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 437 to 460
	value = ((uint32_t)(input[54] & 0x07) << 29) |
			((uint32_t)input[55] << 21) |
			((uint32_t)input[56] << 13) |
			((uint32_t)(input[57] & 0xf8) << 5);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 461 to 484
	value = ((uint32_t)(input[57] & 0x07) << 29) |
			((uint32_t)input[58] << 21) |
			((uint32_t)input[59] << 13) |
			((uint32_t)(input[60] & 0xf8) << 5);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 485 to 508
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)(input[63] & 0xf8) << 5);
	output[20] = (double)(value >> 8);

	// read output[21]: from bit 509 to 532
	value = ((uint32_t)(input[63] & 0x07) << 29) |
			((uint32_t)input[64] << 21) |
			((uint32_t)input[65] << 13) |
			((uint32_t)(input[66] & 0xf8) << 5);
	output[21] = (double)(value >> 8);
}

static void unpack_22_24bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit signed
	// Skip 6 bits, read 528 bits of data.
	// Input must be at least 67 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 390 to 413
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)(input[51] & 0xfc) << 6);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 414 to 437
	value = ((uint32_t)(input[51] & 0x03) << 30) |
			((uint32_t)input[52] << 22) |
			((uint32_t)input[53] << 14) |
			((uint32_t)(input[54] & 0xfc) << 6);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 438 to 461
	value = ((uint32_t)(input[54] & 0x03) << 30) |
			((uint32_t)input[55] << 22) |
			((uint32_t)input[56] << 14) |
			((uint32_t)(input[57] & 0xfc) << 6);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 462 to 485
	value = ((uint32_t)(input[57] & 0x03) << 30) |
			((uint32_t)input[58] << 22) |
			((uint32_t)input[59] << 14) |
			((uint32_t)(input[60] & 0xfc) << 6);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 486 to 509
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)(input[63] & 0xfc) << 6);
	output[20] = (double)(value >> 8);

	// read output[21]: from bit 510 to 533
	value = ((uint32_t)(input[63] & 0x03) << 30) |
			((uint32_t)input[64] << 22) |
			((uint32_t)input[65] << 14) |
			((uint32_t)(input[66] & 0xfc) << 6);
	output[21] = (double)(value >> 8);
}

static void unpack_22_24bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 24-bit unsigned
	// Skip 6 bits, read 528 bits of data.
	// Input must be at least 67 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 29
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfc) << 6);
	output[0] = (double)(value >> 8);

	// read output[1]: from bit 30 to 53
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfc) << 6);
	output[1] = (double)(value >> 8);

	// read output[2]: from bit 54 to 77
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfc) << 6);
	output[2] = (double)(value >> 8);

	// read output[3]: from bit 78 to 101
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfc) << 6);
	output[3] = (double)(value >> 8);

	// read output[4]: from bit 102 to 125
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfc) << 6);
	output[4] = (double)(value >> 8);

	// read output[5]: from bit 126 to 149
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfc) << 6);
	output[5] = (double)(value >> 8);

	// read output[6]: from bit 150 to 173
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfc) << 6);
	output[6] = (double)(value >> 8);

	// read output[7]: from bit 174 to 197
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)(input[24] & 0xfc) << 6);
	output[7] = (double)(value >> 8);

	// read output[8]: from bit 198 to 221
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xfc) << 6);
	output[8] = (double)(value >> 8);

	// read output[9]: from bit 222 to 245
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xfc) << 6);
	output[9] = (double)(value >> 8);

	// read output[10]: from bit 246 to 269
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xfc) << 6);
	output[10] = (double)(value >> 8);

	// read output[11]: from bit 270 to 293
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xfc) << 6);
	output[11] = (double)(value >> 8);

	// read output[12]: from bit 294 to 317
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)(input[39] & 0xfc) << 6);
	output[12] = (double)(value >> 8);

	// read output[13]: from bit 318 to 341
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)(input[42] & 0xfc) << 6);
	output[13] = (double)(value >> 8);

	// read output[14]: from bit 342 to 365
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xfc) << 6);
	output[14] = (double)(value >> 8);

	// read output[15]: from bit 366 to 389
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xfc) << 6);
	output[15] = (double)(value >> 8);

	// read output[16]: from bit 390 to 413
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)(input[51] & 0xfc) << 6);
	output[16] = (double)(value >> 8);

	// read output[17]: from bit 414 to 437
	value = ((uint32_t)(input[51] & 0x03) << 30) |
			((uint32_t)input[52] << 22) |
			((uint32_t)input[53] << 14) |
			((uint32_t)(input[54] & 0xfc) << 6);
	output[17] = (double)(value >> 8);

	// read output[18]: from bit 438 to 461
	value = ((uint32_t)(input[54] & 0x03) << 30) |
			((uint32_t)input[55] << 22) |
			((uint32_t)input[56] << 14) |
			((uint32_t)(input[57] & 0xfc) << 6);
	output[18] = (double)(value >> 8);

	// read output[19]: from bit 462 to 485
	value = ((uint32_t)(input[57] & 0x03) << 30) |
			((uint32_t)input[58] << 22) |
			((uint32_t)input[59] << 14) |
			((uint32_t)(input[60] & 0xfc) << 6);
	output[19] = (double)(value >> 8);

	// read output[20]: from bit 486 to 509
	value = ((uint32_t)(input[60] & 0x03) << 30) |
	