// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack25.h"



static void unpack_1_25bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit signed
	// Skip 0 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit unsigned
	// Skip 0 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit signed
	// Skip 1 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit unsigned
	// Skip 1 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit signed
	// Skip 2 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit unsigned
	// Skip 2 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit signed
	// Skip 3 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit unsigned
	// Skip 3 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit signed
	// Skip 4 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit unsigned
	// Skip 4 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit signed
	// Skip 5 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit unsigned
	// Skip 5 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit signed
	// Skip 6 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit unsigned
	// Skip 6 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit signed
	// Skip 7 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);
}

static void unpack_1_25bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 25-bit unsigned
	// Skip 7 bits, read 25 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);
}

static void unpack_2_25bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit signed
	// Skip 0 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit unsigned
	// Skip 0 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit signed
	// Skip 1 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit unsigned
	// Skip 1 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit signed
	// Skip 2 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit unsigned
	// Skip 2 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit signed
	// Skip 3 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit unsigned
	// Skip 3 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit signed
	// Skip 4 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit unsigned
	// Skip 4 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit signed
	// Skip 5 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit unsigned
	// Skip 5 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit signed
	// Skip 6 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit unsigned
	// Skip 6 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit signed
	// Skip 7 bits, read 50 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);
}

static void unpack_2_25bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 25-bit unsigned
	// Skip 7 bits, read 50 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);
}

static void unpack_3_25bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit signed
	// Skip 0 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 50 to 74
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xe0) << 2);
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit unsigned
	// Skip 0 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 50 to 74
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xe0) << 2);
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit signed
	// Skip 1 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 51 to 75
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xf0) << 3);
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit unsigned
	// Skip 1 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 51 to 75
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xf0) << 3);
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit signed
	// Skip 2 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 52 to 76
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf8) << 4);
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit unsigned
	// Skip 2 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 52 to 76
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf8) << 4);
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit signed
	// Skip 3 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 53 to 77
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfc) << 5);
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit unsigned
	// Skip 3 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 53 to 77
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfc) << 5);
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit signed
	// Skip 4 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 54 to 78
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfe) << 6);
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit unsigned
	// Skip 4 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 54 to 78
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfe) << 6);
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit signed
	// Skip 5 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 55 to 79
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7);
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit unsigned
	// Skip 5 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 55 to 79
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7);
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit signed
	// Skip 6 bits, read 75 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 56 to 80
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0x80));
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit unsigned
	// Skip 6 bits, read 75 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 56 to 80
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0x80));
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit signed
	// Skip 7 bits, read 75 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 57 to 81
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xc0) << 1);
	output[2] = (double)(value >> 7);
}

static void unpack_3_25bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 25-bit unsigned
	// Skip 7 bits, read 75 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 57 to 81
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xc0) << 1);
	output[2] = (double)(value >> 7);
}

static void unpack_4_25bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit signed
	// Skip 0 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 50 to 74
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xe0) << 2);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 75 to 99
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xf0) << 3);
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit unsigned
	// Skip 0 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 50 to 74
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xe0) << 2);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 75 to 99
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xf0) << 3);
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit signed
	// Skip 1 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 51 to 75
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xf0) << 3);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 76 to 100
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf8) << 4);
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit unsigned
	// Skip 1 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 51 to 75
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xf0) << 3);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 76 to 100
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf8) << 4);
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit signed
	// Skip 2 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 52 to 76
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf8) << 4);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 77 to 101
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xfc) << 5);
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit unsigned
	// Skip 2 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 52 to 76
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf8) << 4);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 77 to 101
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xfc) << 5);
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit signed
	// Skip 3 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 53 to 77
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfc) << 5);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 78 to 102
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfe) << 6);
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit unsigned
	// Skip 3 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 53 to 77
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfc) << 5);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 78 to 102
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfe) << 6);
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit signed
	// Skip 4 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 54 to 78
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfe) << 6);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 79 to 103
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7);
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit unsigned
	// Skip 4 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 54 to 78
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfe) << 6);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 79 to 103
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7);
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit signed
	// Skip 5 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 55 to 79
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 80 to 104
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0x80));
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit unsigned
	// Skip 5 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 55 to 79
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 80 to 104
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0x80));
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit signed
	// Skip 6 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 56 to 80
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0x80));
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 81 to 105
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xc0) << 1);
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit unsigned
	// Skip 6 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 56 to 80
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0x80));
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 81 to 105
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xc0) << 1);
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit signed
	// Skip 7 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 57 to 81
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xc0) << 1);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 82 to 106
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xe0) << 2);
	output[3] = (double)(value >> 7);
}

static void unpack_4_25bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 25-bit unsigned
	// Skip 7 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 57 to 81
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xc0) << 1);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 82 to 106
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xe0) << 2);
	output[3] = (double)(value >> 7);
}

static void unpack_5_25bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit signed
	// Skip 0 bits, read 125 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 50 to 74
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xe0) << 2);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 75 to 99
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xf0) << 3);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 100 to 124
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf8) << 4);
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit unsigned
	// Skip 0 bits, read 125 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 50 to 74
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xe0) << 2);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 75 to 99
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xf0) << 3);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 100 to 124
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf8) << 4);
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit signed
	// Skip 1 bits, read 125 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 51 to 75
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xf0) << 3);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 76 to 100
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf8) << 4);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 101 to 125
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xfc) << 5);
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit unsigned
	// Skip 1 bits, read 125 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 51 to 75
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xf0) << 3);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 76 to 100
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf8) << 4);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 101 to 125
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xfc) << 5);
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit signed
	// Skip 2 bits, read 125 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 52 to 76
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf8) << 4);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 77 to 101
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xfc) << 5);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 102 to 126
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfe) << 6);
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit unsigned
	// Skip 2 bits, read 125 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 52 to 76
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf8) << 4);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 77 to 101
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xfc) << 5);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 102 to 126
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfe) << 6);
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit signed
	// Skip 3 bits, read 125 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 53 to 77
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfc) << 5);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 78 to 102
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfe) << 6);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 103 to 127
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7);
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit unsigned
	// Skip 3 bits, read 125 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 53 to 77
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfc) << 5);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 78 to 102
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfe) << 6);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 103 to 127
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7);
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit signed
	// Skip 4 bits, read 125 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 54 to 78
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfe) << 6);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 79 to 103
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 104 to 128
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0x80));
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit unsigned
	// Skip 4 bits, read 125 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 54 to 78
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfe) << 6);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 79 to 103
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 104 to 128
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0x80));
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit signed
	// Skip 5 bits, read 125 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 55 to 79
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 80 to 104
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0x80));
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 105 to 129
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xc0) << 1);
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit unsigned
	// Skip 5 bits, read 125 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 55 to 79
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 80 to 104
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0x80));
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 105 to 129
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xc0) << 1);
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit signed
	// Skip 6 bits, read 125 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 56 to 80
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0x80));
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 81 to 105
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xc0) << 1);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 106 to 130
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xe0) << 2);
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit unsigned
	// Skip 6 bits, read 125 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 56 to 80
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0x80));
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 81 to 105
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xc0) << 1);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 106 to 130
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xe0) << 2);
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit signed
	// Skip 7 bits, read 125 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 57 to 81
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xc0) << 1);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 82 to 106
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xe0) << 2);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 107 to 131
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf0) << 3);
	output[4] = (double)(value >> 7);
}

static void unpack_5_25bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 25-bit unsigned
	// Skip 7 bits, read 125 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 57 to 81
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xc0) << 1);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 82 to 106
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xe0) << 2);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 107 to 131
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf0) << 3);
	output[4] = (double)(value >> 7);
}

static void unpack_6_25bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit signed
	// Skip 0 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 50 to 74
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xe0) << 2);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 75 to 99
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xf0) << 3);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 100 to 124
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf8) << 4);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 125 to 149
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xfc) << 5);
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit unsigned
	// Skip 0 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 50 to 74
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xe0) << 2);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 75 to 99
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xf0) << 3);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 100 to 124
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf8) << 4);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 125 to 149
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xfc) << 5);
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit signed
	// Skip 1 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 51 to 75
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xf0) << 3);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 76 to 100
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf8) << 4);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 101 to 125
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xfc) << 5);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 126 to 150
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfe) << 6);
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit unsigned
	// Skip 1 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 51 to 75
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xf0) << 3);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 76 to 100
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf8) << 4);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 101 to 125
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xfc) << 5);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 126 to 150
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfe) << 6);
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit signed
	// Skip 2 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 52 to 76
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf8) << 4);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 77 to 101
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xfc) << 5);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 102 to 126
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfe) << 6);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 127 to 151
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7);
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit unsigned
	// Skip 2 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 52 to 76
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf8) << 4);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 77 to 101
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xfc) << 5);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 102 to 126
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfe) << 6);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 127 to 151
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7);
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit signed
	// Skip 3 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 53 to 77
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfc) << 5);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 78 to 102
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfe) << 6);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 103 to 127
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 128 to 152
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0x80));
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit unsigned
	// Skip 3 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 53 to 77
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfc) << 5);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 78 to 102
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfe) << 6);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 103 to 127
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 128 to 152
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0x80));
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit signed
	// Skip 4 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 54 to 78
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfe) << 6);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 79 to 103
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 104 to 128
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0x80));
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 129 to 153
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)(input[19] & 0xc0) << 1);
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit unsigned
	// Skip 4 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 54 to 78
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfe) << 6);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 79 to 103
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 104 to 128
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0x80));
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 129 to 153
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)(input[19] & 0xc0) << 1);
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit signed
	// Skip 5 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 55 to 79
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 80 to 104
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0x80));
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 105 to 129
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xc0) << 1);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 130 to 154
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xe0) << 2);
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit unsigned
	// Skip 5 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 55 to 79
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 80 to 104
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0x80));
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 105 to 129
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xc0) << 1);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 130 to 154
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xe0) << 2);
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit signed
	// Skip 6 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 56 to 80
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0x80));
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 81 to 105
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xc0) << 1);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 106 to 130
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xe0) << 2);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 131 to 155
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf0) << 3);
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit unsigned
	// Skip 6 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 56 to 80
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0x80));
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 81 to 105
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xc0) << 1);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 106 to 130
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xe0) << 2);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 131 to 155
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf0) << 3);
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit signed
	// Skip 7 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 57 to 81
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xc0) << 1);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 82 to 106
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xe0) << 2);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 107 to 131
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf0) << 3);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 132 to 156
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xf8) << 4);
	output[5] = (double)(value >> 7);
}

static void unpack_6_25bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 25-bit unsigned
	// Skip 7 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 57 to 81
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xc0) << 1);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 82 to 106
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xe0) << 2);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 107 to 131
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf0) << 3);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 132 to 156
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xf8) << 4);
	output[5] = (double)(value >> 7);
}

static void unpack_7_25bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit signed
	// Skip 0 bits, read 175 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 50 to 74
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xe0) << 2);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 75 to 99
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xf0) << 3);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 100 to 124
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf8) << 4);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 125 to 149
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xfc) << 5);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 150 to 174
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfe) << 6);
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit unsigned
	// Skip 0 bits, read 175 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 50 to 74
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xe0) << 2);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 75 to 99
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xf0) << 3);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 100 to 124
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf8) << 4);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 125 to 149
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xfc) << 5);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 150 to 174
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfe) << 6);
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit signed
	// Skip 1 bits, read 175 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 51 to 75
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xf0) << 3);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 76 to 100
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf8) << 4);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 101 to 125
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xfc) << 5);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 126 to 150
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfe) << 6);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 151 to 175
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7);
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit unsigned
	// Skip 1 bits, read 175 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 51 to 75
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xf0) << 3);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 76 to 100
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf8) << 4);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 101 to 125
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xfc) << 5);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 126 to 150
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfe) << 6);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 151 to 175
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7);
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit signed
	// Skip 2 bits, read 175 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 52 to 76
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf8) << 4);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 77 to 101
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xfc) << 5);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 102 to 126
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfe) << 6);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 127 to 151
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 152 to 176
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0x80));
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit unsigned
	// Skip 2 bits, read 175 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 52 to 76
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf8) << 4);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 77 to 101
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xfc) << 5);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 102 to 126
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfe) << 6);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 127 to 151
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 152 to 176
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0x80));
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit signed
	// Skip 3 bits, read 175 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 53 to 77
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfc) << 5);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 78 to 102
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfe) << 6);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 103 to 127
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 128 to 152
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0x80));
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 153 to 177
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xc0) << 1);
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit unsigned
	// Skip 3 bits, read 175 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 53 to 77
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfc) << 5);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 78 to 102
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfe) << 6);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 103 to 127
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 128 to 152
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0x80));
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 153 to 177
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xc0) << 1);
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit signed
	// Skip 4 bits, read 175 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 54 to 78
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfe) << 6);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 79 to 103
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 104 to 128
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0x80));
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 129 to 153
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)(input[19] & 0xc0) << 1);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 154 to 178
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)(input[22] & 0xe0) << 2);
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit unsigned
	// Skip 4 bits, read 175 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 54 to 78
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfe) << 6);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 79 to 103
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 104 to 128
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0x80));
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 129 to 153
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)(input[19] & 0xc0) << 1);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 154 to 178
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)(input[22] & 0xe0) << 2);
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit signed
	// Skip 5 bits, read 175 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 55 to 79
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 80 to 104
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0x80));
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 105 to 129
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xc0) << 1);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 130 to 154
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xe0) << 2);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 155 to 179
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0xf0) << 3);
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit unsigned
	// Skip 5 bits, read 175 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 55 to 79
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 80 to 104
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0x80));
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 105 to 129
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xc0) << 1);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 130 to 154
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xe0) << 2);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 155 to 179
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0xf0) << 3);
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit signed
	// Skip 6 bits, read 175 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 56 to 80
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0x80));
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 81 to 105
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xc0) << 1);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 106 to 130
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xe0) << 2);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 131 to 155
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf0) << 3);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 156 to 180
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xf8) << 4);
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit unsigned
	// Skip 6 bits, read 175 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 56 to 80
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0x80));
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 81 to 105
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xc0) << 1);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 106 to 130
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xe0) << 2);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 131 to 155
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf0) << 3);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 156 to 180
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xf8) << 4);
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit signed
	// Skip 7 bits, read 175 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 57 to 81
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xc0) << 1);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 82 to 106
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xe0) << 2);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 107 to 131
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf0) << 3);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 132 to 156
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xf8) << 4);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 157 to 181
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfc) << 5);
	output[6] = (double)(value >> 7);
}

static void unpack_7_25bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 25-bit unsigned
	// Skip 7 bits, read 175 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 57 to 81
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xc0) << 1);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 82 to 106
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xe0) << 2);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 107 to 131
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf0) << 3);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 132 to 156
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xf8) << 4);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 157 to 181
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfc) << 5);
	output[6] = (double)(value >> 7);
}

static void unpack_8_25bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit signed
	// Skip 0 bits, read 200 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 50 to 74
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xe0) << 2);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 75 to 99
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xf0) << 3);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 100 to 124
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf8) << 4);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 125 to 149
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xfc) << 5);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 150 to 174
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfe) << 6);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 175 to 199
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7);
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit unsigned
	// Skip 0 bits, read 200 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 24
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0x80));
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 25 to 49
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)input[5] << 9) |
			((uint32_t)(input[6] & 0xc0) << 1);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 50 to 74
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10) |
			((uint32_t)(input[9] & 0xe0) << 2);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 75 to 99
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)input[11] << 11) |
			((uint32_t)(input[12] & 0xf0) << 3);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 100 to 124
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)(input[15] & 0xf8) << 4);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 125 to 149
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0xfc) << 5);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 150 to 174
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xfe) << 6);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 175 to 199
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7);
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit signed
	// Skip 1 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 51 to 75
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xf0) << 3);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 76 to 100
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf8) << 4);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 101 to 125
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xfc) << 5);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 126 to 150
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfe) << 6);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 151 to 175
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 176 to 200
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)input[24] << 8) |
			((uint32_t)(input[25] & 0x80));
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit unsigned
	// Skip 1 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 25
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xc0) << 1);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 26 to 50
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xe0) << 2);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 51 to 75
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0xf0) << 3);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 76 to 100
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)input[11] << 12) |
			((uint32_t)(input[12] & 0xf8) << 4);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 101 to 125
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0xfc) << 5);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 126 to 150
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xfe) << 6);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 151 to 175
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 176 to 200
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)input[24] << 8) |
			((uint32_t)(input[25] & 0x80));
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit signed
	// Skip 2 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 52 to 76
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf8) << 4);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 77 to 101
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xfc) << 5);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 102 to 126
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfe) << 6);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 127 to 151
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 152 to 176
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0x80));
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 177 to 201
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)input[24] << 9) |
			((uint32_t)(input[25] & 0xc0) << 1);
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit unsigned
	// Skip 2 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 26
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xe0) << 2);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 27 to 51
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf0) << 3);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 52 to 76
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xf8) << 4);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 77 to 101
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13) |
			((uint32_t)(input[12] & 0xfc) << 5);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 102 to 126
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xfe) << 6);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 127 to 151
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 152 to 176
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0x80));
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 177 to 201
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)input[24] << 9) |
			((uint32_t)(input[25] & 0xc0) << 1);
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit signed
	// Skip 3 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 53 to 77
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfc) << 5);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 78 to 102
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfe) << 6);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 103 to 127
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 128 to 152
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0x80));
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 153 to 177
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xc0) << 1);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 178 to 202
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10) |
			((uint32_t)(input[25] & 0xe0) << 2);
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit unsigned
	// Skip 3 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 27
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf0) << 3);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 28 to 52
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xf8) << 4);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 53 to 77
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfc) << 5);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 78 to 102
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0xfe) << 6);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 103 to 127
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 128 to 152
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0x80));
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 153 to 177
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xc0) << 1);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 178 to 202
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10) |
			((uint32_t)(input[25] & 0xe0) << 2);
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit signed
	// Skip 4 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 54 to 78
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfe) << 6);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 79 to 103
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 104 to 128
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0x80));
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 129 to 153
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)(input[19] & 0xc0) << 1);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 154 to 178
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)(input[22] & 0xe0) << 2);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 179 to 203
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0xf0) << 3);
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit unsigned
	// Skip 4 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 28
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xf8) << 4);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 29 to 53
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfc) << 5);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 54 to 78
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)(input[9] & 0xfe) << 6);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 79 to 103
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 104 to 128
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0x80));
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 129 to 153
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)(input[19] & 0xc0) << 1);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 154 to 178
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)(input[22] & 0xe0) << 2);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 179 to 203
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0xf0) << 3);
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit signed
	// Skip 5 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 55 to 79
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 80 to 104
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0x80));
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 105 to 129
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xc0) << 1);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 130 to 154
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xe0) << 2);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 155 to 179
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0xf0) << 3);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 180 to 204
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xf8) << 4);
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit unsigned
	// Skip 5 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 29
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfc) << 5);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 30 to 54
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)(input[6] & 0xfe) << 6);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 55 to 79
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 80 to 104
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0x80));
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 105 to 129
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xc0) << 1);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 130 to 154
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xe0) << 2);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 155 to 179
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0xf0) << 3);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 180 to 204
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xf8) << 4);
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit signed
	// Skip 6 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 56 to 80
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0x80));
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 81 to 105
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xc0) << 1);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 106 to 130
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xe0) << 2);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 131 to 155
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf0) << 3);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 156 to 180
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xf8) << 4);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 181 to 205
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xfc) << 5);
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit unsigned
	// Skip 6 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 30
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xfe) << 6);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 31 to 55
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7);
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 56 to 80
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0x80));
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 81 to 105
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xc0) << 1);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 106 to 130
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xe0) << 2);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 131 to 155
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf0) << 3);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 156 to 180
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xf8) << 4);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 181 to 205
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xfc) << 5);
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit signed
	// Skip 7 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 57 to 81
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xc0) << 1);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 82 to 106
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xe0) << 2);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 107 to 131
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf0) << 3);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 132 to 156
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xf8) << 4);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 157 to 181
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfc) << 5);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 182 to 206
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xfe) << 6);
	output[7] = (double)(value >> 7);
}

static void unpack_8_25bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 25-bit unsigned
	// Skip 7 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 31
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7);
	output[0] = (double)(value >> 7);

	// read output[1]: from bit 32 to 56
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0x80));
	output[1] = (double)(value >> 7);

	// read output[2]: from bit 57 to 81
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xc0) << 1);
	output[2] = (double)(value >> 7);

	// read output[3]: from bit 82 to 106
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xe0) << 2);
	output[3] = (double)(value >> 7);

	// read output[4]: from bit 107 to 131
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf0) << 3);
	output[4] = (double)(value >> 7);

	// read output[5]: from bit 132 to 156
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xf8) << 4);
	output[5] = (double)(value >> 7);

	// read output[6]: from bit 157 to 181
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfc) << 5);
	output[6] = (double)(value >> 7);

	// read output[7]: from bit 182 to 206
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xfe) << 6);
	output[7] = (double)(value >> 7);
}


unpack_func_t unpack_25bit[UNPACK_25BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_25bit_unsigned_0off,
			unpack_1_25bit_signed_0off,
		},
		{
			unpack_1_25bit_unsigned_1off,
			unpack_1_25bit_signed_1off,
		},
		{
			unpack_1_25bit_unsigned_2off,
			unpack_1_25bit_signed_2off,
		},
		{
			unpack_1_25bit_unsigned_3off,
			unpack_1_25bit_signed_3off,
		},
		{
			unpack_1_25bit_unsigned_4off,
			unpack_1_25bit_signed_4off,
		},
		{
			unpack_1_25bit_unsigned_5off,
			unpack_1_25bit_signed_5off,
		},
		{
			unpack_1_25bit_unsigned_6off,
			unpack_1_25bit_signed_6off,
		},
		{
			unpack_1_25bit_unsigned_7off,
			unpack_1_25bit_signed_7off,
		},
	},
	{
		{
			unpack_2_25bit_unsigned_0off,
			unpack_2_25bit_signed_0off,
		},
		{
			unpack_2_25bit_unsigned_1off,
			unpack_2_25bit_signed_1off,
		},
		{
			unpack_2_25bit_unsigned_2off,
			unpack_2_25bit_signed_2off,
		},
		{
			unpack_2_25bit_unsigned_3off,
			unpack_2_25bit_signed_3off,
		},
		{
			unpack_2_25bit_unsigned_4off,
			unpack_2_25bit_signed_4off,
		},
		{
			unpack_2_25bit_unsigned_5off,
			unpack_2_25bit_signed_5off,
		},
		{
			unpack_2_25bit_unsigned_6off,
			unpack_2_25bit_signed_6off,
		},
		{
			unpack_2_25bit_unsigned_7off,
			unpack_2_25bit_signed_7off,
		},
	},
	{
		{
			unpack_3_25bit_unsigned_0off,
			unpack_3_25bit_signed_0off,
		},
		{
			unpack_3_25bit_unsigned_1off,
			unpack_3_25bit_signed_1off,
		},
		{
			unpack_3_25bit_unsigned_2off,
			unpack_3_25bit_signed_2off,
		},
		{
			unpack_3_25bit_unsigned_3off,
			unpack_3_25bit_signed_3off,
		},
		{
			unpack_3_25bit_unsigned_4off,
			unpack_3_25bit_signed_4off,
		},
		{
			unpack_3_25bit_unsigned_5off,
			unpack_3_25bit_signed_5off,
		},
		{
			unpack_3_25bit_unsigned_6off,
			unpack_3_25bit_signed_6off,
		},
		{
			unpack_3_25bit_unsigned_7off,
			unpack_3_25bit_signed_7off,
		},
	},
	{
		{
			unpack_4_25bit_unsigned_0off,
			unpack_4_25bit_signed_0off,
		},
		{
			unpack_4_25bit_unsigned_1off,
			unpack_4_25bit_signed_1off,
		},
		{
			unpack_4_25bit_unsigned_2off,
			unpack_4_25bit_signed_2off,
		},
		{
			unpack_4_25bit_unsigned_3off,
			unpack_4_25bit_signed_3off,
		},
		{
			unpack_4_25bit_unsigned_4off,
			unpack_4_25bit_signed_4off,
		},
		{
			unpack_4_25bit_unsigned_5off,
			unpack_4_25bit_signed_5off,
		},
		{
			unpack_4_25bit_unsigned_6off,
			unpack_4_25bit_signed_6off,
		},
		{
			unpack_4_25bit_unsigned_7off,
			unpack_4_25bit_signed_7off,
		},
	},
	{
		{
			unpack_5_25bit_unsigned_0off,
			unpack_5_25bit_signed_0off,
		},
		{
			unpack_5_25bit_unsigned_1off,
			unpack_5_25bit_signed_1off,
		},
		{
			unpack_5_25bit_unsigned_2off,
			unpack_5_25bit_signed_2off,
		},
		{
			unpack_5_25bit_unsigned_3off,
			unpack_5_25bit_signed_3off,
		},
		{
			unpack_5_25bit_unsigned_4off,
			unpack_5_25bit_signed_4off,
		},
		{
			unpack_5_25bit_unsigned_5off,
			unpack_5_25bit_signed_5off,
		},
		{
			unpack_5_25bit_unsigned_6off,
			unpack_5_25bit_signed_6off,
		},
		{
			unpack_5_25bit_unsigned_7off,
			unpack_5_25bit_signed_7off,
		},
	},
	{
		{
			unpack_6_25bit_unsigned_0off,
			unpack_6_25bit_signed_0off,
		},
		{
			unpack_6_25bit_unsigned_1off,
			unpack_6_25bit_signed_1off,
		},
		{
			unpack_6_25bit_unsigned_2off,
			unpack_6_25bit_signed_2off,
		},
		{
			unpack_6_25bit_unsigned_3off,
			unpack_6_25bit_signed_3off,
		},
		{
			unpack_6_25bit_unsigned_4off,
			unpack_6_25bit_signed_4off,
		},
		{
			unpack_6_25bit_unsigned_5off,
			unpack_6_25bit_signed_5off,
		},
		{
			unpack_6_25bit_unsigned_6off,
			unpack_6_25bit_signed_6off,
		},
		{
			unpack_6_25bit_unsigned_7off,
			unpack_6_25bit_signed_7off,
		},
	},
	{
		{
			unpack_7_25bit_unsigned_0off,
			unpack_7_25bit_signed_0off,
		},
		{
			unpack_7_25bit_unsigned_1off,
			unpack_7_25bit_signed_1off,
		},
		{
			unpack_7_25bit_unsigned_2off,
			unpack_7_25bit_signed_2off,
		},
		{
			unpack_7_25bit_unsigned_3off,
			unpack_7_25bit_signed_3off,
		},
		{
			unpack_7_25bit_unsigned_4off,
			unpack_7_25bit_signed_4off,
		},
		{
			unpack_7_25bit_unsigned_5off,
			unpack_7_25bit_signed_5off,
		},
		{
			unpack_7_25bit_unsigned_6off,
			unpack_7_25bit_signed_6off,
		},
		{
			unpack_7_25bit_unsigned_7off,
			unpack_7_25bit_signed_7off,
		},
	},
	{
		{
			unpack_8_25bit_unsigned_0off,
			unpack_8_25bit_signed_0off,
		},
		{
			unpack_8_25bit_unsigned_1off,
			unpack_8_25bit_signed_1off,
		},
		{
			unpack_8_25bit_unsigned_2off,
			unpack_8_25bit_signed_2off,
		},
		{
			unpack_8_25bit_unsigned_3off,
			unpack_8_25bit_signed_3off,
		},
		{
			unpack_8_25bit_unsigned_4off,
			unpack_8_25bit_signed_4off,
		},
		{
			unpack_8_25bit_unsigned_5off,
			unpack_8_25bit_signed_5off,
		},
		{
			unpack_8_25bit_unsigned_6off,
			unpack_8_25bit_signed_6off,
		},
		{
			unpack_8_25bit_unsigned_7off,
			unpack_8_25bit_signed_7off,
		},
	},
};
