// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack26.h"



static void unpack_1_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 26 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 26 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);
}

static void unpack_1_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 26 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);
}

static void unpack_2_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 52 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 52 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 52 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 52 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 52 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 52 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 52 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 52 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 52 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 52 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 52 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 52 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 52 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 52 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 52 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);
}

static void unpack_2_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 52 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);
}

static void unpack_3_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 78 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 78 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 78 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 78 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 78 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 78 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 78 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 78 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 78 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 78 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 78 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 78 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 78 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 78 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 78 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);
}

static void unpack_3_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 78 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);
}

static void unpack_4_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 104 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 104 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);
}

static void unpack_4_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 104 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);
}

static void unpack_5_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 130 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);
}

static void unpack_5_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 130 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);
}

static void unpack_6_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 156 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 156 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 156 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 156 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 156 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);
}

static void unpack_6_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 156 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);
}

static void unpack_7_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 182 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 182 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 182 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 182 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 182 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 182 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);
}

static void unpack_7_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);
}

static void unpack_8_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 208 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 208 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);
}

static void unpack_8_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);
}

static void unpack_9_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 234 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);
}

static void unpack_9_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 234 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);
}

static void unpack_10_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 260 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 260 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 260 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 260 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 260 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);
}

static void unpack_10_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 260 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);
}

static void unpack_11_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 286 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 286 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 286 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 286 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 286 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 286 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);
}

static void unpack_11_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);
}

static void unpack_12_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 312 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 312 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);
}

static void unpack_12_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 312 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);
}

static void unpack_13_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 338 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 338 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);
}

static void unpack_13_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 338 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);
}

static void unpack_14_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 338 to 363
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xf0) << 2);
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 338 to 363
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xf0) << 2);
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 339 to 364
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xf8) << 3);
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 339 to 364
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xf8) << 3);
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 340 to 365
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xfc) << 4);
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 340 to 365
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xfc) << 4);
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 341 to 366
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xfe) << 5);
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 341 to 366
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xfe) << 5);
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 342 to 367
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6);
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 342 to 367
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6);
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 364 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 343 to 368
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0x80) >> 1);
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 364 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 343 to 368
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0x80) >> 1);
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 364 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 344 to 369
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)input[45] << 8) |
			((uint32_t)(input[46] & 0xc0));
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 364 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 344 to 369
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)input[45] << 8) |
			((uint32_t)(input[46] & 0xc0));
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 364 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 345 to 370
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)input[45] << 9) |
			((uint32_t)(input[46] & 0xe0) << 1);
	output[13] = (double)(value >> 6);
}

static void unpack_14_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 364 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 345 to 370
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)input[45] << 9) |
			((uint32_t)(input[46] & 0xe0) << 1);
	output[13] = (double)(value >> 6);
}

static void unpack_15_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 390 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 338 to 363
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xf0) << 2);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 364 to 389
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xfc) << 4);
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 390 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 338 to 363
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xf0) << 2);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 364 to 389
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xfc) << 4);
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 390 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 339 to 364
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xf8) << 3);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 365 to 390
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xfe) << 5);
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 390 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 339 to 364
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xf8) << 3);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 365 to 390
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xfe) << 5);
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 390 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 340 to 365
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xfc) << 4);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 366 to 391
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6);
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 390 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 340 to 365
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xfc) << 4);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 366 to 391
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6);
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 341 to 366
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xfe) << 5);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 367 to 392
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0x80) >> 1);
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 341 to 366
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xfe) << 5);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 367 to 392
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0x80) >> 1);
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 342 to 367
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 368 to 393
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xc0));
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 342 to 367
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 368 to 393
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xc0));
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 343 to 368
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0x80) >> 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 369 to 394
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xe0) << 1);
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 343 to 368
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0x80) >> 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 369 to 394
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xe0) << 1);
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 344 to 369
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)input[45] << 8) |
			((uint32_t)(input[46] & 0xc0));
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 370 to 395
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xf0) << 2);
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 344 to 369
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)input[45] << 8) |
			((uint32_t)(input[46] & 0xc0));
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 370 to 395
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xf0) << 2);
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 345 to 370
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)input[45] << 9) |
			((uint32_t)(input[46] & 0xe0) << 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 371 to 396
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xf8) << 3);
	output[14] = (double)(value >> 6);
}

static void unpack_15_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 345 to 370
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)input[45] << 9) |
			((uint32_t)(input[46] & 0xe0) << 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 371 to 396
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xf8) << 3);
	output[14] = (double)(value >> 6);
}

static void unpack_16_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 416 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 338 to 363
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xf0) << 2);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 364 to 389
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xfc) << 4);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 390 to 415
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6);
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 416 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 338 to 363
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xf0) << 2);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 364 to 389
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xfc) << 4);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 390 to 415
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6);
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 339 to 364
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xf8) << 3);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 365 to 390
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xfe) << 5);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 391 to 416
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0x80) >> 1);
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 339 to 364
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xf8) << 3);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 365 to 390
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xfe) << 5);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 391 to 416
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0x80) >> 1);
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 340 to 365
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xfc) << 4);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 366 to 391
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 392 to 417
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xc0));
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 340 to 365
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xfc) << 4);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 366 to 391
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 392 to 417
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xc0));
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 341 to 366
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xfe) << 5);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 367 to 392
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0x80) >> 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 393 to 418
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xe0) << 1);
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 341 to 366
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xfe) << 5);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 367 to 392
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0x80) >> 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 393 to 418
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xe0) << 1);
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 342 to 367
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 368 to 393
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xc0));
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 394 to 419
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xf0) << 2);
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 342 to 367
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 368 to 393
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xc0));
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 394 to 419
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xf0) << 2);
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 343 to 368
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0x80) >> 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 369 to 394
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xe0) << 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 395 to 420
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xf8) << 3);
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 343 to 368
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0x80) >> 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 369 to 394
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xe0) << 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 395 to 420
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xf8) << 3);
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 344 to 369
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)input[45] << 8) |
			((uint32_t)(input[46] & 0xc0));
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 370 to 395
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xf0) << 2);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 396 to 421
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xfc) << 4);
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 344 to 369
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)input[45] << 8) |
			((uint32_t)(input[46] & 0xc0));
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 370 to 395
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xf0) << 2);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 396 to 421
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xfc) << 4);
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 345 to 370
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)input[45] << 9) |
			((uint32_t)(input[46] & 0xe0) << 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 371 to 396
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xf8) << 3);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 397 to 422
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xfe) << 5);
	output[15] = (double)(value >> 6);
}

static void unpack_16_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 345 to 370
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)input[45] << 9) |
			((uint32_t)(input[46] & 0xe0) << 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 371 to 396
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xf8) << 3);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 397 to 422
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xfe) << 5);
	output[15] = (double)(value >> 6);
}

static void unpack_17_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 338 to 363
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xf0) << 2);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 364 to 389
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xfc) << 4);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 390 to 415
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 416 to 441
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)(input[55] & 0xc0));
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 338 to 363
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xf0) << 2);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 364 to 389
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xfc) << 4);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 390 to 415
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 416 to 441
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)(input[55] & 0xc0));
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 339 to 364
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xf8) << 3);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 365 to 390
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xfe) << 5);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 391 to 416
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0x80) >> 1);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 417 to 442
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)(input[55] & 0xe0) << 1);
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 339 to 364
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xf8) << 3);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 365 to 390
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xfe) << 5);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 391 to 416
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0x80) >> 1);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 417 to 442
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)(input[55] & 0xe0) << 1);
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 340 to 365
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xfc) << 4);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 366 to 391
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 392 to 417
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xc0));
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 418 to 443
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)(input[55] & 0xf0) << 2);
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 340 to 365
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xfc) << 4);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 366 to 391
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 392 to 417
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xc0));
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 418 to 443
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)(input[55] & 0xf0) << 2);
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 341 to 366
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xfe) << 5);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 367 to 392
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0x80) >> 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 393 to 418
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xe0) << 1);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 419 to 444
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)(input[55] & 0xf8) << 3);
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 341 to 366
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xfe) << 5);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 367 to 392
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0x80) >> 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 393 to 418
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xe0) << 1);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 419 to 444
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)(input[55] & 0xf8) << 3);
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 342 to 367
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 368 to 393
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xc0));
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 394 to 419
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xf0) << 2);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 420 to 445
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)(input[55] & 0xfc) << 4);
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 342 to 367
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 368 to 393
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xc0));
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 394 to 419
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xf0) << 2);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 420 to 445
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)(input[55] & 0xfc) << 4);
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 343 to 368
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0x80) >> 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 369 to 394
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xe0) << 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 395 to 420
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xf8) << 3);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 421 to 446
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0xfe) << 5);
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 343 to 368
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0x80) >> 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 369 to 394
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xe0) << 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 395 to 420
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xf8) << 3);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 421 to 446
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0xfe) << 5);
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 344 to 369
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)input[45] << 8) |
			((uint32_t)(input[46] & 0xc0));
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 370 to 395
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xf0) << 2);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 396 to 421
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xfc) << 4);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 422 to 447
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6);
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 442 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 344 to 369
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)input[45] << 8) |
			((uint32_t)(input[46] & 0xc0));
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 370 to 395
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xf0) << 2);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 396 to 421
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xfc) << 4);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 422 to 447
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6);
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 442 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 345 to 370
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)input[45] << 9) |
			((uint32_t)(input[46] & 0xe0) << 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 371 to 396
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xf8) << 3);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 397 to 422
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xfe) << 5);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 423 to 448
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0x80) >> 1);
	output[16] = (double)(value >> 6);
}

static void unpack_17_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 442 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 345 to 370
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)input[45] << 9) |
			((uint32_t)(input[46] & 0xe0) << 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 371 to 396
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xf8) << 3);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 397 to 422
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xfe) << 5);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 423 to 448
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0x80) >> 1);
	output[16] = (double)(value >> 6);
}

static void unpack_18_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 468 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 338 to 363
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xf0) << 2);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 364 to 389
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xfc) << 4);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 390 to 415
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 416 to 441
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)(input[55] & 0xc0));
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 442 to 467
	value = ((uint32_t)(input[55] & 0x3f) << 26) |
			((uint32_t)input[56] << 18) |
			((uint32_t)input[57] << 10) |
			((uint32_t)(input[58] & 0xf0) << 2);
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 468 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 338 to 363
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xf0) << 2);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 364 to 389
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xfc) << 4);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 390 to 415
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 416 to 441
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)(input[55] & 0xc0));
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 442 to 467
	value = ((uint32_t)(input[55] & 0x3f) << 26) |
			((uint32_t)input[56] << 18) |
			((uint32_t)input[57] << 10) |
			((uint32_t)(input[58] & 0xf0) << 2);
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 468 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 339 to 364
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xf8) << 3);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 365 to 390
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xfe) << 5);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 391 to 416
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0x80) >> 1);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 417 to 442
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)(input[55] & 0xe0) << 1);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 443 to 468
	value = ((uint32_t)(input[55] & 0x1f) << 27) |
			((uint32_t)input[56] << 19) |
			((uint32_t)input[57] << 11) |
			((uint32_t)(input[58] & 0xf8) << 3);
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 468 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 339 to 364
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xf8) << 3);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 365 to 390
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xfe) << 5);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 391 to 416
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0x80) >> 1);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 417 to 442
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)(input[55] & 0xe0) << 1);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 443 to 468
	value = ((uint32_t)(input[55] & 0x1f) << 27) |
			((uint32_t)input[56] << 19) |
			((uint32_t)input[57] << 11) |
			((uint32_t)(input[58] & 0xf8) << 3);
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 468 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 340 to 365
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xfc) << 4);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 366 to 391
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 392 to 417
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xc0));
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 418 to 443
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)(input[55] & 0xf0) << 2);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 444 to 469
	value = ((uint32_t)(input[55] & 0x0f) << 28) |
			((uint32_t)input[56] << 20) |
			((uint32_t)input[57] << 12) |
			((uint32_t)(input[58] & 0xfc) << 4);
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 468 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 340 to 365
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xfc) << 4);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 366 to 391
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 392 to 417
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xc0));
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 418 to 443
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)(input[55] & 0xf0) << 2);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 444 to 469
	value = ((uint32_t)(input[55] & 0x0f) << 28) |
			((uint32_t)input[56] << 20) |
			((uint32_t)input[57] << 12) |
			((uint32_t)(input[58] & 0xfc) << 4);
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 468 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 341 to 366
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xfe) << 5);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 367 to 392
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0x80) >> 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 393 to 418
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xe0) << 1);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 419 to 444
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)(input[55] & 0xf8) << 3);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 445 to 470
	value = ((uint32_t)(input[55] & 0x07) << 29) |
			((uint32_t)input[56] << 21) |
			((uint32_t)input[57] << 13) |
			((uint32_t)(input[58] & 0xfe) << 5);
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 468 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 341 to 366
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xfe) << 5);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 367 to 392
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0x80) >> 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 393 to 418
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xe0) << 1);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 419 to 444
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)(input[55] & 0xf8) << 3);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 445 to 470
	value = ((uint32_t)(input[55] & 0x07) << 29) |
			((uint32_t)input[56] << 21) |
			((uint32_t)input[57] << 13) |
			((uint32_t)(input[58] & 0xfe) << 5);
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 468 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 342 to 367
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 368 to 393
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xc0));
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 394 to 419
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xf0) << 2);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 420 to 445
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)(input[55] & 0xfc) << 4);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 446 to 471
	value = ((uint32_t)(input[55] & 0x03) << 30) |
			((uint32_t)input[56] << 22) |
			((uint32_t)input[57] << 14) |
			((uint32_t)input[58] << 6);
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 468 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 342 to 367
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 368 to 393
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xc0));
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 394 to 419
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xf0) << 2);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 420 to 445
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)(input[55] & 0xfc) << 4);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 446 to 471
	value = ((uint32_t)(input[55] & 0x03) << 30) |
			((uint32_t)input[56] << 22) |
			((uint32_t)input[57] << 14) |
			((uint32_t)input[58] << 6);
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 468 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 343 to 368
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0x80) >> 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 369 to 394
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xe0) << 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 395 to 420
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xf8) << 3);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 421 to 446
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0xfe) << 5);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 447 to 472
	value = ((uint32_t)(input[55] & 0x01) << 31) |
			((uint32_t)input[56] << 23) |
			((uint32_t)input[57] << 15) |
			((uint32_t)input[58] << 7) |
			((uint32_t)(input[59] & 0x80) >> 1);
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 468 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 343 to 368
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0x80) >> 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 369 to 394
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xe0) << 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 395 to 420
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xf8) << 3);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 421 to 446
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0xfe) << 5);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 447 to 472
	value = ((uint32_t)(input[55] & 0x01) << 31) |
			((uint32_t)input[56] << 23) |
			((uint32_t)input[57] << 15) |
			((uint32_t)input[58] << 7) |
			((uint32_t)(input[59] & 0x80) >> 1);
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 468 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 344 to 369
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)input[45] << 8) |
			((uint32_t)(input[46] & 0xc0));
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 370 to 395
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xf0) << 2);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 396 to 421
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xfc) << 4);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 422 to 447
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 448 to 473
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)(input[59] & 0xc0));
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 468 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 344 to 369
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)input[45] << 8) |
			((uint32_t)(input[46] & 0xc0));
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 370 to 395
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xf0) << 2);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 396 to 421
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xfc) << 4);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 422 to 447
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 448 to 473
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)(input[59] & 0xc0));
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 468 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 345 to 370
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)input[45] << 9) |
			((uint32_t)(input[46] & 0xe0) << 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 371 to 396
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xf8) << 3);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 397 to 422
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xfe) << 5);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 423 to 448
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0x80) >> 1);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 449 to 474
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)(input[59] & 0xe0) << 1);
	output[17] = (double)(value >> 6);
}

static void unpack_18_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 468 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 345 to 370
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)input[45] << 9) |
			((uint32_t)(input[46] & 0xe0) << 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 371 to 396
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xf8) << 3);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 397 to 422
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xfe) << 5);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 423 to 448
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0x80) >> 1);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 449 to 474
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)(input[59] & 0xe0) << 1);
	output[17] = (double)(value >> 6);
}

static void unpack_19_26bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit signed
	// Skip 0 bits, read 494 bits of data.
	// Input must be at least 62 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 338 to 363
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xf0) << 2);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 364 to 389
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xfc) << 4);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 390 to 415
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 416 to 441
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)(input[55] & 0xc0));
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 442 to 467
	value = ((uint32_t)(input[55] & 0x3f) << 26) |
			((uint32_t)input[56] << 18) |
			((uint32_t)input[57] << 10) |
			((uint32_t)(input[58] & 0xf0) << 2);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 468 to 493
	value = ((uint32_t)(input[58] & 0x0f) << 28) |
			((uint32_t)input[59] << 20) |
			((uint32_t)input[60] << 12) |
			((uint32_t)(input[61] & 0xfc) << 4);
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit unsigned
	// Skip 0 bits, read 494 bits of data.
	// Input must be at least 62 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 25
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xc0));
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 26 to 51
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10) |
			((uint32_t)(input[6] & 0xf0) << 2);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 52 to 77
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)input[8] << 12) |
			((uint32_t)(input[9] & 0xfc) << 4);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 78 to 103
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)input[12] << 6);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 104 to 129
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)input[15] << 8) |
			((uint32_t)(input[16] & 0xc0));
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 130 to 155
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)(input[19] & 0xf0) << 2);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 156 to 181
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xfc) << 4);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 182 to 207
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 208 to 233
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xc0));
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 234 to 259
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)input[31] << 10) |
			((uint32_t)(input[32] & 0xf0) << 2);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 260 to 285
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)(input[35] & 0xfc) << 4);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 286 to 311
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 312 to 337
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xc0));
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 338 to 363
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xf0) << 2);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 364 to 389
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)(input[48] & 0xfc) << 4);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 390 to 415
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 416 to 441
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)(input[55] & 0xc0));
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 442 to 467
	value = ((uint32_t)(input[55] & 0x3f) << 26) |
			((uint32_t)input[56] << 18) |
			((uint32_t)input[57] << 10) |
			((uint32_t)(input[58] & 0xf0) << 2);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 468 to 493
	value = ((uint32_t)(input[58] & 0x0f) << 28) |
			((uint32_t)input[59] << 20) |
			((uint32_t)input[60] << 12) |
			((uint32_t)(input[61] & 0xfc) << 4);
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit signed
	// Skip 1 bits, read 494 bits of data.
	// Input must be at least 62 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 339 to 364
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xf8) << 3);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 365 to 390
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xfe) << 5);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 391 to 416
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0x80) >> 1);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 417 to 442
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)(input[55] & 0xe0) << 1);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 443 to 468
	value = ((uint32_t)(input[55] & 0x1f) << 27) |
			((uint32_t)input[56] << 19) |
			((uint32_t)input[57] << 11) |
			((uint32_t)(input[58] & 0xf8) << 3);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 469 to 494
	value = ((uint32_t)(input[58] & 0x07) << 29) |
			((uint32_t)input[59] << 21) |
			((uint32_t)input[60] << 13) |
			((uint32_t)(input[61] & 0xfe) << 5);
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit unsigned
	// Skip 1 bits, read 494 bits of data.
	// Input must be at least 62 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 26
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xe0) << 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 27 to 52
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xf8) << 3);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 53 to 78
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)input[8] << 13) |
			((uint32_t)(input[9] & 0xfe) << 5);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 79 to 104
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)input[12] << 7) |
			((uint32_t)(input[13] & 0x80) >> 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 105 to 130
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)input[15] << 9) |
			((uint32_t)(input[16] & 0xe0) << 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 131 to 156
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)(input[19] & 0xf8) << 3);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 157 to 182
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xfe) << 5);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 183 to 208
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0x80) >> 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 209 to 234
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xe0) << 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 235 to 260
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)input[31] << 11) |
			((uint32_t)(input[32] & 0xf8) << 3);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 261 to 286
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0xfe) << 5);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 287 to 312
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0x80) >> 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 313 to 338
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xe0) << 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 339 to 364
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xf8) << 3);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 365 to 390
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0xfe) << 5);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 391 to 416
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0x80) >> 1);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 417 to 442
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)(input[55] & 0xe0) << 1);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 443 to 468
	value = ((uint32_t)(input[55] & 0x1f) << 27) |
			((uint32_t)input[56] << 19) |
			((uint32_t)input[57] << 11) |
			((uint32_t)(input[58] & 0xf8) << 3);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 469 to 494
	value = ((uint32_t)(input[58] & 0x07) << 29) |
			((uint32_t)input[59] << 21) |
			((uint32_t)input[60] << 13) |
			((uint32_t)(input[61] & 0xfe) << 5);
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit signed
	// Skip 2 bits, read 494 bits of data.
	// Input must be at least 62 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 340 to 365
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xfc) << 4);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 366 to 391
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 392 to 417
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xc0));
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 418 to 443
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)(input[55] & 0xf0) << 2);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 444 to 469
	value = ((uint32_t)(input[55] & 0x0f) << 28) |
			((uint32_t)input[56] << 20) |
			((uint32_t)input[57] << 12) |
			((uint32_t)(input[58] & 0xfc) << 4);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 470 to 495
	value = ((uint32_t)(input[58] & 0x03) << 30) |
			((uint32_t)input[59] << 22) |
			((uint32_t)input[60] << 14) |
			((uint32_t)input[61] << 6);
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit unsigned
	// Skip 2 bits, read 494 bits of data.
	// Input must be at least 62 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 27
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf0) << 2);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 28 to 53
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfc) << 4);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 54 to 79
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 80 to 105
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)input[12] << 8) |
			((uint32_t)(input[13] & 0xc0));
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 106 to 131
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)input[15] << 10) |
			((uint32_t)(input[16] & 0xf0) << 2);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 132 to 157
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xfc) << 4);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 158 to 183
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 184 to 209
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xc0));
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 210 to 235
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xf0) << 2);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 236 to 261
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)input[31] << 12) |
			((uint32_t)(input[32] & 0xfc) << 4);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 262 to 287
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 288 to 313
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)(input[39] & 0xc0));
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 314 to 339
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xf0) << 2);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 340 to 365
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)(input[45] & 0xfc) << 4);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 366 to 391
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 392 to 417
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xc0));
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 418 to 443
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)(input[55] & 0xf0) << 2);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 444 to 469
	value = ((uint32_t)(input[55] & 0x0f) << 28) |
			((uint32_t)input[56] << 20) |
			((uint32_t)input[57] << 12) |
			((uint32_t)(input[58] & 0xfc) << 4);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 470 to 495
	value = ((uint32_t)(input[58] & 0x03) << 30) |
			((uint32_t)input[59] << 22) |
			((uint32_t)input[60] << 14) |
			((uint32_t)input[61] << 6);
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit signed
	// Skip 3 bits, read 494 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 341 to 366
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xfe) << 5);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 367 to 392
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0x80) >> 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 393 to 418
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xe0) << 1);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 419 to 444
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)(input[55] & 0xf8) << 3);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 445 to 470
	value = ((uint32_t)(input[55] & 0x07) << 29) |
			((uint32_t)input[56] << 21) |
			((uint32_t)input[57] << 13) |
			((uint32_t)(input[58] & 0xfe) << 5);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 471 to 496
	value = ((uint32_t)(input[58] & 0x01) << 31) |
			((uint32_t)input[59] << 23) |
			((uint32_t)input[60] << 15) |
			((uint32_t)input[61] << 7) |
			((uint32_t)(input[62] & 0x80) >> 1);
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit unsigned
	// Skip 3 bits, read 494 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 28
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xf8) << 3);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 29 to 54
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xfe) << 5);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 55 to 80
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0x80) >> 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 81 to 106
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xe0) << 1);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 107 to 132
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11) |
			((uint32_t)(input[16] & 0xf8) << 3);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 133 to 158
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xfe) << 5);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 159 to 184
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0x80) >> 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 185 to 210
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xe0) << 1);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 211 to 236
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)(input[29] & 0xf8) << 3);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 237 to 262
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)input[31] << 13) |
			((uint32_t)(input[32] & 0xfe) << 5);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 263 to 288
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0x80) >> 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 289 to 314
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)(input[39] & 0xe0) << 1);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 315 to 340
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xf8) << 3);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 341 to 366
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0xfe) << 5);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 367 to 392
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0x80) >> 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 393 to 418
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xe0) << 1);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 419 to 444
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)(input[55] & 0xf8) << 3);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 445 to 470
	value = ((uint32_t)(input[55] & 0x07) << 29) |
			((uint32_t)input[56] << 21) |
			((uint32_t)input[57] << 13) |
			((uint32_t)(input[58] & 0xfe) << 5);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 471 to 496
	value = ((uint32_t)(input[58] & 0x01) << 31) |
			((uint32_t)input[59] << 23) |
			((uint32_t)input[60] << 15) |
			((uint32_t)input[61] << 7) |
			((uint32_t)(input[62] & 0x80) >> 1);
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit signed
	// Skip 4 bits, read 494 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 342 to 367
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 368 to 393
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xc0));
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 394 to 419
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xf0) << 2);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 420 to 445
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)(input[55] & 0xfc) << 4);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 446 to 471
	value = ((uint32_t)(input[55] & 0x03) << 30) |
			((uint32_t)input[56] << 22) |
			((uint32_t)input[57] << 14) |
			((uint32_t)input[58] << 6);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 472 to 497
	value = ((uint32_t)input[59] << 24) |
			((uint32_t)input[60] << 16) |
			((uint32_t)input[61] << 8) |
			((uint32_t)(input[62] & 0xc0));
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit unsigned
	// Skip 4 bits, read 494 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 29
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfc) << 4);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 30 to 55
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 56 to 81
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xc0));
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 82 to 107
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf0) << 2);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 108 to 133
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfc) << 4);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 134 to 159
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 160 to 185
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xc0));
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 186 to 211
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)(input[26] & 0xf0) << 2);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 212 to 237
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)(input[29] & 0xfc) << 4);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 238 to 263
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14) |
			((uint32_t)input[32] << 6);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 264 to 289
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)input[35] << 8) |
			((uint32_t)(input[36] & 0xc0));
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 290 to 315
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)(input[39] & 0xf0) << 2);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 316 to 341
	value = ((uint32_t)(input[39] & 0x0f) << 28) |
			((uint32_t)input[40] << 20) |
			((uint32_t)input[41] << 12) |
			((uint32_t)(input[42] & 0xfc) << 4);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 342 to 367
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 368 to 393
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xc0));
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 394 to 419
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xf0) << 2);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 420 to 445
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)(input[55] & 0xfc) << 4);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 446 to 471
	value = ((uint32_t)(input[55] & 0x03) << 30) |
			((uint32_t)input[56] << 22) |
			((uint32_t)input[57] << 14) |
			((uint32_t)input[58] << 6);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 472 to 497
	value = ((uint32_t)input[59] << 24) |
			((uint32_t)input[60] << 16) |
			((uint32_t)input[61] << 8) |
			((uint32_t)(input[62] & 0xc0));
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit signed
	// Skip 5 bits, read 494 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 343 to 368
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0x80) >> 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 369 to 394
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xe0) << 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 395 to 420
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xf8) << 3);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 421 to 446
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0xfe) << 5);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 447 to 472
	value = ((uint32_t)(input[55] & 0x01) << 31) |
			((uint32_t)input[56] << 23) |
			((uint32_t)input[57] << 15) |
			((uint32_t)input[58] << 7) |
			((uint32_t)(input[59] & 0x80) >> 1);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 473 to 498
	value = ((uint32_t)(input[59] & 0x7f) << 25) |
			((uint32_t)input[60] << 17) |
			((uint32_t)input[61] << 9) |
			((uint32_t)(input[62] & 0xe0) << 1);
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit unsigned
	// Skip 5 bits, read 494 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 30
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xfe) << 5);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 31 to 56
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0x80) >> 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 57 to 82
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xe0) << 1);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 83 to 108
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xf8) << 3);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 109 to 134
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xfe) << 5);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 135 to 160
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0x80) >> 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 161 to 186
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)(input[23] & 0xe0) << 1);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 187 to 212
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)(input[26] & 0xf8) << 3);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 213 to 238
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)(input[29] & 0xfe) << 5);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 239 to 264
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)input[32] << 7) |
			((uint32_t)(input[33] & 0x80) >> 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 265 to 290
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)input[35] << 9) |
			((uint32_t)(input[36] & 0xe0) << 1);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 291 to 316
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0xf8) << 3);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 317 to 342
	value = ((uint32_t)(input[39] & 0x07) << 29) |
			((uint32_t)input[40] << 21) |
			((uint32_t)input[41] << 13) |
			((uint32_t)(input[42] & 0xfe) << 5);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 343 to 368
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0x80) >> 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 369 to 394
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xe0) << 1);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 395 to 420
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xf8) << 3);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 421 to 446
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0xfe) << 5);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 447 to 472
	value = ((uint32_t)(input[55] & 0x01) << 31) |
			((uint32_t)input[56] << 23) |
			((uint32_t)input[57] << 15) |
			((uint32_t)input[58] << 7) |
			((uint32_t)(input[59] & 0x80) >> 1);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 473 to 498
	value = ((uint32_t)(input[59] & 0x7f) << 25) |
			((uint32_t)input[60] << 17) |
			((uint32_t)input[61] << 9) |
			((uint32_t)(input[62] & 0xe0) << 1);
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit signed
	// Skip 6 bits, read 494 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 344 to 369
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)input[45] << 8) |
			((uint32_t)(input[46] & 0xc0));
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 370 to 395
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xf0) << 2);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 396 to 421
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xfc) << 4);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 422 to 447
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 448 to 473
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)(input[59] & 0xc0));
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 474 to 499
	value = ((uint32_t)(input[59] & 0x3f) << 26) |
			((uint32_t)input[60] << 18) |
			((uint32_t)input[61] << 10) |
			((uint32_t)(input[62] & 0xf0) << 2);
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit unsigned
	// Skip 6 bits, read 494 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 31
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 32 to 57
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xc0));
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 58 to 83
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf0) << 2);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 84 to 109
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfc) << 4);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 110 to 135
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 136 to 161
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xc0));
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 162 to 187
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf0) << 2);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 188 to 213
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)(input[26] & 0xfc) << 4);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 214 to 239
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 240 to 265
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xc0));
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 266 to 291
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10) |
			((uint32_t)(input[36] & 0xf0) << 2);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 292 to 317
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xfc) << 4);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 318 to 343
	value = ((uint32_t)(input[39] & 0x03) << 30) |
			((uint32_t)input[40] << 22) |
			((uint32_t)input[41] << 14) |
			((uint32_t)input[42] << 6);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 344 to 369
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)input[45] << 8) |
			((uint32_t)(input[46] & 0xc0));
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 370 to 395
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xf0) << 2);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 396 to 421
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xfc) << 4);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 422 to 447
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 448 to 473
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)(input[59] & 0xc0));
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 474 to 499
	value = ((uint32_t)(input[59] & 0x3f) << 26) |
			((uint32_t)input[60] << 18) |
			((uint32_t)input[61] << 10) |
			((uint32_t)(input[62] & 0xf0) << 2);
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit signed
	// Skip 7 bits, read 494 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 345 to 370
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)input[45] << 9) |
			((uint32_t)(input[46] & 0xe0) << 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 371 to 396
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xf8) << 3);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 397 to 422
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xfe) << 5);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 423 to 448
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0x80) >> 1);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 449 to 474
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)(input[59] & 0xe0) << 1);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 475 to 500
	value = ((uint32_t)(input[59] & 0x1f) << 27) |
			((uint32_t)input[60] << 19) |
			((uint32_t)input[61] << 11) |
			((uint32_t)(input[62] & 0xf8) << 3);
	output[18] = (double)(value >> 6);
}

static void unpack_19_26bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 26-bit unsigned
	// Skip 7 bits, read 494 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 32
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0x80) >> 1);
	output[0] = (double)(value >> 6);

	// read output[1]: from bit 33 to 58
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xe0) << 1);
	output[1] = (double)(value >> 6);

	// read output[2]: from bit 59 to 84
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xf8) << 3);
	output[2] = (double)(value >> 6);

	// read output[3]: from bit 85 to 110
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xfe) << 5);
	output[3] = (double)(value >> 6);

	// read output[4]: from bit 111 to 136
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0x80) >> 1);
	output[4] = (double)(value >> 6);

	// read output[5]: from bit 137 to 162
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xe0) << 1);
	output[5] = (double)(value >> 6);

	// read output[6]: from bit 163 to 188
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xf8) << 3);
	output[6] = (double)(value >> 6);

	// read output[7]: from bit 189 to 214
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)(input[26] & 0xfe) << 5);
	output[7] = (double)(value >> 6);

	// read output[8]: from bit 215 to 240
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0x80) >> 1);
	output[8] = (double)(value >> 6);

	// read output[9]: from bit 241 to 266
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xe0) << 1);
	output[9] = (double)(value >> 6);

	// read output[10]: from bit 267 to 292
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0xf8) << 3);
	output[10] = (double)(value >> 6);

	// read output[11]: from bit 293 to 318
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xfe) << 5);
	output[11] = (double)(value >> 6);

	// read output[12]: from bit 319 to 344
	value = ((uint32_t)(input[39] & 0x01) << 31) |
			((uint32_t)input[40] << 23) |
			((uint32_t)input[41] << 15) |
			((uint32_t)input[42] << 7) |
			((uint32_t)(input[43] & 0x80) >> 1);
	output[12] = (double)(value >> 6);

	// read output[13]: from bit 345 to 370
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)input[45] << 9) |
			((uint32_t)(input[46] & 0xe0) << 1);
	output[13] = (double)(value >> 6);

	// read output[14]: from bit 371 to 396
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xf8) << 3);
	output[14] = (double)(value >> 6);

	// read output[15]: from bit 397 to 422
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xfe) << 5);
	output[15] = (double)(value >> 6);

	// read output[16]: from bit 423 to 448
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0x80) >> 1);
	output[16] = (double)(value >> 6);

	// read output[17]: from bit 449 to 474
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)(input[59] & 0xe0) << 1);
	output[17] = (double)(value >> 6);

	// read output[18]: from bit 475 to 500
	value = ((uint32_t)(input[59] & 0x1f) << 27) |
			((uint32_t)input[60] << 19) |
			((uint32_t)input[61] << 11) |
			((uint32_t)(input[62] & 0xf8) << 3);
	output[18] = (double)(value >> 6);
}


unpack_func_t unpack_26bit[UNPACK_26BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_26bit_unsigned_0off,
			unpack_1_26bit_signed_0off,
		},
		{
			unpack_1_26bit_unsigned_1off,
			unpack_1_26bit_signed_1off,
		},
		{
			unpack_1_26bit_unsigned_2off,
			unpack_1_26bit_signed_2off,
		},
		{
			unpack_1_26bit_unsigned_3off,
			unpack_1_26bit_signed_3off,
		},
		{
			unpack_1_26bit_unsigned_4off,
			unpack_1_26bit_signed_4off,
		},
		{
			unpack_1_26bit_unsigned_5off,
			unpack_1_26bit_signed_5off,
		},
		{
			unpack_1_26bit_unsigned_6off,
			unpack_1_26bit_signed_6off,
		},
		{
			unpack_1_26bit_unsigned_7off,
			unpack_1_26bit_signed_7off,
		},
	},
	{
		{
			unpack_2_26bit_unsigned_0off,
			unpack_2_26bit_signed_0off,
		},
		{
			unpack_2_26bit_unsigned_1off,
			unpack_2_26bit_signed_1off,
		},
		{
			unpack_2_26bit_unsigned_2off,
			unpack_2_26bit_signed_2off,
		},
		{
			unpack_2_26bit_unsigned_3off,
			unpack_2_26bit_signed_3off,
		},
		{
			unpack_2_26bit_unsigned_4off,
			unpack_2_26bit_signed_4off,
		},
		{
			unpack_2_26bit_unsigned_5off,
			unpack_2_26bit_signed_5off,
		},
		{
			unpack_2_26bit_unsigned_6off,
			unpack_2_26bit_signed_6off,
		},
		{
			unpack_2_26bit_unsigned_7off,
			unpack_2_26bit_signed_7off,
		},
	},
	{
		{
			unpack_3_26bit_unsigned_0off,
			unpack_3_26bit_signed_0off,
		},
		{
			unpack_3_26bit_unsigned_1off,
			unpack_3_26bit_signed_1off,
		},
		{
			unpack_3_26bit_unsigned_2off,
			unpack_3_26bit_signed_2off,
		},
		{
			unpack_3_26bit_unsigned_3off,
			unpack_3_26bit_signed_3off,
		},
		{
			unpack_3_26bit_unsigned_4off,
			unpack_3_26bit_signed_4off,
		},
		{
			unpack_3_26bit_unsigned_5off,
			unpack_3_26bit_signed_5off,
		},
		{
			unpack_3_26bit_unsigned_6off,
			unpack_3_26bit_signed_6off,
		},
		{
			unpack_3_26bit_unsigned_7off,
			unpack_3_26bit_signed_7off,
		},
	},
	{
		{
			unpack_4_26bit_unsigned_0off,
			unpack_4_26bit_signed_0off,
		},
		{
			unpack_4_26bit_unsigned_1off,
			unpack_4_26bit_signed_1off,
		},
		{
			unpack_4_26bit_unsigned_2off,
			unpack_4_26bit_signed_2off,
		},
		{
			unpack_4_26bit_unsigned_3off,
			unpack_4_26bit_signed_3off,
		},
		{
			unpack_4_26bit_unsigned_4off,
			unpack_4_26bit_signed_4off,
		},
		{
			unpack_4_26bit_unsigned_5off,
			unpack_4_26bit_signed_5off,
		},
		{
			unpack_4_26bit_unsigned_6off,
			unpack_4_26bit_signed_6off,
		},
		{
			unpack_4_26bit_unsigned_7off,
			unpack_4_26bit_signed_7off,
		},
	},
	{
		{
			unpack_5_26bit_unsigned_0off,
			unpack_5_26bit_signed_0off,
		},
		{
			unpack_5_26bit_unsigned_1off,
			unpack_5_26bit_signed_1off,
		},
		{
			unpack_5_26bit_unsigned_2off,
			unpack_5_26bit_signed_2off,
		},
		{
			unpack_5_26bit_unsigned_3off,
			unpack_5_26bit_signed_3off,
		},
		{
			unpack_5_26bit_unsigned_4off,
			unpack_5_26bit_signed_4off,
		},
		{
			unpack_5_26bit_unsigned_5off,
			unpack_5_26bit_signed_5off,
		},
		{
			unpack_5_26bit_unsigned_6off,
			unpack_5_26bit_signed_6off,
		},
		{
			unpack_5_26bit_unsigned_7off,
			unpack_5_26bit_signed_7off,
		},
	},
	{
		{
			unpack_6_26bit_unsigned_0off,
			unpack_6_26bit_signed_0off,
		},
		{
			unpack_6_26bit_unsigned_1off,
			unpack_6_26bit_signed_1off,
		},
		{
			unpack_6_26bit_unsigned_2off,
			unpack_6_26bit_signed_2off,
		},
		{
			unpack_6_26bit_unsigned_3off,
			unpack_6_26bit_signed_3off,
		},
		{
			unpack_6_26bit_unsigned_4off,
			unpack_6_26bit_signed_4off,
		},
		{
			unpack_6_26bit_unsigned_5off,
			unpack_6_26bit_signed_5off,
		},
		{
			unpack_6_26bit_unsigned_6off,
			unpack_6_26bit_signed_6off,
		},
		{
			unpack_6_26bit_unsigned_7off,
			unpack_6_26bit_signed_7off,
		},
	},
	{
		{
			unpack_7_26bit_unsigned_0off,
			unpack_7_26bit_signed_0off,
		},
		{
			unpack_7_26bit_unsigned_1off,
			unpack_7_26bit_signed_1off,
		},
		{
			unpack_7_26bit_unsigned_2off,
			unpack_7_26bit_signed_2off,
		},
		{
			unpack_7_26bit_unsigned_3off,
			unpack_7_26bit_signed_3off,
		},
		{
			unpack_7_26bit_unsigned_4off,
			unpack_7_26bit_signed_4off,
		},
		{
			unpack_7_26bit_unsigned_5off,
			unpack_7_26bit_signed_5off,
		},
		{
			unpack_7_26bit_unsigned_6off,
			unpack_7_26bit_signed_6off,
		},
		{
			unpack_7_26bit_unsigned_7off,
			unpack_7_26bit_signed_7off,
		},
	},
	{
		{
			unpack_8_26bit_unsigned_0off,
			unpack_8_26bit_signed_0off,
		},
		{
			unpack_8_26bit_unsigned_1off,
			unpack_8_26bit_signed_1off,
		},
		{
			unpack_8_26bit_unsigned_2off,
			unpack_8_26bit_signed_2off,
		},
		{
			unpack_8_26bit_unsigned_3off,
			unpack_8_26bit_signed_3off,
		},
		{
			unpack_8_26bit_unsigned_4off,
			unpack_8_26bit_signed_4off,
		},
		{
			unpack_8_26bit_unsigned_5off,
			unpack_8_26bit_signed_5off,
		},
		{
			unpack_8_26bit_unsigned_6off,
			unpack_8_26bit_signed_6off,
		},
		{
			unpack_8_26bit_unsigned_7off,
			unpack_8_26bit_signed_7off,
		},
	},
	{
		{
			unpack_9_26bit_unsigned_0off,
			unpack_9_26bit_signed_0off,
		},
		{
			unpack_9_26bit_unsigned_1off,
			unpack_9_26bit_signed_1off,
		},
		{
			unpack_9_26bit_unsigned_2off,
			unpack_9_26bit_signed_2off,
		},
		{
			unpack_9_26bit_unsigned_3off,
			unpack_9_26bit_signed_3off,
		},
		{
			unpack_9_26bit_unsigned_4off,
			unpack_9_26bit_signed_4off,
		},
		{
			unpack_9_26bit_unsigned_5off,
			unpack_9_26bit_signed_5off,
		},
		{
			unpack_9_26bit_unsigned_6off,
			unpack_9_26bit_signed_6off,
		},
		{
			unpack_9_26bit_unsigned_7off,
			unpack_9_26bit_signed_7off,
		},
	},
	{
		{
			unpack_10_26bit_unsigned_0off,
			unpack_10_26bit_signed_0off,
		},
		{
			unpack_10_26bit_unsigned_1off,
			unpack_10_26bit_signed_1off,
		},
		{
			unpack_10_26bit_unsigned_2off,
			unpack_10_26bit_signed_2off,
		},
		{
			unpack_10_26bit_unsigned_3off,
			unpack_10_26bit_signed_3off,
		},
		{
			unpack_10_26bit_unsigned_4off,
			unpack_10_26bit_signed_4off,
		},
		{
			unpack_10_26bit_unsigned_5off,
			unpack_10_26bit_signed_5off,
		},
		{
			unpack_10_26bit_unsigned_6off,
			unpack_10_26bit_signed_6off,
		},
		{
			unpack_10_26bit_unsigned_7off,
			unpack_10_26bit_signed_7off,
		},
	},
	{
		{
			unpack_11_26bit_unsigned_0off,
			unpack_11_26bit_signed_0off,
		},
		{
			unpack_11_26bit_unsigned_1off,
			unpack_11_26bit_signed_1off,
		},
		{
			unpack_11_26bit_unsigned_2off,
			unpack_11_26bit_signed_2off,
		},
		{
			unpack_11_26bit_unsigned_3off,
			unpack_11_26bit_signed_3off,
		},
		{
			unpack_11_26bit_unsigned_4off,
			unpack_11_26bit_signed_4off,
		},
		{
			unpack_11_26bit_unsigned_5off,
			unpack_11_26bit_signed_5off,
		},
		{
			unpack_11_26bit_unsigned_6off,
			unpack_11_26bit_signed_6off,
		},
		{
			unpack_11_26bit_unsigned_7off,
			unpack_11_26bit_signed_7off,
		},
	},
	{
		{
			unpack_12_26bit_unsigned_0off,
			unpack_12_26bit_signed_0off,
		},
		{
			unpack_12_26bit_unsigned_1off,
			unpack_12_26bit_signed_1off,
		},
		{
			unpack_12_26bit_unsigned_2off,
			unpack_12_26bit_signed_2off,
		},
		{
			unpack_12_26bit_unsigned_3off,
			unpack_12_26bit_signed_3off,
		},
		{
			unpack_12_26bit_unsigned_4off,
			unpack_12_26bit_signed_4off,
		},
		{
			unpack_12_26bit_unsigned_5off,
			unpack_12_26bit_signed_5off,
		},
		{
			unpack_12_26bit_unsigned_6off,
			unpack_12_26bit_signed_6off,
		},
		{
			unpack_12_26bit_unsigned_7off,
			unpack_12_26bit_signed_7off,
		},
	},
	{
		{
			unpack_13_26bit_unsigned_0off,
			unpack_13_26bit_signed_0off,
		},
		{
			unpack_13_26bit_unsigned_1off,
			unpack_13_26bit_signed_1off,
		},
		{
			unpack_13_26bit_unsigned_2off,
			unpack_13_26bit_signed_2off,
		},
		{
			unpack_13_26bit_unsigned_3off,
			unpack_13_26bit_signed_3off,
		},
		{
			unpack_13_26bit_unsigned_4off,
			unpack_13_26bit_signed_4off,
		},
		{
			unpack_13_26bit_unsigned_5off,
			unpack_13_26bit_signed_5off,
		},
		{
			unpack_13_26bit_unsigned_6off,
			unpack_13_26bit_signed_6off,
		},
		{
			unpack_13_26bit_unsigned_7off,
			unpack_13_26bit_signed_7off,
		},
	},
	{
		{
			unpack_14_26bit_unsigned_0off,
			unpack_14_26bit_signed_0off,
		},
		{
			unpack_14_26bit_unsigned_1off,
			unpack_14_26bit_signed_1off,
		},
		{
			unpack_14_26bit_unsigned_2off,
			unpack_14_26bit_signed_2off,
		},
		{
			unpack_14_26bit_unsigned_3off,
			unpack_14_26bit_signed_3off,
		},
		{
			unpack_14_26bit_unsigned_4off,
			unpack_14_26bit_signed_4off,
		},
		{
			unpack_14_26bit_unsigned_5off,
			unpack_14_26bit_signed_5off,
		},
		{
			unpack_14_26bit_unsigned_6off,
			unpack_14_26bit_signed_6off,
		},
		{
			unpack_14_26bit_unsigned_7off,
			unpack_14_26bit_signed_7off,
		},
	},
	{
		{
			unpack_15_26bit_unsigned_0off,
			unpack_15_26bit_signed_0off,
		},
		{
			unpack_15_26bit_unsigned_1off,
			unpack_15_26bit_signed_1off,
		},
		{
			unpack_15_26bit_unsigned_2off,
			unpack_15_26bit_signed_2off,
		},
		{
			unpack_15_26bit_unsigned_3off,
			unpack_15_26bit_signed_3off,
		},
		{
			unpack_15_26bit_unsigned_4off,
			unpack_15_26bit_signed_4off,
		},
		{
			unpack_15_26bit_unsigned_5off,
			unpack_15_26bit_signed_5off,
		},
		{
			unpack_15_26bit_unsigned_6off,
			unpack_15_26bit_signed_6off,
		},
		{
			unpack_15_26bit_unsigned_7off,
			unpack_15_26bit_signed_7off,
		},
	},
	{
		{
			unpack_16_26bit_unsigned_0off,
			unpack_16_26bit_signed_0off,
		},
		{
			unpack_16_26bit_unsigned_1off,
			unpack_16_26bit_signed_1off,
		},
		{
			unpack_16_26bit_unsigned_2off,
			unpack_16_26bit_signed_2off,
		},
		{
			unpack_16_26bit_unsigned_3off,
			unpack_16_26bit_signed_3off,
		},
		{
			unpack_16_26bit_unsigned_4off,
			unpack_16_26bit_signed_4off,
		},
		{
			unpack_16_26bit_unsigned_5off,
			unpack_16_26bit_signed_5off,
		},
		{
			unpack_16_26bit_unsigned_6off,
			unpack_16_26bit_signed_6off,
		},
		{
			unpack_16_26bit_unsigned_7off,
			unpack_16_26bit_signed_7off,
		},
	},
	{
		{
			unpack_17_26bit_unsigned_0off,
			unpack_17_26bit_signed_0off,
		},
		{
			unpack_17_26bit_unsigned_1off,
			unpack_17_26bit_signed_1off,
		},
		{
			unpack_17_26bit_unsigned_2off,
			unpack_17_26bit_signed_2off,
		},
		{
			unpack_17_26bit_unsigned_3off,
			unpack_17_26bit_signed_3off,
		},
		{
			unpack_17_26bit_unsigned_4off,
			unpack_17_26bit_signed_4off,
		},
		{
			unpack_17_26bit_unsigned_5off,
			unpack_17_26bit_signed_5off,
		},
		{
			unpack_17_26bit_unsigned_6off,
			unpack_17_26bit_signed_6off,
		},
		{
			unpack_17_26bit_unsigned_7off,
			unpack_17_26bit_signed_7off,
		},
	},
	{
		{
			unpack_18_26bit_unsigned_0off,
			unpack_18_26bit_signed_0off,
		},
		{
			unpack_18_26bit_unsigned_1off,
			unpack_18_26bit_signed_1off,
		},
		{
			unpack_18_26bit_unsigned_2off,
			unpack_18_26bit_signed_2off,
		},
		{
			unpack_18_26bit_unsigned_3off,
			unpack_18_26bit_signed_3off,
		},
		{
			unpack_18_26bit_unsigned_4off,
			unpack_18_26bit_signed_4off,
		},
		{
			unpack_18_26bit_unsigned_5off,
			unpack_18_26bit_signed_5off,
		},
		{
			unpack_18_26bit_unsigned_6off,
			unpack_18_26bit_signed_6off,
		},
		{
			unpack_18_26bit_unsigned_7off,
			unpack_18_26bit_signed_7off,
		},
	},
	{
		{
			unpack_19_26bit_unsigned_0off,
			unpack_19_26bit_signed_0off,
		},
		{
			unpack_19_26bit_unsigned_1off,
			unpack_19_26bit_signed_1off,
		},
		{
			unpack_19_26bit_unsigned_2off,
			unpack_19_26bit_signed_2off,
		},
		{
			unpack_19_26bit_unsigned_3off,
			unpack_19_26bit_signed_3off,
		},
		{
			unpack_19_26bit_unsigned_4off,
			unpack_19_26bit_signed_4off,
		},
		{
			unpack_19_26bit_unsigned_5off,
			unpack_19_26bit_signed_5off,
		},
		{
			unpack_19_26bit_unsigned_6off,
			unpack_19_26bit_signed_6off,
		},
		{
			unpack_19_26bit_unsigned_7off,
			unpack_19_26bit_signed_7off,
		},
	},
};
