// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack27.h"



static void unpack_1_27bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit signed
	// Skip 0 bits, read 27 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit unsigned
	// Skip 0 bits, read 27 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit signed
	// Skip 1 bits, read 27 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit unsigned
	// Skip 1 bits, read 27 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit signed
	// Skip 2 bits, read 27 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit unsigned
	// Skip 2 bits, read 27 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit signed
	// Skip 3 bits, read 27 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit unsigned
	// Skip 3 bits, read 27 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit signed
	// Skip 4 bits, read 27 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit unsigned
	// Skip 4 bits, read 27 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit signed
	// Skip 5 bits, read 27 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit unsigned
	// Skip 5 bits, read 27 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit signed
	// Skip 6 bits, read 27 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit unsigned
	// Skip 6 bits, read 27 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit signed
	// Skip 7 bits, read 27 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);
}

static void unpack_1_27bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 27-bit unsigned
	// Skip 7 bits, read 27 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);
}

static void unpack_2_27bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit signed
	// Skip 0 bits, read 54 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit unsigned
	// Skip 0 bits, read 54 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit signed
	// Skip 1 bits, read 54 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit unsigned
	// Skip 1 bits, read 54 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit signed
	// Skip 2 bits, read 54 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit unsigned
	// Skip 2 bits, read 54 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit signed
	// Skip 3 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit unsigned
	// Skip 3 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit signed
	// Skip 4 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit unsigned
	// Skip 4 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit signed
	// Skip 5 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit unsigned
	// Skip 5 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit signed
	// Skip 6 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit unsigned
	// Skip 6 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit signed
	// Skip 7 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);
}

static void unpack_2_27bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 27-bit unsigned
	// Skip 7 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);
}

static void unpack_3_27bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit signed
	// Skip 0 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 54 to 80
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6) |
			((uint32_t)(input[10] & 0x80) >> 2);
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit unsigned
	// Skip 0 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 54 to 80
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6) |
			((uint32_t)(input[10] & 0x80) >> 2);
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit signed
	// Skip 1 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 55 to 81
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0xc0) >> 1);
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit unsigned
	// Skip 1 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 55 to 81
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0xc0) >> 1);
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit signed
	// Skip 2 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 56 to 82
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xe0));
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit unsigned
	// Skip 2 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 56 to 82
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xe0));
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit signed
	// Skip 3 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 57 to 83
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf0) << 1);
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit unsigned
	// Skip 3 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 57 to 83
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf0) << 1);
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit signed
	// Skip 4 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 58 to 84
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf8) << 2);
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit unsigned
	// Skip 4 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 58 to 84
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf8) << 2);
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit signed
	// Skip 5 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 59 to 85
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfc) << 3);
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit unsigned
	// Skip 5 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 59 to 85
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfc) << 3);
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit signed
	// Skip 6 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 60 to 86
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)(input[10] & 0xfe) << 4);
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit unsigned
	// Skip 6 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 60 to 86
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)(input[10] & 0xfe) << 4);
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit signed
	// Skip 7 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 61 to 87
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5);
	output[2] = (double)(value >> 5);
}

static void unpack_3_27bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 27-bit unsigned
	// Skip 7 bits, read 81 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 61 to 87
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5);
	output[2] = (double)(value >> 5);
}

static void unpack_4_27bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit signed
	// Skip 0 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 54 to 80
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6) |
			((uint32_t)(input[10] & 0x80) >> 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 81 to 107
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xf0) << 1);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit unsigned
	// Skip 0 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 54 to 80
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6) |
			((uint32_t)(input[10] & 0x80) >> 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 81 to 107
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xf0) << 1);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit signed
	// Skip 1 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 55 to 81
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0xc0) >> 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 82 to 108
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf8) << 2);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit unsigned
	// Skip 1 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 55 to 81
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0xc0) >> 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 82 to 108
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf8) << 2);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit signed
	// Skip 2 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 56 to 82
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xe0));
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 83 to 109
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xfc) << 3);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit unsigned
	// Skip 2 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 56 to 82
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xe0));
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 83 to 109
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xfc) << 3);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit signed
	// Skip 3 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 57 to 83
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf0) << 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 84 to 110
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfe) << 4);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit unsigned
	// Skip 3 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 57 to 83
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf0) << 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 84 to 110
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfe) << 4);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit signed
	// Skip 4 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 58 to 84
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf8) << 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 85 to 111
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit unsigned
	// Skip 4 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 58 to 84
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf8) << 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 85 to 111
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit signed
	// Skip 5 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 59 to 85
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfc) << 3);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 86 to 112
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0x80) >> 2);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit unsigned
	// Skip 5 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 59 to 85
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfc) << 3);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 86 to 112
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0x80) >> 2);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit signed
	// Skip 6 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 60 to 86
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)(input[10] & 0xfe) << 4);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 87 to 113
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xc0) >> 1);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit unsigned
	// Skip 6 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 60 to 86
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)(input[10] & 0xfe) << 4);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 87 to 113
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xc0) >> 1);
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit signed
	// Skip 7 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 61 to 87
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 88 to 114
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xe0));
	output[3] = (double)(value >> 5);
}

static void unpack_4_27bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 27-bit unsigned
	// Skip 7 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 61 to 87
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 88 to 114
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xe0));
	output[3] = (double)(value >> 5);
}

static void unpack_5_27bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit signed
	// Skip 0 bits, read 135 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 54 to 80
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6) |
			((uint32_t)(input[10] & 0x80) >> 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 81 to 107
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xf0) << 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 108 to 134
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfe) << 4);
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit unsigned
	// Skip 0 bits, read 135 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 54 to 80
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6) |
			((uint32_t)(input[10] & 0x80) >> 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 81 to 107
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xf0) << 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 108 to 134
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfe) << 4);
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit signed
	// Skip 1 bits, read 135 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 55 to 81
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0xc0) >> 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 82 to 108
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf8) << 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 109 to 135
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)input[16] << 5);
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit unsigned
	// Skip 1 bits, read 135 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 55 to 81
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0xc0) >> 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 82 to 108
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf8) << 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 109 to 135
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)input[16] << 5);
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit signed
	// Skip 2 bits, read 135 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 56 to 82
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xe0));
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 83 to 109
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xfc) << 3);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 110 to 136
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6) |
			((uint32_t)(input[17] & 0x80) >> 2);
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit unsigned
	// Skip 2 bits, read 135 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 56 to 82
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xe0));
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 83 to 109
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xfc) << 3);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 110 to 136
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6) |
			((uint32_t)(input[17] & 0x80) >> 2);
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit signed
	// Skip 3 bits, read 135 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 57 to 83
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf0) << 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 84 to 110
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfe) << 4);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 111 to 137
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0xc0) >> 1);
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit unsigned
	// Skip 3 bits, read 135 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 57 to 83
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf0) << 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 84 to 110
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfe) << 4);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 111 to 137
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0xc0) >> 1);
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit signed
	// Skip 4 bits, read 135 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 58 to 84
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf8) << 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 85 to 111
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 112 to 138
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xe0));
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit unsigned
	// Skip 4 bits, read 135 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 58 to 84
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf8) << 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 85 to 111
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 112 to 138
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xe0));
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit signed
	// Skip 5 bits, read 135 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 59 to 85
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfc) << 3);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 86 to 112
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0x80) >> 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 113 to 139
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf0) << 1);
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit unsigned
	// Skip 5 bits, read 135 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 59 to 85
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfc) << 3);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 86 to 112
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0x80) >> 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 113 to 139
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf0) << 1);
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit signed
	// Skip 6 bits, read 135 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 60 to 86
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)(input[10] & 0xfe) << 4);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 87 to 113
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xc0) >> 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 114 to 140
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xf8) << 2);
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit unsigned
	// Skip 6 bits, read 135 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 60 to 86
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)(input[10] & 0xfe) << 4);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 87 to 113
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xc0) >> 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 114 to 140
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xf8) << 2);
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit signed
	// Skip 7 bits, read 135 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 61 to 87
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 88 to 114
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xe0));
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 115 to 141
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfc) << 3);
	output[4] = (double)(value >> 5);
}

static void unpack_5_27bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 27-bit unsigned
	// Skip 7 bits, read 135 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 61 to 87
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 88 to 114
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xe0));
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 115 to 141
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfc) << 3);
	output[4] = (double)(value >> 5);
}

static void unpack_6_27bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit signed
	// Skip 0 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 54 to 80
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6) |
			((uint32_t)(input[10] & 0x80) >> 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 81 to 107
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xf0) << 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 108 to 134
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfe) << 4);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 135 to 161
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xc0) >> 1);
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit unsigned
	// Skip 0 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 54 to 80
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6) |
			((uint32_t)(input[10] & 0x80) >> 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 81 to 107
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xf0) << 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 108 to 134
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfe) << 4);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 135 to 161
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xc0) >> 1);
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit signed
	// Skip 1 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 55 to 81
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0xc0) >> 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 82 to 108
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf8) << 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 109 to 135
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)input[16] << 5);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 136 to 162
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xe0));
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit unsigned
	// Skip 1 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 55 to 81
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0xc0) >> 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 82 to 108
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf8) << 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 109 to 135
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)input[16] << 5);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 136 to 162
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xe0));
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit signed
	// Skip 2 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 56 to 82
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xe0));
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 83 to 109
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xfc) << 3);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 110 to 136
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6) |
			((uint32_t)(input[17] & 0x80) >> 2);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 137 to 163
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xf0) << 1);
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit unsigned
	// Skip 2 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 56 to 82
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xe0));
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 83 to 109
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xfc) << 3);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 110 to 136
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6) |
			((uint32_t)(input[17] & 0x80) >> 2);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 137 to 163
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xf0) << 1);
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit signed
	// Skip 3 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 57 to 83
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf0) << 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 84 to 110
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfe) << 4);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 111 to 137
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0xc0) >> 1);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 138 to 164
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10) |
			((uint32_t)(input[20] & 0xf8) << 2);
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit unsigned
	// Skip 3 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 57 to 83
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf0) << 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 84 to 110
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfe) << 4);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 111 to 137
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0xc0) >> 1);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 138 to 164
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10) |
			((uint32_t)(input[20] & 0xf8) << 2);
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit signed
	// Skip 4 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 58 to 84
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf8) << 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 85 to 111
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 112 to 138
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xe0));
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 139 to 165
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0xfc) << 3);
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit unsigned
	// Skip 4 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 58 to 84
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf8) << 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 85 to 111
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 112 to 138
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xe0));
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 139 to 165
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0xfc) << 3);
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit signed
	// Skip 5 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 59 to 85
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfc) << 3);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 86 to 112
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0x80) >> 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 113 to 139
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf0) << 1);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 140 to 166
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)(input[20] & 0xfe) << 4);
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit unsigned
	// Skip 5 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 59 to 85
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfc) << 3);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 86 to 112
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0x80) >> 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 113 to 139
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf0) << 1);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 140 to 166
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)(input[20] & 0xfe) << 4);
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit signed
	// Skip 6 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 60 to 86
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)(input[10] & 0xfe) << 4);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 87 to 113
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xc0) >> 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 114 to 140
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xf8) << 2);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 141 to 167
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5);
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit unsigned
	// Skip 6 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 60 to 86
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)(input[10] & 0xfe) << 4);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 87 to 113
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xc0) >> 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 114 to 140
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xf8) << 2);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 141 to 167
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5);
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit signed
	// Skip 7 bits, read 162 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 61 to 87
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 88 to 114
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xe0));
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 115 to 141
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfc) << 3);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 142 to 168
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0x80) >> 2);
	output[5] = (double)(value >> 5);
}

static void unpack_6_27bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 27-bit unsigned
	// Skip 7 bits, read 162 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 61 to 87
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 88 to 114
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xe0));
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 115 to 141
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfc) << 3);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 142 to 168
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0x80) >> 2);
	output[5] = (double)(value >> 5);
}

static void unpack_7_27bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit signed
	// Skip 0 bits, read 189 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 54 to 80
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6) |
			((uint32_t)(input[10] & 0x80) >> 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 81 to 107
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xf0) << 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 108 to 134
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfe) << 4);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 135 to 161
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xc0) >> 1);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 162 to 188
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf8) << 2);
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit unsigned
	// Skip 0 bits, read 189 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 54 to 80
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6) |
			((uint32_t)(input[10] & 0x80) >> 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 81 to 107
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xf0) << 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 108 to 134
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfe) << 4);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 135 to 161
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xc0) >> 1);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 162 to 188
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf8) << 2);
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit signed
	// Skip 1 bits, read 189 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 55 to 81
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0xc0) >> 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 82 to 108
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf8) << 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 109 to 135
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)input[16] << 5);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 136 to 162
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xe0));
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 163 to 189
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xfc) << 3);
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit unsigned
	// Skip 1 bits, read 189 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 55 to 81
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0xc0) >> 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 82 to 108
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf8) << 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 109 to 135
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)input[16] << 5);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 136 to 162
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xe0));
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 163 to 189
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xfc) << 3);
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit signed
	// Skip 2 bits, read 189 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 56 to 82
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xe0));
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 83 to 109
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xfc) << 3);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 110 to 136
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6) |
			((uint32_t)(input[17] & 0x80) >> 2);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 137 to 163
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xf0) << 1);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 164 to 190
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)(input[23] & 0xfe) << 4);
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit unsigned
	// Skip 2 bits, read 189 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 56 to 82
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xe0));
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 83 to 109
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xfc) << 3);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 110 to 136
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6) |
			((uint32_t)(input[17] & 0x80) >> 2);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 137 to 163
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xf0) << 1);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 164 to 190
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)(input[23] & 0xfe) << 4);
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit signed
	// Skip 3 bits, read 189 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 57 to 83
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf0) << 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 84 to 110
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfe) << 4);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 111 to 137
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0xc0) >> 1);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 138 to 164
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10) |
			((uint32_t)(input[20] & 0xf8) << 2);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 165 to 191
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5);
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit unsigned
	// Skip 3 bits, read 189 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 57 to 83
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf0) << 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 84 to 110
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfe) << 4);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 111 to 137
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0xc0) >> 1);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 138 to 164
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10) |
			((uint32_t)(input[20] & 0xf8) << 2);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 165 to 191
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5);
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit signed
	// Skip 4 bits, read 189 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 58 to 84
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf8) << 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 85 to 111
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 112 to 138
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xe0));
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 139 to 165
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0xfc) << 3);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 166 to 192
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0x80) >> 2);
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit unsigned
	// Skip 4 bits, read 189 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 58 to 84
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf8) << 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 85 to 111
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 112 to 138
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xe0));
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 139 to 165
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0xfc) << 3);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 166 to 192
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0x80) >> 2);
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit signed
	// Skip 5 bits, read 189 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 59 to 85
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfc) << 3);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 86 to 112
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0x80) >> 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 113 to 139
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf0) << 1);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 140 to 166
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)(input[20] & 0xfe) << 4);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 167 to 193
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xc0) >> 1);
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit unsigned
	// Skip 5 bits, read 189 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 59 to 85
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfc) << 3);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 86 to 112
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0x80) >> 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 113 to 139
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf0) << 1);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 140 to 166
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)(input[20] & 0xfe) << 4);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 167 to 193
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xc0) >> 1);
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit signed
	// Skip 6 bits, read 189 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 60 to 86
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)(input[10] & 0xfe) << 4);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 87 to 113
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xc0) >> 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 114 to 140
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xf8) << 2);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 141 to 167
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 168 to 194
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xe0));
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit unsigned
	// Skip 6 bits, read 189 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 60 to 86
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)(input[10] & 0xfe) << 4);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 87 to 113
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xc0) >> 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 114 to 140
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xf8) << 2);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 141 to 167
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 168 to 194
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xe0));
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit signed
	// Skip 7 bits, read 189 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 61 to 87
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 88 to 114
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xe0));
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 115 to 141
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfc) << 3);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 142 to 168
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0x80) >> 2);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 169 to 195
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf0) << 1);
	output[6] = (double)(value >> 5);
}

static void unpack_7_27bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 27-bit unsigned
	// Skip 7 bits, read 189 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 61 to 87
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 88 to 114
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xe0));
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 115 to 141
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfc) << 3);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 142 to 168
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0x80) >> 2);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 169 to 195
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf0) << 1);
	output[6] = (double)(value >> 5);
}

static void unpack_8_27bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit signed
	// Skip 0 bits, read 216 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 54 to 80
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6) |
			((uint32_t)(input[10] & 0x80) >> 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 81 to 107
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xf0) << 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 108 to 134
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfe) << 4);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 135 to 161
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xc0) >> 1);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 162 to 188
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf8) << 2);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 189 to 215
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)input[26] << 5);
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit unsigned
	// Skip 0 bits, read 216 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 26
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xe0));
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 27 to 53
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0xfc) << 3);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 54 to 80
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14) |
			((uint32_t)input[9] << 6) |
			((uint32_t)(input[10] & 0x80) >> 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 81 to 107
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)input[12] << 9) |
			((uint32_t)(input[13] & 0xf0) << 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 108 to 134
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0xfe) << 4);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 135 to 161
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xc0) >> 1);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 162 to 188
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)(input[23] & 0xf8) << 2);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 189 to 215
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)input[26] << 5);
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit signed
	// Skip 1 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 55 to 81
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0xc0) >> 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 82 to 108
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf8) << 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 109 to 135
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)input[16] << 5);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 136 to 162
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xe0));
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 163 to 189
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xfc) << 3);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 190 to 216
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22) |
			((uint32_t)input[25] << 14) |
			((uint32_t)input[26] << 6) |
			((uint32_t)(input[27] & 0x80) >> 2);
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit unsigned
	// Skip 1 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 27
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf0) << 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 28 to 54
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xfe) << 4);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 55 to 81
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)input[9] << 7) |
			((uint32_t)(input[10] & 0xc0) >> 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 82 to 108
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)input[12] << 10) |
			((uint32_t)(input[13] & 0xf8) << 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 109 to 135
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)input[16] << 5);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 136 to 162
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)input[19] << 8) |
			((uint32_t)(input[20] & 0xe0));
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 163 to 189
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)(input[23] & 0xfc) << 3);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 190 to 216
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22) |
			((uint32_t)input[25] << 14) |
			((uint32_t)input[26] << 6) |
			((uint32_t)(input[27] & 0x80) >> 2);
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit signed
	// Skip 2 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 56 to 82
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xe0));
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 83 to 109
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xfc) << 3);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 110 to 136
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6) |
			((uint32_t)(input[17] & 0x80) >> 2);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 137 to 163
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xf0) << 1);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 164 to 190
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)(input[23] & 0xfe) << 4);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 191 to 217
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)input[25] << 15) |
			((uint32_t)input[26] << 7) |
			((uint32_t)(input[27] & 0xc0) >> 1);
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit unsigned
	// Skip 2 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 28
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xf8) << 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 29 to 55
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 56 to 82
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xe0));
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 83 to 109
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)input[12] << 11) |
			((uint32_t)(input[13] & 0xfc) << 3);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 110 to 136
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)input[16] << 6) |
			((uint32_t)(input[17] & 0x80) >> 2);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 137 to 163
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)input[19] << 9) |
			((uint32_t)(input[20] & 0xf0) << 1);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 164 to 190
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)(input[23] & 0xfe) << 4);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 191 to 217
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)input[25] << 15) |
			((uint32_t)input[26] << 7) |
			((uint32_t)(input[27] & 0xc0) >> 1);
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit signed
	// Skip 3 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 57 to 83
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf0) << 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 84 to 110
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfe) << 4);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 111 to 137
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0xc0) >> 1);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 138 to 164
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10) |
			((uint32_t)(input[20] & 0xf8) << 2);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 165 to 191
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 192 to 218
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)(input[27] & 0xe0));
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit unsigned
	// Skip 3 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 29
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfc) << 3);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 30 to 56
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0x80) >> 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 57 to 83
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf0) << 1);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 84 to 110
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0xfe) << 4);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 111 to 137
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)input[16] << 7) |
			((uint32_t)(input[17] & 0xc0) >> 1);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 138 to 164
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10) |
			((uint32_t)(input[20] & 0xf8) << 2);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 165 to 191
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 192 to 218
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)(input[27] & 0xe0));
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit signed
	// Skip 4 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 58 to 84
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf8) << 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 85 to 111
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 112 to 138
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xe0));
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 139 to 165
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0xfc) << 3);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 166 to 192
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0x80) >> 2);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 193 to 219
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0xf0) << 1);
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit unsigned
	// Skip 4 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 30
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xfe) << 4);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 31 to 57
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xc0) >> 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 58 to 84
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xf8) << 2);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 85 to 111
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 112 to 138
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xe0));
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 139 to 165
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0xfc) << 3);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 166 to 192
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0x80) >> 2);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 193 to 219
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)(input[27] & 0xf0) << 1);
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit signed
	// Skip 5 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 59 to 85
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfc) << 3);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 86 to 112
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0x80) >> 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 113 to 139
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf0) << 1);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 140 to 166
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)(input[20] & 0xfe) << 4);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 167 to 193
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xc0) >> 1);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 194 to 220
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xf8) << 2);
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit unsigned
	// Skip 5 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 31
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 32 to 58
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xe0));
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 59 to 85
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfc) << 3);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 86 to 112
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0x80) >> 2);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 113 to 139
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf0) << 1);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 140 to 166
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)(input[20] & 0xfe) << 4);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 167 to 193
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xc0) >> 1);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 194 to 220
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)(input[27] & 0xf8) << 2);
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit signed
	// Skip 6 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 60 to 86
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)(input[10] & 0xfe) << 4);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 87 to 113
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xc0) >> 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 114 to 140
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xf8) << 2);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 141 to 167
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 168 to 194
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xe0));
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 195 to 221
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xfc) << 3);
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit unsigned
	// Skip 6 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 32
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0x80) >> 2);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 33 to 59
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf0) << 1);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 60 to 86
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)(input[10] & 0xfe) << 4);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 87 to 113
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xc0) >> 1);
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 114 to 140
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xf8) << 2);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 141 to 167
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 168 to 194
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xe0));
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 195 to 221
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)(input[27] & 0xfc) << 3);
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit signed
	// Skip 7 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 61 to 87
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 88 to 114
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xe0));
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 115 to 141
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfc) << 3);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 142 to 168
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0x80) >> 2);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 169 to 195
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf0) << 1);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 196 to 222
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xfe) << 4);
	output[7] = (double)(value >> 5);
}

static void unpack_8_27bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 27-bit unsigned
	// Skip 7 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 33
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xc0) >> 1);
	output[0] = (double)(value >> 5);

	// read output[1]: from bit 34 to 60
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xf8) << 2);
	output[1] = (double)(value >> 5);

	// read output[2]: from bit 61 to 87
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5);
	output[2] = (double)(value >> 5);

	// read output[3]: from bit 88 to 114
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xe0));
	output[3] = (double)(value >> 5);

	// read output[4]: from bit 115 to 141
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfc) << 3);
	output[4] = (double)(value >> 5);

	// read output[5]: from bit 142 to 168
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0x80) >> 2);
	output[5] = (double)(value >> 5);

	// read output[6]: from bit 169 to 195
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf0) << 1);
	output[6] = (double)(value >> 5);

	// read output[7]: from bit 196 to 222
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)(input[27] & 0xfe) << 4);
	output[7] = (double)(value >> 5);
}


unpack_func_t unpack_27bit[UNPACK_27BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_27bit_unsigned_0off,
			unpack_1_27bit_signed_0off,
		},
		{
			unpack_1_27bit_unsigned_1off,
			unpack_1_27bit_signed_1off,
		},
		{
			unpack_1_27bit_unsigned_2off,
			unpack_1_27bit_signed_2off,
		},
		{
			unpack_1_27bit_unsigned_3off,
			unpack_1_27bit_signed_3off,
		},
		{
			unpack_1_27bit_unsigned_4off,
			unpack_1_27bit_signed_4off,
		},
		{
			unpack_1_27bit_unsigned_5off,
			unpack_1_27bit_signed_5off,
		},
		{
			unpack_1_27bit_unsigned_6off,
			unpack_1_27bit_signed_6off,
		},
		{
			unpack_1_27bit_unsigned_7off,
			unpack_1_27bit_signed_7off,
		},
	},
	{
		{
			unpack_2_27bit_unsigned_0off,
			unpack_2_27bit_signed_0off,
		},
		{
			unpack_2_27bit_unsigned_1off,
			unpack_2_27bit_signed_1off,
		},
		{
			unpack_2_27bit_unsigned_2off,
			unpack_2_27bit_signed_2off,
		},
		{
			unpack_2_27bit_unsigned_3off,
			unpack_2_27bit_signed_3off,
		},
		{
			unpack_2_27bit_unsigned_4off,
			unpack_2_27bit_signed_4off,
		},
		{
			unpack_2_27bit_unsigned_5off,
			unpack_2_27bit_signed_5off,
		},
		{
			unpack_2_27bit_unsigned_6off,
			unpack_2_27bit_signed_6off,
		},
		{
			unpack_2_27bit_unsigned_7off,
			unpack_2_27bit_signed_7off,
		},
	},
	{
		{
			unpack_3_27bit_unsigned_0off,
			unpack_3_27bit_signed_0off,
		},
		{
			unpack_3_27bit_unsigned_1off,
			unpack_3_27bit_signed_1off,
		},
		{
			unpack_3_27bit_unsigned_2off,
			unpack_3_27bit_signed_2off,
		},
		{
			unpack_3_27bit_unsigned_3off,
			unpack_3_27bit_signed_3off,
		},
		{
			unpack_3_27bit_unsigned_4off,
			unpack_3_27bit_signed_4off,
		},
		{
			unpack_3_27bit_unsigned_5off,
			unpack_3_27bit_signed_5off,
		},
		{
			unpack_3_27bit_unsigned_6off,
			unpack_3_27bit_signed_6off,
		},
		{
			unpack_3_27bit_unsigned_7off,
			unpack_3_27bit_signed_7off,
		},
	},
	{
		{
			unpack_4_27bit_unsigned_0off,
			unpack_4_27bit_signed_0off,
		},
		{
			unpack_4_27bit_unsigned_1off,
			unpack_4_27bit_signed_1off,
		},
		{
			unpack_4_27bit_unsigned_2off,
			unpack_4_27bit_signed_2off,
		},
		{
			unpack_4_27bit_unsigned_3off,
			unpack_4_27bit_signed_3off,
		},
		{
			unpack_4_27bit_unsigned_4off,
			unpack_4_27bit_signed_4off,
		},
		{
			unpack_4_27bit_unsigned_5off,
			unpack_4_27bit_signed_5off,
		},
		{
			unpack_4_27bit_unsigned_6off,
			unpack_4_27bit_signed_6off,
		},
		{
			unpack_4_27bit_unsigned_7off,
			unpack_4_27bit_signed_7off,
		},
	},
	{
		{
			unpack_5_27bit_unsigned_0off,
			unpack_5_27bit_signed_0off,
		},
		{
			unpack_5_27bit_unsigned_1off,
			unpack_5_27bit_signed_1off,
		},
		{
			unpack_5_27bit_unsigned_2off,
			unpack_5_27bit_signed_2off,
		},
		{
			unpack_5_27bit_unsigned_3off,
			unpack_5_27bit_signed_3off,
		},
		{
			unpack_5_27bit_unsigned_4off,
			unpack_5_27bit_signed_4off,
		},
		{
			unpack_5_27bit_unsigned_5off,
			unpack_5_27bit_signed_5off,
		},
		{
			unpack_5_27bit_unsigned_6off,
			unpack_5_27bit_signed_6off,
		},
		{
			unpack_5_27bit_unsigned_7off,
			unpack_5_27bit_signed_7off,
		},
	},
	{
		{
			unpack_6_27bit_unsigned_0off,
			unpack_6_27bit_signed_0off,
		},
		{
			unpack_6_27bit_unsigned_1off,
			unpack_6_27bit_signed_1off,
		},
		{
			unpack_6_27bit_unsigned_2off,
			unpack_6_27bit_signed_2off,
		},
		{
			unpack_6_27bit_unsigned_3off,
			unpack_6_27bit_signed_3off,
		},
		{
			unpack_6_27bit_unsigned_4off,
			unpack_6_27bit_signed_4off,
		},
		{
			unpack_6_27bit_unsigned_5off,
			unpack_6_27bit_signed_5off,
		},
		{
			unpack_6_27bit_unsigned_6off,
			unpack_6_27bit_signed_6off,
		},
		{
			unpack_6_27bit_unsigned_7off,
			unpack_6_27bit_signed_7off,
		},
	},
	{
		{
			unpack_7_27bit_unsigned_0off,
			unpack_7_27bit_signed_0off,
		},
		{
			unpack_7_27bit_unsigned_1off,
			unpack_7_27bit_signed_1off,
		},
		{
			unpack_7_27bit_unsigned_2off,
			unpack_7_27bit_signed_2off,
		},
		{
			unpack_7_27bit_unsigned_3off,
			unpack_7_27bit_signed_3off,
		},
		{
			unpack_7_27bit_unsigned_4off,
			unpack_7_27bit_signed_4off,
		},
		{
			unpack_7_27bit_unsigned_5off,
			unpack_7_27bit_signed_5off,
		},
		{
			unpack_7_27bit_unsigned_6off,
			unpack_7_27bit_signed_6off,
		},
		{
			unpack_7_27bit_unsigned_7off,
			unpack_7_27bit_signed_7off,
		},
	},
	{
		{
			unpack_8_27bit_unsigned_0off,
			unpack_8_27bit_signed_0off,
		},
		{
			unpack_8_27bit_unsigned_1off,
			unpack_8_27bit_signed_1off,
		},
		{
			unpack_8_27bit_unsigned_2off,
			unpack_8_27bit_signed_2off,
		},
		{
			unpack_8_27bit_unsigned_3off,
			unpack_8_27bit_signed_3off,
		},
		{
			unpack_8_27bit_unsigned_4off,
			unpack_8_27bit_signed_4off,
		},
		{
			unpack_8_27bit_unsigned_5off,
			unpack_8_27bit_signed_5off,
		},
		{
			unpack_8_27bit_unsigned_6off,
			unpack_8_27bit_signed_6off,
		},
		{
			unpack_8_27bit_unsigned_7off,
			unpack_8_27bit_signed_7off,
		},
	},
};
