// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack28.h"



static void unpack_1_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);
}

static void unpack_1_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);
}

static void unpack_2_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 56 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 56 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);
}

static void unpack_2_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);
}

static void unpack_3_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);
}

static void unpack_3_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);
}

static void unpack_4_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 112 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 112 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);
}

static void unpack_4_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);
}

static void unpack_5_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);
}

static void unpack_5_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);
}

static void unpack_6_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 168 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 168 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);
}

static void unpack_6_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);
}

static void unpack_7_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 196 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 196 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 196 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 196 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 196 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);
}

static void unpack_7_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 196 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);
}

static void unpack_8_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 224 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 224 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);
}

static void unpack_8_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);
}

static void unpack_9_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);
}

static void unpack_9_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);
}

static void unpack_10_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 280 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 280 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);
}

static void unpack_10_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);
}

static void unpack_11_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);
}

static void unpack_11_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);
}

static void unpack_12_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 336 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 336 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);
}

static void unpack_12_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);
}

static void unpack_13_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 336 to 363
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xf0));
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 336 to 363
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xf0));
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 337 to 364
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xf8) << 1);
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 337 to 364
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xf8) << 1);
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 338 to 365
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xfc) << 2);
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 338 to 365
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xfc) << 2);
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 339 to 366
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xfe) << 3);
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 339 to 366
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xfe) << 3);
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 340 to 367
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)input[45] << 4);
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 364 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 340 to 367
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)input[45] << 4);
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 364 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 341 to 368
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)input[45] << 5) |
			((uint32_t)(input[46] & 0x80) >> 3);
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 364 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 341 to 368
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)input[45] << 5) |
			((uint32_t)(input[46] & 0x80) >> 3);
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 364 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 342 to 369
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6) |
			((uint32_t)(input[46] & 0xc0) >> 2);
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 364 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 342 to 369
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6) |
			((uint32_t)(input[46] & 0xc0) >> 2);
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 364 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 343 to 370
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0xe0) >> 1);
	output[12] = (double)(value >> 4);
}

static void unpack_13_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 364 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 343 to 370
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0xe0) >> 1);
	output[12] = (double)(value >> 4);
}

static void unpack_14_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 392 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 336 to 363
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xf0));
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 364 to 391
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4);
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 392 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 336 to 363
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xf0));
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 364 to 391
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4);
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 337 to 364
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xf8) << 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 365 to 392
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0x80) >> 3);
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 337 to 364
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xf8) << 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 365 to 392
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0x80) >> 3);
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 338 to 365
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xfc) << 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 366 to 393
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xc0) >> 2);
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 338 to 365
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xfc) << 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 366 to 393
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xc0) >> 2);
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 339 to 366
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xfe) << 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 367 to 394
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xe0) >> 1);
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 339 to 366
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xfe) << 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 367 to 394
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xe0) >> 1);
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 340 to 367
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)input[45] << 4);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 368 to 395
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xf0));
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 340 to 367
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)input[45] << 4);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 368 to 395
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xf0));
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 341 to 368
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)input[45] << 5) |
			((uint32_t)(input[46] & 0x80) >> 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 369 to 396
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xf8) << 1);
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 341 to 368
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)input[45] << 5) |
			((uint32_t)(input[46] & 0x80) >> 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 369 to 396
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xf8) << 1);
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 342 to 369
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6) |
			((uint32_t)(input[46] & 0xc0) >> 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 370 to 397
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xfc) << 2);
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 342 to 369
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6) |
			((uint32_t)(input[46] & 0xc0) >> 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 370 to 397
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xfc) << 2);
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 343 to 370
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0xe0) >> 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 371 to 398
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xfe) << 3);
	output[13] = (double)(value >> 4);
}

static void unpack_14_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 392 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 343 to 370
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0xe0) >> 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 371 to 398
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xfe) << 3);
	output[13] = (double)(value >> 4);
}

static void unpack_15_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 336 to 363
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xf0));
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 364 to 391
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 392 to 419
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xf0));
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 336 to 363
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xf0));
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 364 to 391
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 392 to 419
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xf0));
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 337 to 364
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xf8) << 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 365 to 392
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0x80) >> 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 393 to 420
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xf8) << 1);
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 337 to 364
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xf8) << 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 365 to 392
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0x80) >> 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 393 to 420
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xf8) << 1);
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 338 to 365
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xfc) << 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 366 to 393
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xc0) >> 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 394 to 421
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xfc) << 2);
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 338 to 365
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xfc) << 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 366 to 393
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xc0) >> 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 394 to 421
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xfc) << 2);
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 339 to 366
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xfe) << 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 367 to 394
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xe0) >> 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 395 to 422
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xfe) << 3);
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 339 to 366
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xfe) << 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 367 to 394
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xe0) >> 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 395 to 422
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xfe) << 3);
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 340 to 367
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)input[45] << 4);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 368 to 395
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xf0));
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 396 to 423
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4);
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 340 to 367
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)input[45] << 4);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 368 to 395
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xf0));
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 396 to 423
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4);
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 341 to 368
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)input[45] << 5) |
			((uint32_t)(input[46] & 0x80) >> 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 369 to 396
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xf8) << 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 397 to 424
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0x80) >> 3);
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 341 to 368
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)input[45] << 5) |
			((uint32_t)(input[46] & 0x80) >> 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 369 to 396
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xf8) << 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 397 to 424
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0x80) >> 3);
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 342 to 369
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6) |
			((uint32_t)(input[46] & 0xc0) >> 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 370 to 397
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xfc) << 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 398 to 425
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)input[52] << 6) |
			((uint32_t)(input[53] & 0xc0) >> 2);
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 342 to 369
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6) |
			((uint32_t)(input[46] & 0xc0) >> 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 370 to 397
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xfc) << 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 398 to 425
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)input[52] << 6) |
			((uint32_t)(input[53] & 0xc0) >> 2);
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 343 to 370
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0xe0) >> 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 371 to 398
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xfe) << 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 399 to 426
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)input[52] << 7) |
			((uint32_t)(input[53] & 0xe0) >> 1);
	output[14] = (double)(value >> 4);
}

static void unpack_15_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 343 to 370
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0xe0) >> 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 371 to 398
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xfe) << 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 399 to 426
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)input[52] << 7) |
			((uint32_t)(input[53] & 0xe0) >> 1);
	output[14] = (double)(value >> 4);
}

static void unpack_16_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 448 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 336 to 363
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xf0));
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 364 to 391
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 392 to 419
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xf0));
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 420 to 447
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4);
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 448 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 336 to 363
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xf0));
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 364 to 391
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 392 to 419
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xf0));
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 420 to 447
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4);
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 337 to 364
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xf8) << 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 365 to 392
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0x80) >> 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 393 to 420
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xf8) << 1);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 421 to 448
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0x80) >> 3);
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 337 to 364
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xf8) << 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 365 to 392
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0x80) >> 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 393 to 420
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xf8) << 1);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 421 to 448
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0x80) >> 3);
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 338 to 365
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xfc) << 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 366 to 393
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xc0) >> 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 394 to 421
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xfc) << 2);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 422 to 449
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xc0) >> 2);
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 338 to 365
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xfc) << 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 366 to 393
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xc0) >> 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 394 to 421
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xfc) << 2);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 422 to 449
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xc0) >> 2);
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 339 to 366
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xfe) << 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 367 to 394
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xe0) >> 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 395 to 422
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xfe) << 3);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 423 to 450
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xe0) >> 1);
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 339 to 366
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xfe) << 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 367 to 394
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xe0) >> 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 395 to 422
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xfe) << 3);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 423 to 450
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xe0) >> 1);
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 340 to 367
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)input[45] << 4);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 368 to 395
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xf0));
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 396 to 423
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 424 to 451
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)input[55] << 8) |
			((uint32_t)(input[56] & 0xf0));
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 340 to 367
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)input[45] << 4);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 368 to 395
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xf0));
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 396 to 423
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 424 to 451
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)input[55] << 8) |
			((uint32_t)(input[56] & 0xf0));
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 341 to 368
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)input[45] << 5) |
			((uint32_t)(input[46] & 0x80) >> 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 369 to 396
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xf8) << 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 397 to 424
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0x80) >> 3);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 425 to 452
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)input[55] << 9) |
			((uint32_t)(input[56] & 0xf8) << 1);
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 341 to 368
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)input[45] << 5) |
			((uint32_t)(input[46] & 0x80) >> 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 369 to 396
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xf8) << 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 397 to 424
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0x80) >> 3);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 425 to 452
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)input[55] << 9) |
			((uint32_t)(input[56] & 0xf8) << 1);
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 342 to 369
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6) |
			((uint32_t)(input[46] & 0xc0) >> 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 370 to 397
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xfc) << 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 398 to 425
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)input[52] << 6) |
			((uint32_t)(input[53] & 0xc0) >> 2);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 426 to 453
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)input[55] << 10) |
			((uint32_t)(input[56] & 0xfc) << 2);
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 342 to 369
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6) |
			((uint32_t)(input[46] & 0xc0) >> 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 370 to 397
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xfc) << 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 398 to 425
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)input[52] << 6) |
			((uint32_t)(input[53] & 0xc0) >> 2);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 426 to 453
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)input[55] << 10) |
			((uint32_t)(input[56] & 0xfc) << 2);
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 343 to 370
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0xe0) >> 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 371 to 398
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xfe) << 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 399 to 426
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)input[52] << 7) |
			((uint32_t)(input[53] & 0xe0) >> 1);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 427 to 454
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)input[55] << 11) |
			((uint32_t)(input[56] & 0xfe) << 3);
	output[15] = (double)(value >> 4);
}

static void unpack_16_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 343 to 370
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0xe0) >> 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 371 to 398
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xfe) << 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 399 to 426
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)input[52] << 7) |
			((uint32_t)(input[53] & 0xe0) >> 1);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 427 to 454
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)input[55] << 11) |
			((uint32_t)(input[56] & 0xfe) << 3);
	output[15] = (double)(value >> 4);
}

static void unpack_17_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 476 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 336 to 363
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xf0));
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 364 to 391
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 392 to 419
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xf0));
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 420 to 447
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 448 to 475
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)(input[59] & 0xf0));
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 476 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 336 to 363
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xf0));
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 364 to 391
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 392 to 419
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xf0));
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 420 to 447
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 448 to 475
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)(input[59] & 0xf0));
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 476 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 337 to 364
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xf8) << 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 365 to 392
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0x80) >> 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 393 to 420
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xf8) << 1);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 421 to 448
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0x80) >> 3);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 449 to 476
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)(input[59] & 0xf8) << 1);
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 476 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 337 to 364
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xf8) << 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 365 to 392
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0x80) >> 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 393 to 420
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xf8) << 1);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 421 to 448
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0x80) >> 3);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 449 to 476
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)(input[59] & 0xf8) << 1);
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 476 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 338 to 365
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xfc) << 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 366 to 393
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xc0) >> 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 394 to 421
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xfc) << 2);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 422 to 449
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xc0) >> 2);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 450 to 477
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)(input[59] & 0xfc) << 2);
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 476 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 338 to 365
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xfc) << 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 366 to 393
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xc0) >> 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 394 to 421
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xfc) << 2);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 422 to 449
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xc0) >> 2);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 450 to 477
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)(input[59] & 0xfc) << 2);
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 476 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 339 to 366
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xfe) << 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 367 to 394
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xe0) >> 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 395 to 422
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xfe) << 3);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 423 to 450
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xe0) >> 1);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 451 to 478
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)(input[59] & 0xfe) << 3);
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 476 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 339 to 366
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xfe) << 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 367 to 394
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xe0) >> 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 395 to 422
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xfe) << 3);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 423 to 450
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xe0) >> 1);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 451 to 478
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)(input[59] & 0xfe) << 3);
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 476 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 340 to 367
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)input[45] << 4);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 368 to 395
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xf0));
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 396 to 423
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 424 to 451
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)input[55] << 8) |
			((uint32_t)(input[56] & 0xf0));
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 452 to 479
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4);
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 476 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 340 to 367
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)input[45] << 4);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 368 to 395
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xf0));
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 396 to 423
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 424 to 451
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)input[55] << 8) |
			((uint32_t)(input[56] & 0xf0));
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 452 to 479
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4);
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 476 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 341 to 368
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)input[45] << 5) |
			((uint32_t)(input[46] & 0x80) >> 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 369 to 396
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xf8) << 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 397 to 424
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0x80) >> 3);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 425 to 452
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)input[55] << 9) |
			((uint32_t)(input[56] & 0xf8) << 1);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 453 to 480
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0x80) >> 3);
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 476 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 341 to 368
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)input[45] << 5) |
			((uint32_t)(input[46] & 0x80) >> 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 369 to 396
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xf8) << 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 397 to 424
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0x80) >> 3);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 425 to 452
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)input[55] << 9) |
			((uint32_t)(input[56] & 0xf8) << 1);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 453 to 480
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0x80) >> 3);
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 476 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 342 to 369
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6) |
			((uint32_t)(input[46] & 0xc0) >> 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 370 to 397
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xfc) << 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 398 to 425
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)input[52] << 6) |
			((uint32_t)(input[53] & 0xc0) >> 2);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 426 to 453
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)input[55] << 10) |
			((uint32_t)(input[56] & 0xfc) << 2);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 454 to 481
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xc0) >> 2);
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 476 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 342 to 369
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6) |
			((uint32_t)(input[46] & 0xc0) >> 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 370 to 397
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xfc) << 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 398 to 425
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)input[52] << 6) |
			((uint32_t)(input[53] & 0xc0) >> 2);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 426 to 453
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)input[55] << 10) |
			((uint32_t)(input[56] & 0xfc) << 2);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 454 to 481
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xc0) >> 2);
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 476 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 343 to 370
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0xe0) >> 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 371 to 398
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xfe) << 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 399 to 426
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)input[52] << 7) |
			((uint32_t)(input[53] & 0xe0) >> 1);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 427 to 454
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)input[55] << 11) |
			((uint32_t)(input[56] & 0xfe) << 3);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 455 to 482
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xe0) >> 1);
	output[16] = (double)(value >> 4);
}

static void unpack_17_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 476 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 343 to 370
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0xe0) >> 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 371 to 398
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xfe) << 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 399 to 426
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)input[52] << 7) |
			((uint32_t)(input[53] & 0xe0) >> 1);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 427 to 454
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)input[55] << 11) |
			((uint32_t)(input[56] & 0xfe) << 3);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 455 to 482
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xe0) >> 1);
	output[16] = (double)(value >> 4);
}

static void unpack_18_28bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit signed
	// Skip 0 bits, read 504 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 336 to 363
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xf0));
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 364 to 391
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 392 to 419
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xf0));
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 420 to 447
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 448 to 475
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)(input[59] & 0xf0));
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 476 to 503
	value = ((uint32_t)(input[59] & 0x0f) << 28) |
			((uint32_t)input[60] << 20) |
			((uint32_t)input[61] << 12) |
			((uint32_t)input[62] << 4);
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit unsigned
	// Skip 0 bits, read 504 bits of data.
	// Input must be at least 63 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 27
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf0));
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 28 to 55
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)input[6] << 4);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 56 to 83
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)input[9] << 8) |
			((uint32_t)(input[10] & 0xf0));
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 84 to 111
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)input[13] << 4);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 112 to 139
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)input[16] << 8) |
			((uint32_t)(input[17] & 0xf0));
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 140 to 167
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12) |
			((uint32_t)input[20] << 4);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 168 to 195
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)input[23] << 8) |
			((uint32_t)(input[24] & 0xf0));
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 196 to 223
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 224 to 251
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xf0));
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 252 to 279
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)input[33] << 12) |
			((uint32_t)input[34] << 4);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 280 to 307
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)input[37] << 8) |
			((uint32_t)(input[38] & 0xf0));
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 308 to 335
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)input[41] << 4);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 336 to 363
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xf0));
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 364 to 391
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 392 to 419
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xf0));
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 420 to 447
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 448 to 475
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)(input[59] & 0xf0));
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 476 to 503
	value = ((uint32_t)(input[59] & 0x0f) << 28) |
			((uint32_t)input[60] << 20) |
			((uint32_t)input[61] << 12) |
			((uint32_t)input[62] << 4);
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit signed
	// Skip 1 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 337 to 364
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xf8) << 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 365 to 392
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0x80) >> 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 393 to 420
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xf8) << 1);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 421 to 448
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0x80) >> 3);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 449 to 476
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)(input[59] & 0xf8) << 1);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 477 to 504
	value = ((uint32_t)(input[59] & 0x07) << 29) |
			((uint32_t)input[60] << 21) |
			((uint32_t)input[61] << 13) |
			((uint32_t)input[62] << 5) |
			((uint32_t)(input[63] & 0x80) >> 3);
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit unsigned
	// Skip 1 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 28
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xf8) << 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 29 to 56
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0x80) >> 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 57 to 84
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)input[9] << 9) |
			((uint32_t)(input[10] & 0xf8) << 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 85 to 112
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)input[13] << 5) |
			((uint32_t)(input[14] & 0x80) >> 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 113 to 140
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)input[16] << 9) |
			((uint32_t)(input[17] & 0xf8) << 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 141 to 168
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)input[20] << 5) |
			((uint32_t)(input[21] & 0x80) >> 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 169 to 196
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)input[23] << 9) |
			((uint32_t)(input[24] & 0xf8) << 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 197 to 224
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0x80) >> 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 225 to 252
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)(input[31] & 0xf8) << 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 253 to 280
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)input[33] << 13) |
			((uint32_t)input[34] << 5) |
			((uint32_t)(input[35] & 0x80) >> 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 281 to 308
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)input[37] << 9) |
			((uint32_t)(input[38] & 0xf8) << 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 309 to 336
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)input[41] << 5) |
			((uint32_t)(input[42] & 0x80) >> 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 337 to 364
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xf8) << 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 365 to 392
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0x80) >> 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 393 to 420
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xf8) << 1);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 421 to 448
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0x80) >> 3);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 449 to 476
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)(input[59] & 0xf8) << 1);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 477 to 504
	value = ((uint32_t)(input[59] & 0x07) << 29) |
			((uint32_t)input[60] << 21) |
			((uint32_t)input[61] << 13) |
			((uint32_t)input[62] << 5) |
			((uint32_t)(input[63] & 0x80) >> 3);
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit signed
	// Skip 2 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 338 to 365
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xfc) << 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 366 to 393
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xc0) >> 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 394 to 421
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xfc) << 2);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 422 to 449
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xc0) >> 2);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 450 to 477
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)(input[59] & 0xfc) << 2);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 478 to 505
	value = ((uint32_t)(input[59] & 0x03) << 30) |
			((uint32_t)input[60] << 22) |
			((uint32_t)input[61] << 14) |
			((uint32_t)input[62] << 6) |
			((uint32_t)(input[63] & 0xc0) >> 2);
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit unsigned
	// Skip 2 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 29
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfc) << 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 30 to 57
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xc0) >> 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 58 to 85
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfc) << 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 86 to 113
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)input[13] << 6) |
			((uint32_t)(input[14] & 0xc0) >> 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 114 to 141
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10) |
			((uint32_t)(input[17] & 0xfc) << 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 142 to 169
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)input[20] << 6) |
			((uint32_t)(input[21] & 0xc0) >> 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 170 to 197
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18) |
			((uint32_t)input[23] << 10) |
			((uint32_t)(input[24] & 0xfc) << 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 198 to 225
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xc0) >> 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 226 to 253
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)(input[31] & 0xfc) << 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 254 to 281
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14) |
			((uint32_t)input[34] << 6) |
			((uint32_t)(input[35] & 0xc0) >> 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 282 to 309
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)input[37] << 10) |
			((uint32_t)(input[38] & 0xfc) << 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 310 to 337
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)input[41] << 6) |
			((uint32_t)(input[42] & 0xc0) >> 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 338 to 365
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)input[44] << 10) |
			((uint32_t)(input[45] & 0xfc) << 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 366 to 393
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xc0) >> 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 394 to 421
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)(input[52] & 0xfc) << 2);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 422 to 449
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xc0) >> 2);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 450 to 477
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)(input[59] & 0xfc) << 2);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 478 to 505
	value = ((uint32_t)(input[59] & 0x03) << 30) |
			((uint32_t)input[60] << 22) |
			((uint32_t)input[61] << 14) |
			((uint32_t)input[62] << 6) |
			((uint32_t)(input[63] & 0xc0) >> 2);
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit signed
	// Skip 3 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 339 to 366
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xfe) << 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 367 to 394
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xe0) >> 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 395 to 422
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xfe) << 3);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 423 to 450
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xe0) >> 1);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 451 to 478
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)(input[59] & 0xfe) << 3);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 479 to 506
	value = ((uint32_t)(input[59] & 0x01) << 31) |
			((uint32_t)input[60] << 23) |
			((uint32_t)input[61] << 15) |
			((uint32_t)input[62] << 7) |
			((uint32_t)(input[63] & 0xe0) >> 1);
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit unsigned
	// Skip 3 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 30
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0xfe) << 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 31 to 58
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xe0) >> 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 59 to 86
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)(input[10] & 0xfe) << 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 87 to 114
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xe0) >> 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 115 to 142
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0xfe) << 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 143 to 170
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)input[20] << 7) |
			((uint32_t)(input[21] & 0xe0) >> 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 171 to 198
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)input[23] << 11) |
			((uint32_t)(input[24] & 0xfe) << 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 199 to 226
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xe0) >> 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 227 to 254
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0xfe) << 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 255 to 282
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)input[34] << 7) |
			((uint32_t)(input[35] & 0xe0) >> 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 283 to 310
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)input[37] << 11) |
			((uint32_t)(input[38] & 0xfe) << 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 311 to 338
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)input[41] << 7) |
			((uint32_t)(input[42] & 0xe0) >> 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 339 to 366
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)input[44] << 11) |
			((uint32_t)(input[45] & 0xfe) << 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 367 to 394
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xe0) >> 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 395 to 422
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)(input[52] & 0xfe) << 3);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 423 to 450
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xe0) >> 1);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 451 to 478
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)(input[59] & 0xfe) << 3);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 479 to 506
	value = ((uint32_t)(input[59] & 0x01) << 31) |
			((uint32_t)input[60] << 23) |
			((uint32_t)input[61] << 15) |
			((uint32_t)input[62] << 7) |
			((uint32_t)(input[63] & 0xe0) >> 1);
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit signed
	// Skip 4 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 340 to 367
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)input[45] << 4);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 368 to 395
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xf0));
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 396 to 423
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 424 to 451
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)input[55] << 8) |
			((uint32_t)(input[56] & 0xf0));
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 452 to 479
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 480 to 507
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)(input[63] & 0xf0));
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit unsigned
	// Skip 4 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 31
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 32 to 59
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf0));
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 60 to 87
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 88 to 115
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf0));
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 116 to 143
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 144 to 171
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)input[20] << 8) |
			((uint32_t)(input[21] & 0xf0));
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 172 to 199
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)input[23] << 12) |
			((uint32_t)input[24] << 4);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 200 to 227
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)input[27] << 8) |
			((uint32_t)(input[28] & 0xf0));
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 228 to 255
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 256 to 283
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)(input[35] & 0xf0));
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 284 to 311
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12) |
			((uint32_t)input[38] << 4);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 312 to 339
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)input[41] << 8) |
			((uint32_t)(input[42] & 0xf0));
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 340 to 367
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12) |
			((uint32_t)input[45] << 4);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 368 to 395
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16) |
			((uint32_t)input[48] << 8) |
			((uint32_t)(input[49] & 0xf0));
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 396 to 423
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 424 to 451
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)input[55] << 8) |
			((uint32_t)(input[56] & 0xf0));
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 452 to 479
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 480 to 507
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)(input[63] & 0xf0));
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit signed
	// Skip 5 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 341 to 368
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)input[45] << 5) |
			((uint32_t)(input[46] & 0x80) >> 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 369 to 396
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xf8) << 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 397 to 424
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0x80) >> 3);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 425 to 452
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)input[55] << 9) |
			((uint32_t)(input[56] & 0xf8) << 1);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 453 to 480
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0x80) >> 3);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 481 to 508
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)(input[63] & 0xf8) << 1);
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit unsigned
	// Skip 5 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 32
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0x80) >> 3);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 33 to 60
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xf8) << 1);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 61 to 88
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0x80) >> 3);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 89 to 116
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xf8) << 1);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 117 to 144
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0x80) >> 3);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 145 to 172
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xf8) << 1);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 173 to 200
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)input[23] << 13) |
			((uint32_t)input[24] << 5) |
			((uint32_t)(input[25] & 0x80) >> 3);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 201 to 228
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)input[27] << 9) |
			((uint32_t)(input[28] & 0xf8) << 1);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 229 to 256
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0x80) >> 3);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 257 to 284
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)(input[35] & 0xf8) << 1);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 285 to 312
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)input[38] << 5) |
			((uint32_t)(input[39] & 0x80) >> 3);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 313 to 340
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)input[41] << 9) |
			((uint32_t)(input[42] & 0xf8) << 1);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 341 to 368
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)input[45] << 5) |
			((uint32_t)(input[46] & 0x80) >> 3);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 369 to 396
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)input[48] << 9) |
			((uint32_t)(input[49] & 0xf8) << 1);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 397 to 424
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0x80) >> 3);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 425 to 452
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)input[55] << 9) |
			((uint32_t)(input[56] & 0xf8) << 1);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 453 to 480
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0x80) >> 3);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 481 to 508
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)(input[63] & 0xf8) << 1);
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit signed
	// Skip 6 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 342 to 369
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6) |
			((uint32_t)(input[46] & 0xc0) >> 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 370 to 397
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xfc) << 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 398 to 425
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)input[52] << 6) |
			((uint32_t)(input[53] & 0xc0) >> 2);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 426 to 453
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)input[55] << 10) |
			((uint32_t)(input[56] & 0xfc) << 2);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 454 to 481
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xc0) >> 2);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 482 to 509
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)(input[63] & 0xfc) << 2);
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit unsigned
	// Skip 6 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 33
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xc0) >> 2);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 34 to 61
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfc) << 2);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 62 to 89
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xc0) >> 2);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 90 to 117
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfc) << 2);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 118 to 145
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xc0) >> 2);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 146 to 173
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfc) << 2);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 174 to 201
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xc0) >> 2);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 202 to 229
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10) |
			((uint32_t)(input[28] & 0xfc) << 2);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 230 to 257
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xc0) >> 2);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 258 to 285
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)(input[35] & 0xfc) << 2);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 286 to 313
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)input[38] << 6) |
			((uint32_t)(input[39] & 0xc0) >> 2);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 314 to 341
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10) |
			((uint32_t)(input[42] & 0xfc) << 2);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 342 to 369
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)input[45] << 6) |
			((uint32_t)(input[46] & 0xc0) >> 2);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 370 to 397
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)input[48] << 10) |
			((uint32_t)(input[49] & 0xfc) << 2);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 398 to 425
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)input[52] << 6) |
			((uint32_t)(input[53] & 0xc0) >> 2);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 426 to 453
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)input[55] << 10) |
			((uint32_t)(input[56] & 0xfc) << 2);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 454 to 481
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xc0) >> 2);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 482 to 509
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)(input[63] & 0xfc) << 2);
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit signed
	// Skip 7 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 343 to 370
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0xe0) >> 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 371 to 398
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xfe) << 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 399 to 426
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)input[52] << 7) |
			((uint32_t)(input[53] & 0xe0) >> 1);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 427 to 454
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)input[55] << 11) |
			((uint32_t)(input[56] & 0xfe) << 3);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 455 to 482
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xe0) >> 1);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 483 to 510
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)(input[63] & 0xfe) << 3);
	output[17] = (double)(value >> 4);
}

static void unpack_18_28bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 28-bit unsigned
	// Skip 7 bits, read 504 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 34
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xe0) >> 1);
	output[0] = (double)(value >> 4);

	// read output[1]: from bit 35 to 62
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)(input[7] & 0xfe) << 3);
	output[1] = (double)(value >> 4);

	// read output[2]: from bit 63 to 90
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xe0) >> 1);
	output[2] = (double)(value >> 4);

	// read output[3]: from bit 91 to 118
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0xfe) << 3);
	output[3] = (double)(value >> 4);

	// read output[4]: from bit 119 to 146
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xe0) >> 1);
	output[4] = (double)(value >> 4);

	// read output[5]: from bit 147 to 174
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)(input[21] & 0xfe) << 3);
	output[5] = (double)(value >> 4);

	// read output[6]: from bit 175 to 202
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xe0) >> 1);
	output[6] = (double)(value >> 4);

	// read output[7]: from bit 203 to 230
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0xfe) << 3);
	output[7] = (double)(value >> 4);

	// read output[8]: from bit 231 to 258
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xe0) >> 1);
	output[8] = (double)(value >> 4);

	// read output[9]: from bit 259 to 286
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)(input[35] & 0xfe) << 3);
	output[9] = (double)(value >> 4);

	// read output[10]: from bit 287 to 314
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)input[38] << 7) |
			((uint32_t)(input[39] & 0xe0) >> 1);
	output[10] = (double)(value >> 4);

	// read output[11]: from bit 315 to 342
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0xfe) << 3);
	output[11] = (double)(value >> 4);

	// read output[12]: from bit 343 to 370
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)input[45] << 7) |
			((uint32_t)(input[46] & 0xe0) >> 1);
	output[12] = (double)(value >> 4);

	// read output[13]: from bit 371 to 398
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)input[48] << 11) |
			((uint32_t)(input[49] & 0xfe) << 3);
	output[13] = (double)(value >> 4);

	// read output[14]: from bit 399 to 426
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)input[52] << 7) |
			((uint32_t)(input[53] & 0xe0) >> 1);
	output[14] = (double)(value >> 4);

	// read output[15]: from bit 427 to 454
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)input[55] << 11) |
			((uint32_t)(input[56] & 0xfe) << 3);
	output[15] = (double)(value >> 4);

	// read output[16]: from bit 455 to 482
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xe0) >> 1);
	output[16] = (double)(value >> 4);

	// read output[17]: from bit 483 to 510
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)(input[63] & 0xfe) << 3);
	output[17] = (double)(value >> 4);
}


unpack_func_t unpack_28bit[UNPACK_28BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_28bit_unsigned_0off,
			unpack_1_28bit_signed_0off,
		},
		{
			unpack_1_28bit_unsigned_1off,
			unpack_1_28bit_signed_1off,
		},
		{
			unpack_1_28bit_unsigned_2off,
			unpack_1_28bit_signed_2off,
		},
		{
			unpack_1_28bit_unsigned_3off,
			unpack_1_28bit_signed_3off,
		},
		{
			unpack_1_28bit_unsigned_4off,
			unpack_1_28bit_signed_4off,
		},
		{
			unpack_1_28bit_unsigned_5off,
			unpack_1_28bit_signed_5off,
		},
		{
			unpack_1_28bit_unsigned_6off,
			unpack_1_28bit_signed_6off,
		},
		{
			unpack_1_28bit_unsigned_7off,
			unpack_1_28bit_signed_7off,
		},
	},
	{
		{
			unpack_2_28bit_unsigned_0off,
			unpack_2_28bit_signed_0off,
		},
		{
			unpack_2_28bit_unsigned_1off,
			unpack_2_28bit_signed_1off,
		},
		{
			unpack_2_28bit_unsigned_2off,
			unpack_2_28bit_signed_2off,
		},
		{
			unpack_2_28bit_unsigned_3off,
			unpack_2_28bit_signed_3off,
		},
		{
			unpack_2_28bit_unsigned_4off,
			unpack_2_28bit_signed_4off,
		},
		{
			unpack_2_28bit_unsigned_5off,
			unpack_2_28bit_signed_5off,
		},
		{
			unpack_2_28bit_unsigned_6off,
			unpack_2_28bit_signed_6off,
		},
		{
			unpack_2_28bit_unsigned_7off,
			unpack_2_28bit_signed_7off,
		},
	},
	{
		{
			unpack_3_28bit_unsigned_0off,
			unpack_3_28bit_signed_0off,
		},
		{
			unpack_3_28bit_unsigned_1off,
			unpack_3_28bit_signed_1off,
		},
		{
			unpack_3_28bit_unsigned_2off,
			unpack_3_28bit_signed_2off,
		},
		{
			unpack_3_28bit_unsigned_3off,
			unpack_3_28bit_signed_3off,
		},
		{
			unpack_3_28bit_unsigned_4off,
			unpack_3_28bit_signed_4off,
		},
		{
			unpack_3_28bit_unsigned_5off,
			unpack_3_28bit_signed_5off,
		},
		{
			unpack_3_28bit_unsigned_6off,
			unpack_3_28bit_signed_6off,
		},
		{
			unpack_3_28bit_unsigned_7off,
			unpack_3_28bit_signed_7off,
		},
	},
	{
		{
			unpack_4_28bit_unsigned_0off,
			unpack_4_28bit_signed_0off,
		},
		{
			unpack_4_28bit_unsigned_1off,
			unpack_4_28bit_signed_1off,
		},
		{
			unpack_4_28bit_unsigned_2off,
			unpack_4_28bit_signed_2off,
		},
		{
			unpack_4_28bit_unsigned_3off,
			unpack_4_28bit_signed_3off,
		},
		{
			unpack_4_28bit_unsigned_4off,
			unpack_4_28bit_signed_4off,
		},
		{
			unpack_4_28bit_unsigned_5off,
			unpack_4_28bit_signed_5off,
		},
		{
			unpack_4_28bit_unsigned_6off,
			unpack_4_28bit_signed_6off,
		},
		{
			unpack_4_28bit_unsigned_7off,
			unpack_4_28bit_signed_7off,
		},
	},
	{
		{
			unpack_5_28bit_unsigned_0off,
			unpack_5_28bit_signed_0off,
		},
		{
			unpack_5_28bit_unsigned_1off,
			unpack_5_28bit_signed_1off,
		},
		{
			unpack_5_28bit_unsigned_2off,
			unpack_5_28bit_signed_2off,
		},
		{
			unpack_5_28bit_unsigned_3off,
			unpack_5_28bit_signed_3off,
		},
		{
			unpack_5_28bit_unsigned_4off,
			unpack_5_28bit_signed_4off,
		},
		{
			unpack_5_28bit_unsigned_5off,
			unpack_5_28bit_signed_5off,
		},
		{
			unpack_5_28bit_unsigned_6off,
			unpack_5_28bit_signed_6off,
		},
		{
			unpack_5_28bit_unsigned_7off,
			unpack_5_28bit_signed_7off,
		},
	},
	{
		{
			unpack_6_28bit_unsigned_0off,
			unpack_6_28bit_signed_0off,
		},
		{
			unpack_6_28bit_unsigned_1off,
			unpack_6_28bit_signed_1off,
		},
		{
			unpack_6_28bit_unsigned_2off,
			unpack_6_28bit_signed_2off,
		},
		{
			unpack_6_28bit_unsigned_3off,
			unpack_6_28bit_signed_3off,
		},
		{
			unpack_6_28bit_unsigned_4off,
			unpack_6_28bit_signed_4off,
		},
		{
			unpack_6_28bit_unsigned_5off,
			unpack_6_28bit_signed_5off,
		},
		{
			unpack_6_28bit_unsigned_6off,
			unpack_6_28bit_signed_6off,
		},
		{
			unpack_6_28bit_unsigned_7off,
			unpack_6_28bit_signed_7off,
		},
	},
	{
		{
			unpack_7_28bit_unsigned_0off,
			unpack_7_28bit_signed_0off,
		},
		{
			unpack_7_28bit_unsigned_1off,
			unpack_7_28bit_signed_1off,
		},
		{
			unpack_7_28bit_unsigned_2off,
			unpack_7_28bit_signed_2off,
		},
		{
			unpack_7_28bit_unsigned_3off,
			unpack_7_28bit_signed_3off,
		},
		{
			unpack_7_28bit_unsigned_4off,
			unpack_7_28bit_signed_4off,
		},
		{
			unpack_7_28bit_unsigned_5off,
			unpack_7_28bit_signed_5off,
		},
		{
			unpack_7_28bit_unsigned_6off,
			unpack_7_28bit_signed_6off,
		},
		{
			unpack_7_28bit_unsigned_7off,
			unpack_7_28bit_signed_7off,
		},
	},
	{
		{
			unpack_8_28bit_unsigned_0off,
			unpack_8_28bit_signed_0off,
		},
		{
			unpack_8_28bit_unsigned_1off,
			unpack_8_28bit_signed_1off,
		},
		{
			unpack_8_28bit_unsigned_2off,
			unpack_8_28bit_signed_2off,
		},
		{
			unpack_8_28bit_unsigned_3off,
			unpack_8_28bit_signed_3off,
		},
		{
			unpack_8_28bit_unsigned_4off,
			unpack_8_28bit_signed_4off,
		},
		{
			unpack_8_28bit_unsigned_5off,
			unpack_8_28bit_signed_5off,
		},
		{
			unpack_8_28bit_unsigned_6off,
			unpack_8_28bit_signed_6off,
		},
		{
			unpack_8_28bit_unsigned_7off,
			unpack_8_28bit_signed_7off,
		},
	},
	{
		{
			unpack_9_28bit_unsigned_0off,
			unpack_9_28bit_signed_0off,
		},
		{
			unpack_9_28bit_unsigned_1off,
			unpack_9_28bit_signed_1off,
		},
		{
			unpack_9_28bit_unsigned_2off,
			unpack_9_28bit_signed_2off,
		},
		{
			unpack_9_28bit_unsigned_3off,
			unpack_9_28bit_signed_3off,
		},
		{
			unpack_9_28bit_unsigned_4off,
			unpack_9_28bit_signed_4off,
		},
		{
			unpack_9_28bit_unsigned_5off,
			unpack_9_28bit_signed_5off,
		},
		{
			unpack_9_28bit_unsigned_6off,
			unpack_9_28bit_signed_6off,
		},
		{
			unpack_9_28bit_unsigned_7off,
			unpack_9_28bit_signed_7off,
		},
	},
	{
		{
			unpack_10_28bit_unsigned_0off,
			unpack_10_28bit_signed_0off,
		},
		{
			unpack_10_28bit_unsigned_1off,
			unpack_10_28bit_signed_1off,
		},
		{
			unpack_10_28bit_unsigned_2off,
			unpack_10_28bit_signed_2off,
		},
		{
			unpack_10_28bit_unsigned_3off,
			unpack_10_28bit_signed_3off,
		},
		{
			unpack_10_28bit_unsigned_4off,
			unpack_10_28bit_signed_4off,
		},
		{
			unpack_10_28bit_unsigned_5off,
			unpack_10_28bit_signed_5off,
		},
		{
			unpack_10_28bit_unsigned_6off,
			unpack_10_28bit_signed_6off,
		},
		{
			unpack_10_28bit_unsigned_7off,
			unpack_10_28bit_signed_7off,
		},
	},
	{
		{
			unpack_11_28bit_unsigned_0off,
			unpack_11_28bit_signed_0off,
		},
		{
			unpack_11_28bit_unsigned_1off,
			unpack_11_28bit_signed_1off,
		},
		{
			unpack_11_28bit_unsigned_2off,
			unpack_11_28bit_signed_2off,
		},
		{
			unpack_11_28bit_unsigned_3off,
			unpack_11_28bit_signed_3off,
		},
		{
			unpack_11_28bit_unsigned_4off,
			unpack_11_28bit_signed_4off,
		},
		{
			unpack_11_28bit_unsigned_5off,
			unpack_11_28bit_signed_5off,
		},
		{
			unpack_11_28bit_unsigned_6off,
			unpack_11_28bit_signed_6off,
		},
		{
			unpack_11_28bit_unsigned_7off,
			unpack_11_28bit_signed_7off,
		},
	},
	{
		{
			unpack_12_28bit_unsigned_0off,
			unpack_12_28bit_signed_0off,
		},
		{
			unpack_12_28bit_unsigned_1off,
			unpack_12_28bit_signed_1off,
		},
		{
			unpack_12_28bit_unsigned_2off,
			unpack_12_28bit_signed_2off,
		},
		{
			unpack_12_28bit_unsigned_3off,
			unpack_12_28bit_signed_3off,
		},
		{
			unpack_12_28bit_unsigned_4off,
			unpack_12_28bit_signed_4off,
		},
		{
			unpack_12_28bit_unsigned_5off,
			unpack_12_28bit_signed_5off,
		},
		{
			unpack_12_28bit_unsigned_6off,
			unpack_12_28bit_signed_6off,
		},
		{
			unpack_12_28bit_unsigned_7off,
			unpack_12_28bit_signed_7off,
		},
	},
	{
		{
			unpack_13_28bit_unsigned_0off,
			unpack_13_28bit_signed_0off,
		},
		{
			unpack_13_28bit_unsigned_1off,
			unpack_13_28bit_signed_1off,
		},
		{
			unpack_13_28bit_unsigned_2off,
			unpack_13_28bit_signed_2off,
		},
		{
			unpack_13_28bit_unsigned_3off,
			unpack_13_28bit_signed_3off,
		},
		{
			unpack_13_28bit_unsigned_4off,
			unpack_13_28bit_signed_4off,
		},
		{
			unpack_13_28bit_unsigned_5off,
			unpack_13_28bit_signed_5off,
		},
		{
			unpack_13_28bit_unsigned_6off,
			unpack_13_28bit_signed_6off,
		},
		{
			unpack_13_28bit_unsigned_7off,
			unpack_13_28bit_signed_7off,
		},
	},
	{
		{
			unpack_14_28bit_unsigned_0off,
			unpack_14_28bit_signed_0off,
		},
		{
			unpack_14_28bit_unsigned_1off,
			unpack_14_28bit_signed_1off,
		},
		{
			unpack_14_28bit_unsigned_2off,
			unpack_14_28bit_signed_2off,
		},
		{
			unpack_14_28bit_unsigned_3off,
			unpack_14_28bit_signed_3off,
		},
		{
			unpack_14_28bit_unsigned_4off,
			unpack_14_28bit_signed_4off,
		},
		{
			unpack_14_28bit_unsigned_5off,
			unpack_14_28bit_signed_5off,
		},
		{
			unpack_14_28bit_unsigned_6off,
			unpack_14_28bit_signed_6off,
		},
		{
			unpack_14_28bit_unsigned_7off,
			unpack_14_28bit_signed_7off,
		},
	},
	{
		{
			unpack_15_28bit_unsigned_0off,
			unpack_15_28bit_signed_0off,
		},
		{
			unpack_15_28bit_unsigned_1off,
			unpack_15_28bit_signed_1off,
		},
		{
			unpack_15_28bit_unsigned_2off,
			unpack_15_28bit_signed_2off,
		},
		{
			unpack_15_28bit_unsigned_3off,
			unpack_15_28bit_signed_3off,
		},
		{
			unpack_15_28bit_unsigned_4off,
			unpack_15_28bit_signed_4off,
		},
		{
			unpack_15_28bit_unsigned_5off,
			unpack_15_28bit_signed_5off,
		},
		{
			unpack_15_28bit_unsigned_6off,
			unpack_15_28bit_signed_6off,
		},
		{
			unpack_15_28bit_unsigned_7off,
			unpack_15_28bit_signed_7off,
		},
	},
	{
		{
			unpack_16_28bit_unsigned_0off,
			unpack_16_28bit_signed_0off,
		},
		{
			unpack_16_28bit_unsigned_1off,
			unpack_16_28bit_signed_1off,
		},
		{
			unpack_16_28bit_unsigned_2off,
			unpack_16_28bit_signed_2off,
		},
		{
			unpack_16_28bit_unsigned_3off,
			unpack_16_28bit_signed_3off,
		},
		{
			unpack_16_28bit_unsigned_4off,
			unpack_16_28bit_signed_4off,
		},
		{
			unpack_16_28bit_unsigned_5off,
			unpack_16_28bit_signed_5off,
		},
		{
			unpack_16_28bit_unsigned_6off,
			unpack_16_28bit_signed_6off,
		},
		{
			unpack_16_28bit_unsigned_7off,
			unpack_16_28bit_signed_7off,
		},
	},
	{
		{
			unpack_17_28bit_unsigned_0off,
			unpack_17_28bit_signed_0off,
		},
		{
			unpack_17_28bit_unsigned_1off,
			unpack_17_28bit_signed_1off,
		},
		{
			unpack_17_28bit_unsigned_2off,
			unpack_17_28bit_signed_2off,
		},
		{
			unpack_17_28bit_unsigned_3off,
			unpack_17_28bit_signed_3off,
		},
		{
			unpack_17_28bit_unsigned_4off,
			unpack_17_28bit_signed_4off,
		},
		{
			unpack_17_28bit_unsigned_5off,
			unpack_17_28bit_signed_5off,
		},
		{
			unpack_17_28bit_unsigned_6off,
			unpack_17_28bit_signed_6off,
		},
		{
			unpack_17_28bit_unsigned_7off,
			unpack_17_28bit_signed_7off,
		},
	},
	{
		{
			unpack_18_28bit_unsigned_0off,
			unpack_18_28bit_signed_0off,
		},
		{
			unpack_18_28bit_unsigned_1off,
			unpack_18_28bit_signed_1off,
		},
		{
			unpack_18_28bit_unsigned_2off,
			unpack_18_28bit_signed_2off,
		},
		{
			unpack_18_28bit_unsigned_3off,
			unpack_18_28bit_signed_3off,
		},
		{
			unpack_18_28bit_unsigned_4off,
			unpack_18_28bit_signed_4off,
		},
		{
			unpack_18_28bit_unsigned_5off,
			unpack_18_28bit_signed_5off,
		},
		{
			unpack_18_28bit_unsigned_6off,
			unpack_18_28bit_signed_6off,
		},
		{
			unpack_18_28bit_unsigned_7off,
			unpack_18_28bit_signed_7off,
		},
	},
};
