// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack29.h"



static void unpack_1_29bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit signed
	// Skip 0 bits, read 29 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit unsigned
	// Skip 0 bits, read 29 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit signed
	// Skip 1 bits, read 29 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit unsigned
	// Skip 1 bits, read 29 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit signed
	// Skip 2 bits, read 29 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit unsigned
	// Skip 2 bits, read 29 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit signed
	// Skip 3 bits, read 29 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit unsigned
	// Skip 3 bits, read 29 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit signed
	// Skip 4 bits, read 29 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit unsigned
	// Skip 4 bits, read 29 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit signed
	// Skip 5 bits, read 29 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit unsigned
	// Skip 5 bits, read 29 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit signed
	// Skip 6 bits, read 29 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit unsigned
	// Skip 6 bits, read 29 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit signed
	// Skip 7 bits, read 29 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);
}

static void unpack_1_29bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 29-bit unsigned
	// Skip 7 bits, read 29 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);
}

static void unpack_2_29bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit signed
	// Skip 0 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit unsigned
	// Skip 0 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit signed
	// Skip 1 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit unsigned
	// Skip 1 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit signed
	// Skip 2 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit unsigned
	// Skip 2 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit signed
	// Skip 3 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit unsigned
	// Skip 3 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit signed
	// Skip 4 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit unsigned
	// Skip 4 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit signed
	// Skip 5 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit unsigned
	// Skip 5 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit signed
	// Skip 6 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit unsigned
	// Skip 6 bits, read 58 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit signed
	// Skip 7 bits, read 58 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);
}

static void unpack_2_29bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 29-bit unsigned
	// Skip 7 bits, read 58 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);
}

static void unpack_3_29bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit signed
	// Skip 0 bits, read 87 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 58 to 86
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfe) << 2);
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit unsigned
	// Skip 0 bits, read 87 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 58 to 86
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfe) << 2);
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit signed
	// Skip 1 bits, read 87 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 59 to 87
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)input[10] << 3);
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit unsigned
	// Skip 1 bits, read 87 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 59 to 87
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)input[10] << 3);
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit signed
	// Skip 2 bits, read 87 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 60 to 88
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0x80) >> 4);
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit unsigned
	// Skip 2 bits, read 87 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 60 to 88
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0x80) >> 4);
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit signed
	// Skip 3 bits, read 87 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 61 to 89
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xc0) >> 3);
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit unsigned
	// Skip 3 bits, read 87 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 61 to 89
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xc0) >> 3);
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit signed
	// Skip 4 bits, read 87 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 62 to 90
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xe0) >> 2);
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit unsigned
	// Skip 4 bits, read 87 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 62 to 90
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xe0) >> 2);
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit signed
	// Skip 5 bits, read 87 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 63 to 91
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf0) >> 1);
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit unsigned
	// Skip 5 bits, read 87 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 63 to 91
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf0) >> 1);
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit signed
	// Skip 6 bits, read 87 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 64 to 92
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xf8));
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit unsigned
	// Skip 6 bits, read 87 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 64 to 92
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xf8));
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit signed
	// Skip 7 bits, read 87 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 65 to 93
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfc) << 1);
	output[2] = (double)(value >> 3);
}

static void unpack_3_29bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 29-bit unsigned
	// Skip 7 bits, read 87 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 65 to 93
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfc) << 1);
	output[2] = (double)(value >> 3);
}

static void unpack_4_29bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit signed
	// Skip 0 bits, read 116 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 58 to 86
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfe) << 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 87 to 115
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xf0) >> 1);
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit unsigned
	// Skip 0 bits, read 116 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 58 to 86
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfe) << 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 87 to 115
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xf0) >> 1);
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit signed
	// Skip 1 bits, read 116 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 59 to 87
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)input[10] << 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 88 to 116
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf8));
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit unsigned
	// Skip 1 bits, read 116 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 59 to 87
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)input[10] << 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 88 to 116
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf8));
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit signed
	// Skip 2 bits, read 116 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 60 to 88
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0x80) >> 4);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 89 to 117
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xfc) << 1);
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit unsigned
	// Skip 2 bits, read 116 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 60 to 88
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0x80) >> 4);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 89 to 117
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xfc) << 1);
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit signed
	// Skip 3 bits, read 116 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 61 to 89
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xc0) >> 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 90 to 118
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfe) << 2);
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit unsigned
	// Skip 3 bits, read 116 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 61 to 89
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xc0) >> 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 90 to 118
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfe) << 2);
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit signed
	// Skip 4 bits, read 116 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 62 to 90
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xe0) >> 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 91 to 119
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3);
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit unsigned
	// Skip 4 bits, read 116 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 62 to 90
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xe0) >> 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 91 to 119
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3);
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit signed
	// Skip 5 bits, read 116 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 63 to 91
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf0) >> 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 92 to 120
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0x80) >> 4);
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit unsigned
	// Skip 5 bits, read 116 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 63 to 91
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf0) >> 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 92 to 120
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0x80) >> 4);
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit signed
	// Skip 6 bits, read 116 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 64 to 92
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xf8));
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 93 to 121
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xc0) >> 3);
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit unsigned
	// Skip 6 bits, read 116 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 64 to 92
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xf8));
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 93 to 121
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xc0) >> 3);
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit signed
	// Skip 7 bits, read 116 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 65 to 93
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfc) << 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 94 to 122
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xe0) >> 2);
	output[3] = (double)(value >> 3);
}

static void unpack_4_29bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 29-bit unsigned
	// Skip 7 bits, read 116 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 65 to 93
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfc) << 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 94 to 122
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xe0) >> 2);
	output[3] = (double)(value >> 3);
}

static void unpack_5_29bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit signed
	// Skip 0 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 58 to 86
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfe) << 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 87 to 115
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xf0) >> 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 116 to 144
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4) |
			((uint32_t)(input[18] & 0x80) >> 4);
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit unsigned
	// Skip 0 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 58 to 86
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfe) << 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 87 to 115
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xf0) >> 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 116 to 144
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4) |
			((uint32_t)(input[18] & 0x80) >> 4);
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit signed
	// Skip 1 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 59 to 87
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)input[10] << 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 88 to 116
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf8));
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 117 to 145
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0xc0) >> 3);
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit unsigned
	// Skip 1 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 59 to 87
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)input[10] << 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 88 to 116
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf8));
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 117 to 145
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0xc0) >> 3);
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit signed
	// Skip 2 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 60 to 88
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0x80) >> 4);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 89 to 117
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xfc) << 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 118 to 146
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xe0) >> 2);
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit unsigned
	// Skip 2 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 60 to 88
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0x80) >> 4);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 89 to 117
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xfc) << 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 118 to 146
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xe0) >> 2);
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit signed
	// Skip 3 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 61 to 89
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xc0) >> 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 90 to 118
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfe) << 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 119 to 147
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xf0) >> 1);
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit unsigned
	// Skip 3 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 61 to 89
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xc0) >> 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 90 to 118
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfe) << 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 119 to 147
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xf0) >> 1);
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit signed
	// Skip 4 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 62 to 90
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xe0) >> 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 91 to 119
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 120 to 148
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xf8));
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit unsigned
	// Skip 4 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 62 to 90
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xe0) >> 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 91 to 119
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 120 to 148
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xf8));
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit signed
	// Skip 5 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 63 to 91
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf0) >> 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 92 to 120
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0x80) >> 4);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 121 to 149
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfc) << 1);
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit unsigned
	// Skip 5 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 63 to 91
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf0) >> 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 92 to 120
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0x80) >> 4);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 121 to 149
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfc) << 1);
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit signed
	// Skip 6 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 64 to 92
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xf8));
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 93 to 121
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xc0) >> 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 122 to 150
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xfe) << 2);
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit unsigned
	// Skip 6 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 64 to 92
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xf8));
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 93 to 121
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xc0) >> 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 122 to 150
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xfe) << 2);
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit signed
	// Skip 7 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 65 to 93
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfc) << 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 94 to 122
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xe0) >> 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 123 to 151
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3);
	output[4] = (double)(value >> 3);
}

static void unpack_5_29bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 29-bit unsigned
	// Skip 7 bits, read 145 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 65 to 93
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfc) << 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 94 to 122
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xe0) >> 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 123 to 151
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3);
	output[4] = (double)(value >> 3);
}

static void unpack_6_29bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit signed
	// Skip 0 bits, read 174 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 58 to 86
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfe) << 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 87 to 115
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xf0) >> 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 116 to 144
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4) |
			((uint32_t)(input[18] & 0x80) >> 4);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 145 to 173
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xfc) << 1);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit unsigned
	// Skip 0 bits, read 174 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 58 to 86
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfe) << 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 87 to 115
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xf0) >> 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 116 to 144
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4) |
			((uint32_t)(input[18] & 0x80) >> 4);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 145 to 173
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xfc) << 1);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit signed
	// Skip 1 bits, read 174 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 59 to 87
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)input[10] << 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 88 to 116
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf8));
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 117 to 145
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0xc0) >> 3);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 146 to 174
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfe) << 2);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit unsigned
	// Skip 1 bits, read 174 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 59 to 87
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)input[10] << 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 88 to 116
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf8));
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 117 to 145
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0xc0) >> 3);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 146 to 174
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfe) << 2);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit signed
	// Skip 2 bits, read 174 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 60 to 88
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0x80) >> 4);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 89 to 117
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xfc) << 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 118 to 146
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xe0) >> 2);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 147 to 175
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)input[21] << 3);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit unsigned
	// Skip 2 bits, read 174 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 60 to 88
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0x80) >> 4);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 89 to 117
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xfc) << 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 118 to 146
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xe0) >> 2);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 147 to 175
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)input[21] << 3);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit signed
	// Skip 3 bits, read 174 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 61 to 89
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xc0) >> 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 90 to 118
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfe) << 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 119 to 147
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xf0) >> 1);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 148 to 176
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)input[21] << 4) |
			((uint32_t)(input[22] & 0x80) >> 4);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit unsigned
	// Skip 3 bits, read 174 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 61 to 89
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xc0) >> 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 90 to 118
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfe) << 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 119 to 147
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xf0) >> 1);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 148 to 176
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)input[21] << 4) |
			((uint32_t)(input[22] & 0x80) >> 4);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit signed
	// Skip 4 bits, read 174 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 62 to 90
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xe0) >> 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 91 to 119
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 120 to 148
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xf8));
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 149 to 177
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)input[21] << 5) |
			((uint32_t)(input[22] & 0xc0) >> 3);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit unsigned
	// Skip 4 bits, read 174 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 62 to 90
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xe0) >> 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 91 to 119
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 120 to 148
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xf8));
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 149 to 177
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)input[21] << 5) |
			((uint32_t)(input[22] & 0xc0) >> 3);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit signed
	// Skip 5 bits, read 174 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 63 to 91
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf0) >> 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 92 to 120
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0x80) >> 4);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 121 to 149
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfc) << 1);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 150 to 178
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xe0) >> 2);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit unsigned
	// Skip 5 bits, read 174 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 63 to 91
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf0) >> 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 92 to 120
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0x80) >> 4);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 121 to 149
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfc) << 1);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 150 to 178
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xe0) >> 2);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit signed
	// Skip 6 bits, read 174 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 64 to 92
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xf8));
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 93 to 121
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xc0) >> 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 122 to 150
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xfe) << 2);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 151 to 179
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf0) >> 1);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit unsigned
	// Skip 6 bits, read 174 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 64 to 92
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xf8));
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 93 to 121
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xc0) >> 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 122 to 150
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xfe) << 2);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 151 to 179
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf0) >> 1);
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit signed
	// Skip 7 bits, read 174 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 65 to 93
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfc) << 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 94 to 122
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xe0) >> 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 123 to 151
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 152 to 180
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xf8));
	output[5] = (double)(value >> 3);
}

static void unpack_6_29bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 29-bit unsigned
	// Skip 7 bits, read 174 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 65 to 93
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfc) << 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 94 to 122
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xe0) >> 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 123 to 151
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 152 to 180
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xf8));
	output[5] = (double)(value >> 3);
}

static void unpack_7_29bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit signed
	// Skip 0 bits, read 203 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 58 to 86
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfe) << 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 87 to 115
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xf0) >> 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 116 to 144
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4) |
			((uint32_t)(input[18] & 0x80) >> 4);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 145 to 173
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xfc) << 1);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 174 to 202
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xe0) >> 2);
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit unsigned
	// Skip 0 bits, read 203 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 58 to 86
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfe) << 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 87 to 115
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xf0) >> 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 116 to 144
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4) |
			((uint32_t)(input[18] & 0x80) >> 4);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 145 to 173
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xfc) << 1);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 174 to 202
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xe0) >> 2);
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit signed
	// Skip 1 bits, read 203 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 59 to 87
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)input[10] << 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 88 to 116
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf8));
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 117 to 145
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0xc0) >> 3);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 146 to 174
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfe) << 2);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 175 to 203
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xf0) >> 1);
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit unsigned
	// Skip 1 bits, read 203 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 59 to 87
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)input[10] << 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 88 to 116
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf8));
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 117 to 145
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0xc0) >> 3);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 146 to 174
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfe) << 2);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 175 to 203
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xf0) >> 1);
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit signed
	// Skip 2 bits, read 203 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 60 to 88
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0x80) >> 4);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 89 to 117
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xfc) << 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 118 to 146
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xe0) >> 2);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 147 to 175
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)input[21] << 3);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 176 to 204
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)input[24] << 8) |
			((uint32_t)(input[25] & 0xf8));
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit unsigned
	// Skip 2 bits, read 203 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 60 to 88
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0x80) >> 4);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 89 to 117
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xfc) << 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 118 to 146
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xe0) >> 2);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 147 to 175
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)input[21] << 3);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 176 to 204
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)input[24] << 8) |
			((uint32_t)(input[25] & 0xf8));
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit signed
	// Skip 3 bits, read 203 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 61 to 89
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xc0) >> 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 90 to 118
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfe) << 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 119 to 147
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xf0) >> 1);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 148 to 176
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)input[21] << 4) |
			((uint32_t)(input[22] & 0x80) >> 4);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 177 to 205
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)input[24] << 9) |
			((uint32_t)(input[25] & 0xfc) << 1);
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit unsigned
	// Skip 3 bits, read 203 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 61 to 89
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xc0) >> 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 90 to 118
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfe) << 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 119 to 147
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xf0) >> 1);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 148 to 176
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)input[21] << 4) |
			((uint32_t)(input[22] & 0x80) >> 4);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 177 to 205
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)input[24] << 9) |
			((uint32_t)(input[25] & 0xfc) << 1);
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit signed
	// Skip 4 bits, read 203 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 62 to 90
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xe0) >> 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 91 to 119
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 120 to 148
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xf8));
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 149 to 177
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)input[21] << 5) |
			((uint32_t)(input[22] & 0xc0) >> 3);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 178 to 206
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10) |
			((uint32_t)(input[25] & 0xfe) << 2);
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit unsigned
	// Skip 4 bits, read 203 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 62 to 90
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xe0) >> 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 91 to 119
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 120 to 148
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xf8));
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 149 to 177
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)input[21] << 5) |
			((uint32_t)(input[22] & 0xc0) >> 3);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 178 to 206
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10) |
			((uint32_t)(input[25] & 0xfe) << 2);
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit signed
	// Skip 5 bits, read 203 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 63 to 91
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf0) >> 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 92 to 120
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0x80) >> 4);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 121 to 149
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfc) << 1);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 150 to 178
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xe0) >> 2);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 179 to 207
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)input[25] << 3);
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit unsigned
	// Skip 5 bits, read 203 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 63 to 91
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf0) >> 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 92 to 120
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0x80) >> 4);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 121 to 149
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfc) << 1);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 150 to 178
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xe0) >> 2);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 179 to 207
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)input[25] << 3);
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit signed
	// Skip 6 bits, read 203 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 64 to 92
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xf8));
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 93 to 121
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xc0) >> 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 122 to 150
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xfe) << 2);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 151 to 179
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf0) >> 1);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 180 to 208
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0x80) >> 4);
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit unsigned
	// Skip 6 bits, read 203 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 64 to 92
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xf8));
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 93 to 121
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xc0) >> 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 122 to 150
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xfe) << 2);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 151 to 179
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf0) >> 1);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 180 to 208
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0x80) >> 4);
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit signed
	// Skip 7 bits, read 203 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 65 to 93
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfc) << 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 94 to 122
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xe0) >> 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 123 to 151
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 152 to 180
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xf8));
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 181 to 209
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xc0) >> 3);
	output[6] = (double)(value >> 3);
}

static void unpack_7_29bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 29-bit unsigned
	// Skip 7 bits, read 203 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 65 to 93
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfc) << 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 94 to 122
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xe0) >> 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 123 to 151
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 152 to 180
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xf8));
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 181 to 209
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xc0) >> 3);
	output[6] = (double)(value >> 3);
}

static void unpack_8_29bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit signed
	// Skip 0 bits, read 232 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 58 to 86
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfe) << 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 87 to 115
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xf0) >> 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 116 to 144
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4) |
			((uint32_t)(input[18] & 0x80) >> 4);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 145 to 173
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xfc) << 1);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 174 to 202
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xe0) >> 2);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 203 to 231
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)input[28] << 3);
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit unsigned
	// Skip 0 bits, read 232 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 28
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xf8));
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 29 to 57
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)input[6] << 5) |
			((uint32_t)(input[7] & 0xc0) >> 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 58 to 86
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)input[9] << 10) |
			((uint32_t)(input[10] & 0xfe) << 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 87 to 115
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)input[13] << 7) |
			((uint32_t)(input[14] & 0xf0) >> 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 116 to 144
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)input[17] << 4) |
			((uint32_t)(input[18] & 0x80) >> 4);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 145 to 173
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)input[20] << 9) |
			((uint32_t)(input[21] & 0xfc) << 1);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 174 to 202
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)input[23] << 14) |
			((uint32_t)input[24] << 6) |
			((uint32_t)(input[25] & 0xe0) >> 2);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 203 to 231
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)input[28] << 3);
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit signed
	// Skip 1 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 59 to 87
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)input[10] << 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 88 to 116
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf8));
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 117 to 145
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0xc0) >> 3);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 146 to 174
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfe) << 2);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 175 to 203
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xf0) >> 1);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 204 to 232
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)input[28] << 4) |
			((uint32_t)(input[29] & 0x80) >> 4);
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit unsigned
	// Skip 1 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 29
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfc) << 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 30 to 58
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xe0) >> 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 59 to 87
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)input[9] << 11) |
			((uint32_t)input[10] << 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 88 to 116
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)input[13] << 8) |
			((uint32_t)(input[14] & 0xf8));
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 117 to 145
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)input[17] << 5) |
			((uint32_t)(input[18] & 0xc0) >> 3);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 146 to 174
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)input[20] << 10) |
			((uint32_t)(input[21] & 0xfe) << 2);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 175 to 203
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)input[23] << 15) |
			((uint32_t)input[24] << 7) |
			((uint32_t)(input[25] & 0xf0) >> 1);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 204 to 232
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)input[28] << 4) |
			((uint32_t)(input[29] & 0x80) >> 4);
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit signed
	// Skip 2 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 60 to 88
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0x80) >> 4);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 89 to 117
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xfc) << 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 118 to 146
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xe0) >> 2);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 147 to 175
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)input[21] << 3);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 176 to 204
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)input[24] << 8) |
			((uint32_t)(input[25] & 0xf8));
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 205 to 233
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)input[28] << 5) |
			((uint32_t)(input[29] & 0xc0) >> 3);
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit unsigned
	// Skip 2 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 30
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)(input[3] & 0xfe) << 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 31 to 59
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf0) >> 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 60 to 88
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0x80) >> 4);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 89 to 117
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)input[13] << 9) |
			((uint32_t)(input[14] & 0xfc) << 1);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 118 to 146
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)input[17] << 6) |
			((uint32_t)(input[18] & 0xe0) >> 2);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 147 to 175
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11) |
			((uint32_t)input[21] << 3);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 176 to 204
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)input[24] << 8) |
			((uint32_t)(input[25] & 0xf8));
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 205 to 233
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)input[28] << 5) |
			((uint32_t)(input[29] & 0xc0) >> 3);
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit signed
	// Skip 3 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 61 to 89
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xc0) >> 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 90 to 118
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfe) << 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 119 to 147
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xf0) >> 1);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 148 to 176
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)input[21] << 4) |
			((uint32_t)(input[22] & 0x80) >> 4);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 177 to 205
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)input[24] << 9) |
			((uint32_t)(input[25] & 0xfc) << 1);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 206 to 234
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)input[28] << 6) |
			((uint32_t)(input[29] & 0xe0) >> 2);
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit unsigned
	// Skip 3 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 31
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 32 to 60
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xf8));
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 61 to 89
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xc0) >> 3);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 90 to 118
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)(input[14] & 0xfe) << 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 119 to 147
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)input[17] << 7) |
			((uint32_t)(input[18] & 0xf0) >> 1);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 148 to 176
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)input[21] << 4) |
			((uint32_t)(input[22] & 0x80) >> 4);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 177 to 205
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)input[24] << 9) |
			((uint32_t)(input[25] & 0xfc) << 1);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 206 to 234
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)input[28] << 6) |
			((uint32_t)(input[29] & 0xe0) >> 2);
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit signed
	// Skip 4 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 62 to 90
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xe0) >> 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 91 to 119
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 120 to 148
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xf8));
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 149 to 177
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)input[21] << 5) |
			((uint32_t)(input[22] & 0xc0) >> 3);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 178 to 206
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10) |
			((uint32_t)(input[25] & 0xfe) << 2);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 207 to 235
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)input[28] << 7) |
			((uint32_t)(input[29] & 0xf0) >> 1);
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit unsigned
	// Skip 4 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 32
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0x80) >> 4);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 33 to 61
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfc) << 1);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 62 to 90
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xe0) >> 2);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 91 to 119
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 120 to 148
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xf8));
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 149 to 177
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)input[21] << 5) |
			((uint32_t)(input[22] & 0xc0) >> 3);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 178 to 206
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10) |
			((uint32_t)(input[25] & 0xfe) << 2);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 207 to 235
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)input[28] << 7) |
			((uint32_t)(input[29] & 0xf0) >> 1);
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit signed
	// Skip 5 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 63 to 91
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf0) >> 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 92 to 120
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0x80) >> 4);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 121 to 149
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfc) << 1);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 150 to 178
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xe0) >> 2);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 179 to 207
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)input[25] << 3);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 208 to 236
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xf8));
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit unsigned
	// Skip 5 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 33
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xc0) >> 3);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 34 to 62
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)(input[7] & 0xfe) << 2);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 63 to 91
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf0) >> 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 92 to 120
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0x80) >> 4);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 121 to 149
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfc) << 1);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 150 to 178
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xe0) >> 2);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 179 to 207
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)input[25] << 3);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 208 to 236
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16) |
			((uint32_t)input[28] << 8) |
			((uint32_t)(input[29] & 0xf8));
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit signed
	// Skip 6 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 64 to 92
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xf8));
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 93 to 121
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xc0) >> 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 122 to 150
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xfe) << 2);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 151 to 179
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf0) >> 1);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 180 to 208
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0x80) >> 4);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 209 to 237
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xfc) << 1);
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit unsigned
	// Skip 6 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 34
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xe0) >> 2);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 35 to 63
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 64 to 92
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xf8));
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 93 to 121
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xc0) >> 3);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 122 to 150
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)(input[18] & 0xfe) << 2);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 151 to 179
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf0) >> 1);
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 180 to 208
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0x80) >> 4);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 209 to 237
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)input[28] << 9) |
			((uint32_t)(input[29] & 0xfc) << 1);
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit signed
	// Skip 7 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 65 to 93
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfc) << 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 94 to 122
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xe0) >> 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 123 to 151
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 152 to 180
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xf8));
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 181 to 209
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xc0) >> 3);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 210 to 238
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xfe) << 2);
	output[7] = (double)(value >> 3);
}

static void unpack_8_29bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 29-bit unsigned
	// Skip 7 bits, read 232 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 35
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf0) >> 1);
	output[0] = (double)(value >> 3);

	// read output[1]: from bit 36 to 64
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0x80) >> 4);
	output[1] = (double)(value >> 3);

	// read output[2]: from bit 65 to 93
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfc) << 1);
	output[2] = (double)(value >> 3);

	// read output[3]: from bit 94 to 122
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xe0) >> 2);
	output[3] = (double)(value >> 3);

	// read output[4]: from bit 123 to 151
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3);
	output[4] = (double)(value >> 3);

	// read output[5]: from bit 152 to 180
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xf8));
	output[5] = (double)(value >> 3);

	// read output[6]: from bit 181 to 209
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xc0) >> 3);
	output[6] = (double)(value >> 3);

	// read output[7]: from bit 210 to 238
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)(input[29] & 0xfe) << 2);
	output[7] = (double)(value >> 3);
}


unpack_func_t unpack_29bit[UNPACK_29BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_29bit_unsigned_0off,
			unpack_1_29bit_signed_0off,
		},
		{
			unpack_1_29bit_unsigned_1off,
			unpack_1_29bit_signed_1off,
		},
		{
			unpack_1_29bit_unsigned_2off,
			unpack_1_29bit_signed_2off,
		},
		{
			unpack_1_29bit_unsigned_3off,
			unpack_1_29bit_signed_3off,
		},
		{
			unpack_1_29bit_unsigned_4off,
			unpack_1_29bit_signed_4off,
		},
		{
			unpack_1_29bit_unsigned_5off,
			unpack_1_29bit_signed_5off,
		},
		{
			unpack_1_29bit_unsigned_6off,
			unpack_1_29bit_signed_6off,
		},
		{
			unpack_1_29bit_unsigned_7off,
			unpack_1_29bit_signed_7off,
		},
	},
	{
		{
			unpack_2_29bit_unsigned_0off,
			unpack_2_29bit_signed_0off,
		},
		{
			unpack_2_29bit_unsigned_1off,
			unpack_2_29bit_signed_1off,
		},
		{
			unpack_2_29bit_unsigned_2off,
			unpack_2_29bit_signed_2off,
		},
		{
			unpack_2_29bit_unsigned_3off,
			unpack_2_29bit_signed_3off,
		},
		{
			unpack_2_29bit_unsigned_4off,
			unpack_2_29bit_signed_4off,
		},
		{
			unpack_2_29bit_unsigned_5off,
			unpack_2_29bit_signed_5off,
		},
		{
			unpack_2_29bit_unsigned_6off,
			unpack_2_29bit_signed_6off,
		},
		{
			unpack_2_29bit_unsigned_7off,
			unpack_2_29bit_signed_7off,
		},
	},
	{
		{
			unpack_3_29bit_unsigned_0off,
			unpack_3_29bit_signed_0off,
		},
		{
			unpack_3_29bit_unsigned_1off,
			unpack_3_29bit_signed_1off,
		},
		{
			unpack_3_29bit_unsigned_2off,
			unpack_3_29bit_signed_2off,
		},
		{
			unpack_3_29bit_unsigned_3off,
			unpack_3_29bit_signed_3off,
		},
		{
			unpack_3_29bit_unsigned_4off,
			unpack_3_29bit_signed_4off,
		},
		{
			unpack_3_29bit_unsigned_5off,
			unpack_3_29bit_signed_5off,
		},
		{
			unpack_3_29bit_unsigned_6off,
			unpack_3_29bit_signed_6off,
		},
		{
			unpack_3_29bit_unsigned_7off,
			unpack_3_29bit_signed_7off,
		},
	},
	{
		{
			unpack_4_29bit_unsigned_0off,
			unpack_4_29bit_signed_0off,
		},
		{
			unpack_4_29bit_unsigned_1off,
			unpack_4_29bit_signed_1off,
		},
		{
			unpack_4_29bit_unsigned_2off,
			unpack_4_29bit_signed_2off,
		},
		{
			unpack_4_29bit_unsigned_3off,
			unpack_4_29bit_signed_3off,
		},
		{
			unpack_4_29bit_unsigned_4off,
			unpack_4_29bit_signed_4off,
		},
		{
			unpack_4_29bit_unsigned_5off,
			unpack_4_29bit_signed_5off,
		},
		{
			unpack_4_29bit_unsigned_6off,
			unpack_4_29bit_signed_6off,
		},
		{
			unpack_4_29bit_unsigned_7off,
			unpack_4_29bit_signed_7off,
		},
	},
	{
		{
			unpack_5_29bit_unsigned_0off,
			unpack_5_29bit_signed_0off,
		},
		{
			unpack_5_29bit_unsigned_1off,
			unpack_5_29bit_signed_1off,
		},
		{
			unpack_5_29bit_unsigned_2off,
			unpack_5_29bit_signed_2off,
		},
		{
			unpack_5_29bit_unsigned_3off,
			unpack_5_29bit_signed_3off,
		},
		{
			unpack_5_29bit_unsigned_4off,
			unpack_5_29bit_signed_4off,
		},
		{
			unpack_5_29bit_unsigned_5off,
			unpack_5_29bit_signed_5off,
		},
		{
			unpack_5_29bit_unsigned_6off,
			unpack_5_29bit_signed_6off,
		},
		{
			unpack_5_29bit_unsigned_7off,
			unpack_5_29bit_signed_7off,
		},
	},
	{
		{
			unpack_6_29bit_unsigned_0off,
			unpack_6_29bit_signed_0off,
		},
		{
			unpack_6_29bit_unsigned_1off,
			unpack_6_29bit_signed_1off,
		},
		{
			unpack_6_29bit_unsigned_2off,
			unpack_6_29bit_signed_2off,
		},
		{
			unpack_6_29bit_unsigned_3off,
			unpack_6_29bit_signed_3off,
		},
		{
			unpack_6_29bit_unsigned_4off,
			unpack_6_29bit_signed_4off,
		},
		{
			unpack_6_29bit_unsigned_5off,
			unpack_6_29bit_signed_5off,
		},
		{
			unpack_6_29bit_unsigned_6off,
			unpack_6_29bit_signed_6off,
		},
		{
			unpack_6_29bit_unsigned_7off,
			unpack_6_29bit_signed_7off,
		},
	},
	{
		{
			unpack_7_29bit_unsigned_0off,
			unpack_7_29bit_signed_0off,
		},
		{
			unpack_7_29bit_unsigned_1off,
			unpack_7_29bit_signed_1off,
		},
		{
			unpack_7_29bit_unsigned_2off,
			unpack_7_29bit_signed_2off,
		},
		{
			unpack_7_29bit_unsigned_3off,
			unpack_7_29bit_signed_3off,
		},
		{
			unpack_7_29bit_unsigned_4off,
			unpack_7_29bit_signed_4off,
		},
		{
			unpack_7_29bit_unsigned_5off,
			unpack_7_29bit_signed_5off,
		},
		{
			unpack_7_29bit_unsigned_6off,
			unpack_7_29bit_signed_6off,
		},
		{
			unpack_7_29bit_unsigned_7off,
			unpack_7_29bit_signed_7off,
		},
	},
	{
		{
			unpack_8_29bit_unsigned_0off,
			unpack_8_29bit_signed_0off,
		},
		{
			unpack_8_29bit_unsigned_1off,
			unpack_8_29bit_signed_1off,
		},
		{
			unpack_8_29bit_unsigned_2off,
			unpack_8_29bit_signed_2off,
		},
		{
			unpack_8_29bit_unsigned_3off,
			unpack_8_29bit_signed_3off,
		},
		{
			unpack_8_29bit_unsigned_4off,
			unpack_8_29bit_signed_4off,
		},
		{
			unpack_8_29bit_unsigned_5off,
			unpack_8_29bit_signed_5off,
		},
		{
			unpack_8_29bit_unsigned_6off,
			unpack_8_29bit_signed_6off,
		},
		{
			unpack_8_29bit_unsigned_7off,
			unpack_8_29bit_signed_7off,
		},
	},
};
