// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack30.h"



static void unpack_1_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);
}

static void unpack_1_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);
}

static void unpack_2_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);
}

static void unpack_2_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);
}

static void unpack_3_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 90 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);
}

static void unpack_3_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 90 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);
}

static void unpack_4_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 120 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 120 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);
}

static void unpack_4_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);
}

static void unpack_5_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);
}

static void unpack_5_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);
}

static void unpack_6_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);
}

static void unpack_6_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);
}

static void unpack_7_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 210 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);
}

static void unpack_7_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 210 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);
}

static void unpack_8_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 240 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 240 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);
}

static void unpack_8_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);
}

static void unpack_9_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 270 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 270 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 270 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 270 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 270 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 270 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);
}

static void unpack_9_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);
}

static void unpack_10_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 300 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 300 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 300 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 300 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 300 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);
}

static void unpack_10_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 300 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);
}

static void unpack_11_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 330 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);
}

static void unpack_11_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 330 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);
}

static void unpack_12_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 360 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 330 to 359
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10) |
			((uint32_t)input[44] << 2);
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 360 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 330 to 359
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10) |
			((uint32_t)input[44] << 2);
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 331 to 360
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)input[44] << 3) |
			((uint32_t)(input[45] & 0x80) >> 5);
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 331 to 360
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)input[44] << 3) |
			((uint32_t)(input[45] & 0x80) >> 5);
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 332 to 361
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)input[44] << 4) |
			((uint32_t)(input[45] & 0xc0) >> 4);
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 332 to 361
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)input[44] << 4) |
			((uint32_t)(input[45] & 0xc0) >> 4);
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 333 to 362
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)input[44] << 5) |
			((uint32_t)(input[45] & 0xe0) >> 3);
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 333 to 362
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)input[44] << 5) |
			((uint32_t)(input[45] & 0xe0) >> 3);
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 334 to 363
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)input[44] << 6) |
			((uint32_t)(input[45] & 0xf0) >> 2);
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 334 to 363
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)input[44] << 6) |
			((uint32_t)(input[45] & 0xf0) >> 2);
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 335 to 364
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)input[44] << 7) |
			((uint32_t)(input[45] & 0xf8) >> 1);
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 335 to 364
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)input[44] << 7) |
			((uint32_t)(input[45] & 0xf8) >> 1);
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 336 to 365
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xfc));
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 336 to 365
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xfc));
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 337 to 366
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xfe) << 1);
	output[11] = (double)(value >> 2);
}

static void unpack_12_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 337 to 366
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xfe) << 1);
	output[11] = (double)(value >> 2);
}

static void unpack_13_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 390 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 330 to 359
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10) |
			((uint32_t)input[44] << 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 360 to 389
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8) |
			((uint32_t)(input[48] & 0xfc));
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 390 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 330 to 359
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10) |
			((uint32_t)input[44] << 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 360 to 389
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8) |
			((uint32_t)(input[48] & 0xfc));
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 390 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 331 to 360
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)input[44] << 3) |
			((uint32_t)(input[45] & 0x80) >> 5);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 361 to 390
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0xfe) << 1);
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 390 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 331 to 360
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)input[44] << 3) |
			((uint32_t)(input[45] & 0x80) >> 5);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 361 to 390
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0xfe) << 1);
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 390 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 332 to 361
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)input[44] << 4) |
			((uint32_t)(input[45] & 0xc0) >> 4);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 362 to 391
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)input[48] << 2);
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 390 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 332 to 361
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)input[44] << 4) |
			((uint32_t)(input[45] & 0xc0) >> 4);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 362 to 391
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)input[48] << 2);
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 333 to 362
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)input[44] << 5) |
			((uint32_t)(input[45] & 0xe0) >> 3);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 363 to 392
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)input[48] << 3) |
			((uint32_t)(input[49] & 0x80) >> 5);
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 333 to 362
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)input[44] << 5) |
			((uint32_t)(input[45] & 0xe0) >> 3);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 363 to 392
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)input[48] << 3) |
			((uint32_t)(input[49] & 0x80) >> 5);
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 334 to 363
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)input[44] << 6) |
			((uint32_t)(input[45] & 0xf0) >> 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 364 to 393
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4) |
			((uint32_t)(input[49] & 0xc0) >> 4);
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 334 to 363
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)input[44] << 6) |
			((uint32_t)(input[45] & 0xf0) >> 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 364 to 393
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4) |
			((uint32_t)(input[49] & 0xc0) >> 4);
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 335 to 364
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)input[44] << 7) |
			((uint32_t)(input[45] & 0xf8) >> 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 365 to 394
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0xe0) >> 3);
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 335 to 364
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)input[44] << 7) |
			((uint32_t)(input[45] & 0xf8) >> 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 365 to 394
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0xe0) >> 3);
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 336 to 365
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xfc));
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 366 to 395
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xf0) >> 2);
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 336 to 365
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xfc));
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 366 to 395
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xf0) >> 2);
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 337 to 366
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xfe) << 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 367 to 396
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xf8) >> 1);
	output[12] = (double)(value >> 2);
}

static void unpack_13_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 390 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 337 to 366
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xfe) << 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 367 to 396
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xf8) >> 1);
	output[12] = (double)(value >> 2);
}

static void unpack_14_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 330 to 359
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10) |
			((uint32_t)input[44] << 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 360 to 389
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8) |
			((uint32_t)(input[48] & 0xfc));
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 390 to 419
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xf0) >> 2);
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 330 to 359
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10) |
			((uint32_t)input[44] << 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 360 to 389
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8) |
			((uint32_t)(input[48] & 0xfc));
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 390 to 419
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xf0) >> 2);
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 331 to 360
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)input[44] << 3) |
			((uint32_t)(input[45] & 0x80) >> 5);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 361 to 390
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0xfe) << 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 391 to 420
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xf8) >> 1);
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 331 to 360
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)input[44] << 3) |
			((uint32_t)(input[45] & 0x80) >> 5);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 361 to 390
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0xfe) << 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 391 to 420
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xf8) >> 1);
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 332 to 361
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)input[44] << 4) |
			((uint32_t)(input[45] & 0xc0) >> 4);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 362 to 391
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)input[48] << 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 392 to 421
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xfc));
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 332 to 361
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)input[44] << 4) |
			((uint32_t)(input[45] & 0xc0) >> 4);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 362 to 391
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)input[48] << 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 392 to 421
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xfc));
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 333 to 362
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)input[44] << 5) |
			((uint32_t)(input[45] & 0xe0) >> 3);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 363 to 392
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)input[48] << 3) |
			((uint32_t)(input[49] & 0x80) >> 5);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 393 to 422
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xfe) << 1);
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 333 to 362
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)input[44] << 5) |
			((uint32_t)(input[45] & 0xe0) >> 3);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 363 to 392
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)input[48] << 3) |
			((uint32_t)(input[49] & 0x80) >> 5);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 393 to 422
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xfe) << 1);
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 334 to 363
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)input[44] << 6) |
			((uint32_t)(input[45] & 0xf0) >> 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 364 to 393
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4) |
			((uint32_t)(input[49] & 0xc0) >> 4);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 394 to 423
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)input[52] << 2);
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 334 to 363
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)input[44] << 6) |
			((uint32_t)(input[45] & 0xf0) >> 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 364 to 393
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4) |
			((uint32_t)(input[49] & 0xc0) >> 4);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 394 to 423
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)input[52] << 2);
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 335 to 364
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)input[44] << 7) |
			((uint32_t)(input[45] & 0xf8) >> 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 365 to 394
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0xe0) >> 3);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 395 to 424
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)input[52] << 3) |
			((uint32_t)(input[53] & 0x80) >> 5);
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 335 to 364
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)input[44] << 7) |
			((uint32_t)(input[45] & 0xf8) >> 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 365 to 394
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0xe0) >> 3);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 395 to 424
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)input[52] << 3) |
			((uint32_t)(input[53] & 0x80) >> 5);
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 336 to 365
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xfc));
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 366 to 395
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xf0) >> 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 396 to 425
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4) |
			((uint32_t)(input[53] & 0xc0) >> 4);
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 336 to 365
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xfc));
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 366 to 395
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xf0) >> 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 396 to 425
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4) |
			((uint32_t)(input[53] & 0xc0) >> 4);
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 337 to 366
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xfe) << 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 367 to 396
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xf8) >> 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 397 to 426
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0xe0) >> 3);
	output[13] = (double)(value >> 2);
}

static void unpack_14_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 337 to 366
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xfe) << 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 367 to 396
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xf8) >> 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 397 to 426
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0xe0) >> 3);
	output[13] = (double)(value >> 2);
}

static void unpack_15_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 330 to 359
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10) |
			((uint32_t)input[44] << 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 360 to 389
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8) |
			((uint32_t)(input[48] & 0xfc));
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 390 to 419
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xf0) >> 2);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 420 to 449
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xc0) >> 4);
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 330 to 359
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10) |
			((uint32_t)input[44] << 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 360 to 389
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8) |
			((uint32_t)(input[48] & 0xfc));
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 390 to 419
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xf0) >> 2);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 420 to 449
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xc0) >> 4);
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 331 to 360
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)input[44] << 3) |
			((uint32_t)(input[45] & 0x80) >> 5);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 361 to 390
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0xfe) << 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 391 to 420
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xf8) >> 1);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 421 to 450
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xe0) >> 3);
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 331 to 360
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)input[44] << 3) |
			((uint32_t)(input[45] & 0x80) >> 5);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 361 to 390
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0xfe) << 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 391 to 420
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xf8) >> 1);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 421 to 450
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xe0) >> 3);
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 332 to 361
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)input[44] << 4) |
			((uint32_t)(input[45] & 0xc0) >> 4);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 362 to 391
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)input[48] << 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 392 to 421
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xfc));
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 422 to 451
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xf0) >> 2);
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 332 to 361
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)input[44] << 4) |
			((uint32_t)(input[45] & 0xc0) >> 4);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 362 to 391
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)input[48] << 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 392 to 421
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xfc));
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 422 to 451
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xf0) >> 2);
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 333 to 362
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)input[44] << 5) |
			((uint32_t)(input[45] & 0xe0) >> 3);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 363 to 392
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)input[48] << 3) |
			((uint32_t)(input[49] & 0x80) >> 5);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 393 to 422
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xfe) << 1);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 423 to 452
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xf8) >> 1);
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 333 to 362
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)input[44] << 5) |
			((uint32_t)(input[45] & 0xe0) >> 3);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 363 to 392
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)input[48] << 3) |
			((uint32_t)(input[49] & 0x80) >> 5);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 393 to 422
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xfe) << 1);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 423 to 452
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xf8) >> 1);
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 334 to 363
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)input[44] << 6) |
			((uint32_t)(input[45] & 0xf0) >> 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 364 to 393
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4) |
			((uint32_t)(input[49] & 0xc0) >> 4);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 394 to 423
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)input[52] << 2);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 424 to 453
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)input[55] << 8) |
			((uint32_t)(input[56] & 0xfc));
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 334 to 363
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)input[44] << 6) |
			((uint32_t)(input[45] & 0xf0) >> 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 364 to 393
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4) |
			((uint32_t)(input[49] & 0xc0) >> 4);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 394 to 423
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)input[52] << 2);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 424 to 453
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)input[55] << 8) |
			((uint32_t)(input[56] & 0xfc));
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 335 to 364
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)input[44] << 7) |
			((uint32_t)(input[45] & 0xf8) >> 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 365 to 394
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0xe0) >> 3);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 395 to 424
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)input[52] << 3) |
			((uint32_t)(input[53] & 0x80) >> 5);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 425 to 454
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)input[55] << 9) |
			((uint32_t)(input[56] & 0xfe) << 1);
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 335 to 364
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)input[44] << 7) |
			((uint32_t)(input[45] & 0xf8) >> 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 365 to 394
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0xe0) >> 3);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 395 to 424
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)input[52] << 3) |
			((uint32_t)(input[53] & 0x80) >> 5);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 425 to 454
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)input[55] << 9) |
			((uint32_t)(input[56] & 0xfe) << 1);
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 336 to 365
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xfc));
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 366 to 395
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xf0) >> 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 396 to 425
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4) |
			((uint32_t)(input[53] & 0xc0) >> 4);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 426 to 455
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)input[55] << 10) |
			((uint32_t)input[56] << 2);
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 450 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 336 to 365
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xfc));
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 366 to 395
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xf0) >> 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 396 to 425
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4) |
			((uint32_t)(input[53] & 0xc0) >> 4);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 426 to 455
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)input[55] << 10) |
			((uint32_t)input[56] << 2);
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 450 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 337 to 366
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xfe) << 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 367 to 396
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xf8) >> 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 397 to 426
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0xe0) >> 3);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 427 to 456
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)input[55] << 11) |
			((uint32_t)input[56] << 3) |
			((uint32_t)(input[57] & 0x80) >> 5);
	output[14] = (double)(value >> 2);
}

static void unpack_15_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 450 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 337 to 366
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xfe) << 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 367 to 396
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xf8) >> 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 397 to 426
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0xe0) >> 3);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 427 to 456
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)input[55] << 11) |
			((uint32_t)input[56] << 3) |
			((uint32_t)(input[57] & 0x80) >> 5);
	output[14] = (double)(value >> 2);
}

static void unpack_16_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 480 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 330 to 359
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10) |
			((uint32_t)input[44] << 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 360 to 389
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8) |
			((uint32_t)(input[48] & 0xfc));
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 390 to 419
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xf0) >> 2);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 420 to 449
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xc0) >> 4);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 450 to 479
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2);
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 480 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 330 to 359
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10) |
			((uint32_t)input[44] << 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 360 to 389
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8) |
			((uint32_t)(input[48] & 0xfc));
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 390 to 419
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xf0) >> 2);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 420 to 449
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xc0) >> 4);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 450 to 479
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2);
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 331 to 360
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)input[44] << 3) |
			((uint32_t)(input[45] & 0x80) >> 5);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 361 to 390
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0xfe) << 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 391 to 420
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xf8) >> 1);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 421 to 450
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xe0) >> 3);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 451 to 480
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0x80) >> 5);
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 331 to 360
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)input[44] << 3) |
			((uint32_t)(input[45] & 0x80) >> 5);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 361 to 390
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0xfe) << 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 391 to 420
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xf8) >> 1);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 421 to 450
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xe0) >> 3);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 451 to 480
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0x80) >> 5);
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 332 to 361
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)input[44] << 4) |
			((uint32_t)(input[45] & 0xc0) >> 4);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 362 to 391
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)input[48] << 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 392 to 421
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xfc));
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 422 to 451
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xf0) >> 2);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 452 to 481
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xc0) >> 4);
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 332 to 361
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)input[44] << 4) |
			((uint32_t)(input[45] & 0xc0) >> 4);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 362 to 391
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)input[48] << 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 392 to 421
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xfc));
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 422 to 451
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xf0) >> 2);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 452 to 481
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xc0) >> 4);
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 333 to 362
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)input[44] << 5) |
			((uint32_t)(input[45] & 0xe0) >> 3);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 363 to 392
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)input[48] << 3) |
			((uint32_t)(input[49] & 0x80) >> 5);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 393 to 422
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xfe) << 1);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 423 to 452
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xf8) >> 1);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 453 to 482
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xe0) >> 3);
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 333 to 362
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)input[44] << 5) |
			((uint32_t)(input[45] & 0xe0) >> 3);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 363 to 392
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)input[48] << 3) |
			((uint32_t)(input[49] & 0x80) >> 5);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 393 to 422
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xfe) << 1);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 423 to 452
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xf8) >> 1);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 453 to 482
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xe0) >> 3);
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 334 to 363
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)input[44] << 6) |
			((uint32_t)(input[45] & 0xf0) >> 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 364 to 393
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4) |
			((uint32_t)(input[49] & 0xc0) >> 4);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 394 to 423
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)input[52] << 2);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 424 to 453
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)input[55] << 8) |
			((uint32_t)(input[56] & 0xfc));
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 454 to 483
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xf0) >> 2);
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 334 to 363
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)input[44] << 6) |
			((uint32_t)(input[45] & 0xf0) >> 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 364 to 393
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4) |
			((uint32_t)(input[49] & 0xc0) >> 4);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 394 to 423
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)input[52] << 2);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 424 to 453
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)input[55] << 8) |
			((uint32_t)(input[56] & 0xfc));
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 454 to 483
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xf0) >> 2);
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 335 to 364
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)input[44] << 7) |
			((uint32_t)(input[45] & 0xf8) >> 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 365 to 394
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0xe0) >> 3);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 395 to 424
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)input[52] << 3) |
			((uint32_t)(input[53] & 0x80) >> 5);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 425 to 454
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)input[55] << 9) |
			((uint32_t)(input[56] & 0xfe) << 1);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 455 to 484
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xf8) >> 1);
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 335 to 364
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)input[44] << 7) |
			((uint32_t)(input[45] & 0xf8) >> 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 365 to 394
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0xe0) >> 3);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 395 to 424
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)input[52] << 3) |
			((uint32_t)(input[53] & 0x80) >> 5);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 425 to 454
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)input[55] << 9) |
			((uint32_t)(input[56] & 0xfe) << 1);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 455 to 484
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xf8) >> 1);
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 336 to 365
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xfc));
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 366 to 395
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xf0) >> 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 396 to 425
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4) |
			((uint32_t)(input[53] & 0xc0) >> 4);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 426 to 455
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)input[55] << 10) |
			((uint32_t)input[56] << 2);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 456 to 485
	value = ((uint32_t)input[57] << 24) |
			((uint32_t)input[58] << 16) |
			((uint32_t)input[59] << 8) |
			((uint32_t)(input[60] & 0xfc));
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 336 to 365
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xfc));
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 366 to 395
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xf0) >> 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 396 to 425
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4) |
			((uint32_t)(input[53] & 0xc0) >> 4);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 426 to 455
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)input[55] << 10) |
			((uint32_t)input[56] << 2);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 456 to 485
	value = ((uint32_t)input[57] << 24) |
			((uint32_t)input[58] << 16) |
			((uint32_t)input[59] << 8) |
			((uint32_t)(input[60] & 0xfc));
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 337 to 366
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xfe) << 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 367 to 396
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xf8) >> 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 397 to 426
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0xe0) >> 3);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 427 to 456
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)input[55] << 11) |
			((uint32_t)input[56] << 3) |
			((uint32_t)(input[57] & 0x80) >> 5);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 457 to 486
	value = ((uint32_t)(input[57] & 0x7f) << 25) |
			((uint32_t)input[58] << 17) |
			((uint32_t)input[59] << 9) |
			((uint32_t)(input[60] & 0xfe) << 1);
	output[15] = (double)(value >> 2);
}

static void unpack_16_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 337 to 366
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xfe) << 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 367 to 396
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xf8) >> 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 397 to 426
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0xe0) >> 3);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 427 to 456
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)input[55] << 11) |
			((uint32_t)input[56] << 3) |
			((uint32_t)(input[57] & 0x80) >> 5);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 457 to 486
	value = ((uint32_t)(input[57] & 0x7f) << 25) |
			((uint32_t)input[58] << 17) |
			((uint32_t)input[59] << 9) |
			((uint32_t)(input[60] & 0xfe) << 1);
	output[15] = (double)(value >> 2);
}

static void unpack_17_30bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit signed
	// Skip 0 bits, read 510 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 330 to 359
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10) |
			((uint32_t)input[44] << 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 360 to 389
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8) |
			((uint32_t)(input[48] & 0xfc));
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 390 to 419
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xf0) >> 2);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 420 to 449
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xc0) >> 4);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 450 to 479
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 480 to 509
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)(input[63] & 0xfc));
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit unsigned
	// Skip 0 bits, read 510 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 29
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfc));
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 30 to 59
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)input[5] << 14) |
			((uint32_t)input[6] << 6) |
			((uint32_t)(input[7] & 0xf0) >> 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 60 to 89
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12) |
			((uint32_t)input[10] << 4) |
			((uint32_t)(input[11] & 0xc0) >> 4);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 90 to 119
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10) |
			((uint32_t)input[14] << 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 120 to 149
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)input[17] << 8) |
			((uint32_t)(input[18] & 0xfc));
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 150 to 179
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)input[21] << 6) |
			((uint32_t)(input[22] & 0xf0) >> 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 180 to 209
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)input[25] << 4) |
			((uint32_t)(input[26] & 0xc0) >> 4);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 210 to 239
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)input[28] << 10) |
			((uint32_t)input[29] << 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 240 to 269
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)input[32] << 8) |
			((uint32_t)(input[33] & 0xfc));
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 270 to 299
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)input[36] << 6) |
			((uint32_t)(input[37] & 0xf0) >> 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 300 to 329
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12) |
			((uint32_t)input[40] << 4) |
			((uint32_t)(input[41] & 0xc0) >> 4);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 330 to 359
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10) |
			((uint32_t)input[44] << 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 360 to 389
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)input[47] << 8) |
			((uint32_t)(input[48] & 0xfc));
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 390 to 419
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xf0) >> 2);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 420 to 449
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xc0) >> 4);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 450 to 479
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 480 to 509
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)(input[63] & 0xfc));
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit signed
	// Skip 1 bits, read 510 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 331 to 360
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)input[44] << 3) |
			((uint32_t)(input[45] & 0x80) >> 5);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 361 to 390
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0xfe) << 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 391 to 420
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xf8) >> 1);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 421 to 450
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xe0) >> 3);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 451 to 480
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0x80) >> 5);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 481 to 510
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)(input[63] & 0xfe) << 1);
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit unsigned
	// Skip 1 bits, read 510 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 30
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)(input[3] & 0xfe) << 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 31 to 60
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xf8) >> 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 61 to 90
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)input[10] << 5) |
			((uint32_t)(input[11] & 0xe0) >> 3);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 91 to 120
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)input[14] << 3) |
			((uint32_t)(input[15] & 0x80) >> 5);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 121 to 150
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)input[17] << 9) |
			((uint32_t)(input[18] & 0xfe) << 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 151 to 180
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)input[21] << 7) |
			((uint32_t)(input[22] & 0xf8) >> 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 181 to 210
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)input[25] << 5) |
			((uint32_t)(input[26] & 0xe0) >> 3);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 211 to 240
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)input[28] << 11) |
			((uint32_t)input[29] << 3) |
			((uint32_t)(input[30] & 0x80) >> 5);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 241 to 270
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)input[32] << 9) |
			((uint32_t)(input[33] & 0xfe) << 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 271 to 300
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)input[36] << 7) |
			((uint32_t)(input[37] & 0xf8) >> 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 301 to 330
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)input[40] << 5) |
			((uint32_t)(input[41] & 0xe0) >> 3);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 331 to 360
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)input[44] << 3) |
			((uint32_t)(input[45] & 0x80) >> 5);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 361 to 390
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)input[47] << 9) |
			((uint32_t)(input[48] & 0xfe) << 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 391 to 420
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xf8) >> 1);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 421 to 450
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xe0) >> 3);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 451 to 480
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0x80) >> 5);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 481 to 510
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)(input[63] & 0xfe) << 1);
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit signed
	// Skip 2 bits, read 510 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 332 to 361
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)input[44] << 4) |
			((uint32_t)(input[45] & 0xc0) >> 4);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 362 to 391
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)input[48] << 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 392 to 421
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xfc));
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 422 to 451
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xf0) >> 2);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 452 to 481
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xc0) >> 4);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 482 to 511
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2);
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit unsigned
	// Skip 2 bits, read 510 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 31
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 32 to 61
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfc));
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 62 to 91
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf0) >> 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 92 to 121
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)input[14] << 4) |
			((uint32_t)(input[15] & 0xc0) >> 4);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 122 to 151
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)input[17] << 10) |
			((uint32_t)input[18] << 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 152 to 181
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)input[21] << 8) |
			((uint32_t)(input[22] & 0xfc));
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 182 to 211
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)input[25] << 6) |
			((uint32_t)(input[26] & 0xf0) >> 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 212 to 241
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)input[28] << 12) |
			((uint32_t)input[29] << 4) |
			((uint32_t)(input[30] & 0xc0) >> 4);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 242 to 271
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10) |
			((uint32_t)input[33] << 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 272 to 301
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)input[36] << 8) |
			((uint32_t)(input[37] & 0xfc));
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 302 to 331
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)input[40] << 6) |
			((uint32_t)(input[41] & 0xf0) >> 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 332 to 361
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)input[44] << 4) |
			((uint32_t)(input[45] & 0xc0) >> 4);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 362 to 391
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)input[47] << 10) |
			((uint32_t)input[48] << 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 392 to 421
	value = ((uint32_t)input[49] << 24) |
			((uint32_t)input[50] << 16) |
			((uint32_t)input[51] << 8) |
			((uint32_t)(input[52] & 0xfc));
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 422 to 451
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xf0) >> 2);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 452 to 481
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xc0) >> 4);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 482 to 511
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2);
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit signed
	// Skip 3 bits, read 510 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 333 to 362
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)input[44] << 5) |
			((uint32_t)(input[45] & 0xe0) >> 3);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 363 to 392
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)input[48] << 3) |
			((uint32_t)(input[49] & 0x80) >> 5);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 393 to 422
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xfe) << 1);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 423 to 452
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xf8) >> 1);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 453 to 482
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xe0) >> 3);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 483 to 512
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0x80) >> 5);
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit unsigned
	// Skip 3 bits, read 510 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 32
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0x80) >> 5);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 33 to 62
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)(input[7] & 0xfe) << 1);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 63 to 92
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xf8) >> 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 93 to 122
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xe0) >> 3);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 123 to 152
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)input[17] << 11) |
			((uint32_t)input[18] << 3) |
			((uint32_t)(input[19] & 0x80) >> 5);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 153 to 182
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)input[21] << 9) |
			((uint32_t)(input[22] & 0xfe) << 1);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 183 to 212
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)input[25] << 7) |
			((uint32_t)(input[26] & 0xf8) >> 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 213 to 242
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)input[28] << 13) |
			((uint32_t)input[29] << 5) |
			((uint32_t)(input[30] & 0xe0) >> 3);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 243 to 272
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)input[33] << 3) |
			((uint32_t)(input[34] & 0x80) >> 5);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 273 to 302
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)input[36] << 9) |
			((uint32_t)(input[37] & 0xfe) << 1);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 303 to 332
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)input[40] << 7) |
			((uint32_t)(input[41] & 0xf8) >> 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 333 to 362
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)input[44] << 5) |
			((uint32_t)(input[45] & 0xe0) >> 3);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 363 to 392
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)input[47] << 11) |
			((uint32_t)input[48] << 3) |
			((uint32_t)(input[49] & 0x80) >> 5);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 393 to 422
	value = ((uint32_t)(input[49] & 0x7f) << 25) |
			((uint32_t)input[50] << 17) |
			((uint32_t)input[51] << 9) |
			((uint32_t)(input[52] & 0xfe) << 1);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 423 to 452
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xf8) >> 1);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 453 to 482
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xe0) >> 3);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 483 to 512
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0x80) >> 5);
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit signed
	// Skip 4 bits, read 510 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 334 to 363
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)input[44] << 6) |
			((uint32_t)(input[45] & 0xf0) >> 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 364 to 393
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4) |
			((uint32_t)(input[49] & 0xc0) >> 4);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 394 to 423
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)input[52] << 2);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 424 to 453
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)input[55] << 8) |
			((uint32_t)(input[56] & 0xfc));
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 454 to 483
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xf0) >> 2);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 484 to 513
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xc0) >> 4);
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit unsigned
	// Skip 4 bits, read 510 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 33
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xc0) >> 4);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 34 to 63
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 64 to 93
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfc));
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 94 to 123
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf0) >> 2);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 124 to 153
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xc0) >> 4);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 154 to 183
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10) |
			((uint32_t)input[22] << 2);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 184 to 213
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)input[25] << 8) |
			((uint32_t)(input[26] & 0xfc));
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 214 to 243
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)input[28] << 14) |
			((uint32_t)input[29] << 6) |
			((uint32_t)(input[30] & 0xf0) >> 2);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 244 to 273
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)input[33] << 4) |
			((uint32_t)(input[34] & 0xc0) >> 4);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 274 to 303
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)input[36] << 10) |
			((uint32_t)input[37] << 2);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 304 to 333
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)input[40] << 8) |
			((uint32_t)(input[41] & 0xfc));
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 334 to 363
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)input[44] << 6) |
			((uint32_t)(input[45] & 0xf0) >> 2);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 364 to 393
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12) |
			((uint32_t)input[48] << 4) |
			((uint32_t)(input[49] & 0xc0) >> 4);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 394 to 423
	value = ((uint32_t)(input[49] & 0x3f) << 26) |
			((uint32_t)input[50] << 18) |
			((uint32_t)input[51] << 10) |
			((uint32_t)input[52] << 2);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 424 to 453
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)input[55] << 8) |
			((uint32_t)(input[56] & 0xfc));
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 454 to 483
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xf0) >> 2);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 484 to 513
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xc0) >> 4);
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit signed
	// Skip 5 bits, read 510 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 335 to 364
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)input[44] << 7) |
			((uint32_t)(input[45] & 0xf8) >> 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 365 to 394
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0xe0) >> 3);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 395 to 424
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)input[52] << 3) |
			((uint32_t)(input[53] & 0x80) >> 5);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 425 to 454
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)input[55] << 9) |
			((uint32_t)(input[56] & 0xfe) << 1);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 455 to 484
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xf8) >> 1);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 485 to 514
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xe0) >> 3);
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit unsigned
	// Skip 5 bits, read 510 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 34
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xe0) >> 3);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 35 to 64
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0x80) >> 5);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 65 to 94
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)(input[11] & 0xfe) << 1);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 95 to 124
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xf8) >> 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 125 to 154
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xe0) >> 3);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 155 to 184
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0x80) >> 5);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 185 to 214
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)input[25] << 9) |
			((uint32_t)(input[26] & 0xfe) << 1);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 215 to 244
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)input[28] << 15) |
			((uint32_t)input[29] << 7) |
			((uint32_t)(input[30] & 0xf8) >> 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 245 to 274
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)input[33] << 5) |
			((uint32_t)(input[34] & 0xe0) >> 3);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 275 to 304
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)input[36] << 11) |
			((uint32_t)input[37] << 3) |
			((uint32_t)(input[38] & 0x80) >> 5);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 305 to 334
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)input[40] << 9) |
			((uint32_t)(input[41] & 0xfe) << 1);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 335 to 364
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)input[44] << 7) |
			((uint32_t)(input[45] & 0xf8) >> 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 365 to 394
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)input[48] << 5) |
			((uint32_t)(input[49] & 0xe0) >> 3);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 395 to 424
	value = ((uint32_t)(input[49] & 0x1f) << 27) |
			((uint32_t)input[50] << 19) |
			((uint32_t)input[51] << 11) |
			((uint32_t)input[52] << 3) |
			((uint32_t)(input[53] & 0x80) >> 5);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 425 to 454
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)input[55] << 9) |
			((uint32_t)(input[56] & 0xfe) << 1);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 455 to 484
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xf8) >> 1);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 485 to 514
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xe0) >> 3);
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit signed
	// Skip 6 bits, read 510 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 336 to 365
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xfc));
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 366 to 395
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xf0) >> 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 396 to 425
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4) |
			((uint32_t)(input[53] & 0xc0) >> 4);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 426 to 455
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)input[55] << 10) |
			((uint32_t)input[56] << 2);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 456 to 485
	value = ((uint32_t)input[57] << 24) |
			((uint32_t)input[58] << 16) |
			((uint32_t)input[59] << 8) |
			((uint32_t)(input[60] & 0xfc));
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 486 to 515
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)input[63] << 6) |
			((uint32_t)(input[64] & 0xf0) >> 2);
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit unsigned
	// Skip 6 bits, read 510 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 35
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf0) >> 2);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 36 to 65
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xc0) >> 4);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 66 to 95
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 96 to 125
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfc));
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 126 to 155
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf0) >> 2);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 156 to 185
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xc0) >> 4);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 186 to 215
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 216 to 245
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)input[29] << 8) |
			((uint32_t)(input[30] & 0xfc));
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 246 to 275
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)input[33] << 6) |
			((uint32_t)(input[34] & 0xf0) >> 2);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 276 to 305
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)input[36] << 12) |
			((uint32_t)input[37] << 4) |
			((uint32_t)(input[38] & 0xc0) >> 4);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 306 to 335
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)input[40] << 10) |
			((uint32_t)input[41] << 2);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 336 to 365
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)input[44] << 8) |
			((uint32_t)(input[45] & 0xfc));
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 366 to 395
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)input[48] << 6) |
			((uint32_t)(input[49] & 0xf0) >> 2);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 396 to 425
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)input[52] << 4) |
			((uint32_t)(input[53] & 0xc0) >> 4);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 426 to 455
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)input[55] << 10) |
			((uint32_t)input[56] << 2);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 456 to 485
	value = ((uint32_t)input[57] << 24) |
			((uint32_t)input[58] << 16) |
			((uint32_t)input[59] << 8) |
			((uint32_t)(input[60] & 0xfc));
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 486 to 515
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)input[63] << 6) |
			((uint32_t)(input[64] & 0xf0) >> 2);
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit signed
	// Skip 7 bits, read 510 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 337 to 366
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xfe) << 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 367 to 396
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xf8) >> 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 397 to 426
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0xe0) >> 3);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 427 to 456
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)input[55] << 11) |
			((uint32_t)input[56] << 3) |
			((uint32_t)(input[57] & 0x80) >> 5);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 457 to 486
	value = ((uint32_t)(input[57] & 0x7f) << 25) |
			((uint32_t)input[58] << 17) |
			((uint32_t)input[59] << 9) |
			((uint32_t)(input[60] & 0xfe) << 1);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 487 to 516
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)input[63] << 7) |
			((uint32_t)(input[64] & 0xf8) >> 1);
	output[16] = (double)(value >> 2);
}

static void unpack_17_30bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 30-bit unsigned
	// Skip 7 bits, read 510 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 36
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xf8) >> 1);
	output[0] = (double)(value >> 2);

	// read output[1]: from bit 37 to 66
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xe0) >> 3);
	output[1] = (double)(value >> 2);

	// read output[2]: from bit 67 to 96
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0x80) >> 5);
	output[2] = (double)(value >> 2);

	// read output[3]: from bit 97 to 126
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)(input[15] & 0xfe) << 1);
	output[3] = (double)(value >> 2);

	// read output[4]: from bit 127 to 156
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xf8) >> 1);
	output[4] = (double)(value >> 2);

	// read output[5]: from bit 157 to 186
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xe0) >> 3);
	output[5] = (double)(value >> 2);

	// read output[6]: from bit 187 to 216
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0x80) >> 5);
	output[6] = (double)(value >> 2);

	// read output[7]: from bit 217 to 246
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)(input[30] & 0xfe) << 1);
	output[7] = (double)(value >> 2);

	// read output[8]: from bit 247 to 276
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)input[33] << 7) |
			((uint32_t)(input[34] & 0xf8) >> 1);
	output[8] = (double)(value >> 2);

	// read output[9]: from bit 277 to 306
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)input[36] << 13) |
			((uint32_t)input[37] << 5) |
			((uint32_t)(input[38] & 0xe0) >> 3);
	output[9] = (double)(value >> 2);

	// read output[10]: from bit 307 to 336
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)input[40] << 11) |
			((uint32_t)input[41] << 3) |
			((uint32_t)(input[42] & 0x80) >> 5);
	output[10] = (double)(value >> 2);

	// read output[11]: from bit 337 to 366
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)input[44] << 9) |
			((uint32_t)(input[45] & 0xfe) << 1);
	output[11] = (double)(value >> 2);

	// read output[12]: from bit 367 to 396
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)input[48] << 7) |
			((uint32_t)(input[49] & 0xf8) >> 1);
	output[12] = (double)(value >> 2);

	// read output[13]: from bit 397 to 426
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)input[52] << 5) |
			((uint32_t)(input[53] & 0xe0) >> 3);
	output[13] = (double)(value >> 2);

	// read output[14]: from bit 427 to 456
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)input[55] << 11) |
			((uint32_t)input[56] << 3) |
			((uint32_t)(input[57] & 0x80) >> 5);
	output[14] = (double)(value >> 2);

	// read output[15]: from bit 457 to 486
	value = ((uint32_t)(input[57] & 0x7f) << 25) |
			((uint32_t)input[58] << 17) |
			((uint32_t)input[59] << 9) |
			((uint32_t)(input[60] & 0xfe) << 1);
	output[15] = (double)(value >> 2);

	// read output[16]: from bit 487 to 516
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)input[63] << 7) |
			((uint32_t)(input[64] & 0xf8) >> 1);
	output[16] = (double)(value >> 2);
}


unpack_func_t unpack_30bit[UNPACK_30BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_30bit_unsigned_0off,
			unpack_1_30bit_signed_0off,
		},
		{
			unpack_1_30bit_unsigned_1off,
			unpack_1_30bit_signed_1off,
		},
		{
			unpack_1_30bit_unsigned_2off,
			unpack_1_30bit_signed_2off,
		},
		{
			unpack_1_30bit_unsigned_3off,
			unpack_1_30bit_signed_3off,
		},
		{
			unpack_1_30bit_unsigned_4off,
			unpack_1_30bit_signed_4off,
		},
		{
			unpack_1_30bit_unsigned_5off,
			unpack_1_30bit_signed_5off,
		},
		{
			unpack_1_30bit_unsigned_6off,
			unpack_1_30bit_signed_6off,
		},
		{
			unpack_1_30bit_unsigned_7off,
			unpack_1_30bit_signed_7off,
		},
	},
	{
		{
			unpack_2_30bit_unsigned_0off,
			unpack_2_30bit_signed_0off,
		},
		{
			unpack_2_30bit_unsigned_1off,
			unpack_2_30bit_signed_1off,
		},
		{
			unpack_2_30bit_unsigned_2off,
			unpack_2_30bit_signed_2off,
		},
		{
			unpack_2_30bit_unsigned_3off,
			unpack_2_30bit_signed_3off,
		},
		{
			unpack_2_30bit_unsigned_4off,
			unpack_2_30bit_signed_4off,
		},
		{
			unpack_2_30bit_unsigned_5off,
			unpack_2_30bit_signed_5off,
		},
		{
			unpack_2_30bit_unsigned_6off,
			unpack_2_30bit_signed_6off,
		},
		{
			unpack_2_30bit_unsigned_7off,
			unpack_2_30bit_signed_7off,
		},
	},
	{
		{
			unpack_3_30bit_unsigned_0off,
			unpack_3_30bit_signed_0off,
		},
		{
			unpack_3_30bit_unsigned_1off,
			unpack_3_30bit_signed_1off,
		},
		{
			unpack_3_30bit_unsigned_2off,
			unpack_3_30bit_signed_2off,
		},
		{
			unpack_3_30bit_unsigned_3off,
			unpack_3_30bit_signed_3off,
		},
		{
			unpack_3_30bit_unsigned_4off,
			unpack_3_30bit_signed_4off,
		},
		{
			unpack_3_30bit_unsigned_5off,
			unpack_3_30bit_signed_5off,
		},
		{
			unpack_3_30bit_unsigned_6off,
			unpack_3_30bit_signed_6off,
		},
		{
			unpack_3_30bit_unsigned_7off,
			unpack_3_30bit_signed_7off,
		},
	},
	{
		{
			unpack_4_30bit_unsigned_0off,
			unpack_4_30bit_signed_0off,
		},
		{
			unpack_4_30bit_unsigned_1off,
			unpack_4_30bit_signed_1off,
		},
		{
			unpack_4_30bit_unsigned_2off,
			unpack_4_30bit_signed_2off,
		},
		{
			unpack_4_30bit_unsigned_3off,
			unpack_4_30bit_signed_3off,
		},
		{
			unpack_4_30bit_unsigned_4off,
			unpack_4_30bit_signed_4off,
		},
		{
			unpack_4_30bit_unsigned_5off,
			unpack_4_30bit_signed_5off,
		},
		{
			unpack_4_30bit_unsigned_6off,
			unpack_4_30bit_signed_6off,
		},
		{
			unpack_4_30bit_unsigned_7off,
			unpack_4_30bit_signed_7off,
		},
	},
	{
		{
			unpack_5_30bit_unsigned_0off,
			unpack_5_30bit_signed_0off,
		},
		{
			unpack_5_30bit_unsigned_1off,
			unpack_5_30bit_signed_1off,
		},
		{
			unpack_5_30bit_unsigned_2off,
			unpack_5_30bit_signed_2off,
		},
		{
			unpack_5_30bit_unsigned_3off,
			unpack_5_30bit_signed_3off,
		},
		{
			unpack_5_30bit_unsigned_4off,
			unpack_5_30bit_signed_4off,
		},
		{
			unpack_5_30bit_unsigned_5off,
			unpack_5_30bit_signed_5off,
		},
		{
			unpack_5_30bit_unsigned_6off,
			unpack_5_30bit_signed_6off,
		},
		{
			unpack_5_30bit_unsigned_7off,
			unpack_5_30bit_signed_7off,
		},
	},
	{
		{
			unpack_6_30bit_unsigned_0off,
			unpack_6_30bit_signed_0off,
		},
		{
			unpack_6_30bit_unsigned_1off,
			unpack_6_30bit_signed_1off,
		},
		{
			unpack_6_30bit_unsigned_2off,
			unpack_6_30bit_signed_2off,
		},
		{
			unpack_6_30bit_unsigned_3off,
			unpack_6_30bit_signed_3off,
		},
		{
			unpack_6_30bit_unsigned_4off,
			unpack_6_30bit_signed_4off,
		},
		{
			unpack_6_30bit_unsigned_5off,
			unpack_6_30bit_signed_5off,
		},
		{
			unpack_6_30bit_unsigned_6off,
			unpack_6_30bit_signed_6off,
		},
		{
			unpack_6_30bit_unsigned_7off,
			unpack_6_30bit_signed_7off,
		},
	},
	{
		{
			unpack_7_30bit_unsigned_0off,
			unpack_7_30bit_signed_0off,
		},
		{
			unpack_7_30bit_unsigned_1off,
			unpack_7_30bit_signed_1off,
		},
		{
			unpack_7_30bit_unsigned_2off,
			unpack_7_30bit_signed_2off,
		},
		{
			unpack_7_30bit_unsigned_3off,
			unpack_7_30bit_signed_3off,
		},
		{
			unpack_7_30bit_unsigned_4off,
			unpack_7_30bit_signed_4off,
		},
		{
			unpack_7_30bit_unsigned_5off,
			unpack_7_30bit_signed_5off,
		},
		{
			unpack_7_30bit_unsigned_6off,
			unpack_7_30bit_signed_6off,
		},
		{
			unpack_7_30bit_unsigned_7off,
			unpack_7_30bit_signed_7off,
		},
	},
	{
		{
			unpack_8_30bit_unsigned_0off,
			unpack_8_30bit_signed_0off,
		},
		{
			unpack_8_30bit_unsigned_1off,
			unpack_8_30bit_signed_1off,
		},
		{
			unpack_8_30bit_unsigned_2off,
			unpack_8_30bit_signed_2off,
		},
		{
			unpack_8_30bit_unsigned_3off,
			unpack_8_30bit_signed_3off,
		},
		{
			unpack_8_30bit_unsigned_4off,
			unpack_8_30bit_signed_4off,
		},
		{
			unpack_8_30bit_unsigned_5off,
			unpack_8_30bit_signed_5off,
		},
		{
			unpack_8_30bit_unsigned_6off,
			unpack_8_30bit_signed_6off,
		},
		{
			unpack_8_30bit_unsigned_7off,
			unpack_8_30bit_signed_7off,
		},
	},
	{
		{
			unpack_9_30bit_unsigned_0off,
			unpack_9_30bit_signed_0off,
		},
		{
			unpack_9_30bit_unsigned_1off,
			unpack_9_30bit_signed_1off,
		},
		{
			unpack_9_30bit_unsigned_2off,
			unpack_9_30bit_signed_2off,
		},
		{
			unpack_9_30bit_unsigned_3off,
			unpack_9_30bit_signed_3off,
		},
		{
			unpack_9_30bit_unsigned_4off,
			unpack_9_30bit_signed_4off,
		},
		{
			unpack_9_30bit_unsigned_5off,
			unpack_9_30bit_signed_5off,
		},
		{
			unpack_9_30bit_unsigned_6off,
			unpack_9_30bit_signed_6off,
		},
		{
			unpack_9_30bit_unsigned_7off,
			unpack_9_30bit_signed_7off,
		},
	},
	{
		{
			unpack_10_30bit_unsigned_0off,
			unpack_10_30bit_signed_0off,
		},
		{
			unpack_10_30bit_unsigned_1off,
			unpack_10_30bit_signed_1off,
		},
		{
			unpack_10_30bit_unsigned_2off,
			unpack_10_30bit_signed_2off,
		},
		{
			unpack_10_30bit_unsigned_3off,
			unpack_10_30bit_signed_3off,
		},
		{
			unpack_10_30bit_unsigned_4off,
			unpack_10_30bit_signed_4off,
		},
		{
			unpack_10_30bit_unsigned_5off,
			unpack_10_30bit_signed_5off,
		},
		{
			unpack_10_30bit_unsigned_6off,
			unpack_10_30bit_signed_6off,
		},
		{
			unpack_10_30bit_unsigned_7off,
			unpack_10_30bit_signed_7off,
		},
	},
	{
		{
			unpack_11_30bit_unsigned_0off,
			unpack_11_30bit_signed_0off,
		},
		{
			unpack_11_30bit_unsigned_1off,
			unpack_11_30bit_signed_1off,
		},
		{
			unpack_11_30bit_unsigned_2off,
			unpack_11_30bit_signed_2off,
		},
		{
			unpack_11_30bit_unsigned_3off,
			unpack_11_30bit_signed_3off,
		},
		{
			unpack_11_30bit_unsigned_4off,
			unpack_11_30bit_signed_4off,
		},
		{
			unpack_11_30bit_unsigned_5off,
			unpack_11_30bit_signed_5off,
		},
		{
			unpack_11_30bit_unsigned_6off,
			unpack_11_30bit_signed_6off,
		},
		{
			unpack_11_30bit_unsigned_7off,
			unpack_11_30bit_signed_7off,
		},
	},
	{
		{
			unpack_12_30bit_unsigned_0off,
			unpack_12_30bit_signed_0off,
		},
		{
			unpack_12_30bit_unsigned_1off,
			unpack_12_30bit_signed_1off,
		},
		{
			unpack_12_30bit_unsigned_2off,
			unpack_12_30bit_signed_2off,
		},
		{
			unpack_12_30bit_unsigned_3off,
			unpack_12_30bit_signed_3off,
		},
		{
			unpack_12_30bit_unsigned_4off,
			unpack_12_30bit_signed_4off,
		},
		{
			unpack_12_30bit_unsigned_5off,
			unpack_12_30bit_signed_5off,
		},
		{
			unpack_12_30bit_unsigned_6off,
			unpack_12_30bit_signed_6off,
		},
		{
			unpack_12_30bit_unsigned_7off,
			unpack_12_30bit_signed_7off,
		},
	},
	{
		{
			unpack_13_30bit_unsigned_0off,
			unpack_13_30bit_signed_0off,
		},
		{
			unpack_13_30bit_unsigned_1off,
			unpack_13_30bit_signed_1off,
		},
		{
			unpack_13_30bit_unsigned_2off,
			unpack_13_30bit_signed_2off,
		},
		{
			unpack_13_30bit_unsigned_3off,
			unpack_13_30bit_signed_3off,
		},
		{
			unpack_13_30bit_unsigned_4off,
			unpack_13_30bit_signed_4off,
		},
		{
			unpack_13_30bit_unsigned_5off,
			unpack_13_30bit_signed_5off,
		},
		{
			unpack_13_30bit_unsigned_6off,
			unpack_13_30bit_signed_6off,
		},
		{
			unpack_13_30bit_unsigned_7off,
			unpack_13_30bit_signed_7off,
		},
	},
	{
		{
			unpack_14_30bit_unsigned_0off,
			unpack_14_30bit_signed_0off,
		},
		{
			unpack_14_30bit_unsigned_1off,
			unpack_14_30bit_signed_1off,
		},
		{
			unpack_14_30bit_unsigned_2off,
			unpack_14_30bit_signed_2off,
		},
		{
			unpack_14_30bit_unsigned_3off,
			unpack_14_30bit_signed_3off,
		},
		{
			unpack_14_30bit_unsigned_4off,
			unpack_14_30bit_signed_4off,
		},
		{
			unpack_14_30bit_unsigned_5off,
			unpack_14_30bit_signed_5off,
		},
		{
			unpack_14_30bit_unsigned_6off,
			unpack_14_30bit_signed_6off,
		},
		{
			unpack_14_30bit_unsigned_7off,
			unpack_14_30bit_signed_7off,
		},
	},
	{
		{
			unpack_15_30bit_unsigned_0off,
			unpack_15_30bit_signed_0off,
		},
		{
			unpack_15_30bit_unsigned_1off,
			unpack_15_30bit_signed_1off,
		},
		{
			unpack_15_30bit_unsigned_2off,
			unpack_15_30bit_signed_2off,
		},
		{
			unpack_15_30bit_unsigned_3off,
			unpack_15_30bit_signed_3off,
		},
		{
			unpack_15_30bit_unsigned_4off,
			unpack_15_30bit_signed_4off,
		},
		{
			unpack_15_30bit_unsigned_5off,
			unpack_15_30bit_signed_5off,
		},
		{
			unpack_15_30bit_unsigned_6off,
			unpack_15_30bit_signed_6off,
		},
		{
			unpack_15_30bit_unsigned_7off,
			unpack_15_30bit_signed_7off,
		},
	},
	{
		{
			unpack_16_30bit_unsigned_0off,
			unpack_16_30bit_signed_0off,
		},
		{
			unpack_16_30bit_unsigned_1off,
			unpack_16_30bit_signed_1off,
		},
		{
			unpack_16_30bit_unsigned_2off,
			unpack_16_30bit_signed_2off,
		},
		{
			unpack_16_30bit_unsigned_3off,
			unpack_16_30bit_signed_3off,
		},
		{
			unpack_16_30bit_unsigned_4off,
			unpack_16_30bit_signed_4off,
		},
		{
			unpack_16_30bit_unsigned_5off,
			unpack_16_30bit_signed_5off,
		},
		{
			unpack_16_30bit_unsigned_6off,
			unpack_16_30bit_signed_6off,
		},
		{
			unpack_16_30bit_unsigned_7off,
			unpack_16_30bit_signed_7off,
		},
	},
	{
		{
			unpack_17_30bit_unsigned_0off,
			unpack_17_30bit_signed_0off,
		},
		{
			unpack_17_30bit_unsigned_1off,
			unpack_17_30bit_signed_1off,
		},
		{
			unpack_17_30bit_unsigned_2off,
			unpack_17_30bit_signed_2off,
		},
		{
			unpack_17_30bit_unsigned_3off,
			unpack_17_30bit_signed_3off,
		},
		{
			unpack_17_30bit_unsigned_4off,
			unpack_17_30bit_signed_4off,
		},
		{
			unpack_17_30bit_unsigned_5off,
			unpack_17_30bit_signed_5off,
		},
		{
			unpack_17_30bit_unsigned_6off,
			unpack_17_30bit_signed_6off,
		},
		{
			unpack_17_30bit_unsigned_7off,
			unpack_17_30bit_signed_7off,
		},
	},
};
