// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack31.h"



static void unpack_1_31bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit signed
	// Skip 0 bits, read 31 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit unsigned
	// Skip 0 bits, read 31 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit signed
	// Skip 1 bits, read 31 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit unsigned
	// Skip 1 bits, read 31 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit signed
	// Skip 2 bits, read 31 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit unsigned
	// Skip 2 bits, read 31 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit signed
	// Skip 3 bits, read 31 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit unsigned
	// Skip 3 bits, read 31 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit signed
	// Skip 4 bits, read 31 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit unsigned
	// Skip 4 bits, read 31 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit signed
	// Skip 5 bits, read 31 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit unsigned
	// Skip 5 bits, read 31 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit signed
	// Skip 6 bits, read 31 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit unsigned
	// Skip 6 bits, read 31 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit signed
	// Skip 7 bits, read 31 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);
}

static void unpack_1_31bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 31-bit unsigned
	// Skip 7 bits, read 31 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);
}

static void unpack_2_31bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit signed
	// Skip 0 bits, read 62 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit unsigned
	// Skip 0 bits, read 62 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit signed
	// Skip 1 bits, read 62 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit unsigned
	// Skip 1 bits, read 62 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit signed
	// Skip 2 bits, read 62 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit unsigned
	// Skip 2 bits, read 62 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit signed
	// Skip 3 bits, read 62 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit unsigned
	// Skip 3 bits, read 62 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit signed
	// Skip 4 bits, read 62 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit unsigned
	// Skip 4 bits, read 62 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit signed
	// Skip 5 bits, read 62 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit unsigned
	// Skip 5 bits, read 62 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit signed
	// Skip 6 bits, read 62 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit unsigned
	// Skip 6 bits, read 62 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit signed
	// Skip 7 bits, read 62 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);
}

static void unpack_2_31bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 31-bit unsigned
	// Skip 7 bits, read 62 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);
}

static void unpack_3_31bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit signed
	// Skip 0 bits, read 93 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 62 to 92
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf8) >> 2);
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit unsigned
	// Skip 0 bits, read 93 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 62 to 92
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf8) >> 2);
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit signed
	// Skip 1 bits, read 93 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 63 to 93
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xfc) >> 1);
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit unsigned
	// Skip 1 bits, read 93 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 63 to 93
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xfc) >> 1);
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit signed
	// Skip 2 bits, read 93 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 64 to 94
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfe));
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit unsigned
	// Skip 2 bits, read 93 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 64 to 94
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfe));
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit signed
	// Skip 3 bits, read 93 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 65 to 95
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1);
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit unsigned
	// Skip 3 bits, read 93 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 65 to 95
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1);
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit signed
	// Skip 4 bits, read 93 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 66 to 96
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0x80) >> 6);
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit unsigned
	// Skip 4 bits, read 93 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 66 to 96
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0x80) >> 6);
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit signed
	// Skip 5 bits, read 93 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 67 to 97
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xc0) >> 5);
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit unsigned
	// Skip 5 bits, read 93 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 67 to 97
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xc0) >> 5);
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit signed
	// Skip 6 bits, read 93 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 68 to 98
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xe0) >> 4);
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit unsigned
	// Skip 6 bits, read 93 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 68 to 98
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xe0) >> 4);
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit signed
	// Skip 7 bits, read 93 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 69 to 99
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf0) >> 3);
	output[2] = (double)(value >> 1);
}

static void unpack_3_31bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 31-bit unsigned
	// Skip 7 bits, read 93 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 69 to 99
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf0) >> 3);
	output[2] = (double)(value >> 1);
}

static void unpack_4_31bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit signed
	// Skip 0 bits, read 124 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 62 to 92
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf8) >> 2);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 93 to 123
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xf0) >> 3);
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit unsigned
	// Skip 0 bits, read 124 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 62 to 92
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf8) >> 2);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 93 to 123
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xf0) >> 3);
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit signed
	// Skip 1 bits, read 124 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 63 to 93
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xfc) >> 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 94 to 124
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf8) >> 2);
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit unsigned
	// Skip 1 bits, read 124 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 63 to 93
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xfc) >> 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 94 to 124
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf8) >> 2);
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit signed
	// Skip 2 bits, read 124 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 64 to 94
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfe));
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 95 to 125
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xfc) >> 1);
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit unsigned
	// Skip 2 bits, read 124 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 64 to 94
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfe));
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 95 to 125
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xfc) >> 1);
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit signed
	// Skip 3 bits, read 124 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 65 to 95
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 96 to 126
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfe));
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit unsigned
	// Skip 3 bits, read 124 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 65 to 95
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 96 to 126
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfe));
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit signed
	// Skip 4 bits, read 124 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 66 to 96
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0x80) >> 6);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 97 to 127
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1);
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit unsigned
	// Skip 4 bits, read 124 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 66 to 96
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0x80) >> 6);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 97 to 127
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1);
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit signed
	// Skip 5 bits, read 124 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 67 to 97
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xc0) >> 5);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 98 to 128
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0x80) >> 6);
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit unsigned
	// Skip 5 bits, read 124 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 67 to 97
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xc0) >> 5);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 98 to 128
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0x80) >> 6);
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit signed
	// Skip 6 bits, read 124 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 68 to 98
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xe0) >> 4);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 99 to 129
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xc0) >> 5);
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit unsigned
	// Skip 6 bits, read 124 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 68 to 98
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xe0) >> 4);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 99 to 129
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xc0) >> 5);
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit signed
	// Skip 7 bits, read 124 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 69 to 99
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf0) >> 3);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 100 to 130
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xe0) >> 4);
	output[3] = (double)(value >> 1);
}

static void unpack_4_31bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 31-bit unsigned
	// Skip 7 bits, read 124 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 69 to 99
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf0) >> 3);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 100 to 130
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xe0) >> 4);
	output[3] = (double)(value >> 1);
}

static void unpack_5_31bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit signed
	// Skip 0 bits, read 155 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 62 to 92
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf8) >> 2);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 93 to 123
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xf0) >> 3);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 124 to 154
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xe0) >> 4);
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit unsigned
	// Skip 0 bits, read 155 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 62 to 92
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf8) >> 2);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 93 to 123
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xf0) >> 3);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 124 to 154
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xe0) >> 4);
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit signed
	// Skip 1 bits, read 155 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 63 to 93
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xfc) >> 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 94 to 124
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf8) >> 2);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 125 to 155
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xf0) >> 3);
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit unsigned
	// Skip 1 bits, read 155 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 63 to 93
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xfc) >> 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 94 to 124
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf8) >> 2);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 125 to 155
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xf0) >> 3);
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit signed
	// Skip 2 bits, read 155 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 64 to 94
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfe));
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 95 to 125
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xfc) >> 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 126 to 156
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf8) >> 2);
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit unsigned
	// Skip 2 bits, read 155 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 64 to 94
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfe));
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 95 to 125
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xfc) >> 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 126 to 156
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf8) >> 2);
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit signed
	// Skip 3 bits, read 155 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 65 to 95
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 96 to 126
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfe));
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 127 to 157
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xfc) >> 1);
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit unsigned
	// Skip 3 bits, read 155 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 65 to 95
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 96 to 126
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfe));
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 127 to 157
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xfc) >> 1);
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit signed
	// Skip 4 bits, read 155 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 66 to 96
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0x80) >> 6);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 97 to 127
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 128 to 158
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0xfe));
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit unsigned
	// Skip 4 bits, read 155 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 66 to 96
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0x80) >> 6);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 97 to 127
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 128 to 158
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0xfe));
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit signed
	// Skip 5 bits, read 155 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 67 to 97
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xc0) >> 5);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 98 to 128
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0x80) >> 6);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 129 to 159
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1);
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit unsigned
	// Skip 5 bits, read 155 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 67 to 97
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xc0) >> 5);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 98 to 128
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0x80) >> 6);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 129 to 159
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1);
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit signed
	// Skip 6 bits, read 155 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 68 to 98
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xe0) >> 4);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 99 to 129
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xc0) >> 5);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 130 to 160
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0x80) >> 6);
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit unsigned
	// Skip 6 bits, read 155 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 68 to 98
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xe0) >> 4);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 99 to 129
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xc0) >> 5);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 130 to 160
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0x80) >> 6);
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit signed
	// Skip 7 bits, read 155 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 69 to 99
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf0) >> 3);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 100 to 130
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xe0) >> 4);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 131 to 161
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xc0) >> 5);
	output[4] = (double)(value >> 1);
}

static void unpack_5_31bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 31-bit unsigned
	// Skip 7 bits, read 155 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 69 to 99
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf0) >> 3);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 100 to 130
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xe0) >> 4);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 131 to 161
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xc0) >> 5);
	output[4] = (double)(value >> 1);
}

static void unpack_6_31bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit signed
	// Skip 0 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 62 to 92
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf8) >> 2);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 93 to 123
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xf0) >> 3);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 124 to 154
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xe0) >> 4);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 155 to 185
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0xc0) >> 5);
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit unsigned
	// Skip 0 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 62 to 92
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf8) >> 2);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 93 to 123
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xf0) >> 3);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 124 to 154
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xe0) >> 4);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 155 to 185
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0xc0) >> 5);
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit signed
	// Skip 1 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 63 to 93
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xfc) >> 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 94 to 124
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf8) >> 2);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 125 to 155
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xf0) >> 3);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 156 to 186
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xe0) >> 4);
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit unsigned
	// Skip 1 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 63 to 93
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xfc) >> 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 94 to 124
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf8) >> 2);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 125 to 155
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xf0) >> 3);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 156 to 186
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xe0) >> 4);
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit signed
	// Skip 2 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 64 to 94
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfe));
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 95 to 125
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xfc) >> 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 126 to 156
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf8) >> 2);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 157 to 187
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xf0) >> 3);
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit unsigned
	// Skip 2 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 64 to 94
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfe));
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 95 to 125
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xfc) >> 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 126 to 156
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf8) >> 2);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 157 to 187
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xf0) >> 3);
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit signed
	// Skip 3 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 65 to 95
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 96 to 126
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfe));
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 127 to 157
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xfc) >> 1);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 158 to 188
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6) |
			((uint32_t)(input[23] & 0xf8) >> 2);
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit unsigned
	// Skip 3 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 65 to 95
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 96 to 126
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfe));
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 127 to 157
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xfc) >> 1);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 158 to 188
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6) |
			((uint32_t)(input[23] & 0xf8) >> 2);
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit signed
	// Skip 4 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 66 to 96
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0x80) >> 6);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 97 to 127
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 128 to 158
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0xfe));
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 159 to 189
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0xfc) >> 1);
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit unsigned
	// Skip 4 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 66 to 96
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0x80) >> 6);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 97 to 127
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 128 to 158
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0xfe));
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 159 to 189
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0xfc) >> 1);
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit signed
	// Skip 5 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 67 to 97
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xc0) >> 5);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 98 to 128
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0x80) >> 6);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 129 to 159
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 160 to 190
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xfe));
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit unsigned
	// Skip 5 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 67 to 97
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xc0) >> 5);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 98 to 128
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0x80) >> 6);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 129 to 159
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 160 to 190
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xfe));
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit signed
	// Skip 6 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 68 to 98
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xe0) >> 4);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 99 to 129
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xc0) >> 5);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 130 to 160
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0x80) >> 6);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 161 to 191
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1);
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit unsigned
	// Skip 6 bits, read 186 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 68 to 98
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xe0) >> 4);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 99 to 129
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xc0) >> 5);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 130 to 160
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0x80) >> 6);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 161 to 191
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1);
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit signed
	// Skip 7 bits, read 186 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 69 to 99
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf0) >> 3);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 100 to 130
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xe0) >> 4);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 131 to 161
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xc0) >> 5);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 162 to 192
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0x80) >> 6);
	output[5] = (double)(value >> 1);
}

static void unpack_6_31bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 31-bit unsigned
	// Skip 7 bits, read 186 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 69 to 99
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf0) >> 3);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 100 to 130
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xe0) >> 4);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 131 to 161
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xc0) >> 5);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 162 to 192
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0x80) >> 6);
	output[5] = (double)(value >> 1);
}

static void unpack_7_31bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit signed
	// Skip 0 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 62 to 92
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf8) >> 2);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 93 to 123
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xf0) >> 3);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 124 to 154
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xe0) >> 4);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 155 to 185
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0xc0) >> 5);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 186 to 216
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2) |
			((uint32_t)(input[27] & 0x80) >> 6);
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit unsigned
	// Skip 0 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 62 to 92
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf8) >> 2);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 93 to 123
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xf0) >> 3);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 124 to 154
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xe0) >> 4);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 155 to 185
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0xc0) >> 5);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 186 to 216
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2) |
			((uint32_t)(input[27] & 0x80) >> 6);
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit signed
	// Skip 1 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 63 to 93
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xfc) >> 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 94 to 124
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf8) >> 2);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 125 to 155
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xf0) >> 3);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 156 to 186
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xe0) >> 4);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 187 to 217
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0xc0) >> 5);
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit unsigned
	// Skip 1 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 63 to 93
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xfc) >> 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 94 to 124
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf8) >> 2);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 125 to 155
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xf0) >> 3);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 156 to 186
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xe0) >> 4);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 187 to 217
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0xc0) >> 5);
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit signed
	// Skip 2 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 64 to 94
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfe));
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 95 to 125
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xfc) >> 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 126 to 156
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf8) >> 2);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 157 to 187
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xf0) >> 3);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 188 to 218
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)input[26] << 4) |
			((uint32_t)(input[27] & 0xe0) >> 4);
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit unsigned
	// Skip 2 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 64 to 94
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfe));
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 95 to 125
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xfc) >> 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 126 to 156
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf8) >> 2);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 157 to 187
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xf0) >> 3);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 188 to 218
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)input[26] << 4) |
			((uint32_t)(input[27] & 0xe0) >> 4);
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit signed
	// Skip 3 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 65 to 95
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 96 to 126
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfe));
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 127 to 157
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xfc) >> 1);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 158 to 188
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6) |
			((uint32_t)(input[23] & 0xf8) >> 2);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 189 to 219
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)input[26] << 5) |
			((uint32_t)(input[27] & 0xf0) >> 3);
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit unsigned
	// Skip 3 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 65 to 95
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 96 to 126
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfe));
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 127 to 157
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xfc) >> 1);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 158 to 188
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6) |
			((uint32_t)(input[23] & 0xf8) >> 2);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 189 to 219
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)input[26] << 5) |
			((uint32_t)(input[27] & 0xf0) >> 3);
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit signed
	// Skip 4 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 66 to 96
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0x80) >> 6);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 97 to 127
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 128 to 158
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0xfe));
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 159 to 189
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0xfc) >> 1);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 190 to 220
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22) |
			((uint32_t)input[25] << 14) |
			((uint32_t)input[26] << 6) |
			((uint32_t)(input[27] & 0xf8) >> 2);
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit unsigned
	// Skip 4 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 66 to 96
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0x80) >> 6);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 97 to 127
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 128 to 158
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0xfe));
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 159 to 189
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0xfc) >> 1);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 190 to 220
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22) |
			((uint32_t)input[25] << 14) |
			((uint32_t)input[26] << 6) |
			((uint32_t)(input[27] & 0xf8) >> 2);
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit signed
	// Skip 5 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 67 to 97
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xc0) >> 5);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 98 to 128
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0x80) >> 6);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 129 to 159
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 160 to 190
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xfe));
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 191 to 221
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)input[25] << 15) |
			((uint32_t)input[26] << 7) |
			((uint32_t)(input[27] & 0xfc) >> 1);
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit unsigned
	// Skip 5 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 67 to 97
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xc0) >> 5);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 98 to 128
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0x80) >> 6);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 129 to 159
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 160 to 190
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xfe));
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 191 to 221
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)input[25] << 15) |
			((uint32_t)input[26] << 7) |
			((uint32_t)(input[27] & 0xfc) >> 1);
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit signed
	// Skip 6 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 68 to 98
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xe0) >> 4);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 99 to 129
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xc0) >> 5);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 130 to 160
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0x80) >> 6);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 161 to 191
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 192 to 222
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)(input[27] & 0xfe));
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit unsigned
	// Skip 6 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 68 to 98
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xe0) >> 4);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 99 to 129
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xc0) >> 5);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 130 to 160
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0x80) >> 6);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 161 to 191
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 192 to 222
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)(input[27] & 0xfe));
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit signed
	// Skip 7 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 69 to 99
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf0) >> 3);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 100 to 130
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xe0) >> 4);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 131 to 161
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xc0) >> 5);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 162 to 192
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0x80) >> 6);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 193 to 223
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1);
	output[6] = (double)(value >> 1);
}

static void unpack_7_31bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 31-bit unsigned
	// Skip 7 bits, read 217 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 69 to 99
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf0) >> 3);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 100 to 130
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xe0) >> 4);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 131 to 161
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xc0) >> 5);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 162 to 192
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0x80) >> 6);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 193 to 223
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1);
	output[6] = (double)(value >> 1);
}

static void unpack_8_31bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit signed
	// Skip 0 bits, read 248 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 62 to 92
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf8) >> 2);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 93 to 123
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xf0) >> 3);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 124 to 154
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xe0) >> 4);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 155 to 185
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0xc0) >> 5);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 186 to 216
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2) |
			((uint32_t)(input[27] & 0x80) >> 6);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 217 to 247
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)input[30] << 1);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit unsigned
	// Skip 0 bits, read 248 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 30
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)(input[3] & 0xfe));
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 31 to 61
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)input[5] << 15) |
			((uint32_t)input[6] << 7) |
			((uint32_t)(input[7] & 0xfc) >> 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 62 to 92
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)input[10] << 6) |
			((uint32_t)(input[11] & 0xf8) >> 2);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 93 to 123
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)input[14] << 5) |
			((uint32_t)(input[15] & 0xf0) >> 3);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 124 to 154
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12) |
			((uint32_t)input[18] << 4) |
			((uint32_t)(input[19] & 0xe0) >> 4);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 155 to 185
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)input[22] << 3) |
			((uint32_t)(input[23] & 0xc0) >> 5);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 186 to 216
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)input[25] << 10) |
			((uint32_t)input[26] << 2) |
			((uint32_t)(input[27] & 0x80) >> 6);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 217 to 247
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)input[29] << 9) |
			((uint32_t)input[30] << 1);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit signed
	// Skip 1 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 63 to 93
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xfc) >> 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 94 to 124
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf8) >> 2);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 125 to 155
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xf0) >> 3);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 156 to 186
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xe0) >> 4);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 187 to 217
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0xc0) >> 5);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 218 to 248
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)input[30] << 2) |
			((uint32_t)(input[31] & 0x80) >> 6);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit unsigned
	// Skip 1 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 31
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 32 to 62
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)(input[7] & 0xfe));
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 63 to 93
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)input[10] << 7) |
			((uint32_t)(input[11] & 0xfc) >> 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 94 to 124
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)input[14] << 6) |
			((uint32_t)(input[15] & 0xf8) >> 2);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 125 to 155
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)input[18] << 5) |
			((uint32_t)(input[19] & 0xf0) >> 3);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 156 to 186
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)input[22] << 4) |
			((uint32_t)(input[23] & 0xe0) >> 4);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 187 to 217
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)input[25] << 11) |
			((uint32_t)input[26] << 3) |
			((uint32_t)(input[27] & 0xc0) >> 5);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 218 to 248
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)input[29] << 10) |
			((uint32_t)input[30] << 2) |
			((uint32_t)(input[31] & 0x80) >> 6);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit signed
	// Skip 2 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 64 to 94
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfe));
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 95 to 125
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xfc) >> 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 126 to 156
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf8) >> 2);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 157 to 187
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xf0) >> 3);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 188 to 218
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)input[26] << 4) |
			((uint32_t)(input[27] & 0xe0) >> 4);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 219 to 249
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)input[30] << 3) |
			((uint32_t)(input[31] & 0xc0) >> 5);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit unsigned
	// Skip 2 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 32
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0x80) >> 6);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 33 to 63
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 64 to 94
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)(input[11] & 0xfe));
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 95 to 125
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)input[14] << 7) |
			((uint32_t)(input[15] & 0xfc) >> 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 126 to 156
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)input[18] << 6) |
			((uint32_t)(input[19] & 0xf8) >> 2);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 157 to 187
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)input[22] << 5) |
			((uint32_t)(input[23] & 0xf0) >> 3);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 188 to 218
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)input[25] << 12) |
			((uint32_t)input[26] << 4) |
			((uint32_t)(input[27] & 0xe0) >> 4);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 219 to 249
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)input[29] << 11) |
			((uint32_t)input[30] << 3) |
			((uint32_t)(input[31] & 0xc0) >> 5);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit signed
	// Skip 3 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 65 to 95
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 96 to 126
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfe));
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 127 to 157
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xfc) >> 1);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 158 to 188
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6) |
			((uint32_t)(input[23] & 0xf8) >> 2);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 189 to 219
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)input[26] << 5) |
			((uint32_t)(input[27] & 0xf0) >> 3);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 220 to 250
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)input[30] << 4) |
			((uint32_t)(input[31] & 0xe0) >> 4);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit unsigned
	// Skip 3 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 33
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xc0) >> 5);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 34 to 64
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0x80) >> 6);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 65 to 95
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 96 to 126
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)(input[15] & 0xfe));
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 127 to 157
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)input[18] << 7) |
			((uint32_t)(input[19] & 0xfc) >> 1);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 158 to 188
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)input[22] << 6) |
			((uint32_t)(input[23] & 0xf8) >> 2);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 189 to 219
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)input[25] << 13) |
			((uint32_t)input[26] << 5) |
			((uint32_t)(input[27] & 0xf0) >> 3);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 220 to 250
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)input[30] << 4) |
			((uint32_t)(input[31] & 0xe0) >> 4);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit signed
	// Skip 4 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 66 to 96
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0x80) >> 6);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 97 to 127
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 128 to 158
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0xfe));
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 159 to 189
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0xfc) >> 1);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 190 to 220
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22) |
			((uint32_t)input[25] << 14) |
			((uint32_t)input[26] << 6) |
			((uint32_t)(input[27] & 0xf8) >> 2);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 221 to 251
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)input[30] << 5) |
			((uint32_t)(input[31] & 0xf0) >> 3);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit unsigned
	// Skip 4 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 34
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xe0) >> 4);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 35 to 65
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xc0) >> 5);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 66 to 96
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0x80) >> 6);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 97 to 127
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 128 to 158
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)(input[19] & 0xfe));
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 159 to 189
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)input[22] << 7) |
			((uint32_t)(input[23] & 0xfc) >> 1);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 190 to 220
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22) |
			((uint32_t)input[25] << 14) |
			((uint32_t)input[26] << 6) |
			((uint32_t)(input[27] & 0xf8) >> 2);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 221 to 251
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)input[30] << 5) |
			((uint32_t)(input[31] & 0xf0) >> 3);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit signed
	// Skip 5 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 67 to 97
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xc0) >> 5);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 98 to 128
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0x80) >> 6);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 129 to 159
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 160 to 190
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xfe));
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 191 to 221
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)input[25] << 15) |
			((uint32_t)input[26] << 7) |
			((uint32_t)(input[27] & 0xfc) >> 1);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 222 to 252
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)input[30] << 6) |
			((uint32_t)(input[31] & 0xf8) >> 2);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit unsigned
	// Skip 5 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 35
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf0) >> 3);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 36 to 66
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xe0) >> 4);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 67 to 97
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xc0) >> 5);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 98 to 128
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0x80) >> 6);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 129 to 159
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 160 to 190
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)(input[23] & 0xfe));
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 191 to 221
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)input[25] << 15) |
			((uint32_t)input[26] << 7) |
			((uint32_t)(input[27] & 0xfc) >> 1);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 222 to 252
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)input[30] << 6) |
			((uint32_t)(input[31] & 0xf8) >> 2);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit signed
	// Skip 6 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 68 to 98
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xe0) >> 4);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 99 to 129
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xc0) >> 5);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 130 to 160
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0x80) >> 6);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 161 to 191
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 192 to 222
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)(input[27] & 0xfe));
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 223 to 253
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)input[30] << 7) |
			((uint32_t)(input[31] & 0xfc) >> 1);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit unsigned
	// Skip 6 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 36
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xf8) >> 2);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 37 to 67
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf0) >> 3);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 68 to 98
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xe0) >> 4);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 99 to 129
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xc0) >> 5);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 130 to 160
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0x80) >> 6);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 161 to 191
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 192 to 222
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)(input[27] & 0xfe));
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 223 to 253
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)input[30] << 7) |
			((uint32_t)(input[31] & 0xfc) >> 1);
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit signed
	// Skip 7 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 69 to 99
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf0) >> 3);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 100 to 130
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xe0) >> 4);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 131 to 161
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xc0) >> 5);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 162 to 192
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0x80) >> 6);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 193 to 223
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 224 to 254
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xfe));
	output[7] = (double)(value >> 1);
}

static void unpack_8_31bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 31-bit unsigned
	// Skip 7 bits, read 248 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 37
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfc) >> 1);
	output[0] = (double)(value >> 1);

	// read output[1]: from bit 38 to 68
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xf8) >> 2);
	output[1] = (double)(value >> 1);

	// read output[2]: from bit 69 to 99
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf0) >> 3);
	output[2] = (double)(value >> 1);

	// read output[3]: from bit 100 to 130
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xe0) >> 4);
	output[3] = (double)(value >> 1);

	// read output[4]: from bit 131 to 161
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xc0) >> 5);
	output[4] = (double)(value >> 1);

	// read output[5]: from bit 162 to 192
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0x80) >> 6);
	output[5] = (double)(value >> 1);

	// read output[6]: from bit 193 to 223
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1);
	output[6] = (double)(value >> 1);

	// read output[7]: from bit 224 to 254
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)(input[31] & 0xfe));
	output[7] = (double)(value >> 1);
}


unpack_func_t unpack_31bit[UNPACK_31BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_31bit_unsigned_0off,
			unpack_1_31bit_signed_0off,
		},
		{
			unpack_1_31bit_unsigned_1off,
			unpack_1_31bit_signed_1off,
		},
		{
			unpack_1_31bit_unsigned_2off,
			unpack_1_31bit_signed_2off,
		},
		{
			unpack_1_31bit_unsigned_3off,
			unpack_1_31bit_signed_3off,
		},
		{
			unpack_1_31bit_unsigned_4off,
			unpack_1_31bit_signed_4off,
		},
		{
			unpack_1_31bit_unsigned_5off,
			unpack_1_31bit_signed_5off,
		},
		{
			unpack_1_31bit_unsigned_6off,
			unpack_1_31bit_signed_6off,
		},
		{
			unpack_1_31bit_unsigned_7off,
			unpack_1_31bit_signed_7off,
		},
	},
	{
		{
			unpack_2_31bit_unsigned_0off,
			unpack_2_31bit_signed_0off,
		},
		{
			unpack_2_31bit_unsigned_1off,
			unpack_2_31bit_signed_1off,
		},
		{
			unpack_2_31bit_unsigned_2off,
			unpack_2_31bit_signed_2off,
		},
		{
			unpack_2_31bit_unsigned_3off,
			unpack_2_31bit_signed_3off,
		},
		{
			unpack_2_31bit_unsigned_4off,
			unpack_2_31bit_signed_4off,
		},
		{
			unpack_2_31bit_unsigned_5off,
			unpack_2_31bit_signed_5off,
		},
		{
			unpack_2_31bit_unsigned_6off,
			unpack_2_31bit_signed_6off,
		},
		{
			unpack_2_31bit_unsigned_7off,
			unpack_2_31bit_signed_7off,
		},
	},
	{
		{
			unpack_3_31bit_unsigned_0off,
			unpack_3_31bit_signed_0off,
		},
		{
			unpack_3_31bit_unsigned_1off,
			unpack_3_31bit_signed_1off,
		},
		{
			unpack_3_31bit_unsigned_2off,
			unpack_3_31bit_signed_2off,
		},
		{
			unpack_3_31bit_unsigned_3off,
			unpack_3_31bit_signed_3off,
		},
		{
			unpack_3_31bit_unsigned_4off,
			unpack_3_31bit_signed_4off,
		},
		{
			unpack_3_31bit_unsigned_5off,
			unpack_3_31bit_signed_5off,
		},
		{
			unpack_3_31bit_unsigned_6off,
			unpack_3_31bit_signed_6off,
		},
		{
			unpack_3_31bit_unsigned_7off,
			unpack_3_31bit_signed_7off,
		},
	},
	{
		{
			unpack_4_31bit_unsigned_0off,
			unpack_4_31bit_signed_0off,
		},
		{
			unpack_4_31bit_unsigned_1off,
			unpack_4_31bit_signed_1off,
		},
		{
			unpack_4_31bit_unsigned_2off,
			unpack_4_31bit_signed_2off,
		},
		{
			unpack_4_31bit_unsigned_3off,
			unpack_4_31bit_signed_3off,
		},
		{
			unpack_4_31bit_unsigned_4off,
			unpack_4_31bit_signed_4off,
		},
		{
			unpack_4_31bit_unsigned_5off,
			unpack_4_31bit_signed_5off,
		},
		{
			unpack_4_31bit_unsigned_6off,
			unpack_4_31bit_signed_6off,
		},
		{
			unpack_4_31bit_unsigned_7off,
			unpack_4_31bit_signed_7off,
		},
	},
	{
		{
			unpack_5_31bit_unsigned_0off,
			unpack_5_31bit_signed_0off,
		},
		{
			unpack_5_31bit_unsigned_1off,
			unpack_5_31bit_signed_1off,
		},
		{
			unpack_5_31bit_unsigned_2off,
			unpack_5_31bit_signed_2off,
		},
		{
			unpack_5_31bit_unsigned_3off,
			unpack_5_31bit_signed_3off,
		},
		{
			unpack_5_31bit_unsigned_4off,
			unpack_5_31bit_signed_4off,
		},
		{
			unpack_5_31bit_unsigned_5off,
			unpack_5_31bit_signed_5off,
		},
		{
			unpack_5_31bit_unsigned_6off,
			unpack_5_31bit_signed_6off,
		},
		{
			unpack_5_31bit_unsigned_7off,
			unpack_5_31bit_signed_7off,
		},
	},
	{
		{
			unpack_6_31bit_unsigned_0off,
			unpack_6_31bit_signed_0off,
		},
		{
			unpack_6_31bit_unsigned_1off,
			unpack_6_31bit_signed_1off,
		},
		{
			unpack_6_31bit_unsigned_2off,
			unpack_6_31bit_signed_2off,
		},
		{
			unpack_6_31bit_unsigned_3off,
			unpack_6_31bit_signed_3off,
		},
		{
			unpack_6_31bit_unsigned_4off,
			unpack_6_31bit_signed_4off,
		},
		{
			unpack_6_31bit_unsigned_5off,
			unpack_6_31bit_signed_5off,
		},
		{
			unpack_6_31bit_unsigned_6off,
			unpack_6_31bit_signed_6off,
		},
		{
			unpack_6_31bit_unsigned_7off,
			unpack_6_31bit_signed_7off,
		},
	},
	{
		{
			unpack_7_31bit_unsigned_0off,
			unpack_7_31bit_signed_0off,
		},
		{
			unpack_7_31bit_unsigned_1off,
			unpack_7_31bit_signed_1off,
		},
		{
			unpack_7_31bit_unsigned_2off,
			unpack_7_31bit_signed_2off,
		},
		{
			unpack_7_31bit_unsigned_3off,
			unpack_7_31bit_signed_3off,
		},
		{
			unpack_7_31bit_unsigned_4off,
			unpack_7_31bit_signed_4off,
		},
		{
			unpack_7_31bit_unsigned_5off,
			unpack_7_31bit_signed_5off,
		},
		{
			unpack_7_31bit_unsigned_6off,
			unpack_7_31bit_signed_6off,
		},
		{
			unpack_7_31bit_unsigned_7off,
			unpack_7_31bit_signed_7off,
		},
	},
	{
		{
			unpack_8_31bit_unsigned_0off,
			unpack_8_31bit_signed_0off,
		},
		{
			unpack_8_31bit_unsigned_1off,
			unpack_8_31bit_signed_1off,
		},
		{
			unpack_8_31bit_unsigned_2off,
			unpack_8_31bit_signed_2off,
		},
		{
			unpack_8_31bit_unsigned_3off,
			unpack_8_31bit_signed_3off,
		},
		{
			unpack_8_31bit_unsigned_4off,
			unpack_8_31bit_signed_4off,
		},
		{
			unpack_8_31bit_unsigned_5off,
			unpack_8_31bit_signed_5off,
		},
		{
			unpack_8_31bit_unsigned_6off,
			unpack_8_31bit_signed_6off,
		},
		{
			unpack_8_31bit_unsigned_7off,
			unpack_8_31bit_signed_7off,
		},
	},
};
