// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack32.h"



static void unpack_1_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 32 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;
}

static void unpack_1_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 32 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;
}

static void unpack_1_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;
}

static void unpack_1_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;
}

static void unpack_1_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;
}

static void unpack_1_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;
}

static void unpack_1_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;
}

static void unpack_1_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;
}

static void unpack_1_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;
}

static void unpack_1_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;
}

static void unpack_1_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;
}

static void unpack_1_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;
}

static void unpack_1_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;
}

static void unpack_1_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;
}

static void unpack_1_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;
}

static void unpack_1_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;
}

static void unpack_2_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 64 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;
}

static void unpack_2_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 64 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;
}

static void unpack_2_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;
}

static void unpack_2_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;
}

static void unpack_2_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;
}

static void unpack_2_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;
}

static void unpack_2_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;
}

static void unpack_2_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;
}

static void unpack_2_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;
}

static void unpack_2_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;
}

static void unpack_2_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;
}

static void unpack_2_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;
}

static void unpack_2_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;
}

static void unpack_2_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;
}

static void unpack_2_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;
}

static void unpack_2_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;
}

static void unpack_3_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 96 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;
}

static void unpack_3_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 96 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;
}

static void unpack_3_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;
}

static void unpack_3_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;
}

static void unpack_3_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;
}

static void unpack_3_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;
}

static void unpack_3_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;
}

static void unpack_3_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;
}

static void unpack_3_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;
}

static void unpack_3_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;
}

static void unpack_3_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;
}

static void unpack_3_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;
}

static void unpack_3_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;
}

static void unpack_3_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;
}

static void unpack_3_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;
}

static void unpack_3_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;
}

static void unpack_4_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 128 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;
}

static void unpack_4_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 128 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;
}

static void unpack_4_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;
}

static void unpack_4_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;
}

static void unpack_4_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;
}

static void unpack_4_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;
}

static void unpack_4_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;
}

static void unpack_4_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;
}

static void unpack_4_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;
}

static void unpack_4_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;
}

static void unpack_4_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;
}

static void unpack_4_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;
}

static void unpack_4_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;
}

static void unpack_4_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;
}

static void unpack_4_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;
}

static void unpack_4_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;
}

static void unpack_5_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 160 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;
}

static void unpack_5_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 160 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;
}

static void unpack_5_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;
}

static void unpack_5_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;
}

static void unpack_5_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;
}

static void unpack_5_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;
}

static void unpack_5_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;
}

static void unpack_5_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;
}

static void unpack_5_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;
}

static void unpack_5_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;
}

static void unpack_5_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;
}

static void unpack_5_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;
}

static void unpack_5_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;
}

static void unpack_5_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;
}

static void unpack_5_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;
}

static void unpack_5_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;
}

static void unpack_6_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 192 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;
}

static void unpack_6_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 192 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;
}

static void unpack_6_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;
}

static void unpack_6_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;
}

static void unpack_6_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;
}

static void unpack_6_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;
}

static void unpack_6_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;
}

static void unpack_6_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;
}

static void unpack_6_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;
}

static void unpack_6_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;
}

static void unpack_6_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;
}

static void unpack_6_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;
}

static void unpack_6_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;
}

static void unpack_6_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;
}

static void unpack_6_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;
}

static void unpack_6_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;
}

static void unpack_7_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 224 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;
}

static void unpack_7_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 224 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;
}

static void unpack_7_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;
}

static void unpack_7_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;
}

static void unpack_7_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;
}

static void unpack_7_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;
}

static void unpack_7_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;
}

static void unpack_7_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;
}

static void unpack_7_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;
}

static void unpack_7_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;
}

static void unpack_7_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;
}

static void unpack_7_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;
}

static void unpack_7_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;
}

static void unpack_7_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;
}

static void unpack_7_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;
}

static void unpack_7_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;
}

static void unpack_8_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 256 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;
}

static void unpack_8_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 256 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;
}

static void unpack_8_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;
}

static void unpack_8_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;
}

static void unpack_8_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;
}

static void unpack_8_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;
}

static void unpack_8_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;
}

static void unpack_8_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;
}

static void unpack_8_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;
}

static void unpack_8_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;
}

static void unpack_8_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;
}

static void unpack_8_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;
}

static void unpack_8_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;
}

static void unpack_8_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;
}

static void unpack_8_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;
}

static void unpack_8_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;
}

static void unpack_9_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 288 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;
}

static void unpack_9_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 288 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;
}

static void unpack_9_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;
}

static void unpack_9_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;
}

static void unpack_9_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;
}

static void unpack_9_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;
}

static void unpack_9_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;
}

static void unpack_9_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;
}

static void unpack_9_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;
}

static void unpack_9_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;
}

static void unpack_9_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;
}

static void unpack_9_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;
}

static void unpack_9_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;
}

static void unpack_9_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;
}

static void unpack_9_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;
}

static void unpack_9_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;
}

static void unpack_10_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 320 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;
}

static void unpack_10_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 320 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;
}

static void unpack_10_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;
}

static void unpack_10_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;
}

static void unpack_10_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;
}

static void unpack_10_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;
}

static void unpack_10_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;
}

static void unpack_10_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;
}

static void unpack_10_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;
}

static void unpack_10_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;
}

static void unpack_10_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;
}

static void unpack_10_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;
}

static void unpack_10_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;
}

static void unpack_10_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;
}

static void unpack_10_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;
}

static void unpack_10_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;
}

static void unpack_11_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 352 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;
}

static void unpack_11_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 352 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;
}

static void unpack_11_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;
}

static void unpack_11_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;
}

static void unpack_11_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;
}

static void unpack_11_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;
}

static void unpack_11_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;
}

static void unpack_11_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;
}

static void unpack_11_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;
}

static void unpack_11_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;
}

static void unpack_11_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;
}

static void unpack_11_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;
}

static void unpack_11_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;
}

static void unpack_11_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;
}

static void unpack_11_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;
}

static void unpack_11_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;
}

static void unpack_12_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 384 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;
}

static void unpack_12_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 384 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;
}

static void unpack_12_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;
}

static void unpack_12_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;
}

static void unpack_12_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;
}

static void unpack_12_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;
}

static void unpack_12_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;
}

static void unpack_12_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;
}

static void unpack_12_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;
}

static void unpack_12_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;
}

static void unpack_12_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;
}

static void unpack_12_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;
}

static void unpack_12_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;
}

static void unpack_12_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;
}

static void unpack_12_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;
}

static void unpack_12_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;
}

static void unpack_13_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 416 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;
}

static void unpack_13_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 416 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;
}

static void unpack_13_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;
}

static void unpack_13_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;
}

static void unpack_13_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;
}

static void unpack_13_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;
}

static void unpack_13_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;
}

static void unpack_13_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;
}

static void unpack_13_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;
}

static void unpack_13_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;
}

static void unpack_13_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;
}

static void unpack_13_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;
}

static void unpack_13_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;
}

static void unpack_13_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;
}

static void unpack_13_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;
}

static void unpack_13_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 416 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;
}

static void unpack_14_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 448 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;
}

static void unpack_14_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 448 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;
}

static void unpack_14_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;
}

static void unpack_14_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;
}

static void unpack_14_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;
}

static void unpack_14_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;
}

static void unpack_14_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;
}

static void unpack_14_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;
}

static void unpack_14_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;
}

static void unpack_14_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;
}

static void unpack_14_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;
}

static void unpack_14_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;
}

static void unpack_14_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;
}

static void unpack_14_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;
}

static void unpack_14_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;
}

static void unpack_14_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 448 bits of data.
	// Input must be at least 57 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;
}

static void unpack_15_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 480 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;
}

static void unpack_15_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 480 bits of data.
	// Input must be at least 60 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;
}

static void unpack_15_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;
}

static void unpack_15_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;
}

static void unpack_15_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;
}

static void unpack_15_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;
}

static void unpack_15_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;
}

static void unpack_15_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;
}

static void unpack_15_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;
}

static void unpack_15_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;
}

static void unpack_15_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;
}

static void unpack_15_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;
}

static void unpack_15_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;

	// read output[14]: from bit 454 to 485
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xfc) >> 2);
	output[14] = (double)value;
}

static void unpack_15_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;

	// read output[14]: from bit 454 to 485
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xfc) >> 2);
	output[14] = (double)value;
}

static void unpack_15_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;

	// read output[14]: from bit 455 to 486
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xfe) >> 1);
	output[14] = (double)value;
}

static void unpack_15_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 480 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;

	// read output[14]: from bit 455 to 486
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xfe) >> 1);
	output[14] = (double)value;
}

static void unpack_16_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 512 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;

	// read output[15]: from bit 480 to 511
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)input[63]);
	output[15] = (double)value;
}

static void unpack_16_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 512 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;

	// read output[15]: from bit 480 to 511
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)input[63]);
	output[15] = (double)value;
}

static void unpack_16_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;

	// read output[15]: from bit 481 to 512
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)input[63] << 1) |
			((uint32_t)(input[64] & 0x80) >> 7);
	output[15] = (double)value;
}

static void unpack_16_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;

	// read output[15]: from bit 481 to 512
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)input[63] << 1) |
			((uint32_t)(input[64] & 0x80) >> 7);
	output[15] = (double)value;
}

static void unpack_16_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;

	// read output[15]: from bit 482 to 513
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2) |
			((uint32_t)(input[64] & 0xc0) >> 6);
	output[15] = (double)value;
}

static void unpack_16_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;

	// read output[15]: from bit 482 to 513
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2) |
			((uint32_t)(input[64] & 0xc0) >> 6);
	output[15] = (double)value;
}

static void unpack_16_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;

	// read output[15]: from bit 483 to 514
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0xe0) >> 5);
	output[15] = (double)value;
}

static void unpack_16_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;

	// read output[15]: from bit 483 to 514
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0xe0) >> 5);
	output[15] = (double)value;
}

static void unpack_16_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;

	// read output[15]: from bit 484 to 515
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xf0) >> 4);
	output[15] = (double)value;
}

static void unpack_16_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;

	// read output[15]: from bit 484 to 515
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xf0) >> 4);
	output[15] = (double)value;
}

static void unpack_16_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;

	// read output[15]: from bit 485 to 516
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xf8) >> 3);
	output[15] = (double)value;
}

static void unpack_16_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;

	// read output[15]: from bit 485 to 516
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xf8) >> 3);
	output[15] = (double)value;
}

static void unpack_16_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;

	// read output[14]: from bit 454 to 485
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xfc) >> 2);
	output[14] = (double)value;

	// read output[15]: from bit 486 to 517
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)input[63] << 6) |
			((uint32_t)(input[64] & 0xfc) >> 2);
	output[15] = (double)value;
}

static void unpack_16_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;

	// read output[14]: from bit 454 to 485
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xfc) >> 2);
	output[14] = (double)value;

	// read output[15]: from bit 486 to 517
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)input[63] << 6) |
			((uint32_t)(input[64] & 0xfc) >> 2);
	output[15] = (double)value;
}

static void unpack_16_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;

	// read output[14]: from bit 455 to 486
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xfe) >> 1);
	output[14] = (double)value;

	// read output[15]: from bit 487 to 518
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)input[63] << 7) |
			((uint32_t)(input[64] & 0xfe) >> 1);
	output[15] = (double)value;
}

static void unpack_16_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 512 bits of data.
	// Input must be at least 65 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;

	// read output[14]: from bit 455 to 486
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xfe) >> 1);
	output[14] = (double)value;

	// read output[15]: from bit 487 to 518
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)input[63] << 7) |
			((uint32_t)(input[64] & 0xfe) >> 1);
	output[15] = (double)value;
}

static void unpack_17_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 544 bits of data.
	// Input must be at least 68 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;

	// read output[15]: from bit 480 to 511
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)input[63]);
	output[15] = (double)value;

	// read output[16]: from bit 512 to 543
	value = ((uint32_t)input[64] << 24) |
			((uint32_t)input[65] << 16) |
			((uint32_t)input[66] << 8) |
			((uint32_t)input[67]);
	output[16] = (double)value;
}

static void unpack_17_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 544 bits of data.
	// Input must be at least 68 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;

	// read output[15]: from bit 480 to 511
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)input[63]);
	output[15] = (double)value;

	// read output[16]: from bit 512 to 543
	value = ((uint32_t)input[64] << 24) |
			((uint32_t)input[65] << 16) |
			((uint32_t)input[66] << 8) |
			((uint32_t)input[67]);
	output[16] = (double)value;
}

static void unpack_17_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;

	// read output[15]: from bit 481 to 512
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)input[63] << 1) |
			((uint32_t)(input[64] & 0x80) >> 7);
	output[15] = (double)value;

	// read output[16]: from bit 513 to 544
	value = ((uint32_t)(input[64] & 0x7f) << 25) |
			((uint32_t)input[65] << 17) |
			((uint32_t)input[66] << 9) |
			((uint32_t)input[67] << 1) |
			((uint32_t)(input[68] & 0x80) >> 7);
	output[16] = (double)value;
}

static void unpack_17_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;

	// read output[15]: from bit 481 to 512
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)input[63] << 1) |
			((uint32_t)(input[64] & 0x80) >> 7);
	output[15] = (double)value;

	// read output[16]: from bit 513 to 544
	value = ((uint32_t)(input[64] & 0x7f) << 25) |
			((uint32_t)input[65] << 17) |
			((uint32_t)input[66] << 9) |
			((uint32_t)input[67] << 1) |
			((uint32_t)(input[68] & 0x80) >> 7);
	output[16] = (double)value;
}

static void unpack_17_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;

	// read output[15]: from bit 482 to 513
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2) |
			((uint32_t)(input[64] & 0xc0) >> 6);
	output[15] = (double)value;

	// read output[16]: from bit 514 to 545
	value = ((uint32_t)(input[64] & 0x3f) << 26) |
			((uint32_t)input[65] << 18) |
			((uint32_t)input[66] << 10) |
			((uint32_t)input[67] << 2) |
			((uint32_t)(input[68] & 0xc0) >> 6);
	output[16] = (double)value;
}

static void unpack_17_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;

	// read output[15]: from bit 482 to 513
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2) |
			((uint32_t)(input[64] & 0xc0) >> 6);
	output[15] = (double)value;

	// read output[16]: from bit 514 to 545
	value = ((uint32_t)(input[64] & 0x3f) << 26) |
			((uint32_t)input[65] << 18) |
			((uint32_t)input[66] << 10) |
			((uint32_t)input[67] << 2) |
			((uint32_t)(input[68] & 0xc0) >> 6);
	output[16] = (double)value;
}

static void unpack_17_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;

	// read output[15]: from bit 483 to 514
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0xe0) >> 5);
	output[15] = (double)value;

	// read output[16]: from bit 515 to 546
	value = ((uint32_t)(input[64] & 0x1f) << 27) |
			((uint32_t)input[65] << 19) |
			((uint32_t)input[66] << 11) |
			((uint32_t)input[67] << 3) |
			((uint32_t)(input[68] & 0xe0) >> 5);
	output[16] = (double)value;
}

static void unpack_17_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;

	// read output[15]: from bit 483 to 514
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0xe0) >> 5);
	output[15] = (double)value;

	// read output[16]: from bit 515 to 546
	value = ((uint32_t)(input[64] & 0x1f) << 27) |
			((uint32_t)input[65] << 19) |
			((uint32_t)input[66] << 11) |
			((uint32_t)input[67] << 3) |
			((uint32_t)(input[68] & 0xe0) >> 5);
	output[16] = (double)value;
}

static void unpack_17_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;

	// read output[15]: from bit 484 to 515
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xf0) >> 4);
	output[15] = (double)value;

	// read output[16]: from bit 516 to 547
	value = ((uint32_t)(input[64] & 0x0f) << 28) |
			((uint32_t)input[65] << 20) |
			((uint32_t)input[66] << 12) |
			((uint32_t)input[67] << 4) |
			((uint32_t)(input[68] & 0xf0) >> 4);
	output[16] = (double)value;
}

static void unpack_17_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;

	// read output[15]: from bit 484 to 515
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xf0) >> 4);
	output[15] = (double)value;

	// read output[16]: from bit 516 to 547
	value = ((uint32_t)(input[64] & 0x0f) << 28) |
			((uint32_t)input[65] << 20) |
			((uint32_t)input[66] << 12) |
			((uint32_t)input[67] << 4) |
			((uint32_t)(input[68] & 0xf0) >> 4);
	output[16] = (double)value;
}

static void unpack_17_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;

	// read output[15]: from bit 485 to 516
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xf8) >> 3);
	output[15] = (double)value;

	// read output[16]: from bit 517 to 548
	value = ((uint32_t)(input[64] & 0x07) << 29) |
			((uint32_t)input[65] << 21) |
			((uint32_t)input[66] << 13) |
			((uint32_t)input[67] << 5) |
			((uint32_t)(input[68] & 0xf8) >> 3);
	output[16] = (double)value;
}

static void unpack_17_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;

	// read output[15]: from bit 485 to 516
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xf8) >> 3);
	output[15] = (double)value;

	// read output[16]: from bit 517 to 548
	value = ((uint32_t)(input[64] & 0x07) << 29) |
			((uint32_t)input[65] << 21) |
			((uint32_t)input[66] << 13) |
			((uint32_t)input[67] << 5) |
			((uint32_t)(input[68] & 0xf8) >> 3);
	output[16] = (double)value;
}

static void unpack_17_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;

	// read output[14]: from bit 454 to 485
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xfc) >> 2);
	output[14] = (double)value;

	// read output[15]: from bit 486 to 517
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)input[63] << 6) |
			((uint32_t)(input[64] & 0xfc) >> 2);
	output[15] = (double)value;

	// read output[16]: from bit 518 to 549
	value = ((uint32_t)(input[64] & 0x03) << 30) |
			((uint32_t)input[65] << 22) |
			((uint32_t)input[66] << 14) |
			((uint32_t)input[67] << 6) |
			((uint32_t)(input[68] & 0xfc) >> 2);
	output[16] = (double)value;
}

static void unpack_17_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;

	// read output[14]: from bit 454 to 485
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xfc) >> 2);
	output[14] = (double)value;

	// read output[15]: from bit 486 to 517
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)input[63] << 6) |
			((uint32_t)(input[64] & 0xfc) >> 2);
	output[15] = (double)value;

	// read output[16]: from bit 518 to 549
	value = ((uint32_t)(input[64] & 0x03) << 30) |
			((uint32_t)input[65] << 22) |
			((uint32_t)input[66] << 14) |
			((uint32_t)input[67] << 6) |
			((uint32_t)(input[68] & 0xfc) >> 2);
	output[16] = (double)value;
}

static void unpack_17_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;

	// read output[14]: from bit 455 to 486
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xfe) >> 1);
	output[14] = (double)value;

	// read output[15]: from bit 487 to 518
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)input[63] << 7) |
			((uint32_t)(input[64] & 0xfe) >> 1);
	output[15] = (double)value;

	// read output[16]: from bit 519 to 550
	value = ((uint32_t)(input[64] & 0x01) << 31) |
			((uint32_t)input[65] << 23) |
			((uint32_t)input[66] << 15) |
			((uint32_t)input[67] << 7) |
			((uint32_t)(input[68] & 0xfe) >> 1);
	output[16] = (double)value;
}

static void unpack_17_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 544 bits of data.
	// Input must be at least 69 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;

	// read output[14]: from bit 455 to 486
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xfe) >> 1);
	output[14] = (double)value;

	// read output[15]: from bit 487 to 518
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)input[63] << 7) |
			((uint32_t)(input[64] & 0xfe) >> 1);
	output[15] = (double)value;

	// read output[16]: from bit 519 to 550
	value = ((uint32_t)(input[64] & 0x01) << 31) |
			((uint32_t)input[65] << 23) |
			((uint32_t)input[66] << 15) |
			((uint32_t)input[67] << 7) |
			((uint32_t)(input[68] & 0xfe) >> 1);
	output[16] = (double)value;
}

static void unpack_18_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 576 bits of data.
	// Input must be at least 72 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;

	// read output[15]: from bit 480 to 511
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)input[63]);
	output[15] = (double)value;

	// read output[16]: from bit 512 to 543
	value = ((uint32_t)input[64] << 24) |
			((uint32_t)input[65] << 16) |
			((uint32_t)input[66] << 8) |
			((uint32_t)input[67]);
	output[16] = (double)value;

	// read output[17]: from bit 544 to 575
	value = ((uint32_t)input[68] << 24) |
			((uint32_t)input[69] << 16) |
			((uint32_t)input[70] << 8) |
			((uint32_t)input[71]);
	output[17] = (double)value;
}

static void unpack_18_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 576 bits of data.
	// Input must be at least 72 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;

	// read output[15]: from bit 480 to 511
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)input[63]);
	output[15] = (double)value;

	// read output[16]: from bit 512 to 543
	value = ((uint32_t)input[64] << 24) |
			((uint32_t)input[65] << 16) |
			((uint32_t)input[66] << 8) |
			((uint32_t)input[67]);
	output[16] = (double)value;

	// read output[17]: from bit 544 to 575
	value = ((uint32_t)input[68] << 24) |
			((uint32_t)input[69] << 16) |
			((uint32_t)input[70] << 8) |
			((uint32_t)input[71]);
	output[17] = (double)value;
}

static void unpack_18_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;

	// read output[15]: from bit 481 to 512
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)input[63] << 1) |
			((uint32_t)(input[64] & 0x80) >> 7);
	output[15] = (double)value;

	// read output[16]: from bit 513 to 544
	value = ((uint32_t)(input[64] & 0x7f) << 25) |
			((uint32_t)input[65] << 17) |
			((uint32_t)input[66] << 9) |
			((uint32_t)input[67] << 1) |
			((uint32_t)(input[68] & 0x80) >> 7);
	output[16] = (double)value;

	// read output[17]: from bit 545 to 576
	value = ((uint32_t)(input[68] & 0x7f) << 25) |
			((uint32_t)input[69] << 17) |
			((uint32_t)input[70] << 9) |
			((uint32_t)input[71] << 1) |
			((uint32_t)(input[72] & 0x80) >> 7);
	output[17] = (double)value;
}

static void unpack_18_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;

	// read output[15]: from bit 481 to 512
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)input[63] << 1) |
			((uint32_t)(input[64] & 0x80) >> 7);
	output[15] = (double)value;

	// read output[16]: from bit 513 to 544
	value = ((uint32_t)(input[64] & 0x7f) << 25) |
			((uint32_t)input[65] << 17) |
			((uint32_t)input[66] << 9) |
			((uint32_t)input[67] << 1) |
			((uint32_t)(input[68] & 0x80) >> 7);
	output[16] = (double)value;

	// read output[17]: from bit 545 to 576
	value = ((uint32_t)(input[68] & 0x7f) << 25) |
			((uint32_t)input[69] << 17) |
			((uint32_t)input[70] << 9) |
			((uint32_t)input[71] << 1) |
			((uint32_t)(input[72] & 0x80) >> 7);
	output[17] = (double)value;
}

static void unpack_18_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;

	// read output[15]: from bit 482 to 513
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2) |
			((uint32_t)(input[64] & 0xc0) >> 6);
	output[15] = (double)value;

	// read output[16]: from bit 514 to 545
	value = ((uint32_t)(input[64] & 0x3f) << 26) |
			((uint32_t)input[65] << 18) |
			((uint32_t)input[66] << 10) |
			((uint32_t)input[67] << 2) |
			((uint32_t)(input[68] & 0xc0) >> 6);
	output[16] = (double)value;

	// read output[17]: from bit 546 to 577
	value = ((uint32_t)(input[68] & 0x3f) << 26) |
			((uint32_t)input[69] << 18) |
			((uint32_t)input[70] << 10) |
			((uint32_t)input[71] << 2) |
			((uint32_t)(input[72] & 0xc0) >> 6);
	output[17] = (double)value;
}

static void unpack_18_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;

	// read output[15]: from bit 482 to 513
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2) |
			((uint32_t)(input[64] & 0xc0) >> 6);
	output[15] = (double)value;

	// read output[16]: from bit 514 to 545
	value = ((uint32_t)(input[64] & 0x3f) << 26) |
			((uint32_t)input[65] << 18) |
			((uint32_t)input[66] << 10) |
			((uint32_t)input[67] << 2) |
			((uint32_t)(input[68] & 0xc0) >> 6);
	output[16] = (double)value;

	// read output[17]: from bit 546 to 577
	value = ((uint32_t)(input[68] & 0x3f) << 26) |
			((uint32_t)input[69] << 18) |
			((uint32_t)input[70] << 10) |
			((uint32_t)input[71] << 2) |
			((uint32_t)(input[72] & 0xc0) >> 6);
	output[17] = (double)value;
}

static void unpack_18_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;

	// read output[15]: from bit 483 to 514
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0xe0) >> 5);
	output[15] = (double)value;

	// read output[16]: from bit 515 to 546
	value = ((uint32_t)(input[64] & 0x1f) << 27) |
			((uint32_t)input[65] << 19) |
			((uint32_t)input[66] << 11) |
			((uint32_t)input[67] << 3) |
			((uint32_t)(input[68] & 0xe0) >> 5);
	output[16] = (double)value;

	// read output[17]: from bit 547 to 578
	value = ((uint32_t)(input[68] & 0x1f) << 27) |
			((uint32_t)input[69] << 19) |
			((uint32_t)input[70] << 11) |
			((uint32_t)input[71] << 3) |
			((uint32_t)(input[72] & 0xe0) >> 5);
	output[17] = (double)value;
}

static void unpack_18_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;

	// read output[15]: from bit 483 to 514
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0xe0) >> 5);
	output[15] = (double)value;

	// read output[16]: from bit 515 to 546
	value = ((uint32_t)(input[64] & 0x1f) << 27) |
			((uint32_t)input[65] << 19) |
			((uint32_t)input[66] << 11) |
			((uint32_t)input[67] << 3) |
			((uint32_t)(input[68] & 0xe0) >> 5);
	output[16] = (double)value;

	// read output[17]: from bit 547 to 578
	value = ((uint32_t)(input[68] & 0x1f) << 27) |
			((uint32_t)input[69] << 19) |
			((uint32_t)input[70] << 11) |
			((uint32_t)input[71] << 3) |
			((uint32_t)(input[72] & 0xe0) >> 5);
	output[17] = (double)value;
}

static void unpack_18_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;

	// read output[15]: from bit 484 to 515
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xf0) >> 4);
	output[15] = (double)value;

	// read output[16]: from bit 516 to 547
	value = ((uint32_t)(input[64] & 0x0f) << 28) |
			((uint32_t)input[65] << 20) |
			((uint32_t)input[66] << 12) |
			((uint32_t)input[67] << 4) |
			((uint32_t)(input[68] & 0xf0) >> 4);
	output[16] = (double)value;

	// read output[17]: from bit 548 to 579
	value = ((uint32_t)(input[68] & 0x0f) << 28) |
			((uint32_t)input[69] << 20) |
			((uint32_t)input[70] << 12) |
			((uint32_t)input[71] << 4) |
			((uint32_t)(input[72] & 0xf0) >> 4);
	output[17] = (double)value;
}

static void unpack_18_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;

	// read output[15]: from bit 484 to 515
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xf0) >> 4);
	output[15] = (double)value;

	// read output[16]: from bit 516 to 547
	value = ((uint32_t)(input[64] & 0x0f) << 28) |
			((uint32_t)input[65] << 20) |
			((uint32_t)input[66] << 12) |
			((uint32_t)input[67] << 4) |
			((uint32_t)(input[68] & 0xf0) >> 4);
	output[16] = (double)value;

	// read output[17]: from bit 548 to 579
	value = ((uint32_t)(input[68] & 0x0f) << 28) |
			((uint32_t)input[69] << 20) |
			((uint32_t)input[70] << 12) |
			((uint32_t)input[71] << 4) |
			((uint32_t)(input[72] & 0xf0) >> 4);
	output[17] = (double)value;
}

static void unpack_18_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;

	// read output[15]: from bit 485 to 516
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xf8) >> 3);
	output[15] = (double)value;

	// read output[16]: from bit 517 to 548
	value = ((uint32_t)(input[64] & 0x07) << 29) |
			((uint32_t)input[65] << 21) |
			((uint32_t)input[66] << 13) |
			((uint32_t)input[67] << 5) |
			((uint32_t)(input[68] & 0xf8) >> 3);
	output[16] = (double)value;

	// read output[17]: from bit 549 to 580
	value = ((uint32_t)(input[68] & 0x07) << 29) |
			((uint32_t)input[69] << 21) |
			((uint32_t)input[70] << 13) |
			((uint32_t)input[71] << 5) |
			((uint32_t)(input[72] & 0xf8) >> 3);
	output[17] = (double)value;
}

static void unpack_18_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;

	// read output[15]: from bit 485 to 516
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xf8) >> 3);
	output[15] = (double)value;

	// read output[16]: from bit 517 to 548
	value = ((uint32_t)(input[64] & 0x07) << 29) |
			((uint32_t)input[65] << 21) |
			((uint32_t)input[66] << 13) |
			((uint32_t)input[67] << 5) |
			((uint32_t)(input[68] & 0xf8) >> 3);
	output[16] = (double)value;

	// read output[17]: from bit 549 to 580
	value = ((uint32_t)(input[68] & 0x07) << 29) |
			((uint32_t)input[69] << 21) |
			((uint32_t)input[70] << 13) |
			((uint32_t)input[71] << 5) |
			((uint32_t)(input[72] & 0xf8) >> 3);
	output[17] = (double)value;
}

static void unpack_18_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;

	// read output[14]: from bit 454 to 485
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xfc) >> 2);
	output[14] = (double)value;

	// read output[15]: from bit 486 to 517
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)input[63] << 6) |
			((uint32_t)(input[64] & 0xfc) >> 2);
	output[15] = (double)value;

	// read output[16]: from bit 518 to 549
	value = ((uint32_t)(input[64] & 0x03) << 30) |
			((uint32_t)input[65] << 22) |
			((uint32_t)input[66] << 14) |
			((uint32_t)input[67] << 6) |
			((uint32_t)(input[68] & 0xfc) >> 2);
	output[16] = (double)value;

	// read output[17]: from bit 550 to 581
	value = ((uint32_t)(input[68] & 0x03) << 30) |
			((uint32_t)input[69] << 22) |
			((uint32_t)input[70] << 14) |
			((uint32_t)input[71] << 6) |
			((uint32_t)(input[72] & 0xfc) >> 2);
	output[17] = (double)value;
}

static void unpack_18_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;

	// read output[14]: from bit 454 to 485
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xfc) >> 2);
	output[14] = (double)value;

	// read output[15]: from bit 486 to 517
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)input[63] << 6) |
			((uint32_t)(input[64] & 0xfc) >> 2);
	output[15] = (double)value;

	// read output[16]: from bit 518 to 549
	value = ((uint32_t)(input[64] & 0x03) << 30) |
			((uint32_t)input[65] << 22) |
			((uint32_t)input[66] << 14) |
			((uint32_t)input[67] << 6) |
			((uint32_t)(input[68] & 0xfc) >> 2);
	output[16] = (double)value;

	// read output[17]: from bit 550 to 581
	value = ((uint32_t)(input[68] & 0x03) << 30) |
			((uint32_t)input[69] << 22) |
			((uint32_t)input[70] << 14) |
			((uint32_t)input[71] << 6) |
			((uint32_t)(input[72] & 0xfc) >> 2);
	output[17] = (double)value;
}

static void unpack_18_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;

	// read output[14]: from bit 455 to 486
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xfe) >> 1);
	output[14] = (double)value;

	// read output[15]: from bit 487 to 518
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)input[63] << 7) |
			((uint32_t)(input[64] & 0xfe) >> 1);
	output[15] = (double)value;

	// read output[16]: from bit 519 to 550
	value = ((uint32_t)(input[64] & 0x01) << 31) |
			((uint32_t)input[65] << 23) |
			((uint32_t)input[66] << 15) |
			((uint32_t)input[67] << 7) |
			((uint32_t)(input[68] & 0xfe) >> 1);
	output[16] = (double)value;

	// read output[17]: from bit 551 to 582
	value = ((uint32_t)(input[68] & 0x01) << 31) |
			((uint32_t)input[69] << 23) |
			((uint32_t)input[70] << 15) |
			((uint32_t)input[71] << 7) |
			((uint32_t)(input[72] & 0xfe) >> 1);
	output[17] = (double)value;
}

static void unpack_18_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 576 bits of data.
	// Input must be at least 73 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;

	// read output[14]: from bit 455 to 486
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xfe) >> 1);
	output[14] = (double)value;

	// read output[15]: from bit 487 to 518
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)input[63] << 7) |
			((uint32_t)(input[64] & 0xfe) >> 1);
	output[15] = (double)value;

	// read output[16]: from bit 519 to 550
	value = ((uint32_t)(input[64] & 0x01) << 31) |
			((uint32_t)input[65] << 23) |
			((uint32_t)input[66] << 15) |
			((uint32_t)input[67] << 7) |
			((uint32_t)(input[68] & 0xfe) >> 1);
	output[16] = (double)value;

	// read output[17]: from bit 551 to 582
	value = ((uint32_t)(input[68] & 0x01) << 31) |
			((uint32_t)input[69] << 23) |
			((uint32_t)input[70] << 15) |
			((uint32_t)input[71] << 7) |
			((uint32_t)(input[72] & 0xfe) >> 1);
	output[17] = (double)value;
}

static void unpack_19_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 608 bits of data.
	// Input must be at least 76 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;

	// read output[15]: from bit 480 to 511
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)input[63]);
	output[15] = (double)value;

	// read output[16]: from bit 512 to 543
	value = ((uint32_t)input[64] << 24) |
			((uint32_t)input[65] << 16) |
			((uint32_t)input[66] << 8) |
			((uint32_t)input[67]);
	output[16] = (double)value;

	// read output[17]: from bit 544 to 575
	value = ((uint32_t)input[68] << 24) |
			((uint32_t)input[69] << 16) |
			((uint32_t)input[70] << 8) |
			((uint32_t)input[71]);
	output[17] = (double)value;

	// read output[18]: from bit 576 to 607
	value = ((uint32_t)input[72] << 24) |
			((uint32_t)input[73] << 16) |
			((uint32_t)input[74] << 8) |
			((uint32_t)input[75]);
	output[18] = (double)value;
}

static void unpack_19_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 608 bits of data.
	// Input must be at least 76 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;

	// read output[15]: from bit 480 to 511
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)input[63]);
	output[15] = (double)value;

	// read output[16]: from bit 512 to 543
	value = ((uint32_t)input[64] << 24) |
			((uint32_t)input[65] << 16) |
			((uint32_t)input[66] << 8) |
			((uint32_t)input[67]);
	output[16] = (double)value;

	// read output[17]: from bit 544 to 575
	value = ((uint32_t)input[68] << 24) |
			((uint32_t)input[69] << 16) |
			((uint32_t)input[70] << 8) |
			((uint32_t)input[71]);
	output[17] = (double)value;

	// read output[18]: from bit 576 to 607
	value = ((uint32_t)input[72] << 24) |
			((uint32_t)input[73] << 16) |
			((uint32_t)input[74] << 8) |
			((uint32_t)input[75]);
	output[18] = (double)value;
}

static void unpack_19_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;

	// read output[15]: from bit 481 to 512
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)input[63] << 1) |
			((uint32_t)(input[64] & 0x80) >> 7);
	output[15] = (double)value;

	// read output[16]: from bit 513 to 544
	value = ((uint32_t)(input[64] & 0x7f) << 25) |
			((uint32_t)input[65] << 17) |
			((uint32_t)input[66] << 9) |
			((uint32_t)input[67] << 1) |
			((uint32_t)(input[68] & 0x80) >> 7);
	output[16] = (double)value;

	// read output[17]: from bit 545 to 576
	value = ((uint32_t)(input[68] & 0x7f) << 25) |
			((uint32_t)input[69] << 17) |
			((uint32_t)input[70] << 9) |
			((uint32_t)input[71] << 1) |
			((uint32_t)(input[72] & 0x80) >> 7);
	output[17] = (double)value;

	// read output[18]: from bit 577 to 608
	value = ((uint32_t)(input[72] & 0x7f) << 25) |
			((uint32_t)input[73] << 17) |
			((uint32_t)input[74] << 9) |
			((uint32_t)input[75] << 1) |
			((uint32_t)(input[76] & 0x80) >> 7);
	output[18] = (double)value;
}

static void unpack_19_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;

	// read output[15]: from bit 481 to 512
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)input[63] << 1) |
			((uint32_t)(input[64] & 0x80) >> 7);
	output[15] = (double)value;

	// read output[16]: from bit 513 to 544
	value = ((uint32_t)(input[64] & 0x7f) << 25) |
			((uint32_t)input[65] << 17) |
			((uint32_t)input[66] << 9) |
			((uint32_t)input[67] << 1) |
			((uint32_t)(input[68] & 0x80) >> 7);
	output[16] = (double)value;

	// read output[17]: from bit 545 to 576
	value = ((uint32_t)(input[68] & 0x7f) << 25) |
			((uint32_t)input[69] << 17) |
			((uint32_t)input[70] << 9) |
			((uint32_t)input[71] << 1) |
			((uint32_t)(input[72] & 0x80) >> 7);
	output[17] = (double)value;

	// read output[18]: from bit 577 to 608
	value = ((uint32_t)(input[72] & 0x7f) << 25) |
			((uint32_t)input[73] << 17) |
			((uint32_t)input[74] << 9) |
			((uint32_t)input[75] << 1) |
			((uint32_t)(input[76] & 0x80) >> 7);
	output[18] = (double)value;
}

static void unpack_19_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;

	// read output[15]: from bit 482 to 513
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2) |
			((uint32_t)(input[64] & 0xc0) >> 6);
	output[15] = (double)value;

	// read output[16]: from bit 514 to 545
	value = ((uint32_t)(input[64] & 0x3f) << 26) |
			((uint32_t)input[65] << 18) |
			((uint32_t)input[66] << 10) |
			((uint32_t)input[67] << 2) |
			((uint32_t)(input[68] & 0xc0) >> 6);
	output[16] = (double)value;

	// read output[17]: from bit 546 to 577
	value = ((uint32_t)(input[68] & 0x3f) << 26) |
			((uint32_t)input[69] << 18) |
			((uint32_t)input[70] << 10) |
			((uint32_t)input[71] << 2) |
			((uint32_t)(input[72] & 0xc0) >> 6);
	output[17] = (double)value;

	// read output[18]: from bit 578 to 609
	value = ((uint32_t)(input[72] & 0x3f) << 26) |
			((uint32_t)input[73] << 18) |
			((uint32_t)input[74] << 10) |
			((uint32_t)input[75] << 2) |
			((uint32_t)(input[76] & 0xc0) >> 6);
	output[18] = (double)value;
}

static void unpack_19_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;

	// read output[15]: from bit 482 to 513
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2) |
			((uint32_t)(input[64] & 0xc0) >> 6);
	output[15] = (double)value;

	// read output[16]: from bit 514 to 545
	value = ((uint32_t)(input[64] & 0x3f) << 26) |
			((uint32_t)input[65] << 18) |
			((uint32_t)input[66] << 10) |
			((uint32_t)input[67] << 2) |
			((uint32_t)(input[68] & 0xc0) >> 6);
	output[16] = (double)value;

	// read output[17]: from bit 546 to 577
	value = ((uint32_t)(input[68] & 0x3f) << 26) |
			((uint32_t)input[69] << 18) |
			((uint32_t)input[70] << 10) |
			((uint32_t)input[71] << 2) |
			((uint32_t)(input[72] & 0xc0) >> 6);
	output[17] = (double)value;

	// read output[18]: from bit 578 to 609
	value = ((uint32_t)(input[72] & 0x3f) << 26) |
			((uint32_t)input[73] << 18) |
			((uint32_t)input[74] << 10) |
			((uint32_t)input[75] << 2) |
			((uint32_t)(input[76] & 0xc0) >> 6);
	output[18] = (double)value;
}

static void unpack_19_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;

	// read output[15]: from bit 483 to 514
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0xe0) >> 5);
	output[15] = (double)value;

	// read output[16]: from bit 515 to 546
	value = ((uint32_t)(input[64] & 0x1f) << 27) |
			((uint32_t)input[65] << 19) |
			((uint32_t)input[66] << 11) |
			((uint32_t)input[67] << 3) |
			((uint32_t)(input[68] & 0xe0) >> 5);
	output[16] = (double)value;

	// read output[17]: from bit 547 to 578
	value = ((uint32_t)(input[68] & 0x1f) << 27) |
			((uint32_t)input[69] << 19) |
			((uint32_t)input[70] << 11) |
			((uint32_t)input[71] << 3) |
			((uint32_t)(input[72] & 0xe0) >> 5);
	output[17] = (double)value;

	// read output[18]: from bit 579 to 610
	value = ((uint32_t)(input[72] & 0x1f) << 27) |
			((uint32_t)input[73] << 19) |
			((uint32_t)input[74] << 11) |
			((uint32_t)input[75] << 3) |
			((uint32_t)(input[76] & 0xe0) >> 5);
	output[18] = (double)value;
}

static void unpack_19_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;

	// read output[15]: from bit 483 to 514
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0xe0) >> 5);
	output[15] = (double)value;

	// read output[16]: from bit 515 to 546
	value = ((uint32_t)(input[64] & 0x1f) << 27) |
			((uint32_t)input[65] << 19) |
			((uint32_t)input[66] << 11) |
			((uint32_t)input[67] << 3) |
			((uint32_t)(input[68] & 0xe0) >> 5);
	output[16] = (double)value;

	// read output[17]: from bit 547 to 578
	value = ((uint32_t)(input[68] & 0x1f) << 27) |
			((uint32_t)input[69] << 19) |
			((uint32_t)input[70] << 11) |
			((uint32_t)input[71] << 3) |
			((uint32_t)(input[72] & 0xe0) >> 5);
	output[17] = (double)value;

	// read output[18]: from bit 579 to 610
	value = ((uint32_t)(input[72] & 0x1f) << 27) |
			((uint32_t)input[73] << 19) |
			((uint32_t)input[74] << 11) |
			((uint32_t)input[75] << 3) |
			((uint32_t)(input[76] & 0xe0) >> 5);
	output[18] = (double)value;
}

static void unpack_19_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;

	// read output[15]: from bit 484 to 515
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xf0) >> 4);
	output[15] = (double)value;

	// read output[16]: from bit 516 to 547
	value = ((uint32_t)(input[64] & 0x0f) << 28) |
			((uint32_t)input[65] << 20) |
			((uint32_t)input[66] << 12) |
			((uint32_t)input[67] << 4) |
			((uint32_t)(input[68] & 0xf0) >> 4);
	output[16] = (double)value;

	// read output[17]: from bit 548 to 579
	value = ((uint32_t)(input[68] & 0x0f) << 28) |
			((uint32_t)input[69] << 20) |
			((uint32_t)input[70] << 12) |
			((uint32_t)input[71] << 4) |
			((uint32_t)(input[72] & 0xf0) >> 4);
	output[17] = (double)value;

	// read output[18]: from bit 580 to 611
	value = ((uint32_t)(input[72] & 0x0f) << 28) |
			((uint32_t)input[73] << 20) |
			((uint32_t)input[74] << 12) |
			((uint32_t)input[75] << 4) |
			((uint32_t)(input[76] & 0xf0) >> 4);
	output[18] = (double)value;
}

static void unpack_19_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;

	// read output[15]: from bit 484 to 515
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xf0) >> 4);
	output[15] = (double)value;

	// read output[16]: from bit 516 to 547
	value = ((uint32_t)(input[64] & 0x0f) << 28) |
			((uint32_t)input[65] << 20) |
			((uint32_t)input[66] << 12) |
			((uint32_t)input[67] << 4) |
			((uint32_t)(input[68] & 0xf0) >> 4);
	output[16] = (double)value;

	// read output[17]: from bit 548 to 579
	value = ((uint32_t)(input[68] & 0x0f) << 28) |
			((uint32_t)input[69] << 20) |
			((uint32_t)input[70] << 12) |
			((uint32_t)input[71] << 4) |
			((uint32_t)(input[72] & 0xf0) >> 4);
	output[17] = (double)value;

	// read output[18]: from bit 580 to 611
	value = ((uint32_t)(input[72] & 0x0f) << 28) |
			((uint32_t)input[73] << 20) |
			((uint32_t)input[74] << 12) |
			((uint32_t)input[75] << 4) |
			((uint32_t)(input[76] & 0xf0) >> 4);
	output[18] = (double)value;
}

static void unpack_19_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;

	// read output[15]: from bit 485 to 516
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xf8) >> 3);
	output[15] = (double)value;

	// read output[16]: from bit 517 to 548
	value = ((uint32_t)(input[64] & 0x07) << 29) |
			((uint32_t)input[65] << 21) |
			((uint32_t)input[66] << 13) |
			((uint32_t)input[67] << 5) |
			((uint32_t)(input[68] & 0xf8) >> 3);
	output[16] = (double)value;

	// read output[17]: from bit 549 to 580
	value = ((uint32_t)(input[68] & 0x07) << 29) |
			((uint32_t)input[69] << 21) |
			((uint32_t)input[70] << 13) |
			((uint32_t)input[71] << 5) |
			((uint32_t)(input[72] & 0xf8) >> 3);
	output[17] = (double)value;

	// read output[18]: from bit 581 to 612
	value = ((uint32_t)(input[72] & 0x07) << 29) |
			((uint32_t)input[73] << 21) |
			((uint32_t)input[74] << 13) |
			((uint32_t)input[75] << 5) |
			((uint32_t)(input[76] & 0xf8) >> 3);
	output[18] = (double)value;
}

static void unpack_19_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;

	// read output[15]: from bit 485 to 516
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xf8) >> 3);
	output[15] = (double)value;

	// read output[16]: from bit 517 to 548
	value = ((uint32_t)(input[64] & 0x07) << 29) |
			((uint32_t)input[65] << 21) |
			((uint32_t)input[66] << 13) |
			((uint32_t)input[67] << 5) |
			((uint32_t)(input[68] & 0xf8) >> 3);
	output[16] = (double)value;

	// read output[17]: from bit 549 to 580
	value = ((uint32_t)(input[68] & 0x07) << 29) |
			((uint32_t)input[69] << 21) |
			((uint32_t)input[70] << 13) |
			((uint32_t)input[71] << 5) |
			((uint32_t)(input[72] & 0xf8) >> 3);
	output[17] = (double)value;

	// read output[18]: from bit 581 to 612
	value = ((uint32_t)(input[72] & 0x07) << 29) |
			((uint32_t)input[73] << 21) |
			((uint32_t)input[74] << 13) |
			((uint32_t)input[75] << 5) |
			((uint32_t)(input[76] & 0xf8) >> 3);
	output[18] = (double)value;
}

static void unpack_19_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;

	// read output[14]: from bit 454 to 485
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xfc) >> 2);
	output[14] = (double)value;

	// read output[15]: from bit 486 to 517
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)input[63] << 6) |
			((uint32_t)(input[64] & 0xfc) >> 2);
	output[15] = (double)value;

	// read output[16]: from bit 518 to 549
	value = ((uint32_t)(input[64] & 0x03) << 30) |
			((uint32_t)input[65] << 22) |
			((uint32_t)input[66] << 14) |
			((uint32_t)input[67] << 6) |
			((uint32_t)(input[68] & 0xfc) >> 2);
	output[16] = (double)value;

	// read output[17]: from bit 550 to 581
	value = ((uint32_t)(input[68] & 0x03) << 30) |
			((uint32_t)input[69] << 22) |
			((uint32_t)input[70] << 14) |
			((uint32_t)input[71] << 6) |
			((uint32_t)(input[72] & 0xfc) >> 2);
	output[17] = (double)value;

	// read output[18]: from bit 582 to 613
	value = ((uint32_t)(input[72] & 0x03) << 30) |
			((uint32_t)input[73] << 22) |
			((uint32_t)input[74] << 14) |
			((uint32_t)input[75] << 6) |
			((uint32_t)(input[76] & 0xfc) >> 2);
	output[18] = (double)value;
}

static void unpack_19_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;

	// read output[14]: from bit 454 to 485
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xfc) >> 2);
	output[14] = (double)value;

	// read output[15]: from bit 486 to 517
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)input[63] << 6) |
			((uint32_t)(input[64] & 0xfc) >> 2);
	output[15] = (double)value;

	// read output[16]: from bit 518 to 549
	value = ((uint32_t)(input[64] & 0x03) << 30) |
			((uint32_t)input[65] << 22) |
			((uint32_t)input[66] << 14) |
			((uint32_t)input[67] << 6) |
			((uint32_t)(input[68] & 0xfc) >> 2);
	output[16] = (double)value;

	// read output[17]: from bit 550 to 581
	value = ((uint32_t)(input[68] & 0x03) << 30) |
			((uint32_t)input[69] << 22) |
			((uint32_t)input[70] << 14) |
			((uint32_t)input[71] << 6) |
			((uint32_t)(input[72] & 0xfc) >> 2);
	output[17] = (double)value;

	// read output[18]: from bit 582 to 613
	value = ((uint32_t)(input[72] & 0x03) << 30) |
			((uint32_t)input[73] << 22) |
			((uint32_t)input[74] << 14) |
			((uint32_t)input[75] << 6) |
			((uint32_t)(input[76] & 0xfc) >> 2);
	output[18] = (double)value;
}

static void unpack_19_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;

	// read output[14]: from bit 455 to 486
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xfe) >> 1);
	output[14] = (double)value;

	// read output[15]: from bit 487 to 518
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)input[63] << 7) |
			((uint32_t)(input[64] & 0xfe) >> 1);
	output[15] = (double)value;

	// read output[16]: from bit 519 to 550
	value = ((uint32_t)(input[64] & 0x01) << 31) |
			((uint32_t)input[65] << 23) |
			((uint32_t)input[66] << 15) |
			((uint32_t)input[67] << 7) |
			((uint32_t)(input[68] & 0xfe) >> 1);
	output[16] = (double)value;

	// read output[17]: from bit 551 to 582
	value = ((uint32_t)(input[68] & 0x01) << 31) |
			((uint32_t)input[69] << 23) |
			((uint32_t)input[70] << 15) |
			((uint32_t)input[71] << 7) |
			((uint32_t)(input[72] & 0xfe) >> 1);
	output[17] = (double)value;

	// read output[18]: from bit 583 to 614
	value = ((uint32_t)(input[72] & 0x01) << 31) |
			((uint32_t)input[73] << 23) |
			((uint32_t)input[74] << 15) |
			((uint32_t)input[75] << 7) |
			((uint32_t)(input[76] & 0xfe) >> 1);
	output[18] = (double)value;
}

static void unpack_19_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 608 bits of data.
	// Input must be at least 77 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;

	// read output[14]: from bit 455 to 486
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xfe) >> 1);
	output[14] = (double)value;

	// read output[15]: from bit 487 to 518
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)input[63] << 7) |
			((uint32_t)(input[64] & 0xfe) >> 1);
	output[15] = (double)value;

	// read output[16]: from bit 519 to 550
	value = ((uint32_t)(input[64] & 0x01) << 31) |
			((uint32_t)input[65] << 23) |
			((uint32_t)input[66] << 15) |
			((uint32_t)input[67] << 7) |
			((uint32_t)(input[68] & 0xfe) >> 1);
	output[16] = (double)value;

	// read output[17]: from bit 551 to 582
	value = ((uint32_t)(input[68] & 0x01) << 31) |
			((uint32_t)input[69] << 23) |
			((uint32_t)input[70] << 15) |
			((uint32_t)input[71] << 7) |
			((uint32_t)(input[72] & 0xfe) >> 1);
	output[17] = (double)value;

	// read output[18]: from bit 583 to 614
	value = ((uint32_t)(input[72] & 0x01) << 31) |
			((uint32_t)input[73] << 23) |
			((uint32_t)input[74] << 15) |
			((uint32_t)input[75] << 7) |
			((uint32_t)(input[76] & 0xfe) >> 1);
	output[18] = (double)value;
}

static void unpack_20_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 640 bits of data.
	// Input must be at least 80 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;

	// read output[15]: from bit 480 to 511
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)input[63]);
	output[15] = (double)value;

	// read output[16]: from bit 512 to 543
	value = ((uint32_t)input[64] << 24) |
			((uint32_t)input[65] << 16) |
			((uint32_t)input[66] << 8) |
			((uint32_t)input[67]);
	output[16] = (double)value;

	// read output[17]: from bit 544 to 575
	value = ((uint32_t)input[68] << 24) |
			((uint32_t)input[69] << 16) |
			((uint32_t)input[70] << 8) |
			((uint32_t)input[71]);
	output[17] = (double)value;

	// read output[18]: from bit 576 to 607
	value = ((uint32_t)input[72] << 24) |
			((uint32_t)input[73] << 16) |
			((uint32_t)input[74] << 8) |
			((uint32_t)input[75]);
	output[18] = (double)value;

	// read output[19]: from bit 608 to 639
	value = ((uint32_t)input[76] << 24) |
			((uint32_t)input[77] << 16) |
			((uint32_t)input[78] << 8) |
			((uint32_t)input[79]);
	output[19] = (double)value;
}

static void unpack_20_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 640 bits of data.
	// Input must be at least 80 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;

	// read output[15]: from bit 480 to 511
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)input[63]);
	output[15] = (double)value;

	// read output[16]: from bit 512 to 543
	value = ((uint32_t)input[64] << 24) |
			((uint32_t)input[65] << 16) |
			((uint32_t)input[66] << 8) |
			((uint32_t)input[67]);
	output[16] = (double)value;

	// read output[17]: from bit 544 to 575
	value = ((uint32_t)input[68] << 24) |
			((uint32_t)input[69] << 16) |
			((uint32_t)input[70] << 8) |
			((uint32_t)input[71]);
	output[17] = (double)value;

	// read output[18]: from bit 576 to 607
	value = ((uint32_t)input[72] << 24) |
			((uint32_t)input[73] << 16) |
			((uint32_t)input[74] << 8) |
			((uint32_t)input[75]);
	output[18] = (double)value;

	// read output[19]: from bit 608 to 639
	value = ((uint32_t)input[76] << 24) |
			((uint32_t)input[77] << 16) |
			((uint32_t)input[78] << 8) |
			((uint32_t)input[79]);
	output[19] = (double)value;
}

static void unpack_20_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;

	// read output[15]: from bit 481 to 512
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)input[63] << 1) |
			((uint32_t)(input[64] & 0x80) >> 7);
	output[15] = (double)value;

	// read output[16]: from bit 513 to 544
	value = ((uint32_t)(input[64] & 0x7f) << 25) |
			((uint32_t)input[65] << 17) |
			((uint32_t)input[66] << 9) |
			((uint32_t)input[67] << 1) |
			((uint32_t)(input[68] & 0x80) >> 7);
	output[16] = (double)value;

	// read output[17]: from bit 545 to 576
	value = ((uint32_t)(input[68] & 0x7f) << 25) |
			((uint32_t)input[69] << 17) |
			((uint32_t)input[70] << 9) |
			((uint32_t)input[71] << 1) |
			((uint32_t)(input[72] & 0x80) >> 7);
	output[17] = (double)value;

	// read output[18]: from bit 577 to 608
	value = ((uint32_t)(input[72] & 0x7f) << 25) |
			((uint32_t)input[73] << 17) |
			((uint32_t)input[74] << 9) |
			((uint32_t)input[75] << 1) |
			((uint32_t)(input[76] & 0x80) >> 7);
	output[18] = (double)value;

	// read output[19]: from bit 609 to 640
	value = ((uint32_t)(input[76] & 0x7f) << 25) |
			((uint32_t)input[77] << 17) |
			((uint32_t)input[78] << 9) |
			((uint32_t)input[79] << 1) |
			((uint32_t)(input[80] & 0x80) >> 7);
	output[19] = (double)value;
}

static void unpack_20_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;

	// read output[15]: from bit 481 to 512
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)input[63] << 1) |
			((uint32_t)(input[64] & 0x80) >> 7);
	output[15] = (double)value;

	// read output[16]: from bit 513 to 544
	value = ((uint32_t)(input[64] & 0x7f) << 25) |
			((uint32_t)input[65] << 17) |
			((uint32_t)input[66] << 9) |
			((uint32_t)input[67] << 1) |
			((uint32_t)(input[68] & 0x80) >> 7);
	output[16] = (double)value;

	// read output[17]: from bit 545 to 576
	value = ((uint32_t)(input[68] & 0x7f) << 25) |
			((uint32_t)input[69] << 17) |
			((uint32_t)input[70] << 9) |
			((uint32_t)input[71] << 1) |
			((uint32_t)(input[72] & 0x80) >> 7);
	output[17] = (double)value;

	// read output[18]: from bit 577 to 608
	value = ((uint32_t)(input[72] & 0x7f) << 25) |
			((uint32_t)input[73] << 17) |
			((uint32_t)input[74] << 9) |
			((uint32_t)input[75] << 1) |
			((uint32_t)(input[76] & 0x80) >> 7);
	output[18] = (double)value;

	// read output[19]: from bit 609 to 640
	value = ((uint32_t)(input[76] & 0x7f) << 25) |
			((uint32_t)input[77] << 17) |
			((uint32_t)input[78] << 9) |
			((uint32_t)input[79] << 1) |
			((uint32_t)(input[80] & 0x80) >> 7);
	output[19] = (double)value;
}

static void unpack_20_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;

	// read output[15]: from bit 482 to 513
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2) |
			((uint32_t)(input[64] & 0xc0) >> 6);
	output[15] = (double)value;

	// read output[16]: from bit 514 to 545
	value = ((uint32_t)(input[64] & 0x3f) << 26) |
			((uint32_t)input[65] << 18) |
			((uint32_t)input[66] << 10) |
			((uint32_t)input[67] << 2) |
			((uint32_t)(input[68] & 0xc0) >> 6);
	output[16] = (double)value;

	// read output[17]: from bit 546 to 577
	value = ((uint32_t)(input[68] & 0x3f) << 26) |
			((uint32_t)input[69] << 18) |
			((uint32_t)input[70] << 10) |
			((uint32_t)input[71] << 2) |
			((uint32_t)(input[72] & 0xc0) >> 6);
	output[17] = (double)value;

	// read output[18]: from bit 578 to 609
	value = ((uint32_t)(input[72] & 0x3f) << 26) |
			((uint32_t)input[73] << 18) |
			((uint32_t)input[74] << 10) |
			((uint32_t)input[75] << 2) |
			((uint32_t)(input[76] & 0xc0) >> 6);
	output[18] = (double)value;

	// read output[19]: from bit 610 to 641
	value = ((uint32_t)(input[76] & 0x3f) << 26) |
			((uint32_t)input[77] << 18) |
			((uint32_t)input[78] << 10) |
			((uint32_t)input[79] << 2) |
			((uint32_t)(input[80] & 0xc0) >> 6);
	output[19] = (double)value;
}

static void unpack_20_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;

	// read output[15]: from bit 482 to 513
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2) |
			((uint32_t)(input[64] & 0xc0) >> 6);
	output[15] = (double)value;

	// read output[16]: from bit 514 to 545
	value = ((uint32_t)(input[64] & 0x3f) << 26) |
			((uint32_t)input[65] << 18) |
			((uint32_t)input[66] << 10) |
			((uint32_t)input[67] << 2) |
			((uint32_t)(input[68] & 0xc0) >> 6);
	output[16] = (double)value;

	// read output[17]: from bit 546 to 577
	value = ((uint32_t)(input[68] & 0x3f) << 26) |
			((uint32_t)input[69] << 18) |
			((uint32_t)input[70] << 10) |
			((uint32_t)input[71] << 2) |
			((uint32_t)(input[72] & 0xc0) >> 6);
	output[17] = (double)value;

	// read output[18]: from bit 578 to 609
	value = ((uint32_t)(input[72] & 0x3f) << 26) |
			((uint32_t)input[73] << 18) |
			((uint32_t)input[74] << 10) |
			((uint32_t)input[75] << 2) |
			((uint32_t)(input[76] & 0xc0) >> 6);
	output[18] = (double)value;

	// read output[19]: from bit 610 to 641
	value = ((uint32_t)(input[76] & 0x3f) << 26) |
			((uint32_t)input[77] << 18) |
			((uint32_t)input[78] << 10) |
			((uint32_t)input[79] << 2) |
			((uint32_t)(input[80] & 0xc0) >> 6);
	output[19] = (double)value;
}

static void unpack_20_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;

	// read output[15]: from bit 483 to 514
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0xe0) >> 5);
	output[15] = (double)value;

	// read output[16]: from bit 515 to 546
	value = ((uint32_t)(input[64] & 0x1f) << 27) |
			((uint32_t)input[65] << 19) |
			((uint32_t)input[66] << 11) |
			((uint32_t)input[67] << 3) |
			((uint32_t)(input[68] & 0xe0) >> 5);
	output[16] = (double)value;

	// read output[17]: from bit 547 to 578
	value = ((uint32_t)(input[68] & 0x1f) << 27) |
			((uint32_t)input[69] << 19) |
			((uint32_t)input[70] << 11) |
			((uint32_t)input[71] << 3) |
			((uint32_t)(input[72] & 0xe0) >> 5);
	output[17] = (double)value;

	// read output[18]: from bit 579 to 610
	value = ((uint32_t)(input[72] & 0x1f) << 27) |
			((uint32_t)input[73] << 19) |
			((uint32_t)input[74] << 11) |
			((uint32_t)input[75] << 3) |
			((uint32_t)(input[76] & 0xe0) >> 5);
	output[18] = (double)value;

	// read output[19]: from bit 611 to 642
	value = ((uint32_t)(input[76] & 0x1f) << 27) |
			((uint32_t)input[77] << 19) |
			((uint32_t)input[78] << 11) |
			((uint32_t)input[79] << 3) |
			((uint32_t)(input[80] & 0xe0) >> 5);
	output[19] = (double)value;
}

static void unpack_20_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;

	// read output[15]: from bit 483 to 514
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0xe0) >> 5);
	output[15] = (double)value;

	// read output[16]: from bit 515 to 546
	value = ((uint32_t)(input[64] & 0x1f) << 27) |
			((uint32_t)input[65] << 19) |
			((uint32_t)input[66] << 11) |
			((uint32_t)input[67] << 3) |
			((uint32_t)(input[68] & 0xe0) >> 5);
	output[16] = (double)value;

	// read output[17]: from bit 547 to 578
	value = ((uint32_t)(input[68] & 0x1f) << 27) |
			((uint32_t)input[69] << 19) |
			((uint32_t)input[70] << 11) |
			((uint32_t)input[71] << 3) |
			((uint32_t)(input[72] & 0xe0) >> 5);
	output[17] = (double)value;

	// read output[18]: from bit 579 to 610
	value = ((uint32_t)(input[72] & 0x1f) << 27) |
			((uint32_t)input[73] << 19) |
			((uint32_t)input[74] << 11) |
			((uint32_t)input[75] << 3) |
			((uint32_t)(input[76] & 0xe0) >> 5);
	output[18] = (double)value;

	// read output[19]: from bit 611 to 642
	value = ((uint32_t)(input[76] & 0x1f) << 27) |
			((uint32_t)input[77] << 19) |
			((uint32_t)input[78] << 11) |
			((uint32_t)input[79] << 3) |
			((uint32_t)(input[80] & 0xe0) >> 5);
	output[19] = (double)value;
}

static void unpack_20_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;

	// read output[15]: from bit 484 to 515
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xf0) >> 4);
	output[15] = (double)value;

	// read output[16]: from bit 516 to 547
	value = ((uint32_t)(input[64] & 0x0f) << 28) |
			((uint32_t)input[65] << 20) |
			((uint32_t)input[66] << 12) |
			((uint32_t)input[67] << 4) |
			((uint32_t)(input[68] & 0xf0) >> 4);
	output[16] = (double)value;

	// read output[17]: from bit 548 to 579
	value = ((uint32_t)(input[68] & 0x0f) << 28) |
			((uint32_t)input[69] << 20) |
			((uint32_t)input[70] << 12) |
			((uint32_t)input[71] << 4) |
			((uint32_t)(input[72] & 0xf0) >> 4);
	output[17] = (double)value;

	// read output[18]: from bit 580 to 611
	value = ((uint32_t)(input[72] & 0x0f) << 28) |
			((uint32_t)input[73] << 20) |
			((uint32_t)input[74] << 12) |
			((uint32_t)input[75] << 4) |
			((uint32_t)(input[76] & 0xf0) >> 4);
	output[18] = (double)value;

	// read output[19]: from bit 612 to 643
	value = ((uint32_t)(input[76] & 0x0f) << 28) |
			((uint32_t)input[77] << 20) |
			((uint32_t)input[78] << 12) |
			((uint32_t)input[79] << 4) |
			((uint32_t)(input[80] & 0xf0) >> 4);
	output[19] = (double)value;
}

static void unpack_20_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;

	// read output[15]: from bit 484 to 515
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xf0) >> 4);
	output[15] = (double)value;

	// read output[16]: from bit 516 to 547
	value = ((uint32_t)(input[64] & 0x0f) << 28) |
			((uint32_t)input[65] << 20) |
			((uint32_t)input[66] << 12) |
			((uint32_t)input[67] << 4) |
			((uint32_t)(input[68] & 0xf0) >> 4);
	output[16] = (double)value;

	// read output[17]: from bit 548 to 579
	value = ((uint32_t)(input[68] & 0x0f) << 28) |
			((uint32_t)input[69] << 20) |
			((uint32_t)input[70] << 12) |
			((uint32_t)input[71] << 4) |
			((uint32_t)(input[72] & 0xf0) >> 4);
	output[17] = (double)value;

	// read output[18]: from bit 580 to 611
	value = ((uint32_t)(input[72] & 0x0f) << 28) |
			((uint32_t)input[73] << 20) |
			((uint32_t)input[74] << 12) |
			((uint32_t)input[75] << 4) |
			((uint32_t)(input[76] & 0xf0) >> 4);
	output[18] = (double)value;

	// read output[19]: from bit 612 to 643
	value = ((uint32_t)(input[76] & 0x0f) << 28) |
			((uint32_t)input[77] << 20) |
			((uint32_t)input[78] << 12) |
			((uint32_t)input[79] << 4) |
			((uint32_t)(input[80] & 0xf0) >> 4);
	output[19] = (double)value;
}

static void unpack_20_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;

	// read output[15]: from bit 485 to 516
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xf8) >> 3);
	output[15] = (double)value;

	// read output[16]: from bit 517 to 548
	value = ((uint32_t)(input[64] & 0x07) << 29) |
			((uint32_t)input[65] << 21) |
			((uint32_t)input[66] << 13) |
			((uint32_t)input[67] << 5) |
			((uint32_t)(input[68] & 0xf8) >> 3);
	output[16] = (double)value;

	// read output[17]: from bit 549 to 580
	value = ((uint32_t)(input[68] & 0x07) << 29) |
			((uint32_t)input[69] << 21) |
			((uint32_t)input[70] << 13) |
			((uint32_t)input[71] << 5) |
			((uint32_t)(input[72] & 0xf8) >> 3);
	output[17] = (double)value;

	// read output[18]: from bit 581 to 612
	value = ((uint32_t)(input[72] & 0x07) << 29) |
			((uint32_t)input[73] << 21) |
			((uint32_t)input[74] << 13) |
			((uint32_t)input[75] << 5) |
			((uint32_t)(input[76] & 0xf8) >> 3);
	output[18] = (double)value;

	// read output[19]: from bit 613 to 644
	value = ((uint32_t)(input[76] & 0x07) << 29) |
			((uint32_t)input[77] << 21) |
			((uint32_t)input[78] << 13) |
			((uint32_t)input[79] << 5) |
			((uint32_t)(input[80] & 0xf8) >> 3);
	output[19] = (double)value;
}

static void unpack_20_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;

	// read output[15]: from bit 485 to 516
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xf8) >> 3);
	output[15] = (double)value;

	// read output[16]: from bit 517 to 548
	value = ((uint32_t)(input[64] & 0x07) << 29) |
			((uint32_t)input[65] << 21) |
			((uint32_t)input[66] << 13) |
			((uint32_t)input[67] << 5) |
			((uint32_t)(input[68] & 0xf8) >> 3);
	output[16] = (double)value;

	// read output[17]: from bit 549 to 580
	value = ((uint32_t)(input[68] & 0x07) << 29) |
			((uint32_t)input[69] << 21) |
			((uint32_t)input[70] << 13) |
			((uint32_t)input[71] << 5) |
			((uint32_t)(input[72] & 0xf8) >> 3);
	output[17] = (double)value;

	// read output[18]: from bit 581 to 612
	value = ((uint32_t)(input[72] & 0x07) << 29) |
			((uint32_t)input[73] << 21) |
			((uint32_t)input[74] << 13) |
			((uint32_t)input[75] << 5) |
			((uint32_t)(input[76] & 0xf8) >> 3);
	output[18] = (double)value;

	// read output[19]: from bit 613 to 644
	value = ((uint32_t)(input[76] & 0x07) << 29) |
			((uint32_t)input[77] << 21) |
			((uint32_t)input[78] << 13) |
			((uint32_t)input[79] << 5) |
			((uint32_t)(input[80] & 0xf8) >> 3);
	output[19] = (double)value;
}

static void unpack_20_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;

	// read output[14]: from bit 454 to 485
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xfc) >> 2);
	output[14] = (double)value;

	// read output[15]: from bit 486 to 517
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)input[63] << 6) |
			((uint32_t)(input[64] & 0xfc) >> 2);
	output[15] = (double)value;

	// read output[16]: from bit 518 to 549
	value = ((uint32_t)(input[64] & 0x03) << 30) |
			((uint32_t)input[65] << 22) |
			((uint32_t)input[66] << 14) |
			((uint32_t)input[67] << 6) |
			((uint32_t)(input[68] & 0xfc) >> 2);
	output[16] = (double)value;

	// read output[17]: from bit 550 to 581
	value = ((uint32_t)(input[68] & 0x03) << 30) |
			((uint32_t)input[69] << 22) |
			((uint32_t)input[70] << 14) |
			((uint32_t)input[71] << 6) |
			((uint32_t)(input[72] & 0xfc) >> 2);
	output[17] = (double)value;

	// read output[18]: from bit 582 to 613
	value = ((uint32_t)(input[72] & 0x03) << 30) |
			((uint32_t)input[73] << 22) |
			((uint32_t)input[74] << 14) |
			((uint32_t)input[75] << 6) |
			((uint32_t)(input[76] & 0xfc) >> 2);
	output[18] = (double)value;

	// read output[19]: from bit 614 to 645
	value = ((uint32_t)(input[76] & 0x03) << 30) |
			((uint32_t)input[77] << 22) |
			((uint32_t)input[78] << 14) |
			((uint32_t)input[79] << 6) |
			((uint32_t)(input[80] & 0xfc) >> 2);
	output[19] = (double)value;
}

static void unpack_20_32bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit unsigned
	// Skip 6 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;

	// read output[14]: from bit 454 to 485
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xfc) >> 2);
	output[14] = (double)value;

	// read output[15]: from bit 486 to 517
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)input[63] << 6) |
			((uint32_t)(input[64] & 0xfc) >> 2);
	output[15] = (double)value;

	// read output[16]: from bit 518 to 549
	value = ((uint32_t)(input[64] & 0x03) << 30) |
			((uint32_t)input[65] << 22) |
			((uint32_t)input[66] << 14) |
			((uint32_t)input[67] << 6) |
			((uint32_t)(input[68] & 0xfc) >> 2);
	output[16] = (double)value;

	// read output[17]: from bit 550 to 581
	value = ((uint32_t)(input[68] & 0x03) << 30) |
			((uint32_t)input[69] << 22) |
			((uint32_t)input[70] << 14) |
			((uint32_t)input[71] << 6) |
			((uint32_t)(input[72] & 0xfc) >> 2);
	output[17] = (double)value;

	// read output[18]: from bit 582 to 613
	value = ((uint32_t)(input[72] & 0x03) << 30) |
			((uint32_t)input[73] << 22) |
			((uint32_t)input[74] << 14) |
			((uint32_t)input[75] << 6) |
			((uint32_t)(input[76] & 0xfc) >> 2);
	output[18] = (double)value;

	// read output[19]: from bit 614 to 645
	value = ((uint32_t)(input[76] & 0x03) << 30) |
			((uint32_t)input[77] << 22) |
			((uint32_t)input[78] << 14) |
			((uint32_t)input[79] << 6) |
			((uint32_t)(input[80] & 0xfc) >> 2);
	output[19] = (double)value;
}

static void unpack_20_32bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit signed
	// Skip 7 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;

	// read output[14]: from bit 455 to 486
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xfe) >> 1);
	output[14] = (double)value;

	// read output[15]: from bit 487 to 518
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)input[63] << 7) |
			((uint32_t)(input[64] & 0xfe) >> 1);
	output[15] = (double)value;

	// read output[16]: from bit 519 to 550
	value = ((uint32_t)(input[64] & 0x01) << 31) |
			((uint32_t)input[65] << 23) |
			((uint32_t)input[66] << 15) |
			((uint32_t)input[67] << 7) |
			((uint32_t)(input[68] & 0xfe) >> 1);
	output[16] = (double)value;

	// read output[17]: from bit 551 to 582
	value = ((uint32_t)(input[68] & 0x01) << 31) |
			((uint32_t)input[69] << 23) |
			((uint32_t)input[70] << 15) |
			((uint32_t)input[71] << 7) |
			((uint32_t)(input[72] & 0xfe) >> 1);
	output[17] = (double)value;

	// read output[18]: from bit 583 to 614
	value = ((uint32_t)(input[72] & 0x01) << 31) |
			((uint32_t)input[73] << 23) |
			((uint32_t)input[74] << 15) |
			((uint32_t)input[75] << 7) |
			((uint32_t)(input[76] & 0xfe) >> 1);
	output[18] = (double)value;

	// read output[19]: from bit 615 to 646
	value = ((uint32_t)(input[76] & 0x01) << 31) |
			((uint32_t)input[77] << 23) |
			((uint32_t)input[78] << 15) |
			((uint32_t)input[79] << 7) |
			((uint32_t)(input[80] & 0xfe) >> 1);
	output[19] = (double)value;
}

static void unpack_20_32bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 32-bit unsigned
	// Skip 7 bits, read 640 bits of data.
	// Input must be at least 81 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 38
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)(input[4] & 0xfe) >> 1);
	output[0] = (double)value;

	// read output[1]: from bit 39 to 70
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)input[7] << 7) |
			((uint32_t)(input[8] & 0xfe) >> 1);
	output[1] = (double)value;

	// read output[2]: from bit 71 to 102
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)input[11] << 7) |
			((uint32_t)(input[12] & 0xfe) >> 1);
	output[2] = (double)value;

	// read output[3]: from bit 103 to 134
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)input[15] << 7) |
			((uint32_t)(input[16] & 0xfe) >> 1);
	output[3] = (double)value;

	// read output[4]: from bit 135 to 166
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)input[19] << 7) |
			((uint32_t)(input[20] & 0xfe) >> 1);
	output[4] = (double)value;

	// read output[5]: from bit 167 to 198
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)input[23] << 7) |
			((uint32_t)(input[24] & 0xfe) >> 1);
	output[5] = (double)value;

	// read output[6]: from bit 199 to 230
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)input[27] << 7) |
			((uint32_t)(input[28] & 0xfe) >> 1);
	output[6] = (double)value;

	// read output[7]: from bit 231 to 262
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)input[30] << 15) |
			((uint32_t)input[31] << 7) |
			((uint32_t)(input[32] & 0xfe) >> 1);
	output[7] = (double)value;

	// read output[8]: from bit 263 to 294
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)input[35] << 7) |
			((uint32_t)(input[36] & 0xfe) >> 1);
	output[8] = (double)value;

	// read output[9]: from bit 295 to 326
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)input[39] << 7) |
			((uint32_t)(input[40] & 0xfe) >> 1);
	output[9] = (double)value;

	// read output[10]: from bit 327 to 358
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)input[43] << 7) |
			((uint32_t)(input[44] & 0xfe) >> 1);
	output[10] = (double)value;

	// read output[11]: from bit 359 to 390
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)input[47] << 7) |
			((uint32_t)(input[48] & 0xfe) >> 1);
	output[11] = (double)value;

	// read output[12]: from bit 391 to 422
	value = ((uint32_t)(input[48] & 0x01) << 31) |
			((uint32_t)input[49] << 23) |
			((uint32_t)input[50] << 15) |
			((uint32_t)input[51] << 7) |
			((uint32_t)(input[52] & 0xfe) >> 1);
	output[12] = (double)value;

	// read output[13]: from bit 423 to 454
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)input[55] << 7) |
			((uint32_t)(input[56] & 0xfe) >> 1);
	output[13] = (double)value;

	// read output[14]: from bit 455 to 486
	value = ((uint32_t)(input[56] & 0x01) << 31) |
			((uint32_t)input[57] << 23) |
			((uint32_t)input[58] << 15) |
			((uint32_t)input[59] << 7) |
			((uint32_t)(input[60] & 0xfe) >> 1);
	output[14] = (double)value;

	// read output[15]: from bit 487 to 518
	value = ((uint32_t)(input[60] & 0x01) << 31) |
			((uint32_t)input[61] << 23) |
			((uint32_t)input[62] << 15) |
			((uint32_t)input[63] << 7) |
			((uint32_t)(input[64] & 0xfe) >> 1);
	output[15] = (double)value;

	// read output[16]: from bit 519 to 550
	value = ((uint32_t)(input[64] & 0x01) << 31) |
			((uint32_t)input[65] << 23) |
			((uint32_t)input[66] << 15) |
			((uint32_t)input[67] << 7) |
			((uint32_t)(input[68] & 0xfe) >> 1);
	output[16] = (double)value;

	// read output[17]: from bit 551 to 582
	value = ((uint32_t)(input[68] & 0x01) << 31) |
			((uint32_t)input[69] << 23) |
			((uint32_t)input[70] << 15) |
			((uint32_t)input[71] << 7) |
			((uint32_t)(input[72] & 0xfe) >> 1);
	output[17] = (double)value;

	// read output[18]: from bit 583 to 614
	value = ((uint32_t)(input[72] & 0x01) << 31) |
			((uint32_t)input[73] << 23) |
			((uint32_t)input[74] << 15) |
			((uint32_t)input[75] << 7) |
			((uint32_t)(input[76] & 0xfe) >> 1);
	output[18] = (double)value;

	// read output[19]: from bit 615 to 646
	value = ((uint32_t)(input[76] & 0x01) << 31) |
			((uint32_t)input[77] << 23) |
			((uint32_t)input[78] << 15) |
			((uint32_t)input[79] << 7) |
			((uint32_t)(input[80] & 0xfe) >> 1);
	output[19] = (double)value;
}

static void unpack_21_32bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 32-bit signed
	// Skip 0 bits, read 672 bits of data.
	// Input must be at least 84 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;

	// read output[15]: from bit 480 to 511
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)input[63]);
	output[15] = (double)value;

	// read output[16]: from bit 512 to 543
	value = ((uint32_t)input[64] << 24) |
			((uint32_t)input[65] << 16) |
			((uint32_t)input[66] << 8) |
			((uint32_t)input[67]);
	output[16] = (double)value;

	// read output[17]: from bit 544 to 575
	value = ((uint32_t)input[68] << 24) |
			((uint32_t)input[69] << 16) |
			((uint32_t)input[70] << 8) |
			((uint32_t)input[71]);
	output[17] = (double)value;

	// read output[18]: from bit 576 to 607
	value = ((uint32_t)input[72] << 24) |
			((uint32_t)input[73] << 16) |
			((uint32_t)input[74] << 8) |
			((uint32_t)input[75]);
	output[18] = (double)value;

	// read output[19]: from bit 608 to 639
	value = ((uint32_t)input[76] << 24) |
			((uint32_t)input[77] << 16) |
			((uint32_t)input[78] << 8) |
			((uint32_t)input[79]);
	output[19] = (double)value;

	// read output[20]: from bit 640 to 671
	value = ((uint32_t)input[80] << 24) |
			((uint32_t)input[81] << 16) |
			((uint32_t)input[82] << 8) |
			((uint32_t)input[83]);
	output[20] = (double)value;
}

static void unpack_21_32bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 32-bit unsigned
	// Skip 0 bits, read 672 bits of data.
	// Input must be at least 84 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 31
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);
	output[0] = (double)value;

	// read output[1]: from bit 32 to 63
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16) |
			((uint32_t)input[6] << 8) |
			((uint32_t)input[7]);
	output[1] = (double)value;

	// read output[2]: from bit 64 to 95
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)input[10] << 8) |
			((uint32_t)input[11]);
	output[2] = (double)value;

	// read output[3]: from bit 96 to 127
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)input[14] << 8) |
			((uint32_t)input[15]);
	output[3] = (double)value;

	// read output[4]: from bit 128 to 159
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)input[18] << 8) |
			((uint32_t)input[19]);
	output[4] = (double)value;

	// read output[5]: from bit 160 to 191
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)input[22] << 8) |
			((uint32_t)input[23]);
	output[5] = (double)value;

	// read output[6]: from bit 192 to 223
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16) |
			((uint32_t)input[26] << 8) |
			((uint32_t)input[27]);
	output[6] = (double)value;

	// read output[7]: from bit 224 to 255
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)input[30] << 8) |
			((uint32_t)input[31]);
	output[7] = (double)value;

	// read output[8]: from bit 256 to 287
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)input[34] << 8) |
			((uint32_t)input[35]);
	output[8] = (double)value;

	// read output[9]: from bit 288 to 319
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)input[38] << 8) |
			((uint32_t)input[39]);
	output[9] = (double)value;

	// read output[10]: from bit 320 to 351
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)input[42] << 8) |
			((uint32_t)input[43]);
	output[10] = (double)value;

	// read output[11]: from bit 352 to 383
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)input[46] << 8) |
			((uint32_t)input[47]);
	output[11] = (double)value;

	// read output[12]: from bit 384 to 415
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)input[50] << 8) |
			((uint32_t)input[51]);
	output[12] = (double)value;

	// read output[13]: from bit 416 to 447
	value = ((uint32_t)input[52] << 24) |
			((uint32_t)input[53] << 16) |
			((uint32_t)input[54] << 8) |
			((uint32_t)input[55]);
	output[13] = (double)value;

	// read output[14]: from bit 448 to 479
	value = ((uint32_t)input[56] << 24) |
			((uint32_t)input[57] << 16) |
			((uint32_t)input[58] << 8) |
			((uint32_t)input[59]);
	output[14] = (double)value;

	// read output[15]: from bit 480 to 511
	value = ((uint32_t)input[60] << 24) |
			((uint32_t)input[61] << 16) |
			((uint32_t)input[62] << 8) |
			((uint32_t)input[63]);
	output[15] = (double)value;

	// read output[16]: from bit 512 to 543
	value = ((uint32_t)input[64] << 24) |
			((uint32_t)input[65] << 16) |
			((uint32_t)input[66] << 8) |
			((uint32_t)input[67]);
	output[16] = (double)value;

	// read output[17]: from bit 544 to 575
	value = ((uint32_t)input[68] << 24) |
			((uint32_t)input[69] << 16) |
			((uint32_t)input[70] << 8) |
			((uint32_t)input[71]);
	output[17] = (double)value;

	// read output[18]: from bit 576 to 607
	value = ((uint32_t)input[72] << 24) |
			((uint32_t)input[73] << 16) |
			((uint32_t)input[74] << 8) |
			((uint32_t)input[75]);
	output[18] = (double)value;

	// read output[19]: from bit 608 to 639
	value = ((uint32_t)input[76] << 24) |
			((uint32_t)input[77] << 16) |
			((uint32_t)input[78] << 8) |
			((uint32_t)input[79]);
	output[19] = (double)value;

	// read output[20]: from bit 640 to 671
	value = ((uint32_t)input[80] << 24) |
			((uint32_t)input[81] << 16) |
			((uint32_t)input[82] << 8) |
			((uint32_t)input[83]);
	output[20] = (double)value;
}

static void unpack_21_32bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 32-bit signed
	// Skip 1 bits, read 672 bits of data.
	// Input must be at least 85 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;

	// read output[15]: from bit 481 to 512
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)input[63] << 1) |
			((uint32_t)(input[64] & 0x80) >> 7);
	output[15] = (double)value;

	// read output[16]: from bit 513 to 544
	value = ((uint32_t)(input[64] & 0x7f) << 25) |
			((uint32_t)input[65] << 17) |
			((uint32_t)input[66] << 9) |
			((uint32_t)input[67] << 1) |
			((uint32_t)(input[68] & 0x80) >> 7);
	output[16] = (double)value;

	// read output[17]: from bit 545 to 576
	value = ((uint32_t)(input[68] & 0x7f) << 25) |
			((uint32_t)input[69] << 17) |
			((uint32_t)input[70] << 9) |
			((uint32_t)input[71] << 1) |
			((uint32_t)(input[72] & 0x80) >> 7);
	output[17] = (double)value;

	// read output[18]: from bit 577 to 608
	value = ((uint32_t)(input[72] & 0x7f) << 25) |
			((uint32_t)input[73] << 17) |
			((uint32_t)input[74] << 9) |
			((uint32_t)input[75] << 1) |
			((uint32_t)(input[76] & 0x80) >> 7);
	output[18] = (double)value;

	// read output[19]: from bit 609 to 640
	value = ((uint32_t)(input[76] & 0x7f) << 25) |
			((uint32_t)input[77] << 17) |
			((uint32_t)input[78] << 9) |
			((uint32_t)input[79] << 1) |
			((uint32_t)(input[80] & 0x80) >> 7);
	output[19] = (double)value;

	// read output[20]: from bit 641 to 672
	value = ((uint32_t)(input[80] & 0x7f) << 25) |
			((uint32_t)input[81] << 17) |
			((uint32_t)input[82] << 9) |
			((uint32_t)input[83] << 1) |
			((uint32_t)(input[84] & 0x80) >> 7);
	output[20] = (double)value;
}

static void unpack_21_32bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 32-bit unsigned
	// Skip 1 bits, read 672 bits of data.
	// Input must be at least 85 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 32
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)(input[4] & 0x80) >> 7);
	output[0] = (double)value;

	// read output[1]: from bit 33 to 64
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)input[6] << 9) |
			((uint32_t)input[7] << 1) |
			((uint32_t)(input[8] & 0x80) >> 7);
	output[1] = (double)value;

	// read output[2]: from bit 65 to 96
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)input[10] << 9) |
			((uint32_t)input[11] << 1) |
			((uint32_t)(input[12] & 0x80) >> 7);
	output[2] = (double)value;

	// read output[3]: from bit 97 to 128
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)input[14] << 9) |
			((uint32_t)input[15] << 1) |
			((uint32_t)(input[16] & 0x80) >> 7);
	output[3] = (double)value;

	// read output[4]: from bit 129 to 160
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)input[18] << 9) |
			((uint32_t)input[19] << 1) |
			((uint32_t)(input[20] & 0x80) >> 7);
	output[4] = (double)value;

	// read output[5]: from bit 161 to 192
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)input[22] << 9) |
			((uint32_t)input[23] << 1) |
			((uint32_t)(input[24] & 0x80) >> 7);
	output[5] = (double)value;

	// read output[6]: from bit 193 to 224
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)input[26] << 9) |
			((uint32_t)input[27] << 1) |
			((uint32_t)(input[28] & 0x80) >> 7);
	output[6] = (double)value;

	// read output[7]: from bit 225 to 256
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)input[30] << 9) |
			((uint32_t)input[31] << 1) |
			((uint32_t)(input[32] & 0x80) >> 7);
	output[7] = (double)value;

	// read output[8]: from bit 257 to 288
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)input[34] << 9) |
			((uint32_t)input[35] << 1) |
			((uint32_t)(input[36] & 0x80) >> 7);
	output[8] = (double)value;

	// read output[9]: from bit 289 to 320
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)input[38] << 9) |
			((uint32_t)input[39] << 1) |
			((uint32_t)(input[40] & 0x80) >> 7);
	output[9] = (double)value;

	// read output[10]: from bit 321 to 352
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)input[42] << 9) |
			((uint32_t)input[43] << 1) |
			((uint32_t)(input[44] & 0x80) >> 7);
	output[10] = (double)value;

	// read output[11]: from bit 353 to 384
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)input[46] << 9) |
			((uint32_t)input[47] << 1) |
			((uint32_t)(input[48] & 0x80) >> 7);
	output[11] = (double)value;

	// read output[12]: from bit 385 to 416
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)input[50] << 9) |
			((uint32_t)input[51] << 1) |
			((uint32_t)(input[52] & 0x80) >> 7);
	output[12] = (double)value;

	// read output[13]: from bit 417 to 448
	value = ((uint32_t)(input[52] & 0x7f) << 25) |
			((uint32_t)input[53] << 17) |
			((uint32_t)input[54] << 9) |
			((uint32_t)input[55] << 1) |
			((uint32_t)(input[56] & 0x80) >> 7);
	output[13] = (double)value;

	// read output[14]: from bit 449 to 480
	value = ((uint32_t)(input[56] & 0x7f) << 25) |
			((uint32_t)input[57] << 17) |
			((uint32_t)input[58] << 9) |
			((uint32_t)input[59] << 1) |
			((uint32_t)(input[60] & 0x80) >> 7);
	output[14] = (double)value;

	// read output[15]: from bit 481 to 512
	value = ((uint32_t)(input[60] & 0x7f) << 25) |
			((uint32_t)input[61] << 17) |
			((uint32_t)input[62] << 9) |
			((uint32_t)input[63] << 1) |
			((uint32_t)(input[64] & 0x80) >> 7);
	output[15] = (double)value;

	// read output[16]: from bit 513 to 544
	value = ((uint32_t)(input[64] & 0x7f) << 25) |
			((uint32_t)input[65] << 17) |
			((uint32_t)input[66] << 9) |
			((uint32_t)input[67] << 1) |
			((uint32_t)(input[68] & 0x80) >> 7);
	output[16] = (double)value;

	// read output[17]: from bit 545 to 576
	value = ((uint32_t)(input[68] & 0x7f) << 25) |
			((uint32_t)input[69] << 17) |
			((uint32_t)input[70] << 9) |
			((uint32_t)input[71] << 1) |
			((uint32_t)(input[72] & 0x80) >> 7);
	output[17] = (double)value;

	// read output[18]: from bit 577 to 608
	value = ((uint32_t)(input[72] & 0x7f) << 25) |
			((uint32_t)input[73] << 17) |
			((uint32_t)input[74] << 9) |
			((uint32_t)input[75] << 1) |
			((uint32_t)(input[76] & 0x80) >> 7);
	output[18] = (double)value;

	// read output[19]: from bit 609 to 640
	value = ((uint32_t)(input[76] & 0x7f) << 25) |
			((uint32_t)input[77] << 17) |
			((uint32_t)input[78] << 9) |
			((uint32_t)input[79] << 1) |
			((uint32_t)(input[80] & 0x80) >> 7);
	output[19] = (double)value;

	// read output[20]: from bit 641 to 672
	value = ((uint32_t)(input[80] & 0x7f) << 25) |
			((uint32_t)input[81] << 17) |
			((uint32_t)input[82] << 9) |
			((uint32_t)input[83] << 1) |
			((uint32_t)(input[84] & 0x80) >> 7);
	output[20] = (double)value;
}

static void unpack_21_32bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 32-bit signed
	// Skip 2 bits, read 672 bits of data.
	// Input must be at least 85 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;

	// read output[15]: from bit 482 to 513
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2) |
			((uint32_t)(input[64] & 0xc0) >> 6);
	output[15] = (double)value;

	// read output[16]: from bit 514 to 545
	value = ((uint32_t)(input[64] & 0x3f) << 26) |
			((uint32_t)input[65] << 18) |
			((uint32_t)input[66] << 10) |
			((uint32_t)input[67] << 2) |
			((uint32_t)(input[68] & 0xc0) >> 6);
	output[16] = (double)value;

	// read output[17]: from bit 546 to 577
	value = ((uint32_t)(input[68] & 0x3f) << 26) |
			((uint32_t)input[69] << 18) |
			((uint32_t)input[70] << 10) |
			((uint32_t)input[71] << 2) |
			((uint32_t)(input[72] & 0xc0) >> 6);
	output[17] = (double)value;

	// read output[18]: from bit 578 to 609
	value = ((uint32_t)(input[72] & 0x3f) << 26) |
			((uint32_t)input[73] << 18) |
			((uint32_t)input[74] << 10) |
			((uint32_t)input[75] << 2) |
			((uint32_t)(input[76] & 0xc0) >> 6);
	output[18] = (double)value;

	// read output[19]: from bit 610 to 641
	value = ((uint32_t)(input[76] & 0x3f) << 26) |
			((uint32_t)input[77] << 18) |
			((uint32_t)input[78] << 10) |
			((uint32_t)input[79] << 2) |
			((uint32_t)(input[80] & 0xc0) >> 6);
	output[19] = (double)value;

	// read output[20]: from bit 642 to 673
	value = ((uint32_t)(input[80] & 0x3f) << 26) |
			((uint32_t)input[81] << 18) |
			((uint32_t)input[82] << 10) |
			((uint32_t)input[83] << 2) |
			((uint32_t)(input[84] & 0xc0) >> 6);
	output[20] = (double)value;
}

static void unpack_21_32bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 32-bit unsigned
	// Skip 2 bits, read 672 bits of data.
	// Input must be at least 85 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 33
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)(input[4] & 0xc0) >> 6);
	output[0] = (double)value;

	// read output[1]: from bit 34 to 65
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)input[6] << 10) |
			((uint32_t)input[7] << 2) |
			((uint32_t)(input[8] & 0xc0) >> 6);
	output[1] = (double)value;

	// read output[2]: from bit 66 to 97
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10) |
			((uint32_t)input[11] << 2) |
			((uint32_t)(input[12] & 0xc0) >> 6);
	output[2] = (double)value;

	// read output[3]: from bit 98 to 129
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)input[14] << 10) |
			((uint32_t)input[15] << 2) |
			((uint32_t)(input[16] & 0xc0) >> 6);
	output[3] = (double)value;

	// read output[4]: from bit 130 to 161
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)input[18] << 10) |
			((uint32_t)input[19] << 2) |
			((uint32_t)(input[20] & 0xc0) >> 6);
	output[4] = (double)value;

	// read output[5]: from bit 162 to 193
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)input[22] << 10) |
			((uint32_t)input[23] << 2) |
			((uint32_t)(input[24] & 0xc0) >> 6);
	output[5] = (double)value;

	// read output[6]: from bit 194 to 225
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)input[26] << 10) |
			((uint32_t)input[27] << 2) |
			((uint32_t)(input[28] & 0xc0) >> 6);
	output[6] = (double)value;

	// read output[7]: from bit 226 to 257
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10) |
			((uint32_t)input[31] << 2) |
			((uint32_t)(input[32] & 0xc0) >> 6);
	output[7] = (double)value;

	// read output[8]: from bit 258 to 289
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)input[34] << 10) |
			((uint32_t)input[35] << 2) |
			((uint32_t)(input[36] & 0xc0) >> 6);
	output[8] = (double)value;

	// read output[9]: from bit 290 to 321
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10) |
			((uint32_t)input[39] << 2) |
			((uint32_t)(input[40] & 0xc0) >> 6);
	output[9] = (double)value;

	// read output[10]: from bit 322 to 353
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)input[42] << 10) |
			((uint32_t)input[43] << 2) |
			((uint32_t)(input[44] & 0xc0) >> 6);
	output[10] = (double)value;

	// read output[11]: from bit 354 to 385
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10) |
			((uint32_t)input[47] << 2) |
			((uint32_t)(input[48] & 0xc0) >> 6);
	output[11] = (double)value;

	// read output[12]: from bit 386 to 417
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)input[50] << 10) |
			((uint32_t)input[51] << 2) |
			((uint32_t)(input[52] & 0xc0) >> 6);
	output[12] = (double)value;

	// read output[13]: from bit 418 to 449
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10) |
			((uint32_t)input[55] << 2) |
			((uint32_t)(input[56] & 0xc0) >> 6);
	output[13] = (double)value;

	// read output[14]: from bit 450 to 481
	value = ((uint32_t)(input[56] & 0x3f) << 26) |
			((uint32_t)input[57] << 18) |
			((uint32_t)input[58] << 10) |
			((uint32_t)input[59] << 2) |
			((uint32_t)(input[60] & 0xc0) >> 6);
	output[14] = (double)value;

	// read output[15]: from bit 482 to 513
	value = ((uint32_t)(input[60] & 0x3f) << 26) |
			((uint32_t)input[61] << 18) |
			((uint32_t)input[62] << 10) |
			((uint32_t)input[63] << 2) |
			((uint32_t)(input[64] & 0xc0) >> 6);
	output[15] = (double)value;

	// read output[16]: from bit 514 to 545
	value = ((uint32_t)(input[64] & 0x3f) << 26) |
			((uint32_t)input[65] << 18) |
			((uint32_t)input[66] << 10) |
			((uint32_t)input[67] << 2) |
			((uint32_t)(input[68] & 0xc0) >> 6);
	output[16] = (double)value;

	// read output[17]: from bit 546 to 577
	value = ((uint32_t)(input[68] & 0x3f) << 26) |
			((uint32_t)input[69] << 18) |
			((uint32_t)input[70] << 10) |
			((uint32_t)input[71] << 2) |
			((uint32_t)(input[72] & 0xc0) >> 6);
	output[17] = (double)value;

	// read output[18]: from bit 578 to 609
	value = ((uint32_t)(input[72] & 0x3f) << 26) |
			((uint32_t)input[73] << 18) |
			((uint32_t)input[74] << 10) |
			((uint32_t)input[75] << 2) |
			((uint32_t)(input[76] & 0xc0) >> 6);
	output[18] = (double)value;

	// read output[19]: from bit 610 to 641
	value = ((uint32_t)(input[76] & 0x3f) << 26) |
			((uint32_t)input[77] << 18) |
			((uint32_t)input[78] << 10) |
			((uint32_t)input[79] << 2) |
			((uint32_t)(input[80] & 0xc0) >> 6);
	output[19] = (double)value;

	// read output[20]: from bit 642 to 673
	value = ((uint32_t)(input[80] & 0x3f) << 26) |
			((uint32_t)input[81] << 18) |
			((uint32_t)input[82] << 10) |
			((uint32_t)input[83] << 2) |
			((uint32_t)(input[84] & 0xc0) >> 6);
	output[20] = (double)value;
}

static void unpack_21_32bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 32-bit signed
	// Skip 3 bits, read 672 bits of data.
	// Input must be at least 85 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;

	// read output[15]: from bit 483 to 514
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0xe0) >> 5);
	output[15] = (double)value;

	// read output[16]: from bit 515 to 546
	value = ((uint32_t)(input[64] & 0x1f) << 27) |
			((uint32_t)input[65] << 19) |
			((uint32_t)input[66] << 11) |
			((uint32_t)input[67] << 3) |
			((uint32_t)(input[68] & 0xe0) >> 5);
	output[16] = (double)value;

	// read output[17]: from bit 547 to 578
	value = ((uint32_t)(input[68] & 0x1f) << 27) |
			((uint32_t)input[69] << 19) |
			((uint32_t)input[70] << 11) |
			((uint32_t)input[71] << 3) |
			((uint32_t)(input[72] & 0xe0) >> 5);
	output[17] = (double)value;

	// read output[18]: from bit 579 to 610
	value = ((uint32_t)(input[72] & 0x1f) << 27) |
			((uint32_t)input[73] << 19) |
			((uint32_t)input[74] << 11) |
			((uint32_t)input[75] << 3) |
			((uint32_t)(input[76] & 0xe0) >> 5);
	output[18] = (double)value;

	// read output[19]: from bit 611 to 642
	value = ((uint32_t)(input[76] & 0x1f) << 27) |
			((uint32_t)input[77] << 19) |
			((uint32_t)input[78] << 11) |
			((uint32_t)input[79] << 3) |
			((uint32_t)(input[80] & 0xe0) >> 5);
	output[19] = (double)value;

	// read output[20]: from bit 643 to 674
	value = ((uint32_t)(input[80] & 0x1f) << 27) |
			((uint32_t)input[81] << 19) |
			((uint32_t)input[82] << 11) |
			((uint32_t)input[83] << 3) |
			((uint32_t)(input[84] & 0xe0) >> 5);
	output[20] = (double)value;
}

static void unpack_21_32bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 32-bit unsigned
	// Skip 3 bits, read 672 bits of data.
	// Input must be at least 85 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 34
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)(input[4] & 0xe0) >> 5);
	output[0] = (double)value;

	// read output[1]: from bit 35 to 66
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)input[6] << 11) |
			((uint32_t)input[7] << 3) |
			((uint32_t)(input[8] & 0xe0) >> 5);
	output[1] = (double)value;

	// read output[2]: from bit 67 to 98
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)input[11] << 3) |
			((uint32_t)(input[12] & 0xe0) >> 5);
	output[2] = (double)value;

	// read output[3]: from bit 99 to 130
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)input[14] << 11) |
			((uint32_t)input[15] << 3) |
			((uint32_t)(input[16] & 0xe0) >> 5);
	output[3] = (double)value;

	// read output[4]: from bit 131 to 162
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11) |
			((uint32_t)input[19] << 3) |
			((uint32_t)(input[20] & 0xe0) >> 5);
	output[4] = (double)value;

	// read output[5]: from bit 163 to 194
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)input[22] << 11) |
			((uint32_t)input[23] << 3) |
			((uint32_t)(input[24] & 0xe0) >> 5);
	output[5] = (double)value;

	// read output[6]: from bit 195 to 226
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)input[26] << 11) |
			((uint32_t)input[27] << 3) |
			((uint32_t)(input[28] & 0xe0) >> 5);
	output[6] = (double)value;

	// read output[7]: from bit 227 to 258
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)input[31] << 3) |
			((uint32_t)(input[32] & 0xe0) >> 5);
	output[7] = (double)value;

	// read output[8]: from bit 259 to 290
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)input[34] << 11) |
			((uint32_t)input[35] << 3) |
			((uint32_t)(input[36] & 0xe0) >> 5);
	output[8] = (double)value;

	// read output[9]: from bit 291 to 322
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)input[39] << 3) |
			((uint32_t)(input[40] & 0xe0) >> 5);
	output[9] = (double)value;

	// read output[10]: from bit 323 to 354
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)input[42] << 11) |
			((uint32_t)input[43] << 3) |
			((uint32_t)(input[44] & 0xe0) >> 5);
	output[10] = (double)value;

	// read output[11]: from bit 355 to 386
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)input[47] << 3) |
			((uint32_t)(input[48] & 0xe0) >> 5);
	output[11] = (double)value;

	// read output[12]: from bit 387 to 418
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)input[50] << 11) |
			((uint32_t)input[51] << 3) |
			((uint32_t)(input[52] & 0xe0) >> 5);
	output[12] = (double)value;

	// read output[13]: from bit 419 to 450
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)input[55] << 3) |
			((uint32_t)(input[56] & 0xe0) >> 5);
	output[13] = (double)value;

	// read output[14]: from bit 451 to 482
	value = ((uint32_t)(input[56] & 0x1f) << 27) |
			((uint32_t)input[57] << 19) |
			((uint32_t)input[58] << 11) |
			((uint32_t)input[59] << 3) |
			((uint32_t)(input[60] & 0xe0) >> 5);
	output[14] = (double)value;

	// read output[15]: from bit 483 to 514
	value = ((uint32_t)(input[60] & 0x1f) << 27) |
			((uint32_t)input[61] << 19) |
			((uint32_t)input[62] << 11) |
			((uint32_t)input[63] << 3) |
			((uint32_t)(input[64] & 0xe0) >> 5);
	output[15] = (double)value;

	// read output[16]: from bit 515 to 546
	value = ((uint32_t)(input[64] & 0x1f) << 27) |
			((uint32_t)input[65] << 19) |
			((uint32_t)input[66] << 11) |
			((uint32_t)input[67] << 3) |
			((uint32_t)(input[68] & 0xe0) >> 5);
	output[16] = (double)value;

	// read output[17]: from bit 547 to 578
	value = ((uint32_t)(input[68] & 0x1f) << 27) |
			((uint32_t)input[69] << 19) |
			((uint32_t)input[70] << 11) |
			((uint32_t)input[71] << 3) |
			((uint32_t)(input[72] & 0xe0) >> 5);
	output[17] = (double)value;

	// read output[18]: from bit 579 to 610
	value = ((uint32_t)(input[72] & 0x1f) << 27) |
			((uint32_t)input[73] << 19) |
			((uint32_t)input[74] << 11) |
			((uint32_t)input[75] << 3) |
			((uint32_t)(input[76] & 0xe0) >> 5);
	output[18] = (double)value;

	// read output[19]: from bit 611 to 642
	value = ((uint32_t)(input[76] & 0x1f) << 27) |
			((uint32_t)input[77] << 19) |
			((uint32_t)input[78] << 11) |
			((uint32_t)input[79] << 3) |
			((uint32_t)(input[80] & 0xe0) >> 5);
	output[19] = (double)value;

	// read output[20]: from bit 643 to 674
	value = ((uint32_t)(input[80] & 0x1f) << 27) |
			((uint32_t)input[81] << 19) |
			((uint32_t)input[82] << 11) |
			((uint32_t)input[83] << 3) |
			((uint32_t)(input[84] & 0xe0) >> 5);
	output[20] = (double)value;
}

static void unpack_21_32bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 32-bit signed
	// Skip 4 bits, read 672 bits of data.
	// Input must be at least 85 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;

	// read output[15]: from bit 484 to 515
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xf0) >> 4);
	output[15] = (double)value;

	// read output[16]: from bit 516 to 547
	value = ((uint32_t)(input[64] & 0x0f) << 28) |
			((uint32_t)input[65] << 20) |
			((uint32_t)input[66] << 12) |
			((uint32_t)input[67] << 4) |
			((uint32_t)(input[68] & 0xf0) >> 4);
	output[16] = (double)value;

	// read output[17]: from bit 548 to 579
	value = ((uint32_t)(input[68] & 0x0f) << 28) |
			((uint32_t)input[69] << 20) |
			((uint32_t)input[70] << 12) |
			((uint32_t)input[71] << 4) |
			((uint32_t)(input[72] & 0xf0) >> 4);
	output[17] = (double)value;

	// read output[18]: from bit 580 to 611
	value = ((uint32_t)(input[72] & 0x0f) << 28) |
			((uint32_t)input[73] << 20) |
			((uint32_t)input[74] << 12) |
			((uint32_t)input[75] << 4) |
			((uint32_t)(input[76] & 0xf0) >> 4);
	output[18] = (double)value;

	// read output[19]: from bit 612 to 643
	value = ((uint32_t)(input[76] & 0x0f) << 28) |
			((uint32_t)input[77] << 20) |
			((uint32_t)input[78] << 12) |
			((uint32_t)input[79] << 4) |
			((uint32_t)(input[80] & 0xf0) >> 4);
	output[19] = (double)value;

	// read output[20]: from bit 644 to 675
	value = ((uint32_t)(input[80] & 0x0f) << 28) |
			((uint32_t)input[81] << 20) |
			((uint32_t)input[82] << 12) |
			((uint32_t)input[83] << 4) |
			((uint32_t)(input[84] & 0xf0) >> 4);
	output[20] = (double)value;
}

static void unpack_21_32bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 32-bit unsigned
	// Skip 4 bits, read 672 bits of data.
	// Input must be at least 85 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 35
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)(input[4] & 0xf0) >> 4);
	output[0] = (double)value;

	// read output[1]: from bit 36 to 67
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)input[6] << 12) |
			((uint32_t)input[7] << 4) |
			((uint32_t)(input[8] & 0xf0) >> 4);
	output[1] = (double)value;

	// read output[2]: from bit 68 to 99
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)input[11] << 4) |
			((uint32_t)(input[12] & 0xf0) >> 4);
	output[2] = (double)value;

	// read output[3]: from bit 100 to 131
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12) |
			((uint32_t)input[15] << 4) |
			((uint32_t)(input[16] & 0xf0) >> 4);
	output[3] = (double)value;

	// read output[4]: from bit 132 to 163
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)input[19] << 4) |
			((uint32_t)(input[20] & 0xf0) >> 4);
	output[4] = (double)value;

	// read output[5]: from bit 164 to 195
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12) |
			((uint32_t)input[23] << 4) |
			((uint32_t)(input[24] & 0xf0) >> 4);
	output[5] = (double)value;

	// read output[6]: from bit 196 to 227
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)input[26] << 12) |
			((uint32_t)input[27] << 4) |
			((uint32_t)(input[28] & 0xf0) >> 4);
	output[6] = (double)value;

	// read output[7]: from bit 228 to 259
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)input[30] << 12) |
			((uint32_t)input[31] << 4) |
			((uint32_t)(input[32] & 0xf0) >> 4);
	output[7] = (double)value;

	// read output[8]: from bit 260 to 291
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12) |
			((uint32_t)input[35] << 4) |
			((uint32_t)(input[36] & 0xf0) >> 4);
	output[8] = (double)value;

	// read output[9]: from bit 292 to 323
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)input[39] << 4) |
			((uint32_t)(input[40] & 0xf0) >> 4);
	output[9] = (double)value;

	// read output[10]: from bit 324 to 355
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12) |
			((uint32_t)input[43] << 4) |
			((uint32_t)(input[44] & 0xf0) >> 4);
	output[10] = (double)value;

	// read output[11]: from bit 356 to 387
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)input[47] << 4) |
			((uint32_t)(input[48] & 0xf0) >> 4);
	output[11] = (double)value;

	// read output[12]: from bit 388 to 419
	value = ((uint32_t)(input[48] & 0x0f) << 28) |
			((uint32_t)input[49] << 20) |
			((uint32_t)input[50] << 12) |
			((uint32_t)input[51] << 4) |
			((uint32_t)(input[52] & 0xf0) >> 4);
	output[12] = (double)value;

	// read output[13]: from bit 420 to 451
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)input[55] << 4) |
			((uint32_t)(input[56] & 0xf0) >> 4);
	output[13] = (double)value;

	// read output[14]: from bit 452 to 483
	value = ((uint32_t)(input[56] & 0x0f) << 28) |
			((uint32_t)input[57] << 20) |
			((uint32_t)input[58] << 12) |
			((uint32_t)input[59] << 4) |
			((uint32_t)(input[60] & 0xf0) >> 4);
	output[14] = (double)value;

	// read output[15]: from bit 484 to 515
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)input[63] << 4) |
			((uint32_t)(input[64] & 0xf0) >> 4);
	output[15] = (double)value;

	// read output[16]: from bit 516 to 547
	value = ((uint32_t)(input[64] & 0x0f) << 28) |
			((uint32_t)input[65] << 20) |
			((uint32_t)input[66] << 12) |
			((uint32_t)input[67] << 4) |
			((uint32_t)(input[68] & 0xf0) >> 4);
	output[16] = (double)value;

	// read output[17]: from bit 548 to 579
	value = ((uint32_t)(input[68] & 0x0f) << 28) |
			((uint32_t)input[69] << 20) |
			((uint32_t)input[70] << 12) |
			((uint32_t)input[71] << 4) |
			((uint32_t)(input[72] & 0xf0) >> 4);
	output[17] = (double)value;

	// read output[18]: from bit 580 to 611
	value = ((uint32_t)(input[72] & 0x0f) << 28) |
			((uint32_t)input[73] << 20) |
			((uint32_t)input[74] << 12) |
			((uint32_t)input[75] << 4) |
			((uint32_t)(input[76] & 0xf0) >> 4);
	output[18] = (double)value;

	// read output[19]: from bit 612 to 643
	value = ((uint32_t)(input[76] & 0x0f) << 28) |
			((uint32_t)input[77] << 20) |
			((uint32_t)input[78] << 12) |
			((uint32_t)input[79] << 4) |
			((uint32_t)(input[80] & 0xf0) >> 4);
	output[19] = (double)value;

	// read output[20]: from bit 644 to 675
	value = ((uint32_t)(input[80] & 0x0f) << 28) |
			((uint32_t)input[81] << 20) |
			((uint32_t)input[82] << 12) |
			((uint32_t)input[83] << 4) |
			((uint32_t)(input[84] & 0xf0) >> 4);
	output[20] = (double)value;
}

static void unpack_21_32bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 32-bit signed
	// Skip 5 bits, read 672 bits of data.
	// Input must be at least 85 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;

	// read output[15]: from bit 485 to 516
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xf8) >> 3);
	output[15] = (double)value;

	// read output[16]: from bit 517 to 548
	value = ((uint32_t)(input[64] & 0x07) << 29) |
			((uint32_t)input[65] << 21) |
			((uint32_t)input[66] << 13) |
			((uint32_t)input[67] << 5) |
			((uint32_t)(input[68] & 0xf8) >> 3);
	output[16] = (double)value;

	// read output[17]: from bit 549 to 580
	value = ((uint32_t)(input[68] & 0x07) << 29) |
			((uint32_t)input[69] << 21) |
			((uint32_t)input[70] << 13) |
			((uint32_t)input[71] << 5) |
			((uint32_t)(input[72] & 0xf8) >> 3);
	output[17] = (double)value;

	// read output[18]: from bit 581 to 612
	value = ((uint32_t)(input[72] & 0x07) << 29) |
			((uint32_t)input[73] << 21) |
			((uint32_t)input[74] << 13) |
			((uint32_t)input[75] << 5) |
			((uint32_t)(input[76] & 0xf8) >> 3);
	output[18] = (double)value;

	// read output[19]: from bit 613 to 644
	value = ((uint32_t)(input[76] & 0x07) << 29) |
			((uint32_t)input[77] << 21) |
			((uint32_t)input[78] << 13) |
			((uint32_t)input[79] << 5) |
			((uint32_t)(input[80] & 0xf8) >> 3);
	output[19] = (double)value;

	// read output[20]: from bit 645 to 676
	value = ((uint32_t)(input[80] & 0x07) << 29) |
			((uint32_t)input[81] << 21) |
			((uint32_t)input[82] << 13) |
			((uint32_t)input[83] << 5) |
			((uint32_t)(input[84] & 0xf8) >> 3);
	output[20] = (double)value;
}

static void unpack_21_32bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 32-bit unsigned
	// Skip 5 bits, read 672 bits of data.
	// Input must be at least 85 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 36
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)(input[4] & 0xf8) >> 3);
	output[0] = (double)value;

	// read output[1]: from bit 37 to 68
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)input[6] << 13) |
			((uint32_t)input[7] << 5) |
			((uint32_t)(input[8] & 0xf8) >> 3);
	output[1] = (double)value;

	// read output[2]: from bit 69 to 100
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)input[11] << 5) |
			((uint32_t)(input[12] & 0xf8) >> 3);
	output[2] = (double)value;

	// read output[3]: from bit 101 to 132
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)input[15] << 5) |
			((uint32_t)(input[16] & 0xf8) >> 3);
	output[3] = (double)value;

	// read output[4]: from bit 133 to 164
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)input[19] << 5) |
			((uint32_t)(input[20] & 0xf8) >> 3);
	output[4] = (double)value;

	// read output[5]: from bit 165 to 196
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)input[23] << 5) |
			((uint32_t)(input[24] & 0xf8) >> 3);
	output[5] = (double)value;

	// read output[6]: from bit 197 to 228
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)input[26] << 13) |
			((uint32_t)input[27] << 5) |
			((uint32_t)(input[28] & 0xf8) >> 3);
	output[6] = (double)value;

	// read output[7]: from bit 229 to 260
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)input[30] << 13) |
			((uint32_t)input[31] << 5) |
			((uint32_t)(input[32] & 0xf8) >> 3);
	output[7] = (double)value;

	// read output[8]: from bit 261 to 292
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)input[35] << 5) |
			((uint32_t)(input[36] & 0xf8) >> 3);
	output[8] = (double)value;

	// read output[9]: from bit 293 to 324
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)input[39] << 5) |
			((uint32_t)(input[40] & 0xf8) >> 3);
	output[9] = (double)value;

	// read output[10]: from bit 325 to 356
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)input[43] << 5) |
			((uint32_t)(input[44] & 0xf8) >> 3);
	output[10] = (double)value;

	// read output[11]: from bit 357 to 388
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)input[47] << 5) |
			((uint32_t)(input[48] & 0xf8) >> 3);
	output[11] = (double)value;

	// read output[12]: from bit 389 to 420
	value = ((uint32_t)(input[48] & 0x07) << 29) |
			((uint32_t)input[49] << 21) |
			((uint32_t)input[50] << 13) |
			((uint32_t)input[51] << 5) |
			((uint32_t)(input[52] & 0xf8) >> 3);
	output[12] = (double)value;

	// read output[13]: from bit 421 to 452
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)input[55] << 5) |
			((uint32_t)(input[56] & 0xf8) >> 3);
	output[13] = (double)value;

	// read output[14]: from bit 453 to 484
	value = ((uint32_t)(input[56] & 0x07) << 29) |
			((uint32_t)input[57] << 21) |
			((uint32_t)input[58] << 13) |
			((uint32_t)input[59] << 5) |
			((uint32_t)(input[60] & 0xf8) >> 3);
	output[14] = (double)value;

	// read output[15]: from bit 485 to 516
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)input[63] << 5) |
			((uint32_t)(input[64] & 0xf8) >> 3);
	output[15] = (double)value;

	// read output[16]: from bit 517 to 548
	value = ((uint32_t)(input[64] & 0x07) << 29) |
			((uint32_t)input[65] << 21) |
			((uint32_t)input[66] << 13) |
			((uint32_t)input[67] << 5) |
			((uint32_t)(input[68] & 0xf8) >> 3);
	output[16] = (double)value;

	// read output[17]: from bit 549 to 580
	value = ((uint32_t)(input[68] & 0x07) << 29) |
			((uint32_t)input[69] << 21) |
			((uint32_t)input[70] << 13) |
			((uint32_t)input[71] << 5) |
			((uint32_t)(input[72] & 0xf8) >> 3);
	output[17] = (double)value;

	// read output[18]: from bit 581 to 612
	value = ((uint32_t)(input[72] & 0x07) << 29) |
			((uint32_t)input[73] << 21) |
			((uint32_t)input[74] << 13) |
			((uint32_t)input[75] << 5) |
			((uint32_t)(input[76] & 0xf8) >> 3);
	output[18] = (double)value;

	// read output[19]: from bit 613 to 644
	value = ((uint32_t)(input[76] & 0x07) << 29) |
			((uint32_t)input[77] << 21) |
			((uint32_t)input[78] << 13) |
			((uint32_t)input[79] << 5) |
			((uint32_t)(input[80] & 0xf8) >> 3);
	output[19] = (double)value;

	// read output[20]: from bit 645 to 676
	value = ((uint32_t)(input[80] & 0x07) << 29) |
			((uint32_t)input[81] << 21) |
			((uint32_t)input[82] << 13) |
			((uint32_t)input[83] << 5) |
			((uint32_t)(input[84] & 0xf8) >> 3);
	output[20] = (double)value;
}

static void unpack_21_32bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 32-bit signed
	// Skip 6 bits, read 672 bits of data.
	// Input must be at least 85 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 37
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)(input[4] & 0xfc) >> 2);
	output[0] = (double)value;

	// read output[1]: from bit 38 to 69
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)input[7] << 6) |
			((uint32_t)(input[8] & 0xfc) >> 2);
	output[1] = (double)value;

	// read output[2]: from bit 70 to 101
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)input[11] << 6) |
			((uint32_t)(input[12] & 0xfc) >> 2);
	output[2] = (double)value;

	// read output[3]: from bit 102 to 133
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)input[15] << 6) |
			((uint32_t)(input[16] & 0xfc) >> 2);
	output[3] = (double)value;

	// read output[4]: from bit 134 to 165
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)input[19] << 6) |
			((uint32_t)(input[20] & 0xfc) >> 2);
	output[4] = (double)value;

	// read output[5]: from bit 166 to 197
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)input[23] << 6) |
			((uint32_t)(input[24] & 0xfc) >> 2);
	output[5] = (double)value;

	// read output[6]: from bit 198 to 229
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)input[27] << 6) |
			((uint32_t)(input[28] & 0xfc) >> 2);
	output[6] = (double)value;

	// read output[7]: from bit 230 to 261
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)input[30] << 14) |
			((uint32_t)input[31] << 6) |
			((uint32_t)(input[32] & 0xfc) >> 2);
	output[7] = (double)value;

	// read output[8]: from bit 262 to 293
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)input[35] << 6) |
			((uint32_t)(input[36] & 0xfc) >> 2);
	output[8] = (double)value;

	// read output[9]: from bit 294 to 325
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14) |
			((uint32_t)input[39] << 6) |
			((uint32_t)(input[40] & 0xfc) >> 2);
	output[9] = (double)value;

	// read output[10]: from bit 326 to 357
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)input[43] << 6) |
			((uint32_t)(input[44] & 0xfc) >> 2);
	output[10] = (double)value;

	// read output[11]: from bit 358 to 389
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)input[47] << 6) |
			((uint32_t)(input[48] & 0xfc) >> 2);
	output[11] = (double)value;

	// read output[12]: from bit 390 to 421
	value = ((uint32_t)(input[48] & 0x03) << 30) |
			((uint32_t)input[49] << 22) |
			((uint32_t)input[50] << 14) |
			((uint32_t)input[51] << 6) |
			((uint32_t)(input[52] & 0xfc) >> 2);
	output[12] = (double)value;

	// read output[13]: from bit 422 to 453
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)input[55] << 6) |
			((uint32_t)(input[56] & 0xfc) >> 2);
	output[13] = (double)value;

	// read output[14]: from bit 454 to 485
	value = ((uint32_t)(input[56] & 0x03) << 30) |
			((uint32_t)input[57] << 22) |
			((uint32_t)input[58] << 14) |
			((uint32_t)input[59] << 6) |
			((uint32_t)(input[60] & 0xfc) >> 2);
	output[14] = (double)value;

	// read output[15]: from bit 486 to 517
	value = ((uint32_t)(input[60] & 0x03) << 30) |
			((uint32_t)input[61] << 22) |
			((uint32_t)input[62] << 14) |
			((uint32_t)input[63] << 6) |
			((uint32_t)(input[64] & 0xfc) >> 2);
	output[15] = (double)value;

	// read output[16]: from bit 518 to 549
	value = ((uint32_t)(input[6