// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack7.h"



static void unpack_1_7bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit signed
	// Skip 0 bits, read 7 bits of data.
	// Input must be at least 1 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit unsigned
	// Skip 0 bits, read 7 bits of data.
	// Input must be at least 1 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit signed
	// Skip 1 bits, read 7 bits of data.
	// Input must be at least 1 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit unsigned
	// Skip 1 bits, read 7 bits of data.
	// Input must be at least 1 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit signed
	// Skip 2 bits, read 7 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit unsigned
	// Skip 2 bits, read 7 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit signed
	// Skip 3 bits, read 7 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit unsigned
	// Skip 3 bits, read 7 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit signed
	// Skip 4 bits, read 7 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit unsigned
	// Skip 4 bits, read 7 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit signed
	// Skip 5 bits, read 7 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit unsigned
	// Skip 5 bits, read 7 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit signed
	// Skip 6 bits, read 7 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit unsigned
	// Skip 6 bits, read 7 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit signed
	// Skip 7 bits, read 7 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);
}

static void unpack_1_7bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 7-bit unsigned
	// Skip 7 bits, read 7 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);
}

static void unpack_2_7bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit signed
	// Skip 0 bits, read 14 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit unsigned
	// Skip 0 bits, read 14 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit signed
	// Skip 1 bits, read 14 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit unsigned
	// Skip 1 bits, read 14 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit signed
	// Skip 2 bits, read 14 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit unsigned
	// Skip 2 bits, read 14 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit signed
	// Skip 3 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit unsigned
	// Skip 3 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit signed
	// Skip 4 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit unsigned
	// Skip 4 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit signed
	// Skip 5 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit unsigned
	// Skip 5 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit signed
	// Skip 6 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit unsigned
	// Skip 6 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit signed
	// Skip 7 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);
}

static void unpack_2_7bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 7-bit unsigned
	// Skip 7 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);
}

static void unpack_3_7bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit signed
	// Skip 0 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit unsigned
	// Skip 0 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit signed
	// Skip 1 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 15 to 21
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)(input[2] & 0xfc) << 23);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit unsigned
	// Skip 1 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 15 to 21
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)(input[2] & 0xfc) << 23);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit signed
	// Skip 2 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 16 to 22
	value = ((uint32_t)(input[2] & 0xfe) << 24);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit unsigned
	// Skip 2 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 16 to 22
	value = ((uint32_t)(input[2] & 0xfe) << 24);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit signed
	// Skip 3 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 17 to 23
	value = ((uint32_t)(input[2] & 0x7f) << 25);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit unsigned
	// Skip 3 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 17 to 23
	value = ((uint32_t)(input[2] & 0x7f) << 25);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit signed
	// Skip 4 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 18 to 24
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0x80) << 18);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit unsigned
	// Skip 4 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 18 to 24
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0x80) << 18);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit signed
	// Skip 5 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 19 to 25
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xc0) << 19);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit unsigned
	// Skip 5 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 19 to 25
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xc0) << 19);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit signed
	// Skip 6 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 20 to 26
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xe0) << 20);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit unsigned
	// Skip 6 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 20 to 26
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xe0) << 20);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit signed
	// Skip 7 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[2] = (double)(value >> 25);
}

static void unpack_3_7bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 7-bit unsigned
	// Skip 7 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[2] = (double)(value >> 25);
}

static void unpack_4_7bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit signed
	// Skip 0 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit unsigned
	// Skip 0 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit signed
	// Skip 1 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 15 to 21
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)(input[2] & 0xfc) << 23);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 22 to 28
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)(input[3] & 0xf8) << 22);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit unsigned
	// Skip 1 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 15 to 21
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)(input[2] & 0xfc) << 23);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 22 to 28
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)(input[3] & 0xf8) << 22);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit signed
	// Skip 2 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 16 to 22
	value = ((uint32_t)(input[2] & 0xfe) << 24);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 23 to 29
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)(input[3] & 0xfc) << 23);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit unsigned
	// Skip 2 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 16 to 22
	value = ((uint32_t)(input[2] & 0xfe) << 24);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 23 to 29
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)(input[3] & 0xfc) << 23);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit signed
	// Skip 3 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 17 to 23
	value = ((uint32_t)(input[2] & 0x7f) << 25);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 24 to 30
	value = ((uint32_t)(input[3] & 0xfe) << 24);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit unsigned
	// Skip 3 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 17 to 23
	value = ((uint32_t)(input[2] & 0x7f) << 25);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 24 to 30
	value = ((uint32_t)(input[3] & 0xfe) << 24);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit signed
	// Skip 4 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 18 to 24
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0x80) << 18);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 25 to 31
	value = ((uint32_t)(input[3] & 0x7f) << 25);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit unsigned
	// Skip 4 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 18 to 24
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0x80) << 18);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 25 to 31
	value = ((uint32_t)(input[3] & 0x7f) << 25);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit signed
	// Skip 5 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 19 to 25
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xc0) << 19);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 26 to 32
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0x80) << 18);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit unsigned
	// Skip 5 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 19 to 25
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xc0) << 19);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 26 to 32
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0x80) << 18);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit signed
	// Skip 6 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 20 to 26
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xe0) << 20);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 27 to 33
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xc0) << 19);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit unsigned
	// Skip 6 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 20 to 26
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xe0) << 20);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 27 to 33
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xc0) << 19);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit signed
	// Skip 7 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[3] = (double)(value >> 25);
}

static void unpack_4_7bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 7-bit unsigned
	// Skip 7 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[3] = (double)(value >> 25);
}

static void unpack_5_7bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit signed
	// Skip 0 bits, read 35 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit unsigned
	// Skip 0 bits, read 35 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit signed
	// Skip 1 bits, read 35 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 15 to 21
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)(input[2] & 0xfc) << 23);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 22 to 28
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)(input[3] & 0xf8) << 22);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 29 to 35
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)(input[4] & 0xf0) << 21);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit unsigned
	// Skip 1 bits, read 35 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 15 to 21
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)(input[2] & 0xfc) << 23);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 22 to 28
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)(input[3] & 0xf8) << 22);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 29 to 35
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)(input[4] & 0xf0) << 21);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit signed
	// Skip 2 bits, read 35 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 16 to 22
	value = ((uint32_t)(input[2] & 0xfe) << 24);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 23 to 29
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)(input[3] & 0xfc) << 23);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 30 to 36
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)(input[4] & 0xf8) << 22);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit unsigned
	// Skip 2 bits, read 35 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 16 to 22
	value = ((uint32_t)(input[2] & 0xfe) << 24);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 23 to 29
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)(input[3] & 0xfc) << 23);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 30 to 36
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)(input[4] & 0xf8) << 22);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit signed
	// Skip 3 bits, read 35 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 17 to 23
	value = ((uint32_t)(input[2] & 0x7f) << 25);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 24 to 30
	value = ((uint32_t)(input[3] & 0xfe) << 24);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 31 to 37
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)(input[4] & 0xfc) << 23);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit unsigned
	// Skip 3 bits, read 35 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 17 to 23
	value = ((uint32_t)(input[2] & 0x7f) << 25);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 24 to 30
	value = ((uint32_t)(input[3] & 0xfe) << 24);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 31 to 37
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)(input[4] & 0xfc) << 23);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit signed
	// Skip 4 bits, read 35 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 18 to 24
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0x80) << 18);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 25 to 31
	value = ((uint32_t)(input[3] & 0x7f) << 25);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 32 to 38
	value = ((uint32_t)(input[4] & 0xfe) << 24);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit unsigned
	// Skip 4 bits, read 35 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 18 to 24
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0x80) << 18);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 25 to 31
	value = ((uint32_t)(input[3] & 0x7f) << 25);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 32 to 38
	value = ((uint32_t)(input[4] & 0xfe) << 24);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit signed
	// Skip 5 bits, read 35 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 19 to 25
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xc0) << 19);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 26 to 32
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0x80) << 18);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 33 to 39
	value = ((uint32_t)(input[4] & 0x7f) << 25);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit unsigned
	// Skip 5 bits, read 35 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 19 to 25
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xc0) << 19);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 26 to 32
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0x80) << 18);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 33 to 39
	value = ((uint32_t)(input[4] & 0x7f) << 25);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit signed
	// Skip 6 bits, read 35 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 20 to 26
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xe0) << 20);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 27 to 33
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xc0) << 19);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 34 to 40
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0x80) << 18);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit unsigned
	// Skip 6 bits, read 35 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 20 to 26
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xe0) << 20);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 27 to 33
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xc0) << 19);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 34 to 40
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0x80) << 18);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit signed
	// Skip 7 bits, read 35 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[4] = (double)(value >> 25);
}

static void unpack_5_7bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 7-bit unsigned
	// Skip 7 bits, read 35 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[4] = (double)(value >> 25);
}

static void unpack_6_7bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit signed
	// Skip 0 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit unsigned
	// Skip 0 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit signed
	// Skip 1 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 15 to 21
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)(input[2] & 0xfc) << 23);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 22 to 28
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)(input[3] & 0xf8) << 22);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 29 to 35
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)(input[4] & 0xf0) << 21);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 36 to 42
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xe0) << 20);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit unsigned
	// Skip 1 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 15 to 21
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)(input[2] & 0xfc) << 23);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 22 to 28
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)(input[3] & 0xf8) << 22);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 29 to 35
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)(input[4] & 0xf0) << 21);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 36 to 42
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xe0) << 20);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit signed
	// Skip 2 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 16 to 22
	value = ((uint32_t)(input[2] & 0xfe) << 24);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 23 to 29
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)(input[3] & 0xfc) << 23);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 30 to 36
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)(input[4] & 0xf8) << 22);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 37 to 43
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xf0) << 21);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit unsigned
	// Skip 2 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 16 to 22
	value = ((uint32_t)(input[2] & 0xfe) << 24);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 23 to 29
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)(input[3] & 0xfc) << 23);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 30 to 36
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)(input[4] & 0xf8) << 22);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 37 to 43
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xf0) << 21);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit signed
	// Skip 3 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 17 to 23
	value = ((uint32_t)(input[2] & 0x7f) << 25);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 24 to 30
	value = ((uint32_t)(input[3] & 0xfe) << 24);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 31 to 37
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)(input[4] & 0xfc) << 23);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 38 to 44
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)(input[5] & 0xf8) << 22);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit unsigned
	// Skip 3 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 17 to 23
	value = ((uint32_t)(input[2] & 0x7f) << 25);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 24 to 30
	value = ((uint32_t)(input[3] & 0xfe) << 24);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 31 to 37
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)(input[4] & 0xfc) << 23);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 38 to 44
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)(input[5] & 0xf8) << 22);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit signed
	// Skip 4 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 18 to 24
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0x80) << 18);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 25 to 31
	value = ((uint32_t)(input[3] & 0x7f) << 25);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 32 to 38
	value = ((uint32_t)(input[4] & 0xfe) << 24);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 39 to 45
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)(input[5] & 0xfc) << 23);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit unsigned
	// Skip 4 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 18 to 24
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0x80) << 18);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 25 to 31
	value = ((uint32_t)(input[3] & 0x7f) << 25);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 32 to 38
	value = ((uint32_t)(input[4] & 0xfe) << 24);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 39 to 45
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)(input[5] & 0xfc) << 23);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit signed
	// Skip 5 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 19 to 25
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xc0) << 19);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 26 to 32
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0x80) << 18);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 33 to 39
	value = ((uint32_t)(input[4] & 0x7f) << 25);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 40 to 46
	value = ((uint32_t)(input[5] & 0xfe) << 24);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit unsigned
	// Skip 5 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 19 to 25
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xc0) << 19);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 26 to 32
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0x80) << 18);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 33 to 39
	value = ((uint32_t)(input[4] & 0x7f) << 25);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 40 to 46
	value = ((uint32_t)(input[5] & 0xfe) << 24);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit signed
	// Skip 6 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 20 to 26
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xe0) << 20);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 27 to 33
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xc0) << 19);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 34 to 40
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0x80) << 18);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 41 to 47
	value = ((uint32_t)(input[5] & 0x7f) << 25);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit unsigned
	// Skip 6 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 20 to 26
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xe0) << 20);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 27 to 33
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xc0) << 19);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 34 to 40
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0x80) << 18);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 41 to 47
	value = ((uint32_t)(input[5] & 0x7f) << 25);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit signed
	// Skip 7 bits, read 42 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 42 to 48
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0x80) << 18);
	output[5] = (double)(value >> 25);
}

static void unpack_6_7bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 7-bit unsigned
	// Skip 7 bits, read 42 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 42 to 48
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0x80) << 18);
	output[5] = (double)(value >> 25);
}

static void unpack_7_7bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit signed
	// Skip 0 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 42 to 48
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0x80) << 18);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit unsigned
	// Skip 0 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 42 to 48
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0x80) << 18);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit signed
	// Skip 1 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 15 to 21
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)(input[2] & 0xfc) << 23);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 22 to 28
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)(input[3] & 0xf8) << 22);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 29 to 35
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)(input[4] & 0xf0) << 21);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 36 to 42
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xe0) << 20);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 43 to 49
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xc0) << 19);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit unsigned
	// Skip 1 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 15 to 21
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)(input[2] & 0xfc) << 23);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 22 to 28
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)(input[3] & 0xf8) << 22);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 29 to 35
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)(input[4] & 0xf0) << 21);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 36 to 42
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xe0) << 20);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 43 to 49
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xc0) << 19);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit signed
	// Skip 2 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 16 to 22
	value = ((uint32_t)(input[2] & 0xfe) << 24);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 23 to 29
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)(input[3] & 0xfc) << 23);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 30 to 36
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)(input[4] & 0xf8) << 22);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 37 to 43
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xf0) << 21);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 44 to 50
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xe0) << 20);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit unsigned
	// Skip 2 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 16 to 22
	value = ((uint32_t)(input[2] & 0xfe) << 24);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 23 to 29
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)(input[3] & 0xfc) << 23);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 30 to 36
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)(input[4] & 0xf8) << 22);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 37 to 43
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xf0) << 21);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 44 to 50
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xe0) << 20);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit signed
	// Skip 3 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 17 to 23
	value = ((uint32_t)(input[2] & 0x7f) << 25);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 24 to 30
	value = ((uint32_t)(input[3] & 0xfe) << 24);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 31 to 37
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)(input[4] & 0xfc) << 23);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 38 to 44
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)(input[5] & 0xf8) << 22);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 45 to 51
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xf0) << 21);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit unsigned
	// Skip 3 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 17 to 23
	value = ((uint32_t)(input[2] & 0x7f) << 25);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 24 to 30
	value = ((uint32_t)(input[3] & 0xfe) << 24);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 31 to 37
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)(input[4] & 0xfc) << 23);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 38 to 44
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)(input[5] & 0xf8) << 22);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 45 to 51
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xf0) << 21);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit signed
	// Skip 4 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 18 to 24
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0x80) << 18);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 25 to 31
	value = ((uint32_t)(input[3] & 0x7f) << 25);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 32 to 38
	value = ((uint32_t)(input[4] & 0xfe) << 24);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 39 to 45
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)(input[5] & 0xfc) << 23);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 46 to 52
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)(input[6] & 0xf8) << 22);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit unsigned
	// Skip 4 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 18 to 24
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0x80) << 18);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 25 to 31
	value = ((uint32_t)(input[3] & 0x7f) << 25);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 32 to 38
	value = ((uint32_t)(input[4] & 0xfe) << 24);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 39 to 45
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)(input[5] & 0xfc) << 23);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 46 to 52
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)(input[6] & 0xf8) << 22);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit signed
	// Skip 5 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 19 to 25
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xc0) << 19);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 26 to 32
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0x80) << 18);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 33 to 39
	value = ((uint32_t)(input[4] & 0x7f) << 25);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 40 to 46
	value = ((uint32_t)(input[5] & 0xfe) << 24);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 47 to 53
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)(input[6] & 0xfc) << 23);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit unsigned
	// Skip 5 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 19 to 25
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xc0) << 19);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 26 to 32
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0x80) << 18);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 33 to 39
	value = ((uint32_t)(input[4] & 0x7f) << 25);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 40 to 46
	value = ((uint32_t)(input[5] & 0xfe) << 24);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 47 to 53
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)(input[6] & 0xfc) << 23);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit signed
	// Skip 6 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 20 to 26
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xe0) << 20);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 27 to 33
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xc0) << 19);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 34 to 40
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0x80) << 18);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 41 to 47
	value = ((uint32_t)(input[5] & 0x7f) << 25);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 48 to 54
	value = ((uint32_t)(input[6] & 0xfe) << 24);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit unsigned
	// Skip 6 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 20 to 26
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xe0) << 20);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 27 to 33
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xc0) << 19);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 34 to 40
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0x80) << 18);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 41 to 47
	value = ((uint32_t)(input[5] & 0x7f) << 25);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 48 to 54
	value = ((uint32_t)(input[6] & 0xfe) << 24);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit signed
	// Skip 7 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 42 to 48
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0x80) << 18);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 49 to 55
	value = ((uint32_t)(input[6] & 0x7f) << 25);
	output[6] = (double)(value >> 25);
}

static void unpack_7_7bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 7-bit unsigned
	// Skip 7 bits, read 49 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 42 to 48
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0x80) << 18);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 49 to 55
	value = ((uint32_t)(input[6] & 0x7f) << 25);
	output[6] = (double)(value >> 25);
}

static void unpack_8_7bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit signed
	// Skip 0 bits, read 56 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 42 to 48
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0x80) << 18);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 49 to 55
	value = ((uint32_t)(input[6] & 0x7f) << 25);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit unsigned
	// Skip 0 bits, read 56 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 6
	value = ((uint32_t)(input[0] & 0xfe) << 24);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 42 to 48
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0x80) << 18);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 49 to 55
	value = ((uint32_t)(input[6] & 0x7f) << 25);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit signed
	// Skip 1 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 15 to 21
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)(input[2] & 0xfc) << 23);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 22 to 28
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)(input[3] & 0xf8) << 22);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 29 to 35
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)(input[4] & 0xf0) << 21);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 36 to 42
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xe0) << 20);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 43 to 49
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xc0) << 19);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 50 to 56
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0x80) << 18);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit unsigned
	// Skip 1 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 7
	value = ((uint32_t)(input[0] & 0x7f) << 25);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 8 to 14
	value = ((uint32_t)(input[1] & 0xfe) << 24);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 15 to 21
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)(input[2] & 0xfc) << 23);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 22 to 28
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)(input[3] & 0xf8) << 22);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 29 to 35
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)(input[4] & 0xf0) << 21);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 36 to 42
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xe0) << 20);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 43 to 49
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xc0) << 19);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 50 to 56
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0x80) << 18);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit signed
	// Skip 2 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 16 to 22
	value = ((uint32_t)(input[2] & 0xfe) << 24);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 23 to 29
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)(input[3] & 0xfc) << 23);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 30 to 36
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)(input[4] & 0xf8) << 22);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 37 to 43
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xf0) << 21);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 44 to 50
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xe0) << 20);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 51 to 57
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xc0) << 19);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit unsigned
	// Skip 2 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 8
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0x80) << 18);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 9 to 15
	value = ((uint32_t)(input[1] & 0x7f) << 25);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 16 to 22
	value = ((uint32_t)(input[2] & 0xfe) << 24);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 23 to 29
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)(input[3] & 0xfc) << 23);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 30 to 36
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)(input[4] & 0xf8) << 22);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 37 to 43
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xf0) << 21);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 44 to 50
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xe0) << 20);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 51 to 57
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xc0) << 19);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit signed
	// Skip 3 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 17 to 23
	value = ((uint32_t)(input[2] & 0x7f) << 25);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 24 to 30
	value = ((uint32_t)(input[3] & 0xfe) << 24);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 31 to 37
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)(input[4] & 0xfc) << 23);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 38 to 44
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)(input[5] & 0xf8) << 22);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 45 to 51
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xf0) << 21);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 52 to 58
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xe0) << 20);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit unsigned
	// Skip 3 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 9
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xc0) << 19);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 10 to 16
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0x80) << 18);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 17 to 23
	value = ((uint32_t)(input[2] & 0x7f) << 25);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 24 to 30
	value = ((uint32_t)(input[3] & 0xfe) << 24);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 31 to 37
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)(input[4] & 0xfc) << 23);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 38 to 44
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)(input[5] & 0xf8) << 22);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 45 to 51
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xf0) << 21);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 52 to 58
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xe0) << 20);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit signed
	// Skip 4 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 18 to 24
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0x80) << 18);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 25 to 31
	value = ((uint32_t)(input[3] & 0x7f) << 25);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 32 to 38
	value = ((uint32_t)(input[4] & 0xfe) << 24);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 39 to 45
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)(input[5] & 0xfc) << 23);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 46 to 52
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)(input[6] & 0xf8) << 22);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 53 to 59
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xf0) << 21);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit unsigned
	// Skip 4 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 10
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xe0) << 20);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 11 to 17
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xc0) << 19);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 18 to 24
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0x80) << 18);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 25 to 31
	value = ((uint32_t)(input[3] & 0x7f) << 25);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 32 to 38
	value = ((uint32_t)(input[4] & 0xfe) << 24);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 39 to 45
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)(input[5] & 0xfc) << 23);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 46 to 52
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)(input[6] & 0xf8) << 22);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 53 to 59
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xf0) << 21);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit signed
	// Skip 5 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 19 to 25
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xc0) << 19);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 26 to 32
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0x80) << 18);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 33 to 39
	value = ((uint32_t)(input[4] & 0x7f) << 25);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 40 to 46
	value = ((uint32_t)(input[5] & 0xfe) << 24);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 47 to 53
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)(input[6] & 0xfc) << 23);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 54 to 60
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)(input[7] & 0xf8) << 22);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit unsigned
	// Skip 5 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 11
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xf0) << 21);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 12 to 18
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xe0) << 20);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 19 to 25
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xc0) << 19);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 26 to 32
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0x80) << 18);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 33 to 39
	value = ((uint32_t)(input[4] & 0x7f) << 25);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 40 to 46
	value = ((uint32_t)(input[5] & 0xfe) << 24);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 47 to 53
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)(input[6] & 0xfc) << 23);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 54 to 60
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)(input[7] & 0xf8) << 22);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit signed
	// Skip 6 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 20 to 26
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xe0) << 20);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 27 to 33
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xc0) << 19);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 34 to 40
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0x80) << 18);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 41 to 47
	value = ((uint32_t)(input[5] & 0x7f) << 25);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 48 to 54
	value = ((uint32_t)(input[6] & 0xfe) << 24);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 55 to 61
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)(input[7] & 0xfc) << 23);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit unsigned
	// Skip 6 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 12
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)(input[1] & 0xf8) << 22);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 13 to 19
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xf0) << 21);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 20 to 26
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xe0) << 20);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 27 to 33
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xc0) << 19);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 34 to 40
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0x80) << 18);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 41 to 47
	value = ((uint32_t)(input[5] & 0x7f) << 25);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 48 to 54
	value = ((uint32_t)(input[6] & 0xfe) << 24);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 55 to 61
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)(input[7] & 0xfc) << 23);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit signed
	// Skip 7 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 42 to 48
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0x80) << 18);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 49 to 55
	value = ((uint32_t)(input[6] & 0x7f) << 25);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 56 to 62
	value = ((uint32_t)(input[7] & 0xfe) << 24);
	output[7] = (double)(value >> 25);
}

static void unpack_8_7bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 7-bit unsigned
	// Skip 7 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 13
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)(input[1] & 0xfc) << 23);
	output[0] = (double)(value >> 25);

	// read output[1]: from bit 14 to 20
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)(input[2] & 0xf8) << 22);
	output[1] = (double)(value >> 25);

	// read output[2]: from bit 21 to 27
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xf0) << 21);
	output[2] = (double)(value >> 25);

	// read output[3]: from bit 28 to 34
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xe0) << 20);
	output[3] = (double)(value >> 25);

	// read output[4]: from bit 35 to 41
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xc0) << 19);
	output[4] = (double)(value >> 25);

	// read output[5]: from bit 42 to 48
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0x80) << 18);
	output[5] = (double)(value >> 25);

	// read output[6]: from bit 49 to 55
	value = ((uint32_t)(input[6] & 0x7f) << 25);
	output[6] = (double)(value >> 25);

	// read output[7]: from bit 56 to 62
	value = ((uint32_t)(input[7] & 0xfe) << 24);
	output[7] = (double)(value >> 25);
}


unpack_func_t unpack_7bit[UNPACK_7BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_7bit_unsigned_0off,
			unpack_1_7bit_signed_0off,
		},
		{
			unpack_1_7bit_unsigned_1off,
			unpack_1_7bit_signed_1off,
		},
		{
			unpack_1_7bit_unsigned_2off,
			unpack_1_7bit_signed_2off,
		},
		{
			unpack_1_7bit_unsigned_3off,
			unpack_1_7bit_signed_3off,
		},
		{
			unpack_1_7bit_unsigned_4off,
			unpack_1_7bit_signed_4off,
		},
		{
			unpack_1_7bit_unsigned_5off,
			unpack_1_7bit_signed_5off,
		},
		{
			unpack_1_7bit_unsigned_6off,
			unpack_1_7bit_signed_6off,
		},
		{
			unpack_1_7bit_unsigned_7off,
			unpack_1_7bit_signed_7off,
		},
	},
	{
		{
			unpack_2_7bit_unsigned_0off,
			unpack_2_7bit_signed_0off,
		},
		{
			unpack_2_7bit_unsigned_1off,
			unpack_2_7bit_signed_1off,
		},
		{
			unpack_2_7bit_unsigned_2off,
			unpack_2_7bit_signed_2off,
		},
		{
			unpack_2_7bit_unsigned_3off,
			unpack_2_7bit_signed_3off,
		},
		{
			unpack_2_7bit_unsigned_4off,
			unpack_2_7bit_signed_4off,
		},
		{
			unpack_2_7bit_unsigned_5off,
			unpack_2_7bit_signed_5off,
		},
		{
			unpack_2_7bit_unsigned_6off,
			unpack_2_7bit_signed_6off,
		},
		{
			unpack_2_7bit_unsigned_7off,
			unpack_2_7bit_signed_7off,
		},
	},
	{
		{
			unpack_3_7bit_unsigned_0off,
			unpack_3_7bit_signed_0off,
		},
		{
			unpack_3_7bit_unsigned_1off,
			unpack_3_7bit_signed_1off,
		},
		{
			unpack_3_7bit_unsigned_2off,
			unpack_3_7bit_signed_2off,
		},
		{
			unpack_3_7bit_unsigned_3off,
			unpack_3_7bit_signed_3off,
		},
		{
			unpack_3_7bit_unsigned_4off,
			unpack_3_7bit_signed_4off,
		},
		{
			unpack_3_7bit_unsigned_5off,
			unpack_3_7bit_signed_5off,
		},
		{
			unpack_3_7bit_unsigned_6off,
			unpack_3_7bit_signed_6off,
		},
		{
			unpack_3_7bit_unsigned_7off,
			unpack_3_7bit_signed_7off,
		},
	},
	{
		{
			unpack_4_7bit_unsigned_0off,
			unpack_4_7bit_signed_0off,
		},
		{
			unpack_4_7bit_unsigned_1off,
			unpack_4_7bit_signed_1off,
		},
		{
			unpack_4_7bit_unsigned_2off,
			unpack_4_7bit_signed_2off,
		},
		{
			unpack_4_7bit_unsigned_3off,
			unpack_4_7bit_signed_3off,
		},
		{
			unpack_4_7bit_unsigned_4off,
			unpack_4_7bit_signed_4off,
		},
		{
			unpack_4_7bit_unsigned_5off,
			unpack_4_7bit_signed_5off,
		},
		{
			unpack_4_7bit_unsigned_6off,
			unpack_4_7bit_signed_6off,
		},
		{
			unpack_4_7bit_unsigned_7off,
			unpack_4_7bit_signed_7off,
		},
	},
	{
		{
			unpack_5_7bit_unsigned_0off,
			unpack_5_7bit_signed_0off,
		},
		{
			unpack_5_7bit_unsigned_1off,
			unpack_5_7bit_signed_1off,
		},
		{
			unpack_5_7bit_unsigned_2off,
			unpack_5_7bit_signed_2off,
		},
		{
			unpack_5_7bit_unsigned_3off,
			unpack_5_7bit_signed_3off,
		},
		{
			unpack_5_7bit_unsigned_4off,
			unpack_5_7bit_signed_4off,
		},
		{
			unpack_5_7bit_unsigned_5off,
			unpack_5_7bit_signed_5off,
		},
		{
			unpack_5_7bit_unsigned_6off,
			unpack_5_7bit_signed_6off,
		},
		{
			unpack_5_7bit_unsigned_7off,
			unpack_5_7bit_signed_7off,
		},
	},
	{
		{
			unpack_6_7bit_unsigned_0off,
			unpack_6_7bit_signed_0off,
		},
		{
			unpack_6_7bit_unsigned_1off,
			unpack_6_7bit_signed_1off,
		},
		{
			unpack_6_7bit_unsigned_2off,
			unpack_6_7bit_signed_2off,
		},
		{
			unpack_6_7bit_unsigned_3off,
			unpack_6_7bit_signed_3off,
		},
		{
			unpack_6_7bit_unsigned_4off,
			unpack_6_7bit_signed_4off,
		},
		{
			unpack_6_7bit_unsigned_5off,
			unpack_6_7bit_signed_5off,
		},
		{
			unpack_6_7bit_unsigned_6off,
			unpack_6_7bit_signed_6off,
		},
		{
			unpack_6_7bit_unsigned_7off,
			unpack_6_7bit_signed_7off,
		},
	},
	{
		{
			unpack_7_7bit_unsigned_0off,
			unpack_7_7bit_signed_0off,
		},
		{
			unpack_7_7bit_unsigned_1off,
			unpack_7_7bit_signed_1off,
		},
		{
			unpack_7_7bit_unsigned_2off,
			unpack_7_7bit_signed_2off,
		},
		{
			unpack_7_7bit_unsigned_3off,
			unpack_7_7bit_signed_3off,
		},
		{
			unpack_7_7bit_unsigned_4off,
			unpack_7_7bit_signed_4off,
		},
		{
			unpack_7_7bit_unsigned_5off,
			unpack_7_7bit_signed_5off,
		},
		{
			unpack_7_7bit_unsigned_6off,
			unpack_7_7bit_signed_6off,
		},
		{
			unpack_7_7bit_unsigned_7off,
			unpack_7_7bit_signed_7off,
		},
	},
	{
		{
			unpack_8_7bit_unsigned_0off,
			unpack_8_7bit_signed_0off,
		},
		{
			unpack_8_7bit_unsigned_1off,
			unpack_8_7bit_signed_1off,
		},
		{
			unpack_8_7bit_unsigned_2off,
			unpack_8_7bit_signed_2off,
		},
		{
			unpack_8_7bit_unsigned_3off,
			unpack_8_7bit_signed_3off,
		},
		{
			unpack_8_7bit_unsigned_4off,
			unpack_8_7bit_signed_4off,
		},
		{
			unpack_8_7bit_unsigned_5off,
			unpack_8_7bit_signed_5off,
		},
		{
			unpack_8_7bit_unsigned_6off,
			unpack_8_7bit_signed_6off,
		},
		{
			unpack_8_7bit_unsigned_7off,
			unpack_8_7bit_signed_7off,
		},
	},
};
