// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdint.h>
#include "unwrap.h"

static uint64_t unwrap_8bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 8 bits of data

	uint64_t new_counter = ((uint32_t)input[0]);

	uint64_t mask = ((uint64_t)1 << 8) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 8;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_8bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 8 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 1) |
			((uint32_t)input[1] >> 7);

	uint64_t mask = ((uint64_t)1 << 8) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 8;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_8bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 8 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 2) |
			((uint32_t)input[1] >> 6);

	uint64_t mask = ((uint64_t)1 << 8) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 8;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_8bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 8 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 3) |
			((uint32_t)input[1] >> 5);

	uint64_t mask = ((uint64_t)1 << 8) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 8;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_8bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 8 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 4) |
			((uint32_t)input[1] >> 4);

	uint64_t mask = ((uint64_t)1 << 8) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 8;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_8bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 8 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 5) |
			((uint32_t)input[1] >> 3);

	uint64_t mask = ((uint64_t)1 << 8) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 8;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_8bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 8 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 6) |
			((uint32_t)input[1] >> 2);

	uint64_t mask = ((uint64_t)1 << 8) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 8;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_8bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 8 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 7) |
			((uint32_t)input[1] >> 1);

	uint64_t mask = ((uint64_t)1 << 8) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 8;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_9bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 9 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 1) |
			((uint32_t)input[1] >> 7);

	uint64_t mask = ((uint64_t)1 << 9) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 9;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_9bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 9 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 2) |
			((uint32_t)input[1] >> 6);

	uint64_t mask = ((uint64_t)1 << 9) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 9;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_9bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 9 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 3) |
			((uint32_t)input[1] >> 5);

	uint64_t mask = ((uint64_t)1 << 9) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 9;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_9bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 9 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 4) |
			((uint32_t)input[1] >> 4);

	uint64_t mask = ((uint64_t)1 << 9) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 9;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_9bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 9 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 5) |
			((uint32_t)input[1] >> 3);

	uint64_t mask = ((uint64_t)1 << 9) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 9;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_9bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 9 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 6) |
			((uint32_t)input[1] >> 2);

	uint64_t mask = ((uint64_t)1 << 9) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 9;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_9bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 9 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 7) |
			((uint32_t)input[1] >> 1);

	uint64_t mask = ((uint64_t)1 << 9) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 9;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_9bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 9 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 8) |
			((uint32_t)input[1]);

	uint64_t mask = ((uint64_t)1 << 9) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 9;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_10bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 10 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 2) |
			((uint32_t)input[1] >> 6);

	uint64_t mask = ((uint64_t)1 << 10) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 10;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_10bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 10 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 3) |
			((uint32_t)input[1] >> 5);

	uint64_t mask = ((uint64_t)1 << 10) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 10;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_10bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 10 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 4) |
			((uint32_t)input[1] >> 4);

	uint64_t mask = ((uint64_t)1 << 10) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 10;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_10bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 10 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 5) |
			((uint32_t)input[1] >> 3);

	uint64_t mask = ((uint64_t)1 << 10) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 10;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_10bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 10 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 6) |
			((uint32_t)input[1] >> 2);

	uint64_t mask = ((uint64_t)1 << 10) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 10;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_10bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 10 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 7) |
			((uint32_t)input[1] >> 1);

	uint64_t mask = ((uint64_t)1 << 10) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 10;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_10bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 10 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 8) |
			((uint32_t)input[1]);

	uint64_t mask = ((uint64_t)1 << 10) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 10;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_10bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 10 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 9) |
			((uint32_t)input[1] << 1) |
			((uint32_t)input[2] >> 7);

	uint64_t mask = ((uint64_t)1 << 10) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 10;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_11bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 11 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 3) |
			((uint32_t)input[1] >> 5);

	uint64_t mask = ((uint64_t)1 << 11) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 11;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_11bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 11 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 4) |
			((uint32_t)input[1] >> 4);

	uint64_t mask = ((uint64_t)1 << 11) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 11;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_11bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 11 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 5) |
			((uint32_t)input[1] >> 3);

	uint64_t mask = ((uint64_t)1 << 11) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 11;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_11bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 11 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 6) |
			((uint32_t)input[1] >> 2);

	uint64_t mask = ((uint64_t)1 << 11) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 11;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_11bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 11 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 7) |
			((uint32_t)input[1] >> 1);

	uint64_t mask = ((uint64_t)1 << 11) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 11;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_11bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 11 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 8) |
			((uint32_t)input[1]);

	uint64_t mask = ((uint64_t)1 << 11) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 11;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_11bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 11 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 9) |
			((uint32_t)input[1] << 1) |
			((uint32_t)input[2] >> 7);

	uint64_t mask = ((uint64_t)1 << 11) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 11;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_11bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 11 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 10) |
			((uint32_t)input[1] << 2) |
			((uint32_t)input[2] >> 6);

	uint64_t mask = ((uint64_t)1 << 11) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 11;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_12bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 12 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 4) |
			((uint32_t)input[1] >> 4);

	uint64_t mask = ((uint64_t)1 << 12) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 12;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_12bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 12 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 5) |
			((uint32_t)input[1] >> 3);

	uint64_t mask = ((uint64_t)1 << 12) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 12;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_12bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 12 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 6) |
			((uint32_t)input[1] >> 2);

	uint64_t mask = ((uint64_t)1 << 12) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 12;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_12bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 12 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 7) |
			((uint32_t)input[1] >> 1);

	uint64_t mask = ((uint64_t)1 << 12) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 12;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_12bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 12 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 8) |
			((uint32_t)input[1]);

	uint64_t mask = ((uint64_t)1 << 12) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 12;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_12bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 12 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 9) |
			((uint32_t)input[1] << 1) |
			((uint32_t)input[2] >> 7);

	uint64_t mask = ((uint64_t)1 << 12) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 12;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_12bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 12 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 10) |
			((uint32_t)input[1] << 2) |
			((uint32_t)input[2] >> 6);

	uint64_t mask = ((uint64_t)1 << 12) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 12;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_12bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 12 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 11) |
			((uint32_t)input[1] << 3) |
			((uint32_t)input[2] >> 5);

	uint64_t mask = ((uint64_t)1 << 12) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 12;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_13bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 13 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 5) |
			((uint32_t)input[1] >> 3);

	uint64_t mask = ((uint64_t)1 << 13) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 13;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_13bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 13 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 6) |
			((uint32_t)input[1] >> 2);

	uint64_t mask = ((uint64_t)1 << 13) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 13;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_13bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 13 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 7) |
			((uint32_t)input[1] >> 1);

	uint64_t mask = ((uint64_t)1 << 13) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 13;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_13bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 13 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 8) |
			((uint32_t)input[1]);

	uint64_t mask = ((uint64_t)1 << 13) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 13;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_13bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 13 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 9) |
			((uint32_t)input[1] << 1) |
			((uint32_t)input[2] >> 7);

	uint64_t mask = ((uint64_t)1 << 13) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 13;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_13bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 13 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 10) |
			((uint32_t)input[1] << 2) |
			((uint32_t)input[2] >> 6);

	uint64_t mask = ((uint64_t)1 << 13) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 13;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_13bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 13 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 11) |
			((uint32_t)input[1] << 3) |
			((uint32_t)input[2] >> 5);

	uint64_t mask = ((uint64_t)1 << 13) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 13;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_13bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 13 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 12) |
			((uint32_t)input[1] << 4) |
			((uint32_t)input[2] >> 4);

	uint64_t mask = ((uint64_t)1 << 13) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 13;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_14bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 14 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 6) |
			((uint32_t)input[1] >> 2);

	uint64_t mask = ((uint64_t)1 << 14) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 14;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_14bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 14 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 7) |
			((uint32_t)input[1] >> 1);

	uint64_t mask = ((uint64_t)1 << 14) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 14;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_14bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 14 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 8) |
			((uint32_t)input[1]);

	uint64_t mask = ((uint64_t)1 << 14) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 14;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_14bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 14 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 9) |
			((uint32_t)input[1] << 1) |
			((uint32_t)input[2] >> 7);

	uint64_t mask = ((uint64_t)1 << 14) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 14;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_14bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 14 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 10) |
			((uint32_t)input[1] << 2) |
			((uint32_t)input[2] >> 6);

	uint64_t mask = ((uint64_t)1 << 14) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 14;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_14bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 14 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 11) |
			((uint32_t)input[1] << 3) |
			((uint32_t)input[2] >> 5);

	uint64_t mask = ((uint64_t)1 << 14) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 14;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_14bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 14 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 12) |
			((uint32_t)input[1] << 4) |
			((uint32_t)input[2] >> 4);

	uint64_t mask = ((uint64_t)1 << 14) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 14;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_14bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 14 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 13) |
			((uint32_t)input[1] << 5) |
			((uint32_t)input[2] >> 3);

	uint64_t mask = ((uint64_t)1 << 14) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 14;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_15bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 15 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 7) |
			((uint32_t)input[1] >> 1);

	uint64_t mask = ((uint64_t)1 << 15) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 15;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_15bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 15 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 8) |
			((uint32_t)input[1]);

	uint64_t mask = ((uint64_t)1 << 15) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 15;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_15bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 15 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 9) |
			((uint32_t)input[1] << 1) |
			((uint32_t)input[2] >> 7);

	uint64_t mask = ((uint64_t)1 << 15) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 15;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_15bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 15 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 10) |
			((uint32_t)input[1] << 2) |
			((uint32_t)input[2] >> 6);

	uint64_t mask = ((uint64_t)1 << 15) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 15;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_15bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 15 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 11) |
			((uint32_t)input[1] << 3) |
			((uint32_t)input[2] >> 5);

	uint64_t mask = ((uint64_t)1 << 15) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 15;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_15bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 15 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 12) |
			((uint32_t)input[1] << 4) |
			((uint32_t)input[2] >> 4);

	uint64_t mask = ((uint64_t)1 << 15) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 15;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_15bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 15 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 13) |
			((uint32_t)input[1] << 5) |
			((uint32_t)input[2] >> 3);

	uint64_t mask = ((uint64_t)1 << 15) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 15;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_15bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 15 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 14) |
			((uint32_t)input[1] << 6) |
			((uint32_t)input[2] >> 2);

	uint64_t mask = ((uint64_t)1 << 15) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 15;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_16bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 16 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 8) |
			((uint32_t)input[1]);

	uint64_t mask = ((uint64_t)1 << 16) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 16;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_16bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 16 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 9) |
			((uint32_t)input[1] << 1) |
			((uint32_t)input[2] >> 7);

	uint64_t mask = ((uint64_t)1 << 16) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 16;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_16bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 16 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 10) |
			((uint32_t)input[1] << 2) |
			((uint32_t)input[2] >> 6);

	uint64_t mask = ((uint64_t)1 << 16) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 16;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_16bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 16 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 11) |
			((uint32_t)input[1] << 3) |
			((uint32_t)input[2] >> 5);

	uint64_t mask = ((uint64_t)1 << 16) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 16;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_16bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 16 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 12) |
			((uint32_t)input[1] << 4) |
			((uint32_t)input[2] >> 4);

	uint64_t mask = ((uint64_t)1 << 16) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 16;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_16bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 16 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 13) |
			((uint32_t)input[1] << 5) |
			((uint32_t)input[2] >> 3);

	uint64_t mask = ((uint64_t)1 << 16) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 16;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_16bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 16 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 14) |
			((uint32_t)input[1] << 6) |
			((uint32_t)input[2] >> 2);

	uint64_t mask = ((uint64_t)1 << 16) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 16;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_16bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 16 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 15) |
			((uint32_t)input[1] << 7) |
			((uint32_t)input[2] >> 1);

	uint64_t mask = ((uint64_t)1 << 16) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 16;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_17bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 17 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 9) |
			((uint32_t)input[1] << 1) |
			((uint32_t)input[2] >> 7);

	uint64_t mask = ((uint64_t)1 << 17) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 17;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_17bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 17 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 10) |
			((uint32_t)input[1] << 2) |
			((uint32_t)input[2] >> 6);

	uint64_t mask = ((uint64_t)1 << 17) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 17;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_17bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 17 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 11) |
			((uint32_t)input[1] << 3) |
			((uint32_t)input[2] >> 5);

	uint64_t mask = ((uint64_t)1 << 17) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 17;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_17bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 17 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 12) |
			((uint32_t)input[1] << 4) |
			((uint32_t)input[2] >> 4);

	uint64_t mask = ((uint64_t)1 << 17) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 17;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_17bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 17 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 13) |
			((uint32_t)input[1] << 5) |
			((uint32_t)input[2] >> 3);

	uint64_t mask = ((uint64_t)1 << 17) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 17;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_17bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 17 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 14) |
			((uint32_t)input[1] << 6) |
			((uint32_t)input[2] >> 2);

	uint64_t mask = ((uint64_t)1 << 17) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 17;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_17bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 17 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 15) |
			((uint32_t)input[1] << 7) |
			((uint32_t)input[2] >> 1);

	uint64_t mask = ((uint64_t)1 << 17) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 17;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_17bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 17 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 16) |
			((uint32_t)input[1] << 8) |
			((uint32_t)input[2]);

	uint64_t mask = ((uint64_t)1 << 17) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 17;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_18bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 18 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 10) |
			((uint32_t)input[1] << 2) |
			((uint32_t)input[2] >> 6);

	uint64_t mask = ((uint64_t)1 << 18) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 18;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_18bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 18 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 11) |
			((uint32_t)input[1] << 3) |
			((uint32_t)input[2] >> 5);

	uint64_t mask = ((uint64_t)1 << 18) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 18;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_18bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 18 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 12) |
			((uint32_t)input[1] << 4) |
			((uint32_t)input[2] >> 4);

	uint64_t mask = ((uint64_t)1 << 18) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 18;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_18bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 18 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 13) |
			((uint32_t)input[1] << 5) |
			((uint32_t)input[2] >> 3);

	uint64_t mask = ((uint64_t)1 << 18) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 18;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_18bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 18 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 14) |
			((uint32_t)input[1] << 6) |
			((uint32_t)input[2] >> 2);

	uint64_t mask = ((uint64_t)1 << 18) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 18;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_18bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 18 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 15) |
			((uint32_t)input[1] << 7) |
			((uint32_t)input[2] >> 1);

	uint64_t mask = ((uint64_t)1 << 18) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 18;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_18bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 18 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 16) |
			((uint32_t)input[1] << 8) |
			((uint32_t)input[2]);

	uint64_t mask = ((uint64_t)1 << 18) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 18;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_18bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 18 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 17) |
			((uint32_t)input[1] << 9) |
			((uint32_t)input[2] << 1) |
			((uint32_t)input[3] >> 7);

	uint64_t mask = ((uint64_t)1 << 18) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 18;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_19bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 19 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 11) |
			((uint32_t)input[1] << 3) |
			((uint32_t)input[2] >> 5);

	uint64_t mask = ((uint64_t)1 << 19) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 19;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_19bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 19 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 12) |
			((uint32_t)input[1] << 4) |
			((uint32_t)input[2] >> 4);

	uint64_t mask = ((uint64_t)1 << 19) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 19;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_19bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 19 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 13) |
			((uint32_t)input[1] << 5) |
			((uint32_t)input[2] >> 3);

	uint64_t mask = ((uint64_t)1 << 19) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 19;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_19bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 19 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 14) |
			((uint32_t)input[1] << 6) |
			((uint32_t)input[2] >> 2);

	uint64_t mask = ((uint64_t)1 << 19) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 19;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_19bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 19 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 15) |
			((uint32_t)input[1] << 7) |
			((uint32_t)input[2] >> 1);

	uint64_t mask = ((uint64_t)1 << 19) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 19;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_19bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 19 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 16) |
			((uint32_t)input[1] << 8) |
			((uint32_t)input[2]);

	uint64_t mask = ((uint64_t)1 << 19) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 19;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_19bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 19 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 17) |
			((uint32_t)input[1] << 9) |
			((uint32_t)input[2] << 1) |
			((uint32_t)input[3] >> 7);

	uint64_t mask = ((uint64_t)1 << 19) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 19;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_19bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 19 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 18) |
			((uint32_t)input[1] << 10) |
			((uint32_t)input[2] << 2) |
			((uint32_t)input[3] >> 6);

	uint64_t mask = ((uint64_t)1 << 19) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 19;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_20bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 20 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 12) |
			((uint32_t)input[1] << 4) |
			((uint32_t)input[2] >> 4);

	uint64_t mask = ((uint64_t)1 << 20) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 20;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_20bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 20 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 13) |
			((uint32_t)input[1] << 5) |
			((uint32_t)input[2] >> 3);

	uint64_t mask = ((uint64_t)1 << 20) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 20;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_20bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 20 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 14) |
			((uint32_t)input[1] << 6) |
			((uint32_t)input[2] >> 2);

	uint64_t mask = ((uint64_t)1 << 20) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 20;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_20bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 20 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 15) |
			((uint32_t)input[1] << 7) |
			((uint32_t)input[2] >> 1);

	uint64_t mask = ((uint64_t)1 << 20) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 20;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_20bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 20 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 16) |
			((uint32_t)input[1] << 8) |
			((uint32_t)input[2]);

	uint64_t mask = ((uint64_t)1 << 20) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 20;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_20bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 20 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 17) |
			((uint32_t)input[1] << 9) |
			((uint32_t)input[2] << 1) |
			((uint32_t)input[3] >> 7);

	uint64_t mask = ((uint64_t)1 << 20) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 20;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_20bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 20 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 18) |
			((uint32_t)input[1] << 10) |
			((uint32_t)input[2] << 2) |
			((uint32_t)input[3] >> 6);

	uint64_t mask = ((uint64_t)1 << 20) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 20;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_20bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 20 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 19) |
			((uint32_t)input[1] << 11) |
			((uint32_t)input[2] << 3) |
			((uint32_t)input[3] >> 5);

	uint64_t mask = ((uint64_t)1 << 20) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 20;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_21bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 21 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 13) |
			((uint32_t)input[1] << 5) |
			((uint32_t)input[2] >> 3);

	uint64_t mask = ((uint64_t)1 << 21) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 21;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_21bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 21 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 14) |
			((uint32_t)input[1] << 6) |
			((uint32_t)input[2] >> 2);

	uint64_t mask = ((uint64_t)1 << 21) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 21;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_21bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 21 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 15) |
			((uint32_t)input[1] << 7) |
			((uint32_t)input[2] >> 1);

	uint64_t mask = ((uint64_t)1 << 21) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 21;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_21bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 21 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 16) |
			((uint32_t)input[1] << 8) |
			((uint32_t)input[2]);

	uint64_t mask = ((uint64_t)1 << 21) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 21;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_21bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 21 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 17) |
			((uint32_t)input[1] << 9) |
			((uint32_t)input[2] << 1) |
			((uint32_t)input[3] >> 7);

	uint64_t mask = ((uint64_t)1 << 21) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 21;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_21bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 21 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 18) |
			((uint32_t)input[1] << 10) |
			((uint32_t)input[2] << 2) |
			((uint32_t)input[3] >> 6);

	uint64_t mask = ((uint64_t)1 << 21) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 21;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_21bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 21 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 19) |
			((uint32_t)input[1] << 11) |
			((uint32_t)input[2] << 3) |
			((uint32_t)input[3] >> 5);

	uint64_t mask = ((uint64_t)1 << 21) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 21;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_21bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 21 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 20) |
			((uint32_t)input[1] << 12) |
			((uint32_t)input[2] << 4) |
			((uint32_t)input[3] >> 4);

	uint64_t mask = ((uint64_t)1 << 21) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 21;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_22bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 22 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 14) |
			((uint32_t)input[1] << 6) |
			((uint32_t)input[2] >> 2);

	uint64_t mask = ((uint64_t)1 << 22) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 22;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_22bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 22 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 15) |
			((uint32_t)input[1] << 7) |
			((uint32_t)input[2] >> 1);

	uint64_t mask = ((uint64_t)1 << 22) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 22;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_22bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 22 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 16) |
			((uint32_t)input[1] << 8) |
			((uint32_t)input[2]);

	uint64_t mask = ((uint64_t)1 << 22) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 22;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_22bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 22 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 17) |
			((uint32_t)input[1] << 9) |
			((uint32_t)input[2] << 1) |
			((uint32_t)input[3] >> 7);

	uint64_t mask = ((uint64_t)1 << 22) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 22;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_22bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 22 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 18) |
			((uint32_t)input[1] << 10) |
			((uint32_t)input[2] << 2) |
			((uint32_t)input[3] >> 6);

	uint64_t mask = ((uint64_t)1 << 22) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 22;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_22bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 22 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 19) |
			((uint32_t)input[1] << 11) |
			((uint32_t)input[2] << 3) |
			((uint32_t)input[3] >> 5);

	uint64_t mask = ((uint64_t)1 << 22) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 22;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_22bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 22 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 20) |
			((uint32_t)input[1] << 12) |
			((uint32_t)input[2] << 4) |
			((uint32_t)input[3] >> 4);

	uint64_t mask = ((uint64_t)1 << 22) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 22;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_22bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 22 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 21) |
			((uint32_t)input[1] << 13) |
			((uint32_t)input[2] << 5) |
			((uint32_t)input[3] >> 3);

	uint64_t mask = ((uint64_t)1 << 22) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 22;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_23bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 23 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 15) |
			((uint32_t)input[1] << 7) |
			((uint32_t)input[2] >> 1);

	uint64_t mask = ((uint64_t)1 << 23) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 23;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_23bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 23 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 16) |
			((uint32_t)input[1] << 8) |
			((uint32_t)input[2]);

	uint64_t mask = ((uint64_t)1 << 23) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 23;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_23bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 23 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 17) |
			((uint32_t)input[1] << 9) |
			((uint32_t)input[2] << 1) |
			((uint32_t)input[3] >> 7);

	uint64_t mask = ((uint64_t)1 << 23) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 23;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_23bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 23 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 18) |
			((uint32_t)input[1] << 10) |
			((uint32_t)input[2] << 2) |
			((uint32_t)input[3] >> 6);

	uint64_t mask = ((uint64_t)1 << 23) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 23;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_23bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 23 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 19) |
			((uint32_t)input[1] << 11) |
			((uint32_t)input[2] << 3) |
			((uint32_t)input[3] >> 5);

	uint64_t mask = ((uint64_t)1 << 23) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 23;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_23bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 23 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 20) |
			((uint32_t)input[1] << 12) |
			((uint32_t)input[2] << 4) |
			((uint32_t)input[3] >> 4);

	uint64_t mask = ((uint64_t)1 << 23) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 23;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_23bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 23 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 21) |
			((uint32_t)input[1] << 13) |
			((uint32_t)input[2] << 5) |
			((uint32_t)input[3] >> 3);

	uint64_t mask = ((uint64_t)1 << 23) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 23;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_23bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 23 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 22) |
			((uint32_t)input[1] << 14) |
			((uint32_t)input[2] << 6) |
			((uint32_t)input[3] >> 2);

	uint64_t mask = ((uint64_t)1 << 23) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 23;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_24bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 24 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 16) |
			((uint32_t)input[1] << 8) |
			((uint32_t)input[2]);

	uint64_t mask = ((uint64_t)1 << 24) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 24;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_24bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 24 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 17) |
			((uint32_t)input[1] << 9) |
			((uint32_t)input[2] << 1) |
			((uint32_t)input[3] >> 7);

	uint64_t mask = ((uint64_t)1 << 24) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 24;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_24bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 24 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 18) |
			((uint32_t)input[1] << 10) |
			((uint32_t)input[2] << 2) |
			((uint32_t)input[3] >> 6);

	uint64_t mask = ((uint64_t)1 << 24) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 24;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_24bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 24 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 19) |
			((uint32_t)input[1] << 11) |
			((uint32_t)input[2] << 3) |
			((uint32_t)input[3] >> 5);

	uint64_t mask = ((uint64_t)1 << 24) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 24;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_24bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 24 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 20) |
			((uint32_t)input[1] << 12) |
			((uint32_t)input[2] << 4) |
			((uint32_t)input[3] >> 4);

	uint64_t mask = ((uint64_t)1 << 24) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 24;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_24bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 24 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 21) |
			((uint32_t)input[1] << 13) |
			((uint32_t)input[2] << 5) |
			((uint32_t)input[3] >> 3);

	uint64_t mask = ((uint64_t)1 << 24) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 24;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_24bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 24 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 22) |
			((uint32_t)input[1] << 14) |
			((uint32_t)input[2] << 6) |
			((uint32_t)input[3] >> 2);

	uint64_t mask = ((uint64_t)1 << 24) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 24;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_24bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 24 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 23) |
			((uint32_t)input[1] << 15) |
			((uint32_t)input[2] << 7) |
			((uint32_t)input[3] >> 1);

	uint64_t mask = ((uint64_t)1 << 24) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 24;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_25bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 25 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 17) |
			((uint32_t)input[1] << 9) |
			((uint32_t)input[2] << 1) |
			((uint32_t)input[3] >> 7);

	uint64_t mask = ((uint64_t)1 << 25) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 25;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_25bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 25 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 18) |
			((uint32_t)input[1] << 10) |
			((uint32_t)input[2] << 2) |
			((uint32_t)input[3] >> 6);

	uint64_t mask = ((uint64_t)1 << 25) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 25;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_25bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 25 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 19) |
			((uint32_t)input[1] << 11) |
			((uint32_t)input[2] << 3) |
			((uint32_t)input[3] >> 5);

	uint64_t mask = ((uint64_t)1 << 25) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 25;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_25bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 25 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 20) |
			((uint32_t)input[1] << 12) |
			((uint32_t)input[2] << 4) |
			((uint32_t)input[3] >> 4);

	uint64_t mask = ((uint64_t)1 << 25) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 25;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_25bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 25 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 21) |
			((uint32_t)input[1] << 13) |
			((uint32_t)input[2] << 5) |
			((uint32_t)input[3] >> 3);

	uint64_t mask = ((uint64_t)1 << 25) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 25;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_25bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 25 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 22) |
			((uint32_t)input[1] << 14) |
			((uint32_t)input[2] << 6) |
			((uint32_t)input[3] >> 2);

	uint64_t mask = ((uint64_t)1 << 25) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 25;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_25bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 25 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 23) |
			((uint32_t)input[1] << 15) |
			((uint32_t)input[2] << 7) |
			((uint32_t)input[3] >> 1);

	uint64_t mask = ((uint64_t)1 << 25) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 25;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_25bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 25 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);

	uint64_t mask = ((uint64_t)1 << 25) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 25;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_26bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 26 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 18) |
			((uint32_t)input[1] << 10) |
			((uint32_t)input[2] << 2) |
			((uint32_t)input[3] >> 6);

	uint64_t mask = ((uint64_t)1 << 26) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 26;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_26bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 26 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 19) |
			((uint32_t)input[1] << 11) |
			((uint32_t)input[2] << 3) |
			((uint32_t)input[3] >> 5);

	uint64_t mask = ((uint64_t)1 << 26) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 26;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_26bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 26 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 20) |
			((uint32_t)input[1] << 12) |
			((uint32_t)input[2] << 4) |
			((uint32_t)input[3] >> 4);

	uint64_t mask = ((uint64_t)1 << 26) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 26;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_26bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 26 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 21) |
			((uint32_t)input[1] << 13) |
			((uint32_t)input[2] << 5) |
			((uint32_t)input[3] >> 3);

	uint64_t mask = ((uint64_t)1 << 26) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 26;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_26bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 26 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 22) |
			((uint32_t)input[1] << 14) |
			((uint32_t)input[2] << 6) |
			((uint32_t)input[3] >> 2);

	uint64_t mask = ((uint64_t)1 << 26) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 26;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_26bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 26 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 23) |
			((uint32_t)input[1] << 15) |
			((uint32_t)input[2] << 7) |
			((uint32_t)input[3] >> 1);

	uint64_t mask = ((uint64_t)1 << 26) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 26;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_26bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 26 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);

	uint64_t mask = ((uint64_t)1 << 26) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 26;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_26bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 26 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)input[4] >> 7);

	uint64_t mask = ((uint64_t)1 << 26) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 26;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_27bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 27 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 19) |
			((uint32_t)input[1] << 11) |
			((uint32_t)input[2] << 3) |
			((uint32_t)input[3] >> 5);

	uint64_t mask = ((uint64_t)1 << 27) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 27;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_27bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 27 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 20) |
			((uint32_t)input[1] << 12) |
			((uint32_t)input[2] << 4) |
			((uint32_t)input[3] >> 4);

	uint64_t mask = ((uint64_t)1 << 27) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 27;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_27bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 27 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 21) |
			((uint32_t)input[1] << 13) |
			((uint32_t)input[2] << 5) |
			((uint32_t)input[3] >> 3);

	uint64_t mask = ((uint64_t)1 << 27) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 27;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_27bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 27 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 22) |
			((uint32_t)input[1] << 14) |
			((uint32_t)input[2] << 6) |
			((uint32_t)input[3] >> 2);

	uint64_t mask = ((uint64_t)1 << 27) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 27;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_27bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 27 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 23) |
			((uint32_t)input[1] << 15) |
			((uint32_t)input[2] << 7) |
			((uint32_t)input[3] >> 1);

	uint64_t mask = ((uint64_t)1 << 27) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 27;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_27bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 27 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);

	uint64_t mask = ((uint64_t)1 << 27) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 27;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_27bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 27 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)input[4] >> 7);

	uint64_t mask = ((uint64_t)1 << 27) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 27;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_27bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 27 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)input[4] >> 6);

	uint64_t mask = ((uint64_t)1 << 27) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 27;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_28bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 28 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 20) |
			((uint32_t)input[1] << 12) |
			((uint32_t)input[2] << 4) |
			((uint32_t)input[3] >> 4);

	uint64_t mask = ((uint64_t)1 << 28) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 28;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_28bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 28 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 21) |
			((uint32_t)input[1] << 13) |
			((uint32_t)input[2] << 5) |
			((uint32_t)input[3] >> 3);

	uint64_t mask = ((uint64_t)1 << 28) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 28;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_28bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 28 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 22) |
			((uint32_t)input[1] << 14) |
			((uint32_t)input[2] << 6) |
			((uint32_t)input[3] >> 2);

	uint64_t mask = ((uint64_t)1 << 28) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 28;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_28bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 28 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 23) |
			((uint32_t)input[1] << 15) |
			((uint32_t)input[2] << 7) |
			((uint32_t)input[3] >> 1);

	uint64_t mask = ((uint64_t)1 << 28) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 28;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_28bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 28 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);

	uint64_t mask = ((uint64_t)1 << 28) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 28;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_28bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 28 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)input[4] >> 7);

	uint64_t mask = ((uint64_t)1 << 28) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 28;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_28bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 28 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)input[4] >> 6);

	uint64_t mask = ((uint64_t)1 << 28) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 28;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_28bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 28 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)input[4] >> 5);

	uint64_t mask = ((uint64_t)1 << 28) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 28;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_29bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 29 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 21) |
			((uint32_t)input[1] << 13) |
			((uint32_t)input[2] << 5) |
			((uint32_t)input[3] >> 3);

	uint64_t mask = ((uint64_t)1 << 29) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 29;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_29bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 29 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 22) |
			((uint32_t)input[1] << 14) |
			((uint32_t)input[2] << 6) |
			((uint32_t)input[3] >> 2);

	uint64_t mask = ((uint64_t)1 << 29) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 29;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_29bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 29 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 23) |
			((uint32_t)input[1] << 15) |
			((uint32_t)input[2] << 7) |
			((uint32_t)input[3] >> 1);

	uint64_t mask = ((uint64_t)1 << 29) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 29;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_29bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 29 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);

	uint64_t mask = ((uint64_t)1 << 29) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 29;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_29bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 29 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)input[4] >> 7);

	uint64_t mask = ((uint64_t)1 << 29) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 29;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_29bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 29 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)input[4] >> 6);

	uint64_t mask = ((uint64_t)1 << 29) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 29;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_29bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 29 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)input[4] >> 5);

	uint64_t mask = ((uint64_t)1 << 29) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 29;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_29bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 29 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)input[4] >> 4);

	uint64_t mask = ((uint64_t)1 << 29) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 29;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_30bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 30 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 22) |
			((uint32_t)input[1] << 14) |
			((uint32_t)input[2] << 6) |
			((uint32_t)input[3] >> 2);

	uint64_t mask = ((uint64_t)1 << 30) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 30;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_30bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 30 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 23) |
			((uint32_t)input[1] << 15) |
			((uint32_t)input[2] << 7) |
			((uint32_t)input[3] >> 1);

	uint64_t mask = ((uint64_t)1 << 30) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 30;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_30bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 30 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);

	uint64_t mask = ((uint64_t)1 << 30) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 30;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_30bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 30 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)input[4] >> 7);

	uint64_t mask = ((uint64_t)1 << 30) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 30;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_30bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 30 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)input[4] >> 6);

	uint64_t mask = ((uint64_t)1 << 30) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 30;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_30bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 30 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)input[4] >> 5);

	uint64_t mask = ((uint64_t)1 << 30) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 30;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_30bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 30 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)input[4] >> 4);

	uint64_t mask = ((uint64_t)1 << 30) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 30;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_30bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 30 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)input[4] >> 3);

	uint64_t mask = ((uint64_t)1 << 30) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 30;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_31bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 31 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 23) |
			((uint32_t)input[1] << 15) |
			((uint32_t)input[2] << 7) |
			((uint32_t)input[3] >> 1);

	uint64_t mask = ((uint64_t)1 << 31) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 31;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_31bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 31 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);

	uint64_t mask = ((uint64_t)1 << 31) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 31;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_31bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 31 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)input[4] >> 7);

	uint64_t mask = ((uint64_t)1 << 31) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 31;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_31bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 31 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)input[4] >> 6);

	uint64_t mask = ((uint64_t)1 << 31) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 31;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_31bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 31 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)input[4] >> 5);

	uint64_t mask = ((uint64_t)1 << 31) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 31;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_31bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 31 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)input[4] >> 4);

	uint64_t mask = ((uint64_t)1 << 31) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 31;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_31bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 31 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)input[4] >> 3);

	uint64_t mask = ((uint64_t)1 << 31) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 31;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_31bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 31 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)input[4] >> 2);

	uint64_t mask = ((uint64_t)1 << 31) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 31;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_32bit_counter_0off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 0 bit, read 32 bits of data

	uint64_t new_counter = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)input[2] << 8) |
			((uint32_t)input[3]);

	uint64_t mask = ((uint64_t)1 << 32) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 32;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_32bit_counter_1off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 1 bit, read 32 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)input[2] << 9) |
			((uint32_t)input[3] << 1) |
			((uint32_t)input[4] >> 7);

	uint64_t mask = ((uint64_t)1 << 32) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 32;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_32bit_counter_2off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 2 bit, read 32 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10) |
			((uint32_t)input[3] << 2) |
			((uint32_t)input[4] >> 6);

	uint64_t mask = ((uint64_t)1 << 32) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 32;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_32bit_counter_3off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 3 bit, read 32 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)input[3] << 3) |
			((uint32_t)input[4] >> 5);

	uint64_t mask = ((uint64_t)1 << 32) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 32;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_32bit_counter_4off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 4 bit, read 32 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)input[3] << 4) |
			((uint32_t)input[4] >> 4);

	uint64_t mask = ((uint64_t)1 << 32) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 32;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_32bit_counter_5off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 5 bit, read 32 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)input[3] << 5) |
			((uint32_t)input[4] >> 3);

	uint64_t mask = ((uint64_t)1 << 32) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 32;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_32bit_counter_6off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 6 bit, read 32 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)input[3] << 6) |
			((uint32_t)input[4] >> 2);

	uint64_t mask = ((uint64_t)1 << 32) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 32;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}

static uint64_t unwrap_32bit_counter_7off(const uint8_t * input, uint64_t last) {
	// Unpack a single value
	// Skip 7 bit, read 32 bits of data

	uint64_t new_counter = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)input[3] << 7) |
			((uint32_t)input[4] >> 1);

	uint64_t mask = ((uint64_t)1 << 32) - 1;

	// do the unwrapping
	if (new_counter <= (last & mask)) {
		// set the "carry" bit
		new_counter |= (uint64_t)1 << 32;
	}

	// add higher bits
	new_counter += last & (~mask);

	return new_counter;
}


unwrap_func_t unwrap[UNWRAP_MAX_COUNT - UNWRAP_MIN_COUNT + 1][8] = {
	{
		unwrap_8bit_counter_0off,
		unwrap_8bit_counter_1off,
		unwrap_8bit_counter_2off,
		unwrap_8bit_counter_3off,
		unwrap_8bit_counter_4off,
		unwrap_8bit_counter_5off,
		unwrap_8bit_counter_6off,
		unwrap_8bit_counter_7off,
	},
	{
		unwrap_9bit_counter_0off,
		unwrap_9bit_counter_1off,
		unwrap_9bit_counter_2off,
		unwrap_9bit_counter_3off,
		unwrap_9bit_counter_4off,
		unwrap_9bit_counter_5off,
		unwrap_9bit_counter_6off,
		unwrap_9bit_counter_7off,
	},
	{
		unwrap_10bit_counter_0off,
		unwrap_10bit_counter_1off,
		unwrap_10bit_counter_2off,
		unwrap_10bit_counter_3off,
		unwrap_10bit_counter_4off,
		unwrap_10bit_counter_5off,
		unwrap_10bit_counter_6off,
		unwrap_10bit_counter_7off,
	},
	{
		unwrap_11bit_counter_0off,
		unwrap_11bit_counter_1off,
		unwrap_11bit_counter_2off,
		unwrap_11bit_counter_3off,
		unwrap_11bit_counter_4off,
		unwrap_11bit_counter_5off,
		unwrap_11bit_counter_6off,
		unwrap_11bit_counter_7off,
	},
	{
		unwrap_12bit_counter_0off,
		unwrap_12bit_counter_1off,
		unwrap_12bit_counter_2off,
		unwrap_12bit_counter_3off,
		unwrap_12bit_counter_4off,
		unwrap_12bit_counter_5off,
		unwrap_12bit_counter_6off,
		unwrap_12bit_counter_7off,
	},
	{
		unwrap_13bit_counter_0off,
		unwrap_13bit_counter_1off,
		unwrap_13bit_counter_2off,
		unwrap_13bit_counter_3off,
		unwrap_13bit_counter_4off,
		unwrap_13bit_counter_5off,
		unwrap_13bit_counter_6off,
		unwrap_13bit_counter_7off,
	},
	{
		unwrap_14bit_counter_0off,
		unwrap_14bit_counter_1off,
		unwrap_14bit_counter_2off,
		unwrap_14bit_counter_3off,
		unwrap_14bit_counter_4off,
		unwrap_14bit_counter_5off,
		unwrap_14bit_counter_6off,
		unwrap_14bit_counter_7off,
	},
	{
		unwrap_15bit_counter_0off,
		unwrap_15bit_counter_1off,
		unwrap_15bit_counter_2off,
		unwrap_15bit_counter_3off,
		unwrap_15bit_counter_4off,
		unwrap_15bit_counter_5off,
		unwrap_15bit_counter_6off,
		unwrap_15bit_counter_7off,
	},
	{
		unwrap_16bit_counter_0off,
		unwrap_16bit_counter_1off,
		unwrap_16bit_counter_2off,
		unwrap_16bit_counter_3off,
		unwrap_16bit_counter_4off,
		unwrap_16bit_counter_5off,
		unwrap_16bit_counter_6off,
		unwrap_16bit_counter_7off,
	},
	{
		unwrap_17bit_counter_0off,
		unwrap_17bit_counter_1off,
		unwrap_17bit_counter_2off,
		unwrap_17bit_counter_3off,
		unwrap_17bit_counter_4off,
		unwrap_17bit_counter_5off,
		unwrap_17bit_counter_6off,
		unwrap_17bit_counter_7off,
	},
	{
		unwrap_18bit_counter_0off,
		unwrap_18bit_counter_1off,
		unwrap_18bit_counter_2off,
		unwrap_18bit_counter_3off,
		unwrap_18bit_counter_4off,
		unwrap_18bit_counter_5off,
		unwrap_18bit_counter_6off,
		unwrap_18bit_counter_7off,
	},
	{
		unwrap_19bit_counter_0off,
		unwrap_19bit_counter_1off,
		unwrap_19bit_counter_2off,
		unwrap_19bit_counter_3off,
		unwrap_19bit_counter_4off,
		unwrap_19bit_counter_5off,
		unwrap_19bit_counter_6off,
		unwrap_19bit_counter_7off,
	},
	{
		unwrap_20bit_counter_0off,
		unwrap_20bit_counter_1off,
		unwrap_20bit_counter_2off,
		unwrap_20bit_counter_3off,
		unwrap_20bit_counter_4off,
		unwrap_20bit_counter_5off,
		unwrap_20bit_counter_6off,
		unwrap_20bit_counter_7off,
	},
	{
		unwrap_21bit_counter_0off,
		unwrap_21bit_counter_1off,
		unwrap_21bit_counter_2off,
		unwrap_21bit_counter_3off,
		unwrap_21bit_counter_4off,
		unwrap_21bit_counter_5off,
		unwrap_21bit_counter_6off,
		unwrap_21bit_counter_7off,
	},
	{
		unwrap_22bit_counter_0off,
		unwrap_22bit_counter_1off,
		unwrap_22bit_counter_2off,
		unwrap_22bit_counter_3off,
		unwrap_22bit_counter_4off,
		unwrap_22bit_counter_5off,
		unwrap_22bit_counter_6off,
		unwrap_22bit_counter_7off,
	},
	{
		unwrap_23bit_counter_0off,
		unwrap_23bit_counter_1off,
		unwrap_23bit_counter_2off,
		unwrap_23bit_counter_3off,
		unwrap_23bit_counter_4off,
		unwrap_23bit_counter_5off,
		unwrap_23bit_counter_6off,
		unwrap_23bit_counter_7off,
	},
	{
		unwrap_24bit_counter_0off,
		unwrap_24bit_counter_1off,
		unwrap_24bit_counter_2off,
		unwrap_24bit_counter_3off,
		unwrap_24bit_counter_4off,
		unwrap_24bit_counter_5off,
		unwrap_24bit_counter_6off,
		unwrap_24bit_counter_7off,
	},
	{
		unwrap_25bit_counter_0off,
		unwrap_25bit_counter_1off,
		unwrap_25bit_counter_2off,
		unwrap_25bit_counter_3off,
		unwrap_25bit_counter_4off,
		unwrap_25bit_counter_5off,
		unwrap_25bit_counter_6off,
		unwrap_25bit_counter_7off,
	},
	{
		unwrap_26bit_counter_0off,
		unwrap_26bit_counter_1off,
		unwrap_26bit_counter_2off,
		unwrap_26bit_counter_3off,
		unwrap_26bit_counter_4off,
		unwrap_26bit_counter_5off,
		unwrap_26bit_counter_6off,
		unwrap_26bit_counter_7off,
	},
	{
		unwrap_27bit_counter_0off,
		unwrap_27bit_counter_1off,
		unwrap_27bit_counter_2off,
		unwrap_27bit_counter_3off,
		unwrap_27bit_counter_4off,
		unwrap_27bit_counter_5off,
		unwrap_27bit_counter_6off,
		unwrap_27bit_counter_7off,
	},
	{
		unwrap_28bit_counter_0off,
		unwrap_28bit_counter_1off,
		unwrap_28bit_counter_2off,
		unwrap_28bit_counter_3off,
		unwrap_28bit_counter_4off,
		unwrap_28bit_counter_5off,
		unwrap_28bit_counter_6off,
		unwrap_28bit_counter_7off,
	},
	{
		unwrap_29bit_counter_0off,
		unwrap_29bit_counter_1off,
		unwrap_29bit_counter_2off,
		unwrap_29bit_counter_3off,
		unwrap_29bit_counter_4off,
		unwrap_29bit_counter_5off,
		unwrap_29bit_counter_6off,
		unwrap_29bit_counter_7off,
	},
	{
		unwrap_30bit_counter_0off,
		unwrap_30bit_counter_1off,
		unwrap_30bit_counter_2off,
		unwrap_30bit_counter_3off,
		unwrap_30bit_counter_4off,
		unwrap_30bit_counter_5off,
		unwrap_30bit_counter_6off,
		unwrap_30bit_counter_7off,
	},
	{
		unwrap_31bit_counter_0off,
		unwrap_31bit_counter_1off,
		unwrap_31bit_counter_2off,
		unwrap_31bit_counter_3off,
		unwrap_31bit_counter_4off,
		unwrap_31bit_counter_5off,
		unwrap_31bit_counter_6off,
		unwrap_31bit_counter_7off,
	},
	{
		unwrap_32bit_counter_0off,
		unwrap_32bit_counter_1off,
		unwrap_32bit_counter_2off,
		unwrap_32bit_counter_3off,
		unwrap_32bit_counter_4off,
		unwrap_32bit_counter_5off,
		unwrap_32bit_counter_6off,
		unwrap_32bit_counter_7off,
	},
};
