# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'CertificateManaged',
    'CertificateSelfManaged',
    'DnsAuthorizationDnsResourceRecord',
]

@pulumi.output_type
class CertificateManaged(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsAuthorizations":
            suggest = "dns_authorizations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateManaged. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateManaged.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateManaged.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_authorizations: Optional[Sequence[str]] = None,
                 domains: Optional[Sequence[str]] = None,
                 state: Optional[str] = None):
        """
        :param Sequence[str] dns_authorizations: Authorizations that will be used for performing domain authorization
        :param Sequence[str] domains: The domains for which a managed SSL certificate will be generated.
               Wildcard domains are only supported with DNS challenge resolution
        :param str state: -
               State of the managed certificate resource.
        """
        if dns_authorizations is not None:
            pulumi.set(__self__, "dns_authorizations", dns_authorizations)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="dnsAuthorizations")
    def dns_authorizations(self) -> Optional[Sequence[str]]:
        """
        Authorizations that will be used for performing domain authorization
        """
        return pulumi.get(self, "dns_authorizations")

    @property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[str]]:
        """
        The domains for which a managed SSL certificate will be generated.
        Wildcard domains are only supported with DNS challenge resolution
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        -
        State of the managed certificate resource.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class CertificateSelfManaged(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificatePem":
            suggest = "certificate_pem"
        elif key == "privateKeyPem":
            suggest = "private_key_pem"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateSelfManaged. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateSelfManaged.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateSelfManaged.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_pem: str,
                 private_key_pem: str):
        """
        :param str certificate_pem: The certificate chain in PEM-encoded form.
               Leaf certificate comes first, followed by intermediate ones if any.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str private_key_pem: The private key of the leaf certificate in PEM-encoded form.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        pulumi.set(__self__, "certificate_pem", certificate_pem)
        pulumi.set(__self__, "private_key_pem", private_key_pem)

    @property
    @pulumi.getter(name="certificatePem")
    def certificate_pem(self) -> str:
        """
        The certificate chain in PEM-encoded form.
        Leaf certificate comes first, followed by intermediate ones if any.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "certificate_pem")

    @property
    @pulumi.getter(name="privateKeyPem")
    def private_key_pem(self) -> str:
        """
        The private key of the leaf certificate in PEM-encoded form.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "private_key_pem")


@pulumi.output_type
class DnsAuthorizationDnsResourceRecord(dict):
    def __init__(__self__, *,
                 data: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


