# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceTemplateArgs', 'InstanceTemplate']

@pulumi.input_type
class InstanceTemplateArgs:
    def __init__(__self__, *,
                 disks: pulumi.Input[Sequence[pulumi.Input['InstanceTemplateDiskArgs']]],
                 machine_type: pulumi.Input[str],
                 advanced_machine_features: Optional[pulumi.Input['InstanceTemplateAdvancedMachineFeaturesArgs']] = None,
                 can_ip_forward: Optional[pulumi.Input[bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input['InstanceTemplateConfidentialInstanceConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_display: Optional[pulumi.Input[bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateGuestAcceleratorArgs']]]] = None,
                 instance_description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 metadata_startup_script: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateNetworkInterfaceArgs']]]] = None,
                 network_performance_config: Optional[pulumi.Input['InstanceTemplateNetworkPerformanceConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reservation_affinity: Optional[pulumi.Input['InstanceTemplateReservationAffinityArgs']] = None,
                 scheduling: Optional[pulumi.Input['InstanceTemplateSchedulingArgs']] = None,
                 service_account: Optional[pulumi.Input['InstanceTemplateServiceAccountArgs']] = None,
                 shielded_instance_config: Optional[pulumi.Input['InstanceTemplateShieldedInstanceConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a InstanceTemplate resource.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTemplateDiskArgs']]] disks: Disks to attach to instances created from this template.
               This can be specified multiple times for multiple disks. Structure is
               documented below.
        :param pulumi.Input[str] machine_type: The machine type to create.
        :param pulumi.Input['InstanceTemplateAdvancedMachineFeaturesArgs'] advanced_machine_features: Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        :param pulumi.Input[bool] can_ip_forward: Whether to allow sending and receiving of
               packets with non-matching source or destination IPs. This defaults to false.
        :param pulumi.Input['InstanceTemplateConfidentialInstanceConfigArgs'] confidential_instance_config: Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        :param pulumi.Input[str] description: A brief description of this resource.
        :param pulumi.Input[bool] enable_display: ) Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
               **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTemplateGuestAcceleratorArgs']]] guest_accelerators: List of the type and count of accelerator cards attached to the instance. Structure documented below.
        :param pulumi.Input[str] instance_description: A brief description to use for instances
               created from this template.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of ket/value label pairs to assign to disk created from
               this template
        :param pulumi.Input[Mapping[str, Any]] metadata: Metadata key/value pairs to make available from
               within instances created from this template.
        :param pulumi.Input[str] metadata_startup_script: An alternative to using the
               startup-script metadata key, mostly to match the compute_instance resource.
               This replaces the startup-script metadata key on the created instance and
               thus the two mechanisms are not allowed to be used simultaneously.
        :param pulumi.Input[str] min_cpu_platform: Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
               `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        :param pulumi.Input[str] name: The name of the instance template. If you leave
               this blank, the provider will auto-generate a unique name.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTemplateNetworkInterfaceArgs']]] network_interfaces: Networks to attach to instances created from
               this template. This can be specified multiple times for multiple networks.
               Structure is documented below.
        :param pulumi.Input['InstanceTemplateNetworkPerformanceConfigArgs'] network_performance_config: Configures network performance settings for the instance created from the
               template. Structure is documented below. **Note**: `machine_type`
               must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
               the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
               in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
               in order for this setting to take effect.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] region: An instance template is a global resource that is not
               bound to a zone or a region. However, you can still specify some regional
               resources in an instance template, which restricts the template to the
               region where that resource resides. For example, a custom `subnetwork`
               resource is tied to a specific region. Defaults to the region of the
               Provider if no value is given.
        :param pulumi.Input['InstanceTemplateReservationAffinityArgs'] reservation_affinity: Specifies the reservations that this instance can consume from.
               Structure is documented below.
        :param pulumi.Input['InstanceTemplateSchedulingArgs'] scheduling: The scheduling strategy to use. More details about
               this configuration option are detailed below.
        :param pulumi.Input['InstanceTemplateServiceAccountArgs'] service_account: Service account to attach to the instance. Structure is documented below.
        :param pulumi.Input['InstanceTemplateShieldedInstanceConfigArgs'] shielded_instance_config: Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
               **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to attach to the instance.
        """
        pulumi.set(__self__, "disks", disks)
        pulumi.set(__self__, "machine_type", machine_type)
        if advanced_machine_features is not None:
            pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if confidential_instance_config is not None:
            pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_display is not None:
            pulumi.set(__self__, "enable_display", enable_display)
        if guest_accelerators is not None:
            pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        if instance_description is not None:
            pulumi.set(__self__, "instance_description", instance_description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_startup_script is not None:
            pulumi.set(__self__, "metadata_startup_script", metadata_startup_script)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if network_performance_config is not None:
            pulumi.set(__self__, "network_performance_config", network_performance_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def disks(self) -> pulumi.Input[Sequence[pulumi.Input['InstanceTemplateDiskArgs']]]:
        """
        Disks to attach to instances created from this template.
        This can be specified multiple times for multiple disks. Structure is
        documented below.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: pulumi.Input[Sequence[pulumi.Input['InstanceTemplateDiskArgs']]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Input[str]:
        """
        The machine type to create.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Optional[pulumi.Input['InstanceTemplateAdvancedMachineFeaturesArgs']]:
        """
        Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        """
        return pulumi.get(self, "advanced_machine_features")

    @advanced_machine_features.setter
    def advanced_machine_features(self, value: Optional[pulumi.Input['InstanceTemplateAdvancedMachineFeaturesArgs']]):
        pulumi.set(self, "advanced_machine_features", value)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow sending and receiving of
        packets with non-matching source or destination IPs. This defaults to false.
        """
        return pulumi.get(self, "can_ip_forward")

    @can_ip_forward.setter
    def can_ip_forward(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_ip_forward", value)

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> Optional[pulumi.Input['InstanceTemplateConfidentialInstanceConfigArgs']]:
        """
        Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        """
        return pulumi.get(self, "confidential_instance_config")

    @confidential_instance_config.setter
    def confidential_instance_config(self, value: Optional[pulumi.Input['InstanceTemplateConfidentialInstanceConfigArgs']]):
        pulumi.set(self, "confidential_instance_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A brief description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> Optional[pulumi.Input[bool]]:
        """
        ) Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
        **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        """
        return pulumi.get(self, "enable_display")

    @enable_display.setter
    def enable_display(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_display", value)

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateGuestAcceleratorArgs']]]]:
        """
        List of the type and count of accelerator cards attached to the instance. Structure documented below.
        """
        return pulumi.get(self, "guest_accelerators")

    @guest_accelerators.setter
    def guest_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateGuestAcceleratorArgs']]]]):
        pulumi.set(self, "guest_accelerators", value)

    @property
    @pulumi.getter(name="instanceDescription")
    def instance_description(self) -> Optional[pulumi.Input[str]]:
        """
        A brief description to use for instances
        created from this template.
        """
        return pulumi.get(self, "instance_description")

    @instance_description.setter
    def instance_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of ket/value label pairs to assign to disk created from
        this template
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Metadata key/value pairs to make available from
        within instances created from this template.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metadataStartupScript")
    def metadata_startup_script(self) -> Optional[pulumi.Input[str]]:
        """
        An alternative to using the
        startup-script metadata key, mostly to match the compute_instance resource.
        This replaces the startup-script metadata key on the created instance and
        thus the two mechanisms are not allowed to be used simultaneously.
        """
        return pulumi.get(self, "metadata_startup_script")

    @metadata_startup_script.setter
    def metadata_startup_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_startup_script", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
        `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance template. If you leave
        this blank, the provider will auto-generate a unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateNetworkInterfaceArgs']]]]:
        """
        Networks to attach to instances created from
        this template. This can be specified multiple times for multiple networks.
        Structure is documented below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> Optional[pulumi.Input['InstanceTemplateNetworkPerformanceConfigArgs']]:
        """
        Configures network performance settings for the instance created from the
        template. Structure is documented below. **Note**: `machine_type`
        must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
        the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
        in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
        in order for this setting to take effect.
        """
        return pulumi.get(self, "network_performance_config")

    @network_performance_config.setter
    def network_performance_config(self, value: Optional[pulumi.Input['InstanceTemplateNetworkPerformanceConfigArgs']]):
        pulumi.set(self, "network_performance_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        An instance template is a global resource that is not
        bound to a zone or a region. However, you can still specify some regional
        resources in an instance template, which restricts the template to the
        region where that resource resides. For example, a custom `subnetwork`
        resource is tied to a specific region. Defaults to the region of the
        Provider if no value is given.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional[pulumi.Input['InstanceTemplateReservationAffinityArgs']]:
        """
        Specifies the reservations that this instance can consume from.
        Structure is documented below.
        """
        return pulumi.get(self, "reservation_affinity")

    @reservation_affinity.setter
    def reservation_affinity(self, value: Optional[pulumi.Input['InstanceTemplateReservationAffinityArgs']]):
        pulumi.set(self, "reservation_affinity", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['InstanceTemplateSchedulingArgs']]:
        """
        The scheduling strategy to use. More details about
        this configuration option are detailed below.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['InstanceTemplateSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['InstanceTemplateServiceAccountArgs']]:
        """
        Service account to attach to the instance. Structure is documented below.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['InstanceTemplateServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['InstanceTemplateShieldedInstanceConfigArgs']]:
        """
        Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
        **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['InstanceTemplateShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to attach to the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _InstanceTemplateState:
    def __init__(__self__, *,
                 advanced_machine_features: Optional[pulumi.Input['InstanceTemplateAdvancedMachineFeaturesArgs']] = None,
                 can_ip_forward: Optional[pulumi.Input[bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input['InstanceTemplateConfidentialInstanceConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateDiskArgs']]]] = None,
                 enable_display: Optional[pulumi.Input[bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateGuestAcceleratorArgs']]]] = None,
                 instance_description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 metadata_fingerprint: Optional[pulumi.Input[str]] = None,
                 metadata_startup_script: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateNetworkInterfaceArgs']]]] = None,
                 network_performance_config: Optional[pulumi.Input['InstanceTemplateNetworkPerformanceConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reservation_affinity: Optional[pulumi.Input['InstanceTemplateReservationAffinityArgs']] = None,
                 scheduling: Optional[pulumi.Input['InstanceTemplateSchedulingArgs']] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input['InstanceTemplateServiceAccountArgs']] = None,
                 shielded_instance_config: Optional[pulumi.Input['InstanceTemplateShieldedInstanceConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags_fingerprint: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering InstanceTemplate resources.
        :param pulumi.Input['InstanceTemplateAdvancedMachineFeaturesArgs'] advanced_machine_features: Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        :param pulumi.Input[bool] can_ip_forward: Whether to allow sending and receiving of
               packets with non-matching source or destination IPs. This defaults to false.
        :param pulumi.Input['InstanceTemplateConfidentialInstanceConfigArgs'] confidential_instance_config: Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        :param pulumi.Input[str] description: A brief description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTemplateDiskArgs']]] disks: Disks to attach to instances created from this template.
               This can be specified multiple times for multiple disks. Structure is
               documented below.
        :param pulumi.Input[bool] enable_display: ) Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
               **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTemplateGuestAcceleratorArgs']]] guest_accelerators: List of the type and count of accelerator cards attached to the instance. Structure documented below.
        :param pulumi.Input[str] instance_description: A brief description to use for instances
               created from this template.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of ket/value label pairs to assign to disk created from
               this template
        :param pulumi.Input[str] machine_type: The machine type to create.
        :param pulumi.Input[Mapping[str, Any]] metadata: Metadata key/value pairs to make available from
               within instances created from this template.
        :param pulumi.Input[str] metadata_fingerprint: The unique fingerprint of the metadata.
        :param pulumi.Input[str] metadata_startup_script: An alternative to using the
               startup-script metadata key, mostly to match the compute_instance resource.
               This replaces the startup-script metadata key on the created instance and
               thus the two mechanisms are not allowed to be used simultaneously.
        :param pulumi.Input[str] min_cpu_platform: Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
               `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        :param pulumi.Input[str] name: The name of the instance template. If you leave
               this blank, the provider will auto-generate a unique name.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTemplateNetworkInterfaceArgs']]] network_interfaces: Networks to attach to instances created from
               this template. This can be specified multiple times for multiple networks.
               Structure is documented below.
        :param pulumi.Input['InstanceTemplateNetworkPerformanceConfigArgs'] network_performance_config: Configures network performance settings for the instance created from the
               template. Structure is documented below. **Note**: `machine_type`
               must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
               the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
               in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
               in order for this setting to take effect.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] region: An instance template is a global resource that is not
               bound to a zone or a region. However, you can still specify some regional
               resources in an instance template, which restricts the template to the
               region where that resource resides. For example, a custom `subnetwork`
               resource is tied to a specific region. Defaults to the region of the
               Provider if no value is given.
        :param pulumi.Input['InstanceTemplateReservationAffinityArgs'] reservation_affinity: Specifies the reservations that this instance can consume from.
               Structure is documented below.
        :param pulumi.Input['InstanceTemplateSchedulingArgs'] scheduling: The scheduling strategy to use. More details about
               this configuration option are detailed below.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input['InstanceTemplateServiceAccountArgs'] service_account: Service account to attach to the instance. Structure is documented below.
        :param pulumi.Input['InstanceTemplateShieldedInstanceConfigArgs'] shielded_instance_config: Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
               **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to attach to the instance.
        :param pulumi.Input[str] tags_fingerprint: The unique fingerprint of the tags.
        """
        if advanced_machine_features is not None:
            pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if confidential_instance_config is not None:
            pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if enable_display is not None:
            pulumi.set(__self__, "enable_display", enable_display)
        if guest_accelerators is not None:
            pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        if instance_description is not None:
            pulumi.set(__self__, "instance_description", instance_description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_fingerprint is not None:
            pulumi.set(__self__, "metadata_fingerprint", metadata_fingerprint)
        if metadata_startup_script is not None:
            pulumi.set(__self__, "metadata_startup_script", metadata_startup_script)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if network_performance_config is not None:
            pulumi.set(__self__, "network_performance_config", network_performance_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_fingerprint is not None:
            pulumi.set(__self__, "tags_fingerprint", tags_fingerprint)

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Optional[pulumi.Input['InstanceTemplateAdvancedMachineFeaturesArgs']]:
        """
        Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        """
        return pulumi.get(self, "advanced_machine_features")

    @advanced_machine_features.setter
    def advanced_machine_features(self, value: Optional[pulumi.Input['InstanceTemplateAdvancedMachineFeaturesArgs']]):
        pulumi.set(self, "advanced_machine_features", value)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow sending and receiving of
        packets with non-matching source or destination IPs. This defaults to false.
        """
        return pulumi.get(self, "can_ip_forward")

    @can_ip_forward.setter
    def can_ip_forward(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_ip_forward", value)

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> Optional[pulumi.Input['InstanceTemplateConfidentialInstanceConfigArgs']]:
        """
        Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        """
        return pulumi.get(self, "confidential_instance_config")

    @confidential_instance_config.setter
    def confidential_instance_config(self, value: Optional[pulumi.Input['InstanceTemplateConfidentialInstanceConfigArgs']]):
        pulumi.set(self, "confidential_instance_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A brief description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateDiskArgs']]]]:
        """
        Disks to attach to instances created from this template.
        This can be specified multiple times for multiple disks. Structure is
        documented below.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> Optional[pulumi.Input[bool]]:
        """
        ) Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
        **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        """
        return pulumi.get(self, "enable_display")

    @enable_display.setter
    def enable_display(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_display", value)

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateGuestAcceleratorArgs']]]]:
        """
        List of the type and count of accelerator cards attached to the instance. Structure documented below.
        """
        return pulumi.get(self, "guest_accelerators")

    @guest_accelerators.setter
    def guest_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateGuestAcceleratorArgs']]]]):
        pulumi.set(self, "guest_accelerators", value)

    @property
    @pulumi.getter(name="instanceDescription")
    def instance_description(self) -> Optional[pulumi.Input[str]]:
        """
        A brief description to use for instances
        created from this template.
        """
        return pulumi.get(self, "instance_description")

    @instance_description.setter
    def instance_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of ket/value label pairs to assign to disk created from
        this template
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The machine type to create.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Metadata key/value pairs to make available from
        within instances created from this template.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metadataFingerprint")
    def metadata_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        The unique fingerprint of the metadata.
        """
        return pulumi.get(self, "metadata_fingerprint")

    @metadata_fingerprint.setter
    def metadata_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_fingerprint", value)

    @property
    @pulumi.getter(name="metadataStartupScript")
    def metadata_startup_script(self) -> Optional[pulumi.Input[str]]:
        """
        An alternative to using the
        startup-script metadata key, mostly to match the compute_instance resource.
        This replaces the startup-script metadata key on the created instance and
        thus the two mechanisms are not allowed to be used simultaneously.
        """
        return pulumi.get(self, "metadata_startup_script")

    @metadata_startup_script.setter
    def metadata_startup_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_startup_script", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
        `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance template. If you leave
        this blank, the provider will auto-generate a unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateNetworkInterfaceArgs']]]]:
        """
        Networks to attach to instances created from
        this template. This can be specified multiple times for multiple networks.
        Structure is documented below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> Optional[pulumi.Input['InstanceTemplateNetworkPerformanceConfigArgs']]:
        """
        Configures network performance settings for the instance created from the
        template. Structure is documented below. **Note**: `machine_type`
        must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
        the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
        in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
        in order for this setting to take effect.
        """
        return pulumi.get(self, "network_performance_config")

    @network_performance_config.setter
    def network_performance_config(self, value: Optional[pulumi.Input['InstanceTemplateNetworkPerformanceConfigArgs']]):
        pulumi.set(self, "network_performance_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        An instance template is a global resource that is not
        bound to a zone or a region. However, you can still specify some regional
        resources in an instance template, which restricts the template to the
        region where that resource resides. For example, a custom `subnetwork`
        resource is tied to a specific region. Defaults to the region of the
        Provider if no value is given.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional[pulumi.Input['InstanceTemplateReservationAffinityArgs']]:
        """
        Specifies the reservations that this instance can consume from.
        Structure is documented below.
        """
        return pulumi.get(self, "reservation_affinity")

    @reservation_affinity.setter
    def reservation_affinity(self, value: Optional[pulumi.Input['InstanceTemplateReservationAffinityArgs']]):
        pulumi.set(self, "reservation_affinity", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['InstanceTemplateSchedulingArgs']]:
        """
        The scheduling strategy to use. More details about
        this configuration option are detailed below.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['InstanceTemplateSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['InstanceTemplateServiceAccountArgs']]:
        """
        Service account to attach to the instance. Structure is documented below.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['InstanceTemplateServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['InstanceTemplateShieldedInstanceConfigArgs']]:
        """
        Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
        **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['InstanceTemplateShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to attach to the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsFingerprint")
    def tags_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        The unique fingerprint of the tags.
        """
        return pulumi.get(self, "tags_fingerprint")

    @tags_fingerprint.setter
    def tags_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tags_fingerprint", value)


class InstanceTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_machine_features: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateAdvancedMachineFeaturesArgs']]] = None,
                 can_ip_forward: Optional[pulumi.Input[bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateConfidentialInstanceConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateDiskArgs']]]]] = None,
                 enable_display: Optional[pulumi.Input[bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateGuestAcceleratorArgs']]]]] = None,
                 instance_description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 metadata_startup_script: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateNetworkInterfaceArgs']]]]] = None,
                 network_performance_config: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateNetworkPerformanceConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reservation_affinity: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateReservationAffinityArgs']]] = None,
                 scheduling: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateSchedulingArgs']]] = None,
                 service_account: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateServiceAccountArgs']]] = None,
                 shielded_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateShieldedInstanceConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages a VM instance template resource within GCE. For more information see
        [the official documentation](https://cloud.google.com/compute/docs/instance-templates)
        and
        [API](https://cloud.google.com/compute/docs/reference/latest/instanceTemplates).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_account = gcp.service_account.Account("defaultAccount",
            account_id="service-account-id",
            display_name="Service Account")
        my_image = gcp.compute.get_image(family="debian-9",
            project="debian-cloud")
        foobar = gcp.compute.Disk("foobar",
            image=my_image.self_link,
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        daily_backup = gcp.compute.ResourcePolicy("dailyBackup",
            region="us-central1",
            snapshot_schedule_policy=gcp.compute.ResourcePolicySnapshotSchedulePolicyArgs(
                schedule=gcp.compute.ResourcePolicySnapshotSchedulePolicyScheduleArgs(
                    daily_schedule=gcp.compute.ResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleArgs(
                        days_in_cycle=1,
                        start_time="04:00",
                    ),
                ),
            ))
        default_instance_template = gcp.compute.InstanceTemplate("defaultInstanceTemplate",
            description="This template is used to create app server instances.",
            tags=[
                "foo",
                "bar",
            ],
            labels={
                "environment": "dev",
            },
            instance_description="description assigned to instances",
            machine_type="e2-medium",
            can_ip_forward=False,
            scheduling=gcp.compute.InstanceTemplateSchedulingArgs(
                automatic_restart=True,
                on_host_maintenance="MIGRATE",
            ),
            disks=[
                gcp.compute.InstanceTemplateDiskArgs(
                    source_image="debian-cloud/debian-9",
                    auto_delete=True,
                    boot=True,
                    resource_policies=[daily_backup.id],
                ),
                gcp.compute.InstanceTemplateDiskArgs(
                    source=foobar.name,
                    auto_delete=False,
                    boot=False,
                ),
            ],
            network_interfaces=[gcp.compute.InstanceTemplateNetworkInterfaceArgs(
                network="default",
            )],
            metadata={
                "foo": "bar",
            },
            service_account=gcp.compute.InstanceTemplateServiceAccountArgs(
                email=default_account.email,
                scopes=["cloud-platform"],
            ))
        ```
        ### Automatic Envoy Deployment

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_default_service_account()
        my_image = gcp.compute.get_image(family="debian-9",
            project="debian-cloud")
        foobar = gcp.compute.InstanceTemplate("foobar",
            machine_type="e2-medium",
            can_ip_forward=False,
            tags=[
                "foo",
                "bar",
            ],
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image=my_image.self_link,
                auto_delete=True,
                boot=True,
            )],
            network_interfaces=[gcp.compute.InstanceTemplateNetworkInterfaceArgs(
                network="default",
            )],
            scheduling=gcp.compute.InstanceTemplateSchedulingArgs(
                preemptible=False,
                automatic_restart=True,
            ),
            metadata={
                "gce-software-declaration": \"\"\"{
          "softwareRecipes": [{
            "name": "install-gce-service-proxy-agent",
            "desired_state": "INSTALLED",
            "installSteps": [{
              "scriptRun": {
                "script": "#! /bin/bash\nZONE=$(curl --silent http://metadata.google.internal/computeMetadata/v1/instance/zone -H Metadata-Flavor:Google | cut -d/ -f4 )\nexport SERVICE_PROXY_AGENT_DIRECTORY=$(mktemp -d)\nsudo gsutil cp   gs://gce-service-proxy-"$ZONE"/service-proxy-agent/releases/service-proxy-agent-0.2.tgz   "$SERVICE_PROXY_AGENT_DIRECTORY"   || sudo gsutil cp     gs://gce-service-proxy/service-proxy-agent/releases/service-proxy-agent-0.2.tgz     "$SERVICE_PROXY_AGENT_DIRECTORY"\nsudo tar -xzf "$SERVICE_PROXY_AGENT_DIRECTORY"/service-proxy-agent-0.2.tgz -C "$SERVICE_PROXY_AGENT_DIRECTORY"\n"$SERVICE_PROXY_AGENT_DIRECTORY"/service-proxy-agent/service-proxy-agent-bootstrap.sh"
              }
            }]
          }]
        }
        \"\"\",
                "gce-service-proxy": \"\"\"{
          "api-version": "0.2",
          "proxy-spec": {
            "proxy-port": 15001,
            "network": "my-network",
            "tracing": "ON",
            "access-log": "/var/log/envoy/access.log"
          }
          "service": {
            "serving-ports": [80, 81]
          },
         "labels": {
           "app_name": "bookserver_app",
           "app_version": "STABLE"
          }
        }
        \"\"\",
                "enable-guest-attributes": "true",
                "enable-osconfig": "true",
            },
            service_account=gcp.compute.InstanceTemplateServiceAccountArgs(
                email=default.email,
                scopes=["cloud-platform"],
            ),
            labels={
                "gce-service-proxy": "on",
            })
        ```
        ## Deploying the Latest Image

        A common way to use instance templates and managed instance groups is to deploy the
        latest image in a family, usually the latest build of your application. There are two
        ways to do this in the provider, and they have their pros and cons. The difference ends
        up being in how "latest" is interpreted. You can either deploy the latest image available
        when the provider runs, or you can have each instance check what the latest image is when
        it's being created, either as part of a scaling event or being rebuilt by the instance
        group manager.

        If you're not sure, we recommend deploying the latest image available when the provider runs,
        because this means all the instances in your group will be based on the same image, always,
        and means that no upgrades or changes to your instances happen outside of a `pulumi up`.
        You can achieve this by using the `compute.Image`
        data source, which will retrieve the latest image on every `pulumi apply`, and will update
        the template to use that specific image:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_image = gcp.compute.get_image(family="debian-9",
            project="debian-cloud")
        instance_template = gcp.compute.InstanceTemplate("instanceTemplate",
            name_prefix="instance-template-",
            machine_type="e2-medium",
            region="us-central1",
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image=google_compute_image["my_image"]["self_link"],
            )])
        ```

        To have instances update to the latest on every scaling event or instance re-creation,
        use the family as the image for the disk, and it will use GCP's default behavior, setting
        the image for the template to the family:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance_template = gcp.compute.InstanceTemplate("instanceTemplate",
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image="debian-cloud/debian-9",
            )],
            machine_type="e2-medium",
            name_prefix="instance-template-",
            region="us-central1")
        ```

        ## Import

        Instance templates can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/instanceTemplate:InstanceTemplate default projects/{{project}}/global/instanceTemplates/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/instanceTemplate:InstanceTemplate default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/instanceTemplate:InstanceTemplate default {{name}}
        ```

         [custom-vm-types]https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types [network-tier]https://cloud.google.com/network-tiers/docs/overview

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateAdvancedMachineFeaturesArgs']] advanced_machine_features: Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        :param pulumi.Input[bool] can_ip_forward: Whether to allow sending and receiving of
               packets with non-matching source or destination IPs. This defaults to false.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateConfidentialInstanceConfigArgs']] confidential_instance_config: Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        :param pulumi.Input[str] description: A brief description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateDiskArgs']]]] disks: Disks to attach to instances created from this template.
               This can be specified multiple times for multiple disks. Structure is
               documented below.
        :param pulumi.Input[bool] enable_display: ) Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
               **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateGuestAcceleratorArgs']]]] guest_accelerators: List of the type and count of accelerator cards attached to the instance. Structure documented below.
        :param pulumi.Input[str] instance_description: A brief description to use for instances
               created from this template.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of ket/value label pairs to assign to disk created from
               this template
        :param pulumi.Input[str] machine_type: The machine type to create.
        :param pulumi.Input[Mapping[str, Any]] metadata: Metadata key/value pairs to make available from
               within instances created from this template.
        :param pulumi.Input[str] metadata_startup_script: An alternative to using the
               startup-script metadata key, mostly to match the compute_instance resource.
               This replaces the startup-script metadata key on the created instance and
               thus the two mechanisms are not allowed to be used simultaneously.
        :param pulumi.Input[str] min_cpu_platform: Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
               `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        :param pulumi.Input[str] name: The name of the instance template. If you leave
               this blank, the provider will auto-generate a unique name.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateNetworkInterfaceArgs']]]] network_interfaces: Networks to attach to instances created from
               this template. This can be specified multiple times for multiple networks.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateNetworkPerformanceConfigArgs']] network_performance_config: Configures network performance settings for the instance created from the
               template. Structure is documented below. **Note**: `machine_type`
               must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
               the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
               in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
               in order for this setting to take effect.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] region: An instance template is a global resource that is not
               bound to a zone or a region. However, you can still specify some regional
               resources in an instance template, which restricts the template to the
               region where that resource resides. For example, a custom `subnetwork`
               resource is tied to a specific region. Defaults to the region of the
               Provider if no value is given.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateReservationAffinityArgs']] reservation_affinity: Specifies the reservations that this instance can consume from.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateSchedulingArgs']] scheduling: The scheduling strategy to use. More details about
               this configuration option are detailed below.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateServiceAccountArgs']] service_account: Service account to attach to the instance. Structure is documented below.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateShieldedInstanceConfigArgs']] shielded_instance_config: Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
               **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to attach to the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VM instance template resource within GCE. For more information see
        [the official documentation](https://cloud.google.com/compute/docs/instance-templates)
        and
        [API](https://cloud.google.com/compute/docs/reference/latest/instanceTemplates).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_account = gcp.service_account.Account("defaultAccount",
            account_id="service-account-id",
            display_name="Service Account")
        my_image = gcp.compute.get_image(family="debian-9",
            project="debian-cloud")
        foobar = gcp.compute.Disk("foobar",
            image=my_image.self_link,
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        daily_backup = gcp.compute.ResourcePolicy("dailyBackup",
            region="us-central1",
            snapshot_schedule_policy=gcp.compute.ResourcePolicySnapshotSchedulePolicyArgs(
                schedule=gcp.compute.ResourcePolicySnapshotSchedulePolicyScheduleArgs(
                    daily_schedule=gcp.compute.ResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleArgs(
                        days_in_cycle=1,
                        start_time="04:00",
                    ),
                ),
            ))
        default_instance_template = gcp.compute.InstanceTemplate("defaultInstanceTemplate",
            description="This template is used to create app server instances.",
            tags=[
                "foo",
                "bar",
            ],
            labels={
                "environment": "dev",
            },
            instance_description="description assigned to instances",
            machine_type="e2-medium",
            can_ip_forward=False,
            scheduling=gcp.compute.InstanceTemplateSchedulingArgs(
                automatic_restart=True,
                on_host_maintenance="MIGRATE",
            ),
            disks=[
                gcp.compute.InstanceTemplateDiskArgs(
                    source_image="debian-cloud/debian-9",
                    auto_delete=True,
                    boot=True,
                    resource_policies=[daily_backup.id],
                ),
                gcp.compute.InstanceTemplateDiskArgs(
                    source=foobar.name,
                    auto_delete=False,
                    boot=False,
                ),
            ],
            network_interfaces=[gcp.compute.InstanceTemplateNetworkInterfaceArgs(
                network="default",
            )],
            metadata={
                "foo": "bar",
            },
            service_account=gcp.compute.InstanceTemplateServiceAccountArgs(
                email=default_account.email,
                scopes=["cloud-platform"],
            ))
        ```
        ### Automatic Envoy Deployment

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_default_service_account()
        my_image = gcp.compute.get_image(family="debian-9",
            project="debian-cloud")
        foobar = gcp.compute.InstanceTemplate("foobar",
            machine_type="e2-medium",
            can_ip_forward=False,
            tags=[
                "foo",
                "bar",
            ],
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image=my_image.self_link,
                auto_delete=True,
                boot=True,
            )],
            network_interfaces=[gcp.compute.InstanceTemplateNetworkInterfaceArgs(
                network="default",
            )],
            scheduling=gcp.compute.InstanceTemplateSchedulingArgs(
                preemptible=False,
                automatic_restart=True,
            ),
            metadata={
                "gce-software-declaration": \"\"\"{
          "softwareRecipes": [{
            "name": "install-gce-service-proxy-agent",
            "desired_state": "INSTALLED",
            "installSteps": [{
              "scriptRun": {
                "script": "#! /bin/bash\nZONE=$(curl --silent http://metadata.google.internal/computeMetadata/v1/instance/zone -H Metadata-Flavor:Google | cut -d/ -f4 )\nexport SERVICE_PROXY_AGENT_DIRECTORY=$(mktemp -d)\nsudo gsutil cp   gs://gce-service-proxy-"$ZONE"/service-proxy-agent/releases/service-proxy-agent-0.2.tgz   "$SERVICE_PROXY_AGENT_DIRECTORY"   || sudo gsutil cp     gs://gce-service-proxy/service-proxy-agent/releases/service-proxy-agent-0.2.tgz     "$SERVICE_PROXY_AGENT_DIRECTORY"\nsudo tar -xzf "$SERVICE_PROXY_AGENT_DIRECTORY"/service-proxy-agent-0.2.tgz -C "$SERVICE_PROXY_AGENT_DIRECTORY"\n"$SERVICE_PROXY_AGENT_DIRECTORY"/service-proxy-agent/service-proxy-agent-bootstrap.sh"
              }
            }]
          }]
        }
        \"\"\",
                "gce-service-proxy": \"\"\"{
          "api-version": "0.2",
          "proxy-spec": {
            "proxy-port": 15001,
            "network": "my-network",
            "tracing": "ON",
            "access-log": "/var/log/envoy/access.log"
          }
          "service": {
            "serving-ports": [80, 81]
          },
         "labels": {
           "app_name": "bookserver_app",
           "app_version": "STABLE"
          }
        }
        \"\"\",
                "enable-guest-attributes": "true",
                "enable-osconfig": "true",
            },
            service_account=gcp.compute.InstanceTemplateServiceAccountArgs(
                email=default.email,
                scopes=["cloud-platform"],
            ),
            labels={
                "gce-service-proxy": "on",
            })
        ```
        ## Deploying the Latest Image

        A common way to use instance templates and managed instance groups is to deploy the
        latest image in a family, usually the latest build of your application. There are two
        ways to do this in the provider, and they have their pros and cons. The difference ends
        up being in how "latest" is interpreted. You can either deploy the latest image available
        when the provider runs, or you can have each instance check what the latest image is when
        it's being created, either as part of a scaling event or being rebuilt by the instance
        group manager.

        If you're not sure, we recommend deploying the latest image available when the provider runs,
        because this means all the instances in your group will be based on the same image, always,
        and means that no upgrades or changes to your instances happen outside of a `pulumi up`.
        You can achieve this by using the `compute.Image`
        data source, which will retrieve the latest image on every `pulumi apply`, and will update
        the template to use that specific image:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_image = gcp.compute.get_image(family="debian-9",
            project="debian-cloud")
        instance_template = gcp.compute.InstanceTemplate("instanceTemplate",
            name_prefix="instance-template-",
            machine_type="e2-medium",
            region="us-central1",
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image=google_compute_image["my_image"]["self_link"],
            )])
        ```

        To have instances update to the latest on every scaling event or instance re-creation,
        use the family as the image for the disk, and it will use GCP's default behavior, setting
        the image for the template to the family:

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance_template = gcp.compute.InstanceTemplate("instanceTemplate",
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image="debian-cloud/debian-9",
            )],
            machine_type="e2-medium",
            name_prefix="instance-template-",
            region="us-central1")
        ```

        ## Import

        Instance templates can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/instanceTemplate:InstanceTemplate default projects/{{project}}/global/instanceTemplates/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/instanceTemplate:InstanceTemplate default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/instanceTemplate:InstanceTemplate default {{name}}
        ```

         [custom-vm-types]https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types [network-tier]https://cloud.google.com/network-tiers/docs/overview

        :param str resource_name: The name of the resource.
        :param InstanceTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_machine_features: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateAdvancedMachineFeaturesArgs']]] = None,
                 can_ip_forward: Optional[pulumi.Input[bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateConfidentialInstanceConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateDiskArgs']]]]] = None,
                 enable_display: Optional[pulumi.Input[bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateGuestAcceleratorArgs']]]]] = None,
                 instance_description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 metadata_startup_script: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateNetworkInterfaceArgs']]]]] = None,
                 network_performance_config: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateNetworkPerformanceConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reservation_affinity: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateReservationAffinityArgs']]] = None,
                 scheduling: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateSchedulingArgs']]] = None,
                 service_account: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateServiceAccountArgs']]] = None,
                 shielded_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateShieldedInstanceConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceTemplateArgs.__new__(InstanceTemplateArgs)

            __props__.__dict__["advanced_machine_features"] = advanced_machine_features
            __props__.__dict__["can_ip_forward"] = can_ip_forward
            __props__.__dict__["confidential_instance_config"] = confidential_instance_config
            __props__.__dict__["description"] = description
            if disks is None and not opts.urn:
                raise TypeError("Missing required property 'disks'")
            __props__.__dict__["disks"] = disks
            __props__.__dict__["enable_display"] = enable_display
            __props__.__dict__["guest_accelerators"] = guest_accelerators
            __props__.__dict__["instance_description"] = instance_description
            __props__.__dict__["labels"] = labels
            if machine_type is None and not opts.urn:
                raise TypeError("Missing required property 'machine_type'")
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["metadata_startup_script"] = metadata_startup_script
            __props__.__dict__["min_cpu_platform"] = min_cpu_platform
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["network_performance_config"] = network_performance_config
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["reservation_affinity"] = reservation_affinity
            __props__.__dict__["scheduling"] = scheduling
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["shielded_instance_config"] = shielded_instance_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["metadata_fingerprint"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["tags_fingerprint"] = None
        super(InstanceTemplate, __self__).__init__(
            'gcp:compute/instanceTemplate:InstanceTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_machine_features: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateAdvancedMachineFeaturesArgs']]] = None,
            can_ip_forward: Optional[pulumi.Input[bool]] = None,
            confidential_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateConfidentialInstanceConfigArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateDiskArgs']]]]] = None,
            enable_display: Optional[pulumi.Input[bool]] = None,
            guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateGuestAcceleratorArgs']]]]] = None,
            instance_description: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            machine_type: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            metadata_fingerprint: Optional[pulumi.Input[str]] = None,
            metadata_startup_script: Optional[pulumi.Input[str]] = None,
            min_cpu_platform: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_prefix: Optional[pulumi.Input[str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateNetworkInterfaceArgs']]]]] = None,
            network_performance_config: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateNetworkPerformanceConfigArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            reservation_affinity: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateReservationAffinityArgs']]] = None,
            scheduling: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateSchedulingArgs']]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            service_account: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateServiceAccountArgs']]] = None,
            shielded_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceTemplateShieldedInstanceConfigArgs']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags_fingerprint: Optional[pulumi.Input[str]] = None) -> 'InstanceTemplate':
        """
        Get an existing InstanceTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateAdvancedMachineFeaturesArgs']] advanced_machine_features: Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        :param pulumi.Input[bool] can_ip_forward: Whether to allow sending and receiving of
               packets with non-matching source or destination IPs. This defaults to false.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateConfidentialInstanceConfigArgs']] confidential_instance_config: Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        :param pulumi.Input[str] description: A brief description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateDiskArgs']]]] disks: Disks to attach to instances created from this template.
               This can be specified multiple times for multiple disks. Structure is
               documented below.
        :param pulumi.Input[bool] enable_display: ) Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
               **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateGuestAcceleratorArgs']]]] guest_accelerators: List of the type and count of accelerator cards attached to the instance. Structure documented below.
        :param pulumi.Input[str] instance_description: A brief description to use for instances
               created from this template.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of ket/value label pairs to assign to disk created from
               this template
        :param pulumi.Input[str] machine_type: The machine type to create.
        :param pulumi.Input[Mapping[str, Any]] metadata: Metadata key/value pairs to make available from
               within instances created from this template.
        :param pulumi.Input[str] metadata_fingerprint: The unique fingerprint of the metadata.
        :param pulumi.Input[str] metadata_startup_script: An alternative to using the
               startup-script metadata key, mostly to match the compute_instance resource.
               This replaces the startup-script metadata key on the created instance and
               thus the two mechanisms are not allowed to be used simultaneously.
        :param pulumi.Input[str] min_cpu_platform: Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
               `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        :param pulumi.Input[str] name: The name of the instance template. If you leave
               this blank, the provider will auto-generate a unique name.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTemplateNetworkInterfaceArgs']]]] network_interfaces: Networks to attach to instances created from
               this template. This can be specified multiple times for multiple networks.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateNetworkPerformanceConfigArgs']] network_performance_config: Configures network performance settings for the instance created from the
               template. Structure is documented below. **Note**: `machine_type`
               must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
               the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
               in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
               in order for this setting to take effect.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] region: An instance template is a global resource that is not
               bound to a zone or a region. However, you can still specify some regional
               resources in an instance template, which restricts the template to the
               region where that resource resides. For example, a custom `subnetwork`
               resource is tied to a specific region. Defaults to the region of the
               Provider if no value is given.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateReservationAffinityArgs']] reservation_affinity: Specifies the reservations that this instance can consume from.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateSchedulingArgs']] scheduling: The scheduling strategy to use. More details about
               this configuration option are detailed below.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateServiceAccountArgs']] service_account: Service account to attach to the instance. Structure is documented below.
        :param pulumi.Input[pulumi.InputType['InstanceTemplateShieldedInstanceConfigArgs']] shielded_instance_config: Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
               **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to attach to the instance.
        :param pulumi.Input[str] tags_fingerprint: The unique fingerprint of the tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceTemplateState.__new__(_InstanceTemplateState)

        __props__.__dict__["advanced_machine_features"] = advanced_machine_features
        __props__.__dict__["can_ip_forward"] = can_ip_forward
        __props__.__dict__["confidential_instance_config"] = confidential_instance_config
        __props__.__dict__["description"] = description
        __props__.__dict__["disks"] = disks
        __props__.__dict__["enable_display"] = enable_display
        __props__.__dict__["guest_accelerators"] = guest_accelerators
        __props__.__dict__["instance_description"] = instance_description
        __props__.__dict__["labels"] = labels
        __props__.__dict__["machine_type"] = machine_type
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metadata_fingerprint"] = metadata_fingerprint
        __props__.__dict__["metadata_startup_script"] = metadata_startup_script
        __props__.__dict__["min_cpu_platform"] = min_cpu_platform
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["network_performance_config"] = network_performance_config
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["reservation_affinity"] = reservation_affinity
        __props__.__dict__["scheduling"] = scheduling
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["shielded_instance_config"] = shielded_instance_config
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_fingerprint"] = tags_fingerprint
        return InstanceTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> pulumi.Output[Optional['outputs.InstanceTemplateAdvancedMachineFeatures']]:
        """
        Configure Nested Virtualisation and Simultaneous Hyper Threading on this VM. Structure is documented below
        """
        return pulumi.get(self, "advanced_machine_features")

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to allow sending and receiving of
        packets with non-matching source or destination IPs. This defaults to false.
        """
        return pulumi.get(self, "can_ip_forward")

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> pulumi.Output['outputs.InstanceTemplateConfidentialInstanceConfig']:
        """
        Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        """
        return pulumi.get(self, "confidential_instance_config")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A brief description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Sequence['outputs.InstanceTemplateDisk']]:
        """
        Disks to attach to instances created from this template.
        This can be specified multiple times for multiple disks. Structure is
        documented below.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> pulumi.Output[Optional[bool]]:
        """
        ) Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
        **Note**: `allow_stopping_for_update` must be set to true in order to update this field.
        """
        return pulumi.get(self, "enable_display")

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceTemplateGuestAccelerator']]]:
        """
        List of the type and count of accelerator cards attached to the instance. Structure documented below.
        """
        return pulumi.get(self, "guest_accelerators")

    @property
    @pulumi.getter(name="instanceDescription")
    def instance_description(self) -> pulumi.Output[Optional[str]]:
        """
        A brief description to use for instances
        created from this template.
        """
        return pulumi.get(self, "instance_description")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of ket/value label pairs to assign to disk created from
        this template
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[str]:
        """
        The machine type to create.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Metadata key/value pairs to make available from
        within instances created from this template.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="metadataFingerprint")
    def metadata_fingerprint(self) -> pulumi.Output[str]:
        """
        The unique fingerprint of the metadata.
        """
        return pulumi.get(self, "metadata_fingerprint")

    @property
    @pulumi.getter(name="metadataStartupScript")
    def metadata_startup_script(self) -> pulumi.Output[Optional[str]]:
        """
        An alternative to using the
        startup-script metadata key, mostly to match the compute_instance resource.
        This replaces the startup-script metadata key on the created instance and
        thus the two mechanisms are not allowed to be used simultaneously.
        """
        return pulumi.get(self, "metadata_startup_script")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as
        `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the instance template. If you leave
        this blank, the provider will auto-generate a unique name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[str]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceTemplateNetworkInterface']]]:
        """
        Networks to attach to instances created from
        this template. This can be specified multiple times for multiple networks.
        Structure is documented below.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> pulumi.Output[Optional['outputs.InstanceTemplateNetworkPerformanceConfig']]:
        """
        Configures network performance settings for the instance created from the
        template. Structure is documented below. **Note**: `machine_type`
        must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
        the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
        in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
        in order for this setting to take effect.
        """
        return pulumi.get(self, "network_performance_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        An instance template is a global resource that is not
        bound to a zone or a region. However, you can still specify some regional
        resources in an instance template, which restricts the template to the
        region where that resource resides. For example, a custom `subnetwork`
        resource is tied to a specific region. Defaults to the region of the
        Provider if no value is given.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> pulumi.Output[Optional['outputs.InstanceTemplateReservationAffinity']]:
        """
        Specifies the reservations that this instance can consume from.
        Structure is documented below.
        """
        return pulumi.get(self, "reservation_affinity")

    @property
    @pulumi.getter
    def scheduling(self) -> pulumi.Output['outputs.InstanceTemplateScheduling']:
        """
        The scheduling strategy to use. More details about
        this configuration option are detailed below.
        """
        return pulumi.get(self, "scheduling")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional['outputs.InstanceTemplateServiceAccount']]:
        """
        Service account to attach to the instance. Structure is documented below.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> pulumi.Output['outputs.InstanceTemplateShieldedInstanceConfig']:
        """
        Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
        **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags to attach to the instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsFingerprint")
    def tags_fingerprint(self) -> pulumi.Output[str]:
        """
        The unique fingerprint of the tags.
        """
        return pulumi.get(self, "tags_fingerprint")

