# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReservationArgs', 'Reservation']

@pulumi.input_type
class ReservationArgs:
    def __init__(__self__, *,
                 specific_reservation: pulumi.Input['ReservationSpecificReservationArgs'],
                 zone: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 share_settings: Optional[pulumi.Input['ReservationShareSettingsArgs']] = None,
                 specific_reservation_required: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Reservation resource.
        :param pulumi.Input['ReservationSpecificReservationArgs'] specific_reservation: Reservation for instances with specific machine shapes.
               Structure is documented below.
        :param pulumi.Input[str] zone: The zone where the reservation is made.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ReservationShareSettingsArgs'] share_settings: The share setting for reservations.
               Structure is documented below.
        :param pulumi.Input[bool] specific_reservation_required: When set to true, only VMs that target this reservation by name can
               consume this reservation. Otherwise, it can be consumed by VMs with
               affinity for any reservation. Defaults to false.
        """
        pulumi.set(__self__, "specific_reservation", specific_reservation)
        pulumi.set(__self__, "zone", zone)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if share_settings is not None:
            pulumi.set(__self__, "share_settings", share_settings)
        if specific_reservation_required is not None:
            pulumi.set(__self__, "specific_reservation_required", specific_reservation_required)

    @property
    @pulumi.getter(name="specificReservation")
    def specific_reservation(self) -> pulumi.Input['ReservationSpecificReservationArgs']:
        """
        Reservation for instances with specific machine shapes.
        Structure is documented below.
        """
        return pulumi.get(self, "specific_reservation")

    @specific_reservation.setter
    def specific_reservation(self, value: pulumi.Input['ReservationSpecificReservationArgs']):
        pulumi.set(self, "specific_reservation", value)

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Input[str]:
        """
        The zone where the reservation is made.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="shareSettings")
    def share_settings(self) -> Optional[pulumi.Input['ReservationShareSettingsArgs']]:
        """
        The share setting for reservations.
        Structure is documented below.
        """
        return pulumi.get(self, "share_settings")

    @share_settings.setter
    def share_settings(self, value: Optional[pulumi.Input['ReservationShareSettingsArgs']]):
        pulumi.set(self, "share_settings", value)

    @property
    @pulumi.getter(name="specificReservationRequired")
    def specific_reservation_required(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, only VMs that target this reservation by name can
        consume this reservation. Otherwise, it can be consumed by VMs with
        affinity for any reservation. Defaults to false.
        """
        return pulumi.get(self, "specific_reservation_required")

    @specific_reservation_required.setter
    def specific_reservation_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "specific_reservation_required", value)


@pulumi.input_type
class _ReservationState:
    def __init__(__self__, *,
                 commitment: Optional[pulumi.Input[str]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 share_settings: Optional[pulumi.Input['ReservationShareSettingsArgs']] = None,
                 specific_reservation: Optional[pulumi.Input['ReservationSpecificReservationArgs']] = None,
                 specific_reservation_required: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Reservation resources.
        :param pulumi.Input[str] commitment: Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input['ReservationShareSettingsArgs'] share_settings: The share setting for reservations.
               Structure is documented below.
        :param pulumi.Input['ReservationSpecificReservationArgs'] specific_reservation: Reservation for instances with specific machine shapes.
               Structure is documented below.
        :param pulumi.Input[bool] specific_reservation_required: When set to true, only VMs that target this reservation by name can
               consume this reservation. Otherwise, it can be consumed by VMs with
               affinity for any reservation. Defaults to false.
        :param pulumi.Input[str] status: The status of the reservation.
        :param pulumi.Input[str] zone: The zone where the reservation is made.
        """
        if commitment is not None:
            pulumi.set(__self__, "commitment", commitment)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if share_settings is not None:
            pulumi.set(__self__, "share_settings", share_settings)
        if specific_reservation is not None:
            pulumi.set(__self__, "specific_reservation", specific_reservation)
        if specific_reservation_required is not None:
            pulumi.set(__self__, "specific_reservation_required", specific_reservation_required)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def commitment(self) -> Optional[pulumi.Input[str]]:
        """
        Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
        """
        return pulumi.get(self, "commitment")

    @commitment.setter
    def commitment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commitment", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="shareSettings")
    def share_settings(self) -> Optional[pulumi.Input['ReservationShareSettingsArgs']]:
        """
        The share setting for reservations.
        Structure is documented below.
        """
        return pulumi.get(self, "share_settings")

    @share_settings.setter
    def share_settings(self, value: Optional[pulumi.Input['ReservationShareSettingsArgs']]):
        pulumi.set(self, "share_settings", value)

    @property
    @pulumi.getter(name="specificReservation")
    def specific_reservation(self) -> Optional[pulumi.Input['ReservationSpecificReservationArgs']]:
        """
        Reservation for instances with specific machine shapes.
        Structure is documented below.
        """
        return pulumi.get(self, "specific_reservation")

    @specific_reservation.setter
    def specific_reservation(self, value: Optional[pulumi.Input['ReservationSpecificReservationArgs']]):
        pulumi.set(self, "specific_reservation", value)

    @property
    @pulumi.getter(name="specificReservationRequired")
    def specific_reservation_required(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, only VMs that target this reservation by name can
        consume this reservation. Otherwise, it can be consumed by VMs with
        affinity for any reservation. Defaults to false.
        """
        return pulumi.get(self, "specific_reservation_required")

    @specific_reservation_required.setter
    def specific_reservation_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "specific_reservation_required", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the reservation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone where the reservation is made.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class Reservation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 share_settings: Optional[pulumi.Input[pulumi.InputType['ReservationShareSettingsArgs']]] = None,
                 specific_reservation: Optional[pulumi.Input[pulumi.InputType['ReservationSpecificReservationArgs']]] = None,
                 specific_reservation_required: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Represents a reservation resource. A reservation ensures that capacity is
        held in a specific zone even if the reserved VMs are not running.

        Reservations apply only to Compute Engine, Cloud Dataproc, and Google
        Kubernetes Engine VM usage.Reservations do not apply to `f1-micro` or
        `g1-small` machine types, preemptible VMs, sole tenant nodes, or other
        services not listed above
        like Cloud SQL and Dataflow.

        To get more information about Reservation, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/reservations)
        * How-to Guides
            * [Reserving zonal resources](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)

        ## Example Usage
        ### Reservation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        gce_reservation = gcp.compute.Reservation("gceReservation",
            specific_reservation=gcp.compute.ReservationSpecificReservationArgs(
                count=1,
                instance_properties=gcp.compute.ReservationSpecificReservationInstancePropertiesArgs(
                    machine_type="n2-standard-2",
                    min_cpu_platform="Intel Cascade Lake",
                ),
            ),
            zone="us-central1-a")
        ```

        ## Import

        Reservation can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/reservation:Reservation default projects/{{project}}/zones/{{zone}}/reservations/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/reservation:Reservation default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/reservation:Reservation default {{zone}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/reservation:Reservation default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['ReservationShareSettingsArgs']] share_settings: The share setting for reservations.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ReservationSpecificReservationArgs']] specific_reservation: Reservation for instances with specific machine shapes.
               Structure is documented below.
        :param pulumi.Input[bool] specific_reservation_required: When set to true, only VMs that target this reservation by name can
               consume this reservation. Otherwise, it can be consumed by VMs with
               affinity for any reservation. Defaults to false.
        :param pulumi.Input[str] zone: The zone where the reservation is made.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReservationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a reservation resource. A reservation ensures that capacity is
        held in a specific zone even if the reserved VMs are not running.

        Reservations apply only to Compute Engine, Cloud Dataproc, and Google
        Kubernetes Engine VM usage.Reservations do not apply to `f1-micro` or
        `g1-small` machine types, preemptible VMs, sole tenant nodes, or other
        services not listed above
        like Cloud SQL and Dataflow.

        To get more information about Reservation, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/reservations)
        * How-to Guides
            * [Reserving zonal resources](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)

        ## Example Usage
        ### Reservation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        gce_reservation = gcp.compute.Reservation("gceReservation",
            specific_reservation=gcp.compute.ReservationSpecificReservationArgs(
                count=1,
                instance_properties=gcp.compute.ReservationSpecificReservationInstancePropertiesArgs(
                    machine_type="n2-standard-2",
                    min_cpu_platform="Intel Cascade Lake",
                ),
            ),
            zone="us-central1-a")
        ```

        ## Import

        Reservation can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/reservation:Reservation default projects/{{project}}/zones/{{zone}}/reservations/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/reservation:Reservation default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/reservation:Reservation default {{zone}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/reservation:Reservation default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ReservationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReservationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 share_settings: Optional[pulumi.Input[pulumi.InputType['ReservationShareSettingsArgs']]] = None,
                 specific_reservation: Optional[pulumi.Input[pulumi.InputType['ReservationSpecificReservationArgs']]] = None,
                 specific_reservation_required: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReservationArgs.__new__(ReservationArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["share_settings"] = share_settings
            if specific_reservation is None and not opts.urn:
                raise TypeError("Missing required property 'specific_reservation'")
            __props__.__dict__["specific_reservation"] = specific_reservation
            __props__.__dict__["specific_reservation_required"] = specific_reservation_required
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["commitment"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["status"] = None
        super(Reservation, __self__).__init__(
            'gcp:compute/reservation:Reservation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            commitment: Optional[pulumi.Input[str]] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            share_settings: Optional[pulumi.Input[pulumi.InputType['ReservationShareSettingsArgs']]] = None,
            specific_reservation: Optional[pulumi.Input[pulumi.InputType['ReservationSpecificReservationArgs']]] = None,
            specific_reservation_required: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'Reservation':
        """
        Get an existing Reservation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] commitment: Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[pulumi.InputType['ReservationShareSettingsArgs']] share_settings: The share setting for reservations.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ReservationSpecificReservationArgs']] specific_reservation: Reservation for instances with specific machine shapes.
               Structure is documented below.
        :param pulumi.Input[bool] specific_reservation_required: When set to true, only VMs that target this reservation by name can
               consume this reservation. Otherwise, it can be consumed by VMs with
               affinity for any reservation. Defaults to false.
        :param pulumi.Input[str] status: The status of the reservation.
        :param pulumi.Input[str] zone: The zone where the reservation is made.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReservationState.__new__(_ReservationState)

        __props__.__dict__["commitment"] = commitment
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["share_settings"] = share_settings
        __props__.__dict__["specific_reservation"] = specific_reservation
        __props__.__dict__["specific_reservation_required"] = specific_reservation_required
        __props__.__dict__["status"] = status
        __props__.__dict__["zone"] = zone
        return Reservation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def commitment(self) -> pulumi.Output[str]:
        """
        Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
        """
        return pulumi.get(self, "commitment")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="shareSettings")
    def share_settings(self) -> pulumi.Output['outputs.ReservationShareSettings']:
        """
        The share setting for reservations.
        Structure is documented below.
        """
        return pulumi.get(self, "share_settings")

    @property
    @pulumi.getter(name="specificReservation")
    def specific_reservation(self) -> pulumi.Output['outputs.ReservationSpecificReservation']:
        """
        Reservation for instances with specific machine shapes.
        Structure is documented below.
        """
        return pulumi.get(self, "specific_reservation")

    @property
    @pulumi.getter(name="specificReservationRequired")
    def specific_reservation_required(self) -> pulumi.Output[Optional[bool]]:
        """
        When set to true, only VMs that target this reservation by name can
        consume this reservation. Otherwise, it can be consumed by VMs with
        affinity for any reservation. Defaults to false.
        """
        return pulumi.get(self, "specific_reservation_required")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the reservation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The zone where the reservation is made.
        """
        return pulumi.get(self, "zone")

