# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 placement: pulumi.Input['JobPlacementArgs'],
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 hadoop_config: Optional[pulumi.Input['JobHadoopConfigArgs']] = None,
                 hive_config: Optional[pulumi.Input['JobHiveConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pig_config: Optional[pulumi.Input['JobPigConfigArgs']] = None,
                 presto_config: Optional[pulumi.Input['JobPrestoConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pyspark_config: Optional[pulumi.Input['JobPysparkConfigArgs']] = None,
                 reference: Optional[pulumi.Input['JobReferenceArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scheduling: Optional[pulumi.Input['JobSchedulingArgs']] = None,
                 spark_config: Optional[pulumi.Input['JobSparkConfigArgs']] = None,
                 sparksql_config: Optional[pulumi.Input['JobSparksqlConfigArgs']] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input['JobPlacementArgs'] placement: The config of job placement.
        :param pulumi.Input[bool] force_delete: By default, you can only delete inactive jobs within
               Dataproc. Setting this to true, and calling destroy, will ensure that the
               job is first cancelled before issuing the delete.
        :param pulumi.Input['JobHadoopConfigArgs'] hadoop_config: The config of Hadoop job
        :param pulumi.Input['JobHiveConfigArgs'] hive_config: The config of hive job
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The list of labels (key/value pairs) to add to the job.
        :param pulumi.Input['JobPigConfigArgs'] pig_config: The config of pag job.
        :param pulumi.Input['JobPrestoConfigArgs'] presto_config: The config of presto job
        :param pulumi.Input[str] project: The project in which the `cluster` can be found and jobs
               subsequently run against. If it is not provided, the provider project is used.
        :param pulumi.Input['JobPysparkConfigArgs'] pyspark_config: The config of pySpark job.
        :param pulumi.Input['JobReferenceArgs'] reference: The reference of the job
        :param pulumi.Input[str] region: The Cloud Dataproc region. This essentially determines which clusters are available
               for this job to be submitted to. If not specified, defaults to `global`.
        :param pulumi.Input['JobSchedulingArgs'] scheduling: Optional. Job scheduling configuration.
        :param pulumi.Input['JobSparkConfigArgs'] spark_config: The config of the Spark job.
        :param pulumi.Input['JobSparksqlConfigArgs'] sparksql_config: The config of SparkSql job
        """
        pulumi.set(__self__, "placement", placement)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if hadoop_config is not None:
            pulumi.set(__self__, "hadoop_config", hadoop_config)
        if hive_config is not None:
            pulumi.set(__self__, "hive_config", hive_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if pig_config is not None:
            pulumi.set(__self__, "pig_config", pig_config)
        if presto_config is not None:
            pulumi.set(__self__, "presto_config", presto_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pyspark_config is not None:
            pulumi.set(__self__, "pyspark_config", pyspark_config)
        if reference is not None:
            pulumi.set(__self__, "reference", reference)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if spark_config is not None:
            pulumi.set(__self__, "spark_config", spark_config)
        if sparksql_config is not None:
            pulumi.set(__self__, "sparksql_config", sparksql_config)

    @property
    @pulumi.getter
    def placement(self) -> pulumi.Input['JobPlacementArgs']:
        """
        The config of job placement.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: pulumi.Input['JobPlacementArgs']):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        By default, you can only delete inactive jobs within
        Dataproc. Setting this to true, and calling destroy, will ensure that the
        job is first cancelled before issuing the delete.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="hadoopConfig")
    def hadoop_config(self) -> Optional[pulumi.Input['JobHadoopConfigArgs']]:
        """
        The config of Hadoop job
        """
        return pulumi.get(self, "hadoop_config")

    @hadoop_config.setter
    def hadoop_config(self, value: Optional[pulumi.Input['JobHadoopConfigArgs']]):
        pulumi.set(self, "hadoop_config", value)

    @property
    @pulumi.getter(name="hiveConfig")
    def hive_config(self) -> Optional[pulumi.Input['JobHiveConfigArgs']]:
        """
        The config of hive job
        """
        return pulumi.get(self, "hive_config")

    @hive_config.setter
    def hive_config(self, value: Optional[pulumi.Input['JobHiveConfigArgs']]):
        pulumi.set(self, "hive_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The list of labels (key/value pairs) to add to the job.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="pigConfig")
    def pig_config(self) -> Optional[pulumi.Input['JobPigConfigArgs']]:
        """
        The config of pag job.
        """
        return pulumi.get(self, "pig_config")

    @pig_config.setter
    def pig_config(self, value: Optional[pulumi.Input['JobPigConfigArgs']]):
        pulumi.set(self, "pig_config", value)

    @property
    @pulumi.getter(name="prestoConfig")
    def presto_config(self) -> Optional[pulumi.Input['JobPrestoConfigArgs']]:
        """
        The config of presto job
        """
        return pulumi.get(self, "presto_config")

    @presto_config.setter
    def presto_config(self, value: Optional[pulumi.Input['JobPrestoConfigArgs']]):
        pulumi.set(self, "presto_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project in which the `cluster` can be found and jobs
        subsequently run against. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pysparkConfig")
    def pyspark_config(self) -> Optional[pulumi.Input['JobPysparkConfigArgs']]:
        """
        The config of pySpark job.
        """
        return pulumi.get(self, "pyspark_config")

    @pyspark_config.setter
    def pyspark_config(self, value: Optional[pulumi.Input['JobPysparkConfigArgs']]):
        pulumi.set(self, "pyspark_config", value)

    @property
    @pulumi.getter
    def reference(self) -> Optional[pulumi.Input['JobReferenceArgs']]:
        """
        The reference of the job
        """
        return pulumi.get(self, "reference")

    @reference.setter
    def reference(self, value: Optional[pulumi.Input['JobReferenceArgs']]):
        pulumi.set(self, "reference", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Dataproc region. This essentially determines which clusters are available
        for this job to be submitted to. If not specified, defaults to `global`.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['JobSchedulingArgs']]:
        """
        Optional. Job scheduling configuration.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['JobSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="sparkConfig")
    def spark_config(self) -> Optional[pulumi.Input['JobSparkConfigArgs']]:
        """
        The config of the Spark job.
        """
        return pulumi.get(self, "spark_config")

    @spark_config.setter
    def spark_config(self, value: Optional[pulumi.Input['JobSparkConfigArgs']]):
        pulumi.set(self, "spark_config", value)

    @property
    @pulumi.getter(name="sparksqlConfig")
    def sparksql_config(self) -> Optional[pulumi.Input['JobSparksqlConfigArgs']]:
        """
        The config of SparkSql job
        """
        return pulumi.get(self, "sparksql_config")

    @sparksql_config.setter
    def sparksql_config(self, value: Optional[pulumi.Input['JobSparksqlConfigArgs']]):
        pulumi.set(self, "sparksql_config", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 driver_controls_files_uri: Optional[pulumi.Input[str]] = None,
                 driver_output_resource_uri: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 hadoop_config: Optional[pulumi.Input['JobHadoopConfigArgs']] = None,
                 hive_config: Optional[pulumi.Input['JobHiveConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pig_config: Optional[pulumi.Input['JobPigConfigArgs']] = None,
                 placement: Optional[pulumi.Input['JobPlacementArgs']] = None,
                 presto_config: Optional[pulumi.Input['JobPrestoConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pyspark_config: Optional[pulumi.Input['JobPysparkConfigArgs']] = None,
                 reference: Optional[pulumi.Input['JobReferenceArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scheduling: Optional[pulumi.Input['JobSchedulingArgs']] = None,
                 spark_config: Optional[pulumi.Input['JobSparkConfigArgs']] = None,
                 sparksql_config: Optional[pulumi.Input['JobSparksqlConfigArgs']] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['JobStatusArgs']]]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[str] driver_controls_files_uri: If present, the location of miscellaneous control files which may be used as part of job setup and handling. If not present, control files may be placed in the same location as driver_output_uri.
        :param pulumi.Input[str] driver_output_resource_uri: A URI pointing to the location of the stdout of the job's driver program.
        :param pulumi.Input[bool] force_delete: By default, you can only delete inactive jobs within
               Dataproc. Setting this to true, and calling destroy, will ensure that the
               job is first cancelled before issuing the delete.
        :param pulumi.Input['JobHadoopConfigArgs'] hadoop_config: The config of Hadoop job
        :param pulumi.Input['JobHiveConfigArgs'] hive_config: The config of hive job
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The list of labels (key/value pairs) to add to the job.
        :param pulumi.Input['JobPigConfigArgs'] pig_config: The config of pag job.
        :param pulumi.Input['JobPlacementArgs'] placement: The config of job placement.
        :param pulumi.Input['JobPrestoConfigArgs'] presto_config: The config of presto job
        :param pulumi.Input[str] project: The project in which the `cluster` can be found and jobs
               subsequently run against. If it is not provided, the provider project is used.
        :param pulumi.Input['JobPysparkConfigArgs'] pyspark_config: The config of pySpark job.
        :param pulumi.Input['JobReferenceArgs'] reference: The reference of the job
        :param pulumi.Input[str] region: The Cloud Dataproc region. This essentially determines which clusters are available
               for this job to be submitted to. If not specified, defaults to `global`.
        :param pulumi.Input['JobSchedulingArgs'] scheduling: Optional. Job scheduling configuration.
        :param pulumi.Input['JobSparkConfigArgs'] spark_config: The config of the Spark job.
        :param pulumi.Input['JobSparksqlConfigArgs'] sparksql_config: The config of SparkSql job
        :param pulumi.Input[Sequence[pulumi.Input['JobStatusArgs']]] statuses: The status of the job.
        """
        if driver_controls_files_uri is not None:
            pulumi.set(__self__, "driver_controls_files_uri", driver_controls_files_uri)
        if driver_output_resource_uri is not None:
            pulumi.set(__self__, "driver_output_resource_uri", driver_output_resource_uri)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if hadoop_config is not None:
            pulumi.set(__self__, "hadoop_config", hadoop_config)
        if hive_config is not None:
            pulumi.set(__self__, "hive_config", hive_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if pig_config is not None:
            pulumi.set(__self__, "pig_config", pig_config)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if presto_config is not None:
            pulumi.set(__self__, "presto_config", presto_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pyspark_config is not None:
            pulumi.set(__self__, "pyspark_config", pyspark_config)
        if reference is not None:
            pulumi.set(__self__, "reference", reference)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if spark_config is not None:
            pulumi.set(__self__, "spark_config", spark_config)
        if sparksql_config is not None:
            pulumi.set(__self__, "sparksql_config", sparksql_config)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="driverControlsFilesUri")
    def driver_controls_files_uri(self) -> Optional[pulumi.Input[str]]:
        """
        If present, the location of miscellaneous control files which may be used as part of job setup and handling. If not present, control files may be placed in the same location as driver_output_uri.
        """
        return pulumi.get(self, "driver_controls_files_uri")

    @driver_controls_files_uri.setter
    def driver_controls_files_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver_controls_files_uri", value)

    @property
    @pulumi.getter(name="driverOutputResourceUri")
    def driver_output_resource_uri(self) -> Optional[pulumi.Input[str]]:
        """
        A URI pointing to the location of the stdout of the job's driver program.
        """
        return pulumi.get(self, "driver_output_resource_uri")

    @driver_output_resource_uri.setter
    def driver_output_resource_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver_output_resource_uri", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        By default, you can only delete inactive jobs within
        Dataproc. Setting this to true, and calling destroy, will ensure that the
        job is first cancelled before issuing the delete.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="hadoopConfig")
    def hadoop_config(self) -> Optional[pulumi.Input['JobHadoopConfigArgs']]:
        """
        The config of Hadoop job
        """
        return pulumi.get(self, "hadoop_config")

    @hadoop_config.setter
    def hadoop_config(self, value: Optional[pulumi.Input['JobHadoopConfigArgs']]):
        pulumi.set(self, "hadoop_config", value)

    @property
    @pulumi.getter(name="hiveConfig")
    def hive_config(self) -> Optional[pulumi.Input['JobHiveConfigArgs']]:
        """
        The config of hive job
        """
        return pulumi.get(self, "hive_config")

    @hive_config.setter
    def hive_config(self, value: Optional[pulumi.Input['JobHiveConfigArgs']]):
        pulumi.set(self, "hive_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The list of labels (key/value pairs) to add to the job.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="pigConfig")
    def pig_config(self) -> Optional[pulumi.Input['JobPigConfigArgs']]:
        """
        The config of pag job.
        """
        return pulumi.get(self, "pig_config")

    @pig_config.setter
    def pig_config(self, value: Optional[pulumi.Input['JobPigConfigArgs']]):
        pulumi.set(self, "pig_config", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input['JobPlacementArgs']]:
        """
        The config of job placement.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input['JobPlacementArgs']]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="prestoConfig")
    def presto_config(self) -> Optional[pulumi.Input['JobPrestoConfigArgs']]:
        """
        The config of presto job
        """
        return pulumi.get(self, "presto_config")

    @presto_config.setter
    def presto_config(self, value: Optional[pulumi.Input['JobPrestoConfigArgs']]):
        pulumi.set(self, "presto_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project in which the `cluster` can be found and jobs
        subsequently run against. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pysparkConfig")
    def pyspark_config(self) -> Optional[pulumi.Input['JobPysparkConfigArgs']]:
        """
        The config of pySpark job.
        """
        return pulumi.get(self, "pyspark_config")

    @pyspark_config.setter
    def pyspark_config(self, value: Optional[pulumi.Input['JobPysparkConfigArgs']]):
        pulumi.set(self, "pyspark_config", value)

    @property
    @pulumi.getter
    def reference(self) -> Optional[pulumi.Input['JobReferenceArgs']]:
        """
        The reference of the job
        """
        return pulumi.get(self, "reference")

    @reference.setter
    def reference(self, value: Optional[pulumi.Input['JobReferenceArgs']]):
        pulumi.set(self, "reference", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Dataproc region. This essentially determines which clusters are available
        for this job to be submitted to. If not specified, defaults to `global`.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['JobSchedulingArgs']]:
        """
        Optional. Job scheduling configuration.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['JobSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="sparkConfig")
    def spark_config(self) -> Optional[pulumi.Input['JobSparkConfigArgs']]:
        """
        The config of the Spark job.
        """
        return pulumi.get(self, "spark_config")

    @spark_config.setter
    def spark_config(self, value: Optional[pulumi.Input['JobSparkConfigArgs']]):
        pulumi.set(self, "spark_config", value)

    @property
    @pulumi.getter(name="sparksqlConfig")
    def sparksql_config(self) -> Optional[pulumi.Input['JobSparksqlConfigArgs']]:
        """
        The config of SparkSql job
        """
        return pulumi.get(self, "sparksql_config")

    @sparksql_config.setter
    def sparksql_config(self, value: Optional[pulumi.Input['JobSparksqlConfigArgs']]):
        pulumi.set(self, "sparksql_config", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobStatusArgs']]]]:
        """
        The status of the job.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobStatusArgs']]]]):
        pulumi.set(self, "statuses", value)


class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 hadoop_config: Optional[pulumi.Input[pulumi.InputType['JobHadoopConfigArgs']]] = None,
                 hive_config: Optional[pulumi.Input[pulumi.InputType['JobHiveConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pig_config: Optional[pulumi.Input[pulumi.InputType['JobPigConfigArgs']]] = None,
                 placement: Optional[pulumi.Input[pulumi.InputType['JobPlacementArgs']]] = None,
                 presto_config: Optional[pulumi.Input[pulumi.InputType['JobPrestoConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pyspark_config: Optional[pulumi.Input[pulumi.InputType['JobPysparkConfigArgs']]] = None,
                 reference: Optional[pulumi.Input[pulumi.InputType['JobReferenceArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scheduling: Optional[pulumi.Input[pulumi.InputType['JobSchedulingArgs']]] = None,
                 spark_config: Optional[pulumi.Input[pulumi.InputType['JobSparkConfigArgs']]] = None,
                 sparksql_config: Optional[pulumi.Input[pulumi.InputType['JobSparksqlConfigArgs']]] = None,
                 __props__=None):
        """
        Manages a job resource within a Dataproc cluster within GCE. For more information see
        [the official dataproc documentation](https://cloud.google.com/dataproc/).

        !> **Note:** This resource does not support 'update' and changing any attributes will cause the resource to be recreated.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        mycluster = gcp.dataproc.Cluster("mycluster", region="us-central1")
        # Submit an example spark job to a dataproc cluster
        spark = gcp.dataproc.Job("spark",
            region=mycluster.region,
            force_delete=True,
            placement=gcp.dataproc.JobPlacementArgs(
                cluster_name=mycluster.name,
            ),
            spark_config=gcp.dataproc.JobSparkConfigArgs(
                main_class="org.apache.spark.examples.SparkPi",
                jar_file_uris=["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                args=["1000"],
                properties={
                    "spark.logConf": "true",
                },
                logging_config=gcp.dataproc.JobSparkConfigLoggingConfigArgs(
                    driver_log_levels={
                        "root": "INFO",
                    },
                ),
            ))
        # Submit an example pyspark job to a dataproc cluster
        pyspark = gcp.dataproc.Job("pyspark",
            region=mycluster.region,
            force_delete=True,
            placement=gcp.dataproc.JobPlacementArgs(
                cluster_name=mycluster.name,
            ),
            pyspark_config=gcp.dataproc.JobPysparkConfigArgs(
                main_python_file_uri="gs://dataproc-examples-2f10d78d114f6aaec76462e3c310f31f/src/pyspark/hello-world/hello-world.py",
                properties={
                    "spark.logConf": "true",
                },
            ))
        pulumi.export("sparkStatus", spark.statuses[0].state)
        pulumi.export("pysparkStatus", pyspark.statuses[0].state)
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] force_delete: By default, you can only delete inactive jobs within
               Dataproc. Setting this to true, and calling destroy, will ensure that the
               job is first cancelled before issuing the delete.
        :param pulumi.Input[pulumi.InputType['JobHadoopConfigArgs']] hadoop_config: The config of Hadoop job
        :param pulumi.Input[pulumi.InputType['JobHiveConfigArgs']] hive_config: The config of hive job
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The list of labels (key/value pairs) to add to the job.
        :param pulumi.Input[pulumi.InputType['JobPigConfigArgs']] pig_config: The config of pag job.
        :param pulumi.Input[pulumi.InputType['JobPlacementArgs']] placement: The config of job placement.
        :param pulumi.Input[pulumi.InputType['JobPrestoConfigArgs']] presto_config: The config of presto job
        :param pulumi.Input[str] project: The project in which the `cluster` can be found and jobs
               subsequently run against. If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['JobPysparkConfigArgs']] pyspark_config: The config of pySpark job.
        :param pulumi.Input[pulumi.InputType['JobReferenceArgs']] reference: The reference of the job
        :param pulumi.Input[str] region: The Cloud Dataproc region. This essentially determines which clusters are available
               for this job to be submitted to. If not specified, defaults to `global`.
        :param pulumi.Input[pulumi.InputType['JobSchedulingArgs']] scheduling: Optional. Job scheduling configuration.
        :param pulumi.Input[pulumi.InputType['JobSparkConfigArgs']] spark_config: The config of the Spark job.
        :param pulumi.Input[pulumi.InputType['JobSparksqlConfigArgs']] sparksql_config: The config of SparkSql job
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a job resource within a Dataproc cluster within GCE. For more information see
        [the official dataproc documentation](https://cloud.google.com/dataproc/).

        !> **Note:** This resource does not support 'update' and changing any attributes will cause the resource to be recreated.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        mycluster = gcp.dataproc.Cluster("mycluster", region="us-central1")
        # Submit an example spark job to a dataproc cluster
        spark = gcp.dataproc.Job("spark",
            region=mycluster.region,
            force_delete=True,
            placement=gcp.dataproc.JobPlacementArgs(
                cluster_name=mycluster.name,
            ),
            spark_config=gcp.dataproc.JobSparkConfigArgs(
                main_class="org.apache.spark.examples.SparkPi",
                jar_file_uris=["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                args=["1000"],
                properties={
                    "spark.logConf": "true",
                },
                logging_config=gcp.dataproc.JobSparkConfigLoggingConfigArgs(
                    driver_log_levels={
                        "root": "INFO",
                    },
                ),
            ))
        # Submit an example pyspark job to a dataproc cluster
        pyspark = gcp.dataproc.Job("pyspark",
            region=mycluster.region,
            force_delete=True,
            placement=gcp.dataproc.JobPlacementArgs(
                cluster_name=mycluster.name,
            ),
            pyspark_config=gcp.dataproc.JobPysparkConfigArgs(
                main_python_file_uri="gs://dataproc-examples-2f10d78d114f6aaec76462e3c310f31f/src/pyspark/hello-world/hello-world.py",
                properties={
                    "spark.logConf": "true",
                },
            ))
        pulumi.export("sparkStatus", spark.statuses[0].state)
        pulumi.export("pysparkStatus", pyspark.statuses[0].state)
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 hadoop_config: Optional[pulumi.Input[pulumi.InputType['JobHadoopConfigArgs']]] = None,
                 hive_config: Optional[pulumi.Input[pulumi.InputType['JobHiveConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pig_config: Optional[pulumi.Input[pulumi.InputType['JobPigConfigArgs']]] = None,
                 placement: Optional[pulumi.Input[pulumi.InputType['JobPlacementArgs']]] = None,
                 presto_config: Optional[pulumi.Input[pulumi.InputType['JobPrestoConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pyspark_config: Optional[pulumi.Input[pulumi.InputType['JobPysparkConfigArgs']]] = None,
                 reference: Optional[pulumi.Input[pulumi.InputType['JobReferenceArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scheduling: Optional[pulumi.Input[pulumi.InputType['JobSchedulingArgs']]] = None,
                 spark_config: Optional[pulumi.Input[pulumi.InputType['JobSparkConfigArgs']]] = None,
                 sparksql_config: Optional[pulumi.Input[pulumi.InputType['JobSparksqlConfigArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["hadoop_config"] = hadoop_config
            __props__.__dict__["hive_config"] = hive_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["pig_config"] = pig_config
            if placement is None and not opts.urn:
                raise TypeError("Missing required property 'placement'")
            __props__.__dict__["placement"] = placement
            __props__.__dict__["presto_config"] = presto_config
            __props__.__dict__["project"] = project
            __props__.__dict__["pyspark_config"] = pyspark_config
            __props__.__dict__["reference"] = reference
            __props__.__dict__["region"] = region
            __props__.__dict__["scheduling"] = scheduling
            __props__.__dict__["spark_config"] = spark_config
            __props__.__dict__["sparksql_config"] = sparksql_config
            __props__.__dict__["driver_controls_files_uri"] = None
            __props__.__dict__["driver_output_resource_uri"] = None
            __props__.__dict__["statuses"] = None
        super(Job, __self__).__init__(
            'gcp:dataproc/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            driver_controls_files_uri: Optional[pulumi.Input[str]] = None,
            driver_output_resource_uri: Optional[pulumi.Input[str]] = None,
            force_delete: Optional[pulumi.Input[bool]] = None,
            hadoop_config: Optional[pulumi.Input[pulumi.InputType['JobHadoopConfigArgs']]] = None,
            hive_config: Optional[pulumi.Input[pulumi.InputType['JobHiveConfigArgs']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            pig_config: Optional[pulumi.Input[pulumi.InputType['JobPigConfigArgs']]] = None,
            placement: Optional[pulumi.Input[pulumi.InputType['JobPlacementArgs']]] = None,
            presto_config: Optional[pulumi.Input[pulumi.InputType['JobPrestoConfigArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            pyspark_config: Optional[pulumi.Input[pulumi.InputType['JobPysparkConfigArgs']]] = None,
            reference: Optional[pulumi.Input[pulumi.InputType['JobReferenceArgs']]] = None,
            region: Optional[pulumi.Input[str]] = None,
            scheduling: Optional[pulumi.Input[pulumi.InputType['JobSchedulingArgs']]] = None,
            spark_config: Optional[pulumi.Input[pulumi.InputType['JobSparkConfigArgs']]] = None,
            sparksql_config: Optional[pulumi.Input[pulumi.InputType['JobSparksqlConfigArgs']]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobStatusArgs']]]]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] driver_controls_files_uri: If present, the location of miscellaneous control files which may be used as part of job setup and handling. If not present, control files may be placed in the same location as driver_output_uri.
        :param pulumi.Input[str] driver_output_resource_uri: A URI pointing to the location of the stdout of the job's driver program.
        :param pulumi.Input[bool] force_delete: By default, you can only delete inactive jobs within
               Dataproc. Setting this to true, and calling destroy, will ensure that the
               job is first cancelled before issuing the delete.
        :param pulumi.Input[pulumi.InputType['JobHadoopConfigArgs']] hadoop_config: The config of Hadoop job
        :param pulumi.Input[pulumi.InputType['JobHiveConfigArgs']] hive_config: The config of hive job
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The list of labels (key/value pairs) to add to the job.
        :param pulumi.Input[pulumi.InputType['JobPigConfigArgs']] pig_config: The config of pag job.
        :param pulumi.Input[pulumi.InputType['JobPlacementArgs']] placement: The config of job placement.
        :param pulumi.Input[pulumi.InputType['JobPrestoConfigArgs']] presto_config: The config of presto job
        :param pulumi.Input[str] project: The project in which the `cluster` can be found and jobs
               subsequently run against. If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['JobPysparkConfigArgs']] pyspark_config: The config of pySpark job.
        :param pulumi.Input[pulumi.InputType['JobReferenceArgs']] reference: The reference of the job
        :param pulumi.Input[str] region: The Cloud Dataproc region. This essentially determines which clusters are available
               for this job to be submitted to. If not specified, defaults to `global`.
        :param pulumi.Input[pulumi.InputType['JobSchedulingArgs']] scheduling: Optional. Job scheduling configuration.
        :param pulumi.Input[pulumi.InputType['JobSparkConfigArgs']] spark_config: The config of the Spark job.
        :param pulumi.Input[pulumi.InputType['JobSparksqlConfigArgs']] sparksql_config: The config of SparkSql job
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobStatusArgs']]]] statuses: The status of the job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["driver_controls_files_uri"] = driver_controls_files_uri
        __props__.__dict__["driver_output_resource_uri"] = driver_output_resource_uri
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["hadoop_config"] = hadoop_config
        __props__.__dict__["hive_config"] = hive_config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["pig_config"] = pig_config
        __props__.__dict__["placement"] = placement
        __props__.__dict__["presto_config"] = presto_config
        __props__.__dict__["project"] = project
        __props__.__dict__["pyspark_config"] = pyspark_config
        __props__.__dict__["reference"] = reference
        __props__.__dict__["region"] = region
        __props__.__dict__["scheduling"] = scheduling
        __props__.__dict__["spark_config"] = spark_config
        __props__.__dict__["sparksql_config"] = sparksql_config
        __props__.__dict__["statuses"] = statuses
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="driverControlsFilesUri")
    def driver_controls_files_uri(self) -> pulumi.Output[str]:
        """
        If present, the location of miscellaneous control files which may be used as part of job setup and handling. If not present, control files may be placed in the same location as driver_output_uri.
        """
        return pulumi.get(self, "driver_controls_files_uri")

    @property
    @pulumi.getter(name="driverOutputResourceUri")
    def driver_output_resource_uri(self) -> pulumi.Output[str]:
        """
        A URI pointing to the location of the stdout of the job's driver program.
        """
        return pulumi.get(self, "driver_output_resource_uri")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[bool]]:
        """
        By default, you can only delete inactive jobs within
        Dataproc. Setting this to true, and calling destroy, will ensure that the
        job is first cancelled before issuing the delete.
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter(name="hadoopConfig")
    def hadoop_config(self) -> pulumi.Output[Optional['outputs.JobHadoopConfig']]:
        """
        The config of Hadoop job
        """
        return pulumi.get(self, "hadoop_config")

    @property
    @pulumi.getter(name="hiveConfig")
    def hive_config(self) -> pulumi.Output[Optional['outputs.JobHiveConfig']]:
        """
        The config of hive job
        """
        return pulumi.get(self, "hive_config")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The list of labels (key/value pairs) to add to the job.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="pigConfig")
    def pig_config(self) -> pulumi.Output[Optional['outputs.JobPigConfig']]:
        """
        The config of pag job.
        """
        return pulumi.get(self, "pig_config")

    @property
    @pulumi.getter
    def placement(self) -> pulumi.Output['outputs.JobPlacement']:
        """
        The config of job placement.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="prestoConfig")
    def presto_config(self) -> pulumi.Output[Optional['outputs.JobPrestoConfig']]:
        """
        The config of presto job
        """
        return pulumi.get(self, "presto_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project in which the `cluster` can be found and jobs
        subsequently run against. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pysparkConfig")
    def pyspark_config(self) -> pulumi.Output[Optional['outputs.JobPysparkConfig']]:
        """
        The config of pySpark job.
        """
        return pulumi.get(self, "pyspark_config")

    @property
    @pulumi.getter
    def reference(self) -> pulumi.Output['outputs.JobReference']:
        """
        The reference of the job
        """
        return pulumi.get(self, "reference")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The Cloud Dataproc region. This essentially determines which clusters are available
        for this job to be submitted to. If not specified, defaults to `global`.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def scheduling(self) -> pulumi.Output[Optional['outputs.JobScheduling']]:
        """
        Optional. Job scheduling configuration.
        """
        return pulumi.get(self, "scheduling")

    @property
    @pulumi.getter(name="sparkConfig")
    def spark_config(self) -> pulumi.Output[Optional['outputs.JobSparkConfig']]:
        """
        The config of the Spark job.
        """
        return pulumi.get(self, "spark_config")

    @property
    @pulumi.getter(name="sparksqlConfig")
    def sparksql_config(self) -> pulumi.Output[Optional['outputs.JobSparksqlConfig']]:
        """
        The config of SparkSql job
        """
        return pulumi.get(self, "sparksql_config")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.JobStatus']]:
        """
        The status of the job.
        """
        return pulumi.get(self, "statuses")

