# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OsPolicyAssignmentArgs', 'OsPolicyAssignment']

@pulumi.input_type
class OsPolicyAssignmentArgs:
    def __init__(__self__, *,
                 instance_filter: pulumi.Input['OsPolicyAssignmentInstanceFilterArgs'],
                 location: pulumi.Input[str],
                 os_policies: pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]],
                 rollout: pulumi.Input['OsPolicyAssignmentRolloutArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OsPolicyAssignment resource.
        :param pulumi.Input['OsPolicyAssignmentInstanceFilterArgs'] instance_filter: Required. Filter to select VMs.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]] os_policies: Required. List of OS policies to be applied to the VMs.
        :param pulumi.Input['OsPolicyAssignmentRolloutArgs'] rollout: Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        :param pulumi.Input[str] description: OS policy assignment description. Length of the description is limited to 1024 characters.
        :param pulumi.Input[str] name: Required. The name of the repository.
        :param pulumi.Input[str] project: The project for the resource
        """
        pulumi.set(__self__, "instance_filter", instance_filter)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "os_policies", os_policies)
        pulumi.set(__self__, "rollout", rollout)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="instanceFilter")
    def instance_filter(self) -> pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']:
        """
        Required. Filter to select VMs.
        """
        return pulumi.get(self, "instance_filter")

    @instance_filter.setter
    def instance_filter(self, value: pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']):
        pulumi.set(self, "instance_filter", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="osPolicies")
    def os_policies(self) -> pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]:
        """
        Required. List of OS policies to be applied to the VMs.
        """
        return pulumi.get(self, "os_policies")

    @os_policies.setter
    def os_policies(self, value: pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]):
        pulumi.set(self, "os_policies", value)

    @property
    @pulumi.getter
    def rollout(self) -> pulumi.Input['OsPolicyAssignmentRolloutArgs']:
        """
        Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        """
        return pulumi.get(self, "rollout")

    @rollout.setter
    def rollout(self, value: pulumi.Input['OsPolicyAssignmentRolloutArgs']):
        pulumi.set(self, "rollout", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        OS policy assignment description. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The name of the repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _OsPolicyAssignmentState:
    def __init__(__self__, *,
                 baseline: Optional[pulumi.Input[bool]] = None,
                 deleted: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 instance_filter: Optional[pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_policies: Optional[pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reconciling: Optional[pulumi.Input[bool]] = None,
                 revision_create_time: Optional[pulumi.Input[str]] = None,
                 revision_id: Optional[pulumi.Input[str]] = None,
                 rollout: Optional[pulumi.Input['OsPolicyAssignmentRolloutArgs']] = None,
                 rollout_state: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OsPolicyAssignment resources.
        :param pulumi.Input[bool] baseline: Output only. Indicates that this revision has been successfully rolled out in this zone and new VMs will be assigned OS
               policies from this revision. For a given OS policy assignment, there is only one revision with a value of `true` for
               this field.
        :param pulumi.Input[bool] deleted: Output only. Indicates that this revision deletes the OS policy assignment.
        :param pulumi.Input[str] description: OS policy assignment description. Length of the description is limited to 1024 characters.
        :param pulumi.Input[str] etag: The etag for this OS policy assignment. If this is provided on update, it must match the server's etag.
        :param pulumi.Input['OsPolicyAssignmentInstanceFilterArgs'] instance_filter: Required. Filter to select VMs.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Required. The name of the repository.
        :param pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]] os_policies: Required. List of OS policies to be applied to the VMs.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[bool] reconciling: Output only. Indicates that reconciliation is in progress for the revision. This value is `true` when the
               `rollout_state` is one of: * IN_PROGRESS * CANCELLING
        :param pulumi.Input[str] revision_create_time: Output only. The timestamp that the revision was created.
        :param pulumi.Input[str] revision_id: Output only. The assignment revision ID A new revision is committed whenever a rollout is triggered for a OS policy
               assignment
        :param pulumi.Input['OsPolicyAssignmentRolloutArgs'] rollout: Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        :param pulumi.Input[str] rollout_state: Output only. OS policy assignment rollout state Possible values: ROLLOUT_STATE_UNSPECIFIED, IN_PROGRESS, CANCELLING,
               CANCELLED, SUCCEEDED
        :param pulumi.Input[str] uid: Output only. Server generated unique id for the OS policy assignment resource.
        """
        if baseline is not None:
            pulumi.set(__self__, "baseline", baseline)
        if deleted is not None:
            pulumi.set(__self__, "deleted", deleted)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if instance_filter is not None:
            pulumi.set(__self__, "instance_filter", instance_filter)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_policies is not None:
            pulumi.set(__self__, "os_policies", os_policies)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if revision_create_time is not None:
            pulumi.set(__self__, "revision_create_time", revision_create_time)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)
        if rollout is not None:
            pulumi.set(__self__, "rollout", rollout)
        if rollout_state is not None:
            pulumi.set(__self__, "rollout_state", rollout_state)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def baseline(self) -> Optional[pulumi.Input[bool]]:
        """
        Output only. Indicates that this revision has been successfully rolled out in this zone and new VMs will be assigned OS
        policies from this revision. For a given OS policy assignment, there is only one revision with a value of `true` for
        this field.
        """
        return pulumi.get(self, "baseline")

    @baseline.setter
    def baseline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "baseline", value)

    @property
    @pulumi.getter
    def deleted(self) -> Optional[pulumi.Input[bool]]:
        """
        Output only. Indicates that this revision deletes the OS policy assignment.
        """
        return pulumi.get(self, "deleted")

    @deleted.setter
    def deleted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deleted", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        OS policy assignment description. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        The etag for this OS policy assignment. If this is provided on update, it must match the server's etag.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="instanceFilter")
    def instance_filter(self) -> Optional[pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']]:
        """
        Required. Filter to select VMs.
        """
        return pulumi.get(self, "instance_filter")

    @instance_filter.setter
    def instance_filter(self, value: Optional[pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']]):
        pulumi.set(self, "instance_filter", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The name of the repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osPolicies")
    def os_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]]:
        """
        Required. List of OS policies to be applied to the VMs.
        """
        return pulumi.get(self, "os_policies")

    @os_policies.setter
    def os_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]]):
        pulumi.set(self, "os_policies", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[bool]]:
        """
        Output only. Indicates that reconciliation is in progress for the revision. This value is `true` when the
        `rollout_state` is one of: * IN_PROGRESS * CANCELLING
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The timestamp that the revision was created.
        """
        return pulumi.get(self, "revision_create_time")

    @revision_create_time.setter
    def revision_create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_create_time", value)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The assignment revision ID A new revision is committed whenever a rollout is triggered for a OS policy
        assignment
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_id", value)

    @property
    @pulumi.getter
    def rollout(self) -> Optional[pulumi.Input['OsPolicyAssignmentRolloutArgs']]:
        """
        Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        """
        return pulumi.get(self, "rollout")

    @rollout.setter
    def rollout(self, value: Optional[pulumi.Input['OsPolicyAssignmentRolloutArgs']]):
        pulumi.set(self, "rollout", value)

    @property
    @pulumi.getter(name="rolloutState")
    def rollout_state(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. OS policy assignment rollout state Possible values: ROLLOUT_STATE_UNSPECIFIED, IN_PROGRESS, CANCELLING,
        CANCELLED, SUCCEEDED
        """
        return pulumi.get(self, "rollout_state")

    @rollout_state.setter
    def rollout_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rollout_state", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Server generated unique id for the OS policy assignment resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


class OsPolicyAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_filter: Optional[pulumi.Input[pulumi.InputType['OsPolicyAssignmentInstanceFilterArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OsPolicyAssignmentOsPolicyArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rollout: Optional[pulumi.Input[pulumi.InputType['OsPolicyAssignmentRolloutArgs']]] = None,
                 __props__=None):
        """
        Represents an OSPolicyAssignment resource.

        ## Example Usage
        ### Fixed_os_policy_assignment
        An example of an osconfig os policy assignment with fixed rollout disruption budget
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.osconfig.OsPolicyAssignment("primary",
            description="A test os policy assignment",
            instance_filter=gcp.osconfig.OsPolicyAssignmentInstanceFilterArgs(
                all=False,
                exclusion_labels=[gcp.osconfig.OsPolicyAssignmentInstanceFilterExclusionLabelArgs(
                    labels={
                        "label-two": "value-two",
                    },
                )],
                inclusion_labels=[gcp.osconfig.OsPolicyAssignmentInstanceFilterInclusionLabelArgs(
                    labels={
                        "label-one": "value-one",
                    },
                )],
                inventories=[gcp.osconfig.OsPolicyAssignmentInstanceFilterInventoryArgs(
                    os_short_name="centos",
                    os_version="8.*",
                )],
            ),
            location="us-west1-a",
            os_policies=[gcp.osconfig.OsPolicyAssignmentOsPolicyArgs(
                allow_no_resource_group_match=False,
                description="A test os policy",
                id="policy",
                mode="VALIDATION",
                resource_groups=[
                    gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupArgs(
                        inventory_filters=[gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupInventoryFilterArgs(
                            os_short_name="centos",
                            os_version="8.*",
                        )],
                        resources=[
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="apt",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    apt=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgAptArgs(
                                        name="bazel",
                                    ),
                                    desired_state="INSTALLED",
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="deb1",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    deb=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebArgs(
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceArgs(
                                            local_path="$HOME/package.deb",
                                        ),
                                    ),
                                    desired_state="INSTALLED",
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="deb2",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    deb=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebArgs(
                                        pull_deps=True,
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceArgs(
                                            allow_insecure=True,
                                            remote=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceRemoteArgs(
                                                sha256_checksum="3bbfd1043cd7afdb78cf9afec36c0c5370d2fea98166537b4e67f3816f256025",
                                                uri="ftp.us.debian.org/debian/package.deb",
                                            ),
                                        ),
                                    ),
                                    desired_state="INSTALLED",
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="deb3",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    deb=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebArgs(
                                        pull_deps=True,
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceArgs(
                                            gcs=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceGcsArgs(
                                                bucket="test-bucket",
                                                generation=1,
                                                object="test-object",
                                            ),
                                        ),
                                    ),
                                    desired_state="INSTALLED",
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="yum",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    yum=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgYumArgs(
                                        name="gstreamer-plugins-base-devel.x86_64",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="zypper",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    zypper=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgZypperArgs(
                                        name="gcc",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="rpm1",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    rpm=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmArgs(
                                        pull_deps=True,
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceArgs(
                                            local_path="$HOME/package.rpm",
                                        ),
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="rpm2",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    rpm=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmArgs(
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceArgs(
                                            allow_insecure=True,
                                            remote=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceRemoteArgs(
                                                sha256_checksum="3bbfd1043cd7afdb78cf9afec36c0c5370d2fea98166537b4e67f3816f256025",
                                                uri="https://mirror.jaleco.com/centos/8.3.2011/BaseOS/x86_64/os/Packages/efi-filesystem-3-2.el8.noarch.rpm",
                                            ),
                                        ),
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="rpm3",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    rpm=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmArgs(
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceArgs(
                                            gcs=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceGcsArgs(
                                                bucket="test-bucket",
                                                generation=1,
                                                object="test-object",
                                            ),
                                        ),
                                    ),
                                ),
                            ),
                        ],
                    ),
                    gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupArgs(
                        resources=[
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="apt-to-deb",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    apt=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgAptArgs(
                                        name="bazel",
                                    ),
                                    desired_state="INSTALLED",
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="deb-local-path-to-gcs",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    deb=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebArgs(
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceArgs(
                                            local_path="$HOME/package.deb",
                                        ),
                                    ),
                                    desired_state="INSTALLED",
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="googet",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    googet=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgGoogetArgs(
                                        name="gcc",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="msi1",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    msi=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiArgs(
                                        properties=["REBOOT=ReallySuppress"],
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceArgs(
                                            local_path="$HOME/package.msi",
                                        ),
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="msi2",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    msi=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiArgs(
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceArgs(
                                            allow_insecure=True,
                                            remote=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceRemoteArgs(
                                                sha256_checksum="3bbfd1043cd7afdb78cf9afec36c0c5370d2fea98166537b4e67f3816f256025",
                                                uri="https://remote.uri.com/package.msi",
                                            ),
                                        ),
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="msi3",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    msi=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiArgs(
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceArgs(
                                            gcs=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceGcsArgs(
                                                bucket="test-bucket",
                                                generation=1,
                                                object="test-object",
                                            ),
                                        ),
                                    ),
                                ),
                            ),
                        ],
                    ),
                ],
            )],
            project="my-project-name",
            rollout=gcp.osconfig.OsPolicyAssignmentRolloutArgs(
                disruption_budget=gcp.osconfig.OsPolicyAssignmentRolloutDisruptionBudgetArgs(
                    fixed=1,
                ),
                min_wait_duration="3.5s",
            ))
        ```
        ### Percent_os_policy_assignment
        An example of an osconfig os policy assignment with percent rollout disruption budget
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.osconfig.OsPolicyAssignment("primary",
            description="A test os policy assignment",
            instance_filter=gcp.osconfig.OsPolicyAssignmentInstanceFilterArgs(
                all=True,
            ),
            location="us-west1-a",
            os_policies=[gcp.osconfig.OsPolicyAssignmentOsPolicyArgs(
                id="policy",
                mode="VALIDATION",
                resource_groups=[
                    gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupArgs(
                        resources=[
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="apt-to-yum",
                                repository=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryArgs(
                                    apt=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryAptArgs(
                                        archive_type="DEB",
                                        components=["doc"],
                                        distribution="debian",
                                        gpg_key=".gnupg/pubring.kbx",
                                        uri="https://atl.mirrors.clouvider.net/debian",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="yum",
                                repository=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryArgs(
                                    yum=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryYumArgs(
                                        base_url="http://centos.s.uw.edu/centos/",
                                        display_name="yum",
                                        gpg_keys=["RPM-GPG-KEY-CentOS-7"],
                                        id="yum",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="zypper",
                                repository=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryArgs(
                                    zypper=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryZypperArgs(
                                        base_url="http://mirror.dal10.us.leaseweb.net/opensuse",
                                        display_name="zypper",
                                        gpg_keys=["sample-key-uri"],
                                        id="zypper",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="goo",
                                repository=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryArgs(
                                    goo=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryGooArgs(
                                        name="goo",
                                        url="https://foo.com/googet/bar",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                exec_=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecArgs(
                                    enforce=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceArgs(
                                        args=["arg1"],
                                        file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileArgs(
                                            allow_insecure=True,
                                            remote=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileRemoteArgs(
                                                sha256_checksum="c7938fed83afdccbb0e86a2a2e4cad7d5035012ca3214b4a61268393635c3063",
                                                uri="https://www.example.com/script.sh",
                                            ),
                                        ),
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                    ),
                                    validate=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateArgs(
                                        args=["arg1"],
                                        file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileArgs(
                                            local_path="$HOME/script.sh",
                                        ),
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                    ),
                                ),
                                id="exec1",
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                exec_=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecArgs(
                                    enforce=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceArgs(
                                        args=["arg1"],
                                        file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileArgs(
                                            local_path="$HOME/script.sh",
                                        ),
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                    ),
                                    validate=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateArgs(
                                        args=["arg1"],
                                        file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileArgs(
                                            allow_insecure=True,
                                            remote=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileRemoteArgs(
                                                sha256_checksum="c7938fed83afdccbb0e86a2a2e4cad7d5035012ca3214b4a61268393635c3063",
                                                uri="https://www.example.com/script.sh",
                                            ),
                                        ),
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                    ),
                                ),
                                id="exec2",
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                exec_=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecArgs(
                                    enforce=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceArgs(
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                        script="pwd",
                                    ),
                                    validate=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateArgs(
                                        file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileArgs(
                                            allow_insecure=True,
                                            gcs=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileGcsArgs(
                                                bucket="test-bucket",
                                                generation=1,
                                                object="test-object",
                                            ),
                                        ),
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                    ),
                                ),
                                id="exec3",
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                exec_=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecArgs(
                                    enforce=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceArgs(
                                        file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileArgs(
                                            allow_insecure=True,
                                            gcs=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileGcsArgs(
                                                bucket="test-bucket",
                                                generation=1,
                                                object="test-object",
                                            ),
                                        ),
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                    ),
                                    validate=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateArgs(
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                        script="pwd",
                                    ),
                                ),
                                id="exec4",
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileArgs(
                                    file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileArgs(
                                        local_path="$HOME/file",
                                    ),
                                    path="$HOME/file",
                                    state="PRESENT",
                                ),
                                id="file1",
                            ),
                        ],
                    ),
                    gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupArgs(
                        resources=[
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileArgs(
                                    file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileArgs(
                                        allow_insecure=True,
                                        remote=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileRemoteArgs(
                                            sha256_checksum="c7938fed83afdccbb0e86a2a2e4cad7d5035012ca3214b4a61268393635c3063",
                                            uri="https://www.example.com/file",
                                        ),
                                    ),
                                    path="$HOME/file",
                                    state="PRESENT",
                                ),
                                id="file2",
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileArgs(
                                    file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileArgs(
                                        gcs=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileGcsArgs(
                                            bucket="test-bucket",
                                            generation=1,
                                            object="test-object",
                                        ),
                                    ),
                                    path="$HOME/file",
                                    state="PRESENT",
                                ),
                                id="file3",
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileArgs(
                                    content="sample-content",
                                    path="$HOME/file",
                                    state="PRESENT",
                                ),
                                id="file4",
                            ),
                        ],
                    ),
                ],
            )],
            project="my-project-name",
            rollout=gcp.osconfig.OsPolicyAssignmentRolloutArgs(
                disruption_budget=gcp.osconfig.OsPolicyAssignmentRolloutDisruptionBudgetArgs(
                    percent=1,
                ),
                min_wait_duration="3.5s",
            ))
        ```

        ## Import

        OSPolicyAssignment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default projects/{{project}}/locations/{{location}}/osPolicyAssignments/{{name}}
        ```

        ```sh
         $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: OS policy assignment description. Length of the description is limited to 1024 characters.
        :param pulumi.Input[pulumi.InputType['OsPolicyAssignmentInstanceFilterArgs']] instance_filter: Required. Filter to select VMs.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Required. The name of the repository.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OsPolicyAssignmentOsPolicyArgs']]]] os_policies: Required. List of OS policies to be applied to the VMs.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[pulumi.InputType['OsPolicyAssignmentRolloutArgs']] rollout: Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OsPolicyAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an OSPolicyAssignment resource.

        ## Example Usage
        ### Fixed_os_policy_assignment
        An example of an osconfig os policy assignment with fixed rollout disruption budget
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.osconfig.OsPolicyAssignment("primary",
            description="A test os policy assignment",
            instance_filter=gcp.osconfig.OsPolicyAssignmentInstanceFilterArgs(
                all=False,
                exclusion_labels=[gcp.osconfig.OsPolicyAssignmentInstanceFilterExclusionLabelArgs(
                    labels={
                        "label-two": "value-two",
                    },
                )],
                inclusion_labels=[gcp.osconfig.OsPolicyAssignmentInstanceFilterInclusionLabelArgs(
                    labels={
                        "label-one": "value-one",
                    },
                )],
                inventories=[gcp.osconfig.OsPolicyAssignmentInstanceFilterInventoryArgs(
                    os_short_name="centos",
                    os_version="8.*",
                )],
            ),
            location="us-west1-a",
            os_policies=[gcp.osconfig.OsPolicyAssignmentOsPolicyArgs(
                allow_no_resource_group_match=False,
                description="A test os policy",
                id="policy",
                mode="VALIDATION",
                resource_groups=[
                    gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupArgs(
                        inventory_filters=[gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupInventoryFilterArgs(
                            os_short_name="centos",
                            os_version="8.*",
                        )],
                        resources=[
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="apt",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    apt=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgAptArgs(
                                        name="bazel",
                                    ),
                                    desired_state="INSTALLED",
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="deb1",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    deb=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebArgs(
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceArgs(
                                            local_path="$HOME/package.deb",
                                        ),
                                    ),
                                    desired_state="INSTALLED",
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="deb2",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    deb=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebArgs(
                                        pull_deps=True,
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceArgs(
                                            allow_insecure=True,
                                            remote=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceRemoteArgs(
                                                sha256_checksum="3bbfd1043cd7afdb78cf9afec36c0c5370d2fea98166537b4e67f3816f256025",
                                                uri="ftp.us.debian.org/debian/package.deb",
                                            ),
                                        ),
                                    ),
                                    desired_state="INSTALLED",
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="deb3",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    deb=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebArgs(
                                        pull_deps=True,
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceArgs(
                                            gcs=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceGcsArgs(
                                                bucket="test-bucket",
                                                generation=1,
                                                object="test-object",
                                            ),
                                        ),
                                    ),
                                    desired_state="INSTALLED",
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="yum",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    yum=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgYumArgs(
                                        name="gstreamer-plugins-base-devel.x86_64",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="zypper",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    zypper=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgZypperArgs(
                                        name="gcc",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="rpm1",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    rpm=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmArgs(
                                        pull_deps=True,
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceArgs(
                                            local_path="$HOME/package.rpm",
                                        ),
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="rpm2",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    rpm=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmArgs(
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceArgs(
                                            allow_insecure=True,
                                            remote=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceRemoteArgs(
                                                sha256_checksum="3bbfd1043cd7afdb78cf9afec36c0c5370d2fea98166537b4e67f3816f256025",
                                                uri="https://mirror.jaleco.com/centos/8.3.2011/BaseOS/x86_64/os/Packages/efi-filesystem-3-2.el8.noarch.rpm",
                                            ),
                                        ),
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="rpm3",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    rpm=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmArgs(
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceArgs(
                                            gcs=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgRpmSourceGcsArgs(
                                                bucket="test-bucket",
                                                generation=1,
                                                object="test-object",
                                            ),
                                        ),
                                    ),
                                ),
                            ),
                        ],
                    ),
                    gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupArgs(
                        resources=[
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="apt-to-deb",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    apt=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgAptArgs(
                                        name="bazel",
                                    ),
                                    desired_state="INSTALLED",
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="deb-local-path-to-gcs",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    deb=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebArgs(
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgDebSourceArgs(
                                            local_path="$HOME/package.deb",
                                        ),
                                    ),
                                    desired_state="INSTALLED",
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="googet",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    googet=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgGoogetArgs(
                                        name="gcc",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="msi1",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    msi=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiArgs(
                                        properties=["REBOOT=ReallySuppress"],
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceArgs(
                                            local_path="$HOME/package.msi",
                                        ),
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="msi2",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    msi=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiArgs(
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceArgs(
                                            allow_insecure=True,
                                            remote=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceRemoteArgs(
                                                sha256_checksum="3bbfd1043cd7afdb78cf9afec36c0c5370d2fea98166537b4e67f3816f256025",
                                                uri="https://remote.uri.com/package.msi",
                                            ),
                                        ),
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="msi3",
                                pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                                    desired_state="INSTALLED",
                                    msi=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiArgs(
                                        source=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceArgs(
                                            gcs=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgMsiSourceGcsArgs(
                                                bucket="test-bucket",
                                                generation=1,
                                                object="test-object",
                                            ),
                                        ),
                                    ),
                                ),
                            ),
                        ],
                    ),
                ],
            )],
            project="my-project-name",
            rollout=gcp.osconfig.OsPolicyAssignmentRolloutArgs(
                disruption_budget=gcp.osconfig.OsPolicyAssignmentRolloutDisruptionBudgetArgs(
                    fixed=1,
                ),
                min_wait_duration="3.5s",
            ))
        ```
        ### Percent_os_policy_assignment
        An example of an osconfig os policy assignment with percent rollout disruption budget
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.osconfig.OsPolicyAssignment("primary",
            description="A test os policy assignment",
            instance_filter=gcp.osconfig.OsPolicyAssignmentInstanceFilterArgs(
                all=True,
            ),
            location="us-west1-a",
            os_policies=[gcp.osconfig.OsPolicyAssignmentOsPolicyArgs(
                id="policy",
                mode="VALIDATION",
                resource_groups=[
                    gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupArgs(
                        resources=[
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="apt-to-yum",
                                repository=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryArgs(
                                    apt=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryAptArgs(
                                        archive_type="DEB",
                                        components=["doc"],
                                        distribution="debian",
                                        gpg_key=".gnupg/pubring.kbx",
                                        uri="https://atl.mirrors.clouvider.net/debian",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="yum",
                                repository=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryArgs(
                                    yum=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryYumArgs(
                                        base_url="http://centos.s.uw.edu/centos/",
                                        display_name="yum",
                                        gpg_keys=["RPM-GPG-KEY-CentOS-7"],
                                        id="yum",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="zypper",
                                repository=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryArgs(
                                    zypper=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryZypperArgs(
                                        base_url="http://mirror.dal10.us.leaseweb.net/opensuse",
                                        display_name="zypper",
                                        gpg_keys=["sample-key-uri"],
                                        id="zypper",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                id="goo",
                                repository=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryArgs(
                                    goo=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceRepositoryGooArgs(
                                        name="goo",
                                        url="https://foo.com/googet/bar",
                                    ),
                                ),
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                exec_=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecArgs(
                                    enforce=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceArgs(
                                        args=["arg1"],
                                        file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileArgs(
                                            allow_insecure=True,
                                            remote=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileRemoteArgs(
                                                sha256_checksum="c7938fed83afdccbb0e86a2a2e4cad7d5035012ca3214b4a61268393635c3063",
                                                uri="https://www.example.com/script.sh",
                                            ),
                                        ),
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                    ),
                                    validate=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateArgs(
                                        args=["arg1"],
                                        file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileArgs(
                                            local_path="$HOME/script.sh",
                                        ),
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                    ),
                                ),
                                id="exec1",
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                exec_=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecArgs(
                                    enforce=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceArgs(
                                        args=["arg1"],
                                        file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileArgs(
                                            local_path="$HOME/script.sh",
                                        ),
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                    ),
                                    validate=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateArgs(
                                        args=["arg1"],
                                        file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileArgs(
                                            allow_insecure=True,
                                            remote=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileRemoteArgs(
                                                sha256_checksum="c7938fed83afdccbb0e86a2a2e4cad7d5035012ca3214b4a61268393635c3063",
                                                uri="https://www.example.com/script.sh",
                                            ),
                                        ),
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                    ),
                                ),
                                id="exec2",
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                exec_=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecArgs(
                                    enforce=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceArgs(
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                        script="pwd",
                                    ),
                                    validate=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateArgs(
                                        file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileArgs(
                                            allow_insecure=True,
                                            gcs=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateFileGcsArgs(
                                                bucket="test-bucket",
                                                generation=1,
                                                object="test-object",
                                            ),
                                        ),
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                    ),
                                ),
                                id="exec3",
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                exec_=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecArgs(
                                    enforce=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceArgs(
                                        file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileArgs(
                                            allow_insecure=True,
                                            gcs=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecEnforceFileGcsArgs(
                                                bucket="test-bucket",
                                                generation=1,
                                                object="test-object",
                                            ),
                                        ),
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                    ),
                                    validate=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceExecValidateArgs(
                                        interpreter="SHELL",
                                        output_file_path="$HOME/out",
                                        script="pwd",
                                    ),
                                ),
                                id="exec4",
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileArgs(
                                    file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileArgs(
                                        local_path="$HOME/file",
                                    ),
                                    path="$HOME/file",
                                    state="PRESENT",
                                ),
                                id="file1",
                            ),
                        ],
                    ),
                    gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupArgs(
                        resources=[
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileArgs(
                                    file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileArgs(
                                        allow_insecure=True,
                                        remote=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileRemoteArgs(
                                            sha256_checksum="c7938fed83afdccbb0e86a2a2e4cad7d5035012ca3214b4a61268393635c3063",
                                            uri="https://www.example.com/file",
                                        ),
                                    ),
                                    path="$HOME/file",
                                    state="PRESENT",
                                ),
                                id="file2",
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileArgs(
                                    file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileArgs(
                                        gcs=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileFileGcsArgs(
                                            bucket="test-bucket",
                                            generation=1,
                                            object="test-object",
                                        ),
                                    ),
                                    path="$HOME/file",
                                    state="PRESENT",
                                ),
                                id="file3",
                            ),
                            gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                                file=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceFileArgs(
                                    content="sample-content",
                                    path="$HOME/file",
                                    state="PRESENT",
                                ),
                                id="file4",
                            ),
                        ],
                    ),
                ],
            )],
            project="my-project-name",
            rollout=gcp.osconfig.OsPolicyAssignmentRolloutArgs(
                disruption_budget=gcp.osconfig.OsPolicyAssignmentRolloutDisruptionBudgetArgs(
                    percent=1,
                ),
                min_wait_duration="3.5s",
            ))
        ```

        ## Import

        OSPolicyAssignment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default projects/{{project}}/locations/{{location}}/osPolicyAssignments/{{name}}
        ```

        ```sh
         $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param OsPolicyAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OsPolicyAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_filter: Optional[pulumi.Input[pulumi.InputType['OsPolicyAssignmentInstanceFilterArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OsPolicyAssignmentOsPolicyArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rollout: Optional[pulumi.Input[pulumi.InputType['OsPolicyAssignmentRolloutArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OsPolicyAssignmentArgs.__new__(OsPolicyAssignmentArgs)

            __props__.__dict__["description"] = description
            if instance_filter is None and not opts.urn:
                raise TypeError("Missing required property 'instance_filter'")
            __props__.__dict__["instance_filter"] = instance_filter
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if os_policies is None and not opts.urn:
                raise TypeError("Missing required property 'os_policies'")
            __props__.__dict__["os_policies"] = os_policies
            __props__.__dict__["project"] = project
            if rollout is None and not opts.urn:
                raise TypeError("Missing required property 'rollout'")
            __props__.__dict__["rollout"] = rollout
            __props__.__dict__["baseline"] = None
            __props__.__dict__["deleted"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["revision_create_time"] = None
            __props__.__dict__["revision_id"] = None
            __props__.__dict__["rollout_state"] = None
            __props__.__dict__["uid"] = None
        super(OsPolicyAssignment, __self__).__init__(
            'gcp:osconfig/osPolicyAssignment:OsPolicyAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            baseline: Optional[pulumi.Input[bool]] = None,
            deleted: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            instance_filter: Optional[pulumi.Input[pulumi.InputType['OsPolicyAssignmentInstanceFilterArgs']]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            os_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OsPolicyAssignmentOsPolicyArgs']]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            reconciling: Optional[pulumi.Input[bool]] = None,
            revision_create_time: Optional[pulumi.Input[str]] = None,
            revision_id: Optional[pulumi.Input[str]] = None,
            rollout: Optional[pulumi.Input[pulumi.InputType['OsPolicyAssignmentRolloutArgs']]] = None,
            rollout_state: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None) -> 'OsPolicyAssignment':
        """
        Get an existing OsPolicyAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] baseline: Output only. Indicates that this revision has been successfully rolled out in this zone and new VMs will be assigned OS
               policies from this revision. For a given OS policy assignment, there is only one revision with a value of `true` for
               this field.
        :param pulumi.Input[bool] deleted: Output only. Indicates that this revision deletes the OS policy assignment.
        :param pulumi.Input[str] description: OS policy assignment description. Length of the description is limited to 1024 characters.
        :param pulumi.Input[str] etag: The etag for this OS policy assignment. If this is provided on update, it must match the server's etag.
        :param pulumi.Input[pulumi.InputType['OsPolicyAssignmentInstanceFilterArgs']] instance_filter: Required. Filter to select VMs.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Required. The name of the repository.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OsPolicyAssignmentOsPolicyArgs']]]] os_policies: Required. List of OS policies to be applied to the VMs.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[bool] reconciling: Output only. Indicates that reconciliation is in progress for the revision. This value is `true` when the
               `rollout_state` is one of: * IN_PROGRESS * CANCELLING
        :param pulumi.Input[str] revision_create_time: Output only. The timestamp that the revision was created.
        :param pulumi.Input[str] revision_id: Output only. The assignment revision ID A new revision is committed whenever a rollout is triggered for a OS policy
               assignment
        :param pulumi.Input[pulumi.InputType['OsPolicyAssignmentRolloutArgs']] rollout: Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        :param pulumi.Input[str] rollout_state: Output only. OS policy assignment rollout state Possible values: ROLLOUT_STATE_UNSPECIFIED, IN_PROGRESS, CANCELLING,
               CANCELLED, SUCCEEDED
        :param pulumi.Input[str] uid: Output only. Server generated unique id for the OS policy assignment resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OsPolicyAssignmentState.__new__(_OsPolicyAssignmentState)

        __props__.__dict__["baseline"] = baseline
        __props__.__dict__["deleted"] = deleted
        __props__.__dict__["description"] = description
        __props__.__dict__["etag"] = etag
        __props__.__dict__["instance_filter"] = instance_filter
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["os_policies"] = os_policies
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["revision_create_time"] = revision_create_time
        __props__.__dict__["revision_id"] = revision_id
        __props__.__dict__["rollout"] = rollout
        __props__.__dict__["rollout_state"] = rollout_state
        __props__.__dict__["uid"] = uid
        return OsPolicyAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def baseline(self) -> pulumi.Output[bool]:
        """
        Output only. Indicates that this revision has been successfully rolled out in this zone and new VMs will be assigned OS
        policies from this revision. For a given OS policy assignment, there is only one revision with a value of `true` for
        this field.
        """
        return pulumi.get(self, "baseline")

    @property
    @pulumi.getter
    def deleted(self) -> pulumi.Output[bool]:
        """
        Output only. Indicates that this revision deletes the OS policy assignment.
        """
        return pulumi.get(self, "deleted")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        OS policy assignment description. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        The etag for this OS policy assignment. If this is provided on update, it must match the server's etag.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="instanceFilter")
    def instance_filter(self) -> pulumi.Output['outputs.OsPolicyAssignmentInstanceFilter']:
        """
        Required. Filter to select VMs.
        """
        return pulumi.get(self, "instance_filter")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Required. The name of the repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osPolicies")
    def os_policies(self) -> pulumi.Output[Sequence['outputs.OsPolicyAssignmentOsPolicy']]:
        """
        Required. List of OS policies to be applied to the VMs.
        """
        return pulumi.get(self, "os_policies")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[bool]:
        """
        Output only. Indicates that reconciliation is in progress for the revision. This value is `true` when the
        `rollout_state` is one of: * IN_PROGRESS * CANCELLING
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> pulumi.Output[str]:
        """
        Output only. The timestamp that the revision was created.
        """
        return pulumi.get(self, "revision_create_time")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> pulumi.Output[str]:
        """
        Output only. The assignment revision ID A new revision is committed whenever a rollout is triggered for a OS policy
        assignment
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter
    def rollout(self) -> pulumi.Output['outputs.OsPolicyAssignmentRollout']:
        """
        Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        """
        return pulumi.get(self, "rollout")

    @property
    @pulumi.getter(name="rolloutState")
    def rollout_state(self) -> pulumi.Output[str]:
        """
        Output only. OS policy assignment rollout state Possible values: ROLLOUT_STATE_UNSPECIFIED, IN_PROGRESS, CANCELLING,
        CANCELLED, SUCCEEDED
        """
        return pulumi.get(self, "rollout_state")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Output only. Server generated unique id for the OS policy assignment resource.
        """
        return pulumi.get(self, "uid")

