# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DatabaseInstanceCloneArgs',
    'DatabaseInstanceIpAddressArgs',
    'DatabaseInstanceReplicaConfigurationArgs',
    'DatabaseInstanceRestoreBackupContextArgs',
    'DatabaseInstanceServerCaCertArgs',
    'DatabaseInstanceSettingsArgs',
    'DatabaseInstanceSettingsActiveDirectoryConfigArgs',
    'DatabaseInstanceSettingsBackupConfigurationArgs',
    'DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs',
    'DatabaseInstanceSettingsDatabaseFlagArgs',
    'DatabaseInstanceSettingsInsightsConfigArgs',
    'DatabaseInstanceSettingsIpConfigurationArgs',
    'DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs',
    'DatabaseInstanceSettingsLocationPreferenceArgs',
    'DatabaseInstanceSettingsMaintenanceWindowArgs',
    'UserSqlServerUserDetailsArgs',
]

@pulumi.input_type
class DatabaseInstanceCloneArgs:
    def __init__(__self__, *,
                 source_instance_name: pulumi.Input[str],
                 allocated_ip_range: Optional[pulumi.Input[str]] = None,
                 point_in_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] source_instance_name: Name of the source instance which will be cloned.
        :param pulumi.Input[str] allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param pulumi.Input[str] point_in_time: The timestamp of the point in time that should be restored.
        """
        pulumi.set(__self__, "source_instance_name", source_instance_name)
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if point_in_time is not None:
            pulumi.set(__self__, "point_in_time", point_in_time)

    @property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> pulumi.Input[str]:
        """
        Name of the source instance which will be cloned.
        """
        return pulumi.get(self, "source_instance_name")

    @source_instance_name.setter
    def source_instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_instance_name", value)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @allocated_ip_range.setter
    def allocated_ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocated_ip_range", value)

    @property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of the point in time that should be restored.
        """
        return pulumi.get(self, "point_in_time")

    @point_in_time.setter
    def point_in_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "point_in_time", value)


@pulumi.input_type
class DatabaseInstanceIpAddressArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 time_to_retire: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if time_to_retire is not None:
            pulumi.set(__self__, "time_to_retire", time_to_retire)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_to_retire")

    @time_to_retire.setter
    def time_to_retire(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_to_retire", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DatabaseInstanceReplicaConfigurationArgs:
    def __init__(__self__, *,
                 ca_certificate: Optional[pulumi.Input[str]] = None,
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 connect_retry_interval: Optional[pulumi.Input[int]] = None,
                 dump_file_path: Optional[pulumi.Input[str]] = None,
                 failover_target: Optional[pulumi.Input[bool]] = None,
                 master_heartbeat_period: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 ssl_cipher: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 verify_server_certificate: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] ca_certificate: PEM representation of the trusted CA's x509
               certificate.
        :param pulumi.Input[str] client_certificate: PEM representation of the replica's x509
               certificate.
        :param pulumi.Input[str] client_key: PEM representation of the replica's private key. The
               corresponding public key in encoded in the `client_certificate`.
        :param pulumi.Input[int] connect_retry_interval: The number of seconds
               between connect retries.
        :param pulumi.Input[str] dump_file_path: Path to a SQL file in GCS from which replica
               instances are created. Format is `gs://bucket/filename`.
        :param pulumi.Input[bool] failover_target: Specifies if the replica is the failover target.
               If the field is set to true the replica will be designated as a failover replica.
               If the master instance fails, the replica instance will be promoted as
               the new master instance.
        :param pulumi.Input[int] master_heartbeat_period: Time in ms between replication
               heartbeats.
        :param pulumi.Input[str] password: Password for the replication connection.
        :param pulumi.Input[str] username: Username for replication connection.
        :param pulumi.Input[bool] verify_server_certificate: True if the master's common name
               value is checked during the SSL handshake.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if connect_retry_interval is not None:
            pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        if dump_file_path is not None:
            pulumi.set(__self__, "dump_file_path", dump_file_path)
        if failover_target is not None:
            pulumi.set(__self__, "failover_target", failover_target)
        if master_heartbeat_period is not None:
            pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssl_cipher is not None:
            pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_server_certificate is not None:
            pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the trusted CA's x509
        certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the replica's x509
        certificate.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the replica's private key. The
        corresponding public key in encoded in the `client_certificate`.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds
        between connect retries.
        """
        return pulumi.get(self, "connect_retry_interval")

    @connect_retry_interval.setter
    def connect_retry_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connect_retry_interval", value)

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to a SQL file in GCS from which replica
        instances are created. Format is `gs://bucket/filename`.
        """
        return pulumi.get(self, "dump_file_path")

    @dump_file_path.setter
    def dump_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dump_file_path", value)

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the replica is the failover target.
        If the field is set to true the replica will be designated as a failover replica.
        If the master instance fails, the replica instance will be promoted as
        the new master instance.
        """
        return pulumi.get(self, "failover_target")

    @failover_target.setter
    def failover_target(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "failover_target", value)

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> Optional[pulumi.Input[int]]:
        """
        Time in ms between replication
        heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @master_heartbeat_period.setter
    def master_heartbeat_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_heartbeat_period", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ssl_cipher")

    @ssl_cipher.setter
    def ssl_cipher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_cipher", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the master's common name
        value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")

    @verify_server_certificate.setter
    def verify_server_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify_server_certificate", value)


@pulumi.input_type
class DatabaseInstanceRestoreBackupContextArgs:
    def __init__(__self__, *,
                 backup_run_id: pulumi.Input[int],
                 instance_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] backup_run_id: The ID of the backup run to restore from.
        :param pulumi.Input[str] instance_id: The ID of the instance that the backup was taken from. If left empty,
               this instance's ID will be used.
        :param pulumi.Input[str] project: The full project ID of the source instance.`
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> pulumi.Input[int]:
        """
        The ID of the backup run to restore from.
        """
        return pulumi.get(self, "backup_run_id")

    @backup_run_id.setter
    def backup_run_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "backup_run_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance that the backup was taken from. If left empty,
        this instance's ID will be used.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The full project ID of the source instance.`
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class DatabaseInstanceServerCaCertArgs:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 sha1_fingerprint: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if sha1_fingerprint is not None:
            pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sha1_fingerprint")

    @sha1_fingerprint.setter
    def sha1_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sha1_fingerprint", value)


@pulumi.input_type
class DatabaseInstanceSettingsArgs:
    def __init__(__self__, *,
                 tier: pulumi.Input[str],
                 activation_policy: Optional[pulumi.Input[str]] = None,
                 active_directory_config: Optional[pulumi.Input['DatabaseInstanceSettingsActiveDirectoryConfigArgs']] = None,
                 availability_type: Optional[pulumi.Input[str]] = None,
                 backup_configuration: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationArgs']] = None,
                 collation: Optional[pulumi.Input[str]] = None,
                 database_flags: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsDatabaseFlagArgs']]]] = None,
                 disk_autoresize: Optional[pulumi.Input[bool]] = None,
                 disk_autoresize_limit: Optional[pulumi.Input[int]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 insights_config: Optional[pulumi.Input['DatabaseInstanceSettingsInsightsConfigArgs']] = None,
                 ip_configuration: Optional[pulumi.Input['DatabaseInstanceSettingsIpConfigurationArgs']] = None,
                 location_preference: Optional[pulumi.Input['DatabaseInstanceSettingsLocationPreferenceArgs']] = None,
                 maintenance_window: Optional[pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgs']] = None,
                 pricing_plan: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] tier: The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
               for more details and supported versions. Postgres supports only shared-core machine types,
               and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        :param pulumi.Input[str] activation_policy: This specifies when the instance should be
               active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        :param pulumi.Input[str] availability_type: The availability type of the Cloud SQL
               instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For all instances, ensure that
               `settings.backup_configuration.enabled` is set to `true`.
               For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
               For Postgres instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
               is set to `true`.
        :param pulumi.Input[str] collation: The name of server instance collation.
        :param pulumi.Input[bool] disk_autoresize: Enables auto-resizing of the storage size. Set to false if you want to set `disk_size`.
        :param pulumi.Input[int] disk_size: The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. If you want to set this field, set `disk_autoresize` to false.
        :param pulumi.Input[str] disk_type: The type of data disk: PD_SSD or PD_HDD.
        :param pulumi.Input[str] pricing_plan: Pricing plan for this instance, can only be `PER_USE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: A set of key/value user label pairs to assign to the instance.
        """
        pulumi.set(__self__, "tier", tier)
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if active_directory_config is not None:
            pulumi.set(__self__, "active_directory_config", active_directory_config)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if disk_autoresize is not None:
            pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        if disk_autoresize_limit is not None:
            pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if insights_config is not None:
            pulumi.set(__self__, "insights_config", insights_config)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if location_preference is not None:
            pulumi.set(__self__, "location_preference", location_preference)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if pricing_plan is not None:
            pulumi.set(__self__, "pricing_plan", pricing_plan)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[str]:
        """
        The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
        for more details and supported versions. Postgres supports only shared-core machine types,
        and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[str]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[pulumi.Input[str]]:
        """
        This specifies when the instance should be
        active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        """
        return pulumi.get(self, "activation_policy")

    @activation_policy.setter
    def activation_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_policy", value)

    @property
    @pulumi.getter(name="activeDirectoryConfig")
    def active_directory_config(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsActiveDirectoryConfigArgs']]:
        return pulumi.get(self, "active_directory_config")

    @active_directory_config.setter
    def active_directory_config(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsActiveDirectoryConfigArgs']]):
        pulumi.set(self, "active_directory_config", value)

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[pulumi.Input[str]]:
        """
        The availability type of the Cloud SQL
        instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For all instances, ensure that
        `settings.backup_configuration.enabled` is set to `true`.
        For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
        For Postgres instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
        is set to `true`.
        """
        return pulumi.get(self, "availability_type")

    @availability_type.setter
    def availability_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_type", value)

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationArgs']]:
        return pulumi.get(self, "backup_configuration")

    @backup_configuration.setter
    def backup_configuration(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationArgs']]):
        pulumi.set(self, "backup_configuration", value)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[str]]:
        """
        The name of server instance collation.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsDatabaseFlagArgs']]]]:
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsDatabaseFlagArgs']]]]):
        pulumi.set(self, "database_flags", value)

    @property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables auto-resizing of the storage size. Set to false if you want to set `disk_size`.
        """
        return pulumi.get(self, "disk_autoresize")

    @disk_autoresize.setter
    def disk_autoresize(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disk_autoresize", value)

    @property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "disk_autoresize_limit")

    @disk_autoresize_limit.setter
    def disk_autoresize_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_autoresize_limit", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. If you want to set this field, set `disk_autoresize` to false.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of data disk: PD_SSD or PD_HDD.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter(name="insightsConfig")
    def insights_config(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsInsightsConfigArgs']]:
        return pulumi.get(self, "insights_config")

    @insights_config.setter
    def insights_config(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsInsightsConfigArgs']]):
        pulumi.set(self, "insights_config", value)

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsIpConfigurationArgs']]:
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsIpConfigurationArgs']]):
        pulumi.set(self, "ip_configuration", value)

    @property
    @pulumi.getter(name="locationPreference")
    def location_preference(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsLocationPreferenceArgs']]:
        return pulumi.get(self, "location_preference")

    @location_preference.setter
    def location_preference(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsLocationPreferenceArgs']]):
        pulumi.set(self, "location_preference", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgs']]:
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional[pulumi.Input[str]]:
        """
        Pricing plan for this instance, can only be `PER_USE`.
        """
        return pulumi.get(self, "pricing_plan")

    @pricing_plan.setter
    def pricing_plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pricing_plan", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_labels", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class DatabaseInstanceSettingsActiveDirectoryConfigArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str]):
        """
        :param pulumi.Input[str] domain: The domain name for the active directory (e.g., mydomain.com).
               Can only be used with SQL Server.
        """
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        The domain name for the active directory (e.g., mydomain.com).
        Can only be used with SQL Server.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)


@pulumi.input_type
class DatabaseInstanceSettingsBackupConfigurationArgs:
    def __init__(__self__, *,
                 backup_retention_settings: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs']] = None,
                 binary_log_enabled: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 point_in_time_recovery_enabled: Optional[pulumi.Input[bool]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 transaction_log_retention_days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs'] backup_retention_settings: Backup retention settings. The configuration is detailed below.
        :param pulumi.Input[bool] binary_log_enabled: True if binary logging is enabled.
               Can only be used with MySQL.
        :param pulumi.Input[bool] enabled: True if backup configuration is enabled.
        :param pulumi.Input[str] location: The region where the backup will be stored
        :param pulumi.Input[bool] point_in_time_recovery_enabled: True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL instances.
        :param pulumi.Input[str] start_time: `HH:MM` format time indicating when backup
               configuration starts.
        :param pulumi.Input[int] transaction_log_retention_days: The number of days of transaction logs we retain for point in time restore, from 1-7.
        """
        if backup_retention_settings is not None:
            pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        if binary_log_enabled is not None:
            pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if point_in_time_recovery_enabled is not None:
            pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if transaction_log_retention_days is not None:
            pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs']]:
        """
        Backup retention settings. The configuration is detailed below.
        """
        return pulumi.get(self, "backup_retention_settings")

    @backup_retention_settings.setter
    def backup_retention_settings(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs']]):
        pulumi.set(self, "backup_retention_settings", value)

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if binary logging is enabled.
        Can only be used with MySQL.
        """
        return pulumi.get(self, "binary_log_enabled")

    @binary_log_enabled.setter
    def binary_log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "binary_log_enabled", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The region where the backup will be stored
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL instances.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @point_in_time_recovery_enabled.setter
    def point_in_time_recovery_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "point_in_time_recovery_enabled", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        `HH:MM` format time indicating when backup
        configuration starts.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7.
        """
        return pulumi.get(self, "transaction_log_retention_days")

    @transaction_log_retention_days.setter
    def transaction_log_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "transaction_log_retention_days", value)


@pulumi.input_type
class DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs:
    def __init__(__self__, *,
                 retained_backups: pulumi.Input[int],
                 retention_unit: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] retained_backups: Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
               is 'COUNT', we will retain this many backups.
        :param pulumi.Input[str] retention_unit: The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        pulumi.set(__self__, "retained_backups", retained_backups)
        if retention_unit is not None:
            pulumi.set(__self__, "retention_unit", retention_unit)

    @property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> pulumi.Input[int]:
        """
        Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
        is 'COUNT', we will retain this many backups.
        """
        return pulumi.get(self, "retained_backups")

    @retained_backups.setter
    def retained_backups(self, value: pulumi.Input[int]):
        pulumi.set(self, "retained_backups", value)

    @property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        return pulumi.get(self, "retention_unit")

    @retention_unit.setter
    def retention_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_unit", value)


@pulumi.input_type
class DatabaseInstanceSettingsDatabaseFlagArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: A name for this whitelist entry.
        :param pulumi.Input[str] value: A CIDR notation IPv4 or IPv6 address that is allowed to
               access this instance. Must be set even if other two attributes are not for
               the whitelist to become active.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DatabaseInstanceSettingsInsightsConfigArgs:
    def __init__(__self__, *,
                 query_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 query_string_length: Optional[pulumi.Input[int]] = None,
                 record_application_tags: Optional[pulumi.Input[bool]] = None,
                 record_client_address: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] query_insights_enabled: True if Query Insights feature is enabled.
        :param pulumi.Input[int] query_string_length: Maximum query length stored in bytes. Between 256 and 4500. Default to 1024.
        :param pulumi.Input[bool] record_application_tags: True if Query Insights will record application tags from query when enabled.
        :param pulumi.Input[bool] record_client_address: True if Query Insights will record client address when enabled.
        """
        if query_insights_enabled is not None:
            pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        if query_string_length is not None:
            pulumi.set(__self__, "query_string_length", query_string_length)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if record_client_address is not None:
            pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Query Insights feature is enabled.
        """
        return pulumi.get(self, "query_insights_enabled")

    @query_insights_enabled.setter
    def query_insights_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "query_insights_enabled", value)

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum query length stored in bytes. Between 256 and 4500. Default to 1024.
        """
        return pulumi.get(self, "query_string_length")

    @query_string_length.setter
    def query_string_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "query_string_length", value)

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Query Insights will record application tags from query when enabled.
        """
        return pulumi.get(self, "record_application_tags")

    @record_application_tags.setter
    def record_application_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "record_application_tags", value)

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Query Insights will record client address when enabled.
        """
        return pulumi.get(self, "record_client_address")

    @record_client_address.setter
    def record_client_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "record_client_address", value)


@pulumi.input_type
class DatabaseInstanceSettingsIpConfigurationArgs:
    def __init__(__self__, *,
                 allocated_ip_range: Optional[pulumi.Input[str]] = None,
                 authorized_networks: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs']]]] = None,
                 ipv4_enabled: Optional[pulumi.Input[bool]] = None,
                 private_network: Optional[pulumi.Input[str]] = None,
                 require_ssl: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param pulumi.Input[bool] ipv4_enabled: Whether this Cloud SQL instance should be assigned
               a public IPV4 address. At least `ipv4_enabled` must be enabled or a
               `private_network` must be configured.
        :param pulumi.Input[str] private_network: The VPC network from which the Cloud SQL
               instance is accessible for private IP. For example, projects/myProject/global/networks/default.
               Specifying a network enables private IP.
               At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
               This setting can be updated, but it cannot be removed after it is set.
        :param pulumi.Input[bool] require_ssl: Whether SSL connections over IP are enforced or not.
        """
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if require_ssl is not None:
            pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @allocated_ip_range.setter
    def allocated_ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocated_ip_range", value)

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs']]]]:
        return pulumi.get(self, "authorized_networks")

    @authorized_networks.setter
    def authorized_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs']]]]):
        pulumi.set(self, "authorized_networks", value)

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this Cloud SQL instance should be assigned
        a public IPV4 address. At least `ipv4_enabled` must be enabled or a
        `private_network` must be configured.
        """
        return pulumi.get(self, "ipv4_enabled")

    @ipv4_enabled.setter
    def ipv4_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv4_enabled", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC network from which the Cloud SQL
        instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        Specifying a network enables private IP.
        At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
        This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether SSL connections over IP are enforced or not.
        """
        return pulumi.get(self, "require_ssl")

    @require_ssl.setter
    def require_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_ssl", value)


@pulumi.input_type
class DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] value: A CIDR notation IPv4 or IPv6 address that is allowed to
               access this instance. Must be set even if other two attributes are not for
               the whitelist to become active.
        :param pulumi.Input[str] expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        :param pulumi.Input[str] name: A name for this whitelist entry.
        """
        pulumi.set(__self__, "value", value)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class DatabaseInstanceSettingsLocationPreferenceArgs:
    def __init__(__self__, *,
                 follow_gae_application: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] follow_gae_application: A GAE application whose zone to remain
               in. Must be in the same region as this instance.
        :param pulumi.Input[str] zone: The preferred compute engine
               [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        if follow_gae_application is not None:
            pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> Optional[pulumi.Input[str]]:
        """
        A GAE application whose zone to remain
        in. Must be in the same region as this instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @follow_gae_application.setter
    def follow_gae_application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "follow_gae_application", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred compute engine
        [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class DatabaseInstanceSettingsMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[int]] = None,
                 hour: Optional[pulumi.Input[int]] = None,
                 update_track: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] day: Day of week (`1-7`), starting on Monday
        :param pulumi.Input[int] hour: Hour of day (`0-23`), ignored if `day` not set
        :param pulumi.Input[str] update_track: Receive updates earlier (`canary`) or later
               (`stable`)
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if update_track is not None:
            pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[int]]:
        """
        Day of week (`1-7`), starting on Monday
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[int]]:
        """
        Hour of day (`0-23`), ignored if `day` not set
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> Optional[pulumi.Input[str]]:
        """
        Receive updates earlier (`canary`) or later
        (`stable`)
        """
        return pulumi.get(self, "update_track")

    @update_track.setter
    def update_track(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_track", value)


@pulumi.input_type
class UserSqlServerUserDetailsArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 server_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if server_roles is not None:
            pulumi.set(__self__, "server_roles", server_roles)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="serverRoles")
    def server_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "server_roles")

    @server_roles.setter
    def server_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "server_roles", value)


