"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Api = exports.ApiProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const apigateway_generated_1 = require("./apigateway.generated");
Object.defineProperty(exports, "ApiProperty", { enumerable: true, get: function () { return apigateway_generated_1.RosApi; } });
/**
 * A ROS resource type:  `ALIYUN::ApiGateway::Api`
 */
class Api extends ros.Resource {
    /**
     * Create a new `ALIYUN::ApiGateway::Api`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosApi = new apigateway_generated_1.RosApi(this, id, {
            requestConfig: props.requestConfig,
            description: props.description,
            resultSample: props.resultSample,
            disableInternet: props.disableInternet,
            apiName: props.apiName,
            forceNonceCheck: props.forceNonceCheck,
            resultType: props.resultType ? props.resultType : 'JSON',
            failResultSample: props.failResultSample,
            errorCodeSamples: props.errorCodeSamples,
            serviceParametersMap: props.serviceParametersMap,
            groupId: props.groupId,
            requestParameters: props.requestParameters,
            appCodeAuthType: props.appCodeAuthType,
            serviceConfig: props.serviceConfig,
            constParameters: props.constParameters,
            systemParameters: props.systemParameters,
            openIdConnectConfig: props.openIdConnectConfig,
            visibility: props.visibility,
            serviceParameters: props.serviceParameters,
            authType: props.authType,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosApi;
        this.attrApiId = rosApi.attrApiId;
    }
}
exports.Api = Api;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXBpLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDhDQUE4QztBQUM5QyxpRUFBZ0Q7QUFFN0IsNEZBRlYsNkJBQU0sT0FFZTtBQTJIOUI7O0dBRUc7QUFDSCxNQUFhLEdBQUksU0FBUSxHQUFHLENBQUMsUUFBUTtJQVlqQzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQWUsRUFBRSxtQ0FBMkMsSUFBSTtRQUMxRyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sTUFBTSxHQUFHLElBQUksNkJBQU0sQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFHO1lBQ2pDLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUN0QyxPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87WUFDdEIsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxNQUFNO1lBQ3hELGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7WUFDeEMsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGdCQUFnQjtZQUN4QyxvQkFBb0IsRUFBRSxLQUFLLENBQUMsb0JBQW9CO1lBQ2hELE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztZQUN0QixpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1lBQzFDLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUN0QyxhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7WUFDbEMsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7WUFDeEMsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLG1CQUFtQjtZQUM5QyxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7WUFDNUIsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQjtZQUMxQyxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1NBQ25CLEVBQUUsZ0NBQWdDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxTQUFTLEdBQUcsTUFBTSxDQUFDLFNBQVMsQ0FBQztJQUN0QyxDQUFDO0NBQ0o7QUFoREQsa0JBZ0RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuaW1wb3J0IHsgUm9zQXBpIH0gZnJvbSAnLi9hcGlnYXRld2F5LmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc0FwaSBhcyBBcGlQcm9wZXJ0eSB9O1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6QXBpR2F0ZXdheTo6QXBpYFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEFwaVByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGFwaU5hbWU6IFRoZSBuYW1lIG9mIHRoZSBBUEkuTmVlZCBbNCwgNTBdIENoaW5lc2VcXEVuZ2xpc2hcXE51bWJlciBjaGFyYWN0ZXJzIG9yIFwiX1wiLGFuZCBzaG91bGQgc3RhcnQgd2l0aCBDaGluZXNlL0VuZ2xpc2ggY2hhcmFjdGVyLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGFwaU5hbWU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGdyb3VwSWQ6IFRoZSBpZCBvZiB0aGUgR3JvdXAuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZ3JvdXBJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcmVxdWVzdENvbmZpZzogVGhlIGNvbmZpZ3VyYXRpb24gb2YgdGhlIHJlcXVlc3RcbiAgICAgKi9cbiAgICByZWFkb25seSByZXF1ZXN0Q29uZmlnOiBSb3NBcGkuUmVxdWVzdENvbmZpZ1Byb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcmVzdWx0U2FtcGxlOiBUaGUgc2FtcGxlIG9mIHRoZSByZXN1bHQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVzdWx0U2FtcGxlOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSByZXN1bHRUeXBlOiBUaGUgZm9ybWF0IG9mIHNlcnZpY2UncyByZXNwb25zZSwgXCJKU09OXCIsIFwiVEVYVFwiLCBcIkJJTkFSWVwiLCBcIlhNTFwiLCBcIkhUTUxcIiBvciBcIlBBU1NUSFJPVUdIXCIuIERlZmF1bHQgaXMgXCJKU09OXCIuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVzdWx0VHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc2VydmljZUNvbmZpZzogVGhlIGNvbmZpZ3VyYXRpb24gb2YgdGhlIHNlcnZpY2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2VydmljZUNvbmZpZzogUm9zQXBpLlNlcnZpY2VDb25maWdQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHZpc2liaWxpdHk6IFdoZXRoZXIgdG8gbWFrZSB0aGUgQVBJIHB1YmxpYy4gXCJQVUJMSUNcIiBvciBcIlBSSVZBVEVcIi5cbiAgICAgKi9cbiAgICByZWFkb25seSB2aXNpYmlsaXR5OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBhcHBDb2RlQXV0aFR5cGU6IFdoZW4gQXV0aFR5cGUgaXMgQVBQIGF1dGhlbnRpY2F0aW9uLCB0aGUgb3B0aW9uYWwgdmFsdWVzIGFyZSBhcyBmb2xsb3dzOiBJZiBub3QgcGFzc2VkLCB0aGUgZGVmYXVsdCB2YWx1ZSBpcyBERUZBVUxUOlxuICAgICAqIERFRkFVTFQ6IERlZmF1bHQgKHNldCBieSBncm91cCkuXG4gICAgICogRElTQUJMRTogTm90IGFsbG93ZWRcbiAgICAgKiBIRUFERVI6IEFsbG93IEFwcENvZGUgaGVhZGVyIGF1dGhlbnRpY2F0aW9uXG4gICAgICogSEVBREVSX1FVRVJZOiBBbGxvdyBBcHBDb2RlIGhlYWRlciBhbmQgcXVlcnkgYXV0aGVudGljYXRpb25cbiAgICAgKi9cbiAgICByZWFkb25seSBhcHBDb2RlQXV0aFR5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBhdXRoVHlwZTogVHlwZSBvZiBhdXRob3JpemF0aW9uIG9mIHRoZSBBUEkgLiBcIkFQUFwiLFwiQU5PTllNT1VTXCIsIG9yIFwiQVBQT1BFTklEXCJcbiAgICAgKi9cbiAgICByZWFkb25seSBhdXRoVHlwZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGNvbnN0UGFyYW1ldGVyczogVGhlIGNvbnN0IHBhcmFtZXRlcnMuXG4gICAgICovXG4gICAgcmVhZG9ubHkgY29uc3RQYXJhbWV0ZXJzPzogQXJyYXk8Um9zQXBpLkNvbnN0UGFyYW1ldGVyc1Byb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlPiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRlc2NyaXB0aW9uOiBEZXNjcmlwdGlvbiBvZiB0aGUgQVBJLCBsZXNzIHRoYW4gMTgwIGNoYXJhY3RlcnMuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkaXNhYmxlSW50ZXJuZXQ6IFNldCBEaXNhYmxlSW50ZXJuZXQgdG8gdHJ1ZSwgb25seSBzdXBwb3J0IGludHJhbmV0IHRvIGNhbGwgQVBJLiBcbiAgICAgKiBTZXQgRGlzYWJsZUludGVybmV0IHRvIGZhbHNlLCB0aGVuIHRoZSBjYWxsIGlzIG5vdCByZXN0cmljdGVkLiBcbiAgICAgKlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRpc2FibGVJbnRlcm5ldD86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBlcnJvckNvZGVTYW1wbGVzOiBUaGUgRXJyb3IgQ29kZSBzYW1wbGVzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVycm9yQ29kZVNhbXBsZXM/OiBBcnJheTxSb3NBcGkuRXJyb3JDb2RlU2FtcGxlc1Byb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlPiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGZhaWxSZXN1bHRTYW1wbGU6IFRoZSBzYW1wbGUgb2YgdGhlIGZhaWwgcmVzdWx0LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGZhaWxSZXN1bHRTYW1wbGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBmb3JjZU5vbmNlQ2hlY2s6IFNldCBGb3JjZU5vbmNlQ2hlY2sgdG8gdHJ1ZSwgY29tcHVsc29yaWx5IGNoZWNrIFgtQ2EtTm9uY2Ugd2hlbiByZXF1ZXN0aW5nLCBcbiAgICAgKiB0aGlzIGlzIHRoZSB1bmlxdWUgaWRlbnRpZmllciBvZiB0aGUgcmVxdWVzdCwgZ2VuZXJhbGx5IHVzaW5nIFVVSUQgdG8gaWRlbnRpZnkuIFxuICAgICAqIFRoZSBBUEkgZ2F0ZXdheSB3aWxsIHZlcmlmeSB0aGUgdmFsaWRpdHkgb2YgdGhpcyBwYXJhbWV0ZXIgYWZ0ZXIgcmVjZWl2aW5nIHRoaXMgcGFyYW1ldGVyLiBcbiAgICAgKiBUaGUgc2FtZSB2YWx1ZSBjYW4gb25seSBiZSB1c2VkIG9uY2Ugd2l0aGluIDE1IG1pbnV0ZXMuIEl0IGNhbiBlZmZlY3RpdmVseSBwcmV2ZW50IEFQSSByZXBsYXkgYXR0YWNrcy5cbiAgICAgKiBTZXQgRm9yY2VOb25jZUNoZWNrIHRvIGZhbHNlLCB0aGVuIG5vIGNoZWNrLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGZvcmNlTm9uY2VDaGVjaz86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBvcGVuSWRDb25uZWN0Q29uZmlnOiBUaGUgY29uZmlndXJhdGlvbiBvZiB0aGUgb3BlbiBpZC5cbiAgICAgKi9cbiAgICByZWFkb25seSBvcGVuSWRDb25uZWN0Q29uZmlnPzogUm9zQXBpLk9wZW5JZENvbm5lY3RDb25maWdQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHJlcXVlc3RQYXJhbWV0ZXJzOiBUaGUgcmVxdWVzdCBwYXJhbWV0ZXJzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlcXVlc3RQYXJhbWV0ZXJzPzogQXJyYXk8Um9zQXBpLlJlcXVlc3RQYXJhbWV0ZXJzUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc2VydmljZVBhcmFtZXRlcnM6IFRoZSBzZXJ2aWNlIHBhcmFtZXRlcnMuXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2VydmljZVBhcmFtZXRlcnM/OiBBcnJheTxSb3NBcGkuU2VydmljZVBhcmFtZXRlcnNQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzZXJ2aWNlUGFyYW1ldGVyc01hcDogVGhlIG1hcHBpbmcgcmVsYXRpb24gYmV0d2VlbiAocmVxdWVzdCBwYXJhbWV0ZXJzXFxjb25zdCBwYXJhbWV0ZXJzXFxzeXN0ZW0gcGFyYW1ldGVycykgYW5kIHNlcnZpY2UgcGFyYW1ldGVycy5cbiAgICAgKi9cbiAgICByZWFkb25seSBzZXJ2aWNlUGFyYW1ldGVyc01hcD86IEFycmF5PFJvc0FwaS5TZXJ2aWNlUGFyYW1ldGVyc01hcFByb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlPiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHN5c3RlbVBhcmFtZXRlcnM6IFRoZSBzeXN0ZW0gcGFyYW1ldGVycy5cbiAgICAgKi9cbiAgICByZWFkb25seSBzeXN0ZW1QYXJhbWV0ZXJzPzogQXJyYXk8Um9zQXBpLlN5c3RlbVBhcmFtZXRlcnNQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB0YWdzOiBUYWdzIHRvIGF0dGFjaCB0byBpbnN0YW5jZS4gTWF4IHN1cHBvcnQgMjAgdGFncyB0byBhZGQgZHVyaW5nIGNyZWF0ZSBpbnN0YW5jZS4gRWFjaCB0YWcgd2l0aCB0d28gcHJvcGVydGllcyBLZXkgYW5kIFZhbHVlLCBhbmQgS2V5IGlzIHJlcXVpcmVkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBSb3NBcGkuVGFnc1Byb3BlcnR5W107XG59XG5cbi8qKlxuICogQSBST1MgcmVzb3VyY2UgdHlwZTogIGBBTElZVU46OkFwaUdhdGV3YXk6OkFwaWBcbiAqL1xuZXhwb3J0IGNsYXNzIEFwaSBleHRlbmRzIHJvcy5SZXNvdXJjZSB7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgcHJvcGVydGllcyBvZiB0aGlzIFJPUyByZXNvdXJjZSwgd2hpY2ggd2lsbCBiZSBhc3NpZ25lZCB0byBST1MgcmVzb3VyY2UuXG4gICAgICovXG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgQXBpSWQ6IFRoZSBpZCBvZiB0aGUgQVBJLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyQXBpSWQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpBcGlHYXRld2F5OjpBcGlgLlxuICAgICAqXG4gICAgICogUGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBQYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBQYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEFwaVByb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDpib29sZWFuID0gdHJ1ZSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgICAgIGNvbnN0IHJvc0FwaSA9IG5ldyBSb3NBcGkodGhpcywgaWQsICB7XG4gICAgICAgICAgICByZXF1ZXN0Q29uZmlnOiBwcm9wcy5yZXF1ZXN0Q29uZmlnLFxuICAgICAgICAgICAgZGVzY3JpcHRpb246IHByb3BzLmRlc2NyaXB0aW9uLFxuICAgICAgICAgICAgcmVzdWx0U2FtcGxlOiBwcm9wcy5yZXN1bHRTYW1wbGUsXG4gICAgICAgICAgICBkaXNhYmxlSW50ZXJuZXQ6IHByb3BzLmRpc2FibGVJbnRlcm5ldCxcbiAgICAgICAgICAgIGFwaU5hbWU6IHByb3BzLmFwaU5hbWUsXG4gICAgICAgICAgICBmb3JjZU5vbmNlQ2hlY2s6IHByb3BzLmZvcmNlTm9uY2VDaGVjayxcbiAgICAgICAgICAgIHJlc3VsdFR5cGU6IHByb3BzLnJlc3VsdFR5cGUgPyBwcm9wcy5yZXN1bHRUeXBlIDogJ0pTT04nLFxuICAgICAgICAgICAgZmFpbFJlc3VsdFNhbXBsZTogcHJvcHMuZmFpbFJlc3VsdFNhbXBsZSxcbiAgICAgICAgICAgIGVycm9yQ29kZVNhbXBsZXM6IHByb3BzLmVycm9yQ29kZVNhbXBsZXMsXG4gICAgICAgICAgICBzZXJ2aWNlUGFyYW1ldGVyc01hcDogcHJvcHMuc2VydmljZVBhcmFtZXRlcnNNYXAsXG4gICAgICAgICAgICBncm91cElkOiBwcm9wcy5ncm91cElkLFxuICAgICAgICAgICAgcmVxdWVzdFBhcmFtZXRlcnM6IHByb3BzLnJlcXVlc3RQYXJhbWV0ZXJzLFxuICAgICAgICAgICAgYXBwQ29kZUF1dGhUeXBlOiBwcm9wcy5hcHBDb2RlQXV0aFR5cGUsXG4gICAgICAgICAgICBzZXJ2aWNlQ29uZmlnOiBwcm9wcy5zZXJ2aWNlQ29uZmlnLFxuICAgICAgICAgICAgY29uc3RQYXJhbWV0ZXJzOiBwcm9wcy5jb25zdFBhcmFtZXRlcnMsXG4gICAgICAgICAgICBzeXN0ZW1QYXJhbWV0ZXJzOiBwcm9wcy5zeXN0ZW1QYXJhbWV0ZXJzLFxuICAgICAgICAgICAgb3BlbklkQ29ubmVjdENvbmZpZzogcHJvcHMub3BlbklkQ29ubmVjdENvbmZpZyxcbiAgICAgICAgICAgIHZpc2liaWxpdHk6IHByb3BzLnZpc2liaWxpdHksXG4gICAgICAgICAgICBzZXJ2aWNlUGFyYW1ldGVyczogcHJvcHMuc2VydmljZVBhcmFtZXRlcnMsXG4gICAgICAgICAgICBhdXRoVHlwZTogcHJvcHMuYXV0aFR5cGUsXG4gICAgICAgICAgICB0YWdzOiBwcm9wcy50YWdzLFxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc0FwaTtcbiAgICAgICAgdGhpcy5hdHRyQXBpSWQgPSByb3NBcGkuYXR0ckFwaUlkO1xuICAgIH1cbn1cbiJdfQ==