import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
export interface ManagedInstanceRoleProps {
    /**
     * The managed policies to apply to the role in addition to the default policies.
     */
    readonly managedPolicies?: iam.ManagedPolicy[];
    /**
     * Should the role include directory service access with SSM.
     */
    readonly domainJoinEnabled?: boolean;
    /**
     * Should the role include SSM management. By default if domainJoinEnabled is true then this role is always included.
     */
    readonly ssmManagementEnabled?: boolean;
}
export declare class ManagedInstanceRole extends cdk.Construct {
    readonly instanceProfile: iam.CfnInstanceProfile;
    constructor(scope: cdk.Construct, id: string, props: ManagedInstanceRoleProps);
}
