Contributors to Recommenders 
============================
Recommenders is developed and maintained by a community of people interested in exploring recommendation algorithms and how best to deploy them in industry settings. The goal is to accelerate the workflow of any individual or organization working on recommender systems. Everyone is encouraged to contribute at any level to add and improve the implemented algorithms, notebooks and utilities.

<p align="center">
  <img src="https://contributors-img.web.app/image?repo=microsoft/recommenders" width = 500/>
</p>

Maintainers (sorted alphabetically)
---------------------------------------
Maintainers are actively supporting the project and have made substantial contributions to the repository.<br>
They have admin access to the repo and provide support reviewing issues and pull requests.

* **[Andreas Argyriou](https://github.com/anargyri)**
   * SAR single node improvements
   * Reco utils metrics computations
   * Tests for Surprise
   * Model selection notebooks (AzureML for SVD, NNI) 
* **[Jianxun Lian](https://github.com/Leavingseason)**
   * xDeepFM algorithm
   * DKN algorithm
   * Review, development and optimization of MSRA algorithms.
* **[Jun Ki Min](https://github.com/loomlike)**
   * ALS notebook
   * Wide & Deep algorithm
   * Hyperparameter tuning notebooks
* **[Miguel González-Fierro](https://github.com/miguelfierro)**
   * Recommendation algorithms review, development and optimization.
   * Reco utils review, development and optimization.
   * Github statistics.
   * Continuous integration build / test setup.
* **[Scott Graham](https://github.com/gramhagen)**
   * Improving documentation
   * VW notebook
* **[Tao Wu](https://github.com/wutaomsft)**
   * Improving documentation


Contributors  (sorted alphabetically)
-------------------------------------
[Full List of Contributors](https://github.com/Microsoft/Recommenders/graphs/contributors)

To contributors: please add your name to the list when you submit a patch to the project.

* **[Aaron He](https://github.com/AaronHeee)**
   * Reco utils of NCF
   * Deep dive notebook demonstrating the use of NCF
* **[Abir Chakraborty](https://github.com/aeroabir)**
   * Self-Attentive Sequential Recommendation (SASRec)
   * Sequential Recommendation Via Personalized Transformer (SSEPT)
* **[Alexandros Ioannou](https://github.com/aioannou96)**
   * Standard VAE algorithm 
   * Multinomial VAE algorithm  
* **[Bamdev Mishra](https://github.com/bamdevm)**
   * RLRMC algorithm
   * GeoIMC algorithm
* **[Beth Zeranski](https://github.com/bethz)**
   * DevOps Pipelines used as a control plane to run existing Pytests on AzureML
   * Automation scripts to configure AzureML environment for pipeline use 
* **[Chuyang Ke](https://github.com/ChuyangKe)**
   * Reco utils optimization
   * Performance tests
* **[Dan Bianchini](https://github.com/danb27)**
   * SAR Single Node algorithm improvements
* **[Dan Ciborowski](https://github.com/dciborow)**
   * ALS operationalization notebook
   * SAR PySpark improvement
* **[Daniel Schneider](https://github.com/danielsc)**
   * FastAI notebook
* **[Evgenia Chroni](https://github.com/EvgeniaChroni)**
   * Multinomial VAE algorithm
   * Standard VAE algorithm
* **[Gianluca Campanella](https://github.com/gcampanella)**
   * Spark optimization and support
* **[Heather Spetalnick (Shapiro)](https://github.com/heatherbshapiro)**
   * AzureML documentation and support
* **[Jeremy Reynolds](https://github.com/jreynolds01)**
   * Reference architecture
* **[Jianjie Liu](https://github.com/laserprec/)**
   * GitHub Action Migration
   * Test Infrastructure Optimization
* **[Kaisar Mussalim](https://github.com/kmussalim)**
   * Multinomial VAE algorithm
   * Standard VAE algorithm
* **[Le Zhang](https://github.com/yueguoguo)**
   * Reco utils
   * Continuous integration build / test setup
   * Quickstart, deep dive, algorithm comparison, notebooks
* **[Markus Cozowicz](https://github.com/eisber)**
   * SAR improvements on Spark
* **[Max Kaznady](https://github.com/maxkazmsft)**
   * Early SAR single node code and port from another internal codebase
   * Early SAR on Spark-SQL implementation
   * SAR notebooks
   * SAR unit / integration / smoke tests
   * Early infrastructure design based on collapsing another internal project
* **[Mirco Milletarì](https://github.com/WessZumino)**
   * Restricted Boltzmann Machine algorithm
* **[Nicolas Hug](https://github.com/NicolasHug)**
   * Jupyter notebook demonstrating the use of [Surprise](https://github.com/NicolasHug/Surprise) library for recommendations
* **[Nikhil Joglekar](https://github.com/nikhilrj)**
   * Improving documentation
   * Quick start notebook
   * Operationalization notebook
* **[Nile Wilson](https://github.com/niwilso)**
   * Term Frequency - Inverse Document Frequency (TF-IDF) quickstart, utils
* **[Pradnyesh Vineet Joshi](https://github.com/pradnyeshjoshi)**
   * GitHub workflows to trigger unit, smoke and integration tests in parallel on AzureML
   * Scripts to configure AzureML environment
* **[Pratik Jawanpuria](https://github.com/pratikjawanpuria)**
   * RLRMC algorithm
   * GeoIMC algorithm
* **[Qi Wan](https://github.com/Qcactus)**
   * LightGCN algorithm
   * Deep dive notebook demonstrating the use of LightGCN
* **[Quoc-Tuan Truong](https://github.com/tqtg)**
   * BPR notebook using [Cornac](https://github.com/PreferredAI/cornac) framework
   * BiVAE notebook using [Cornac](https://github.com/PreferredAI/cornac) framework
* **[Robert Alexander](https://github.com/roalexan)**
   * Windows test pipelines
* **[Satyadev Ntv](https://github.com/satyadevntv)**
   * GeoIMC algorithm
* **[Simon Zhao](https://github.com/simonzhaoms)**
   * SARplus algorithm upgrade
* **[Yan Zhang](https://github.com/YanZhangADS)**
   * Diversity metrics including coverage, novelty, diversity, and serendipity
   * Diversity metrics evaluation sample notebook
* **[Yassine Khelifi](https://github.com/datashinobi)**
   * SAR notebook quickstart
* **[Zhenhui Xu](https://github.com/motefly)**
   * Reco utils of LightGBM
   * LightGBM notebook quickstart
    
