# ##############################################################################
#                           CARMA DEPENDENCIES                                 #
# ##############################################################################
# Python and Numpy dependencies
IF (carma_FIND_REQUIRED)
    FIND_PACKAGE(Python3 COMPONENTS Interpreter Development NumPy REQUIRED)
ELSE ()
    FIND_PACKAGE(Python3 COMPONENTS Interpreter Development NumPy)
ENDIF ()
IF (Python3_FOUND)
    LIST(APPEND carma_INCLUDE_DIRS ${Python3_INCLUDE_DIRS})
ENDIF ()
IF (Python3_NumPy_FOUND)
    LIST(APPEND carma_INCLUDE_DIRS ${Python3_NumPy_INCLUDE_DIRS})
ENDIF ()

IF (NOT DEFINED PYTHON_EXECUTABLE)
    SET(PYTHON_EXECUTABLE ${Python3_EXECUTABLE})
ENDIF ()

# Armadillo dependency
IF (NOT TARGET armadillo)
    IF (carma_FIND_REQUIRED)
        FIND_PACKAGE(Armadillo REQUIRED)
    ELSE ()
        FIND_PACKAGE(Armadillo)
    ENDIF ()
    ADD_LIBRARY(armadillo INTERFACE)
    TARGET_INCLUDE_DIRECTORIES(armadillo INTERFACE ${ARMADILLO_INCLUDE_DIRS})
    TARGET_LINK_LIBRARIES(armadillo INTERFACE ${ARMADILLO_LIBRARIES})
ENDIF ()
IF (armadillo_FOUND OR ARMADILLO_FOUND OR TARGET armadillo)
    ADD_LIBRARY(armadillo::armadillo ALIAS armadillo)
    LIST(APPEND carma_INCLUDE_DIRS ${ARMADILLO_INCLUDE_DIRS})
ENDIF ()

# pybind11 dependency
IF(NOT TARGET pybind11::pybind11)
    IF (PYBIND11_ROOT_DIR)
        ADD_SUBDIRECTORY(${PYBIND11_ROOT_DIR} pybind11)
    ELSE()
        IF (carma_FIND_REQUIRED)
            FIND_PACKAGE(pybind11 CONFIG REQUIRED)
        ELSE ()
            FIND_PACKAGE(pybind11 CONFIG)
        ENDIF()
    ENDIF()
    IF (pybind11_FOUND)
        LIST(APPEND carma_INCLUDE_DIRS ${pybind11_INCLUDE_DIR})
    ENDIF()
ENDIF()
