from typing import Optional, Set, List, Callable
from collections.abc import Iterable, Sequence
from ctypes import *
from enum import Enum

from decimal import Decimal as decimal


message_builder: MessageBuilder
series_builder: SeriesBuilder
current_script: Script
andi: Andi

class Andi:
  pass

class Database:
  pass

class Timer:
  pass

class TIMERSTATE:
  pass

class TimerElapsedEventArgs:
  pass

class TimerStateChangedEventArg:
  pass

class EcuNodeEthernet:
  pass

class ISDMessageManager:
  pass

class INMMessageManager:
  pass

class MessageNM:
  pass

class FILEFORMAT:
  pass

class Filter:
  pass

class HeaderUDP:
  pass

class TransportProtocols:
  pass

class IctrBs:
  pass

class IctrFktn:
  pass

class HeaderIPv4:
  pass

class IIPOptions:
  pass

class IIPOption:
  pass

class HeaderIPv6:
  pass

class IPProtocol_Type:
  pass

class IExtensionHeader:
  pass

class NetworkProtocols:
  pass

class Protocols:
  pass

class HeaderTransport:
  pass

class HeaderIP:
  pass

class HeaderEthernet:
  pass

class EtherType:
  pass

class HeaderVlan:
  pass

class CaptureInfo:
  pass

class GatewayType:
  pass

class DataDirection:
  pass

class LinkLayer:
  pass

class BasePartialNet:
  pass

class FunctionalPartialNet:
  pass

class EcuNmState:
  pass

class IMessageManager:
  pass

class ISomeIPMessageManager:
  pass

class ManagerState:
  pass

class Port:
  pass

class SendingSomeIPEventArgs:
  pass

class MessageSomeIP:
  pass

class Parameter:
  pass

class ICompuMethod:
  pass

class IRationalCoeff:
  pass

class COMPU_METHOD_CATEGORY:
  pass

class Unit:
  pass

class ICompuScale:
  pass

class IManufacturerParameterExtension:
  pass

class DataTypeCategory:
  pass

class ISignal:
  pass

class ISignalActivation:
  pass

class ArrayDefinition:
  pass

class IMessageInternetApplication:
  pass

class HeaderTCP:
  pass

class ISomeIPHeader:
  pass

class MessageType:
  pass

class ReturnCode:
  pass

class ISomeIpTpHeader:
  pass

class SendingSomeIPSDEventArgs:
  pass

class MessageSomeIPSD:
  pass

class Entry:
  pass

class Option:
  pass

class TransType:
  pass

class EndPointType:
  pass

class EntryType:
  pass

class Message:
  pass

class IMessageBase:
  pass

class ISDHeader:
  pass

class ReceivingEventArgs:
  pass

class ValueChangedArgs:
  pass

class MethodCalledArgs:
  pass

class IChannelAdapter:
  pass

class Adapter:
  pass

class BusData:
  pass

class BusVendorData:
  pass

class BusStatus:
  pass

class CmStatus:
  pass

class CmVendorData:
  pass

class ControlMessageData:
  pass

class IP:
  pass

class SeriesBuilder:
  pass

class Series:
  pass

class DataPoint:
  pass

class Node:
  pass

class EcuNodeCAN:
  pass

class SignalValue:
  pass

class ValueChangedArgsMsg:
  pass

class IEcuMessageBasedNode:
  pass

class ChannelBrspyCAN:
  pass

class MessageCAN:
  pass

class ICANHeader:
  pass

class IFrameInstance:
  pass

class IE2EInformation:
  pass

class ISignalInstance:
  pass

class IPduTiming:
  pass

class ICyclicTiming:
  pass

class IEventTiming:
  pass

class ISignalTrigger:
  pass

class ISignalInstanceRef:
  pass

class INetworkConfiguration:
  pass

class INetwork:
  pass

class INetworkEndpointAddress:
  pass

class IPv4AddresSource:
  pass

class IFrameTriggering:
  pass

class IFrame:
  pass

class IPduInstance:
  pass

class IPduType:
  pass

class FrameType:
  pass

class ISignalGroupInstance:
  pass

class ISignalGroup:
  pass

class IChannel:
  pass

class IPduTriggering:
  pass

class ICluster:
  pass

class IMacMulticastGroup:
  pass

class CouplingPort:
  pass

class VlanMembership:
  pass

class IChannelEthernet:
  pass

class ISignalTriggering:
  pass

class IController:
  pass

class IMultiplexedPart:
  pass

class ISwitchedPduInstance:
  pass

class ISegmentPosition:
  pass

class ISecOCConfiguration:
  pass

class IContainedProps:
  pass

class HeaderType:
  pass

class AutoCalculate:
  pass

class IRecordHandler:
  pass

class ChannelBrspy:
  pass

class ChannelBtsCAN:
  pass

class ChannelBtsLIN:
  pass

class MessageLIN:
  pass

class ILINHeader:
  pass

class ChannelBts:
  pass

class ChannelBtsIO:
  pass

class ChannelCAN:
  pass

class Transmission:
  pass

class ChannelEthernet:
  pass

class ChannelLIN:
  pass

class ChannelMediaGateway:
  pass

class ChannelMediaGatewayCAN:
  pass

class ChannelNewMediaGateway:
  pass

class ChannelPlpAnalog:
  pass

class ChannelPlpCan:
  pass

class ChannelPlp:
  pass

class ChannelPlpEthernet:
  pass

class ChannelPlpFlexRay:
  pass

class MessageFlexray:
  pass

class IMessageFlexRayHeader:
  pass

class ChannelPlpLin:
  pass

class ChannelPlpSerial:
  pass

class DatabaseCAN:
  pass

class ISignalEcu:
  pass

class TpAddress:
  pass

class ITpConfig:
  pass

class ICanTpConnection:
  pass

class AddressingFormat:
  pass

class ITpNode:
  pass

class IConnector:
  pass

class IEcu:
  pass

class IEcuPort:
  pass

class IApplicationEndpoint:
  pass

class IProvidedService:
  pass

class IServiceInterface:
  pass

class Package:
  pass

class Event:
  pass

class CALLSEMANTIC:
  pass

class IManufacturerMethodExtension:
  pass

class SomeIpTP:
  pass

class Method:
  pass

class IEventGroup:
  pass

class Field:
  pass

class IEventHandler:
  pass

class IConsumedEventGroup:
  pass

class IConsumedService:
  pass

class TargetType:
  pass

class IPduPool:
  pass

class IFrTpConnection:
  pass

class DatabaseEdiabas:
  pass

class DatabaseEthernet:
  pass

class IECUEthernet:
  pass

class CouplingElement:
  pass

class DatabaseLIN:
  pass

class ILinEcu:
  pass

class IProduct:
  pass

class ScheduleTable:
  pass

class ScheduleCommand:
  pass

class DatabasePDU:
  pass

class PduEcu:
  pass

class IOutputViewer:
  pass

class OutputStringType:
  pass

class Variable:
  pass

class IExcelFilesCreator:
  pass

class IExcelFile:
  pass

class IsoTp:
  pass

class MessageARP:
  pass

class Operation:
  pass

class HARDWARE_TYPE:
  pass

class PROTOCOL_TYPE:
  pass

class MessageBuilder:
  pass

class MessagePDU:
  pass

class MessageAnalog:
  pass

class MeasurementSample:
  pass

class MessageTFTP:
  pass

class ErrorCodes:
  pass

class Opcodes:
  pass

class Modes:
  pass

class MessageHSFZ:
  pass

class HSFZCtrlWordMapping:
  pass

class Diag:
  pass

class HSFZServices:
  pass

class VIS:
  pass

class MessageEthernet:
  pass

class MessagePTP:
  pass

class PtpMessageTypes:
  pass

class ITimeSpan:
  pass

class IFollowUpTlv:
  pass

class MessageUDP:
  pass

class IMessageDiagBasic:
  pass

class Uds:
  pass

class UdsServices:
  pass

class MessageTCP:
  pass

class MessageIEEE1722:
  pass

class MessageICMPv4:
  pass

class ICMPv4TypeCodes1:
  pass

class MessageDHCP:
  pass

class mode:
  pass

class MessageIpv4:
  pass

class MessageIPv6:
  pass

class MessageDlt:
  pass

class DltStandardHeader:
  pass

class DltExtendedHeader:
  pass

class DltType:
  pass

class MessageTls:
  pass

class TlsContentTypes:
  pass

class ITlsHandshake:
  pass

class HandshakeTypes:
  pass

class TlsCipherSuite:
  pass

class ITlsAlert:
  pass

class AlertLevels:
  pass

class AlertDescription:
  pass

class MessageICMPv6:
  pass

class ICMPv6_TYPE:
  pass

class MessageSRP:
  pass

class ISRPSubMessage:
  pass

class ISRPVectorAttribute:
  pass

class MessageHttp:
  pass

class MessageDoIP:
  pass

class Script:
  pass

class LOG_TYPE:
  pass

class NODESTATE:
  pass

class Panel:
  pass

class PanelFormClosedEventArgs:
  pass

class DateTime:
  pass

"""
This variable is available as :code:`andi` global variable
"""
class Andi:
  def auto_fix_channels(self):
    """
    Set the channels adapters.

    """
    pass
  def clear_output_console(self):
    """
    Clears the ANDi's output console

    """
    pass
  def create_channel(self, adapter_id : str) -> IChannelAdapter:
    """
    Creates a channel.

      **adapter_id** (str) – Adapter's name follows a special naming format: see :doc:`Adapter Naming Notations <../../Scripting API/Notations>` in documentation for more info
    :return: Channel adapter.
    :rtype: IChannelAdapter
    """
    pass
  def create_channel(self, driver : str, link : str, dev_port : c_int32, dev_id : Optional[c_int32] = None, dev_ip : str = None, dev_mac : str = None, sys_nic : str = None) -> IChannelAdapter:
    """
    Creates a channel.

      - **driver** (str) – Protocol/driver used.
            Possible values: :code:`tecmp`, :code:`bts`, :code:`btsevo`.
      - **link** (str) – Link layer.
            Possible values: :code:`can`, :code:`canfd`, :code:`lin`, :code:`flexray`, :code:`serial`,
            :code:`analog`, :code:`ethernet`, :code:`io`.
      - **dev_port** (c_int32) – Port assigned to the channel (CM Channel ID, BTS interface ID...).
      - **dev_id** (Optional[c_int32]) – Device ID (CM ID, BTS Board Index...).
      - **dev_ip** (str) – Device IP.
      - **dev_mac** (str) – Device MAC address.
      - **sys_nic** (str) – PC network interface.
    :return: Channel adapter.
    :rtype: IChannelAdapter
    """
    pass
  def create_node(self, database : Database, ecu_name : str, channel : object) -> EcuNodeEthernet:
    """
    Creates and returns a SOME/IP RBS node.

      - **database** (Database) – The database from which we will get our ECU.
      - **ecu_name** (str) – ECU Name.
      - **channel** (object) – Channel object or channel name
    :return: Ecu node created
    :rtype: EcuNodeEthernet
    """
    pass
  def create_timer(self) -> Timer:
    """
    Creates and returns a timer object.

    :return: Timer object created.
    :rtype: Timer
    """
    pass
  def detect_hardware(self):
    """
    Detects hardware.

    """
    pass
  def get_adapters(self) -> List[Adapter]:
    """
    Gets the list of the available adapters.

    :return: List of available adapters.
    :rtype: List[Adapter]
    """
    pass
  def get_output_console(self) -> str:
    """
    Gets the text that's displayed in the ANDi's output console.

    :return: Text displayed on output console
    :rtype: str
    """
    pass
  def get_project_name(self) -> str:
    """
    Gets the current project name.

    :return: Project's name
    :rtype: str
    """
    pass
  def load_channels(self, file_path : str) -> dict[str, IChannelAdapter]:
    """
    Gets a dictionary of loaded channels.

      **file_path** (str) – Channels Configuration file path
    :return: Dictionary of loaded channels.
    :rtype: dict[str, IChannelAdapter]
    """
    pass
  def load_database(self, file_path : str, type : str = None) -> Database:
    """
    load data base.

      - **file_path** (str) – database path
            file_path could also have a specific structure in case the file_path is a db file
            :code:`db_file_path|database_name`
      - **type** (str) – type of database to parse.
            One of :code:`ethernet`, :code:`pdu`, :code:`can`.
            Default: auto detect.
    :return: database given in parameter
    :rtype: Database
    """
    pass

  pass

"""
Common type for all databases, see :doc:`/Scripting API/Databases` for possible implementations
"""
class Database:
  def get_path(self) -> str:
    """
    Gets the path of the database.

    :return: The path of the database
    :rtype: str
    """
    pass

  pass

"""
Represents a project timer object.
"""
class Timer:
  def get_running_time(self) -> c_float:
    """
    Method that returns the current duration since timer started.

    :return: Timer execution duration.
    :rtype: c_float
    """
    pass
  def get_state(self) -> TIMERSTATE:
    """
    Method that returns the current state of the timer.

    :return: Timer State
    :rtype: TIMERSTATE
    """
    pass
  def get_timeout(self) -> c_float:
    """
    Method that returns the Timeout value of the timer.

    :return: Timer timeout value
    :rtype: c_float
    """
    pass
  def pause(self):
    """
    Pauses the timer.

    """
    pass
  def reset(self):
    """
    Sets the timer’s time to zero.

    """
    pass
  def resume(self):
    """
    Resumes the timer.

    """
    pass
  def start(self):
    """
    Starts the timer, raising during the execution the on_time_elapsed and on_time_out events. It can be stopped at any time by calling stop.

    """
    pass
  def start(self, timeout : c_float):
    """
    Starts the timer, raising during the execution the on_time_elapsed and on_time_out events. It can be stopped at any time by calling stop.

      **timeout** (c_float) – (optional) the time that the timer will run is in milliseconds. In this case, there is no need to use stop because the timer will stop automatically when the defined time is over.
    """
    pass
  def stop(self):
    """
    Stops the timer.

    """
    pass
  def on_state_changed(self, arg : TimerStateChangedEventArg):
    """
    Event is triggered when the state of the timer changes, e.g. from running to stop. The Callback parameters are a Timer object that generated the event and the current_date, timestamp when the event is triggered. See Microsoft’s DateTime class for further information.

      **arg** (TimerStateChangedEventArg) – Timer monitored.
    """
    pass
  def on_time_elapsed(self, source : object, e : TimerElapsedEventArgs):
    """
    Event is triggered every time when the interval elapses, e.g. every second if the interval is set to :code:`1000` milliseconds. The Callback parameters are a Timer object that generated the event and the current_date, timestamp when the event is triggered. See Microsoft’s DateTime class for further information.

      - **source** (object) – Source of the event.
      - **e** (TimerElapsedEventArgs) – Timer to monitor.
    """
    pass
  def on_time_out(self, source : object, e : TimerElapsedEventArgs):
    """
    Event is triggered when the timeout is over, i.e. when the timer stops. The Callback parameters are a Timer object that generated the event, and the current_date, timestamp when the event is triggered. See Microsoft’s DateTime class for further information.

      - **source** (object) – Source of the event.
      - **e** (TimerElapsedEventArgs) – Timer to monitor.
    """
    pass
  interval : c_float

  name : str


  pass

"""
Used to detect if a timer is started or stopped.
"""
class TIMERSTATE(Enum):

  STOPPED = 0x00000000
  STARTED = 0x00000001
  pass

"""
Represents the Timer elapsed Event arguments. when a timer elapsed is triggered this object is passed to the event handler.
"""
class TimerElapsedEventArgs:
  time : DateTime


  pass

"""
Represents a timer state changed event arguments. when a timer state changes this object is passed to the event handlers that are subscribed to it.
"""
class TimerStateChangedEventArg:
  Timer : Timer


  pass

"""
Represents an RBS Ethernet ECU node.
"""
class EcuNodeEthernet:
  def call(self, selector : str, input_parameters : dict, transport_protocol : str = None, timeout : c_float = 1) -> dict:
    """
    Calls a consumed method to send SOME/IP message and return the output parameters. Follows an example :doc:`RBS Scripting <../../\Tutorials/rbs_scripting>` in documentation for more info.

      - **selector** (str) – selector can be service_id_or_name.method_id_or_name
      - **input_parameters** (dict) – dictionary contains the input parameters of a method and its default values
      - **transport_protocol** (str) – the protocol of the service. It can be UDP or TCP
      - **timeout** (c_float) – timout of response message in seconds
    :return: A dictionary contains the output parameters of a method and its values
    :rtype: dict
    """
    pass
  def disable(self, selector : str):
    """
    Disables a service, a method, an event or a field of the ecu.

      **selector** (str) – selector can be service_id_or_name and it can be service_id_or_name.member_id_or_name
    """
    pass
  def enable(self, selector : str):
    """
    Enables a service, a method, an event or a field of the ecu.

      **selector** (str) – selector can be service_id_or_name and it can be service_id_or_name.member_id_or_name
    """
    pass
  def get_config(self, config_path : str, config_property : str) -> decimal:
    """
    Gets the value of a specified config.

      - **config_path** (str) – The config_path is service_id_or_name@instance_id
      - **config_property** (str) – The config_property is port
    :return: The value of a specified config.
    :rtype: decimal
    """
    pass
  def get_mac(self, ip : str) -> str:
    """
    Finds the specific device with the specific IP address provided from the map and returns its MAC address.

      **ip** (str) – Desired IP address.
    :return: MAC address found.
    :rtype: str
    """
    pass
  def get_value(self, path : str, member : str = None) -> object:
    """
    Gets the value of a specific child of the ecu.

      - **path** (str) – The path to the child. follows a specific path format see :doc:`RBS Notations <../../Scripting API/Notations>` in documentation for more info
      - **member** (str) – [optional] The name of the member in the child, empty or :code:`None` means the entire child value will be returned.
    :return: The value of the child (member if member is not :code:`None`)
    :rtype: object
    """
    pass
  def reset(self) -> c_bool:
    """
    Resets the ECU.

    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def reset(self, service_id : c_uint16, instance_id : c_uint16) -> c_bool:
    """
    Attempts to reset the ECU node.

      - **service_id** (c_uint16) – Service identifier.
      - **instance_id** (c_uint16) – Instance identifier.
    :return: :code:`True` if reset was successful, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  def reset_value(self, path : str = None, member : str = None):
    """
    Resets the value of a specific child of the ecu to the default value.

      - **path** (str) – The path to the child. follows a specific path format see :doc:`RBS Notations <../../Scripting API/Notations>` in documentation for more info.empty or :code:`None` means the entire elements of the node will be reset.
      - **member** (str) – [optional] The name of the member in the child, empty or :code:`None` means the entire child value will be reset.
    """
    pass
  def set_config(self, config_path : str, config_property : str, value : decimal):
    """
    Sets the value of a specified config.

      - **config_path** (str) – The config_path is service_id_or_name@instance_id
      - **config_property** (str) – The config_property is port
      - **value** (decimal) – The config value
    """
    pass
  def set_mac(self, mac : str, p : str):
    """
    Sets the mac address (if empty) of the desired device by IP from the MAC/IP map.

      - **mac** (str) – Desired MAC address.
      - **p** (str) – Desired IP addresses
    """
    pass
  def set_value(self, path : str, value : object):
    """
    Sets the value of a specific child of the ecu to a specific value.

      - **path** (str) – The path to the child. follows a specific path format see :doc:`RBS Notations <../../Scripting API/Notations>` in documentation for more info.
      - **value** (object) – The value of the child/member to be set, :code:`None` means default value.
    """
    pass
  def set_value(self, path : str, member : str, value : object):
    """
    Sets the value of a specific child of the ecu to a specific value.

      - **path** (str) – The path to the child. follows a specific path format see :doc:`RBS Notations <../../Scripting API/Notations>` in documentation for more info.
      - **member** (str) – The name of the member in the child, :code:`None` means the entire child value will be set (use set_values(path, value) instead).
      - **value** (object) – The value of the child/member to be set, :code:`None` means default value.
    """
    pass
  def start(self):
    """
    Starts the ECU

    """
    pass
  def stop(self):
    """
    Stops the ECU.

    """
    pass
  def trigger(self, selector : str, transport_protocol : str = None):
    """
    Triggers an enabled provided field or event of the ecu to send SOME/IP message. Follows an example :doc:`RBS Scripting <../../\Tutorials/rbs_scripting>` in documentation for more info.

      - **selector** (str) – selector is service_id_or_name.instance_id.member_id_or_name
      - **transport_protocol** (str) – the protocol of the service. It can be UDP or TCP
    """
    pass
  def on_method_called(self, sender : object, e : MethodCalledArgs):
    """
    Gets the service id, service name , member_id, member_name and instance_id, request and response message when we send a SOME/IP message.

      - **sender** (object) – The source of the event.
      - **e** (MethodCalledArgs) – An object that contains the event data.
    """
    pass
  def on_receiving(self, sender : object, e : ReceivingEventArgs):
    """
    Event is triggered when we receive a message.See :doc:`Using node events <../../Tutorials/node_events>` for more information.

      - **sender** (object) – The source of the event.
      - **e** (ReceivingEventArgs) – An object that contains the event data.
    """
    pass
  def on_reset_ecu(self):
    """
    Event is triggered when the capture of Ethernet ECU RBS is reset.

    """
    pass
  def on_sending_sd(self, sender : object, e : SendingSomeIPSDEventArgs):
    """
    Event is triggered when a someip-sd has been sent. See :doc:`Using node events <../../Tutorials/node_events>` for more information.

      - **sender** (object) – The source of the event.
      - **e** (SendingSomeIPSDEventArgs) – An object that contains the event data.
    """
    pass
  def on_sending_someip(self, sender : object, e : SendingSomeIPEventArgs):
    """
    Event is triggered when a someip has been sent. See :doc:`Using node events <../../Tutorials/node_events>` for more information.

      - **sender** (object) – The source of the event.
      - **e** (SendingSomeIPEventArgs) – An object that contains the event data.
    """
    pass
  def on_start(self):
    """
    Event is triggered when the capture of Ethernet ECU RBS is started.

    """
    pass
  def on_stop(self):
    """
    Event is triggered when the capture of Ethernet ECU RBS is stopped.

    """
    pass
  def on_value_changed(self, sender : object, e : ValueChangedArgs):
    """
    Gets the new value , old value, service id, service name , member_id, member_name and instance_id when we set value of field or event and trigger it.

      - **sender** (object) – The source of the event.
      - **e** (ValueChangedArgs) – An object that contains the event data.
    """
    pass
  auto_fire : c_bool

  auto_fire_delay : c_int32

  auto_toggle_bit_length : c_int32

  auto_toggle_bit_position : c_int32

  auto_toggle_payload : c_bool

  data_base : Database

  enable_arp_manager : c_bool

  enable_icmp_manager : c_bool

  enable_nm_manager : ManagerState

  enable_sd_manager : ManagerState

  ip_address_source : str

  ip_multicast_address : str

  is_started : c_bool

  message_manager : IMessageManager

  nm_manager : INMMessageManager

  override_auto_fire_delays : c_bool

  override_auto_toggle_bit : c_bool

  port_connection : Port

  sd_manager : ISDMessageManager

  someip_manager : ISomeIPMessageManager


  pass

"""
Represents a SOME/IP-SD Manager object.
"""
class ISDMessageManager:
  def set_ttl(self, ttl : c_uint16):
    """
    Sets the Time To Live (TTL) of the messages to a specific value.

      **ttl** (c_uint16) – Desired TTL.
    """
    pass
  def sleep(self):
    """
    Forces the manager to a sleep state.

    """
    pass
  def start(self):
    """
    Starts the ECU

    """
    pass
  def stop(self):
    """
    Stops the ECU.

    """
    pass
  def wake_up(self):
    """
    Wakes up the manager (sets it to a wakeup and active state)

    """
    pass
  ecu_node : EcuNodeEthernet

  is_started : c_bool


  pass

"""
Represents an NM message manager object.
"""
class INMMessageManager:
  def accept(self, sd : MessageNM):
    """
    Get NM Message from MessageManager then calls the appropriate function and finally sends response if the manager is activated.

      **sd** (MessageNM) – Message to accept.
    """
    pass
  def open_network_management(self, clientInstanceID : c_int8):
    """
    Opens the network management of a client given its id.

      **clientInstanceID** (c_int8) – Client's id.
    """
    pass
  def release_network(self, functionPartialNetworkID : FunctionalPartialNet):
    """
    Releases a specific network given its id.

      **functionPartialNetworkID** (FunctionalPartialNet) – Desired functional partial network id.
    """
    pass
  def start(self):
    """
    Starts the ECU

    """
    pass
  def stop(self):
    """
    Stops the ECU.

    """
    pass
  def wakeup_server(self, basePartialNetworkID : BasePartialNet, functionPartialNetworkID : FunctionalPartialNet):
    """
    Send request to wake up another ECU.

      - **basePartialNetworkID** (BasePartialNet) – is the ECU ID in base partial network.
      - **functionPartialNetworkID** (FunctionalPartialNet) – function Partial Network ID is the ECU ID mask in function partial network.
    """
    pass
  connectionMac : str

  ecu_node : EcuNodeEthernet

  is_started : c_bool

  state : EcuNmState


  pass

"""
Represents an NM (network management protocol) Message object.
"""
class MessageNM:
  def capture(self, filter : Filter = None) -> MessageNM:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageNM
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageNM:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageNM
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageNM]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageNM]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def is_sending_cyclic(self) -> c_bool:
    """
    Checks if the message is sending cyclically.

    :return: :code:`True` if the message is sending cyclically. Otherwise, :code:`False`.
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageNM:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageNM
    """
    pass
  def receive(self, timeout : c_int32) -> MessageNM:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageNM
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageNM]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageNM]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> MessageNM:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: MessageNM
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[MessageNM]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[MessageNM]
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_cyclic_send(self, cycle_time_milliseconds : c_uint16):
    """
    Starts sending NM message cyclically for a possible cycle_time.

      **cycle_time_milliseconds** (c_uint16) – Max time in milliseconds to send the message cyclically.
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_cyclic_send(self):
    """
    Stops the sending cyclically activated with start_cyclic_send

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageNM):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageNM) – The message object being handled.
    """
    pass
  active_wakeup_bit : c_bool

  capture_info : CaptureInfo

  cbv : c_int8

  coordinator_sleep_ready : c_bool

  ctr_bs_prtnt_nm : IctrBs

  ctr_fktn_prtnt_nm : IctrFktn

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  length : c_uint32

  network_protocol : NetworkProtocols

  payload : Array[c_uint8]

  pni_bit : c_bool

  rpt_msg_request : c_bool

  source_node : c_int8

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  udp_header : HeaderUDP

  vlan_tag : HeaderVlan


  pass

"""
Used to select format when logging messages into a file.
"""
class FILEFORMAT(Enum):

  PCAP = 0x00000000
  pass

"""
Filter for incoming messages, can be created through :code:`andi.filters` module
            See :doc:`/Usage/Pcap_Filter` for more details about Pcap/NG filters.
::
  
              from andi.filters import pcap_filter
              filter = pcap_filter('arp or tcp')
"""
class Filter:

  pass

"""
Represents an UDP header object.
"""
class HeaderUDP:
  checksum : Optional[c_uint16]

  length : Optional[c_uint16]

  port_destination : c_uint16

  port_source : c_uint16

  protocol_type : TransportProtocols


  pass

"""
Used to check the protocol from the transport layer.
"""
class TransportProtocols(Enum):

  UDP = 0x00000000
  TCP = 0x00000001
  Unknown = 0x00000002
  ARP = 0x00000003
  ICMP = 0x00000004
  DHCP = 0x00000005
  IEEE1722 = 0x00000006
  IGMP = 0x00000007
  PTP = 0x00000008
  IP = 0x0000000A
  IPv6 = 0x0000000B
  ICMPv6 = 0x0000000C
  pass

"""
Represents an NM Message's ctrBs property.
"""
class IctrBs:
  def decode(self, p : c_uint16):
    """
    Decodes a given data and gives each attribute its proper value.

      **p** (c_uint16) – Data to decode.
    """
    pass
  kom_fahrbereitshaft_beenden : c_bool

  kom_fahrbereitshaft_herstellen : c_bool

  kom_fahren : c_bool

  kom_parken_bn_io : c_bool

  kom_parken_bn_nio : c_bool

  kom_pruefen_analyse_diagnose : c_bool

  kom_standfunktionen_kunde_nicht_im_fzg : c_bool

  kom_wohnen : c_bool


  pass

"""
Represents an NM Message's ctrFktn property.
"""
class IctrFktn:
  def decode(self, p : c_uint32):
    """
    Decodes a given data and gives each attribute its proper value.

      **p** (c_uint32) – Data to decode.
    """
    pass
  assistenz_parken_high : c_bool

  datenkommunikation : c_bool

  entertainmentbetrieb_fond : c_bool

  entretainmentbetreib : c_bool

  ethernet_infrastruktur : c_bool

  externe_kommunikation : c_bool

  fahrzeug_infrastruktur : c_bool

  fernwartung : c_bool

  klima_basis : c_bool

  klimabetrieb : c_bool

  konfiguration : c_bool

  laden : c_bool

  licht : c_bool

  rsu_hochvoltstuetzung : c_bool

  safe_exit : c_bool

  signal_unbefuellt : c_bool

  tn_48v : c_bool


  pass

"""
Represents an IPv4 header object.
"""
class HeaderIPv4:
  checksum : Optional[c_uint16]

  differentiated_services : c_uint8

  fragment_flag : c_uint8

  fragmentation_offset : c_uint16

  identification : c_uint16

  ihl : Optional[c_uint8]

  ip_address_destination : str

  ip_address_source : str

  length : Optional[c_uint16]

  option : IIPOptions

  protocol_byte : Optional[c_uint8]

  time_to_live : c_uint8

  version : Optional[c_uint8]


  pass

"""
Represents a collection of IPv4 header options.
"""
class IIPOptions:
  def addOptions(self, type : c_uint8):
    """
    Creates an option object and adds it to the list of options given its type.

      **type** (c_uint8) – Options type.
    """
    pass
  def addOptions(self, type : c_uint8, length : Optional[c_uint8], data : Array[c_uint8]):
    """
    Creates an option object and adds it to the list of options given its type, length and data.

      - **type** (c_uint8) – Option's type.
      - **length** (Optional[c_uint8]) – Option's length.
      - **data** (Array[c_uint8]) – Options, data.
    """
    pass
  List_options : List[IIPOption]

  Totallength : c_uint16


  pass

"""
Represents IPv4 header option object.
"""
class IIPOption:
  data : Array[c_uint8]

  length : Optional[c_uint8]

  type : c_uint8


  pass

"""
Represents an IPv6 header object.
"""
class HeaderIPv6:
  extension_headers : List[IExtensionHeader]

  flow_label : c_int32

  hop_limit : c_uint8

  ip_address_destination : str

  ip_address_source : str

  next_header : Optional[IPProtocol_Type]

  payload_length : Optional[c_uint16]

  trafic_class : c_uint8

  version : Optional[c_uint8]


  pass

"""
An enumeration that represents the different protocol type possible values.
"""
class IPProtocol_Type(Enum):

  HOPOPTS = 0x00000000
  ICMP = 0x00000001
  IGMP = 0x00000002
  IPIP = 0x00000004
  TCP = 0x00000006
  EGP = 0x00000008
  PUP = 0x0000000C
  UDP = 0x00000011
  IDP = 0x00000016
  TP = 0x0000001D
  IPV6 = 0x00000029
  ROUTING = 0x0000002B
  FRAGMENT = 0x0000002C
  RSVP = 0x0000002E
  GRE = 0x0000002F
  ESP = 0x00000032
  AH = 0x00000033
  ICMPV6 = 0x0000003A
  NONE = 0x0000003B
  DSTOPTS = 0x0000003C
  MTP = 0x0000005C
  ENCAP = 0x00000062
  PIM = 0x00000067
  COMP = 0x0000006C
  MOBILITY = 0x00000087
  HIPV2 = 0x0000008B
  SHIM6 = 0x0000008C
  MASK = 0x000000FF
  RAW = 0x000000FF
  pass

"""
Represents an IPv6 Extension Header.
"""
class IExtensionHeader:
  data : Array[c_uint8]

  header_type : IPProtocol_Type


  pass

"""
An enumeration that represents the possible Network Protocols (IPv4 or IPv6).
"""
class NetworkProtocols(Enum):

  IPv4 = 0x00000800
  IPv6 = 0x000086DD
  pass

"""
Represents the possible ethernet transport protocols (UDP or TCP).
"""
class Protocols(Enum):

  UDP = 0x00000000
  TCP = 0x00000001
  pass

"""
Represents a base type for transport protocols (TCP or UDP) headers.
"""
class HeaderTransport:
  checksum : Optional[c_uint16]

  port_destination : c_uint16

  port_source : c_uint16

  protocol_type : TransportProtocols


  pass

"""
Represents an IP header object (regardless of ip version).
"""
class HeaderIP:
  ip_address_destination : str

  ip_address_source : str

  version : Optional[c_uint8]


  pass

"""
Represents an Ethernet frame object.
"""
class HeaderEthernet:
  ether_type : EtherType

  mac_address_destination : str

  mac_address_source : str

  vlan_tag : HeaderVlan


  pass

"""
Used to check the type of an Ethernet message.
"""
class EtherType(Enum):

  Unknown = 0x00000000
  Loop = 0x00000060
  Echo = 0x00000200
  CANGATEWAY = 0x000004D2
  BRSPY2 = 0x00000789
  IpV4 = 0x00000800
  Arp = 0x00000806
  WakeOnLan = 0x00000842
  MGCANEthernetExtremRaw = 0x00001887
  BTSCANEthernetExtremRaw = 0x00001986
  BRSPYCANEthernetRaw = 0x00002085
  PLP = 0x00002090
  MSRP = 0x000022EA
  AvbTransportProtocol = 0x000022F0
  ReverseArp = 0x00008035
  AppleTalk = 0x0000809B
  AppleTalkArp = 0x000080F3
  VLanTaggedFrame = 0x00008100
  NovellInternetworkPacketExchange = 0x00008137
  Novell = 0x00008138
  IpV6 = 0x000086DD
  MacControl = 0x00008808
  CobraNet = 0x00008819
  MultiprotocolLabelSwitchingUnicast = 0x00008847
  MultiprotocolLabelSwitchingMulticast = 0x00008848
  PointToPointProtocolOverEthernetDiscoveryStage = 0x00008863
  PointToPointProtocolOverEthernetSessionStage = 0x00008864
  ExtensibleAuthenticationProtocolOverLan = 0x0000888E
  HyperScsi = 0x0000889A
  AtaOverEthernet = 0x000088A2
  EtherCatProtocol = 0x000088A4
  ProviderBridging = 0x000088A8
  LLDP = 0x000088CC
  SerialRealTimeCommunicationSystemIii = 0x000088CD
  CircuitEmulationServicesOverEthernet = 0x000088D8
  HomePlug = 0x000088E1
  MacSecurity = 0x000088E5
  MVRP = 0x000088F5
  MMRP = 0x000088F6
  PrecisionTimeProtocol = 0x000088F7
  ConnectivityFaultManagementOrOperationsAdministrationManagement = 0x00008902
  FibreChannelOverEthernet = 0x00008906
  FibreChannelOverEthernetInitializationProtocol = 0x00008914
  QInQ = 0x00009100
  TECMP = 0x000099FE
  BTSEVO = 0x0000BEBE
  VeritasLowLatencyTransport = 0x0000CAFE
  pass

"""
Represents a vlan header object.
"""
class HeaderVlan:
  qinq_cfi : c_bool

  qinq_priority_tag : c_uint8

  qinq_vlan : Optional[c_uint32]

  qinq_vlan_ethertype : c_uint16

  vlan : Optional[c_uint32]

  vlan_cfi : c_bool

  vlan_priority_tag : c_uint8


  pass

"""
Here you can find extra information about how the message was captured
            Gateway device could be a Spy or Converter, such as 1000BASE-T1 SPY
"""
class CaptureInfo:
  crc : Optional[c_uint64]

  direction : Optional[DataDirection]

  frame_number : c_int64

  gateway_address : str

  gateway_linklayer : Optional[LinkLayer]

  gateway_port : Optional[c_uint32]

  gateway_timestamp : Optional[decimal]

  gateway_type : Optional[GatewayType]

  interface_name : str

  timestamp : decimal


  pass

"""
Enumeration of the ether types of supported gateways.
"""
class GatewayType(Enum):

  BrSpyEth = 0x00002082
  BrSpyCan = 0x00002085
  Plp = 0x00002090
  BrSpyEthMini = 0x00002182
  BrSpyEthMiniLegacy = 0x00002183
  BrSpyEth1000TMini = 0x00002282
  TECMP = 0x000099FE
  BTSEVO = 0x0000BEBE
  pass

"""
An enumeration that represents the possible data direction values (Input or Output).
"""
class DataDirection(Enum):

  DIR_INPUT = 0x00000000
  DIR_OUTPUT = 0x00000001
  pass

"""
Enumeration of link types.
"""
class LinkLayer(Enum):

  Ethernet = 0x00000001
  FlexRay = 0x000000D2
  LIN = 0x000000D4
  CAN = 0x000000E3
  pass

"""
An enumeration that represents the possible base partial network values.
"""
class BasePartialNet(Enum):

  BPN_NO_COMMUNICATION = 0x00000000
  BPN_COM_PARKING_BN_OK = 0x00000001
  BPN_COM_PARKING_BN_NOT_OK = 0x00000002
  BPN_SIGNAL_INVALID = 0x0000FFFF
  pass

"""
An enumeration that represents the possible functional partial network values.
"""
class FunctionalPartialNet(Enum):

  FPN_CONFIGURATION = 0x00000001
  FPN_ETHERNET_INFRASTRUCTURE = 0x00000002
  FPN_CLIMATE_CONTROL = 0x00000100
  FPN_ENTERTAINMENTMODE = 0x00000200
  FPN_COMMUNICATION_BACKEND = 0x00000400
  FPN_PARKING_SYSTEM = 0x00001000
  FPN_CHARGING_SYSTEM = 0x00008000
  FPN_FAHRZEUG_INFRASTRUKTUR = 0x00010000
  pass

"""
An enumeration that represents the received status of an ECU from NM-daemon.
"""
class EcuNmState(Enum):

  unknown = 0x00000000
  wakeup = 0x00000001
  sleep = 0x00000002
  response = 0x00000003
  fail = 0x00000004
  pass

"""
Represents a message manager object.
"""
class IMessageManager:
  def start_arp_listener(self):
    """
    Starts ARP listener.

    """
    pass
  def start_icmp_listener(self):
    """
    Starts the ICMP listener.

    """
    pass
  def start_icmpv6_listener(self):
    """
    Starts the ICMPv6 listener.

    """
    pass
  def start_listen(self) -> c_bool:
    """
    Attempts to start listening process.

    :return: :code:`True` if operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def stop_arp_listener(self):
    """
    Stops the ARP listener.

    """
    pass
  def stop_icmp_listener(self):
    """
    Stop ICMP listener.

    """
    pass
  def stop_icmpv6_listener(self):
    """
    Stop ICMPv6 listener.

    """
    pass
  def stop_listen(self) -> c_bool:
    """
    Attempts to stop listening process.

    :return: :code:`True` if operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  ecu_node : EcuNodeEthernet


  pass

"""
Represents a SOME/IP message manager.
"""
class ISomeIPMessageManager:
  def fire_event(self, service_id : c_uint16, instance_id : c_uint16, event_id : c_uint16, transport_protocol : str = None) -> c_bool:
    """
    Attempts to fire an event.

      - **service_id** (c_uint16) – The provided service id.
      - **instance_id** (c_uint16) – The provided service instance id.
      - **event_id** (c_uint16) – The event id to fire.
      - **transport_protocol** (str) – the protocol of the event. It can be UDP or TCP
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def fire_field(self, service_id : c_uint16, instance_id : c_uint16, notifier_id : c_uint16, param : Array[object]) -> c_bool:
    """
    Attempts to fire a field.

      - **service_id** (c_uint16) – The provided service id.
      - **instance_id** (c_uint16) – The provided service instance id.
      - **notifier_id** (c_uint16) – The notifier id to fire.
      - **param** (Array[object]) – A list of the parameters of the node.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def fire_field(self, service_id : c_uint16, instance_id : c_uint16, notifier_id : c_uint16, transport_protocol : str = None) -> c_bool:
    """
    Attempts to fire a field.

      - **service_id** (c_uint16) – The provided service id.
      - **instance_id** (c_uint16) – The provided service instance id.
      - **notifier_id** (c_uint16) – The notifier id to fire.
      - **transport_protocol** (str) – the protocol of the field. It can be UDP or TCP
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def request_event(self, service_id : c_uint16, instance_id : c_uint16, event_id : c_uint16) -> c_bool:
    """
    Attempt to send an event request on a specific subscribed service.

      - **service_id** (c_uint16) – The subscribed service id.
      - **instance_id** (c_uint16) – The subscribed service instance id.
      - **event_id** (c_uint16) – The event id.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def send_getter(self, service_id : c_uint16, instance_id : c_uint16, getter_id : c_uint16) -> c_bool:
    """
    Attempt to send a setter on a specific subscribed service.

      - **service_id** (c_uint16) – The subscribed service id.
      - **instance_id** (c_uint16) – The subscribed service instance id.
      - **getter_id** (c_uint16) – The getter id.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def send_setter(self, service_id : c_uint16, instance_id : c_uint16, setter_id : c_uint16) -> c_bool:
    """
    Attempt to send a setter on a specific subscribed service.

      - **service_id** (c_uint16) – The subscribed service id.
      - **instance_id** (c_uint16) – The subscribed service instance id.
      - **setter_id** (c_uint16) – The setter id.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def start(self):
    """
    Starts the ECU

    """
    pass
  def stop(self):
    """
    Stops the ECU.

    """
    pass
  ecu_node : EcuNodeEthernet

  is_started : c_bool


  pass

"""
An enumeration that represents the possible manager states.
"""
class ManagerState(Enum):

  ACTIVATED = 0x00000000
  DEACTIVATED = 0x00000001
  pass

"""
Represents a port object, used to establish and manage a connection.
"""
class Port:
  mac : str

  port : c_uint16

  vlan : HeaderVlan


  pass

"""
Represents the event arguments that gets passed to the on_sending_someip event handler.
"""
class SendingSomeIPEventArgs:
  message : MessageSomeIP


  pass

"""
Represents a SOME/IP (Scalable service-Oriented MiddlewarE over IP) message.
"""
class MessageSomeIP:
  def append_message(self, message : IMessageInternetApplication):
    """
    Lets the user packs several messages into one packet, each appended message will have its own header.

      **message** (IMessageInternetApplication) – The message to append
    """
    pass
  def capture(self, filter : Filter = None) -> MessageSomeIP:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageSomeIP
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageSomeIP:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageSomeIP
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageSomeIP]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageSomeIP]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def connect(self, timeout : c_float = 1) -> c_bool:
    """
    Opens a TCP connection.

      **timeout** (c_float) – Number of seconds to wait for connection to establish before aborting.
    :return: for connect() returns :code:`True` if there’s a connection.
    :rtype: c_bool
    """
    pass
  def disconnect(self, timeout : c_float = 0):
    """
    Closes the TCP connection opened with connect.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_all_input_params(self) -> dict:
    """
    Retrieves all the encoded or decoded input parameters. Where, parameters and complex members are following the information from the database attached to the SOME/IP message (if the database is not set, an exception will be | | invoked) . If the deserialization is not possible (message ID does not exist in the database), an empty dictionary will be returned. When the parameters’ specification does not match the payload of the SOME/IP message (wrong | SOME/IP message following a database), an exception will be invoked: in this case the dictionary will be filled with deserialized valid parameters and completed with default value of no valid one.

    :return: Dictionary: “key” short name of the param. “value” DecodedParameter type.
    :rtype: dict
    """
    pass
  def get_all_output_params(self) -> dict:
    """
    Gets all the encoded or decoded output parameters.

    :return: Array of bytes representing the payload of the message
    :rtype: dict
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_field_param(self, value : str) -> object:
    """
    Gets the value of the field parameter.

      **value** (str) – The name of the parameter.
    :return: Field parameter.
    :rtype: object
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def get_input_param(self, value : str) -> object:
    """
    Gets the input parameter of the message.

      **value** (str) – The value of the parameter.
    :return: Parameter of field.
    :rtype: object
    """
    pass
  def get_input_parameters(self) -> Array[Parameter]:
    """
    Returns a list of input parameter object.

    :return: List of input parameters of the method/event.
    :rtype: Array[Parameter]
    """
    pass
  def get_input_parameters(self, service_id : c_uint16, method_id : c_uint16) -> Array[Parameter]:
    """
    Returns a list of input parameter object.

      - **service_id** (c_uint16) – (optional) Service identifier.
      - **method_id** (c_uint16) – (optional) Method/Event identifier.
    :return: List of input parameters of the method/event.
    :rtype: Array[Parameter]
    """
    pass
  def get_output_param(self, value : str) -> object:
    """
    Gets the output parameter of the message.

      **value** (str) – The value of the parameter.
    :return: The output parameter of method or event.
    :rtype: object
    """
    pass
  def get_output_parameters(self) -> Array[Parameter]:
    """
    Gets a list of the output parameters object

    :return: List of input parameters of the method/event.
    :rtype: Array[Parameter]
    """
    pass
  def get_output_parameters(self, service_id : c_uint16, method_id : c_uint16) -> Array[Parameter]:
    """
    Gets a list of the output parameters object

      - **service_id** (c_uint16) – (optional) Service identifier.
      - **method_id** (c_uint16) – (optional) Method/Event identifier.
    :return: List of input parameters of the method/event.
    :rtype: Array[Parameter]
    """
    pass
  def get_service_version(self) -> c_uint32:
    """
    Gets the service version of the message.

    :return: Service version of the message.
    :rtype: c_uint32
    """
    pass
  def has_dynamic_parameters(self) -> c_bool:
    """
    Checks if the message has dynamic parameters.

    :return: :code:`True` if the message has dynamic parameters. Otherwise, :code:`False`.
    :rtype: c_bool
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageSomeIP:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageSomeIP
    """
    pass
  def receive(self, timeout : c_int32) -> MessageSomeIP:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageSomeIP
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageSomeIP]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageSomeIP]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> MessageSomeIP:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: MessageSomeIP
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[MessageSomeIP]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[MessageSomeIP]
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def set_crc_value(self) -> c_uint32:
    """
    Calculates and retrieves the CRC identifier of SOME/IP message.

    :return: Returns the CRC identifier of the SOME/IP message. Otherwise, it returns to :code:`0`.
    :rtype: c_uint32
    """
    pass
  def set_field_param(self, param : str, value : object):
    """
    Sets the field or members of it (if it is complex) with values specified by the user.

      - **param** (str) – Name of the parameter to set.
      - **value** (object) – New value for the parameter.
    """
    pass
  def set_input_param(self, param : str, value : object):
    """
    Sets the parameter and members of it (if it is complex) with values specified by user.

      - **param** (str) – Name of the parameter to set.
      - **value** (object) – New value for the parameter.
    """
    pass
  def set_output_param(self, param : str, value : object):
    """
    Sets the parameter and members of it (if it is complex) with values specified by user.

      - **param** (str) – Name of the parameter to set.
      - **value** (object) – New value for the parameter.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_listener(self):
    """
    Starts listening for TCP clients through the receiver network adapter.

    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_listener(self, timeout : c_float = 0):
    """
    Stops listening for TCP clients through the receiver network adapter.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageSomeIP):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageSomeIP) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  connected : c_bool

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  messages : List[IMessageInternetApplication]

  network_protocol : NetworkProtocols

  payload : Array[c_uint8]

  payload_size : c_uint32

  protocol : Protocols

  someip_header : ISomeIPHeader

  tcp_header : HeaderTCP

  timestamp : decimal

  tp_header : ISomeIpTpHeader

  transport_header : HeaderTransport

  transport_protocol : Protocols

  udp_header : HeaderUDP

  vlan_tag : HeaderVlan


  pass

"""
Represents a parameter object.
"""
class Parameter:
  def get_bit_position(self) -> c_int32:
    """
    Retrieves the bit position of the current parameter.

    :return: Bit position of the parameter.
    :rtype: c_int32
    """
    pass
  def get_length(self) -> c_int32:
    """
    Retrieves the length of the current parameter.

    :return: Length of the parameter.
    :rtype: c_int32
    """
    pass
  def set_length(self, p0 : c_int32):
    """
    Sets the length of the parameter data.

      **p0** (c_int32) – Desired length.
    """
    pass
  def set_payload_offset(self, payloadOffset : c_int32):
    """
    Sets the offset of the payload.

      **payloadOffset** (c_int32) – Payload offset.
    """
    pass
  arrays : Array[ArrayDefinition]

  base_type : str

  basic_partial_network : Array[str]

  bit_length : c_int32

  compu_methods : List[ICompuMethod]

  description : str

  enumeration_elements : dict[str, str]

  functional_partial_network : Array[str]

  is_array : c_bool

  is_complex : c_bool

  is_enum : c_bool

  is_high_low_bit_order : Optional[c_bool]

  length_field_size : Optional[c_uint32]

  mandatory : c_bool

  manufacturer_extension : IManufacturerParameterExtension

  max_bit_length : Optional[c_uint32]

  members : Array[Parameter]

  min_bit_length : Optional[c_uint32]

  name : str

  position : c_int32

  signal : ISignal

  string_bom : c_bool

  string_encoding : str

  string_termination : Optional[c_char]

  tag_id : Optional[c_uint16]

  type_field_size : Optional[c_uint32]

  uuid : str


  pass

"""
Represents a Computation Method. A computation method that can be used to transform fixed-point representations of variables in the ECU memory into corresponding physical values and vice versa.
"""
class ICompuMethod:
  categorie : COMPU_METHOD_CATEGORY

  internal_to_phys : List[ICompuScale]

  name : str

  rationalCoeffs : List[IRationalCoeff]

  unit : Unit


  pass

"""
Represents a rational coefficient that is used when transforming values (follows AUTOSAR standard).
"""
class IRationalCoeff:
  denominator : c_float

  numerator1 : c_float

  numerator2 : c_float


  pass

"""
An enumeration that represents the category of the computation method.
"""
class COMPU_METHOD_CATEGORY(Enum):

  LINEAR = 0x00000001
  SCALE_LINEAR = 0x00000002
  TEXTTABLE = 0x00000003
  TABNOINTP = 0x00000004
  FORMULA = 0x00000005
  IDENTICAL = 0x00000006
  SCALE_LINEAR_AND_TEXTTABLE = 0x00000007
  BITFIELD_TEXTTABLE = 0x00000008
  UNKNOWN = 0x00000009
  pass

"""
Represents a unit of a physical value (as specified in AUTOSAR standards)
"""
class Unit:
  display_name : str

  id_string : str

  name : str


  pass

"""
Represents a computation scale of the computation method.
"""
class ICompuScale:
  compu_const : str

  desc_code : str

  lower_limit : Optional[c_float]

  mask : str

  rational_coeffs : IRationalCoeff

  upper_limit : Optional[c_float]


  pass

"""
Represents a parameter extension for manufacturer (as specified in FIBEX Standard).
"""
class IManufacturerParameterExtension:
  basic_partial_network : Array[str]

  crc_id : c_uint32

  functional_partial_network : Array[str]

  method : str

  type : DataTypeCategory


  pass

"""
An enumeration that represents the category of the data type (used to indicate vital data).
"""
class DataTypeCategory(Enum):

  ALIVE_COUNTER = 0x00000001
  CHECKSUM = 0x00000002
  OTHER = 0x00000003
  UNKNOWN = 0x00000004
  pass

"""
Represents a signal description from database
"""
class ISignal:
  def get_interpretations(self) -> dict[str, tuple[c_float, c_float]]:
    """
    Returns a dictionary of tuple (min_physical_value, max_physical_value)

    :return: Dictionary of tuple (min_physical_value, max_physical_value)
    :rtype: dict[str, tuple[c_float, c_float]]
    """
    pass
  def physical_to_raw(self, physical : c_float) -> c_uint64:
    """
    converts the physical measurement of the signal to its corresponding raw value

      **physical** (c_float) – the physical measurement of the signal
    :return: The raw value of the signal.
    :rtype: c_uint64
    """
    pass
  def raw_to_interpretation(self, raw : c_uint64) -> str:
    """
    Converts the raw value of the signal to its corresponding interpretation.

      **raw** (c_uint64) – The raw value to be converted.
    :return: Interpretation of the signal.
    :rtype: str
    """
    pass
  def raw_to_physical(self, raw : c_uint64) -> c_float:
    """
    converts the raw value of the signal to its corresponding physical measurement

      **raw** (c_uint64) – The raw value to be converted.
    :return: physical measurement of the signal.
    :rtype: c_float
    """
    pass
  base_data_type : str

  bit_length : c_int32

  compu_methods : List[ICompuMethod]

  crc_id : c_uint64

  id_string : str

  initial_value : Optional[c_uint64]

  lower_limit : Optional[c_float]

  method : str

  name : str

  signal_activation_configs : List[ISignalActivation]

  signal_type : str

  signal_type_attribute_name : str

  unit : str

  upper_limit : Optional[c_float]

  uuid : str

  validity : str


  pass

"""
Represents a condition in which the signal could be sent.
"""
class ISignalActivation:
  active_time : str

  category : str

  name : str

  quality : str


  pass

"""
Represents the Definition of an array for SOME/IP standard.
"""
class ArrayDefinition:
  is_dynamic : c_bool

  is_fixed : c_bool

  length_field_size : Optional[c_uint32]

  maximum_size : Optional[c_int32]

  minimum_size : c_int32


  pass

"""
Represents an Internet application message (over IP Protocol).
"""
class IMessageInternetApplication:
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  capture_info : CaptureInfo

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  network_protocol : NetworkProtocols

  payload : Array[c_uint8]

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  vlan_tag : HeaderVlan


  pass

"""
Represents a TCP message header object.
"""
class HeaderTCP:
  acknowledgement_number : c_uint32

  auto_port : c_bool

  checksum : Optional[c_uint16]

  data_offset : Optional[c_uint16]

  flags : c_int32

  flags_str : str

  option : IIPOptions

  port_destination : c_uint16

  port_source : c_uint16

  protocol_type : TransportProtocols

  sequence_number : c_uint32

  urgent_pointer : c_uint16

  window_size : c_uint16


  pass

"""
Represents a SOME/IP header object.
"""
class ISomeIPHeader:
  client_id : c_uint16

  interface_version : Optional[c_uint8]

  length : Optional[c_uint32]

  message_id : c_uint32

  message_type : MessageType

  method_identifier : c_uint16

  protocol_version : c_uint8

  request_id : c_uint32

  return_code : ReturnCode

  service_identifier : c_uint16

  session_id : c_uint16


  pass

"""
Used to figure out the type of a SOME/IP or SOME/IP-SD message.
"""
class MessageType(Enum):

  REQUEST = 0x00000000
  REQUEST_NO_RETURN = 0x00000001
  NOTIFICATION = 0x00000002
  TP = 0x00000020
  REQUEST_ACK = 0x00000040
  REQUEST_NO_RETURN_ACK = 0x00000041
  NOTIFICATION_ACK = 0x00000042
  RESPONSE = 0x00000080
  ERROR = 0x00000081
  RESPONSE_ACK = 0x000000C0
  ERROR_ACK = 0x000000C1
  UNKNOWN = 0x000000FF
  pass

"""
Used to determine the return code of SOME/IP and SOME/IP-SD messages.
"""
class ReturnCode(Enum):

  E_OK = 0x00000000
  E_NOT_OK = 0x00000001
  E_UNKNOWN_SERVICE = 0x00000002
  E_UNKNOWN_METHOD = 0x00000003
  E_NOT_READY = 0x00000004
  E_NOT_REACHABLE = 0x00000005
  E_TIMEOUT = 0x00000006
  E_WRONG_PROTOCOL_VERSION = 0x00000007
  E_WRONG_INTERFACE_VERSION = 0x00000008
  E_MALFORMED_MESSAGE = 0x00000009
  RESERVED = 0x00000020
  UNKNOWN = 0x000000FF
  pass

"""
SomeIP TP Header
"""
class ISomeIpTpHeader:
  flags : c_uint8

  more_segments : c_bool

  offset : c_int32


  pass

"""
Represents the event arguments that gets passed to the on_sending_sd event handler.
"""
class SendingSomeIPSDEventArgs:
  message : MessageSomeIPSD


  pass

"""
Represents a SOME/IP-SD (Scalable service-Oriented MiddlewarE over IP Service discovery) message object.
"""
class MessageSomeIPSD:
  def add_configuration_string_option(self, configuration : dict) -> Option:
    """
    Adds configuration options from a dictionary.

      **configuration** (dict) – A dictionary containing the configuration option strings.
    :return: Option containing the added configuration.
    :rtype: Option
    """
    pass
  def add_configuration_string_option(self, configuration : str) -> Option:
    """
    Creates an option of type “Configuration string” and adds it to the options array of the message, and updates length accordingly.

      **configuration** (str) – Configuration string.
    :return: Option created.
    :rtype: Option
    """
    pass
  def add_entries(self, entries : Array[Entry]) -> c_bool:
    """
    Adds a list of entries to the current entries of the message.

      **entries** (Array[Entry]) – List of entries to add.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def add_entry(self, e : Entry) -> c_bool:
    """
    Adds the entry to the entries array of the message, and updates length accordingly.

      **e** (Entry) – Entry to add.
    :return: :code:`True` if the entry is added, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  def add_find_entries(self, ecu_name : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Retrieves the entries of type FindService of the specific ECU and service, then adds it to the entries array of the message. Updating its length accordingly.

      - **ecu_name** (str) – Name of the desired ECU.
      - **service_id** (c_uint16) – Identifier of the service containing the method.
      - **including_all_services** (c_bool) – If :code:`True`, you will have all entries of consumed and provided services, if :code:`False` you will have only the entries of the consumed services.
    :return: List of entries created.
    :rtype: Array[Entry]
    """
    pass
  def add_find_service_entry(self, entry : Entry) -> Entry:
    """
    Creates an entry of type FindService and adds it to the entries array of the message, and updates length accordingly.

      **entry** (Entry) – Previously created FindService entry.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_find_service_entry(self, service_id : c_uint16, instance_id : c_uint16, ttl : c_int32, major_version : c_uint8, minor_version : c_uint32) -> Entry:
    """
    Creates an entry of type FindService and adds it to the entries array of the message, and updates length accordingly.

      - **service_id** (c_uint16) – Identifier of the service sought.
      - **instance_id** (c_uint16) – Identifier of the specific instance needed.
      - **ttl** (c_int32) – TTL of the Find message.
      - **major_version** (c_uint8) – Major version of the service.
      - **minor_version** (c_uint32) – Minor version of the service.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_ipv4_option(self, address : str, port : c_uint16, is_udp : c_bool, is_multicast : c_bool) -> Option:
    """
    Creates an option of type “IPv4”, which can be an endpoint or a multicast address, and adds it to the options array of the message, and updates length accordingly. If an entry is specified, a reference from this entry to the option will be added.

      - **address** (str) – IP address.
      - **port** (c_uint16) – Port number.
      - **is_udp** (c_bool) – Transport protocol used. :code:`True`, UDP. :code:`False`, TCP.
      - **is_multicast** (c_bool) – Flag that only SubscribeEventgroup entries that should set to :code:`True`, indicating that the SOME/IP messages of the subscribed service will be sent multicast.
    :return: Option created.
    :rtype: Option
    """
    pass
  def add_ipv4_option(self, entry : Entry, port : c_uint16, address : str, is_udp : c_bool, is_multicast : c_bool) -> Option:
    """
    Creates an option of type “IPv4”, which can be an endpoint or a multicast address, and adds it to the options array of the message, and updates length accordingly. If an entry is specified, a reference from this entry to the option will be added.

      - **entry** (Entry) – (optional) previously created entry.
      - **port** (c_uint16) – Port number.
      - **address** (str) – IP address.
      - **is_udp** (c_bool) – Transport protocol used. :code:`True`, UDP. :code:`False`, TCP.
      - **is_multicast** (c_bool) – Flag that only SubscribeEventgroup entries that should set to :code:`True`, indicating that the SOME/IP messages of the subscribed service will be sent multicast.
    :return: Option created.
    :rtype: Option
    """
    pass
  def add_ipv4_option(self, entry : Entry, port : c_uint16, address : str, is_udp : c_bool, is_multicast : c_bool, index : c_uint8) -> Option:
    """
    Creates an option of type “IPv4”, which can be an endpoint or a multicast address, and adds it to the options array of the message, and updates length accordingly. If an entry is specified, a reference from this entry to the option will be added.

      - **entry** (Entry) – (optional) previously created entry.
      - **port** (c_uint16) – Port number.
      - **address** (str) – IP address.
      - **is_udp** (c_bool) – Transport protocol used. :code:`True`, UDP. :code:`False`, TCP.
      - **is_multicast** (c_bool) – Boolean flag that only SubscribeEventgroup entries that should set to :code:`True`, indicating that the SOME/IP messages of the subscribed service will be sent multicast.
      - **index** (c_uint8) – (optional) index of the option in the options array.
    :return: Option created.
    :rtype: Option
    """
    pass
  def add_ipv6_option(self, address : str, port : c_uint16, is_udp : c_bool, is_multicast : c_bool) -> Option:
    """
    Creates an option of type “IPv6 endpoint” and adds it to the options array of the message, and updates length accordingly.

      - **address** (str) – IP address.
      - **port** (c_uint16) – Port number.
      - **is_udp** (c_bool) – Transport protocol used. :code:`True`, UDP. :code:`False`, TCP.
      - **is_multicast** (c_bool) – Flag that only SubscribeEventgroup entries that should set to :code:`True`, indicating that the SOME/IP messages of the subscribed service will be sent multicast.
    :return: Option created.
    :rtype: Option
    """
    pass
  def add_ipv6_option(self, entry : Entry, port : c_uint16, address : str, is_udp : c_bool, is_multicast : c_bool) -> Option:
    """
    Creates an option of type “IPv6 endpoint” and adds it to the options array of the message, and updates length accordingly.

      - **entry** (Entry) – (optional) previously created entry.
      - **port** (c_uint16) – Port number.
      - **address** (str) – IP address.
      - **is_udp** (c_bool) – Transport protocol used. :code:`True`, UDP. :code:`False`, TCP.
      - **is_multicast** (c_bool) – Flag that only SubscribeEventgroup entries that should set to :code:`True`, indicating that the SOME/IP messages of the subscribed service will be sent multicast.
    :return: Option created.
    :rtype: Option
    """
    pass
  def add_offer_entries(self, ecu_name : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Retrieves the entries of type OfferService of the specific ECU and service and adds it to the entries array of the message, and updates length accordingly.

      - **ecu_name** (str) – Name of the desired ECU.
      - **service_id** (c_uint16) – Identifier of the service containing the method.
      - **including_all_services** (c_bool) – If :code:`True`, you will have all entries of consumed and provided services, if :code:`False` you will have only the entries of the consumed services.
    :return: List Entry created.
    :rtype: Array[Entry]
    """
    pass
  def add_offer_service_entry(self, entry : Entry) -> Entry:
    """
    Creates an entry of type OfferService, adds it to the entries array of the message, and updates length accordingly.

      **entry** (Entry) – Previously created OfferService entry.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_offer_service_entry(self, service_id : c_uint16, instance_id : c_uint16, ttl : c_int32, major_version : c_uint8, minor_version : c_uint32) -> Entry:
    """
    Creates an entry of type OfferService, adds it to the entries array of the message, and updates length accordingly.

      - **service_id** (c_uint16) – Identifier of the service offered.
      - **instance_id** (c_uint16) – Identifier of the specific instance that offer the service.
      - **ttl** (c_int32) – TTL of the offer message.
      - **major_version** (c_uint8) – Major version of the service.
      - **minor_version** (c_uint32) – Minor version of the service.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_offer_service_entry(self, service_id : c_uint16, instance_id : c_uint16, ttl : c_int32, major_version : c_uint8, minor_version : c_uint32, options : object) -> Entry:
    """
    Creates an entry of type OfferService, adds it to the entries array of the message, and updates length accordingly.

      - **service_id** (c_uint16) – Identifier of the service offered.
      - **instance_id** (c_uint16) – Identifier of the specific instance that offer the service.
      - **ttl** (c_int32) – TTL of the offer message.
      - **major_version** (c_uint8) – Major version of the service.
      - **minor_version** (c_uint32) – Minor version of the service.
      - **options** (object) – List of options associated with the entry.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_option(self, entry : Entry, option : Option) -> Option:
    """
    Adds a given option, already created, to an entry.

      - **entry** (Entry) – Entry to which the option will be added.
      - **option** (Option) – Option to be added.
    :return: Option created.
    :rtype: Option
    """
    pass
  def add_stop_offer_service_entry(self, service_id : c_uint16, instance_id : c_uint16, major_version : c_uint8, minor_version : c_uint32) -> Entry:
    """
    Creates an entry of type OfferService, adds it to the entries array of the message, and updates length accordingly.

      - **service_id** (c_uint16) – Identifier of the service offered.
      - **instance_id** (c_uint16) – Identifier of the specific instance that offer the service.
      - **major_version** (c_uint8) – Major version of the service.
      - **minor_version** (c_uint32) – Minor version of the service.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_stop_offer_service_entry(self, service_id : c_uint16, instance_id : c_uint16, major_version : c_uint8, minor_version : c_uint32, options : object) -> Entry:
    """
    Creates an entry of type OfferService, adds it to the entries array of the message, and updates length accordingly.

      - **service_id** (c_uint16) – Identifier of the service offered.
      - **instance_id** (c_uint16) – Identifier of the specific instance that offer the service.
      - **major_version** (c_uint8) – Major version of the service.
      - **minor_version** (c_uint32) – MnorVersion, Minor version of the service.
      - **options** (object) – (optional) list of options associated with the entry.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_stop_subscribe_event_group_entry(self, entry : Entry, event_group_id : c_uint16) -> Entry:
    """
    Creates an entry of type StopSubscribeEventgroup, adds it to the entries array of the message, and updates length accordingly.

      - **entry** (Entry) – Previously created SubscribeEventgroup entry. The TTL will be changed to zero internally.
      - **event_group_id** (c_uint16) – Event group id.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_stop_subscribe_event_group_entry(self, service_id : c_uint16, instance_id : c_uint16, event_group_id : c_uint16, major_version : c_uint8) -> Entry:
    """
    Creates an entry of type StopSubscribeEventgroup, adds it to the entries array of the message, and updates length accordingly.

      - **service_id** (c_uint16) – Identifier of the service to which the subscription wants to be stopped.
      - **instance_id** (c_uint16) – Identifier of the service instance that includes the event group used for subscription.
      - **event_group_id** (c_uint16) – Event group ID.
      - **major_version** (c_uint8) – Major version of the service.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_subscribe_event_group_ack_entry(self, entry : Entry) -> Entry:
    """
    Creates an entry of type SubscribeEventgroupACK, adds it to the entries array of the message, and updates length accordingly.

      **entry** (Entry) – Entry.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_subscribe_event_group_ack_entry(self, service_id : c_uint16, instance_id : c_uint16, event_group_id : c_uint16, ttl : c_int32, major_version : c_uint8) -> Entry:
    """
    Creates an entry of type SubscribeEventgroupACK, adds it to the entries array of the message, and updates length accordingly.

      - **service_id** (c_uint16) – Identifier of the service to which the subscription is confirmed.
      - **instance_id** (c_uint16) – Identifier of the service instance that includes the event group used for subscription.
      - **event_group_id** (c_uint16) – Selected event group ID.
      - **ttl** (c_int32) – TTL of the Subscribe message.
      - **major_version** (c_uint8) – Major version of the service.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_subscribe_event_group_ack_entry(self, service_id : c_uint16, instance_id : c_uint16, event_group_id : c_uint16, ttl : c_int32, major_version : c_uint8, options : object) -> Entry:
    """
    Creates an entry of type SubscribeEventgroupACK, adds it to the entries array of the message, and updates length accordingly.

      - **service_id** (c_uint16) – Identifier of the service to which the subscription is confirmed.
      - **instance_id** (c_uint16) – Identifier of the service instance that includes the event group used for subscription.
      - **event_group_id** (c_uint16) – Selected event group ID.
      - **ttl** (c_int32) – TTL of the Subscribe message.
      - **major_version** (c_uint8) – Major version of the service.
      - **options** (object) – (optional) list of options associated with the entry.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_subscribe_event_group_entries(self, ecu_name : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Creates an entry of type SubscribeEventgroup based on the SubscribeEventgroup to which it responds, adds it to the entries array of the message, and updates length accordingly.

      - **ecu_name** (str) – Ecu name.
      - **service_id** (c_uint16) – Identifier of the service containing the method
      - **including_all_services** (c_bool) – If :code:`True`, you will have all entries of the consumed and provided services, if :code:`False` you will have only the entries of the consumed services.
    :return: List of entries created.
    :rtype: Array[Entry]
    """
    pass
  def add_subscribe_event_group_entry(self, entry : Entry, event_group_id : c_uint16) -> Entry:
    """
    Creates an entry of type SubscribeEventgroup based on the SubscribeEventgroup to which it responds, adds it to the entries array of the message, and updates length accordingly.

      - **entry** (Entry) – Previously created SubscribeEventgroup entry. The TTL will be changed to zero internally.
      - **event_group_id** (c_uint16) – Event group ID.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_subscribe_event_group_entry(self, service_id : c_uint16, instance_id : c_uint16, event_group_id : c_uint16, ttl : c_int32, major_version : c_uint8) -> Entry:
    """
    Creates an entry of type SubscribeEventgroup based on the SubscribeEventgroup to which it responds, adds it to the entries array of the message, and updates length accordingly.

      - **service_id** (c_uint16) – Service identifier.
      - **instance_id** (c_uint16) – Identifier of the service instance that includes the event group used for subscription.
      - **event_group_id** (c_uint16) – Selected event group ID.
      - **ttl** (c_int32) – TTL of the Subscribe message.
      - **major_version** (c_uint8) – Major version of the service.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_subscribe_event_group_entry(self, service_id : c_uint16, instance_id : c_uint16, event_group_id : c_uint16, ttl : c_int32, major_version : c_uint8, options : object) -> Entry:
    """
    Creates an entry of type SubscribeEventgroup based on the SubscribeEventgroup to which it responds, adds it to the entries array of the message, and updates length accordingly.

      - **service_id** (c_uint16) – Service identifier.
      - **instance_id** (c_uint16) – Identifier of the service instance that includes the event group used for subscription.
      - **event_group_id** (c_uint16) – Selected event group ID.
      - **ttl** (c_int32) – TTL of the Subscribe message.
      - **major_version** (c_uint8) – Major version of the service.
      - **options** (object) – (optional) list of options associated with the entry.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def add_subscribe_event_group_nack_entry(self, entry : Entry) -> Entry:
    """
    Creates an entry of type SubscribeEventgroupNACK based on the SubscribeEventgroup to which it responds, adds it to the entries array of the message, and updates length accordingly.

      **entry** (Entry) – SubscribeEventgroup entry to answer.
    :return: Entry created.
    :rtype: Entry
    """
    pass
  def append_message(self, message : MessageSomeIPSD):
    """
    Lets the user packs several messages into one packet, each appended message will have its own header.

      **message** (MessageSomeIPSD) – The message to append
    """
    pass
  def capture(self, filter : Filter = None) -> MessageSomeIPSD:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageSomeIPSD
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageSomeIPSD:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageSomeIPSD
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageSomeIPSD]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageSomeIPSD]
    """
    pass
  def clear_entries(self):
    """
    Empties the entries array to be able to use the same message several times.

    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def encapsulate_packet(self, message : Message):
    """
    Sets the encapsulated_packet of the message.

      **message** (Message) – , message to set.
    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_all_entries(self) -> List[Entry]:
    """
    Gets the content of the array entries of the message which is equivalent to the property entries.

    :return: List of entries contained the message.
    :rtype: List[Entry]
    """
    pass
  def get_all_options(self) -> List[Option]:
    """
    Gets the content of the array options of the message which is similar to the property options.

    :return: List of options contained the message.
    :rtype: List[Option]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_entries_of_type(self, type : c_int32) -> List[Entry]:
    """
    Gets a list of all the entries of type in the message.

      **type** (c_int32) – Entry type. See Entry type enum (:class:`EntryType`) for a list of valid values.
    :return: List of entries that match the desired type.
    :rtype: List[Entry]
    """
    pass
  def get_find_service_entries(self) -> List[Entry]:
    """
    Gets a list of all the entries of type FindService found in the message.

    :return: List of FindService entries.
    :rtype: List[Entry]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def get_offer_service_entries(self) -> List[Entry]:
    """
    Gets a list of all the entries of type OfferService found in the message.

    :return: List of OfferService entries.
    :rtype: List[Entry]
    """
    pass
  def get_stop_offer_service_entries(self) -> List[Entry]:
    """
    Gets a list of all the entries of type StopOfferService found in the message.

    :return: List of StopOfferServic entries.
    :rtype: List[Entry]
    """
    pass
  def get_stop_subscribe_event_group_entries(self) -> List[Entry]:
    """
    Gets a list of all the entries of type SubscribeEventgroup found in the message.

    :return: List of SubscribeEventgroup entries.
    :rtype: List[Entry]
    """
    pass
  def get_subscribe_event_group_ack_entries(self) -> List[Entry]:
    """
    Gets a list of all the entries of type SubscribeEventgroupACK found in the message.

    :return: List of SubscribeEventgroupACK entries.
    :rtype: List[Entry]
    """
    pass
  def get_subscribe_event_group_entries(self) -> List[Entry]:
    """
    Gets a list of all the entries of type SubscribeEventgroup found in the message.

    :return: List of SubscribeEventgroup entries.
    :rtype: List[Entry]
    """
    pass
  def get_subscribe_event_group_nack_entries(self) -> List[Entry]:
    """
    Gets a list of all the entries of type SubscribeEventgroupNACK found in the message.

    :return: List of SubscribeEventgroupNACK entries .
    :rtype: List[Entry]
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageSomeIPSD:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageSomeIPSD
    """
    pass
  def receive(self, timeout : c_int32) -> MessageSomeIPSD:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageSomeIPSD
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageSomeIPSD]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageSomeIPSD]
    """
    pass
  def request_service(self, timeout : c_int32) -> tuple[IMessageBase]:
    """
    Listens to the Ethernet bus for a while and returns a list with all the SOME/IP messages captured in that period containing the entry type of RequestService.

      **timeout** (c_int32) – Max time in milliseconds to wait for a response.
    :return: List of messages containing the entry type of RequestService, captured from the Ethernet bus during a given period of time.
    :rtype: tuple[IMessageBase]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> MessageSomeIPSD:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: MessageSomeIPSD
    """
    pass
  def send_receive_find(self, timeout : c_int32) -> tuple[IMessageBase]:
    """
    Sends the message if it contains at least one entry of type FindService and waits for responses during a certain period of time. An exception is thrown if the message contains no FindService entries.

      **timeout** (c_int32) – Max time in milliseconds to wait for a response.
    :return: List of SOME/IP-SD messages as a response to the Find message sent.
    :rtype: tuple[IMessageBase]
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[MessageSomeIPSD]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[MessageSomeIPSD]
    """
    pass
  def send_receive_offer(self, timeout : c_int32) -> tuple[IMessageBase]:
    """
    Sends the message if it contains at least one entry of type OfferService and waits for responses during a certain period of time. An exception is thrown if the message contains no OfferService entries.

      **timeout** (c_int32) – Max time in milliseconds to wait for a response.
    :return: List of SOME/IP-SD messages as a response to the Offer message sent.
    :rtype: tuple[IMessageBase]
    """
    pass
  def send_receive_subscribe(self, timeout : c_int32) -> tuple[IMessageBase]:
    """
    Sends the message if it contains at least one entry of type SubscribeEventgroup and waits for responses during a certain period of time. An exception is thrown if the message contains no Subscribe entries.

      **timeout** (c_int32) – Max time in milliseconds to wait for a response.
    :return: List of SOME/IP-SD messages as a response to the Subscribe message sent.
    :rtype: tuple[IMessageBase]
    """
    pass
  def send_stop_offer(self, offer_entry : Entry):
    """
    Sends a given stop offer.

      **offer_entry** (Entry) – Stop offer entry.
    """
    pass
  def send_stop_subscribe(self, subscribe_evt_grp_entry : Entry):
    """
    Creates a StopSubscribeEventgroup entry for the SubscribeEventgroup specified as a parameter, adds it to the message (clearing first the entries array) and sends it. No response is expected, so nothing is returned in this case.

      **subscribe_evt_grp_entry** (Entry) – SubscribeEventgroup entry for the service to unsubscribe to.
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageSomeIPSD):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageSomeIPSD) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  data_base : Database

  encapsulated_packet : Message

  entries : List[Entry]

  ethernet_header : HeaderEthernet

  flags : c_uint8

  frame_number : c_int64

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  is_reboot : c_bool

  length_of_options_array : Optional[c_uint32]

  messages : List[MessageSomeIPSD]

  network_protocol : NetworkProtocols

  options : List[Option]

  payload : Array[c_uint8]

  reboot_flag : c_bool

  reserved : c_uint32

  someip_header : ISomeIPHeader

  someip_sd_header : ISDHeader

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  udp_header : HeaderUDP

  unicast_flag : c_bool

  vlan_tag : HeaderVlan


  pass

"""
Represents a SOME/IP Entry object.
"""
class Entry:
  def add_ipv4_option(self, port : c_uint16, address : str, is_udp : c_bool, is_multicast : c_bool) -> Option:
    """
    Creates an IPv4 endpoint option over UDP or TCP from the parameters given and attaches it to the entry, updating the corresponding fields (index and number of options) to reflect the addition.

      - **port** (c_uint16) – UDP or TCP port number.
      - **address** (str) – IPv4 address.
      - **is_udp** (c_bool) – :code:`True` if it’s over UDP . :code:`False` otherwise.
      - **is_multicast** (c_bool) – :code:`True` if the option is used in a SusbcribeEventgroupAck entry to indicate that the events/methods of the subscribed service will be sent multicast.:code:`False` otherwise.
    :return: IPv4 endpoint option over UDP or TCP.
    :rtype: Option
    """
    pass
  def contains_op(self, option : Option) -> c_bool:
    """
    Verifies if the put option put it in parameter exists in option list

      **option** (Option) – Option to set.
    :return: The index of option in option list. :code:`-1` if it does not exist.
    :rtype: c_bool
    """
    pass
  def set_option_tcp(self, port : c_uint16, address : str, isMulticast : c_bool):
    """
    Creates an IPv4 endpoint option over TCP from the parameters given and attaches it to the entry, updating the corresponding fields(index and number of options) to reflect the addition.

      - **port** (c_uint16) – TCP port number.
      - **address** (str) – IPv4 address.
      - **isMulticast** (c_bool) – :code:`True` if the option is used in a SusbcribeEventgroupAck entry to indicate that the events/methods of the subscribed
    """
    pass
  def set_option_tcp_by_instance_id(self) -> c_bool:
    """
    Creates an IPv4 endpoint option over TCP from the info found in the Fibex database for the service id and instance id of the entry and attaches it to the entry. To get that, it performs the following actions, It searches the Fibex database for the service instance associated to the instance id and service id of the entry, then checks if this service instance has TCP among the defined transport protocols, If so, it gets the IP address and TCP port from this service instance, With the gathered info, it creates the TCP IPv4 endpoint option and adds it to the entry.

    :return: :code:`True` if the option could be successfully added. :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_option_udp(self, port : c_uint16, address : str, isMulticast : c_bool):
    """
    Creates an IPv4 endpoint option over UDP from the parameters given and attaches it to the entry, updating the corresponding fields(index and number of options) to reflect the addition.

      - **port** (c_uint16) – UDP port number.
      - **address** (str) – IPv4 address.
      - **isMulticast** (c_bool) – :code:`True` if the option is used in a SusbcribeEventgroupAck entry to indicate that the events/methods of the subscribed.
    """
    pass
  def set_option_udp_by_instance_id(self) -> c_bool:
    """
    Creates an IPv4 endpoint option over UDP from the info found in the Fibex database for the service id and instance id of the entry and attaches it to the entry. To get that, it performs the following actions, It searches the Fibex database for the service instance associated to the instance id and service id of the entry, then checks if this service instance has UDP among the defined transport protocols, If so, it gets the IP address and UDP port from this service instance, With the gathered info, it creates the UDP IPv4 endpoint option and adds it to the entry.

    :return: :code:`True` if the option could be successfully added. :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  counter : c_uint8

  entry_type : c_uint8

  event_group_id : c_uint16

  flag_op_1 : c_uint8

  flag_op_2 : c_uint8

  index_op_1 : c_uint8

  index_op_2 : c_uint8

  initial_data_req : c_uint8

  instance_id : c_uint16

  major_version : c_uint8

  minor_version : c_uint32

  options : List[Option]

  reserved : c_uint16

  reserved2 : c_uint8

  service_id : c_uint16

  string_entry_type : str

  ttl : c_int32

  type : EntryType


  pass

"""
Represents a SOME/IP options object.
"""
class Option:
  def get_default_option_length(self) -> c_uint16:
    """
    Returns the default option's length.

    :return: Default option's length.
    :rtype: c_uint16
    """
    pass
  def is_configuration_string(self) -> c_bool:
    """
    Checks if the option is of type “configuration string”

    :return: :code:`True` if the option is of type “configuration string”. :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def is_endpoint(self) -> c_bool:
    """
    Checks if the type of the option is “ipv4_endpoint” or “ipv6_endpoint”.

    :return: :code:`True` if the option is of type “endpoint”, either IPv4 or IPv6. :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def is_ipv4(self) -> c_bool:
    """
    Checks if the option references an IPv4 address, either endpoint or multicast.

    :return: :code:`True` if the option refers to an IPv4 address. :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def is_ipv4_endpoint(self) -> c_bool:
    """
    Checks if the option is exclusively of type “ipv4_multicast”.

    :return: :code:`True` if the option is an IPv4 multicast address. :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def is_ipv4_multicast(self) -> c_bool:
    """
    Checks if the option is exclusively of type “ipv4_multicast”.

    :return: :code:`True` if the option is an IPv4 multicast address. :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def is_ipv6(self) -> c_bool:
    """
    Checks if the option references an IPv6 address, either endpoint or multicast.

    :return: :code:`True` if the option refers to an IPv6 address. :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def is_ipv6_endpoint(self) -> c_bool:
    """
    Checks if the option is exclusively of type “ipv6_endpoint”.

    :return: :code:`True` if the option is an IPv6 endpoint address. :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def is_ipv6_multicast(self) -> c_bool:
    """
    Checks if the option is exclusively of type “ipv6_multicast”.

    :return: :code:`True` if the option is an IPv6 multicast address. :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def is_multicast(self) -> c_bool:
    """
    Checks if the option is exclusively of type “ipv4_multicast” or “ipv6_multicast”.

    :return: :code:`True` if the option is of type “multicast”, either IPv4 or IPv6.:code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  configuration : str

  endpoint_type : EndPointType

  index : c_int32

  ip_address : str

  ipv6_address : str

  length : Optional[c_uint16]

  option_port : c_uint16

  option_type : c_uint8

  protocol : c_uint8

  reserved_byte : c_uint8

  Type : TransType


  pass

"""
An enumeration that represents the possible transport protocol types (UDP or TCP or unknown).
"""
class TransType(Enum):

  unknown = 0x00000000
  tcp = 0x00000006
  udp = 0x00000011
  pass

"""
Used to check the type of an option contained in a message or referred to by an entry.
"""
class EndPointType(Enum):

  unknown = 0x00000000
  OptionConfigurationString = 0x00000001
  OptionIPv4Type = 0x00000004
  OptionIPv6Type = 0x00000006
  OptionIPv4MulticastType = 0x00000014
  OptionIPv6MulticastType = 0x00000016
  pass

"""
Used to determine the type of a SOME/IP-SD entry.
"""
class EntryType(Enum):

  FindService = 0x00000000
  OfferService = 0x00000001
  RequestService = 0x00000002
  RequestServiceAck = 0x00000003
  FindEventGroup = 0x00000004
  PublishEventGroup = 0x00000005
  SubscribeEventGroup = 0x00000006
  SubscribeEventGroupAck = 0x00000007
  pass

"""
Represent a base message object. for possible implementations see :doc:`/Scripting API/Messages`.
"""
class Message:
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  capture_info : CaptureInfo

  data_base : Database

  frame_number : c_int64

  payload : Array[c_uint8]

  timestamp : decimal


  pass

"""
Represents a Common type for all messages, see :doc:`/Scripting API/Messages` for possible implementations.
"""
class IMessageBase:
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  capture_info : CaptureInfo

  data_base : Database

  frame_number : c_int64

  payload : Array[c_uint8]

  timestamp : decimal


  pass

"""
Represents an SD header for SOME/IP-SD message.
"""
class ISDHeader:
  flags : c_uint8

  initial_data_flag : c_bool

  reboot_flag : c_bool

  reserved : c_uint32

  unicast_flag : c_bool


  pass

"""
Represents the event arguments that gets passed to the on_receiving event handler.
"""
class ReceivingEventArgs:
  message : IMessageBase

  protocol : str


  pass

"""
Event or field triggered every time the payload value has been changed.
"""
class ValueChangedArgs:
  def match(self, selector : str) -> c_bool:
    """
    identify which service or member with the value change

      **selector** (str) – selector is service_id_or_name.instance_id.member_id_or_name
    :return: :code:`True` if the selector exist in the node. Otherwise, :code:`False`
    :rtype: c_bool
    """
    pass
  ecu : EcuNodeEthernet

  instance_id : c_uint16

  member_id : c_uint16

  member_name : str

  new_value : object

  old_value : object

  service_id : c_uint16

  service_name : str


  pass

"""
Method called when receiving a request message
"""
class MethodCalledArgs:
  def match(self, selector : str) -> c_bool:
    """
    identify the method that send a request SOME/IP message

      **selector** (str) – selector is service_id_or_name.instance_id.method_id_or_name
    :return: :code:`True` if it's the same selector that send a SOME/IP message. Otherwise, :code:`False`
    :rtype: c_bool
    """
    pass
  ecu : EcuNodeEthernet

  instance_id : c_uint16

  method_id : c_uint16

  method_name : str

  request : dict

  response : dict

  service_id : c_uint16

  service_name : str


  pass

"""
Represents a base Channel Adapter.
"""
class IChannelAdapter:
  cluster_name : str

  name : str


  pass

"""
This variable is available as :code:`andi` global variable.
"""
class Adapter:
  def create_channel(self) -> IChannelAdapter:
    """
    Creates a channel.

    :return: Channel adapter.
    :rtype: IChannelAdapter
    """
    pass
  description : str

  id : str


  pass

"""
Represents vendor data field in a tecmp bus status message.
"""
class BusData:
  channel_id : c_uint32

  total_errors : c_uint32

  total_messages : c_uint32

  vendor_data : BusVendorData


  pass

"""
Represents vendor data in tecmp bus status message.
"""
class BusVendorData:
  link_quality : c_uint8

  link_status : c_uint8

  linkup_time : c_uint16


  pass

"""
Represents bus status in tecmp message.
"""
class BusStatus:
  bus_data : Array[BusData]

  cm_id : c_uint16

  cm_type : c_uint8

  cm_version : c_uint8

  serial_number : c_uint32

  vendor_id : c_uint8


  pass

"""
Represents capture module status in tecmp message.
"""
class CmStatus:
  cm_id : c_uint16

  cm_type : c_uint8

  cm_version : c_uint8

  serial_number : c_uint32

  vendor_data : CmVendorData

  vendor_id : c_uint8


  pass

"""
Represents vendor data in tecmp capture module status message.
"""
class CmVendorData:
  buffer_fill_level : c_uint8

  buffer_overflow : c_uint8

  buffer_size : c_uint32

  chassis_temperature : Optional[c_int8]

  hw_version : Array[c_uint8]

  lifecycle : c_uint64

  silicon_temperature : Optional[c_int8]

  sw_version : Array[c_uint8]

  temperature : Optional[c_uint8]

  voltage_fractional_part : c_uint8

  voltage_integer_part : c_uint8


  pass

"""
Represents control message in tecmp message.
"""
class ControlMessageData:
  control_message_id : c_uint16

  device_id : c_uint16

  timestamp : decimal

  vendor_data : Array[c_uint8]


  pass

"""
Class responsible for IP operations
"""
class IP:
  def get_protocol(self, addr : str) -> Optional[NetworkProtocols]:
    """
    Check the network protocol of an address

      **addr** (str) – Address to check
    :return: The network protocol of the address
    :rtype: Optional[NetworkProtocols]
    """
    pass
  def get_solicited_multicast_address(self, ip : str) -> str:
    """
    The multicast address is calculated using this formula: https://en.wikipedia.org/wiki/Solicited-node_multicast_address

      **ip** (str) – Address used to calculate multicast address
    :return: The solicited multicast address
    :rtype: str
    """
    pass
  def is_ipv4(self, addr : str) -> c_bool:
    """
    Check if an address is a valid IPv4 address

      **addr** (str) – Address to check
    :rtype: c_bool
    """
    pass
  def is_ipv6(self, addr : str) -> c_bool:
    """
    Check if an address is a valid IPv6 address

      **addr** (str) – Address to check
    :rtype: c_bool
    """
    pass
  def is_multicast(self, addr : str) -> c_bool:
    """
    Check if the address provided is a multicast address.

      **addr** (str) – Address to check
    :rtype: c_bool
    """
    pass
  def is_private(self, addr : str) -> c_bool:
    """
    Check if an address is a private address.

      **addr** (str) – Address to check
    :rtype: c_bool
    """
    pass

  pass

"""
Represents Series Builder for signal analysis.
"""
class SeriesBuilder:
  def bitrate(self, sampling_time : Optional[decimal] = None, control_bitrate : c_uint32 = 500000, data_bitrate : c_uint32 = 2000000) -> Series:
    """
    Creates a BitRate Series object.

      - **sampling_time** (Optional[decimal]) – sampling time in seconds
      - **control_bitrate** (c_uint32) – control sampling time in bit/second
      - **data_bitrate** (c_uint32) – data sampling time in bit/second
    :return: BitRate Series object.
    :rtype: Series
    """
    pass
  def deltatime(self) -> Series:
    """
    Creates a DeltaTime Series object.

    :return: DeltaTime Series object.
    :rtype: Series
    """
    pass
  def packetrate(self, sampling_time : Optional[decimal] = None) -> Series:
    """
    Creates a PacketRate Series object.

      **sampling_time** (Optional[decimal]) – sampling time in seconds(default value will be considered as one second).
    :return: PacketRate Series object.
    :rtype: Series
    """
    pass

  pass

"""
Represents a list of points (timestamp, value) of the signals analysis
"""
class Series:
  def add(self, message : IMessageBase):
    """
    Add a point to the list from a message object.

      **message** (IMessageBase) – a message object
    """
    pass
  values : tuple[DataPoint]


  pass

"""
Represents a point in the data space.
"""
class DataPoint:
  def IsDefined(self) -> c_bool:
    """
    Determines whether this point is defined.

    :return: :code:`true` if this point is defined; otherwise, :code:`false`.
    :rtype: c_bool
    """
    pass
  def ToCode(self) -> str:
    """
    Returns C# code that generates this instance.

    :return: The to code.
    :rtype: str
    """
    pass
  def ToCode(self) -> str:
    """
    Returns C# code that generates this instance.

    :return: The C# code.
    :rtype: str
    """
    pass
  X : c_float

  Y : c_float


  pass

"""
Represents a base RBS node.
"""
class Node:

  pass

"""
Represents an RBS CAN ECU node object.
"""
class EcuNodeCAN:
  def disable(self, message : str):
    """
    Disables a message of the ecu.

      **message** (str) – message can be message_name or message_id. Examples: "ST_ENERG_GEN", "*"(this is to indicate that this applies to all messages of the ECU.)
    """
    pass
  def enable(self, message : str):
    """
    Enables a message of the ecu.

      **message** (str) – message can be message_name or message_id. Examples: "ST_ENERG_GEN", "*"(this is to indicate that this applies to all messages of the ECU.)
    """
    pass
  def get_value(self, message : str) -> dict:
    """
    Gets the values of the signals of the specified message of the ecu.

      **message** (str) – The path to the message. Examples: "ST_ENERG_GEN".
    :return: The values of the signals of the specified message
    :rtype: dict
    """
    pass
  def get_value(self, message : str, signal : str) -> int:
    """
    Gets the value of a specific signal of a message of the ecu.

      - **message** (str) – The path to the message. Examples: "ST_ENERG_GEN".
      - **signal** (str) – The name of the signal.
    :return: The value of the signal
    :rtype: int
    """
    pass
  def reset(self) -> c_bool:
    """
    Resets the ECU.

    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def reset_value(self, message : str = None, signal : str = None):
    """
    Resets the value of a specific message/signal of the ecu to the default value.

      - **message** (str) – [optional] The path to the message. Examples: "ST_ENERG_GEN", "*"(this is to indicate that this applies to all messages of the ECU.) .empty or :code:`None` means the entire messages of the ECU will be reset.
      - **signal** (str) – [optional] The name of the signal, empty or :code:`None` means all the signals values of the message will be reset.
    """
    pass
  def set_value(self, message : str, value : dict):
    """
    Sets the value of (a) signal(s) of the message to a specific value.

      - **message** (str) – The path to the message. Examples: "ST_ENERG_GEN", "*"(this is to indicate that this applies to all messages of the ECU.)
      - **value** (dict) – The value of the signal(s) to be set, :code:`None` means default value.
    """
    pass
  def set_value(self, message : str, signal : str, value : Optional[int]):
    """
    Sets the value of the signal of the specified message to a specific value.

      - **message** (str) – The path to the message. Examples: "ST_ENERG_GEN", "*"(this is to indicate that this applies to all messages of the ECU.)
      - **signal** (str) – The name of the signal to be set, :code:`None` means default value.
      - **value** (Optional[int]) – The value of the signal to be set, :code:`None` means default value.
    """
    pass
  def signal(self, signalName : str) -> SignalValue:
    """
    Gets a signal by its name.

      **signalName** (str) – The name of the signal.
    :return: Signal value.
    :rtype: SignalValue
    """
    pass
  def signal(self, message : str, signalName : str) -> SignalValue:
    """
    Gets a signal by message and signal name.

      - **message** (str) – The path to the message. Examples: "ST_ENERG_GEN", "*"(this is to indicate that this applies to all messages of the ECU.)
      - **signalName** (str) – The name of the signal.
    :return: Signal value.
    :rtype: SignalValue
    """
    pass
  def start(self):
    """
    Starts the ECU

    """
    pass
  def stop(self):
    """
    Stops the ECU.

    """
    pass
  def trigger(self, message : str):
    """
    Triggers an enabled transmitted message of the ecu to send a message.

      **message** (str) – message is message_id_or_name
    """
    pass
  def on_reset_ecu(self):
    """
    Event is triggered when the capture of Ethernet ECU RBS is reset.

    """
    pass
  def on_start(self):
    """
    Event is triggered when the capture of Ethernet ECU RBS is started.

    """
    pass
  def on_stop(self):
    """
    Event is triggered when the capture of Ethernet ECU RBS is stopped.

    """
    pass
  def on_value_changed(self, sender : object, e : ValueChangedArgsMsg):
    """
    Gets the new value , old value, message id, message name when we set value of signal(s).

      - **sender** (object) – The source of the event.
      - **e** (ValueChangedArgsMsg) – An object that contains the event data.
    """
    pass
  data_base : Database

  is_started : c_bool


  pass

"""
Get Signal value for a specific signal name.
            It is used to get or set signal value and physical value. Also to get interpretation value.
"""
class SignalValue:
  def phy(self) -> Optional[c_float]:
    """
    Get physical value.

    :return: Signal's physical value.
    :rtype: Optional[c_float]
    """
    pass
  def phy(self, value : c_float):
    """
    Sets the physical value of a specific signal.

      **value** (c_float) – Desired signal's physical value
    """
    pass
  def raw(self) -> Optional[c_uint64]:
    """
    Get raw value.

    :return: Signal's raw value.
    :rtype: Optional[c_uint64]
    """
    pass
  def raw(self, value : c_uint64):
    """
    Sets the raw value of a specific signal.

      **value** (c_uint64) – Desired signal's raw value
    """
    pass
  def str(self) -> str:
    """
    Get interpretation value.

    :return: Signal's interpretation value.
    :rtype: str
    """
    pass

  pass

"""
Message triggered every time one or more of its signals value(s) has/have been changed.
"""
class ValueChangedArgsMsg:
  def match(self, message : str) -> c_bool:
    """
    identify which message with the value change

      **message** (str) – message is message_id_or_name
    :return: :code:`True` if the message exists in the node. Otherwise, :code:`False`
    :rtype: c_bool
    """
    pass
  ecu : IEcuMessageBasedNode

  message_id : c_uint32

  message_name : str

  new_value : object

  old_value : object


  pass

"""
Represents an ECU message node.
"""
class IEcuMessageBasedNode:
  def disable(self, message : str):
    """
    Disables a message of the ecu.

      **message** (str) – message can be message_name or message_id. Examples: "ST_ENERG_GEN", "*"(this is to indicate that this applies to all messages of the ECU.)
    """
    pass
  def enable(self, message : str):
    """
    Enables a message of the ecu.

      **message** (str) – message can be message_name or message_id. Examples: "ST_ENERG_GEN", "*"(this is to indicate that this applies to all messages of the ECU.)
    """
    pass
  def get_value(self, message : str) -> dict:
    """
    Gets the values of the signals of the specified message of the ecu.

      **message** (str) – The path to the message. Examples: "ST_ENERG_GEN".
    :return: The values of the signals of the specified message
    :rtype: dict
    """
    pass
  def get_value(self, message : str, signal : str) -> int:
    """
    Gets the value of a specific signal of a message of the ecu.

      - **message** (str) – The path to the message. Examples: "ST_ENERG_GEN".
      - **signal** (str) – The name of the signal.
    :return: The value of the signal
    :rtype: int
    """
    pass
  def reset(self) -> c_bool:
    """
    Resets the ECU.

    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def reset_value(self, message : str = None, signal : str = None):
    """
    Resets the value of a specific message/signal of the ecu to the default value.

      - **message** (str) – [optional] The path to the message. Examples: "ST_ENERG_GEN", "*"(this is to indicate that this applies to all messages of the ECU.) .empty or :code:`None` means the entire messages of the ECU will be reset.
      - **signal** (str) – [optional] The name of the signal, empty or :code:`None` means all the signals values of the message will be reset.
    """
    pass
  def set_value(self, message : str, value : dict):
    """
    Sets the value of (a) signal(s) of the message to a specific value.

      - **message** (str) – The path to the message. Examples: "ST_ENERG_GEN", "*"(this is to indicate that this applies to all messages of the ECU.)
      - **value** (dict) – The value of the signal(s) to be set, :code:`None` means default value.
    """
    pass
  def set_value(self, message : str, signal : str, value : Optional[int]):
    """
    Sets the value of the signal of the specified message to a specific value.

      - **message** (str) – The path to the message. Examples: "ST_ENERG_GEN", "*"(this is to indicate that this applies to all messages of the ECU.)
      - **signal** (str) – The name of the signal to be set, :code:`None` means default value.
      - **value** (Optional[int]) – The value of the signal to be set, :code:`None` means default value.
    """
    pass
  def signal(self, signalName : str) -> SignalValue:
    """
    Gets a signal by its name.

      **signalName** (str) – The name of the signal.
    :return: Signal value.
    :rtype: SignalValue
    """
    pass
  def signal(self, message : str, signalName : str) -> SignalValue:
    """
    Gets a signal by message and signal name.

      - **message** (str) – The path to the message. Examples: "ST_ENERG_GEN", "*"(this is to indicate that this applies to all messages of the ECU.)
      - **signalName** (str) – The name of the signal.
    :return: Signal value.
    :rtype: SignalValue
    """
    pass
  def start(self):
    """
    Starts the ECU

    """
    pass
  def stop(self):
    """
    Stops the ECU.

    """
    pass
  def trigger(self, message : str):
    """
    Triggers an enabled transmitted message of the ecu to send a message.

      **message** (str) – message is message_id_or_name
    """
    pass
  def on_reset_ecu(self):
    """
    Event is triggered when the capture of Ethernet ECU RBS is reset.

    """
    pass
  def on_start(self):
    """
    Event is triggered when the capture of Ethernet ECU RBS is started.

    """
    pass
  def on_stop(self):
    """
    Event is triggered when the capture of Ethernet ECU RBS is stopped.

    """
    pass
  def on_value_changed(self, sender : object, e : ValueChangedArgsMsg):
    """
    Gets the new value , old value, message id, message name when we set value of signal(s).

      - **sender** (object) – The source of the event.
      - **e** (ValueChangedArgsMsg) – An object that contains the event data.
    """
    pass
  data_base : Database

  is_started : c_bool


  pass

"""
Represents BRSpy CAN Channel Adapter object.
"""
class ChannelBrspyCAN:
  def encode(self, message : MessageCAN, request_counter : c_int64 = 0) -> Array[c_uint8]:
    """
    Returns the encoded CAN message as a byte array.

      - **message** (MessageCAN) – the encoded CAN message
      - **request_counter** (c_int64) – request counter
    :return: the encoded CAN message as a byte array
    :rtype: Array[c_uint8]
    """
    pass
  def start_record(self, file : str, filter : Filter = None) -> IRecordHandler:
    """
    Starts recording the traffic on the adapter to an output file.

      - **file** (str) – The file to record into.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: The record handler responsible for recording.
    :rtype: IRecordHandler
    """
    pass
  def stop_record(self):
    """
    stops capturing transmission

    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a CAN message object.
"""
class MessageCAN:
  def capture(self, filter : Filter = None) -> MessageCAN:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageCAN
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageCAN:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageCAN
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageCAN]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageCAN]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_signals_interpretations(self) -> dict[str, object]:
    """
    Gets a dictionary of all the signal interpretations of the Message.

    :return: dictionary of signal interpretations.
    :rtype: dict[str, object]
    """
    pass
  def get_all_signals_values(self) -> dict[str, int]:
    """
    Gets a dictionary of all the signal values (name, value).

    :return: Dictionary of all signals values
    :rtype: dict[str, int]
    """
    pass
  def get_signal_interpretation(self, name : str) -> object:
    """
    Gets the interpretation of the frame of the corresponding signal given in parameter.

      **name** (str) – Desired signal's name
    :return: return the interpretation as an object.
    :rtype: object
    """
    pass
  def get_signal_value(self, name : str) -> Optional[int]:
    """
    Gets a value of a specific signal given its name.

      **name** (str) – Desired signal's name
    :return: Signal's value.
    :rtype: Optional[int]
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageCAN:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageCAN
    """
    pass
  def receive(self, timeout : c_int32) -> MessageCAN:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageCAN
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageCAN]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageCAN]
    """
    pass
  def reset_signal_value(self, signalName : str = None):
    """
    Resets the signal value to its default value. If no :code:`signalName` is specified, reset all signals.

      **signalName** (str) – the name of the signal to reset
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def set_signal_value(self, name : str, value : Optional[c_uint64]):
    """
    Sets the value of a specific signal to a specific value.

      - **name** (str) – Desired signal's name
      - **value** (Optional[c_uint64]) – Desired signal's value
    """
    pass
  def signal(self, name : str) -> SignalValue:
    """
    Gets a signal by its name.

      **name** (str) – Desired signal's name
    :return: Signal's value.
    :rtype: SignalValue
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageCAN):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageCAN) – The message object being handled.
    """
    pass
  auto_calculate : AutoCalculate

  can_header : ICANHeader

  capture_info : CaptureInfo

  data_base : Database

  direction : Optional[DataDirection]

  fd : c_bool

  frame : IFrameInstance

  frame_number : c_int64

  payload : Array[c_uint8]

  timestamp : decimal


  pass

"""
Represents a CAN frame header object.
"""
class ICANHeader:
  brs : c_bool

  bus : str

  extended : c_bool

  length : c_uint8

  message_id : c_uint32


  pass

"""
Full frame network information
"""
class IFrameInstance:
  base_cycle : Optional[c_uint8]

  can_frame_rx_behaviour : str

  can_frame_tx_behaviour : str

  channel : IChannel

  cluster : ICluster

  cycle_repetition : Optional[c_uint8]

  dst : INetworkConfiguration

  e2e : IE2EInformation

  frame : IFrame

  frame_triggering : IFrameTriggering

  frame_type : FrameType

  id : Optional[c_uint32]

  length : c_uint32

  name : str

  pdu_collection_pdu_timeout : Optional[c_float]

  pdu_collection_trigger : str

  pdu_instances : Array[IPduInstance]

  pdu_triggering : IPduTriggering

  protocol_version : Optional[decimal]

  signal_activation_configs : List[ISignalActivation]

  signals : Sequence[ISignalInstance]

  src : INetworkConfiguration

  timing : IPduTiming

  uuid : str


  pass

"""
Represents the information of e2e
"""
class IE2EInformation:
  bits_to_shift : c_uint64

  chl_signal : ISignalInstance

  counter_signal : ISignalInstance

  crc_signal : ISignalInstance

  data_id : c_uint64

  data_id_list : Array[c_uint8]

  data_id_signal : ISignalInstance

  data_length : Optional[c_int32]

  header_length : c_uint64

  length_signal : ISignalInstance

  profile : str


  pass

"""
Represents a Signal Instance.
"""
class ISignalInstance:
  def get_interpretations(self) -> dict[str, tuple[c_float, c_float]]:
    """
    Returns a dictionary of tuple (min_physical_value, max_physical_value)

    :return: Dictionary of tuple (min_physical_value, max_physical_value)
    :rtype: dict[str, tuple[c_float, c_float]]
    """
    pass
  def physical_to_raw(self, physical : c_float) -> c_uint64:
    """
    converts the physical measurement of the signal to its corresponding raw value

      **physical** (c_float) – the physical measurement of the signal
    :return: The raw value of the signal.
    :rtype: c_uint64
    """
    pass
  def raw_to_interpretation(self, raw : c_uint64) -> str:
    """
    Converts the raw value of the signal to its corresponding interpretation.

      **raw** (c_uint64) – The raw value to be converted.
    :return: Interpretation of the signal.
    :rtype: str
    """
    pass
  def raw_to_physical(self, raw : c_uint64) -> c_float:
    """
    converts the raw value of the signal to its corresponding physical measurement

      **raw** (c_uint64) – The raw value to be converted.
    :return: physical measurement of the signal.
    :rtype: c_float
    """
    pass
  base_data_type : str

  bit_length : c_int32

  bit_position : c_uint32

  compu_methods : List[ICompuMethod]

  crc_id : c_uint64

  id_string : str

  initial_value : Optional[c_uint64]

  is_high_low_byte_order : Optional[c_bool]

  lower_limit : Optional[c_float]

  method : str

  name : str

  signal : ISignal

  signal_activation_configs : List[ISignalActivation]

  signal_type : str

  signal_type_attribute_name : str

  unit : str

  update_indication_bit_position : Optional[c_uint32]

  upper_limit : Optional[c_float]

  uuid : str

  validity : str


  pass

"""
The information related to timing of the frame.
"""
class IPduTiming:
  cycle : Optional[decimal]

  cyclic_timings : Array[ICyclicTiming]

  debounce_time : decimal

  event_timings : Array[IEventTiming]

  send_conditions : Array[str]


  pass

"""
Represents a cyclic timing type.
"""
class ICyclicTiming:
  cycle : Optional[decimal]

  max_value : Optional[decimal]

  min_value : Optional[decimal]


  pass

"""
The possible event times of the frame.
"""
class IEventTiming:
  debounce_time : decimal

  final_repetitions : Optional[c_uint16]

  repeating_time_range : decimal

  send_conditions : Array[str]

  signal_triggers : Array[ISignalTrigger]


  pass

"""
Represents a signal trigger.
"""
class ISignalTrigger:
  signal_instance_refs : Iterable[ISignalInstanceRef]


  pass

"""
Represents a signal instance ref.
"""
class ISignalInstanceRef:
  id_ref : str


  pass

"""
Represents a network configuration object (for example a service).
"""
class INetworkConfiguration:
  id_string : str

  ip : str

  name : str

  network : INetwork

  network_mask : str

  pdu_collection_timeout : Optional[c_float]

  port : c_int32

  protocol : str

  uuid : str


  pass

"""
Defines the Network information.
"""
class INetwork:
  description : str

  id_string : str

  name : str

  network_endpoint_addresses : Iterable[INetworkEndpointAddress]

  uuid : str


  pass

"""
Defines the network addressing.
"""
class INetworkEndpointAddress:
  ipv4_address : str

  ipv4_address_source : IPv4AddresSource

  ipv6_address : str

  ipv6_address_prefix_length : Optional[c_uint32]

  ipv6_address_source : str

  network_mask : str


  pass

"""
Represents the possible values for ipv4 address source.
"""
class IPv4AddresSource(Enum):

  FIXED = 0x00000000
  DHCPV4 = 0x00000004
  AUTOIP = 0x00000008
  pass

"""
Represents a Frame Triggering.
"""
class IFrameTriggering:
  base_cycle : Optional[c_uint8]

  can_frame_rx_behaviour : str

  can_frame_tx_behaviour : str

  channel : IChannel

  cluster : ICluster

  cycle_repetition : Optional[c_uint8]

  frame : IFrame

  id : Optional[c_uint32]

  name : str

  uuid : str


  pass

"""
Represents a Frame.
"""
class IFrame:
  frame_type : FrameType

  length : c_uint32

  name : str

  pdu_instances : Array[IPduInstance]

  signal_activation_configs : List[ISignalActivation]

  signals : Sequence[ISignalInstance]

  uuid : str


  pass

"""
Represents a Frame's PDU Mapping.
"""
class IPduInstance:
  bit_position : Optional[c_uint32]

  is_high_low_byte_order : Optional[c_bool]

  pdu : IPduType

  update_bit_position : Optional[c_uint32]

  uuid : str


  pass

"""
Represents a PDU.
"""
class IPduType:
  byte_length : c_uint32

  contained_props : IContainedProps

  dynamic_parts : Iterable[IMultiplexedPart]

  e2e : IE2EInformation

  header_type : HeaderType

  id_string : str

  multiplexer_selector : ISignalInstance

  name : str

  payload_pdus : tuple[IPduType]

  pdu_type : FrameType

  secoc : ISecOCConfiguration

  signal_group_instance : ISignalGroupInstance

  signal_instances : Sequence[ISignalInstance]

  static_parts : Iterable[IMultiplexedPart]

  unused_bit_pattern : Optional[c_uint32]

  uuid : str


  pass

"""
An enumeration that represents the different frame types.
"""
class FrameType(Enum):

  APPLICATION = 0x00000000
  BAP = 0x00000001
  DIAG_REQUEST = 0x00000002
  DIAG_RESPONSE = 0x00000003
  DIAG_STATE = 0x00000004
  NM = 0x00000005
  OTHER = 0x00000006
  SERVICE = 0x00000007
  TPL = 0x00000008
  XCP = 0x00000009
  XCP_PRE_CONFIGURED = 0x0000000A
  XCP_RUNTIME_CONFIGURED = 0x0000000B
  pass

"""
Represents a Signal Group Instance.
"""
class ISignalGroupInstance:
  bit_position : c_uint32

  channel : IChannel

  is_high_low_byte_order : Optional[c_bool]

  name : str

  signal_group : ISignalGroup

  signals : Iterable[ISignal]

  update_bit_position : Optional[c_uint32]

  uuid : str


  pass

"""
Represents a set of I-Signals that shall always be kept together.
"""
class ISignalGroup:
  channel : IChannel

  name : str

  signals : Iterable[ISignal]

  uuid : str


  pass

"""
The information related to a channel
"""
class IChannel:
  cluster : ICluster

  frame_triggerings : Iterable[IFrameTriggering]

  name : str

  pdu_triggerings : Iterable[IPduTriggering]

  signal_triggerings : Iterable[ISignalTriggering]

  uuid : str


  pass

"""
The information related to a frame triggering.
"""
class IPduTriggering:
  channel : IChannel

  cluster : ICluster

  id_string : str

  pdu : IPduType

  timing : IPduTiming

  uuid : str


  pass

"""
Represent a Cluster
"""
class ICluster:
  bit_counting_policy : str

  can_fd_speed : Optional[c_uint64]

  channels : Iterable[IChannel]

  description : str

  id_string : str

  is_high_low_bit_order : Optional[c_bool]

  mac_multicast_groups : Iterable[IMacMulticastGroup]

  max_frame_length : Optional[c_uint32]

  medium : str

  name : str

  num_of_cycles : Optional[c_int16]

  physical_version : str

  ports : Iterable[CouplingPort]

  protocol_name : str

  protocol_version : str

  speed : c_uint64

  uuid : str


  pass

"""
Represents a MAC multicast group (with name and multicast address).
"""
class IMacMulticastGroup:
  mac_multicast_address : str

  name : str

  uuid : str


  pass

"""
the coupling port of the coupling element
"""
class CouplingPort:
  connected_to : CouplingPort

  controller : IController

  default_vlan : IChannelEthernet

  vlan_memberships : tuple[VlanMembership]


  pass

"""
the VlanMembership of coupling port
"""
class VlanMembership:
  channel : IChannelEthernet

  default_priority : Optional[c_uint16]


  pass

"""
Represents an Ethernet Channel.
"""
class IChannelEthernet:
  cluster : ICluster

  frame_triggerings : Iterable[IFrameTriggering]

  name : str

  pdu_triggerings : Iterable[IPduTriggering]

  signal_triggerings : Iterable[ISignalTriggering]

  uuid : str

  vlan_identifier : Optional[decimal]

  vlan_name : str

  vlan_uuid : str


  pass

"""
The information related to a signal triggering.
"""
class ISignalTriggering:
  channel : IChannel

  cluster : ICluster

  id_string : str

  signal : ISignal

  signal_group : ISignalGroup

  uuid : str


  pass

"""
Represents a Controller.
"""
class IController:
  id_string : str

  mac_unicast_address : str

  name : str

  ports : tuple[CouplingPort]

  uuid : str


  pass

"""
Represents a Multiplexed Part of a Multiplexed PDU.
"""
class IMultiplexedPart:
  name : str

  pdus : Array[ISwitchedPduInstance]

  segment_positions : Array[ISegmentPosition]

  uuid : str


  pass

"""
Represents the Com PDU alternative that is transmitted in the Dynamic Part of the Multiplexed PDU.
"""
class ISwitchedPduInstance:
  initial_dynamic_part : Optional[c_bool]

  pdu : IPduType

  switch_code : Optional[c_uint64]


  pass

"""
Represents the position and the length of a PDU fragment.
"""
class ISegmentPosition:
  bit_length : c_uint32

  bit_position : c_uint32

  is_high_low_byte_order : c_bool


  pass

"""
The Secure Onboard Communication configuration for the Secured PDU.
"""
class ISecOCConfiguration:
  auth_algorithm : str

  auth_build_attempts : c_uint16

  auth_retries : c_uint16

  auth_signal : ISignalInstance

  data_id : c_uint64

  freshness_length : c_uint32

  freshness_signal : ISignalInstance

  freshness_sync_attempts : c_uint16

  freshness_timestamp_time_period : c_uint32

  freshness_value_id : c_uint16

  message_link_signal : ISignalInstance

  use_as_crypto_pdu : c_bool

  use_freshness_timestamp : c_bool


  pass

"""
Defines the aspects of a Pdu which can be collected inside a Container Pdu.
"""
class IContainedProps:
  id_header : Optional[c_uint32]

  offset : c_uint32


  pass

"""
An enumeration that represents the different header types.
"""
class HeaderType(Enum):

  NO_HEADER = 0x00000000
  LONG_HEADER = 0x00000001
  SHORT_HEADER = 0x00000002
  pass

"""
An enumeration that represents the different auto calculate possible values (for messages with alive counter and CRC signals)
"""
class AutoCalculate(Enum):

  Disabled = 0x00000000
  CRC = 0x00000001
  AliveCounter = 0x00000002
  All = 0x00000003
  pass

"""
Represents a Record Handler object, used to record traffic to a file.
"""
class IRecordHandler:
  FilePath : str

  IsClosed : c_bool


  pass

"""
Represents a BRSPY Channel Adapter object.
"""
class ChannelBrspy:
  cluster_name : str

  name : str


  pass

"""
Represents a BTS CAN Channel Adapter object.
"""
class ChannelBtsCAN:
  def configure(self, bitrate : c_int32, sampling_point : c_uint8, ack : c_bool, fd_bitrate : Optional[c_int32] = None, fd_sampling_point : Optional[c_uint8] = None):
    """
    Configures the BTS CAN channels (sets the bitrate, data rate, sampling point, data sampling point of the channel and determines if an ack is sent or not).
            
            Note: This function is not supported in old BTS.

      - **bitrate** (c_int32) – The desired bitrate of the channel.
      - **sampling_point** (c_uint8) – The desired sampling point of the channel.
      - **ack** (c_bool) – Whether or not the channel answers with an ack.
      - **fd_bitrate** (Optional[c_int32]) – The desired data rate of the channel.
      - **fd_sampling_point** (Optional[c_uint8]) – The data sampling point of the channel.
    """
    pass
  def encode(self, message : MessageCAN, request_counter : c_int64 = 0) -> Array[c_uint8]:
    """
    Returns the encoded CAN message as a byte array.

      - **message** (MessageCAN) – the encoded CAN message
      - **request_counter** (c_int64) – request counter
    :return: the encoded CAN message as a byte array
    :rtype: Array[c_uint8]
    """
    pass
  def start_record(self, file : str, filter : Filter = None) -> IRecordHandler:
    """
    Starts recording the traffic on the adapter to an output file.

      - **file** (str) – The file to record into.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: The record handler responsible for recording.
    :rtype: IRecordHandler
    """
    pass
  def stop_record(self):
    """
    stops capturing transmission

    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a BTS LIN Channel Adapter object.
"""
class ChannelBtsLIN:
  def encode(self, message : MessageLIN, request_counter : c_int64 = 0) -> Array[c_uint8]:
    """
    Returns the encoded LIN message as a byte array.

      - **message** (MessageLIN) – the encoded LIN message
      - **request_counter** (c_int64) – request counter
    :return: the encoded LIN message as a byte array
    :rtype: Array[c_uint8]
    """
    pass
  def start_record(self, file : str, filter : Filter = None) -> IRecordHandler:
    """
    Starts recording the traffic on the adapter to an output file.

      - **file** (str) – The file to record into.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: The record handler responsible for recording.
    :rtype: IRecordHandler
    """
    pass
  def stop_record(self):
    """
    stops capturing transmission

    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a LIN Message object
"""
class MessageLIN:
  def capture(self, filter : Filter = None) -> MessageLIN:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageLIN
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageLIN:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageLIN
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageLIN]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageLIN]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_signals_interpretations(self) -> dict[str, object]:
    """
    Gets a dictionary of all the signal interpretations of the Message.

    :return: dictionary of signal interpretations.
    :rtype: dict[str, object]
    """
    pass
  def get_all_signals_values(self) -> dict[str, int]:
    """
    Gets a dictionary of all the signal values (name, value).

    :return: Dictionary of all signals values
    :rtype: dict[str, int]
    """
    pass
  def get_signal_interpretation(self, name : str) -> object:
    """
    Gets the interpretation of the frame of the corresponding signal given in parameter.

      **name** (str) – Desired signal's name
    :return: return the interpretation as an object.
    :rtype: object
    """
    pass
  def get_signal_value(self, name : str) -> Optional[int]:
    """
    Gets a value of a specific signal given its name.

      **name** (str) – Desired signal's name
    :return: Signal's value.
    :rtype: Optional[int]
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageLIN:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageLIN
    """
    pass
  def receive(self, timeout : c_int32) -> MessageLIN:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageLIN
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageLIN]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageLIN]
    """
    pass
  def reset_signal_value(self, signalName : str = None):
    """
    Resets the signal value to its default value. If no :code:`signalName` is specified, reset all signals.

      **signalName** (str) – the name of the signal to reset
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def set_signal_value(self, name : str, value : Optional[c_uint64]):
    """
    Sets the value of a specific signal to a specific value.

      - **name** (str) – Desired signal's name
      - **value** (Optional[c_uint64]) – Desired signal's value
    """
    pass
  def signal(self, name : str) -> SignalValue:
    """
    Gets a signal by its name.

      **name** (str) – Desired signal's name
    :return: Signal's value.
    :rtype: SignalValue
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageLIN):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageLIN) – The message object being handled.
    """
    pass
  auto_calculate : AutoCalculate

  capture_info : CaptureInfo

  crc : Optional[c_uint8]

  data_base : Database

  direction : Optional[DataDirection]

  frame : IFrameInstance

  frame_number : c_int64

  lin_header : ILINHeader

  payload : Array[c_uint8]

  timestamp : decimal


  pass

"""
Represents a LIN header object.
"""
class ILINHeader:
  bus : str

  length : c_uint8

  message_id : c_uint32


  pass

"""
Represents a BTS Channel Adapter object.
"""
class ChannelBts:
  def close_channel(self, channel_id : c_uint8) -> c_bool:
    """
    Attempt to close a specific channel given its Id.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: :code:`True` if operation was successful, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  def disable_GND(self, channel_id : c_uint8) -> c_bool:
    """
    Attempt to disable the GND of specific channel given its Id.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: :code:`True` if operation was successful, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  def disable_SIM(self, channel_id : c_uint8) -> c_bool:
    """
    Attempt to disable the SIM of specific channel given its Id.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: :code:`True` if operation was successful, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  def disable_VBAT(self, channel_id : c_uint8) -> c_bool:
    """
    Attempt to disable the vbat of specific channel given its Id.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: :code:`True` if operation was successful, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  def enable_GND(self, channel_id : c_uint8) -> c_bool:
    """
    Attempt to enable the GND of specific channel given its Id.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: :code:`True` if operation was successful, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  def enable_SIM(self, channel_id : c_uint8) -> c_bool:
    """
    Attempt to enable the SIM of specific channel given its Id.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: :code:`True` if operation was successful, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  def enable_VBAT(self, channel_id : c_uint8) -> c_bool:
    """
    Attempt to enable the vbat of specific channel given its Id.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: :code:`True` if operation was successful, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  def get_channel_amperage(self, channel_id : c_uint8) -> c_float:
    """
    Gets the amperage of a channel given its Id.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: Amperage of the channel.
    :rtype: c_float
    """
    pass
  def get_channel_voltage(self, channel_id : c_uint8) -> c_float:
    """
    Gets the voltage of a channel given its Id.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: Voltage of the channel.
    :rtype: c_float
    """
    pass
  def get_status(self):
    """
    The Status of the Adapter.

    """
    pass
  def is_channel_gnd_enabled(self, channel_id : c_uint8) -> c_bool:
    """
    Gets the GND status of specific channel given its Id, :code:`True` if GND is enabled, :code:`False` if not.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: Channel's GND status
    :rtype: c_bool
    """
    pass
  def is_channel_open(self, channel_id : c_uint8) -> c_bool:
    """
    Gets the status of specific channel given its Id, :code:`True` if channel is open, :code:`False` if not.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: Channel's status
    :rtype: c_bool
    """
    pass
  def is_channel_sim_enabled(self, channel_id : c_uint8) -> c_bool:
    """
    Gets the SIM status of specific channel given its Id, :code:`True` if SIM is enabled, :code:`False` if not.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: Channel's SIM status
    :rtype: c_bool
    """
    pass
  def is_channel_vbat_enabled(self, channel_id : c_uint8) -> c_bool:
    """
    Gets the vbat status of specific channel given its Id, :code:`True` if vbat is enabled, :code:`False` if not.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: Channel's vbat status
    :rtype: c_bool
    """
    pass
  def open_channel(self, channel_id : c_uint8) -> c_bool:
    """
    Attempt to open a specific channel given its Id.

      **channel_id** (c_uint8) – Desired channel's id.
    :return: :code:`True` if operation was successful, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  def set_poti_resistance_value(self, value : c_float) -> c_bool:
    """
    Attempts to set the value of the POTI resistance of the adapter to a specific value.

      **value** (c_float) – Desired value.
    :return: :code:`True` if operation was successful, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  def subscribe_events(self, type : str, channel_mask : c_uint16):
    """
    Subscribe to to BTS events

      - **type** (str) – one of open, vbat, gnd, sim, relay, poti, voltage, current
      - **channel_mask** (c_uint16) – the mask of the channel
    """
    pass
  def sw_reset(self) -> c_bool:
    """
    Attempts to reset the switch to its default state.

    :return: :code:`True` if operation was successful, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  def switch_relay(self, value : c_bool) -> c_bool:
    """
    Attempt to switch the adapter relay.

      **value** (c_bool) – Desired switch value.
    :return: :code:`True` if operation was successful, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a BTS IO Channel Adapter object.
"""
class ChannelBtsIO:
  def get_io_state(self, function : str) -> c_float:
    """
    Checks the state of a certain function of the channel.

      **function** (str) – Function to be checked. Possible values: "open", "vbat", "gnd", "sim", "voltage".
    :return: State of the queried function.
    :rtype: c_float
    """
    pass
  def get_supported_functions(self) -> Array[str]:
    """
    Gets the functions supported by the channel.

    :return: List of functions supported by the channel.
    :rtype: Array[str]
    """
    pass
  def set_io_state(self, function : str, value : c_int32):
    """
    Sets the state of a certain function of the channel.

      - **function** (str) – Function to be set. Possible values: "open", "vbat", "gnd", "sim", "poti", "relay".
      - **value** (c_int32) – Desired function value.
    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a CAN(FD) Channel Adapter object.
"""
class ChannelCAN:
  def create_transmit(self, messages : Array, repeat : Optional[c_uint32]) -> Transmission:
    """
    Starts the transmission of a burst of messages using a specific period of time between them. Useful to write load/stress tests.

      - **messages** (Array) – The messages to transmit.
      - **repeat** (Optional[c_uint32]) – Number of times transmitting the packets, indefinitely if value is :code:`None`
    :return: The object created for the transmission
    :rtype: Transmission
    """
    pass
  def start_record(self, file : str, filter : Filter = None) -> IRecordHandler:
    """
    Starts recording the traffic on the adapter to an output file.

      - **file** (str) – The file to record into.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: The record handler responsible for recording.
    :rtype: IRecordHandler
    """
    pass
  def stop_record(self):
    """
    stops capturing transmission

    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a collection of members to control a transmission.
"""
class Transmission:
  def start(self):
    """
    Starts the transmission

    """
    pass
  def stop(self, timeout : c_float = 0):
    """
    Stop a running transmission

      **timeout** (c_float) – Maximum time to wait for transmission to end gracefully
    """
    pass
  def wait(self, timeout : Optional[c_float] = None):
    """
    Wait for the transmission to end

      **timeout** (Optional[c_float]) – Maximum time to wait for transmission to end
    """
    pass
  is_running : c_bool


  pass

"""
Represents an Ethernet Channel Adapter object.
"""
class ChannelEthernet:
  def create_transmit(self, messages : Array, repeat : Optional[c_uint32] = None, duration : Optional[c_float] = None, max_throughput : c_bool = False, bitrate : Optional[c_float] = None, packet_rate : Optional[c_float] = None, cycle : Optional[c_float] = None, packet_overhead : c_int32 = 4) -> Transmission:
    """
    Create a transmission of a burst of messages, useful to write load/stress tests.
            Depending on the arguments provided, a different kind of load test is executed.
            The parameters :code:`max_throughput`, :code:`bitrate`, :code:`packet_rate` and :code:`cycle` can not be used together.
            The parameters :code:`repeat` and :code:`duration` can not be used together.
            The parameters :code:`max_throughput` and :code:`duration` can not be used together.
            
            Note: The usage of the parameter :code:`max_throughput` can raise OutOfMemoryException.

      - **messages** (Array) – The messages to transmit.
      - **repeat** (Optional[c_uint32]) – Number of times transmitting the packets, indefinitely if value is :code:`None`
      - **duration** (Optional[c_float]) – Duration of transmission the packets, indefinitely if value is :code:`None`, value in seconds
      - **max_throughput** (c_bool) – if :code:`True` sends the packet as fast as possible, and ignore the messages timestamp
      - **bitrate** (Optional[c_float]) – If specified, the packets would be burst sent with the specified bitrate, value in bit/s
      - **packet_rate** (Optional[c_float]) – If specified, the packets would be burst sent with the specified packet rate, value in packet/s
      - **cycle** (Optional[c_float]) – If specified, how much time should pass before start sending messages again, value in seconds
      - **packet_overhead** (c_int32) – How many bytes to add to each packet when using :code:`bitrate`
    :return: The transmission object
    :rtype: Transmission
    """
    pass
  def get_ip(self) -> str:
    """
    Returns the IP address of the adapter.

    :return: Adapter's IP address
    :rtype: str
    """
    pass
  def get_ips(self) -> List[str]:
    """
    returns a list of the ip addresses of the devices in the network

    :return: list of IP addresses
    :rtype: List[str]
    """
    pass
  def get_ipv6(self) -> str:
    """
    Returns the IPv6 address of the adapter.

    :return: Adapter's IP address
    :rtype: str
    """
    pass
  def get_mac(self) -> str:
    """
    Returns the MAC address of the adapter.

    :return: MAC address of the adapter.
    :rtype: str
    """
    pass
  def refresh(self):
    """
    Refresh the adapter.

    """
    pass
  def start_pcap_player(self, file_path : str):
    """
    Starts a pcap player using an offline source (pcap file).

      **file_path** (str) – pcap file path
    """
    pass
  def start_pcap_player(self, file_path : str, buffer_size : c_int32):
    """
    Starts a pcap player using an offline source (pcap file).

      - **file_path** (str) – pcap file path
      - **buffer_size** (c_int32) – the buffer size user by the player
    """
    pass
  def start_pcap_player(self, nb_play : c_int32, file_path : str):
    """
    Starts a pcap player using an offline source (pcap file).

      - **nb_play** (c_int32) – number of times playing the pcap file, indefinitely if value is :code:`-1`
      - **file_path** (str) – pcap file path
    """
    pass
  def start_pcap_player(self, file_path : str, buffer_size : c_int32, time_stamp : c_bool):
    """
    Starts a pcap player using an offline source (pcap file).

      - **file_path** (str) – pcap file path
      - **buffer_size** (c_int32) – the buffer size used by the player
      - **time_stamp** (c_bool) – :code:`True` if the player respects timestamps, :code:`False` otherwise
    """
    pass
  def start_pcap_player(self, nb_play : c_int32, file_path : str, auto_increment_seq_nb : c_bool):
    """
    Starts a pcap player using an offline source (pcap file).

      - **nb_play** (c_int32) – number of times playing the pcap file, indefinitely if value is :code:`-1`
      - **file_path** (str) – pcap file path
      - **auto_increment_seq_nb** (c_bool) – :code:`True` if sequence number auto increments, :code:`False` otherwise.
    """
    pass
  def start_pcap_player(self, nb_play : c_int32, file_path : str, buffer_size : c_int32):
    """
    Starts a pcap player using an offline source (pcap file).

      - **nb_play** (c_int32) – number of times playing the pcap file, indefinitely if value is :code:`-1`
      - **file_path** (str) – pcap file path
      - **buffer_size** (c_int32) – the buffer size used by the player
    """
    pass
  def start_pcap_player(self, nb_play : c_int32, file_path : str, buffer_size : c_int32, time_stamp : c_bool):
    """
    Starts a pcap player using an offline source (pcap file).

      - **nb_play** (c_int32) – number of times playing the pcap file, indefinitely if value is :code:`-1`
      - **file_path** (str) – pcap file path
      - **buffer_size** (c_int32) – the buffer size used by the player
      - **time_stamp** (c_bool) – :code:`True` if the player respects timestamps, :code:`False` otherwise
    """
    pass
  def start_pcap_player(self, nb_play : c_int32, file_path : str, buffer_size : c_int32, time_stamp : c_bool, is_synchronous : c_bool, auto_increment_seq_nb : c_bool):
    """
    Starts a pcap player using an offline source (pcap file).

      - **nb_play** (c_int32) – number of times playing the pcap file, indefinitely if value is :code:`-1`
      - **file_path** (str) – pcap file path
      - **buffer_size** (c_int32) – the buffer size used by the player
      - **time_stamp** (c_bool) – :code:`True` if the player respects timestamps, :code:`False` otherwise
      - **is_synchronous** (c_bool) – :code:`True` if player is synchronus with the channel adapter, :code:`False` otherwise.
      - **auto_increment_seq_nb** (c_bool) – :code:`True` if sequence number auto increments, :code:`False` otherwise.
    """
    pass
  def start_record(self, file : str, filter : Filter = None) -> IRecordHandler:
    """
    Starts recording the traffic on the adapter to an output file.

      - **file** (str) – The file to record into.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: The record handler responsible for recording.
    :rtype: IRecordHandler
    """
    pass
  def start_transmit(self, data_rate : c_uint32, packets : Array, times : c_int32, is_synchronous : c_bool) -> Transmission:
    """
    Deprecated, use M:PrimaITestCaseLibrary.NetWorksConfig.IEthernetChannelAdapter.create_transmit(System.Collections.IList,System.Nullable{System.UInt32},System.Nullable{System.Double},System.Boolean,System.Nullable{System.Double},System.Nullable{System.Double},System.Nullable{System.Double},System.Int32) instead.

      - **data_rate** (c_uint32) – the data rate with which the packets are sent.
      - **packets** (Array) – The packets to transmit.
      - **times** (c_int32) – Number of times transmitting the packets, indefinitely if value is :code:`-1`
      - **is_synchronous** (c_bool) – :code:`True` if transmission is synchronus with the channel adapter, :code:`False` otherwise.
    :return: A transmission object created
    :rtype: Transmission
    """
    pass
  def start_transmit(self, distance : c_uint64, times : c_int32, is_synchronous : c_bool, packets : Array) -> Transmission:
    """
    Deprecated, use M:PrimaITestCaseLibrary.NetWorksConfig.IEthernetChannelAdapter.create_transmit(System.Collections.IList,System.Nullable{System.UInt32},System.Nullable{System.Double},System.Boolean,System.Nullable{System.Double},System.Nullable{System.Double},System.Nullable{System.Double},System.Int32) instead.

      - **distance** (c_uint64) – the distance between packets
      - **times** (c_int32) – Number of times transmitting the packets, indefinitely if value is :code:`-1`
      - **is_synchronous** (c_bool) – :code:`True` if transmission is synchronus with the channel adapter, :code:`False` otherwise.
      - **packets** (Array) – The packets to transmit.
    :return: A transmission object created
    :rtype: Transmission
    """
    pass
  def start_transmit(self, packets : Array, times : c_int32, respect_timestamp : c_bool, is_synchronous : c_bool) -> Transmission:
    """
    Deprecated, use M:PrimaITestCaseLibrary.NetWorksConfig.IEthernetChannelAdapter.create_transmit(System.Collections.IList,System.Nullable{System.UInt32},System.Nullable{System.Double},System.Boolean,System.Nullable{System.Double},System.Nullable{System.Double},System.Nullable{System.Double},System.Int32) instead.

      - **packets** (Array) – The packets to transmit.
      - **times** (c_int32) – Number of times transmitting the packets, indefinitely if value is :code:`-1`
      - **respect_timestamp** (c_bool) – :code:`True` if the transmission respects timestamps, :code:`False` otherwise
      - **is_synchronous** (c_bool) – :code:`True` if transmission is synchronus with the channel adapter, :code:`False` otherwise.
    :return: The object created for the transmission
    :rtype: Transmission
    """
    pass
  def stop_pcap_player(self):
    """
    Stops the currently running Pcap player.

    """
    pass
  def stop_record(self):
    """
    stops capturing transmission

    """
    pass
  def stop_transmit(self):
    """
    Stops all the burst transmissions from the adapter.

    """
    pass
  def stop_transmit(self, tr : Transmission):
    """
    Stops a certain burst transmission from the adapter.

      **tr** (Transmission) – The transmission to stop.
    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a LIN Channel Adapter object.
"""
class ChannelLIN:
  def lin_set_bus_silent(self):
    """
    Sets the LIN bus as silent

    """
    pass
  def lin_wakeup_bus(self):
    """
    Wakes up the LIN bus

    """
    pass
  def start_record(self, file : str, filter : Filter = None) -> IRecordHandler:
    """
    Starts recording the traffic on the adapter to an output file.

      - **file** (str) – The file to record into.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: The record handler responsible for recording.
    :rtype: IRecordHandler
    """
    pass
  def stop_record(self):
    """
    stops capturing transmission

    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a Media Gateway Channel Adapter object.
"""
class ChannelMediaGateway:
  def check_status(self) -> str:
    """
    Checks the status of the device and returns it.

    :return: Device's status.
    :rtype: str
    """
    pass
  def export_configuration(self, path : str, name : str) -> c_bool:
    """
    Attempts to export a device's configuration to a file.

      - **path** (str) – Path to export to.
      - **name** (str) – File name to save as.
    :return: :code:`True` if operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def get_wakeup_line_status(self) -> str:
    """
    Gets the wakeup line status of the device.

    :return: Device's wakeup line status.
    :rtype: str
    """
    pass
  def import_configuration(self, conf_file : str) -> c_bool:
    """
    Attempts to import configuration from a file to the device.

      **conf_file** (str) – File containing the configuration.
    :return: :code:`True` if operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def port_enable(self, numPort : c_uint16, enableDisable : c_bool) -> c_bool:
    """
    Attempts to set a specific's port state to enabled or disabled.

      - **numPort** (c_uint16) – Desired port number.
      - **enableDisable** (c_bool) – Desired port's status, :code:`True` for enabled, :code:`False` for disabled.
    :return: :code:`True` if operation was successful (port enabled), :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def port_master_slave(self, selected_port : c_int32, slave_master : c_int32) -> c_bool:
    """
    Attempts to connect a slave_master to a specific port.

      - **selected_port** (c_int32) – Desired port.
      - **slave_master** (c_int32) – Desired slave_master.
    :return: :code:`True` if operation was successful (slave_master connected to a port), :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def reset_to_default(self) -> c_bool:
    """
    Attempts to reset the device to default.

    :return: :code:`True` if operation was successful (device reset to default), :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def restart_device(self) -> c_bool:
    """
    Attempts to restart the device.

    :return: :code:`True` if operation was successful (device restarted), :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_dynamic(self, conf_file : str) -> c_bool:
    """
    Attempts to set the device as dynamic.

      **conf_file** (str) – Device's configuration file.
    :return: :code:`True` if operation was successful(device set to dynamic), :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_wakeup_line_status(self, line_select : c_int32, line_status : c_int32) -> c_bool:
    """
    Attempts to set the wakeup line status of a specific line to a specific status.

      - **line_select** (c_int32) – Desired line.
      - **line_status** (c_int32) – desired status.
    :return: :code:`True` if operation was successful (status set), :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a Media Gateway CAN Channel Adapter object.
"""
class ChannelMediaGatewayCAN:
  def encode(self, message : MessageCAN, request_counter : c_int64 = 0) -> Array[c_uint8]:
    """
    Returns the encoded CAN message as a byte array.

      - **message** (MessageCAN) – the encoded CAN message
      - **request_counter** (c_int64) – request counter
    :return: the encoded CAN message as a byte array
    :rtype: Array[c_uint8]
    """
    pass
  def start_record(self, file : str, filter : Filter = None) -> IRecordHandler:
    """
    Starts recording the traffic on the adapter to an output file.

      - **file** (str) – The file to record into.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: The record handler responsible for recording.
    :rtype: IRecordHandler
    """
    pass
  def stop_record(self):
    """
    stops capturing transmission

    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a base Media Gateway Channel Adapter.
"""
class ChannelNewMediaGateway:
  def check_status(self) -> str:
    """
    Check the configuration mode of the MediaGateway

    :return: :code:`"Normal"` if the configuration remains saved. :code:`"Dynamic"` if the configuration is lost once the MediaGateway is restarted
    :rtype: str
    """
    pass
  def export_configuration(self, path : str, name : str) -> c_bool:
    """
    Export the current configuration of the MediaGateway

      - **path** (str) – path to save the configuration
      - **name** (str) – name of the saved configuration
    :return: :code:`True` if accepted, :code:`False` otherwise
    :rtype: c_bool
    """
    pass
  def get_dest_mac(self) -> str:
    """
    Method that gets the mac address of the destination

    :return: Mac address of the destination
    :rtype: str
    """
    pass
  def get_wakeup_line_status(self) -> str:
    """
    Get the status of the Wakeup lines

    :return: - wakeup line one :code:`low` or :code:`high`
            - wakeup line two :code:`low` or :code:`high`
    :rtype: str
    """
    pass
  def import_configuration(self, conf_file : str) -> c_bool:
    """
    Import a configuration file to the MediaGateway

      **conf_file** (str) – path of the configuration to import.
    :return: :code:`True` if accepted, :code:`False` otherwise
    :rtype: c_bool
    """
    pass
  def port_enable(self, numPort : c_uint16, enableDisable : c_bool) -> c_bool:
    """
    Sets Enable or disable MediaGateway ports

      - **numPort** (c_uint16) – port number from :code:`0` to :code:`11`
      - **enableDisable** (c_bool) – :code:`True` -> :code:`enabled`, :code:`False` -> :code:`disable`
    :return: :code:`True` if accepted, :code:`False` otherwise
    :rtype: c_bool
    """
    pass
  def port_master_slave(self, selected_port : c_int32, slave_master : c_int32) -> c_bool:
    """
    Sets Master or Slave MediaGateway ports

      - **selected_port** (c_int32) – port number from :code:`0` to :code:`11`
      - **slave_master** (c_int32) – :code:`0` Slave or :code:`1` Master
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def reset_to_default(self) -> c_bool:
    """
    Set the MG to default configuration

    :return: :code:`True` if accepted, :code:`False` otherwise
    :rtype: c_bool
    """
    pass
  def restart_device(self) -> c_bool:
    """
    Restart the MediaGateway device

    :return: :code:`True` if accepted, :code:`False` otherwise
    :rtype: c_bool
    """
    pass
  def set_dest_mac(self, dstMac : Array[c_uint8]) -> c_bool:
    """
    Sets the destination mac address

      **dstMac** (Array[c_uint8]) – Destination Mac address to set.
    :return: :code:`True` if Mac address is set, :code:`False` if error occurred
    :rtype: c_bool
    """
    pass
  def set_dynamic(self, conf_file : str) -> c_bool:
    """
    Import a configuration file to the MediaGateway and set the status to Dynamic mode

      **conf_file** (str) – path of the configuration to import
    :return: :code:`True` if accepted, :code:`False` otherwise
    :rtype: c_bool
    """
    pass
  def set_wakeup_line_status(self, line_select : c_int32, line_status : c_int32) -> c_bool:
    """
    Sets the status of the Wakeup lines

      - **line_select** (c_int32) – wakeup line: :code:`1` or :code:`2`
      - **line_status** (c_int32) – line status: :code:`0` (low) or :code:`1` (high)
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  cluster_name : str

  name : str


  pass

"""
PLP Analog Channel Adapter Interface
"""
class ChannelPlpAnalog:
  cluster_name : str

  name : str


  pass

"""
Represents a PLP (probe logging protocol) CAN Channel Adapter
"""
class ChannelPlpCan:
  def encode(self, message : MessageCAN, request_counter : c_int64 = 0) -> Array[c_uint8]:
    """
    Returns the encoded CAN message as a byte array.

      - **message** (MessageCAN) – the encoded CAN message
      - **request_counter** (c_int64) – request counter
    :return: the encoded CAN message as a byte array
    :rtype: Array[c_uint8]
    """
    pass
  def start_record(self, file : str, filter : Filter = None) -> IRecordHandler:
    """
    Starts recording the traffic on the adapter to an output file.

      - **file** (str) – The file to record into.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: The record handler responsible for recording.
    :rtype: IRecordHandler
    """
    pass
  def stop_record(self):
    """
    stops capturing transmission

    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a PLP (Probe logging protocol) Channel Adapter.
"""
class ChannelPlp:
  def export_configuration(self, path : str, name : str) -> c_bool:
    """
    Exports the current configuration of the Capture Module

      - **path** (str) – path to save the configuration
      - **name** (str) – name of the saved configuration
    :return: :code:`True` if accepted, :code:`False` otherwise
    :rtype: c_bool
    """
    pass
  def import_configuration(self, conf_file : str) -> c_bool:
    """
    Imports a configuration file to the Capture module

      **conf_file** (str) – path of the configuration to import.
    :return: :code:`True` if accepted, :code:`False` otherwise
    :rtype: c_bool
    """
    pass
  def restart_device(self) -> c_bool:
    """
    Restarts the Capture module device

    :return: :code:`True` if accepted, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a PLP (Probe logging protocol) Ethernet Channel.
"""
class ChannelPlpEthernet:
  def start_record(self, file : str, filter : Filter = None) -> IRecordHandler:
    """
    Starts recording the traffic on the adapter to an output file.

      - **file** (str) – The file to record into.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: The record handler responsible for recording.
    :rtype: IRecordHandler
    """
    pass
  def stop_record(self):
    """
    stops capturing transmission

    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a PLP (Probe logging protocol) FlexRay Channel Adapter.
"""
class ChannelPlpFlexRay:
  def clear_slots(self):
    """
    Send a UDP message to remove key slot configuration and all the configured Tx buffers.

    """
    pass
  def configure_slot(self, slot_id : c_uint16, startup : c_bool = False, sync : c_bool = False, leading : c_bool = False):
    """
    Sends a UDP message to configure the key slot id.

      - **slot_id** (c_uint16) – The slot ID
      - **startup** (c_bool) – Enables node startup
      - **sync** (c_bool) – Indicates that the node will run in synchronous mode
      - **leading** (c_bool) – Indicates running as a leading node
    """
    pass
  def encode(self, message : MessageFlexray, request_counter : c_int64 = 0) -> Array[c_uint8]:
    """
    Returns the encoded FlexRay message as a byte array.

      - **message** (MessageFlexray) – the encoded FlexRay message
      - **request_counter** (c_int64) – request counter
    :return: the encoded FlexRay message as a byte array
    :rtype: Array[c_uint8]
    """
    pass
  def start_node(self, wakeup : c_bool = False):
    """
    Sends a UDP message to start the node

      **wakeup** (c_bool) – Indicates waking up the node
    """
    pass
  def start_record(self, file : str, filter : Filter = None) -> IRecordHandler:
    """
    Starts recording the traffic on the adapter to an output file.

      - **file** (str) – The file to record into.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: The record handler responsible for recording.
    :rtype: IRecordHandler
    """
    pass
  def stop_node(self, abort : c_bool = False):
    """
    Sends a UDP message to stop the node

      **abort** (c_bool) – Indicates aborting current communication
    """
    pass
  def stop_record(self):
    """
    stops capturing transmission

    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a FlexRay message object.
"""
class MessageFlexray:
  def capture(self, filter : Filter = None) -> MessageFlexray:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageFlexray
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageFlexray:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageFlexray
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageFlexray]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageFlexray]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_signals_interpretations(self) -> dict[str, object]:
    """
    Gets a dictionary of all the signal interpretations of the Message.

    :return: dictionary of signal interpretations.
    :rtype: dict[str, object]
    """
    pass
  def get_all_signals_values(self) -> dict[str, int]:
    """
    Gets a dictionary of all the signal values (name, value).

    :return: Dictionary of all signals values
    :rtype: dict[str, int]
    """
    pass
  def get_signal_interpretation(self, name : str) -> object:
    """
    Gets the interpretation of the frame of the corresponding signal given in parameter.

      **name** (str) – Desired signal's name
    :return: return the interpretation as an object.
    :rtype: object
    """
    pass
  def get_signal_value(self, name : str) -> Optional[int]:
    """
    Gets a value of a specific signal given its name.

      **name** (str) – Desired signal's name
    :return: Signal's value.
    :rtype: Optional[int]
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageFlexray:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageFlexray
    """
    pass
  def receive(self, timeout : c_int32) -> MessageFlexray:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageFlexray
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageFlexray]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageFlexray]
    """
    pass
  def reset_signal_value(self, signalName : str = None):
    """
    Resets the signal value to its default value. If no :code:`signalName` is specified, reset all signals.

      **signalName** (str) – the name of the signal to reset
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_cyclic(self):
    """
    Sends FlexRay message in continuous transmission mode

    """
    pass
  def set_signal_value(self, name : str, value : Optional[c_uint64]):
    """
    Sets the value of a specific signal to a specific value.

      - **name** (str) – Desired signal's name
      - **value** (Optional[c_uint64]) – Desired signal's value
    """
    pass
  def signal(self, name : str) -> SignalValue:
    """
    Gets a signal by its name.

      **name** (str) – Desired signal's name
    :return: Signal's value.
    :rtype: SignalValue
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_cyclic(self):
    """
    Stops sending FlexRay messages in continuous transmission mode

    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageFlexray):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageFlexray) – The message object being handled.
    """
    pass
  auto_calculate : AutoCalculate

  capture_info : CaptureInfo

  data_base : Database

  direction : Optional[DataDirection]

  flexray_header : IMessageFlexRayHeader

  frame : IFrameInstance

  frame_number : c_int64

  payload : Array[c_uint8]

  timestamp : decimal


  pass

"""
Represents a FlexRay frame header object.
"""
class IMessageFlexRayHeader:
  cas : c_bool

  cycle : c_uint8

  frame_id : c_uint16

  header_crc : c_uint16

  nfi : c_bool

  ppi : c_bool

  repetition : c_uint8

  sufi : c_bool

  syfi : c_bool

  ws : c_bool


  pass

"""
Represents a PLP (Probe logging protocol) LIN Channel Adapter.
"""
class ChannelPlpLin:
  def encode(self, message : MessageLIN, request_counter : c_int64 = 0) -> Array[c_uint8]:
    """
    Returns the encoded LIN message as a byte array.

      - **message** (MessageLIN) – the encoded LIN message
      - **request_counter** (c_int64) – request counter
    :return: the encoded LIN message as a byte array
    :rtype: Array[c_uint8]
    """
    pass
  def start_record(self, file : str, filter : Filter = None) -> IRecordHandler:
    """
    Starts recording the traffic on the adapter to an output file.

      - **file** (str) – The file to record into.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: The record handler responsible for recording.
    :rtype: IRecordHandler
    """
    pass
  def stop_record(self):
    """
    stops capturing transmission

    """
    pass
  cluster_name : str

  name : str


  pass

"""
Represents a Serial PLP (probe logging protocol) Channel Adapter.
"""
class ChannelPlpSerial:
  cluster_name : str

  name : str


  pass

"""
Represents a CAN Database object.
"""
class DatabaseCAN:
  def get_all_clusters(self) -> List[ICluster]:
    """
    Gets all the Clusters of the database and returns them in a list.

    :return: A list of all the Clusters in the database.
    :rtype: List[ICluster]
    """
    pass
  def get_all_ecus(self) -> List[ISignalEcu]:
    """
    Gets all the ECUs of the database and returns them in a list.

    :return: List of all the ECUs in the database.
    :rtype: List[ISignalEcu]
    """
    pass
  def get_all_ecus(self) -> List[ISignalEcu]:
    """
    Gets all the ISignalEcus of the database and returns them in a list.

    :return: A list of all the ISignalEcus in the database.
    :rtype: List[ISignalEcu]
    """
    pass
  def get_all_frame_triggerings(self) -> List[IFrameTriggering]:
    """
    Gets all the Frame Triggerings of the database and returns them in a list.

    :return: List of all the Frame Triggerings in the database.
    :rtype: List[IFrameTriggering]
    """
    pass
  def get_all_frames(self) -> List[IFrameInstance]:
    """
    Gets all the Frames of the database and returns them in a list.

    :return: List of all the Frames in the database.
    :rtype: List[IFrameInstance]
    """
    pass
  def get_ecu_by_id(self, id : str) -> ISignalEcu:
    """
    Identifies an ECU by its Id from the ECUs of the database and returns it.

      **id** (str) – The Id of the ECU to identify
    :return: The ECU identified
    :rtype: ISignalEcu
    """
    pass
  def get_ecu_by_name(self, name : str) -> ISignalEcu:
    """
    Identifies an ECU by its name from the ECUs of the database and returns it.

      **name** (str) – The name of the ECU to be identified
    :return: The ECU identified
    :rtype: ISignalEcu
    """
    pass
  def get_frame_by_id(self, frame_id : c_uint32, ecu_name : str = None, cluster_name : str = None) -> IFrameInstance:
    """
    Identified a frame by its id from all the frames of the database and returns it.

      - **frame_id** (c_uint32) – The id of the frame to be identified
      - **ecu_name** (str) – The name of the frame's parent ECU
      - **cluster_name** (str) – The name of the frame's parent Cluster
    :return: The identified frame
    :rtype: IFrameInstance
    """
    pass
  def get_frame_description(self, frame_id : c_uint32) -> str:
    """
    Identifies a frame by its id and returns its description.

      **frame_id** (c_uint32) – The Id of the frame to be identified.
    :return: Description of the frame identified.
    :rtype: str
    """
    pass
  def get_path(self) -> str:
    """
    Gets the path of the database.

    :return: The path of the database
    :rtype: str
    """
    pass
  def get_signal_by_name(self, name : str) -> ISignalInstance:
    """
    Identifies a signal by its name from all the signals of the database and returns it.

      **name** (str) – The name of the signal
    :return: The signal identified
    :rtype: ISignalInstance
    """
    pass
  def get_signals_by_frame(self, frame_id : c_uint32) -> List[ISignalInstance]:
    """
    Identifies a frame by its id and returns all the signals of that frame.

      **frame_id** (c_uint32) – The id of the frame to be identified
    :return: List of the signals
    :rtype: List[ISignalInstance]
    """
    pass
  def get_tp_configs(self) -> List[ITpConfig]:
    """
    Gets all the Configurations of the used transport protocol from the database and returns them in a list.

    :return: List of all the Configurations of the used transport protocol in the database.
    :rtype: List[ITpConfig]
    """
    pass
  def get_unit_by_signal(self, frame_id : c_uint32, signal_name : str) -> Unit:
    """
    Identifies a unit by its signal and returns it.

      - **frame_id** (c_uint32) – The id of the frame that contains the signal needed.
      - **signal_name** (str) – The name of the signal.
    :return: The Unit identified
    :rtype: Unit
    """
    pass

  pass

"""
Represents a CAN Ecu.
"""
class ISignalEcu:
  diagnostic_addresses : tuple[TpAddress]

  ecu_id : str

  input_frames : List[IFrameInstance]

  name : str

  output_frames : List[IFrameInstance]

  response_address : TpAddress

  uuid : str


  pass

"""
Represents a diagnostic Address.
"""
class TpAddress:
  addressing : str

  name : str

  uuid : str

  value : c_uint64


  pass

"""
Represents a TP Configuration
"""
class ITpConfig:
  can_tp_connections : Iterable[ICanTpConnection]

  cluster : ICluster

  fr_tp_connections : Iterable[IFrTpConnection]

  name : str

  pdu_pools : Iterable[IPduPool]

  tp_addresses : Iterable[TpAddress]

  tp_nodes : Iterable[ITpNode]

  uuid : str


  pass

"""
Represents a CAN-TP Connection
"""
class ICanTpConnection:
  addressing_format : AddressingFormat

  data_pdu : IPduType

  flow_control_pdu : IPduType

  max_block_size : Optional[c_int32]

  multicast_address : TpAddress

  name : str

  padding_activation : c_bool

  receivers : Iterable[ITpNode]

  segmented_pdu : IPduType

  ta_type : TargetType

  transmitter : ITpNode

  uuid : str


  pass

"""
An enumeration that represents the communication addressing mode of the CAN-TP Connection.
"""
class AddressingFormat(Enum):

  Extended = 0x00000000
  Standard = 0x00000001
  pass

"""
Represents a TP Node (Sender or Receiver) that provides the TP Address and the connection to the Topology description.
"""
class ITpNode:
  connector : IConnector

  name : str

  st_min : Optional[decimal]

  tp_address : TpAddress

  uuid : str


  pass

"""
Represents a Connector.
"""
class IConnector:
  applications : Iterable[IApplicationEndpoint]

  channel : IChannel

  controller : IController

  ecu : IEcu

  input_ports : Iterable[IEcuPort]

  networks : Iterable[INetwork]

  output_ports : Iterable[IEcuPort]

  uuid : str


  pass

"""
Represents an Ecu.
"""
class IEcu:
  diagnostic_addresses : tuple[TpAddress]

  ecu_id : str

  name : str

  response_address : TpAddress

  uuid : str


  pass

"""
Represents a input port or output port.
"""
class IEcuPort:
  frame_triggering : IFrameTriggering

  name : str

  pdu_triggering : IPduTriggering

  uuid : str


  pass

"""
Represents the endpoint on an Ecu in terms of application addressing.
"""
class IApplicationEndpoint:
  connector : IConnector

  consumedServices : Iterable[IConsumedService]

  id_string : str

  ip : str

  name : str

  network : INetwork

  network_mask : str

  pdu_collection_timeout : Optional[c_float]

  port : c_int32

  protocol : str

  providedServices : Iterable[IProvidedService]

  uuid : str


  pass

"""
Represents a provided service.
"""
class IProvidedService:
  application : IApplicationEndpoint

  cyclic_announce_delay : decimal

  event_handlers : Array[IEventHandler]

  id_string : str

  initial_delay_max : decimal

  instance_id : c_uint16

  ip : str

  name : str

  network : INetwork

  network_mask : str

  pdu_collection_timeout : Optional[c_float]

  port : c_int32

  protocol : str

  query_response_delay : decimal

  repetition_base : decimal

  repetition_max : c_uint16

  service : IServiceInterface

  ttl : c_int32

  uuid : str


  pass

"""
Represents a Service Interface object.
"""
class IServiceInterface:
  event_groups : Array[IEventGroup]

  events : Array[Event]

  fields : Array[Field]

  id_string : str

  major_version : c_uint32

  methods : Array[Method]

  minor_version : c_uint32

  name : str

  package : Package

  service_id : c_uint16

  uuid : str


  pass

"""
Represents an Ethernet package information (name and id).
"""
class Package:
  id_string : str

  name : str

  uuid : str


  pass

"""
Represents a SOME/IP Event.
"""
class Event:
  application_cycle : Optional[decimal]

  call_semantic : CALLSEMANTIC

  description : str

  e2e : IE2EInformation

  id_string : str

  identifier_integer : c_uint16

  input_parameters : Array[Parameter]

  manufacturer_extension : IManufacturerMethodExtension

  name : str

  reliable : Optional[c_bool]

  return_parameters : Array[Parameter]

  service_parent : IServiceInterface

  service_parent_identifier : c_uint16

  tp : SomeIpTP

  uuid : str


  pass

"""
An enumeration that represents the type of the service call.
"""
class CALLSEMANTIC(Enum):

  SYNCHRONOUS = 0x00000000
  ASYNCHRONOUS = 0x00000001
  REQUEST_RESPONSE = 0x00000002
  FIRE_AND_FORGET = 0x00000003
  UNKNOWN = 0x00000004
  pass

"""
Represents a Method Extension of a manufacturer.
"""
class IManufacturerMethodExtension:
  buffer_retention : decimal

  debounce_time : decimal


  pass

"""
Represents a SOMEIP-TP Configuration
"""
class SomeIpTP:
  max_segment_length : Optional[c_uint32]


  pass

"""
Represents the definition of a Method for SOME/IP standard
"""
class Method:
  call_semantic : CALLSEMANTIC

  description : str

  id_string : str

  identifier_integer : c_uint16

  input_parameters : Array[Parameter]

  manufacturer_extension : IManufacturerMethodExtension

  name : str

  reliable : Optional[c_bool]

  return_parameters : Array[Parameter]

  service_parent : IServiceInterface

  service_parent_identifier : c_uint16

  tp : SomeIpTP

  uuid : str


  pass

"""
Represents an Event Group, responsible for regulating the message flow between Service providers and consumers.
"""
class IEventGroup:
  events : List[Event]

  fields : List[Field]

  id_string : str

  identifier_integer : c_uint16

  name : str

  service_parent : IServiceInterface

  service_parent_identifier : c_uint16

  uuid : str


  pass

"""
Represents a SOME/IP Field.
"""
class Field:
  def get_bit_position(self) -> c_int32:
    """
    Retrieves the bit position of the current parameter.

    :return: Bit position of the parameter.
    :rtype: c_int32
    """
    pass
  def get_length(self) -> c_int32:
    """
    Retrieves the length of the current parameter.

    :return: Length of the parameter.
    :rtype: c_int32
    """
    pass
  def set_length(self, p0 : c_int32):
    """
    Sets the length of the parameter data.

      **p0** (c_int32) – Desired length.
    """
    pass
  def set_payload_offset(self, payloadOffset : c_int32):
    """
    Sets the offset of the payload.

      **payloadOffset** (c_int32) – Payload offset.
    """
    pass
  application_cycle : Optional[decimal]

  arrays : Array[ArrayDefinition]

  base_type : str

  basic_partial_network : Array[str]

  bit_length : c_int32

  compu_methods : List[ICompuMethod]

  description : str

  e2e : IE2EInformation

  enumeration_elements : dict[str, str]

  functional_partial_network : Array[str]

  getter_id : c_uint16

  getter_timing : IManufacturerMethodExtension

  getter_tp : SomeIpTP

  id_string : str

  identifier : c_uint16

  is_array : c_bool

  is_complex : c_bool

  is_enum : c_bool

  is_high_low_bit_order : Optional[c_bool]

  length_field_size : Optional[c_uint32]

  mandatory : c_bool

  manufacturer_extension : IManufacturerParameterExtension

  max_bit_length : Optional[c_uint32]

  members : Array[Parameter]

  min_bit_length : Optional[c_uint32]

  name : str

  notifier_id : c_uint16

  notifier_timing : IManufacturerMethodExtension

  notifier_tp : SomeIpTP

  position : c_int32

  service_parent : IServiceInterface

  service_parent_identifier : c_uint16

  setter_id : c_uint16

  setter_timing : IManufacturerMethodExtension

  setter_tp : SomeIpTP

  signal : ISignal

  string_bom : c_bool

  string_encoding : str

  string_termination : Optional[c_char]

  tag_id : Optional[c_uint16]

  type_field_size : Optional[c_uint32]

  uuid : str


  pass

"""
Represents an Event Handler, responsible for handling Event related to specific consumed event groups.
"""
class IEventHandler:
  application : IApplicationEndpoint

  consumed_event_group : Array[IConsumedEventGroup]

  multicast_threshold : Optional[c_int32]


  pass

"""
Represents a Consumed Event Group.
"""
class IConsumedEventGroup:
  application : IApplicationEndpoint

  cyclic_request_delay : decimal

  eventgroup : IEventGroup

  id_string : str

  identifier : c_uint16

  initial_delay_max : decimal

  ip : str

  name : str

  network : INetwork

  network_mask : str

  pdu_collection_timeout : Optional[c_float]

  port : c_int32

  protocol : str

  repetition_base : decimal

  repetition_max : c_uint16

  service : IServiceInterface

  ttl : c_int32

  uuid : str


  pass

"""
Represents a Consumed Service.
"""
class IConsumedService:
  application : IApplicationEndpoint

  consumed_event_groups : Array[IConsumedEventGroup]

  id_string : str

  initial_delay_max : decimal

  instance_id : c_uint16

  ip : str

  name : str

  network : INetwork

  network_mask : str

  pdu_collection_timeout : Optional[c_float]

  port : c_int32

  protocol : str

  provided : IProvidedService

  repetition_base : decimal

  repetition_max : c_uint16

  service : IServiceInterface

  ttl : c_int32

  uuid : str


  pass

"""
An enumeration that represents the Network Target Address type.
"""
class TargetType(Enum):

  Physical = 0x00000000
  Functional = 0x00000001
  pass

"""
Represents a set of N-PDUs which are defined for FlexRay-TP sending or receiving purpose.
"""
class IPduPool:
  name : str

  pdus : Iterable[IPduType]

  uuid : str


  pass

"""
Represents a FlexRay-TP Connection
"""
class IFrTpConnection:
  multicast_address : TpAddress

  name : str

  protocol_variant : str

  receivers : Iterable[ITpNode]

  rx_pdu_pool : IPduPool

  rx_segmented_pdu : IPduType

  transmitter : ITpNode

  tx_pdu_pool : IPduPool

  tx_segmented_pdu : IPduType

  uuid : str


  pass

"""
Represents an Ediabas Database object.
"""
class DatabaseEdiabas:
  def disconnect_ediabas(self) -> c_bool:
    """
    Attempts to disconnect the ediabas.

    :return: :code:`True` if is_ediabas_connected value is :code:`True` and the method disconnects the API, :code:`False` if the is_ediabas_connected value is already :code:`False`
    :rtype: c_bool
    """
    pass
  def get_all_diag_jobs(self) -> List[str]:
    """
    Gets a list of all the diag jobs of the database.

    :return: List of all the diag jobs of the database.
    :rtype: List[str]
    """
    pass
  def get_arguments_for_job(self, job : str) -> List[tuple[str, str]]:
    """
    Gets a list of a job arguments of a job from the database.

      **job** (str) – Desired Job.
    :return: List of job arguments.
    :rtype: List[tuple[str, str]]
    """
    pass
  def get_path(self) -> str:
    """
    Gets the path of the database.

    :return: The path of the database
    :rtype: str
    """
    pass
  def reconnect(self) -> c_bool:
    """
    Attempts to reconnect the ediabas database

    :return: :code:`True` if the reconnection attempt was successful, :code:`False` if not.
    :rtype: c_bool
    """
    pass
  def send_job(self, job_name : str, aguments : str) -> List[dict[str, str]]:
    """
    Sends a specific job

      - **job_name** (str) – Job name.
      - **aguments** (str) – Job arguments.
    :return: A dictionary of the job result.
    :rtype: List[dict[str, str]]
    """
    pass
  file_name : str

  is_connected : c_bool

  is_ediabas_connected : c_bool


  pass

"""
Represents an Ethernet FIBEX Database
"""
class DatabaseEthernet:
  def compute_crc(self, payload : Array[c_uint8], service_id : c_uint16, method_id : c_uint16) -> c_uint32:
    """
    Calculates the CRC parameter according to the service identifier of the desired profile and event or field.

      - **payload** (Array[c_uint8]) – Payload used to compute the desired CRC.
      - **service_id** (c_uint16) – Service identifier.
      - **method_id** (c_uint16) – Method identifier.
    :return: The value of the CRC parameter
    :rtype: c_uint32
    """
    pass
  def compute_origine_crc(self, payload : Array[c_uint8], service_id : c_uint16, method_id : c_uint16) -> c_uint32:
    """
    Calculates the origin CRC parameter according to the service identifier of the desired profile and event or field.

      - **payload** (Array[c_uint8]) – Payload used to compute the desired CRC.
      - **service_id** (c_uint16) – Service identifier.
      - **method_id** (c_uint16) – Method identifier.
    :return: CRC calculated
    :rtype: c_uint32
    """
    pass
  def get_all_ecus(self) -> List[IECUEthernet]:
    """
    Extracts all the ECUs from the database and returns them in a list.

    :return: List of all the ECUs of the database.
    :rtype: List[IECUEthernet]
    """
    pass
  def get_all_services(self) -> List[IServiceInterface]:
    """
    Extracts from the database all the service interfaces defined without taking into account to which ECUs they belong.

    :return: A list containing all the service interfaces defined in the database.
    :rtype: List[IServiceInterface]
    """
    pass
  def get_channel(self, name : str) -> IChannelEthernet:
    """
    Extracts from the database the channel specified by channel name.

      **name** (str) – Name of the channel that is extracted from the database.
    :return: Channel extracted.
    :rtype: IChannelEthernet
    """
    pass
  def get_consumed_event_groups(self, service_id : c_uint16, ecu_name : str) -> List[IConsumedEventGroup]:
    """
    Extracts from the database the complete list of services consumed with event groups by the given service identifier and ECU name.

      - **service_id** (c_uint16) – Service identifier which contains the consumed services with event groups.
      - **ecu_name** (str) – Name of the ECU which contains the consumed services with event groups.
    :return: A list containing the consumed services with event groups of the given service identifier and ECU name.
    :rtype: List[IConsumedEventGroup]
    """
    pass
  def get_consumed_instance_ids(self, service_id : c_uint16, ecu_name : str) -> List[c_uint16]:
    """
    Extracts from the database the complete list of services consumed by the given service identifier and ECU name.

      - **service_id** (c_uint16) – service identifier which contains the consumed services.
      - **ecu_name** (str) – name of the ECU which contains the consumed services.
    :return: A list containing the consumed services of the given service identifier and ECU name .
    :rtype: List[c_uint16]
    """
    pass
  def get_consumed_instance_ids_by_ip(self, service_id : c_uint16, ecu_name : str, ip : str) -> List[c_uint16]:
    """
    Extracts from the database the complete list of services consumed by the given service identifier, ECU name and IP address.

      - **service_id** (c_uint16) – Service identifier which contains the consumed services.
      - **ecu_name** (str) – Name of the ECU which contains the consumed services.
      - **ip** (str) – IP address which contains the consumed services.
    :return: A list containing the consumed services of the given service identifier, ECU name and IP address.
    :rtype: List[c_uint16]
    """
    pass
  def get_consumed_services(self, ecu_name : str, service_id : c_uint16) -> List[IConsumedService]:
    """
    Extracts from the database the complete list of services consumed by the given ECU.

      - **ecu_name** (str) – Name of the ECU which contains the consumed services.
      - **service_id** (c_uint16) – Service identifier.
    :return: A list containing the consumed services of the given ECU.
    :rtype: List[IConsumedService]
    """
    pass
  def get_consumed_services_by_ecu_id(self, ECUID : str) -> Array[IConsumedService]:
    """
    Extracts from the database the complete list of services consumed by the given ECU ID.

      **ECUID** (str) – Id of the ECU which contains the consumed services.
    :return: A list containing the consumed services of the given ECU ID.
    :rtype: Array[IConsumedService]
    """
    pass
  def get_consumed_services_by_ecu_ip(self, ecu_name : str, ip : str) -> Array[IConsumedService]:
    """
    Extracts from the database the complete list of services consumed by the given ECU name and IP address.

      - **ecu_name** (str) – Name of the ECU which contains the consumed services.
      - **ip** (str) – IP address of the ECU in case this has several. If no IP address is provided, all the consumed services are returned, no matter from which IP.
    :return: A list containing the consumed services of the given parameters.
    :rtype: Array[IConsumedService]
    """
    pass
  def get_consumed_services_by_ecu_name(self, ECUNAME : str) -> Array[IConsumedService]:
    """
    Extracts from the database the complete list of services consumed by the given ECU name.

      **ECUNAME** (str) – Name of the ECU which contains the consumed services.
    :return: A list containing the consumed services of the given ECU name.
    :rtype: Array[IConsumedService]
    """
    pass
  def get_consumed_services_by_ip(self, ecu_name : str, ip : str, service_id : c_uint16) -> List[IConsumedService]:
    """
    Extracts from the database the complete list of services consumed by the given parameters.

      - **ecu_name** (str) – name of the ECU which contains the consumed services.
      - **ip** (str) – IP address of the ECU in case this has several addresses. If no IP address is provided, all the consumed services are returned, no matter from which IP.
      - **service_id** (c_uint16) – service identifier.
    :return: A list containing the consumed services of the given parameters(ECU name,ip address,service id).
    :rtype: List[IConsumedService]
    """
    pass
  def get_consumed_services_with_eventgroups_by_ecu_id(self, ECUID : str) -> List[IConsumedService]:
    """
    Extracts from the database the complete list of services consumed with event groups by the given ECU identifier.

      **ECUID** (str) – Identifier of the ECU which contains the provided services with event groups.
    :return: List of services consumed with event groups
    :rtype: List[IConsumedService]
    """
    pass
  def get_consumed_services_with_eventgroups_by_ecu_ip(self, ecu_name : str, ip : str) -> List[IConsumedService]:
    """
    Extracts from the database the complete list of services consumed with event groups by the given ECU name and IP address.

      - **ecu_name** (str) – Name of the ECU which contains the provided services with event groups.
      - **ip** (str) – IP address of the ECU which contains the provided services with event groups.
    :return: A list containing the provided services with event groups of the given ECU name and IP address.
    :rtype: List[IConsumedService]
    """
    pass
  def get_consumed_services_with_eventgroups_by_ecu_name(self, ECUNAME : str) -> List[IConsumedService]:
    """
    Extracts from the database the complete list of services consumed with event groups by the given ECU name.

      **ECUNAME** (str) – Name of the ECU which contains the provided services with event groups.
    :return: A list containing the provided services with event groups of the given ECU name.
    :rtype: List[IConsumedService]
    """
    pass
  def get_e2e(self, service_id : c_uint16, method_id : c_uint16) -> IE2EInformation:
    """
    Extracts from the database the Configuration of End-to-End Communication Protection according to the given service and event or field.

      - **service_id** (c_uint16) – Service identifier.
      - **method_id** (c_uint16) – Method identifier.
    :return: CRC profile of the given identifier.
    :rtype: IE2EInformation
    """
    pass
  def get_ecu_by_identifier(self, id : str) -> IECUEthernet:
    """
    Extracts from the database the ECU specified by its ID.

      **id** (str) – ID of the ECU that is extracted from the database.
    :return: ECU object found in the database with the given ID.
    :rtype: IECUEthernet
    """
    pass
  def get_ecu_by_name(self, name : str) -> IECUEthernet:
    """
    Extracts from the database the ECU specified by its name.

      **name** (str) – Name of the ECU that is extracted from the database.
    :return: ECU object found in the database with the given name.
    :rtype: IECUEthernet
    """
    pass
  def get_ecus_by_ip(self, ip : str) -> Array[IECUEthernet]:
    """
    Extracts from the database a list with all the defined ECUs containing the given IP address.

      **ip** (str) – IP address of the ECUs that is extracted from the database.
    :return: A list containing all the ECU objects found in the database with the given IP address.
    :rtype: Array[IECUEthernet]
    """
    pass
  def get_event_by_id(self, service_id : c_uint16, method_id : c_uint16) -> Event:
    """
    Extracts from the database a list of event for the given service and method identifiers.

      - **service_id** (c_uint16) – Service identifier.
      - **method_id** (c_uint16) – Method identifier.
    :return: A list containing all the event objects found in the database for the given service and method identifiers.
    :rtype: Event
    """
    pass
  def get_event_group_by_id(self, service_id : c_uint16, event_group_id : c_uint16) -> IEventGroup:
    """
    Extracts from the database a list of event group for the given service and event group identifiers.

      - **service_id** (c_uint16) – Service identifier.
      - **event_group_id** (c_uint16) – Event group identifier.
    :return: A list containing all the event group objects found in the database for the given service and event group identifiers.
    :rtype: IEventGroup
    """
    pass
  def get_eventgroups_by_service(self, ServiceID : c_uint16) -> Array[IEventGroup]:
    """
    Extracts from the database a list of event groups for the given service identifier.

      **ServiceID** (c_uint16) – Service identifier.
    :return: A list containing all the event groups objects found in the database for the given service identifier.
    :rtype: Array[IEventGroup]
    """
    pass
  def get_events_by_service(self, ServiceID : c_uint16) -> Array[Event]:
    """
    Extracts from the database a list of event for the given service identifier.

      **ServiceID** (c_uint16) – Service identifier.
    :return: A list containing all the event objects found in the database for the given service identifier.
    :rtype: Array[Event]
    """
    pass
  def get_field_by_id(self, service_id : c_uint16, method_id : c_uint16) -> Field:
    """
    Extracts from the database a list of Field for the given service and method identifiers.

      - **service_id** (c_uint16) – Service identifier.
      - **method_id** (c_uint16) – Method identifier.
    :return: A list containing all the Field objects found in the database for the given service and method identifiers.
    :rtype: Field
    """
    pass
  def get_fields_by_service(self, ServiceID : c_uint16) -> Array[Field]:
    """
    Extracts from the database a list of Field for the given service and method identifiers.

      **ServiceID** (c_uint16) – Service identifier.
    :return: A list containing all the Field objects found in the database for the given service identifier.
    :rtype: Array[Field]
    """
    pass
  def get_find_entries(self, ecu_name : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Extracts from the database a list of Entry for the given service identifier.

      - **ecu_name** (str) – Name of the desired ECU.
      - **service_id** (c_uint16) – service identifier.
      - **including_all_services** (c_bool) – :code:`True` if search is in all services, :code:`False` if not.
    :return: A list containing all the Entry objects found in the database for the given service identifier.
    :rtype: Array[Entry]
    """
    pass
  def get_find_entries_by_ip(self, ecu_name : str, ip : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Extracts from the database a list of Entry for the given service and method identifiers.

      - **ecu_name** (str) – Name of the desired ECU.
      - **ip** (str) – IP address of the desired ECU.
      - **service_id** (c_uint16) – service identifier.
      - **including_all_services** (c_bool) – :code:`True` if search is in all services, :code:`False` if not.
    :return: A list containing all the Entry objects found in the database for the given service and method identifiers.
    :rtype: Array[Entry]
    """
    pass
  def get_input_parameters_by_identifier(self, service_id : c_uint16, method_id : c_uint16) -> Array[Parameter]:
    """
    Extracts from the database a list of input parameters for a certain method by the identifier.

      - **service_id** (c_uint16) – Service identifier.
      - **method_id** (c_uint16) – Method identifier.
    :return: A list containing all the input parameters objects found in the database for the given identifier.
    :rtype: Array[Parameter]
    """
    pass
  def get_instance_id_by_service(self, ServiceID : c_uint16) -> Array[c_uint16]:
    """
    Gets a list of valid instance IDs for a certain service.

      **ServiceID** (c_uint16) – Service identifier.
    :return: A list containing the instance IDs for the given service.
    :rtype: Array[c_uint16]
    """
    pass
  def get_mac_multicast_group(self, name : str) -> IMacMulticastGroup:
    """
    Extracts from the database the mac multicast group specified by mac name.

      **name** (str) – Name of the mac that is extracted from the database.
    :return: Mac multicast group.
    :rtype: IMacMulticastGroup
    """
    pass
  def get_mac_multicast_groups(self) -> List[IMacMulticastGroup]:
    """
    Extracts from the database all of the mac multicast addresses from mac multicast groups

    :return: Mac multicast group.
    :rtype: List[IMacMulticastGroup]
    """
    pass
  def get_method_by_id(self, service_id : c_uint16, method_id : c_uint16) -> Method:
    """
    Gets a list of Method for the given service and method identifiers.

      - **service_id** (c_uint16) – Service identifier.
      - **method_id** (c_uint16) – Method identifier.
    :return: A list containing methods for the given service and method identifiers.
    :rtype: Method
    """
    pass
  def get_methods_by_service(self, ServiceID : c_uint16) -> Array[Method]:
    """
    Gets a list of Method for the given service identifier.

      **ServiceID** (c_uint16) – Service identifier.
    :return: A list containing methods for the given service identifier.
    :rtype: Array[Method]
    """
    pass
  def get_offer_entries(self, ecu_name : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Gets a list of the offer entries.If including_all_services = :code:`True`, you will have all offer entries of consumed and provided services, if including_all_services = :code:`False` you will have only the offer entries of the provided services

      - **ecu_name** (str) – Name of the desired ECU .
      - **service_id** (c_uint16) – Identifier of the service containing the method.
      - **including_all_services** (c_bool) – :code:`True` if search is in all services, :code:`False` if not.
    :return: A list of offer entries.
    :rtype: Array[Entry]
    """
    pass
  def get_offer_entries_by_ip(self, ecu_name : str, ip : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Gets a list of the offer entries.If including_all_services = :code:`True`, you will have all offer entries of consumed and provided services, if including_all_services = :code:`False` you will have only the offer entries of the provided services

      - **ecu_name** (str) – Name of the desired ECU .
      - **ip** (str) – IP address of the desired ECU.
      - **service_id** (c_uint16) – Identifier of the service containing the method.
      - **including_all_services** (c_bool) – :code:`True` if search is in all services, :code:`False` if not.
    :return: A list of the offer entries.
    :rtype: Array[Entry]
    """
    pass
  def get_output_parameters_by_identifier(self, service_id : c_uint16, method_id : c_uint16) -> Array[Parameter]:
    """
    Extracts from the database the complete list of Parameters by the given service identifier and method identifier.

      - **service_id** (c_uint16) – Service identifier.
      - **method_id** (c_uint16) – Method identifier.
    :return: A list of the parameters.
    :rtype: Array[Parameter]
    """
    pass
  def get_path(self) -> str:
    """
    Gets the path of the database.

    :return: The path of the database
    :rtype: str
    """
    pass
  def get_provided_instance_ids(self, service_id : c_uint16, ecu_name : str) -> List[c_uint16]:
    """
    Gets the instance ids associated with a service that is contained in the list of the provided services by an ECU.

      - **service_id** (c_uint16) – Identifier of the service to search.
      - **ecu_name** (str) – Name of the ECU for which the list of provided instances is requested.
    :return: A list of instance ids provided by the ECU for the given service.
    :rtype: List[c_uint16]
    """
    pass
  def get_provided_instance_ids_by_ip(self, service_id : c_uint16, ecu_name : str, ip : str) -> List[c_uint16]:
    """
    Gets the instance ids associated with a service that is contained in the list of provided services by an ECU.

      - **service_id** (c_uint16) – Identifier of the service to search.
      - **ecu_name** (str) – Name of the ECU for which the list of provided instances is requested.
      - **ip** (str) – IP address of the ECU for which the list of provided instances is requested
    :return: A list of instance ids provided by the ECU for the given service.
    :rtype: List[c_uint16]
    """
    pass
  def get_provided_service_by_identifier(self, serviceID : c_uint16, instanceID : c_uint16) -> IProvidedService:
    """
    Extracts from the database the complete list of services provided by the given service and instance identifiers.

      - **serviceID** (c_uint16) – Identifier of the service which contains the provided services.
      - **instanceID** (c_uint16) – Identifier of the instance which contains the provided services.
    :return: A list containing the provided services of the given service identifier and instance identifier.
    :rtype: IProvidedService
    """
    pass
  def get_provided_service_by_service(self, serviceID : c_uint16) -> Array[IProvidedService]:
    """
    Extracts from the database the complete list of services provided by the given service.

      **serviceID** (c_uint16) – ServiceID, identifier of the service which contains the provided services.
    :return: A list containing the provided services of the given service identifier.
    :rtype: Array[IProvidedService]
    """
    pass
  def get_provided_services(self, ecu_name : str, service_id : c_uint16) -> List[IProvidedService]:
    """
    Extracts from the database the complete list of services provided by the given ECU.

      - **ecu_name** (str) – Name of the ECU which contains the provided services.
      - **service_id** (c_uint16) – Service identifier.
    :return: A list containing the provided services of the given ECU.
    :rtype: List[IProvidedService]
    """
    pass
  def get_provided_services_by_ecu_id(self, ECUID : str) -> Array[IProvidedService]:
    """
    Extracts from the database the complete list of services provided by the given ECU identifier.

      **ECUID** (str) – Identifier of the ECU which contains the provided services.
    :return: list containing the provided services of the given ECU identifier.
    :rtype: Array[IProvidedService]
    """
    pass
  def get_provided_services_by_ecu_ip(self, ecu_name : str, ip : str) -> Array[IProvidedService]:
    """
    Extracts from the database the complete list of services provided by the given ECU name and IP address.

      - **ecu_name** (str) – Name of the ECU which contains the provided services.
      - **ip** (str) – IP address of the ECU which contains the provided services.
    :return: A list containing the provided services of the given ECU name and IP address.
    :rtype: Array[IProvidedService]
    """
    pass
  def get_provided_services_by_ecu_name(self, ECUNAME : str) -> Array[IProvidedService]:
    """
    Extracts from the database the complete list of services provided by the given ECU name.

      **ECUNAME** (str) – Name of the ECU which contains the provided services.
    :return: A list containing the provided services of the given ECU name.
    :rtype: Array[IProvidedService]
    """
    pass
  def get_provided_services_by_ip(self, ecu_name : str, ip : str, service_id : c_uint16) -> List[IProvidedService]:
    """
    Extracts from the database the complete list of services provided by the given ECU name and IP address and service identifier.

      - **ecu_name** (str) – name of the ECU which contains the provided services.
      - **ip** (str) – IP address of the ECU which contains the provided services.
      - **service_id** (c_uint16) – service identifier of the ECU which contains the provided services.
    :return: A list containing the provided services of the given ECU name, IP address and service identifier.
    :rtype: List[IProvidedService]
    """
    pass
  def get_provided_services_with_eventgroups_by_ecu_id(self, ECUID : str) -> List[IProvidedService]:
    """
    Extracts from the database the complete list of services provided with event groups by the given ECU identifier.

      **ECUID** (str) – Identifier of the ECU which contains the provided services with event groups.
    :return: A list containing the provided services with event groups of the given ECU identifier.
    :rtype: List[IProvidedService]
    """
    pass
  def get_provided_services_with_eventgroups_by_ecu_ip(self, ecu_name : str, ip : str) -> List[IProvidedService]:
    """
    Extracts from the database the complete list of services provided with event groups by the given ECU name and IP address.

      - **ecu_name** (str) – The name of the specific ECU.
      - **ip** (str) – IP address of the specific ECU.
    :return: A list of the provided services with eventgroups.
    :rtype: List[IProvidedService]
    """
    pass
  def get_provided_services_with_eventgroups_by_ecu_name(self, ECUNAME : str) -> List[IProvidedService]:
    """
    Extracts from the database the complete list of services provided with event groups by the given ECU name.

      **ECUNAME** (str) – The name of the specific ECU.
    :return: A list of the provided services with eventgroups.
    :rtype: List[IProvidedService]
    """
    pass
  def get_service_by_identifier(self, identifier : c_uint16) -> IServiceInterface:
    """
    Gets from the database the formal description of a service, i.e. the service interface, of the given ID.

      **identifier** (c_uint16) – Service identifier.
    :return: Service interface of the given service ID.
    :rtype: IServiceInterface
    """
    pass
  def get_signal_by_shortname(self, name : str) -> ISignal:
    """
    Extracts from the database a signals object with the given name.

      **name** (str) – Name of the signal.
    :return: Signal object found in database with the given name.
    :rtype: ISignal
    """
    pass
  def get_signals_by_identifier(self, service_id : c_uint16, method_id : c_uint16) -> List[ISignal]:
    """
    Extracts from the database the signals of a field by the given identifier.

      - **service_id** (c_uint16) – Service identifier.
      - **method_id** (c_uint16) – Method identifier.
    :return: A list containing all the signal objects found in the database for the given identifier.
    :rtype: List[ISignal]
    """
    pass
  def get_stop_find_entries(self, ecu_name : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Gets a list of the stop entries by the given parameters. If including_all_services = :code:`True`, you will have all the stop entries of the consumed and provided services, if including_all_services = :code:`False` you will have only the stop entries of the consumed services.

      - **ecu_name** (str) – Name of the desired ECU.
      - **service_id** (c_uint16) – Identifier of the service containing the method.
      - **including_all_services** (c_bool) – :code:`True` if search is in all services, :code:`False` if not.
    :return: A list of the stop entries.
    :rtype: Array[Entry]
    """
    pass
  def get_stop_find_entries_by_ip(self, ecu_name : str, ip : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Gets a list of the stop entries by the given parameters. If including_all_services = :code:`True`, you will have all the stop entries of the consumed and provided services, if including_all_services = :code:`False` you will have only the stop entries of the consumed services.

      - **ecu_name** (str) – Name of the desired ECU.
      - **ip** (str) – ip of the desired ECU.
      - **service_id** (c_uint16) – Identifier of the service containing the method.
      - **including_all_services** (c_bool) – :code:`True` if search is in all services, :code:`False` if not.
    :return: A list of the stop entries by IP.
    :rtype: Array[Entry]
    """
    pass
  def get_stop_offer_entries(self, ecu_name : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Gets a list of the stop offer entries. If including_all_services = :code:`True`, you will have all the stop offer entries of the consumed and provided services, if including_all_services = :code:`False` you will have only the stop offer entries of the provided services.

      - **ecu_name** (str) – Name of the desired ECU.
      - **service_id** (c_uint16) – Identifier of the service containing the method.
      - **including_all_services** (c_bool) – :code:`True` if search is in all services, :code:`False` if not.
    :return: A list of the stop offer entries.
    :rtype: Array[Entry]
    """
    pass
  def get_stop_offer_entries_by_ip(self, ecu_name : str, ip : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Gets a list of the stop offer entries. If including_all_services = :code:`True`, you will have all the stop offer entries of the consumed and provided services, if including_all_services = :code:`False` you will have only the stop offer entries of the provided services.

      - **ecu_name** (str) – Name of the desired ECU.
      - **ip** (str) – IP address of the desired ECU .
      - **service_id** (c_uint16) – Identifier of the service containing the method.
      - **including_all_services** (c_bool) – :code:`True` if search is in all services, :code:`False` if not.
    :return: A list of the stop offer entries by IP.
    :rtype: Array[Entry]
    """
    pass
  def get_stop_subscribe_event_group_entries(self, ecu_name : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Gets a list of the stop subscribe event group entries. If including_all_services = :code:`True`, you will have all stop subscribe eventgroup entries of consumed and provided services, if including_all_services = :code:`False` you will have only the stop subscribe eventgroup entries of the provided services.

      - **ecu_name** (str) – Name of the desired ECU.
      - **service_id** (c_uint16) – Identifier of the service containing the method.
      - **including_all_services** (c_bool) – :code:`True` if search is in all services, :code:`False` if not.
    :return: A list of the stop which subscribes event group entries.
    :rtype: Array[Entry]
    """
    pass
  def get_stop_subscribe_event_group_entries_by_ip(self, ecu_name : str, ip : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Gets a list of the stop which subscribes event group entries. If including_all_services = :code:`True`, you will have all the stop that subscribes event group entries of the consumed and provided services, if including_all_services = :code:`False`, you will have only the stop which subscribes event group entries of the provided services.

      - **ecu_name** (str) – Name of the desired ECU.
      - **ip** (str) – IP address of the desired ECU.
      - **service_id** (c_uint16) – Identifier of the service containing the method.
      - **including_all_services** (c_bool) – :code:`True` if search is in all services, :code:`False` if not.
    :return: A list of the stop that subscribes event group entries.
    :rtype: Array[Entry]
    """
    pass
  def get_subscribe_event_group_entries(self, ecu_name : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Gets a list of the subscribe event group entries. If including_all_services = :code:`True`, you will have all the event group entries of the consumed and provided services, if including_all_services = :code:`False` you will have only the event groups entries of the provided services.

      - **ecu_name** (str) – Name of the desired ECU.
      - **service_id** (c_uint16) – Identifier of the service containing the method.
      - **including_all_services** (c_bool) – :code:`True` if search is in all services, :code:`False` if not.
    :return: A list of the subscribe event group entries.
    :rtype: Array[Entry]
    """
    pass
  def get_subscribe_event_group_entries_by_ip(self, ecu_name : str, ip : str, service_id : c_uint16, including_all_services : c_bool) -> Array[Entry]:
    """
    Gets a list of the stop entries. If including_all_services = :code:`True`, you will have all the stop entries of the consumed and provided services, if including_all_services = :code:`False`, you will have only the stop entries of the provided services.

      - **ecu_name** (str) – Name of the desired ECU. find_provided_service_instances
      - **ip** (str) – ip of the desired ECU.
      - **service_id** (c_uint16) – Identifier of the service containing the method.
      - **including_all_services** (c_bool) – :code:`True` if search is in all services, :code:`False` if not.
    :return: A list of the subscribe event group entries.
    :rtype: Array[Entry]
    """
    pass
  couplings : tuple[CouplingElement]


  pass

"""
Represents an Ethernet ECU object.
"""
class IECUEthernet:
  def find_consumed_service_instances(self, service_id : c_uint16) -> Array[IConsumedService]:
    """
    Gets a list of consumed service objects found for the ECU that correspond to the service id given. An ECU can consume the same service id with different event groups, IPs and ports, and for each combination of these parameters a consumed service object is created.

      **service_id** (c_uint16) – Id of the desired service.
    :return: List of consumed services found.
    :rtype: Array[IConsumedService]
    """
    pass
  def find_provided_service_instances(self, service_id : c_uint16) -> Array[IProvidedService]:
    """
    Gets a list of provided service objects found for the ECU that correspond to the service id given.

      **service_id** (c_uint16) – Id of the desired service.
    :return: List of provided services found.
    :rtype: Array[IProvidedService]
    """
    pass
  def get_consumed_services_by_ip(self, ip : str) -> Array[IConsumedService]:
    """
    Extracts from the database the complete list of consumed services by a certain ECU. These consumed services contain info not only about the services itself, but also about the eventgroups used, transport info, etc.

      **ip** (str) – IP address of the desired ECU.
    :return: List of consumed services by the IP
    :rtype: Array[IConsumedService]
    """
    pass
  def get_ips(self, filters : Array[Callable[str, c_bool]]) -> tuple[str]:
    """
    Extracts a list of IPs from the network of the ECU by applying a list of filters.

      **filters** (Array[Callable[str, c_bool]]) – Filters applied before extracting the list of IPs
    :return: A list of IPs
    :rtype: tuple[str]
    """
    pass
  def get_provided_services_by_ip(self, ip : str) -> Array[IProvidedService]:
    """
    Extracts from the database the complete list of provided services by a certain ECU.

      **ip** (str) – IP address of the desired ECU.
    :return: List of services provided by the IP
    :rtype: Array[IProvidedService]
    """
    pass
  consumed_services : Array[IConsumedService]

  couplings : tuple[CouplingElement]

  diagnostic_addresses : tuple[TpAddress]

  ecu_id : str

  mac_unicast_addresses : tuple[str]

  name : str

  provided_services : Array[IProvidedService]

  response_address : TpAddress

  uuid : str


  pass

"""
the coupling element of Fibex data base
"""
class CouplingElement:
  cluster : ICluster

  coupling_type : str

  ecu : IEcu

  name : str

  ports : tuple[CouplingPort]

  uuid : str


  pass

"""
Represents a LIN database.
"""
class DatabaseLIN:
  def get_all_clusters(self) -> List[ICluster]:
    """
    Gets all the Clusters of the database and returns them in a list.

    :return: A list of all the Clusters in the database.
    :rtype: List[ICluster]
    """
    pass
  def get_all_ecus(self) -> Iterable[ILinEcu]:
    """
    Gets all the ECUs of the database and returns them in a list.

    :return: A list of all the ECUs in the database.
    :rtype: Iterable[ILinEcu]
    """
    pass
  def get_all_ecus(self) -> List[ISignalEcu]:
    """
    Gets all the ISignalEcus of the database and returns them in a list.

    :return: A list of all the ISignalEcus in the database.
    :rtype: List[ISignalEcu]
    """
    pass
  def get_all_frames(self) -> List[IFrameInstance]:
    """
    Gets all the Frames of the database and returns them in a list.

    :return: A list of all the Frames in the database.
    :rtype: List[IFrameInstance]
    """
    pass
  def get_ecu_by_name(self, name : str) -> ILinEcu:
    """
    Identifies an ECU by its name from the ECUs of the database and returns it.

      **name** (str) – The name of the ECU to be identified
    :return: The ECU identified
    :rtype: ILinEcu
    """
    pass
  def get_frame_by_id(self, frame_id : c_uint32, cluster_name : str = None) -> IFrameInstance:
    """
    Identifies a frame by its id from all the frames of the database and returns it.

      - **frame_id** (c_uint32) – The id of the frame to be identified
      - **cluster_name** (str) – The name of the frame's parent Cluster
    :return: The frame identified
    :rtype: IFrameInstance
    """
    pass
  def get_path(self) -> str:
    """
    Gets the path of the database.

    :return: The path of the database
    :rtype: str
    """
    pass
  def get_schedule_tables(self) -> List[ScheduleTable]:
    """
    Gets all the schedule table of the database and returns them in a list.

    :return: A list of all the schedule table in the database.
    :rtype: List[ScheduleTable]
    """
    pass
  def get_signal_by_name(self, name : str) -> ISignalInstance:
    """
    Identifies a signal by its name from all the signals of the database and returns it.

      **name** (str) – The name of the signal
    :return: The signal identified
    :rtype: ISignalInstance
    """
    pass

  pass

"""
Represents a LIN ECU
"""
class ILinEcu:
  configurable_frames : List[IFrame]

  configured_nad : c_int32

  diagnostic_addresses : tuple[TpAddress]

  ecu_id : str

  initial_nad : c_int32

  input_frames : List[IFrameInstance]

  is_master : c_bool

  jitter : Optional[decimal]

  name : str

  output_frames : List[IFrameInstance]

  product : IProduct

  protocol_version : decimal

  response_address : TpAddress

  time_base : Optional[decimal]

  uuid : str


  pass

"""
Represents the lin slave or master conditional
"""
class IProduct:
  function_id : Optional[c_uint16]

  supplier_id : Optional[c_uint16]

  variant : Optional[c_uint8]


  pass

"""
Represents the schedule table
"""
class ScheduleTable:
  commands : List[ScheduleCommand]

  name : str


  pass

"""
Represents the schedule command
"""
class ScheduleCommand:
  delay : decimal

  frame : IFrameInstance

  type : str


  pass

"""
PDU Database instance.
"""
class DatabasePDU:
  def get_all_clusters(self) -> List[ICluster]:
    """
    Gets all the Clusters of the database and returns them in a list.

    :return: A list of all the Clusters in the database.
    :rtype: List[ICluster]
    """
    pass
  def get_all_ecus(self) -> List[PduEcu]:
    """
    Gets all the ECUs of the database and returns them in a list.

    :return: List of all the ECUs in the database.
    :rtype: List[PduEcu]
    """
    pass
  def get_all_ecus(self) -> List[ISignalEcu]:
    """
    Gets all the ISignalEcus of the database and returns them in a list.

    :return: A list of all the ISignalEcus in the database.
    :rtype: List[ISignalEcu]
    """
    pass
  def get_all_frames(self) -> List[IFrameInstance]:
    """
    Gets all the Frames of the database and returns them in a list.

    :return: List of all the Frames in the database.
    :rtype: List[IFrameInstance]
    """
    pass
  def get_all_signals(self) -> List[ISignal]:
    """
    Gets all the Signals of the database and returns them in a list.

    :return: List of all the Signals in the database.
    :rtype: List[ISignal]
    """
    pass
  def get_ecu(self, name : str) -> PduEcu:
    """
    Identifies an ECU by its name from the ECUs of the database and returns it.

      **name** (str) – The name of the ECU to be identified.
    :return: The ECU identified.
    :rtype: PduEcu
    """
    pass
  def get_frame(self, frame_id : c_uint32) -> IFrameInstance:
    """
    Identifies a frame by its id from all the frames of the database and returns it.

      **frame_id** (c_uint32) – The id of the frame to be identified.
    :return: The frame identified.
    :rtype: IFrameInstance
    """
    pass
  def get_path(self) -> str:
    """
    Gets the path of the database.

    :return: The path of the database
    :rtype: str
    """
    pass

  pass

"""
A PDU Ecu instance.
"""
class PduEcu:
  def get_ips(self, filters : Array[Callable[str, c_bool]]) -> tuple[str]:
    """
    Extracts a list of IPs from the network of the ECU by applying a list of filters.

      **filters** (Array[Callable[str, c_bool]]) – Filters applied before extracting the list of IPs
    :return: A list of IPs
    :rtype: tuple[str]
    """
    pass
  diagnostic_addresses : tuple[TpAddress]

  ecu_id : str

  input_frames : List[IFrameInstance]

  name : str

  output_frames : List[IFrameInstance]

  response_address : TpAddress

  uuid : str


  pass

"""
Represents the output viewer (script log) object.
"""
class IOutputViewer:
  def clear(self):
    """
    Clears the output viewer.

    """
    pass
  def log(self, message : str, type : OutputStringType):
    """
    Log the output viewer.

      - **message** (str) – The message displayed in the output viewer.
      - **type** (OutputStringType) – An enumeration that represents the type of the output.
             Possible values: Unknown, Error, Warning, Information, Success
    """
    pass

  pass

"""
Used to select the output type for the script’s log.
            This output type defines the foreground color of the text printed in the output window
"""
class OutputStringType(Enum):

  Unknown = 0x00000000
  Error = 0x00000001
  Warning = 0x00000002
  Information = 0x00000003
  Success = 0x00000004
  pass

"""
Base type that represents a project variable.
"""
class Variable:
  def reset(self):
    """
    Resets the current value of the variable to its initial value.

    """
    pass
  def on_value_changed(self, e : Variable):
    """
    Event triggered every time the variable value has been changed.

      **e** (Variable) – The attribute to monitor for change.
    """
    pass
  type : Type

  value : object


  pass

"""
Represents an Excel files creator object.
"""
class IExcelFilesCreator:
  def createExcelFile(self, filePath : str, defaultWorksheetName : str) -> IExcelFile:
    """
    Creates and returns an excel file given its desired path and the default worksheet's name.

      - **filePath** (str) – Desired file path for the excel file.
      - **defaultWorksheetName** (str) – Default worksheet name.
    :return: Created file.
    :rtype: IExcelFile
    """
    pass
  def exportExecutionReport(self, filePath : str):
    """
    Exports the execution report a the current project to an excel file.

      **filePath** (str) – Excel file path.
    """
    pass
  def openExcelFile(self, xlsxFilePath : str) -> IExcelFile:
    """
    Opens and returns an excel file given its path.

      **xlsxFilePath** (str) – Excel file path
    :return: Opened file.
    :rtype: IExcelFile
    """
    pass

  pass

"""
Represents an Excel File object.
"""
class IExcelFile:
  def adjustCellsToContent(self):
    """
    Adjusts the size of the cells to their content.

    """
    pass
  def adjustColumnWidth(self, WorksheetName : str, Column : c_int32, width : c_float):
    """
    Adjusts the width of a specific column given the column's number.

      - **WorksheetName** (str) – Desired worksheet name.
      - **Column** (c_int32) – Desired worksheet column number.
      - **width** (c_float) – Desired width.
    """
    pass
  def adjustColumnWidth(self, WorksheetName : str, Column : str, width : c_float):
    """
    Adjusts the width of a specific column given the column's name.

      - **WorksheetName** (str) – Desired worksheet name.
      - **Column** (str) – Desired worksheet column name.
      - **width** (c_float) – Desired width.
    """
    pass
  def adjustRowHeight(self, WorksheetName : str, Row : c_int32, height : c_float):
    """
    Adjust the height of a specific row.

      - **WorksheetName** (str) – Desired worksheet name.
      - **Row** (c_int32) – Desired row's number.
      - **height** (c_float) – Desired height.
    """
    pass
  def close(self):
    """
    Closes the file.

    """
    pass
  def containWorksheet(self, WorksheetName : str) -> c_bool:
    """
    Checks if the excel file contains a specific worksheet or not given its name.

      **WorksheetName** (str) – Name of the worksheet.
    :return: :code:`True` if the worksheet exists in the file, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def deleteCellHyperlink(self, WorksheetName : str, cell : str):
    """
    Deletes a hyper link from a specific cell in a specific worksheet.

      - **WorksheetName** (str) – Worksheet's name.
      - **cell** (str) – Cell's coordinates (i.e :code:`A5`).
    """
    pass
  def deleteCellHyperlink(self, WorksheetName : str, Row : c_int32, Column : c_int32):
    """
    Deletes a hyper link from a specific cell in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **Row** (c_int32) – Row number of the desired cell.
      - **Column** (c_int32) – Columns number of the desired cell.
    """
    pass
  def getCellValue(self, WorksheetName : str, cell : str) -> object:
    """
    Gets the cell value of a specific cell in a specific worksheet given the cell's coordinates.

      - **WorksheetName** (str) – Desired worksheet name.
      - **cell** (str) – Desired cell's coordinates (i.e :code:`A5`).
    :return: Value object of the cell.
    :rtype: object
    """
    pass
  def getCellValue(self, WorksheetName : str, Row : c_int32, Column : c_int32) -> object:
    """
    Gets the cell value of a specific cell in a specific worksheet given the cell's coordinates.

      - **WorksheetName** (str) – Desired worksheet name.
      - **Row** (c_int32) – Row number of the desired cell.
      - **Column** (c_int32) – Column number of the desired cell.
    :return: Value object of the cell.
    :rtype: object
    """
    pass
  def getFirstFreeRow(self, WorksheetName : str) -> c_int32:
    """
    Gets the number of the first free line of the table in a worksheet.

      **WorksheetName** (str) – Desired worksheet name.
    :return: The line number of the first free row.
    :rtype: c_int32
    """
    pass
  def getLineValues(self, WorksheetName : str, Row : c_int32) -> List[object]:
    """
    Gets a list of the cells value of a specific line.

      - **WorksheetName** (str) – Desired worksheet name.
      - **Row** (c_int32) – Desired row number.
    :return: List of values.
    :rtype: List[object]
    """
    pass
  def getSheetsList(self) -> List[object]:
    """
    Gets a list of the sheets of the file.

    :return: List of sheets.
    :rtype: List[object]
    """
    pass
  def insertCell(self, WorksheetName : str, cell : str, cellContent : str):
    """
    Inserts a cell in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **cell** (str) – The cell's coordinates (i.e :code:`A5`).
      - **cellContent** (str) – The cell's content.
    """
    pass
  def insertCell(self, WorksheetName : str, Row : c_int32, Column : c_int32, cellContent : str):
    """
    Inserts a cell in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **Row** (c_int32) – Row number of the cell.
      - **Column** (c_int32) – Column number of the cell.
      - **cellContent** (str) – Cell' content.
    """
    pass
  def insertCell(self, WorksheetName : str, cell : str, cellContent : str, FontColor : str, BackgroundColor : str, WithBorders : c_bool):
    """
    Inserts a cell in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **cell** (str) – The cell's coordinates.
      - **cellContent** (str) – The cell's content (i.e :code:`A5`).
      - **FontColor** (str) – The font color of the cell.
      - **BackgroundColor** (str) – The background color of the cell0
      - **WithBorders** (c_bool) – :code:`True` if borders are needed to be added, :code:`False` otherwise.
    """
    pass
  def insertCell(self, WorksheetName : str, Row : c_int32, Column : c_int32, cellContent : str, FontColor : str, BackgroundColor : str, WithBorders : c_bool):
    """
    Inserts a cell in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **Row** (c_int32) – Row number of the cell.
      - **Column** (c_int32) – Column number of the cell.
      - **cellContent** (str) – The cell's content.
      - **FontColor** (str) – The font color of the cell.
      - **BackgroundColor** (str) – The background color of the cell.
      - **WithBorders** (c_bool) – :code:`True` if borders are needed to be added, :code:`False` otherwise.
    """
    pass
  def insertCellRange(self, WorksheetName : str, firstCell : str, lastCell : str, cellContent : str):
    """
    Inserts a cell range in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **firstCell** (str) – Coordinates of the first cell in the range (i.e :code:`A5`).
      - **lastCell** (str) – Coordinates of the last cell in the range (i.e :code:`D10`).
      - **cellContent** (str) – Cells contents
    """
    pass
  def insertCellRange(self, WorksheetName : str, firstCell : str, lastCell : str, cellContent : str, FontColor : str, BackgroundColor : str, WithBorders : c_bool):
    """
    Inserts a cell range in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **firstCell** (str) – Coordinates of the first cell in the range (i.e :code:`A5`).
      - **lastCell** (str) – Coordinates of the last cell in the range (i.e :code:`D10`).
      - **cellContent** (str) – Cells content.
      - **FontColor** (str) – Font color of the cells.
      - **BackgroundColor** (str) – Background color of the cells.
      - **WithBorders** (c_bool) – :code:`True` if borders are needed to be added, :code:`False` otherwise.
    """
    pass
  def insertComment(self, WorksheetName : str, cell : str, comment : str):
    """
    Inserts a comment in a specific cell of a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **cell** (str) – Cell's coordinates (i.e :code:`A5`).
      - **comment** (str) – Comment to be inserted.
    """
    pass
  def insertComment(self, WorksheetName : str, Row : c_int32, Column : c_int32, comment : str):
    """
    Inserts a comment in a specific cell of a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **Row** (c_int32) – Cell's row number.
      - **Column** (c_int32) – Cell's column number.
      - **comment** (str) – Comment to be inserted.
    """
    pass
  def insertLine(self, WorksheetName : str, listOfElements : object):
    """
    Inserts a line after the last row in the table of a specific sheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **listOfElements** (object) – The list of the elements to be inserted in the row.
    """
    pass
  def insertLine(self, WorksheetName : str, listOfElements : object, RowNumber : c_int32):
    """
    Inserts a line at a specific row number in the table of a specific sheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **listOfElements** (object) – The list of the elements to be inserted in a row.
      - **RowNumber** (c_int32) – The row number at which the line will be inserted.
    """
    pass
  def insertLine(self, WorksheetName : str, listOfElements : object, FontColor : str, BackgroundColor : str, WithBorders : c_bool):
    """
    Inserts a line after the last row in the table of a specific sheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **listOfElements** (object) – The list of elements to be inserted in the row.
      - **FontColor** (str) – The font color of the cells.
      - **BackgroundColor** (str) – The background color of the cells.
      - **WithBorders** (c_bool) – :code:`True` if borders are needed to be added, :code:`False` otherwise.
    """
    pass
  def insertLine(self, WorksheetName : str, listOfElements : object, FontColor : str, BackgroundColor : str, WithBorders : c_bool, RowNumber : c_int32):
    """
    Inserts a line at a specific row number in the table of a specific sheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **listOfElements** (object) – The list of the elements to be inserted in a row.
      - **FontColor** (str) – The font color of the cells.
      - **BackgroundColor** (str) – The background color of the cells.
      - **WithBorders** (c_bool) – The background color of the elements.
      - **RowNumber** (c_int32) – The row number at which the line will be inserted.
    """
    pass
  def insertWorksheet(self, WorksheetName : str):
    """
    Inserts a new worksheet in the excel file.

      **WorksheetName** (str) – Name of the worksheet.
    """
    pass
  def lockWorksheet(self, WorksheetName : str):
    """
    Locks a specific worksheet to prevent unwanted modification.

      **WorksheetName** (str) – Worksheet name.
    """
    pass
  def lockWorksheet(self, WorksheetName : str, password : str):
    """
    Locks a specific worksheet to prevent unwanted modification with a protection password.

      - **WorksheetName** (str) – Worksheet name.
      - **password** (str) – Protection password.
    """
    pass
  def modifyCellFormula(self, WorksheetName : str, cell : str, formula : str):
    """
    Modifies the formula of a specific cell to a specific formula in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **cell** (str) – The cell's coordinates.
      - **formula** (str) – The formula to be inserted.
    """
    pass
  def modifyCellHyperlinkInSameSheet(self, WorksheetName : str, cell : str, linkToAddressInSameWorksheet : str):
    """
    Modifies the hyper link of a specific cell to a specific hyper link in the same sheet in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **cell** (str) – Cell's coordinates (i.e :code:`A5`).
      - **linkToAddressInSameWorksheet** (str) – The hyper link to the same sheet to be inserted.
    """
    pass
  def modifyCellHyperlinkInSameSheet(self, WorksheetName : str, Row : c_int32, Column : c_int32, linkToAddressInSameWorksheet : str):
    """
    Modifies the hyper link of a specific cell to a specific hyper link in the same sheet in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **Row** (c_int32) – Row number of the desired cell.
      - **Column** (c_int32) – Columns number of the desired cell.
      - **linkToAddressInSameWorksheet** (str) – The hyper link to the same sheet to be inserted.
    """
    pass
  def modifyCellHyperlinkToFile(self, WorksheetName : str, cell : str, linkToOtherFile : str):
    """
    Modifies the hyper link of a specific cell to a specific hyper link of a file in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **cell** (str) – The cell's coordinates (i.e :code:`A5`).
      - **linkToOtherFile** (str) – The file's hyper link to be inserted.
    """
    pass
  def modifyCellHyperlinkToFile(self, WorksheetName : str, Row : c_int32, Column : c_int32, linkToOtherFile : str):
    """
    Modifies the hyper link of a specific cell to a specific hyper link of a file in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **Row** (c_int32) – Row number of the desired cell.
      - **Column** (c_int32) – Columns number of the desired cell.
      - **linkToOtherFile** (str) – The file's hyper link to be inserted.
    """
    pass
  def modifyCellHyperlinkToOtherSheet(self, WorksheetName : str, cell : str, worksheetOfLink : str, cellOfLink : str):
    """
    Modifies the hyper link of a specific cell to a specific hyper link to another sheet in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **cell** (str) – The cell's coordinates (i.e :code:`A5`).
      - **worksheetOfLink** (str) – The sheet to be linked to.
      - **cellOfLink** (str) – The cell in the worksheet to be linked to.
    """
    pass
  def modifyCellHyperlinkToOtherSheet(self, WorksheetName : str, Row : c_int32, Column : c_int32, worksheetOfLink : str, cellOfLink : str):
    """
    Modifies the hyper link of a specific cell to a specific hyper link to another sheet in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **Row** (c_int32) – Row number of the desired cell.
      - **Column** (c_int32) – Columns number of the desired cell.
      - **worksheetOfLink** (str) – The sheet to be linked to.
      - **cellOfLink** (str) – The cell in the other worksheet to be linked to.
    """
    pass
  def modifyCellRangeFormula(self, WorksheetName : str, firstCell : str, lastCell : str, formula : str):
    """
    Modifies the formula of a specific range in a specific worksheet.

      - **WorksheetName** (str) – Desired worksheet name.
      - **firstCell** (str) – Coordinates of the first cell in the range.
      - **lastCell** (str) – Coordinates of the last cell in the range.
      - **formula** (str) – The formula to be inserted.
    """
    pass
  def save(self):
    """
    Saves the file.

    """
    pass

  pass

"""
Holds the configuration for sending messages respecting ISO-TP protocol for diag messages.
"""
class IsoTp:
  block_size : c_uint8

  enabled : c_bool

  padding_byte : c_uint8

  request_id : c_int16

  response_id : c_int16

  separation_time : c_uint8

  timeout : c_uint32


  pass

"""
Represents an ARP Message object.
"""
class MessageARP:
  def capture(self, filter : Filter = None) -> MessageARP:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageARP
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageARP:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageARP
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageARP]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageARP]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def ping(self, target_ip : str) -> IMessageBase:
    """
    Creates an ARP ping message to discover the target MAC address, sends it and waits for a response.

      **target_ip** (str) – IP address of the target device.
    :return: ARP message got as a response to the ping sent, if there is any.
    :rtype: IMessageBase
    """
    pass
  def ping(self, target_ip : str, timeout : c_int32) -> IMessageBase:
    """
    Creates an ARP ping message to discover the target MAC address, sends it and waits for a response. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **target_ip** (str) – IP address of the target device.
      - **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response.
    :return: ARP message got as a response to the ping sent, if there is any.
    :rtype: IMessageBase
    """
    pass
  def receive(self) -> MessageARP:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageARP
    """
    pass
  def receive(self, timeout : c_int32) -> MessageARP:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageARP
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageARP]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageARP]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> MessageARP:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: MessageARP
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[MessageARP]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[MessageARP]
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_arp_responder(self):
    """
    Starts a process in charge of filtering the ARP request messages sent to the tester address and generates the corresponding responses. It answers using the same criteria for the VLAN tags as the request: if the request was sent with VLAN, it uses VLAN in the response; if not, no VLAN tags are used.

    """
    pass
  def start_arp_responder(self, timeout_milliseconds : c_int32):
    """
    Starts a process in charge of filtering the ARP request messages sent to the tester address and generates the corresponding responses. It answers using the same criteria for the VLAN tags as the request: if the request was sent with VLAN, it uses VLAN in the response; if not, no VLAN tags are used.

      **timeout_milliseconds** (c_int32) – (optional) Max time in milliseconds to keep the ARP responder working.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_arp_responder(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageARP):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageARP) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  hardware_size : c_uint8

  hardware_type : HARDWARE_TYPE

  operation : Operation

  payload : Array[c_uint8]

  proto_type : EtherType

  protocol_size : c_uint8

  protocol_type : PROTOCOL_TYPE

  sender_ip_address : str

  sender_mac_address : str

  target_ip_address : str

  target_mac_address : str

  timestamp : decimal

  vlan_tag : HeaderVlan


  pass

"""
Used to distinguish between request and reply operations in ARP and DHCP messages.
"""
class Operation(Enum):

  request = 0x0001
  reply = 0x0002
  pass

"""
An enumeration that represents the possible hardware types values.
"""
class HARDWARE_TYPE(Enum):

  NETROM_pseudo = 0x0000
  Ethernet = 0x0001
  ExperimentalEthernet3MB = 0x0002
  AmateurRadioAX25 = 0x0003
  ProteonProNetTokenRing = 0x0004
  Chaos = 0x0005
  IEEE802 = 0x0006
  ARCNET = 0x0007
  Hyperchannel = 0x0008
  Lanstar = 0x0009
  AutonetShortAddress = 0x000A
  LocalTalk = 0x000B
  LocalNet = 0x000C
  Ultralink = 0x000D
  SMDS = 0x000E
  FrameRelay = 0x000F
  AsynchronousTransmissionMode = 0x0010
  HDLC = 0x0011
  FibreChannel = 0x0012
  SerialLine = 0x0014
  MILSTD188220 = 0x0016
  Metricom = 0x0017
  IEEE13941995 = 0x0018
  MAPOS = 0x0019
  Twinaxial = 0x001A
  EUI64 = 0x001B
  HIPARP = 0x001C
  IPandARPoverISO78163 = 0x001D
  ARPSec = 0x001E
  IPsectunnel = 0x001F
  InfiniBand = 0x0020
  TIA102Project25CommonAirInterface = 0x0021
  WiegandInterface = 0x0022
  PureIP = 0x0023
  HW_EXP1 = 0x0024
  HFI = 0x0025
  Unknown = 0x00FF
  pass

"""
An enumeration that represents the possible protocol type values.
"""
class PROTOCOL_TYPE(Enum):

  UNKNOWN = 0x0000
  SOMEIP_SD = 0x0001
  NM = 0x0002
  ICMP = 0x0003
  DHCP = 0x0004
  HSFZ = 0x0005
  UDP = 0x0006
  TFTP = 0x0007
  ETHERNET_FRAME = 0x0008
  TCP = 0x0009
  IEEE1722 = 0x000A
  SOMEIP = 0x000B
  CAN = 0x000C
  NONE = 0x000D
  LIN = 0x000E
  ETHCC = 0x000F
  ETHNM = 0x0010
  ETHAVB = 0x0011
  ETHDIAG = 0x0012
  MMRP = 0x0013
  MVRP = 0x0014
  MSRP = 0x0015
  DOIP = 0x0016
  ETHTP = 0x0017
  Reprog = 0x0018
  PDU = 0x0019
  FLEXRAY = 0x001A
  DLT = 0x001B
  TLS = 0x001C
  ICMPv6 = 0x003A
  IP = 0x0800
  IPv4 = 0x0800
  ARP = 0x0806
  VLAN_TAGGED = 0x8100
  IPv6 = 0x86DD
  PROVIDER_BRIDGING = 0x88A8
  PTP = 0x88F7
  QINQ = 0x9100
  pass

"""
Represents Message Builder for standard protocols that are supported by ANDi.
"""
class MessageBuilder:
  def create_1722_message(self, sender : object = None, receiver : object = None) -> MessageIEEE1722:
    """
    Creates an IEEE1722 message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageIEEE1722
    """
    pass
  def create_analog_message(self, sender : object = None, receiver : object = None) -> MessageAnalog:
    """
    Creates an analog message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageAnalog
    """
    pass
  def create_arp_message(self, sender : object = None, receiver : object = None) -> MessageARP:
    """
    Creates an ARP message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the
    :return: Message object created.
    :rtype: MessageARP
    """
    pass
  def create_can_message(self, sender : object = None, receiver : object = None) -> MessageCAN:
    """
    Creates a CAN message object.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageCAN
    """
    pass
  def create_dhcp_message(self, sender : object = None, receiver : object = None) -> MessageDHCP:
    """
    Creates a DHCP message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageDHCP
    """
    pass
  def create_dlt_message(self, sender : object = None, receiver : object = None) -> MessageDlt:
    """
    Creates a DLT message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive the message.
    :return: Message object created
    :rtype: MessageDlt
    """
    pass
  def create_doip_message(self, sender : object = None, receiver : object = None) -> IMessageDiagBasic:
    """
    Creates a DoIP message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message.
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: IMessageDiagBasic
    """
    pass
  def create_ethernet_message(self, sender : object = None, receiver : object = None) -> MessageEthernet:
    """
    Creates an Ethernet message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageEthernet
    """
    pass
  def create_flexray_message(self, sender : object = None, receiver : object = None) -> MessageFlexray:
    """
    Creates a FlexRay message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageFlexray
    """
    pass
  def create_hsfz_message(self, sender : object = None, receiver : object = None) -> MessageHSFZ:
    """
    Creates a HSFZ message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageHSFZ
    """
    pass
  def create_http_message(self, sender : object = None, receiver : object = None) -> MessageHttp:
    """
    Creates a HTTP message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageHttp
    """
    pass
  def create_icmp_message(self, sender : object = None, receiver : object = None) -> MessageICMPv4:
    """
    Creates an ICMP message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageICMPv4
    """
    pass
  def create_icmpv6_message(self, sender : object = None, receiver : object = None) -> MessageICMPv6:
    """
    Creates an ICMPV6 message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageICMPv6
    """
    pass
  def create_ip_message(self, sender : object = None, receiver : object = None) -> MessageIpv4:
    """
    Creates an IP message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageIpv4
    """
    pass
  def create_ipv6_message(self, sender : object = None, receiver : object = None) -> MessageIPv6:
    """
    Creates an IPV6 message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageIPv6
    """
    pass
  def create_lin_message(self, sender : object = None, receiver : object = None) -> MessageLIN:
    """
    Creates a LIN message object.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageLIN
    """
    pass
  def create_mmrp_message(self, sender : object = None, receiver : object = None) -> MessageSRP:
    """
    Creates an SRP message object with default values in its fields using a MAC base.

      - **sender** (object) – network adapter used to send the message.
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageSRP
    """
    pass
  def create_mvrp_message(self, sender : object = None, receiver : object = None) -> MessageSRP:
    """
    Creates an SRP message object with default values in its fields using a VLAN base.

      - **sender** (object) – network adapter used to send the message.
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageSRP
    """
    pass
  def create_pdu_message(self, sender : object = None, receiver : object = None) -> MessagePDU:
    """
    Creates a PDU message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessagePDU
    """
    pass
  def create_ptp_message(self, sender : object = None, receiver : object = None) -> MessagePTP:
    """
    Creates a PTP message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessagePTP
    """
    pass
  def create_someip_message(self, sender : object = None, receiver : object = None) -> MessageSomeIP:
    """
    Creates a SOME/IP message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageSomeIP
    """
    pass
  def create_someip_sd_message(self, sender : object = None, receiver : object = None) -> MessageSomeIPSD:
    """
    Creates a SOME/IP-SD message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageSomeIPSD
    """
    pass
  def create_tcp_message(self, sender : object = None, receiver : object = None) -> MessageTCP:
    """
    Creates a TCP message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageTCP
    """
    pass
  def create_tftp_message(self, sender : object = None, receiver : object = None) -> MessageTFTP:
    """
    Creates a TFTP message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageTFTP
    """
    pass
  def create_tls_message(self, sender : object = None, receiver : object = None) -> MessageTls:
    """
    Creates a TLS message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageTls
    """
    pass
  def create_udp_message(self, sender : object = None, receiver : object = None) -> MessageUDP:
    """
    Creates an UDP message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageUDP
    """
    pass
  def create_udp_nm_message(self, sender : object = None, receiver : object = None) -> MessageNM:
    """
    Creates an UDP-NM  message object with default values in its fields.

      - **sender** (object) – network adapter used to send the message
      - **receiver** (object) – network adapter used to receive messages of the same protocol.
    :return: Message object created.
    :rtype: MessageNM
    """
    pass

  pass

"""
An Autosar PDU Message.
"""
class MessagePDU:
  def append_message(self, message : MessagePDU):
    """
    Lets the user packs several messages into one packet, each appended message will have its own header.

      **message** (MessagePDU) – The message to append
    """
    pass
  def capture(self, filter : Filter = None) -> MessagePDU:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessagePDU
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessagePDU:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessagePDU
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessagePDU]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessagePDU]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def connect(self, timeout : c_float = 1) -> c_bool:
    """
    Opens a TCP connection.

      **timeout** (c_float) – Number of seconds to wait for connection to establish before aborting.
    :return: for connect() returns :code:`True` if there’s a connection.
    :rtype: c_bool
    """
    pass
  def disconnect(self, timeout : c_float = 0):
    """
    Closes the TCP connection opened with connect.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_all_signals_values(self) -> dict[str, int]:
    """
    Gets a dictionary of all the signal values (name, value).

    :return: Dictionary of all signals values
    :rtype: dict[str, int]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def get_signal_value(self, name : str) -> Optional[int]:
    """
    Gets a value of a specific signal given its name.

      **name** (str) – Desired signal's name
    :return: Signal's value.
    :rtype: Optional[int]
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessagePDU:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessagePDU
    """
    pass
  def receive(self, timeout : c_int32) -> MessagePDU:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessagePDU
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessagePDU]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessagePDU]
    """
    pass
  def reset_signal_value(self, signalName : str = None):
    """
    Resets the signal value to its default value. If no :code:`signalName` is specified, reset all signals.

      **signalName** (str) – the name of the signal to reset
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def set_signal_value(self, name : str, value : Optional[c_uint64]):
    """
    Sets the value of a specific signal to a specific value.

      - **name** (str) – Desired signal's name
      - **value** (Optional[c_uint64]) – Desired signal's value
    """
    pass
  def signal(self, name : str) -> SignalValue:
    """
    Gets a signal by its name.

      **name** (str) – Desired signal's name
    :return: Signal's value.
    :rtype: SignalValue
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_listener(self):
    """
    Starts listening for TCP clients through the receiver network adapter.

    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_listener(self, timeout : c_float = 0):
    """
    Stops listening for TCP clients through the receiver network adapter.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessagePDU):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessagePDU) – The message object being handled.
    """
    pass
  auto_calculate : AutoCalculate

  capture_info : CaptureInfo

  connected : c_bool

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  length : Optional[c_uint32]

  message_id : c_uint32

  messages : List[MessagePDU]

  network_protocol : NetworkProtocols

  payload : Array[c_uint8]

  pdu : IFrameInstance

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  vlan_tag : HeaderVlan


  pass

"""
Represents an analog message, aggregates multiple measurement samples only a physical value and a timestamp
"""
class MessageAnalog:
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  capture_info : CaptureInfo

  data_base : Database

  frame_number : c_int64

  payload : Array[c_uint8]

  samples : Array[MeasurementSample]

  timestamp : decimal


  pass

"""
Represents a measurement sample
"""
class MeasurementSample:
  timestamp : decimal

  value : c_float


  pass

"""
Represents a TFTP (Trivial File Transfer Protocol) message object.
"""
class MessageTFTP:
  def capture(self, filter : Filter = None) -> MessageTFTP:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageTFTP
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageTFTP:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageTFTP
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageTFTP]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageTFTP]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def do_ack(self, block : c_uint16):
    """
    Sends an acknowledgment packet to inform the other side that the last packet(s) has (have) been correctly received.

      **block** (c_uint16) – The packet's content.
    """
    pass
  def do_error(self, error : str, errcode : ErrorCodes):
    """
    Sends an error packet to inform the other side that the last packet(s) has (have) been lost.

      - **error** (str) – Error name.
      - **errcode** (ErrorCodes) – Error code.
    """
    pass
  def do_write_data(self, files_bytes : object):
    """
    Writes the data included in the file specified as parameter.

      **files_bytes** (object) – Writes the data included in the file specified as parameter.
    """
    pass
  def do_write_request(self, file_names : str, is_octet_mode : c_bool):
    """
    Sends a request to write a particular file to the other side .

      - **file_names** (str) – The name of the file.
      - **is_octet_mode** (c_bool) – :code:`True` if the operation was in octet mode, :code:`False` otherwise.
    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_file_bytes(self, path : str) -> Array[c_uint8]:
    """
    Gets the bytes included in the file specified as parameter.

      **path** (str) – Path of the file where the messages will be stored.
    :return: Bytes included in the file.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageTFTP:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageTFTP
    """
    pass
  def receive(self, timeout : c_int32) -> MessageTFTP:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageTFTP
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageTFTP]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageTFTP]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def write_bytes_to_file(self, path : str, b : object) -> c_bool:
    """
    Writes the received bytes in the file specified as parameter.

      - **path** (str) – Path of the file where the messages will be stored.
      - **b** (object) – Bytes to write.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageTFTP):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageTFTP) – The message object being handled.
    """
    pass
  block : c_uint16

  capture_info : CaptureInfo

  data_base : Database

  error_code : ErrorCodes

  error_string : str

  ethernet_header : HeaderEthernet

  file_data : Array[c_uint8]

  file_name : str

  frame_number : c_int64

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  mode : Modes

  network_protocol : NetworkProtocols

  op_codes : Opcodes

  payload : Array[c_uint8]

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  udp_header : HeaderUDP

  vlan_tag : HeaderVlan


  pass

"""
An enumeration that represents the different Error Codes values.
"""
class ErrorCodes(Enum):

  TFTP_ERROR_UNDEFINED = 0x00000000
  TFTP_ERROR_FILE_NOT_FOUND = 0x00000001
  TFTP_ERROR_ACCESS_VIOLATION = 0x00000002
  TFTP_ERROR_ALLOC_ERROR = 0x00000003
  TFTP_ERROR_ILLEGAL_OP = 0x00000004
  TFTP_ERROR_UNKNOWN_TID = 0x00000005
  TFTP_ERROR_FILE_EXISTS = 0x00000006
  TFTP_ERROR_INVALID_USER = 0x00000007
  pass

"""
An enumeration that represents the TFTP possible operation codes.
"""
class Opcodes(Enum):

  UNKNOWN = 0x00000000
  TFTP_RRQ = 0x00000001
  TFTP_WRQ = 0x00000002
  TFTP_DATA = 0x00000003
  TFTP_ACK = 0x00000004
  TFTP_ERROR = 0x00000005
  TFTP_OACK = 0x00000006
  pass

"""
An enumeration that represents the possible modes (NET ASCII or OCTET).
"""
class Modes(Enum):

  NETASCII = 0x00000000
  OCTET = 0x00000001
  pass

"""
Represents a HSFZ message object.
"""
class MessageHSFZ:
  def append_message(self, message : MessageHSFZ):
    """
    Lets the user packs several messages into one packet, each appended message will have its own header.

      **message** (MessageHSFZ) – The message to append
    """
    pass
  def capture(self, filter : Filter = None) -> MessageHSFZ:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageHSFZ
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageHSFZ:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageHSFZ
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageHSFZ]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageHSFZ]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def connect(self, timeout : c_float = 1) -> c_bool:
    """
    Opens a TCP connection.

      **timeout** (c_float) – Number of seconds to wait for connection to establish before aborting.
    :return: for connect() returns :code:`True` if there’s a connection.
    :rtype: c_bool
    """
    pass
  def disconnect(self, timeout : c_float = 0):
    """
    Closes the TCP connection opened with connect.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageHSFZ:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageHSFZ
    """
    pass
  def receive(self, timeout : c_int32) -> MessageHSFZ:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageHSFZ
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageHSFZ]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageHSFZ]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> MessageHSFZ:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: MessageHSFZ
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[MessageHSFZ]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[MessageHSFZ]
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_listener(self):
    """
    Starts listening for TCP clients through the receiver network adapter.

    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_listener(self, timeout : c_float = 0):
    """
    Stops listening for TCP clients through the receiver network adapter.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageHSFZ):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageHSFZ) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  connected : c_bool

  ctr_word : HSFZCtrlWordMapping

  data_base : Database

  diag : Diag

  diagnostic_payload_data : Array[c_uint8]

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  hsfz_payload : Array[c_uint8]

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  length : Optional[c_int32]

  messages : List[MessageHSFZ]

  network_protocol : NetworkProtocols

  payload : Array[c_uint8]

  tcp_header : HeaderTCP

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  udp_header : HeaderUDP

  vis : VIS

  vlan_tag : HeaderVlan


  pass

"""
Used to determine the type of the control word of an HSFZ message.
"""
class HSFZCtrlWordMapping(Enum):

  UNKNOWN = 0x0000
  CTRLWORD_REQUEST_RESPONSE = 0x0001
  CTRLWORD_ACK = 0x0002
  REQUEST_KLEMME = 0x0010
  REQUEST_VEHICULE_IDENT_DATA = 0x0011
  ALIVE_CHECK = 0x0012
  REQUEST_STATUS_DATA = 0x0013
  WRONG_TESTER_ADDRESS = 0x0040
  WRONG_CONTROL_WORD = 0x0041
  WRONG_FORMAT = 0x0042
  WRONG_DESTINATION_ADDRESS = 0x0043
  MESSAGE_TOO_BIG = 0x0044
  DIAGNOSIS_APP_NOT_READY = 0x0045
  NO_MEMORY_AVAILABLE = 0x00FF
  pass

"""
Represents a Diag serve object.
"""
class Diag:
  data : Array[c_uint8]

  diag_negative_response_code : c_uint8

  diag_negative_response_service : c_uint8

  diag_service_id : HSFZServices

  source_address : c_uint8

  target_address : c_uint8


  pass

"""
An enumeration that represents the possible values of the HSFZ Services.
            See https://en.wikipedia.org/wiki/Unified_Diagnostic_Services.
"""
class HSFZServices(Enum):

  Unknown = 0x00
  DiagnosticSessionControl = 0x10
  ECUReset = 0x11
  ClearDiagnosticInformation = 0x14
  ReadDTCInformation = 0x19
  ReadDataByIdentifier = 0x22
  ReadMemoryByAddress = 0x23
  ReadScalingDataByIdentifier = 0x24
  SecurityAccess = 0x27
  CommunicationControl = 0x28
  ReadDataByPeriodicIdentifier = 0x2A
  DynamicallyDefineDataIdentifier = 0x2C
  WriteDataByIdentifier = 0x2E
  InputOuputControlByIdentifier = 0x2F
  RoutineControl = 0x31
  RequestDownload = 0x34
  RequestUpload = 0x35
  TransferData = 0x36
  TransferExit = 0x37
  WriteMemoryByAddress = 0x3D
  TesterPresent = 0x3E
  AccessTimingParameters = 0x83
  SecuredDataTransmission = 0x84
  ControlDTCSetting = 0x85
  ResponseOnEvent = 0x86
  LinkControl = 0x87
  pass

"""
Represents a VIS (Vehicle identification service) object.
"""
class VIS:
  bmw_mac : Array[c_uint8]

  bmw_vin : Array[c_uint8]

  diag_address : c_uint16


  pass

"""
Represents an ethernet message object.
"""
class MessageEthernet:
  def capture(self, filter : Filter = None) -> MessageEthernet:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageEthernet
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageEthernet:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageEthernet
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageEthernet]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageEthernet]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_arp_layer(self) -> MessageARP:
    """
    Extracts the ARP layer from the message.

    :return: ARP packet extracted. If no ARP layer found, :code:`None` is returned.
    :rtype: MessageARP
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_can_layer(self) -> MessageCAN:
    """
    Extracts the CAN layer from the message.

    :return: CAN packet extracted. If no CAN layer found, :code:`None` is returned.
    :rtype: MessageCAN
    """
    pass
  def get_dhcp_layer(self) -> MessageDHCP:
    """
    Extracts the DHCP layer from the message.

    :return: DHCP packet extracted. If no DHCP layer found, :code:`None` is returned.
    :rtype: MessageDHCP
    """
    pass
  def get_dlt_layer(self) -> MessageDlt:
    """
    Extracts the DLT layer from the message, if present.

    :return: Encapsulated DLT packet including both header and data. If no DLT layer found, :code:`None` is returned.
    :rtype: MessageDlt
    """
    pass
  def get_ethernet_layer(self) -> MessageEthernet:
    """
    Extracts the ethernet layer from the message, if present.

    :return: Encapsulated Ethernet Packet if the parent message is an Ethernet Gateway. If no Ethernet Layer is found, :code:`None` is returned.
    :rtype: MessageEthernet
    """
    pass
  def get_flexray_layer(self) -> MessageFlexray:
    """
    Extracts the FlexRay layer from the message.

    :return: FlexRay packet extracted. If no FlexRay layer found, :code:`None` is returned.
    :rtype: MessageFlexray
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def get_hsfz_layer(self) -> MessageHSFZ:
    """
    Extracts the HSFZ layer from the message.

    :return: HSFZ packet extracted. If no HSFZ layer found, :code:`None` is returned.
    :rtype: MessageHSFZ
    """
    pass
  def get_icmp_layer(self) -> MessageICMPv4:
    """
    Extracts the ICMP layer from the message.

    :return: ICMP packet extracted. If no ICMP layer found, :code:`None` is returned.
    :rtype: MessageICMPv4
    """
    pass
  def get_ieee1722_layer(self) -> MessageIEEE1722:
    """
    Extracts the IEEE1722 layer from the message.

    :return: IEEE1722 packet extracted. If no IEEE1722 layer found, :code:`None` is returned.
    :rtype: MessageIEEE1722
    """
    pass
  def get_ipv4_layer(self) -> MessageIpv4:
    """
    Extracts the IPv4 layer from the message, if present.

    :return: IPv4 packet, including both header and data. If no IPv4 layer found, :code:`None` is returned.
    :rtype: MessageIpv4
    """
    pass
  def get_ipv6_layer(self) -> MessageIPv6:
    """
    Extracts the IPv6 layer from the message, if present.

    :return: IPv6 packet, including both header and data. If no IPv6 layer found, :code:`None` is returned.
    :rtype: MessageIPv6
    """
    pass
  def get_layer(self, type : PROTOCOL_TYPE) -> IMessageBase:
    """
    Extracts a layer from the message given its type.

      **type** (PROTOCOL_TYPE) – Desired layer.
    :return: Packet extracted, if the layer is not found, :code:`None` is returned.
    :rtype: IMessageBase
    """
    pass
  def get_lin_layer(self) -> MessageLIN:
    """
    Extracts the LIN layer from the message.

    :return: LIN packet extracted. If no LIN layer found, :code:`None` is returned.
    :rtype: MessageLIN
    """
    pass
  def get_nm_layer(self) -> MessageNM:
    """
    Extracts the NM layer from the message, if present.

    :return: NM packet extracted. If no NM layer found, :code:`None` is returned. NOTE: Due to its simplicity, it has no header or payload sections, so the whole message is treated as NM payload.
    :rtype: MessageNM
    """
    pass
  def get_pdu_layer(self) -> MessagePDU:
    """
    Extracts the PDU layer from the message, if present.

    :return: PDU packet, including both header and data. If no PDU layer found, :code:`None` is returned.
    :rtype: MessagePDU
    """
    pass
  def get_ptp_layer(self) -> MessagePTP:
    """
    Extracts the PTP layer from the message.

    :return: PTP packet extracted. If no PTP layer found, :code:`None` is returned.
    :rtype: MessagePTP
    """
    pass
  def get_someip_layer(self) -> MessageSomeIP:
    """
    Extracts the SOME/IP layer from the message, if present.

    :return: SOME/IP packet extracted. If no SOME/IP layer found, :code:`None` is returned.
    :rtype: MessageSomeIP
    """
    pass
  def get_someip_sd_layer(self) -> MessageSomeIPSD:
    """
    Extracts the SOME/IP-SD layer from the message, if present.

    :return: Whole SOME/IP-SD packet extracted. If no SOME/IP-SD layer found, :code:`None` is returned.
    :rtype: MessageSomeIPSD
    """
    pass
  def get_tcp_layer(self) -> MessageTCP:
    """
    Extracts the TCP layer from the message.

    :return: TCP packet extracted. If no TCP layer found, :code:`None` is returned.
    :rtype: MessageTCP
    """
    pass
  def get_tls_layer(self) -> MessageTls:
    """
    Extracts the TLS layer from the message.

    :return: TLS packet extracted. If no TLS layer found, :code:`None` is returned.
    :rtype: MessageTls
    """
    pass
  def get_udp_layer(self) -> MessageUDP:
    """
    Extracts the UDP layer from the message.

    :return: UDP packet extracted. If no UDP layer found, :code:`None` is returned.
    :rtype: MessageUDP
    """
    pass
  def has_layer(self, protocol : PROTOCOL_TYPE) -> c_bool:
    """
    Checks if the message has a layer of the given protocol.

      **protocol** (PROTOCOL_TYPE) – Desired protocol layer. see Protocol type enum for a list of valid values.
    :return: :code:`True` if the layer is present in the message. Otherwise, :code:`False`.
    :rtype: c_bool
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageEthernet:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageEthernet
    """
    pass
  def receive(self, timeout : c_int32) -> MessageEthernet:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageEthernet
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageEthernet]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageEthernet]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageEthernet):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageEthernet) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  data_base : Database

  ether_type : EtherType

  frame_number : c_int64

  mac_address_destination : str

  mac_address_source : str

  payload : Array[c_uint8]

  timestamp : decimal

  vlan_tag : HeaderVlan


  pass

"""
Represents a PTP (Precision Time Protocol) message object, follows PTPv2 specifications.
"""
class MessagePTP:
  def capture(self, filter : Filter = None) -> MessagePTP:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessagePTP
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessagePTP:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessagePTP
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessagePTP]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessagePTP]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessagePTP:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessagePTP
    """
    pass
  def receive(self, timeout : c_int32) -> MessagePTP:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessagePTP
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessagePTP]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessagePTP]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessagePTP):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessagePTP) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  clock_identity : Optional[c_uint64]

  control : c_uint8

  correction : c_float

  data_base : Database

  ethernet_header : HeaderEthernet

  flags : c_uint16

  followup_tlv : IFollowUpTlv

  frame_number : c_int64

  log_message_period : c_int8

  message_id : c_uint8

  message_length : c_uint16

  message_type : PtpMessageTypes

  message_type_specific : c_uint32

  minor_sdo_id : c_uint8

  minor_version_ptp : c_uint8

  origin_timestamp : ITimeSpan

  payload : Array[c_uint8]

  requesting_port_id : Optional[c_uint16]

  requesting_port_identity : Optional[c_uint64]

  sequence_id : c_uint16

  source_port_id : c_uint16

  subdomain_number : c_uint8

  timestamp : decimal

  transport_specific : c_uint8

  version : c_uint8

  vlan_tag : HeaderVlan


  pass

"""
An enumeration that represents the possible PTP Message types.
"""
class PtpMessageTypes(Enum):

  Sync = 0x00000000
  DelayReq = 0x00000001
  PDelayReq = 0x00000002
  PDelayResp = 0x00000003
  FollowUp = 0x00000008
  DelayResp = 0x00000009
  PDelayRespFollowUp = 0x0000000A
  Announce = 0x0000000B
  Signaling = 0x0000000C
  Management = 0x0000000D
  PTP_MAX_Message = 0x0000000E
  pass

"""
Represents a TimeSpan object. used by timer to set cycles.
"""
class ITimeSpan:
  nanoseconds : Optional[c_uint32]

  seconds : Optional[c_uint64]


  pass

"""
Represents a follow up TLV for PTP message (an extension to follow up messages with extra information).
"""
class IFollowUpTlv:
  cumulative_scaled_rate_offset : Optional[c_uint32]

  gm_time_base_indicator : Optional[c_uint16]

  last_gm_phase_change : Array[c_uint8]

  length_field : Optional[c_uint16]

  organization_id : Optional[c_uint32]

  organization_sub_type : Optional[c_uint32]

  scaled_last_gm_freq_change : Optional[c_uint32]

  tlv_type : Optional[c_uint16]


  pass

"""
Represents a UDP (User Datagram Protocol) message object.
"""
class MessageUDP:
  def capture(self, filter : Filter = None) -> MessageUDP:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageUDP
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageUDP:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageUDP
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageUDP]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageUDP]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def decode_as_doip(self) -> IMessageDiagBasic:
    """
    Tries to decode the payload of the UDP message as a DOIP packet.

    :return: SOME/IP-SD message if the payload could be decoded as a SOME/IP-SD message, :code:`None` value if not.
    :rtype: IMessageDiagBasic
    """
    pass
  def decode_as_someip(self) -> MessageSomeIP:
    """
    Tries to decode the payload of the UDP message as a SOME/IP packet (SOME/IP-SD packets are not considered)

    :return: SOME/IP message if the payload could be decoded as a SOME/IP message, :code:`None` value if not.
    :rtype: MessageSomeIP
    """
    pass
  def decode_as_someip_sd(self) -> MessageSomeIPSD:
    """
    Tries to decode the payload of the UDP message as a SOME/IP-SD packet.

    :return: SOME/IP-SD message if the payload could be decoded as a SOME/IP-SD message, :code:`None` value if not.
    :rtype: MessageSomeIPSD
    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageUDP:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageUDP
    """
    pass
  def receive(self, timeout : c_int32) -> MessageUDP:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageUDP
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageUDP]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageUDP]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> MessageUDP:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: MessageUDP
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[MessageUDP]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[MessageUDP]
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageUDP):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageUDP) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  network_protocol : NetworkProtocols

  payload : Array[c_uint8]

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  udp_header : HeaderUDP

  vlan_tag : HeaderVlan


  pass

"""
Represents a Basic diag message object.
"""
class IMessageDiagBasic:
  def capture(self, filter : Filter = None) -> IMessageDiagBasic:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: IMessageDiagBasic
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> IMessageDiagBasic:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: IMessageDiagBasic
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[IMessageDiagBasic]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[IMessageDiagBasic]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def connect(self, timeout : c_float = 1) -> c_bool:
    """
    Opens a TCP connection.

      **timeout** (c_float) – Number of seconds to wait for connection to establish before aborting.
    :return: for connect() returns :code:`True` if there’s a connection.
    :rtype: c_bool
    """
    pass
  def disconnect(self, timeout : c_float = 0):
    """
    Closes the TCP connection opened with connect.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> IMessageDiagBasic:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: IMessageDiagBasic
    """
    pass
  def receive(self, timeout : c_int32) -> IMessageDiagBasic:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: IMessageDiagBasic
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[IMessageDiagBasic]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[IMessageDiagBasic]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> IMessageDiagBasic:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: IMessageDiagBasic
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[IMessageDiagBasic]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[IMessageDiagBasic]
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_listener(self):
    """
    Starts listening for TCP clients through the receiver network adapter.

    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_listener(self, timeout : c_float = 0):
    """
    Stops listening for TCP clients through the receiver network adapter.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : IMessageDiagBasic):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (IMessageDiagBasic) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  connected : c_bool

  data_base : Database

  doip_ack : Optional[c_uint8]

  doip_nack : Optional[c_uint8]

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  inverse_protocol_version : Optional[c_uint8]

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  iso_tp : IsoTp

  network_protocol : NetworkProtocols

  payload : Array[c_uint8]

  payload_length : Optional[c_uint32]

  payload_type : c_uint16

  protocol_version : c_uint8

  source_address : c_uint16

  target_address : c_uint16

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  uds : Uds

  vlan_tag : HeaderVlan


  pass

"""
UDS Service for doip message
"""
class Uds:
  data : Array[c_uint8]

  is_reply : Optional[c_bool]

  service : Optional[UdsServices]

  service_id : Optional[c_uint8]


  pass

"""
An enumeration that represents the possible values of the diagnostic communication protocol UDS (Unified Diagnostic Services).
            See https://en.wikipedia.org/wiki/Unified_Diagnostic_Services.
"""
class UdsServices(Enum):

  DiagnosticSessionControl = 0x10
  ECUReset = 0x11
  ClearDiagnosticInformation = 0x14
  ReadDTCInformation = 0x19
  ReadDataByIdentifier = 0x22
  ReadMemoryByAddress = 0x23
  ReadScalingDataByIdentifier = 0x24
  SecurityAccess = 0x27
  CommunicationControl = 0x28
  ReadDataByPeriodicIdentifier = 0x2A
  DynamicallyDefineDataIdentifier = 0x2C
  WriteDataByIdentifier = 0x2E
  InputOutputControlByIdentifier = 0x2F
  RoutineControl = 0x31
  RequestDownload = 0x34
  RequestUpload = 0x35
  TransferData = 0x36
  RequestTransferExit = 0x37
  RequestFileTransfer = 0x38
  WriteMemoryByAddress = 0x3D
  TesterPresent = 0x3E
  NegativeResponse = 0x3F
  AccessTimingParameter = 0x83
  SecuredDataTransmission = 0x84
  ControlDTCSetting = 0x85
  ResponseOnEvent = 0x86
  LinkControl = 0x87
  pass

"""
Represents a TCP (Transmission Control Protocol) message object.
"""
class MessageTCP:
  def capture(self, filter : Filter = None) -> MessageTCP:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageTCP
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageTCP:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageTCP
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageTCP]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageTCP]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def connect(self, timeout : c_float = 1) -> c_bool:
    """
    Opens a TCP connection.

      **timeout** (c_float) – Number of seconds to wait for connection to establish before aborting.
    :return: for connect() returns :code:`True` if there’s a connection.
    :rtype: c_bool
    """
    pass
  def decode_as_hsfz(self) -> MessageHSFZ:
    """
    Tries to decode the payload of the TCP message as a HSFZ packet (SOME/IP-SD).

    :return: HSFZ message if the payload could be decoded as a HSFZ message, :code:`None` value if not.
    :rtype: MessageHSFZ
    """
    pass
  def decode_as_someip(self) -> MessageSomeIP:
    """
    Tries to decode the payload of the UDP message as a SOME/IP packet (SOME/IP-SD packets are not considered)

    :return: SOME/IP message if the payload could be decoded as a SOME/IP message, :code:`None` value if not.
    :rtype: MessageSomeIP
    """
    pass
  def disconnect(self, timeout : c_float = 0):
    """
    Closes the TCP connection opened with connect.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageTCP:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageTCP
    """
    pass
  def receive(self, timeout : c_int32) -> MessageTCP:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageTCP
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageTCP]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageTCP]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> MessageTCP:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: MessageTCP
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[MessageTCP]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[MessageTCP]
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_listener(self):
    """
    Starts listening for TCP clients through the receiver network adapter.

    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_listener(self, timeout : c_float = 0):
    """
    Stops listening for TCP clients through the receiver network adapter.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageTCP):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageTCP) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  connected : c_bool

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  network_protocol : NetworkProtocols

  payload : Array[c_uint8]

  tcp_header : HeaderTCP

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  vlan_tag : HeaderVlan


  pass

"""
Represents a standard IEEE1722 message object.
"""
class MessageIEEE1722:
  def capture(self, filter : Filter = None) -> MessageIEEE1722:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageIEEE1722
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageIEEE1722:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageIEEE1722
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageIEEE1722]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageIEEE1722]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageIEEE1722:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageIEEE1722
    """
    pass
  def receive(self, timeout : c_int32) -> MessageIEEE1722:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageIEEE1722
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageIEEE1722]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageIEEE1722]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_auto_increment(self):
    """
    Sends the message (the one used to call the method) through the Ethernet bus and, unlike the send method, it also increments the value of the sequence number.

    """
    pass
  def set_acceptable_delta_time(self, delta_time : c_float):
    """
    Sets the acceptable delta time between packets sent by pcap player.

      **delta_time** (c_float) – Desired delta time.
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_delta_time_exceeded(self, message : Message, delta_time_microsecond : c_float):
    """
    Event is triggered when the delta time between packets exceed the acceptable delta time.

      - **message** (Message) – Message to monitor.
      - **delta_time_microsecond** (c_float) – The delta time.
    """
    pass
  def on_frame_counter_packet_loss(self, message : Message, last_frame_number : c_int32, current_frame_number : c_int32, nb_missing_frames : c_int32):
    """
    Event is triggered when the frame counter is not respected.

      - **message** (Message) – Message to monitor.
      - **last_frame_number** (c_int32) – Last frame number.
      - **current_frame_number** (c_int32) – Current frame number.
      - **nb_missing_frames** (c_int32) – Number of missing frames.
    """
    pass
  def on_message_received(self, message : MessageIEEE1722):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageIEEE1722) – The message object being handled.
    """
    pass
  def on_sequence_number_packet_loss(self, message : Message, last_sequence_number : c_int32, current_squence_number : c_int32, nb_missing_packets : c_int32):
    """
    Event is triggered when the sequence number is not respected.

      - **message** (Message) – The message to monitor.
      - **last_sequence_number** (c_int32) – The last sequence number.
      - **current_squence_number** (c_int32) – The current sequence number.
      - **nb_missing_packets** (c_int32) – The number of missing packets.
    """
    pass
  avbtp_stream_id_valid : c_bool

  avbtp_timestamp : c_uint32

  avbtp_timestamp_uncertain : c_bool

  avbtp_timestamp_valid : c_bool

  capture_info : CaptureInfo

  control_data_indicator : c_bool

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  gateway_info : c_uint32

  gateway_info_field : c_bool

  media_engine_restart : c_bool

  packet_data_length : c_uint16

  payload : Array[c_uint8]

  protocol_specific_packet_header : c_uint16

  reserved : c_bool

  seq_number : c_uint8

  stream_id : c_uint64

  subtype : c_uint8

  timestamp : decimal

  version : c_uint8

  vlan_tag : HeaderVlan


  pass

"""
Represents an ICMPv4 message object.
"""
class MessageICMPv4:
  def capture(self, filter : Filter = None) -> MessageICMPv4:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageICMPv4
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageICMPv4:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageICMPv4
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageICMPv4]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageICMPv4]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageICMPv4:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageICMPv4
    """
    pass
  def receive(self, timeout : c_int32) -> MessageICMPv4:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageICMPv4
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageICMPv4]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageICMPv4]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> MessageICMPv4:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: MessageICMPv4
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[MessageICMPv4]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[MessageICMPv4]
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageICMPv4):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageICMPv4) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  checksum : c_uint16

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  identifier : c_uint16

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  originateTimestamp : c_uint32

  payload : Array[c_uint8]

  pointerField : c_uint8

  receiveTimestamp : c_uint32

  sequence : c_uint16

  timestamp : decimal

  transmitTimestamp : c_uint32

  type_code : ICMPv4TypeCodes1

  vlan_tag : HeaderVlan


  pass

"""
Used to get/set the type and code (at once) of an ICMP message.
"""
class ICMPv4TypeCodes1(Enum):

  EchoReply = 0x0000
  Unassigned1 = 0x0100
  Unassigned2 = 0x0200
  Unreachable_Net = 0x0300
  Unreachable_Host = 0x0301
  Unreachable_Protocol = 0x0302
  Unreachable_Port = 0x0303
  Unreachable_FragmentationNeeded = 0x0304
  Unreachable_SourceRouteFailed = 0x0305
  Unreachable_DestinationNetworkUnknown = 0x0306
  Unreachable_DestinationHostUnknown = 0x0307
  Unreachable_SourceHostIsolated = 0x0308
  Unreachable_NetworkProhibited = 0x0309
  Unreachable_HostProhibited = 0x030A
  Unreachable_NetworkUnreachableForServiceType = 0x030B
  Unreachable_HostUnreachableForServiceType = 0x030C
  Unreachable_CommunicationProhibited = 0x030D
  Unreachable_HostPrecedenceViolation = 0x030E
  Unreachable_PrecedenceCutoffInEffect = 0x030F
  SourceQuench = 0x0400
  AlternateHostAddress = 0x0500
  Redirect_Network = 0x0500
  Redirect_Host = 0x0501
  Redirect_TypeOfServiceAndNetwork = 0x0502
  Redirect_TypeOfServiceAndHost = 0x0503
  Unassigned3 = 0x0700
  EchoRequest = 0x0800
  RouterAdvertisement = 0x0900
  RouterSelection = 0x0A00
  TimeExceeded = 0x0B00
  ParameterProblem_PointerIndicatesError = 0x0C00
  ParameterProblem_MissingRequiredOption = 0x0C01
  ParameterProblem_BadLength = 0x0C02
  Timestamp = 0x0D00
  TimestampReply = 0x0E00
  InformationRequest = 0x0F00
  InformationReply = 0x1000
  AddressMaskRequest = 0x1100
  AddressMaskReply = 0x1200
  Reserved4Security = 0x1300
  Reserved4robustnessExperiment1 = 0x1400
  Reserved4robustnessExperiment2 = 0x1500
  Reserved4robustnessExperiment3 = 0x1600
  Reserved4robustnessExperiment4 = 0x1700
  Reserved4robustnessExperiment5 = 0x1800
  Reserved4robustnessExperiment6 = 0x1900
  Reserved4robustnessExperiment7 = 0x1A00
  Reserved4robustnessExperiment8 = 0x1B00
  Reserved4robustnessExperiment9 = 0x1C00
  Reserved4robustnessExperiment10 = 0x1D00
  Traceroute = 0x1E00
  DatagramConversionError = 0x1F00
  MobileHostRedirect = 0x2000
  IPv6WhereAreYou = 0x2100
  IPv6IAmHere = 0x2200
  MobileReqistrationRequest = 0x2300
  MobileRegistrationReply = 0x2400
  Skip = 0x2500
  Photuri_BadSPI = 0x2600
  Photuri_AuthenticationFailed = 0x2601
  Photuri_DecompressionFailed = 0x2602
  Photuri_DecryptionFailed = 0x2603
  Photuri_NeedAuthentication = 0x2604
  Photuri_NeedAuthorization = 0x2605
  pass

"""
Represents a DHCP Message object.
"""
class MessageDHCP:
  def ack_ip(self, ip : str, server_ip : str, subnet_mask : str, mac_client : str):
    """
    Creates a DHCPACK message.

      - **ip** (str) – IP address assigned to the client.
      - **server_ip** (str) – Server IP address. It will be added to the options of the message.
      - **subnet_mask** (str) – Subnet mask. Like the server address, it will be added to the options of the message.
      - **mac_client** (str) – Hardware address of the client.
    """
    pass
  def add_lease_time(self, seconds : c_int32):
    """
    Adds to the options array the lease time specified. Used by the server in DHCPOFFER and DHCPACK messages.

      **seconds** (c_int32) – Minimum amount of time an IP address will be allocated.
    """
    pass
  def add_option(self, tag : c_uint8, data : IList[c_uint8]):
    """
    Add a generic option to the message.

      - **tag** (c_uint8) – The type of the option.
      - **data** (IList[c_uint8]) – The data of the option.
    """
    pass
  def add_option(self, tag : c_uint8, value : c_int64, size : c_uint8):
    """
    Add a generic option to the message.

      - **tag** (c_uint8) – The type of the option.
      - **value** (c_int64) – The value of the option.
      - **size** (c_uint8) – The size of the option.
    """
    pass
  def add_to_option(self, byte_array : Array[c_uint8]):
    """
    Adds the specified bytes to the options array, the bytes will be decoded as options.

      **byte_array** (Array[c_uint8]) – Bytes containing the information to add to the options array.
    """
    pass
  def capture(self, filter : Filter = None) -> MessageDHCP:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageDHCP
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageDHCP:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageDHCP
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageDHCP]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageDHCP]
    """
    pass
  def clear_options(self):
    """
    Clear the options of the message.

    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def delete_option(self, tag : c_uint8):
    """
    Delete an option from the message if it's found.

      **tag** (c_uint8) – The type of the option to delete.
    """
    pass
  def discover(self, time_out : c_int32) -> IMessageBase:
    """
    Creates a DHCPDISCOVER message and waits for a response from the DHCP server. It is possible to specify the desired IP address in order to check if it is still available.

      **time_out** (c_int32) – Max time to wait for a response to discover the message.
    :return: DHCP message sent by the server as a response to the request made.
    :rtype: IMessageBase
    """
    pass
  def discover(self, ip : str, time_out : c_int32) -> IMessageBase:
    """
    Creates a DHCPDISCOVER message and waits for a response from the DHCP server. It is possible to specify the desired IP address in order to check if it is still available.

      - **ip** (str) – (optional) IP address of the client that would like to get.
      - **time_out** (c_int32) – Max time to wait for a response to discover the message.
    :return: DHCP message sent by the server as a response to the request made.
    :rtype: IMessageBase
    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def get_option(self, tag : c_uint8) -> Array[c_uint8]:
    """
    Gets the option data specified by the tag.

      **tag** (c_uint8) – Option type.
    :return: The data of the option :code:`None` if the message doesn't have the option type.
    :rtype: Array[c_uint8]
    """
    pass
  def has_option(self, tag : c_uint8) -> c_bool:
    """
    Checks if the message has the option specified by the tag.

      **tag** (c_uint8) – Option type.
    :return: :code:`True` if the message has the option, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def offer_ip(self, ip : str, server_ip : str, subnet_mask : str, mac_client : str, timeout : c_int32) -> IMessageBase:
    """
    Creates a DHCPOFFER message and waits for a response. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **ip** (str) – IP address assigned to the client.
      - **server_ip** (str) – Server IP address. It will be added to the options of the message.
      - **subnet_mask** (str) – Subnet mask. Like the server address, it will be added to the options of the message.
      - **mac_client** (str) – Hardware address of the client.
      - **timeout** (c_int32) – Max time to wait for a response from the DHCP client
    :return: DHCP message sent by the client as a response to the offer made.
    :rtype: IMessageBase
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageDHCP:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageDHCP
    """
    pass
  def receive(self, timeout : c_int32) -> MessageDHCP:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageDHCP
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageDHCP]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageDHCP]
    """
    pass
  def request_ip(self, ip : str, timeout : c_int32) -> IMessageBase:
    """
    Creates a DHCPREQUEST message and waits for a response from the DHCP server. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **ip** (str) – IP address assigned to the client.
      - **timeout** (c_int32) – Max time to wait for a response from the DHCP client
    :return: DHCP message sent by the server as a response to the request made
    :rtype: IMessageBase
    """
    pass
  def request_ip(self, ip : str, server_ip : str, mac_client : str, time_out : c_int32) -> IMessageBase:
    """
    Creates a DHCPREQUEST message and waits for a response from the DHCP client.

      - **ip** (str) – IP address assigned to the client.
      - **server_ip** (str) – Server IP address. It will be added to the options of the message.
      - **mac_client** (str) – Hardware address of the client.
      - **time_out** (c_int32) – Max time to wait for a response to discover the message.
    :return: DHCP message sent by the server as a response to the request made
    :rtype: IMessageBase
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> MessageDHCP:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: MessageDHCP
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[MessageDHCP]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[MessageDHCP]
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageDHCP):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageDHCP) – The message object being handled.
    """
    pass
  allOptionTypes : List[c_uint8]

  assigned_ip_address : str

  capture_info : CaptureInfo

  ciaddr : str

  client_mac_address : str

  data_base : Database

  elapsed_time : c_int16

  ethernet_header : HeaderEthernet

  file : Array[c_uint8]

  flags : c_uint16

  frame_number : c_int64

  giaddr : str

  hlen : c_uint8

  hops : c_uint8

  htype : c_uint8

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  mode : mode

  network_protocol : NetworkProtocols

  op : Operation

  option_bytes : Array[c_uint8]

  payload : Array[c_uint8]

  server_name : Array[c_uint8]

  siaddr : str

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  udp_header : HeaderUDP

  vlan_tag : HeaderVlan

  xid : c_uint32


  pass

"""
Used to check the mode chosen for sending a DHCP message.
"""
class mode(Enum):

  unicast = 0x00000000
  broadcast = 0x00008000
  pass

"""
Represents an IPv4 message object.
"""
class MessageIpv4:
  def capture(self, filter : Filter = None) -> MessageIpv4:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageIpv4
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageIpv4:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageIpv4
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageIpv4]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageIpv4]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageIpv4:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageIpv4
    """
    pass
  def receive(self, timeout : c_int32) -> MessageIpv4:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageIpv4
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageIpv4]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageIpv4]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> MessageIpv4:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: MessageIpv4
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[MessageIpv4]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[MessageIpv4]
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageIpv4):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageIpv4) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  payload : Array[c_uint8]

  timestamp : decimal

  vlan_tag : HeaderVlan


  pass

"""
Represents an IPv6 message object
"""
class MessageIPv6:
  def capture(self, filter : Filter = None) -> MessageIPv6:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageIPv6
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageIPv6:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageIPv6
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageIPv6]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageIPv6]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageIPv6:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageIPv6
    """
    pass
  def receive(self, timeout : c_int32) -> MessageIPv6:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageIPv6
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageIPv6]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageIPv6]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageIPv6):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageIPv6) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  ip_header : HeaderIP

  ipv6_header : HeaderIPv6

  payload : Array[c_uint8]

  timestamp : decimal

  vlan_tag : HeaderVlan


  pass

"""
Represents a DLT (Diagnostics, Logging and Trace protocol) message object.
"""
class MessageDlt:
  def append_message(self, message : MessageDlt):
    """
    Lets the user packs several messages into one packet, each appended message will have its own header.

      **message** (MessageDlt) – The message to append
    """
    pass
  def capture(self, filter : Filter = None) -> MessageDlt:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageDlt
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageDlt:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageDlt
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageDlt]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageDlt]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_all_signals_values(self) -> dict[str, int]:
    """
    Gets a dictionary of all the signal values (name, value).

    :return: Dictionary of all signals values
    :rtype: dict[str, int]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def get_payload_interpretation(self) -> str:
    """
    Shows the interpretation of the payload.

    :return: The payload interpretation of the message.
    :rtype: str
    """
    pass
  def get_signal_value(self, name : str) -> Optional[int]:
    """
    Gets a value of a specific signal given its name.

      **name** (str) – Desired signal's name
    :return: Signal's value.
    :rtype: Optional[int]
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageDlt:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageDlt
    """
    pass
  def receive(self, timeout : c_int32) -> MessageDlt:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageDlt
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageDlt]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageDlt]
    """
    pass
  def reset_signal_value(self, signalName : str = None):
    """
    Resets the signal value to its default value. If no :code:`signalName` is specified, reset all signals.

      **signalName** (str) – the name of the signal to reset
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def set_signal_value(self, name : str, value : Optional[c_uint64]):
    """
    Sets the value of a specific signal to a specific value.

      - **name** (str) – Desired signal's name
      - **value** (Optional[c_uint64]) – Desired signal's value
    """
    pass
  def signal(self, name : str) -> SignalValue:
    """
    Gets a signal by its name.

      **name** (str) – Desired signal's name
    :return: Signal's value.
    :rtype: SignalValue
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageDlt):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageDlt) – The message object being handled.
    """
    pass
  auto_calculate : AutoCalculate

  capture_info : CaptureInfo

  data_base : Database

  ethernet_header : HeaderEthernet

  extended_header : DltExtendedHeader

  frame_number : c_int64

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  message_id : c_uint32

  messages : List[MessageDlt]

  network_protocol : NetworkProtocols

  payload : Array[c_uint8]

  standard_header : DltStandardHeader

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  udp_header : HeaderUDP

  vlan_tag : HeaderVlan


  pass

"""
The DLT Message Standard Header.
"""
class DltStandardHeader:
  ecu_id : str

  header_type : c_uint8

  is_msbf : c_bool

  length : c_uint16

  message_counter : c_uint8

  session_id : c_uint32

  standard_header_length : c_int32

  timestamp : c_float

  use_extended_header : c_bool

  version_number : c_uint8

  with_ecu_id : c_bool

  with_session_id : c_bool

  with_timestamp : c_bool


  pass

"""
The DLT Message Extended Header.
"""
class DltExtendedHeader:
  application_id : str

  arguments_number : c_uint8

  context_id : str

  message_info : c_uint8

  message_type : DltType

  message_type_info : c_uint8

  verbose : c_bool


  pass

"""
DLT Type enumeration, indicates the message type.
"""
class DltType(Enum):

  Log = 0x00
  AppTrace = 0x01
  NetworkTrace = 0x02
  Control = 0x03
  pass

"""
Represents a TLS :code:`1.2` (Transport Layer Security) message object.
"""
class MessageTls:
  def append_message(self, message : MessageTls):
    """
    Lets the user packs several messages into one packet, each appended message will have its own header.

      **message** (MessageTls) – The message to append
    """
    pass
  def capture(self, filter : Filter = None) -> MessageTls:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageTls
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageTls:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageTls
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageTls]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageTls]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageTls:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageTls
    """
    pass
  def receive(self, timeout : c_int32) -> MessageTls:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageTls
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageTls]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageTls]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageTls):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageTls) – The message object being handled.
    """
    pass
  alert : ITlsAlert

  capture_info : CaptureInfo

  content_type : TlsContentTypes

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  handshake : ITlsHandshake

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  length : c_uint16

  messages : List[MessageTls]

  network_protocol : NetworkProtocols

  payload : Array[c_uint8]

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  vlan_tag : HeaderVlan


  pass

"""
An enumeration that represents the possible TLS :code:`1.2` Content types.
"""
class TlsContentTypes(Enum):

  Alert = 0x00000015
  Handshake = 0x00000016
  pass

"""
Represents a TLS Handshake object.
"""
class ITlsHandshake:
  cipher_suites : Array[TlsCipherSuite]

  handshake_type : Optional[HandshakeTypes]

  length : Optional[c_uint16]


  pass

"""
An enumeration that represents the possible TLS :code:`1.2` Handshake types.
"""
class HandshakeTypes(Enum):

  ClientHello = 0x00000001
  ServerHello = 0x00000002
  pass

"""

"""
class TlsCipherSuite(Enum):

  TLS_NULL_WITH_NULL_NULL = 0x0000
  TLS_RSA_WITH_NULL_MD5 = 0x0001
  TLS_RSA_WITH_NULL_SHA = 0x0002
  TLS_RSA_EXPORT_WITH_RC4_40_MD5 = 0x0003
  TLS_RSA_WITH_RC4_128_MD5 = 0x0004
  TLS_RSA_WITH_RC4_128_SHA = 0x0005
  TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = 0x0006
  TLS_RSA_WITH_IDEA_CBC_SHA = 0x0007
  TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = 0x0008
  TLS_RSA_WITH_DES_CBC_SHA = 0x0009
  TLS_RSA_WITH_3DES_EDE_CBC_SHA = 0x000A
  TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = 0x000B
  TLS_DH_DSS_WITH_DES_CBC_SHA = 0x000C
  TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA = 0x000D
  TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = 0x000E
  TLS_DH_RSA_WITH_DES_CBC_SHA = 0x000F
  TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA = 0x0010
  TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 0x0011
  TLS_DHE_DSS_WITH_DES_CBC_SHA = 0x0012
  TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 0x0013
  TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 0x0014
  TLS_DHE_RSA_WITH_DES_CBC_SHA = 0x0015
  TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 0x0016
  TLS_DH_anon_EXPORT_WITH_RC4_40_MD5 = 0x0017
  TLS_DH_anon_WITH_RC4_128_MD5 = 0x0018
  TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA = 0x0019
  TLS_DH_anon_WITH_DES_CBC_SHA = 0x001A
  TLS_DH_anon_WITH_3DES_EDE_CBC_SHA = 0x001B
  TLS_KRB5_WITH_DES_CBC_SHA = 0x001E
  TLS_KRB5_WITH_3DES_EDE_CBC_SHA = 0x001F
  TLS_KRB5_WITH_RC4_128_SHA = 0x0020
  TLS_KRB5_WITH_IDEA_CBC_SHA = 0x0021
  TLS_KRB5_WITH_DES_CBC_MD5 = 0x0022
  TLS_KRB5_WITH_3DES_EDE_CBC_MD5 = 0x0023
  TLS_KRB5_WITH_RC4_128_MD5 = 0x0024
  TLS_KRB5_WITH_IDEA_CBC_MD5 = 0x0025
  TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA = 0x0026
  TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA = 0x0027
  TLS_KRB5_EXPORT_WITH_RC4_40_SHA = 0x0028
  TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5 = 0x0029
  TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5 = 0x002A
  TLS_KRB5_EXPORT_WITH_RC4_40_MD5 = 0x002B
  TLS_PSK_WITH_NULL_SHA = 0x002C
  TLS_DHE_PSK_WITH_NULL_SHA = 0x002D
  TLS_RSA_PSK_WITH_NULL_SHA = 0x002E
  TLS_RSA_WITH_AES_128_CBC_SHA = 0x002F
  TLS_DH_DSS_WITH_AES_128_CBC_SHA = 0x0030
  TLS_DH_RSA_WITH_AES_128_CBC_SHA = 0x0031
  TLS_DHE_DSS_WITH_AES_128_CBC_SHA = 0x0032
  TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 0x0033
  TLS_DH_anon_WITH_AES_128_CBC_SHA = 0x0034
  TLS_RSA_WITH_AES_256_CBC_SHA = 0x0035
  TLS_DH_DSS_WITH_AES_256_CBC_SHA = 0x0036
  TLS_DH_RSA_WITH_AES_256_CBC_SHA = 0x0037
  TLS_DHE_DSS_WITH_AES_256_CBC_SHA = 0x0038
  TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 0x0039
  TLS_DH_anon_WITH_AES_256_CBC_SHA = 0x003A
  TLS_RSA_WITH_NULL_SHA256 = 0x003B
  TLS_RSA_WITH_AES_128_CBC_SHA256 = 0x003C
  TLS_RSA_WITH_AES_256_CBC_SHA256 = 0x003D
  TLS_DH_DSS_WITH_AES_128_CBC_SHA256 = 0x003E
  TLS_DH_RSA_WITH_AES_128_CBC_SHA256 = 0x003F
  TLS_DHE_DSS_WITH_AES_128_CBC_SHA256 = 0x0040
  TLS_RSA_WITH_CAMELLIA_128_CBC_SHA = 0x0041
  TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = 0x0042
  TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = 0x0043
  TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = 0x0044
  TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = 0x0045
  TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA = 0x0046
  TLS_DHE_RSA_WITH_AES_128_CBC_SHA256 = 0x0067
  TLS_DH_DSS_WITH_AES_256_CBC_SHA256 = 0x0068
  TLS_DH_RSA_WITH_AES_256_CBC_SHA256 = 0x0069
  TLS_DHE_DSS_WITH_AES_256_CBC_SHA256 = 0x006A
  TLS_DHE_RSA_WITH_AES_256_CBC_SHA256 = 0x006B
  TLS_DH_anon_WITH_AES_128_CBC_SHA256 = 0x006C
  TLS_DH_anon_WITH_AES_256_CBC_SHA256 = 0x006D
  TLS_RSA_WITH_CAMELLIA_256_CBC_SHA = 0x0084
  TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = 0x0085
  TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = 0x0086
  TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = 0x0087
  TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = 0x0088
  TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA = 0x0089
  TLS_PSK_WITH_RC4_128_SHA = 0x008A
  TLS_PSK_WITH_3DES_EDE_CBC_SHA = 0x008B
  TLS_PSK_WITH_AES_128_CBC_SHA = 0x008C
  TLS_PSK_WITH_AES_256_CBC_SHA = 0x008D
  TLS_DHE_PSK_WITH_RC4_128_SHA = 0x008E
  TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA = 0x008F
  TLS_DHE_PSK_WITH_AES_128_CBC_SHA = 0x0090
  TLS_DHE_PSK_WITH_AES_256_CBC_SHA = 0x0091
  TLS_RSA_PSK_WITH_RC4_128_SHA = 0x0092
  TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA = 0x0093
  TLS_RSA_PSK_WITH_AES_128_CBC_SHA = 0x0094
  TLS_RSA_PSK_WITH_AES_256_CBC_SHA = 0x0095
  TLS_RSA_WITH_SEED_CBC_SHA = 0x0096
  TLS_DH_DSS_WITH_SEED_CBC_SHA = 0x0097
  TLS_DH_RSA_WITH_SEED_CBC_SHA = 0x0098
  TLS_DHE_DSS_WITH_SEED_CBC_SHA = 0x0099
  TLS_DHE_RSA_WITH_SEED_CBC_SHA = 0x009A
  TLS_DH_anon_WITH_SEED_CBC_SHA = 0x009B
  TLS_RSA_WITH_AES_128_GCM_SHA256 = 0x009C
  TLS_RSA_WITH_AES_256_GCM_SHA384 = 0x009D
  TLS_DHE_RSA_WITH_AES_128_GCM_SHA256 = 0x009E
  TLS_DHE_RSA_WITH_AES_256_GCM_SHA384 = 0x009F
  TLS_DH_RSA_WITH_AES_128_GCM_SHA256 = 0x00A0
  TLS_DH_RSA_WITH_AES_256_GCM_SHA384 = 0x00A1
  TLS_DHE_DSS_WITH_AES_128_GCM_SHA256 = 0x00A2
  TLS_DHE_DSS_WITH_AES_256_GCM_SHA384 = 0x00A3
  TLS_DH_DSS_WITH_AES_128_GCM_SHA256 = 0x00A4
  TLS_DH_DSS_WITH_AES_256_GCM_SHA384 = 0x00A5
  TLS_DH_anon_WITH_AES_128_GCM_SHA256 = 0x00A6
  TLS_DH_anon_WITH_AES_256_GCM_SHA384 = 0x00A7
  TLS_PSK_WITH_AES_128_GCM_SHA256 = 0x00A8
  TLS_PSK_WITH_AES_256_GCM_SHA384 = 0x00A9
  TLS_DHE_PSK_WITH_AES_128_GCM_SHA256 = 0x00AA
  TLS_DHE_PSK_WITH_AES_256_GCM_SHA384 = 0x00AB
  TLS_RSA_PSK_WITH_AES_128_GCM_SHA256 = 0x00AC
  TLS_RSA_PSK_WITH_AES_256_GCM_SHA384 = 0x00AD
  TLS_PSK_WITH_AES_128_CBC_SHA256 = 0x00AE
  TLS_PSK_WITH_AES_256_CBC_SHA384 = 0x00AF
  TLS_PSK_WITH_NULL_SHA256 = 0x00B0
  TLS_PSK_WITH_NULL_SHA384 = 0x00B1
  TLS_DHE_PSK_WITH_AES_128_CBC_SHA256 = 0x00B2
  TLS_DHE_PSK_WITH_AES_256_CBC_SHA384 = 0x00B3
  TLS_DHE_PSK_WITH_NULL_SHA256 = 0x00B4
  TLS_DHE_PSK_WITH_NULL_SHA384 = 0x00B5
  TLS_RSA_PSK_WITH_AES_128_CBC_SHA256 = 0x00B6
  TLS_RSA_PSK_WITH_AES_256_CBC_SHA384 = 0x00B7
  TLS_RSA_PSK_WITH_NULL_SHA256 = 0x00B8
  TLS_RSA_PSK_WITH_NULL_SHA384 = 0x00B9
  TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 0x00BA
  TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 0x00BB
  TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 0x00BC
  TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 0x00BD
  TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 0x00BE
  TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256 = 0x00BF
  TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 0x00C0
  TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 0x00C1
  TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 0x00C2
  TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 0x00C3
  TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 0x00C4
  TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256 = 0x00C5
  TLS_AES_128_GCM_SHA256 = 0x1301
  TLS_AES_256_GCM_SHA384 = 0x1302
  TLS_CHACHA20_POLY1305_SHA256 = 0x1303
  TLS_AES_128_CCM_SHA256 = 0x1304
  TLS_AES_128_CCM_8_SHA256 = 0x1305
  TLS_ECDH_ECDSA_WITH_NULL_SHA = 0xC001
  TLS_ECDH_ECDSA_WITH_RC4_128_SHA = 0xC002
  TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA = 0xC003
  TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA = 0xC004
  TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA = 0xC005
  TLS_ECDHE_ECDSA_WITH_NULL_SHA = 0xC006
  TLS_ECDHE_ECDSA_WITH_RC4_128_SHA = 0xC007
  TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA = 0xC008
  TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 0xC009
  TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 0xC00A
  TLS_ECDH_RSA_WITH_NULL_SHA = 0xC00B
  TLS_ECDH_RSA_WITH_RC4_128_SHA = 0xC00C
  TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA = 0xC00D
  TLS_ECDH_RSA_WITH_AES_128_CBC_SHA = 0xC00E
  TLS_ECDH_RSA_WITH_AES_256_CBC_SHA = 0xC00F
  TLS_ECDHE_RSA_WITH_NULL_SHA = 0xC010
  TLS_ECDHE_RSA_WITH_RC4_128_SHA = 0xC011
  TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA = 0xC012
  TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = 0xC013
  TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = 0xC014
  TLS_ECDH_anon_WITH_NULL_SHA = 0xC015
  TLS_ECDH_anon_WITH_RC4_128_SHA = 0xC016
  TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA = 0xC017
  TLS_ECDH_anon_WITH_AES_128_CBC_SHA = 0xC018
  TLS_ECDH_anon_WITH_AES_256_CBC_SHA = 0xC019
  TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA = 0xC01A
  TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = 0xC01B
  TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = 0xC01C
  TLS_SRP_SHA_WITH_AES_128_CBC_SHA = 0xC01D
  TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = 0xC01E
  TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = 0xC01F
  TLS_SRP_SHA_WITH_AES_256_CBC_SHA = 0xC020
  TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = 0xC021
  TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = 0xC022
  TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 = 0xC023
  TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 = 0xC024
  TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256 = 0xC025
  TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384 = 0xC026
  TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = 0xC027
  TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = 0xC028
  TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256 = 0xC029
  TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384 = 0xC02A
  TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 0xC02B
  TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 0xC02C
  TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = 0xC02D
  TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = 0xC02E
  TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 0xC02F
  TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 0xC030
  TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256 = 0xC031
  TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384 = 0xC032
  TLS_ECDHE_PSK_WITH_RC4_128_SHA = 0xC033
  TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = 0xC034
  TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA = 0xC035
  TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA = 0xC036
  TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = 0xC037
  TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = 0xC038
  TLS_ECDHE_PSK_WITH_NULL_SHA = 0xC039
  TLS_ECDHE_PSK_WITH_NULL_SHA256 = 0xC03A
  TLS_ECDHE_PSK_WITH_NULL_SHA384 = 0xC03B
  TLS_RSA_WITH_ARIA_128_CBC_SHA256 = 0xC03C
  TLS_RSA_WITH_ARIA_256_CBC_SHA384 = 0xC03D
  TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256 = 0xC03E
  TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384 = 0xC03F
  TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256 = 0xC040
  TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384 = 0xC041
  TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256 = 0xC042
  TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384 = 0xC043
  TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256 = 0xC044
  TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384 = 0xC045
  TLS_DH_anon_WITH_ARIA_128_CBC_SHA256 = 0xC046
  TLS_DH_anon_WITH_ARIA_256_CBC_SHA384 = 0xC047
  TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256 = 0xC048
  TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384 = 0xC049
  TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256 = 0xC04A
  TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384 = 0xC04B
  TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256 = 0xC04C
  TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384 = 0xC04D
  TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256 = 0xC04E
  TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384 = 0xC04F
  TLS_RSA_WITH_ARIA_128_GCM_SHA256 = 0xC050
  TLS_RSA_WITH_ARIA_256_GCM_SHA384 = 0xC051
  TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = 0xC052
  TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = 0xC053
  TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256 = 0xC054
  TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384 = 0xC055
  TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = 0xC056
  TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = 0xC057
  TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256 = 0xC058
  TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384 = 0xC059
  TLS_DH_anon_WITH_ARIA_128_GCM_SHA256 = 0xC05A
  TLS_DH_anon_WITH_ARIA_256_GCM_SHA384 = 0xC05B
  TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = 0xC05C
  TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = 0xC05D
  TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = 0xC05E
  TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = 0xC05F
  TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = 0xC060
  TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = 0xC061
  TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = 0xC062
  TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = 0xC063
  TLS_PSK_WITH_ARIA_128_CBC_SHA256 = 0xC064
  TLS_PSK_WITH_ARIA_256_CBC_SHA384 = 0xC065
  TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256 = 0xC066
  TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384 = 0xC067
  TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256 = 0xC068
  TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384 = 0xC069
  TLS_PSK_WITH_ARIA_128_GCM_SHA256 = 0xC06A
  TLS_PSK_WITH_ARIA_256_GCM_SHA384 = 0xC06B
  TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = 0xC06C
  TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = 0xC06D
  TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = 0xC06E
  TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = 0xC06F
  TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256 = 0xC070
  TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384 = 0xC071
  TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 0xC072
  TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 0xC073
  TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 0xC074
  TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 0xC075
  TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 0xC076
  TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 0xC077
  TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 0xC078
  TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 0xC079
  TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 0xC07A
  TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 0xC07B
  TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 0xC07C
  TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 0xC07D
  TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 0xC07E
  TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 0xC07F
  TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256 = 0xC080
  TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384 = 0xC081
  TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256 = 0xC082
  TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384 = 0xC083
  TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256 = 0xC084
  TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384 = 0xC085
  TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256 = 0xC086
  TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384 = 0xC087
  TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256 = 0xC088
  TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384 = 0xC089
  TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 0xC08A
  TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 0xC08B
  TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 0xC08C
  TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 0xC08D
  TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256 = 0xC08E
  TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384 = 0xC08F
  TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256 = 0xC090
  TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384 = 0xC091
  TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256 = 0xC092
  TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384 = 0xC093
  TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 0xC094
  TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 0xC095
  TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 0xC096
  TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 0xC097
  TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 0xC098
  TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 0xC099
  TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 0xC09A
  TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 0xC09B
  TLS_RSA_WITH_AES_128_CCM = 0xC09C
  TLS_RSA_WITH_AES_256_CCM = 0xC09D
  TLS_DHE_RSA_WITH_AES_128_CCM = 0xC09E
  TLS_DHE_RSA_WITH_AES_256_CCM = 0xC09F
  TLS_RSA_WITH_AES_128_CCM_8 = 0xC0A0
  TLS_RSA_WITH_AES_256_CCM_8 = 0xC0A1
  TLS_DHE_RSA_WITH_AES_128_CCM_8 = 0xC0A2
  TLS_DHE_RSA_WITH_AES_256_CCM_8 = 0xC0A3
  TLS_PSK_WITH_AES_128_CCM = 0xC0A4
  TLS_PSK_WITH_AES_256_CCM = 0xC0A5
  TLS_DHE_PSK_WITH_AES_128_CCM = 0xC0A6
  TLS_DHE_PSK_WITH_AES_256_CCM = 0xC0A7
  TLS_PSK_WITH_AES_128_CCM_8 = 0xC0A8
  TLS_PSK_WITH_AES_256_CCM_8 = 0xC0A9
  TLS_PSK_DHE_WITH_AES_128_CCM_8 = 0xC0AA
  TLS_PSK_DHE_WITH_AES_256_CCM_8 = 0xC0AB
  TLS_ECDHE_ECDSA_WITH_AES_128_CCM = 0xC0AC
  TLS_ECDHE_ECDSA_WITH_AES_256_CCM = 0xC0AD
  TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8 = 0xC0AE
  TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8 = 0xC0AF
  TLS_ECCPWD_WITH_AES_128_GCM_SHA256 = 0xC0B0
  TLS_ECCPWD_WITH_AES_256_GCM_SHA384 = 0xC0B1
  TLS_ECCPWD_WITH_AES_128_CCM_SHA256 = 0xC0B2
  TLS_ECCPWD_WITH_AES_256_CCM_SHA384 = 0xC0B3
  TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 0xCCA8
  TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = 0xCCA9
  TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 0xCCAA
  TLS_PSK_WITH_CHACHA20_POLY1305_SHA256 = 0xCCAB
  TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = 0xCCAC
  TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = 0xCCAD
  TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256 = 0xCCAE
  TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256 = 0xD001
  TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384 = 0xD002
  TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256 = 0xD003
  TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256 = 0xD005
  pass

"""
Represents a TLS Alert object.
"""
class ITlsAlert:
  description : Optional[AlertDescription]

  level : Optional[AlertLevels]


  pass

"""
An enumeration that represents the possible TLS :code:`1.2` Alert levels.
"""
class AlertLevels(Enum):

  Warning = 0x00000001
  Fatal = 0x00000002
  pass

"""
An enumeration that represents the possible TLS :code:`1.2` Alert descriptions.
"""
class AlertDescription(Enum):

  CloseNotify = 0x00000000
  UnexpectedMessage = 0x0000000A
  BadRecordMac = 0x00000014
  DecryptionFailedReserved = 0x00000015
  RecordOverflow = 0x00000016
  DecompressionFailure = 0x0000001E
  HandshakeFailure = 0x00000028
  NoCertificateReserved = 0x00000029
  BadCertificate = 0x0000002A
  UnsupportedCertificate = 0x0000002B
  CertificateRevoked = 0x0000002C
  CertificateExpired = 0x0000002D
  CertificateUnknown = 0x0000002E
  IllegalParameter = 0x0000002F
  UnknownCa = 0x00000030
  AccessDenied = 0x00000031
  DecodeError = 0x00000032
  DecryptError = 0x00000033
  ExportRestrictionReserved = 0x0000003C
  ProtocolVersion = 0x00000046
  InsufficientSecurity = 0x00000047
  InternalError = 0x00000050
  UserCanceled = 0x0000005A
  NoRenegotiation = 0x00000064
  UnsupportedExtension = 0x0000006E
  pass

"""
Represents an ICMPv6 message object.
"""
class MessageICMPv6:
  def capture(self, filter : Filter = None) -> MessageICMPv6:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageICMPv6
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageICMPv6:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageICMPv6
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageICMPv6]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageICMPv6]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def create_response(self) -> MessageICMPv6:
    """
    Creates neighbor advertisement message.

    :return: Neighbor advertisement message
    :rtype: MessageICMPv6
    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def ping(self, ip_address : str) -> IMessageBase:
    """
    Creates an ICMP ping request message and waits for a response. for the response. Return value: ICMP ping request message received as response, if any.

      **ip_address** (str) – IP address of the target device.
    :return: ICMP message got as a response to the ping sent, if there is any.
    :rtype: IMessageBase
    """
    pass
  def ping(self, ip_address : str, timeout : c_int32) -> IMessageBase:
    """
    Creates an ICMP ping request message and waits for a response. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **ip_address** (str) – IP address of the target device.
      - **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response.
    :return: ICMP message got as a response to the ping sent, if there is any.
    :rtype: IMessageBase
    """
    pass
  def receive(self) -> MessageICMPv6:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageICMPv6
    """
    pass
  def receive(self, timeout : c_int32) -> MessageICMPv6:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageICMPv6
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageICMPv6]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageICMPv6]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> MessageICMPv6:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: MessageICMPv6
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[MessageICMPv6]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[MessageICMPv6]
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def solicit(self, ip : str):
    """
    Makes current message a neighbor solicitation message

      **ip** (str) – ip address of the neighbor
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageICMPv6):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageICMPv6) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  checksum : Optional[c_uint16]

  code : c_uint8

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  identifier : c_uint16

  ip_header : HeaderIP

  ipv6_header : HeaderIPv6

  payload : Array[c_uint8]

  sequence : c_uint16

  target_address : str

  target_link_layer_address : str

  timestamp : decimal

  type : ICMPv6_TYPE

  vlan_tag : HeaderVlan


  pass

"""
An enumeration that represents the different ICMPv6 message types.
"""
class ICMPv6_TYPE(Enum):

  Zero = 0x00000000
  DestinationUnreachable = 0x00000001
  PacketTooBig = 0x00000002
  TimeExceeded = 0x00000003
  ParameterProblem = 0x00000004
  PrivateExperimentation1 = 0x00000064
  PrivateExperimentation2 = 0x00000065
  ReservedForExpansion1 = 0x0000007F
  EchoRequest = 0x00000080
  EchoReply = 0x00000081
  RouterSolicitation = 0x00000085
  NeighborSolicitation = 0x00000087
  NeighborAdvertisement = 0x00000088
  PrivateExperimentation3 = 0x000000C8
  PrivateExperimentation4 = 0x000000C9
  ReservedForExpansion2 = 0x000000FF
  Unassigned1 = 0x00001388
  pass

"""
Represents an SRP (Secure Remote Password protocol) message object.
"""
class MessageSRP:
  def add_sub_message(self, attributeType : c_uint8) -> ISRPSubMessage:
    """
    Creates and adds a sub message to the list of sub messages given its type.

      **attributeType** (c_uint8) – The sub message attribute type.
    :return: Created sub message.
    :rtype: ISRPSubMessage
    """
    pass
  def capture(self, filter : Filter = None) -> MessageSRP:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageSRP
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageSRP:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageSRP
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageSRP]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageSRP]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageSRP:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageSRP
    """
    pass
  def receive(self, timeout : c_int32) -> MessageSRP:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageSRP
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageSRP]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageSRP]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageSRP):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageSRP) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  messages : tuple[ISRPSubMessage]

  payload : Array[c_uint8]

  protocol_version : c_uint8

  timestamp : decimal

  vlan_tag : HeaderVlan


  pass

"""
Represents an SRP protocol sub message.
"""
class ISRPSubMessage:
  def add_vector_attribute(self, leave_all_event : c_uint8, firstValue : Array[c_uint8], vectorArray : Array[c_uint8]) -> ISRPVectorAttribute:
    """
    Creates and adds an attribute (SRPVectorAttribute) to the list of attributes given its parameters.

      - **leave_all_event** (c_uint8) – The leave all event parameter.
      - **firstValue** (Array[c_uint8]) – The first value parameter.
      - **vectorArray** (Array[c_uint8]) – The vector array parameter.
    :return: Attribute created.
    :rtype: ISRPVectorAttribute
    """
    pass
  attribute_length : c_uint8

  attribute_list : tuple[ISRPVectorAttribute]

  attribute_list_length : c_uint16

  attribute_type : c_uint8

  attribute_type_string : str

  parent_srp_message : MessageSRP


  pass

"""
Represents an SRP Vector attribute.
"""
class ISRPVectorAttribute:
  first_value : Array[c_uint8]

  leave_all_event : c_uint8

  parent_sub_srp_message : ISRPSubMessage

  vector : Array[c_uint8]


  pass

"""
Represents a HTTP Message object
"""
class MessageHttp:
  def capture(self, filter : Filter = None) -> MessageHttp:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageHttp
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> MessageHttp:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: MessageHttp
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[MessageHttp]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[MessageHttp]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def connect(self, timeout : c_float = 1) -> c_bool:
    """
    Opens a TCP connection.

      **timeout** (c_float) – Number of seconds to wait for connection to establish before aborting.
    :return: for connect() returns :code:`True` if there’s a connection.
    :rtype: c_bool
    """
    pass
  def disconnect(self, timeout : c_float = 0):
    """
    Closes the TCP connection opened with connect.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> MessageHttp:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: MessageHttp
    """
    pass
  def receive(self, timeout : c_int32) -> MessageHttp:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: MessageHttp
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[MessageHttp]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[MessageHttp]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> MessageHttp:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: MessageHttp
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[MessageHttp]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[MessageHttp]
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_listener(self):
    """
    Starts listening for TCP clients through the receiver network adapter.

    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_listener(self, timeout : c_float = 0):
    """
    Stops listening for TCP clients through the receiver network adapter.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : MessageHttp):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (MessageHttp) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  connected : c_bool

  data_base : Database

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  headers : dict[str, str]

  http_protocol : str

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  method : str

  network_protocol : NetworkProtocols

  payload : Array[c_uint8]

  status_code : Optional[c_int32]

  status_description : str

  tcp_header : HeaderTCP

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  uri : str

  vlan_tag : HeaderVlan


  pass

"""
Represents a DO/IP message object.
"""
class MessageDoIP:
  def capture(self, filter : Filter = None) -> IMessageDiagBasic:
    """
    Matches any message with the same protocol.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: Listens to the bus until a message is received and returns this first message
    :rtype: IMessageDiagBasic
    """
    pass
  def capture(self, timeout : c_int32, filter : Filter = None) -> IMessageDiagBasic:
    """
    Waits for the first message having the same protocol that the sent message without verify the IP address and the port between send and respond message and return it. A timeout is specified to guarantee that the script can continue if no message is captured in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: First message captured from the bus or :code:`None` in case no message is received.
    :rtype: IMessageDiagBasic
    """
    pass
  def capture_list(self, timeout : c_int32, filter : Filter = None) -> tuple[IMessageDiagBasic]:
    """
    Waits for any response having the same protocol that the sent message without verify the IP address and the port between send and respond message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      - **timeout** (c_int32) – Max time in milliseconds to wait for the response.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    :return: List of messages captured from the bus during a given period of time.
    :rtype: tuple[IMessageDiagBasic]
    """
    pass
  def close_writer(self):
    """
    Closes the file previously created with :code:`open_writer(file)`.

    """
    pass
  def connect(self, timeout : c_float = 1) -> c_bool:
    """
    Opens a TCP connection.

      **timeout** (c_float) – Number of seconds to wait for connection to establish before aborting.
    :return: for connect() returns :code:`True` if there’s a connection.
    :rtype: c_bool
    """
    pass
  def disconnect(self, timeout : c_float = 0):
    """
    Closes the TCP connection opened with connect.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def get_all_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the whole message from Ethernet layer.

    :return: Array of bytes representing the message from Ethernet layer.
    :rtype: Array[c_uint8]
    """
    pass
  def get_bytes(self) -> Array[c_uint8]:
    """
    Gets the content of the payload.

    :return: Array of bytes representing the payload of the message.
    :rtype: Array[c_uint8]
    """
    pass
  def get_hex_bytes(self) -> str:
    """
    Converts the payload of the message from decimal to hex and outputs it to a string of bytes.

    :return: Payload of message in hex bytes.
    :rtype: str
    """
    pass
  def hex_view(self) -> str:
    """
    Allows to visualize messages in hexadecimal format.

    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def hex_view(self, nb_bytes_per_line : c_int32) -> str:
    """
    Allows to visualize messages in hexadecimal format.

      **nb_bytes_per_line** (c_int32) – (optional) number of bytes per line.
    :return: Hexadecimal representation of the whole message.
    :rtype: str
    """
    pass
  def is_segmented(self) -> c_bool:
    """
    Checks if the message is segmented.

    :return: :code:`True` if the message is segmented. :code:`False` if not
    :rtype: c_bool
    """
    pass
  def open_writer(self, file : str, fileFormat : Optional[FILEFORMAT] = None):
    """
    Creates a PCAP or PCAPNG file for writing the received messages. If the file already exists, it will be overwritten (old file data will be lost). Use the :code:`store()` method to record received messages into the file.

      - **file** (str) – Absolute path of the file where the messages will be stored
      - **fileFormat** (Optional[FILEFORMAT]) – Obsolete, you don't need to specify this argument anymore
    """
    pass
  def receive(self) -> IMessageDiagBasic:
    """
    Matches a response for the used message.

    :return: Listens to the bus until a message is received and returns this first message
    :rtype: IMessageDiagBasic
    """
    pass
  def receive(self, timeout : c_int32) -> IMessageDiagBasic:
    """
    Waits for the first response having the IP address destination equals to the IP address source of the sent message and return it. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: First message received from the bus or :code:`None` in case no message is received.
    :rtype: IMessageDiagBasic
    """
    pass
  def receive_list(self, timeout : c_int32) -> tuple[IMessageDiagBasic]:
    """
    Waits for any response having the IP address destination equals to the IP address source of sent message and return them all as a list. A timeout is specified to guarantee that the script can continue if no message is received in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages received from the bus during a given period of time.
    :rtype: tuple[IMessageDiagBasic]
    """
    pass
  def send(self) -> c_bool:
    """
    Sends the message (the one used to call the method) through the Ethernet bus.

    :return: Returns :code:`True` if the message is sent successfully. Otherwise, an exception will be thrown.
    :rtype: c_bool
    """
    pass
  def send_receive(self, timeout : c_int32 = 1000) -> IMessageDiagBasic:
    """
    Sends the message (the one used to call the method) through the Ethernet bus and waits for a possible response, i.e. a message from the target address to our own address. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – (optional) Max time in milliseconds to wait for the response. Default :code:`1` second
    :return: First message detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: IMessageDiagBasic
    """
    pass
  def send_receive_list(self, timeout : c_int32) -> tuple[IMessageDiagBasic]:
    """
    Sends the message through the Ethernet bus, listens for a while and returns a list with all the messages captured in that period. It is possible to specify a timeout to guarantee that the script can continue if no response is detected in a certain time interval.

      **timeout** (c_int32) – Max time in milliseconds to wait for the response.
    :return: List of messages detected from the destination address to our address. This can be the response to the message sent but it is not :code:`100%` guaranteed; additional traffic can be captured before this expected response and thus returned.
    :rtype: tuple[IMessageDiagBasic]
    """
    pass
  def set_all_bytes(self, all_packet : Array[c_uint8]) -> c_bool:
    """
    Sets the content of the whole message from Ethernet layer, byte per byte.

      **all_packet** (Array[c_uint8]) – All packet to set.
    :return: :code:`True` if the operation was successful, :code:`False` otherwise.
    :rtype: c_bool
    """
    pass
  def set_bytes(self, payload : Array[c_uint8]):
    """
    Sets the content of the payload, byte per byte.

      **payload** (Array[c_uint8]) – Array of bytes to set.
    """
    pass
  def start_capture(self, filter : Filter = None):
    """
    Used for online capture(capturing network traffic from an adapter). Used with callback function(on_message_received()) and stop_capture() method.

      **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_capture(self, file : str, wait_eof : c_bool, filter : Filter = None):
    """
    Used for offline capture(reading packets from pcap or asc file). Used with callback function(on_message_received()) and stop_capture() method.

      - **file** (str) – The trace file from where the messages will be read.
      - **wait_eof** (c_bool) – If :code:`True` the function would block until all frames in the file are read. If :code:`False` the function would read the frames in the background.
      - **filter** (Filter) – Filter to use to narrow down packets to capture
    """
    pass
  def start_listener(self):
    """
    Starts listening for TCP clients through the receiver network adapter.

    """
    pass
  def start_responding_machine(self):
    """
    With this function, it is possible to simulate an ECU. It captures packets and, for every received message, it calls is_request callback. If it returns :code:`True`, then it calls the make_reply callback

    """
    pass
  def stop_capture(self):
    """
    Stops capturing Ethernet messages, either directly from the bus or from a trace file (depending on the version used to start the capture).

    """
    pass
  def stop_listener(self, timeout : c_float = 0):
    """
    Stops listening for TCP clients through the receiver network adapter.

      **timeout** (c_float) – Number of seconds to wait for connection to close before aborting. If timeout is :code:`0` (default) the connection would be closed with a TCP RST instead of normal TCP FIN, this prevents the connection from remaining stuck in the TIME_WAIT state for two minutes.
    """
    pass
  def stop_responding_machine(self):
    """
    Stops the responding machine activated with start_responding_machine.

    """
    pass
  def store(self, file : str):
    """
    Writes the message into the trace file.

      **file** (str) – Path of the file where the messages will be stored.
    """
    pass
  def store(self):
    """
    Writes the message into the trace file opened with :code:`open_writer(file)`.

    """
    pass
  def tree_view(self) -> str:
    """
    Gives the tree view of the message.

    :return: Tree view representation of the message.
    :rtype: str
    """
    pass
  def on_capture_start(self):
    """
    The event is triggered when the capture of Ethernet messages is started. See start_capture .

    """
    pass
  def on_capture_stop(self):
    """
    The event is triggered when the capture of Ethernet messages is stopped. See stop_capture .

    """
    pass
  def on_message_received(self, message : IMessageDiagBasic):
    """
    Event is triggered every time a message is read from the Ethernet bus or a trace file. See start_capture.

      **message** (IMessageDiagBasic) – The message object being handled.
    """
    pass
  capture_info : CaptureInfo

  connected : c_bool

  data_base : Database

  doip_ack : Optional[c_uint8]

  doip_nack : Optional[c_uint8]

  ethernet_header : HeaderEthernet

  frame_number : c_int64

  inverse_protocol_version : Optional[c_uint8]

  ip_header : HeaderIP

  ipv4_header : HeaderIPv4

  ipv6_header : HeaderIPv6

  iso_tp : IsoTp

  network_protocol : NetworkProtocols

  payload : Array[c_uint8]

  payload_length : Optional[c_uint32]

  payload_type : c_uint16

  protocol_version : c_uint8

  source_address : c_uint16

  target_address : c_uint16

  tcp_header : HeaderTCP

  timestamp : decimal

  transport_header : HeaderTransport

  transport_protocol : Protocols

  udp_header : HeaderUDP

  uds : Uds

  vlan_tag : HeaderVlan


  pass

"""
In ANDi, it is possible to run scripts in parallel.
            The object *script* provides different methods that allow to start/stop the execution of other scripts dynamically.
            A name of a script in the current project must be used to call these methods. In order to refer to the self-script, it is possible to use the reserved word **current_script**.
::
  
              script_1.start() # start the execution of a script present in the project
              print(current_script.get_file_path()) # return the path of the current script
"""
class Script:
  def add_log_path(self, log_type : LOG_TYPE, path : str):
    """
    Add the log path for the script.

      - **log_type** (LOG_TYPE) – Type of log
      - **path** (str) – Path of the log.
    """
    pass
  def get_file_path(self) -> str:
    """
    Gets the full path of the script file. The script should be saved before using the reset method in order to print the path. If it's not saved the file path is an empty string.

    :return: The full path of the script file
    :rtype: str
    """
    pass
  def skip(self):
    """
    Marks the script as "skipped" and stops its execution

    """
    pass
  def start(self):
    """
    Starts the execution of the script.

    """
    pass
  def start(self, timeout : c_int32):
    """
    Executes the script. If the timeout is given, the started script will be stopped automatically after this time.

      **timeout** (c_int32) – (optional) maximum time in the started script will be executed.
    """
    pass
  def stop(self):
    """
    Stops the execution of the script.

    """
    pass
  def on_script_stopped(self, script : Node, state : NODESTATE):
    """
    Event triggered every time the execution of the script is stopped.
::
  
              def when_script_stop(script, node_state):
                  if node_state == NODESTATE.STOPPED:
                      print("script stoped manually")
                  stop_computing()
              current_script.on_script_stopped += when_script_stop
              start_computing()

      - **script** (Node) – Same script object which called the event
      - **state** (NODESTATE) – states the current script indicating why it has stopped
    """
    pass

  pass

"""
An enumeration that represents the possible log types, either a log or pcap file.
"""
class LOG_TYPE(Enum):

  logfile = 0x00000000
  pcap = 0x00000001
  pass

"""
Used to check current execution state of a script.
"""
class NODESTATE(Enum):

  CREATED = 0x00000000
  RUNNING = 0x00000001
  TERMINATED = 0x00000002
  BLOCKED = 0x00000003
  STOPPED = 0x00000004
  SUCCESS = 0x00000005
  FAIL = 0x00000006
  ERROR = 0x00000007
  SKIPPED = 0x00000008
  ABORTED = 0x00000008
  pass

"""
Represents a graphical panel project object.
"""
class Panel:
  def start(self):
    """
    Starts the panel.

    """
    pass
  def stop(self):
    """
    Stops the panel.

    """
    pass
  def on_panel_closed(self, sender : object, e : PanelFormClosedEventArgs):
    """
    Event is triggered when panel is closed

      - **sender** (object) – The source of the event.
      - **e** (PanelFormClosedEventArgs) – An object that contains the event data.
    """
    pass
  is_running : c_bool

  name : str


  pass

"""
Represents the event arguments that gets passed to the on_panel_closed event handler.
"""
class PanelFormClosedEventArgs:

  pass
