# akeyless-kfm-api
KFM manages and stores key fragments. The core operations of each KFM instance are as follows: Creating secure random encryption keys which will be used as a master key fragment. Managing data storage for key fragments. Performing a key fragment derivation function, which generates a derived fragment from the original key fragment.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.4
- Package version: 0.0.6
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.akeyless-security.com](https://www.akeyless-security.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import akeyless_kfm_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import akeyless_kfm_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import akeyless_kfm_api
from akeyless_kfm_api.rest import ApiException
from pprint import pprint
# create an instance of the API class
api_instance = akeyless_kfm_api.DefaultApi()
akeyless_kfm_user_creds = 'akeyless_kfm_user_creds_example' # str | Temporary credentials for accessing the endpoint
akeyless_kfm_operation_creds = 'akeyless_kfm_operation_creds_example' # str | Temporary credentials for performing the operation
derivation_data = 'derivation_data_example' # str | The derivation data to be used for the fragment derivation operation
double_derivation = true # bool | Indicate if perform a double derivation (optional)

try:
    # Returns a derived fragment from the origin fragment via the supplied derivation data.
    api_response = api_instance.derive_fragment(akeyless_kfm_user_creds, akeyless_kfm_operation_creds, derivation_data, double_derivation=double_derivation)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->derive_fragment: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://$HOST*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**derive_fragment**](docs/DefaultApi.md#derive_fragment) | **POST** /derive-fragment | Returns a derived fragment from the origin fragment via the supplied derivation data.
*DefaultApi* | [**generate_aes_key_fragment**](docs/DefaultApi.md#generate_aes_key_fragment) | **POST** /generate-aes-key-fragment | Generate a new key fragment.
*DefaultApi* | [**get_fragment_details**](docs/DefaultApi.md#get_fragment_details) | **POST** /get-fragment-details | 
*DefaultApi* | [**get_status**](docs/DefaultApi.md#get_status) | **GET** /status | 
*DefaultApi* | [**get_time**](docs/DefaultApi.md#get_time) | **GET** /time | 
*DefaultApi* | [**rsa_fragment_decrypt**](docs/DefaultApi.md#rsa_fragment_decrypt) | **POST** /rsa-fragment-decrypt | Returns a fragmented decryption result on an RSA fragment.
*DefaultApi* | [**upload_rsa_fragment**](docs/DefaultApi.md#upload_rsa_fragment) | **POST** /upload-rsa-fragment | 


## Documentation For Models

 - [Algorithm](docs/Algorithm.md)
 - [AuthStatusReplyObj](docs/AuthStatusReplyObj.md)
 - [AzureADAccessRole](docs/AzureADAccessRole.md)
 - [CreateAccountCredsParams](docs/CreateAccountCredsParams.md)
 - [CreateAccountReplyObj](docs/CreateAccountReplyObj.md)
 - [CreatePolicyReplyObj](docs/CreatePolicyReplyObj.md)
 - [CreateUserReplyObj](docs/CreateUserReplyObj.md)
 - [CredentialsReplyObj](docs/CredentialsReplyObj.md)
 - [DerivationCredsReplyObj](docs/DerivationCredsReplyObj.md)
 - [DerivedFragmentReplyObj](docs/DerivedFragmentReplyObj.md)
 - [ErrorReplyObj](docs/ErrorReplyObj.md)
 - [FragmentType](docs/FragmentType.md)
 - [GetAccountDetailsReplyObj](docs/GetAccountDetailsReplyObj.md)
 - [GetAccountRolesReplyObj](docs/GetAccountRolesReplyObj.md)
 - [GetAccountUsersReplyObj](docs/GetAccountUsersReplyObj.md)
 - [GetFragmentDetailsReplyObj](docs/GetFragmentDetailsReplyObj.md)
 - [GetItemReplyObj](docs/GetItemReplyObj.md)
 - [GetPoliciesReplyObj](docs/GetPoliciesReplyObj.md)
 - [GetPolicyReplyObj](docs/GetPolicyReplyObj.md)
 - [GetRoleReplyObj](docs/GetRoleReplyObj.md)
 - [GetUserItemsReplyObj](docs/GetUserItemsReplyObj.md)
 - [GetUserReplyObj](docs/GetUserReplyObj.md)
 - [KFMStatusReplyObj](docs/KFMStatusReplyObj.md)
 - [PolicyParams](docs/PolicyParams.md)
 - [PolicyRules](docs/PolicyRules.md)
 - [PolicyRulesType](docs/PolicyRulesType.md)
 - [PolicyType](docs/PolicyType.md)
 - [PublicSigningKeyReplyObj](docs/PublicSigningKeyReplyObj.md)
 - [RSADecryptCredsReplyObj](docs/RSADecryptCredsReplyObj.md)
 - [RSAFragmentDecryptReplyObj](docs/RSAFragmentDecryptReplyObj.md)
 - [SecretAccessCredsReplyObj](docs/SecretAccessCredsReplyObj.md)
 - [SetUAMPolicyCredsParams](docs/SetUAMPolicyCredsParams.md)
 - [SystemUserCredentialsReplyObj](docs/SystemUserCredentialsReplyObj.md)
 - [TimeReplyObj](docs/TimeReplyObj.md)
 - [UAMStatusReplyObj](docs/UAMStatusReplyObj.md)
 - [UpdatePolicyMode](docs/UpdatePolicyMode.md)
 - [UploadRSAFragmentReplyObj](docs/UploadRSAFragmentReplyObj.md)
 - [UploadRSAKeyCredsReplyObj](docs/UploadRSAKeyCredsReplyObj.md)
 - [UserAccessPolicyInfo](docs/UserAccessPolicyInfo.md)
 - [ValidateClientCredsReplyObj](docs/ValidateClientCredsReplyObj.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

refael@akeyless-security.com

