# coding: utf-8

"""
    KFM - Application API

    KFM manages and stores key fragments. The core operations of each KFM instance are as follows: Creating secure random encryption keys which will be used as a master key fragment. Managing data storage for key fragments. Performing a key fragment derivation function, which generates a derived fragment from the original key fragment.  # noqa: E501

    OpenAPI spec version: 1.0.4
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from akeyless_kfm_api.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def derive_fragment(self, akeyless_kfm_user_creds, akeyless_kfm_operation_creds, derivation_data, **kwargs):  # noqa: E501
        """Returns a derived fragment from the origin fragment via the supplied derivation data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.derive_fragment(akeyless_kfm_user_creds, akeyless_kfm_operation_creds, derivation_data, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_kfm_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_kfm_operation_creds: Temporary credentials for performing the operation (required)
        :param str derivation_data: The derivation data to be used for the fragment derivation operation (required)
        :param bool double_derivation: Indicate if perform a double derivation
        :return: DerivedFragmentReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.derive_fragment_with_http_info(akeyless_kfm_user_creds, akeyless_kfm_operation_creds, derivation_data, **kwargs)  # noqa: E501
        else:
            (data) = self.derive_fragment_with_http_info(akeyless_kfm_user_creds, akeyless_kfm_operation_creds, derivation_data, **kwargs)  # noqa: E501
            return data

    def derive_fragment_with_http_info(self, akeyless_kfm_user_creds, akeyless_kfm_operation_creds, derivation_data, **kwargs):  # noqa: E501
        """Returns a derived fragment from the origin fragment via the supplied derivation data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.derive_fragment_with_http_info(akeyless_kfm_user_creds, akeyless_kfm_operation_creds, derivation_data, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_kfm_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_kfm_operation_creds: Temporary credentials for performing the operation (required)
        :param str derivation_data: The derivation data to be used for the fragment derivation operation (required)
        :param bool double_derivation: Indicate if perform a double derivation
        :return: DerivedFragmentReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_kfm_user_creds', 'akeyless_kfm_operation_creds', 'derivation_data', 'double_derivation']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method derive_fragment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_kfm_user_creds' is set
        if ('akeyless_kfm_user_creds' not in params or
                params['akeyless_kfm_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_kfm_user_creds` when calling `derive_fragment`")  # noqa: E501
        # verify the required parameter 'akeyless_kfm_operation_creds' is set
        if ('akeyless_kfm_operation_creds' not in params or
                params['akeyless_kfm_operation_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_kfm_operation_creds` when calling `derive_fragment`")  # noqa: E501
        # verify the required parameter 'derivation_data' is set
        if ('derivation_data' not in params or
                params['derivation_data'] is None):
            raise ValueError("Missing the required parameter `derivation_data` when calling `derive_fragment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'derivation_data' in params:
            query_params.append(('derivation_data', params['derivation_data']))  # noqa: E501
        if 'double_derivation' in params:
            query_params.append(('double_derivation', params['double_derivation']))  # noqa: E501

        header_params = {}
        if 'akeyless_kfm_user_creds' in params:
            header_params['AkeylessKFM-UserCreds'] = params['akeyless_kfm_user_creds']  # noqa: E501
        if 'akeyless_kfm_operation_creds' in params:
            header_params['AkeylessKFM-OperationCreds'] = params['akeyless_kfm_operation_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/derive-fragment', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DerivedFragmentReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_aes_key_fragment(self, akeyless_kfm_user_creds, fragment_size, **kwargs):  # noqa: E501
        """Generate a new key fragment.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.generate_aes_key_fragment(akeyless_kfm_user_creds, fragment_size, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_kfm_user_creds: Temporary credentials for accessing the endpoint (required)
        :param int fragment_size: The size of the fragment to be generated (max 16kb). (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.generate_aes_key_fragment_with_http_info(akeyless_kfm_user_creds, fragment_size, **kwargs)  # noqa: E501
        else:
            (data) = self.generate_aes_key_fragment_with_http_info(akeyless_kfm_user_creds, fragment_size, **kwargs)  # noqa: E501
            return data

    def generate_aes_key_fragment_with_http_info(self, akeyless_kfm_user_creds, fragment_size, **kwargs):  # noqa: E501
        """Generate a new key fragment.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.generate_aes_key_fragment_with_http_info(akeyless_kfm_user_creds, fragment_size, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_kfm_user_creds: Temporary credentials for accessing the endpoint (required)
        :param int fragment_size: The size of the fragment to be generated (max 16kb). (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_kfm_user_creds', 'fragment_size']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_aes_key_fragment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_kfm_user_creds' is set
        if ('akeyless_kfm_user_creds' not in params or
                params['akeyless_kfm_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_kfm_user_creds` when calling `generate_aes_key_fragment`")  # noqa: E501
        # verify the required parameter 'fragment_size' is set
        if ('fragment_size' not in params or
                params['fragment_size'] is None):
            raise ValueError("Missing the required parameter `fragment_size` when calling `generate_aes_key_fragment`")  # noqa: E501

        if 'fragment_size' in params and params['fragment_size'] > 16384:  # noqa: E501
            raise ValueError("Invalid value for parameter `fragment_size` when calling `generate_aes_key_fragment`, must be a value less than or equal to `16384`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fragment_size' in params:
            query_params.append(('fragment_size', params['fragment_size']))  # noqa: E501

        header_params = {}
        if 'akeyless_kfm_user_creds' in params:
            header_params['AkeylessKFM-UserCreds'] = params['akeyless_kfm_user_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/generate-aes-key-fragment', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_fragment_details(self, **kwargs):  # noqa: E501
        """get_fragment_details  # noqa: E501

        Returns the fragment details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_fragment_details(async=True)
        >>> result = thread.get()

        :param async bool
        :return: GetFragmentDetailsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_fragment_details_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_fragment_details_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_fragment_details_with_http_info(self, **kwargs):  # noqa: E501
        """get_fragment_details  # noqa: E501

        Returns the fragment details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_fragment_details_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: GetFragmentDetailsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fragment_details" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/get-fragment-details', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetFragmentDetailsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_status(self, **kwargs):  # noqa: E501
        """get_status  # noqa: E501

        Get KFM server status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_status(async=True)
        >>> result = thread.get()

        :param async bool
        :return: KFMStatusReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_status_with_http_info(self, **kwargs):  # noqa: E501
        """get_status  # noqa: E501

        Get KFM server status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_status_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: KFMStatusReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KFMStatusReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_time(self, **kwargs):  # noqa: E501
        """get_time  # noqa: E501

        Get Auth server time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_time(async=True)
        >>> result = thread.get()

        :param async bool
        :return: TimeReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_time_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_time_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_time_with_http_info(self, **kwargs):  # noqa: E501
        """get_time  # noqa: E501

        Get Auth server time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_time_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: TimeReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_time" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/time', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rsa_fragment_decrypt(self, akeyless_kfm_user_creds, akeyless_kfm_operation_creds, cipher, **kwargs):  # noqa: E501
        """Returns a fragmented decryption result on an RSA fragment.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.rsa_fragment_decrypt(akeyless_kfm_user_creds, akeyless_kfm_operation_creds, cipher, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_kfm_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_kfm_operation_creds: Temporary credentials for performing the operation (required)
        :param str cipher: The ciphertext to be decrypted (in case of signing operation this parameter should contain the message to be signed) (required)
        :return: RSAFragmentDecryptReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.rsa_fragment_decrypt_with_http_info(akeyless_kfm_user_creds, akeyless_kfm_operation_creds, cipher, **kwargs)  # noqa: E501
        else:
            (data) = self.rsa_fragment_decrypt_with_http_info(akeyless_kfm_user_creds, akeyless_kfm_operation_creds, cipher, **kwargs)  # noqa: E501
            return data

    def rsa_fragment_decrypt_with_http_info(self, akeyless_kfm_user_creds, akeyless_kfm_operation_creds, cipher, **kwargs):  # noqa: E501
        """Returns a fragmented decryption result on an RSA fragment.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.rsa_fragment_decrypt_with_http_info(akeyless_kfm_user_creds, akeyless_kfm_operation_creds, cipher, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_kfm_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_kfm_operation_creds: Temporary credentials for performing the operation (required)
        :param str cipher: The ciphertext to be decrypted (in case of signing operation this parameter should contain the message to be signed) (required)
        :return: RSAFragmentDecryptReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_kfm_user_creds', 'akeyless_kfm_operation_creds', 'cipher']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rsa_fragment_decrypt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_kfm_user_creds' is set
        if ('akeyless_kfm_user_creds' not in params or
                params['akeyless_kfm_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_kfm_user_creds` when calling `rsa_fragment_decrypt`")  # noqa: E501
        # verify the required parameter 'akeyless_kfm_operation_creds' is set
        if ('akeyless_kfm_operation_creds' not in params or
                params['akeyless_kfm_operation_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_kfm_operation_creds` when calling `rsa_fragment_decrypt`")  # noqa: E501
        # verify the required parameter 'cipher' is set
        if ('cipher' not in params or
                params['cipher'] is None):
            raise ValueError("Missing the required parameter `cipher` when calling `rsa_fragment_decrypt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cipher' in params:
            query_params.append(('cipher', params['cipher']))  # noqa: E501

        header_params = {}
        if 'akeyless_kfm_user_creds' in params:
            header_params['AkeylessKFM-UserCreds'] = params['akeyless_kfm_user_creds']  # noqa: E501
        if 'akeyless_kfm_operation_creds' in params:
            header_params['AkeylessKFM-OperationCreds'] = params['akeyless_kfm_operation_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/rsa-fragment-decrypt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RSAFragmentDecryptReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_rsa_fragment(self, akeyless_kfm_user_creds, akeyless_kfm_operation_creds, fragment_value, test_message, **kwargs):  # noqa: E501
        """upload_rsa_fragment  # noqa: E501

        Gets a fragment of an RSA key for storage in database as a new key fragment and return a test signature on a test message using the uploaded fragment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.upload_rsa_fragment(akeyless_kfm_user_creds, akeyless_kfm_operation_creds, fragment_value, test_message, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_kfm_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_kfm_operation_creds: Temporary credentials for performing the operation (required)
        :param str fragment_value: The value of the RSA key fragment. (required)
        :param str test_message: A message to be use to create the testing signature. (required)
        :return: UploadRSAFragmentReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.upload_rsa_fragment_with_http_info(akeyless_kfm_user_creds, akeyless_kfm_operation_creds, fragment_value, test_message, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_rsa_fragment_with_http_info(akeyless_kfm_user_creds, akeyless_kfm_operation_creds, fragment_value, test_message, **kwargs)  # noqa: E501
            return data

    def upload_rsa_fragment_with_http_info(self, akeyless_kfm_user_creds, akeyless_kfm_operation_creds, fragment_value, test_message, **kwargs):  # noqa: E501
        """upload_rsa_fragment  # noqa: E501

        Gets a fragment of an RSA key for storage in database as a new key fragment and return a test signature on a test message using the uploaded fragment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.upload_rsa_fragment_with_http_info(akeyless_kfm_user_creds, akeyless_kfm_operation_creds, fragment_value, test_message, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_kfm_user_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_kfm_operation_creds: Temporary credentials for performing the operation (required)
        :param str fragment_value: The value of the RSA key fragment. (required)
        :param str test_message: A message to be use to create the testing signature. (required)
        :return: UploadRSAFragmentReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_kfm_user_creds', 'akeyless_kfm_operation_creds', 'fragment_value', 'test_message']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_rsa_fragment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_kfm_user_creds' is set
        if ('akeyless_kfm_user_creds' not in params or
                params['akeyless_kfm_user_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_kfm_user_creds` when calling `upload_rsa_fragment`")  # noqa: E501
        # verify the required parameter 'akeyless_kfm_operation_creds' is set
        if ('akeyless_kfm_operation_creds' not in params or
                params['akeyless_kfm_operation_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_kfm_operation_creds` when calling `upload_rsa_fragment`")  # noqa: E501
        # verify the required parameter 'fragment_value' is set
        if ('fragment_value' not in params or
                params['fragment_value'] is None):
            raise ValueError("Missing the required parameter `fragment_value` when calling `upload_rsa_fragment`")  # noqa: E501
        # verify the required parameter 'test_message' is set
        if ('test_message' not in params or
                params['test_message'] is None):
            raise ValueError("Missing the required parameter `test_message` when calling `upload_rsa_fragment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fragment_value' in params:
            query_params.append(('fragment_value', params['fragment_value']))  # noqa: E501
        if 'test_message' in params:
            query_params.append(('test_message', params['test_message']))  # noqa: E501

        header_params = {}
        if 'akeyless_kfm_user_creds' in params:
            header_params['AkeylessKFM-UserCreds'] = params['akeyless_kfm_user_creds']  # noqa: E501
        if 'akeyless_kfm_operation_creds' in params:
            header_params['AkeylessKFM-OperationCreds'] = params['akeyless_kfm_operation_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/upload-rsa-fragment', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UploadRSAFragmentReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
