# -*- coding: utf-8 -*-
from collective.conferences.roomfolder import IRoomfolder
from collective.conferences.testing import COLLECTIVE_CONFERENCES_INTEGRATION_TESTING
from plone import api
from plone.app.testing import setRoles
from plone.app.testing import TEST_USER_ID
from plone.dexterity.interfaces import IDexterityFTI
from zope.component import createObject
from zope.component import queryUtility

import unittest


class TestRoomfolderIntegration(unittest.TestCase):
    layer = COLLECTIVE_CONFERENCES_INTEGRATION_TESTING

    def setUp(self):
        self.portal = self.layer['portal']
        setRoles(self.portal, TEST_USER_ID, ['Manager'])
        portal = api.portal.get()
        api.content.create(type='Folder', title='test-folder', container=portal)
        setRoles(self.portal, TEST_USER_ID, ['Member'])
        self.folder = self.portal['test-folder']

    def test_adding(self):
        portal = api.portal.get()
        setRoles(self.portal, TEST_USER_ID, ['Manager'])
        api.content.create(type='collective.conferences.roomfolder', title='Rooms', container=portal)
        p1 = portal['rooms']
        self.assertTrue(IRoomfolder.providedBy(p1))

    def test_fti(self):
        fti = queryUtility(IDexterityFTI, name='collective.conferences.roomfolder')
        self.assertNotEqual(None, fti)

    def test_schema(self):
        fti = queryUtility(IDexterityFTI, name='collective.conferences.roomfolder')
        schema = fti.lookupSchema()
        self.assertEqual(IRoomfolder, schema)

    def test_factory(self):
        fti = queryUtility(IDexterityFTI, name='collective.conferences.roomfolder')
        factory = fti.factory
        new_object = createObject(factory)
        self.assertTrue(IRoomfolder.providedBy(new_object))

    def test_textedit(self):
        portal = api.portal.get()
        setRoles(self.portal, TEST_USER_ID, ['Manager'])
        api.content.create(type='collective.conferences.roomfolder', title='Rooms', container=portal)
        text = 'The talks and workshops at the conference'
        richtext = '<h2>Conference Rooms</h2><p>A more detailed description of the rooms, the way to them etc.</p>'
        context = portal['rooms']
        context.description = text
        context.details = richtext
        self.assertEqual(context.description, text)
        self.assertEqual(context.details, richtext)


def test_suite():
    return unittest.defaultTestLoader.loadTestsFromName(__name__)
