from setuptools import setup, find_packages
import os

setup(
    name='areixio',
    version='0.1.84',
    description='Areix IO Backtesting Framework',
    long_description_content_type='text/markdown',
    long_description=open(os.path.join(os.path.dirname(__file__), 'README.md'),encoding='utf-8').read(),
    author='Areix',
    author_email='hellohk@areix-ai.com',
    packages=find_packages(),
    # packages=['areixio'],
    # package_dir={'areixio': 'dist'},
    entry_points = {
        "console_scripts": [
            "areixio = areixio.__main__:quick_start",
        ]
    },
    include_package_data=True,  # if true, Accept all data files and directories matched by MANIFEST.in
    python_requires=">=3.7.0",
    install_requires=[
        'pandas', # include: python-dateutil, numpy, pytz
        'requests',
        'aiohttp',
        'bokeh',
        'apscheduler',
        'pydantic',
        'scipy',
        # 'pyjwt',
        # 'tqdm',
        # 'numpy',
        # 'pytz',
    ],
    zip_safe=False,
    url='https://alphagen.areix-ai.com', # homepage
    project_urls={
        'Documentation': 'https://alphagen.areix-ai.com/doc',
        # 'Source': '',
        # 'Tracker': '',
    },
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'Intended Audience :: Financial and Insurance Industry',
        'Intended Audience :: Information Technology',
        'Topic :: Software Development :: Build Tools',
        'Topic :: Office/Business :: Financial :: Investment',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Operating System :: OS Independent',
        'Environment :: Console'
    ],
    keywords=[
        'areix',
        'areixio',
        'alpha_gen',
        'alphagen',
        'wealthx',
        'algo',
        'algorithmic',
        'backtest',
        'backtesting',
        'bitcoin',
        'crypto',
        'bokeh',
        'bonds',
        'candle',
        'candlestick',
        'cboe',
        'chart',
        'cme',
        'commodities',
        'crash',
        'currency',
        'drawdown',
        'equity',
        'etf',
        'ethereum',
        'exchange',
        'finance',
        'financial',
        'forecast',
        'forex',
        'fund',
        'futures',
        'fx',
        'gold',
        'historical',
        'indicator',
        'invest',
        'investing',
        'investment',
        'macd',
        'market',
        'money',
        'ohlc',
        'ohlcv',
        'order',
        'price',
        'profit',
        'quant',
        'quantitative',
        'rsi',
        'pnl',
        'stocks',
        'strategy',
        'ticker',
        'trader',
        'trading',
        'tradingview',
        'usd',
        'binance'
    ],
)




