# slack_webhook

This is a simple python API for sending messages into a specific
slack channel using incoming webhook.

## Prerequisite

In order to send messages using incoming webhook into slack, an Application
must be configured. This needs to be done from a slack account with
administrator rights.  This is done on a per slack channel basis.

Request an incoming webhook from the administrator with the name of an
existing channel for receiving the alerts.

An unique URL will be generated by the administrator.

Note that there is no authentication mechanism.  Anyone (script) with
knowledge of this URL will be able to generate messages into this channel.

Following is a (fake) sample of such an URL:

```
https://hooks.slack.com/services/T02TQT999/B01PZ5XXXXX/GevkYac4s55lE97fXXXXXXX
```

## Installation
```
pip install slack-webhook-alpa
```

## Usage

```
from slack_webhook import SlackWebhook, SlackWebhookException

url = 'https://hooks.slack.com/services/XXXXXXXXX/XXXXXXXXX/XXXXXXXXXXXXXXX'

slack_alert = SlackWebhook(url)
slack_alert.send('TEST TEST TEST')
```

Content formatted in block kit is also supported.

```
blocks = [
    {
        "type": "header",
        "text": {
            "text": "\ud83d\udd34 This is a header",
            "type": "plain_text",
            "emoji": true
        }
    }
]

slack_alert.send('TEST TEST TEST', blocks=blocks)
```

## References
- https://api.slack.com/messaging/webhooks
- https://pypi.org/project/blockkit/

