# AISAFE-BACKEND

<a target="_blank" href="https://cookiecutter-data-science.drivendata.org/">
    <img src="https://img.shields.io/badge/CCDS-Project%20template-328F97?logo=cookiecutter" />
</a>

A backend leveraging gradient boosting machines and multimodal neural networks for early detection of child abuse. 

## DISCLAIMER

The information provided by aisafe_back (owned by GitHub user bright-rookie) on this GitHub repository or on the website `aisafe.qbio.page` is for educational and informational purposes only. All code and data within this repository or information garnered from the website are mock data and examples intended solely for demonstration and experimentation with machine learning models. This repository does not contain functional AI models or real medical data, and any outputs generated by the code are purely fictional and lack any basis in real-world medical analysis or diagnostics.

UNDER NO CIRCUMSTANCES should any code, data, or outputs from this repository or the website be used in clinical settings, to make medical decisions, or as a substitute for professional healthcare advice. bright-rookie and contributors to this repository disclaim any liability for damages resulting from the use or misuse of information contained within this repository. Use of this repository and reliance on any content derived from this repository, or the use of the data from the website are entirely at your own risk.

This repository or website may contain links to other websites or external content maintained by third parties. These links are provided for convenience only, and bright-rookie and contributors do not endorse, guarantee, or take responsibility for the accuracy or completeness of any information available through these links. We have not investigated or verified the content of linked websites. Use of such external resources is also entirely at your own risk.

### Professional Disclaimer

This repository or website does not provide real medical or health advice. The code and data are intended solely for instructional purposes in machine learning and should not be used for any medical or diagnostic purposes. The repository or website does not and cannot provide any kind of medical advice or treatment recommendation. For any medical concerns, consult a qualified healthcare professional.


## Installation

```bash
pip install aisafe_xgboost
```

## Usage

`aisafe_xgboost` can be used as either a CLI or a Python package. 
To train the model, run the following command:

```bash
safe-train
```

To use the model in python, run the following command:

```python
>>> from aisafe_xgboost import model
>>> prediction, explainability = model(
    info = info, # Iterable of Length 4 [Patient Age, Sex, Height Percentile, Weight Percentile]
    bruise = bruse, # Iterable of Length 11 [float]
    response = response, # Iterable of Length 9 [int]
    lab = lab, # Iterable of Length 19 [float]
    xray = xray, # Iterable of Length 9 [float]
    video = video, # Iterable of Length 30 [float]
)
>>> prediction 
0.75
>>> explainability 
[("문진정보", 0.5), ("Lab 수치", 0.3), ("X-ray 영상", 0.1), ("진료 영상", 0.1), ("신체 계측치", 0.0), ("멍 정보", 0.0)]
```



## Project Organization

```
├── LICENSE            <- Open-source license if one is chosen
├── README.md          <- The top-level README for developers using this project.
├── data
│   ├── external       <- Data from third party sources.
│   ├── interim        <- Intermediate data that has been transformed.
│   ├── processed      <- The final, canonical data sets for modeling.
│   └── raw            <- The original, immutable data dump.
│
│
├── models             <- Trained and serialized models, model predictions, or model summaries
│
├── notebooks          <- Jupyter notebooks. 
│
├── pyproject.toml     <- Project configuration file with package metadata for 
│                         aisafe and configuration for tools like black
│
├── references         <- Data dictionaries, manuals, and all other explanatory materials.
│
│
└── aisafe_xgboost   <- Source code for use in this project.
    │
    ├── __init__.py             <- Makes aisafe a Python module
    │
    ├── training.py             <- For training the xgboost model
    │
    ├── utils.py                <- General utility functions for parsing data
    │
    ├── inference.py            <- Code to run model inference with trained models
    │
    ├── models                
    │   ├── *.ubj               <- XGBoost models, stored as .ubj files (universal binary format) 
    │   └── *.npy               <- Weights for combinining the xgboost model as an ensemble        
    │
    ├── growth data                 
    │   └── *.csv               <- Growth Data for Korean male/female children
    └── mock_data
         └── *.csv              <- Mock data for training the model
```
--------

