[![PyPI version](https://img.shields.io/pypi/v/calibr8)](https://pypi.org/project/calibr8)
[![pipeline](https://github.com/jubiotech/calibr8/workflows/pipeline/badge.svg)](https://github.com/jubiotech/calibr8/actions)
[![coverage](https://codecov.io/gh/jubiotech/calibr8/branch/master/graph/badge.svg)](https://codecov.io/gh/jubiotech/calibr8)
[![documentation](https://readthedocs.org/projects/calibr8/badge/?version=latest)](https://calibr8.readthedocs.io/en/latest/?badge=latest)
[![DOI](https://zenodo.org/badge/306862348.svg)](https://zenodo.org/badge/latestdoi/306862348)


# `calibr8`
This package provides templates and functions for performing likelihood-based calibration modeling.
To see implementation examples & excercises, you can go to [notebooks/](notebooks).

# Installation
`calibr8` is released on [PyPI](https://pypi.org/project/calibr8/):

```
pip install calibr8
```
# Documentation
Read the package documentation [here](https://calibr8.readthedocs.io/en/latest/?badge=latest).

# Usage and Citing
`calibr8` is licensed under the [GNU Affero General Public License v3.0](https://github.com/michaelosthege/calibr8/blob/master/LICENSE).

When using `calibr8` in your work, please cite the [Helleckes & Osthege et al. (2022) paper](https://doi.org/10.1371/journal.pcbi.1009223) __and__ the [corresponding software version](https://doi.org/10.5281/zenodo.4127012).

Note that the paper is a shared first co-authorship, which can be indicated by <sup>1</sup> in the bibliography.

```bibtex
@article{calibr8Paper,
  doi       = {10.1371/journal.pcbi.1009223},
  author    = {Helleckes$^1$, Laura Marie and
  	       Osthege$^1$, Michael and
	       Wiechert, Wolfgang and
	       von Lieres, Eric and
	       Oldiges, Marco},
  journal   = {PLOS Computational Biology},
  publisher = {Public Library of Science},
  title     = {Bayesian and calibration, process modeling and uncertainty quantification in biotechnology},
  year      = {2022},
  month     = {03},
  volume    = {18},
  url       = {https://doi.org/10.1371/journal.pcbi.1009223},
  pages     = {1-46},
  number    = {3}
}

@software{calibr8version,
  author    = {Michael Osthege and
               Laura Helleckes},
  title     = {JuBiotech/calibr8: v6.5.2},
  month     = mar,
  year      = 2022,
  publisher = {Zenodo},
  version   = {v6.5.2},
  doi       = {10.5281/zenodo.4127012},
  url       = {https://doi.org/10.5281/zenodo.4127012}
}
```

Head over to Zenodo to [generate a BibTeX citation](https://doi.org/10.5281/zenodo.4127012) for the latest release.
