"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StripeEventBusProducer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class StripeEventBusProducer extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const handler = new aws_cdk_lib_1.aws_lambda.Function(this, 'Function', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_14_X,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'stripe-event-bus-producer')),
            handler: 'index.handler',
        });
        handler.addEnvironment('SOURCE', (_b = props.source) !== null && _b !== void 0 ? _b : 'Stripe');
        if (props.eventBus) {
            handler.addEnvironment('EVENT_BUS_NAME', props.eventBus.eventBusArn);
            handler.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
                effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                actions: ['events:PutEvents'],
                resources: [props.eventBus.eventBusArn],
            }));
        }
        else {
            handler.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
                effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                actions: ['events:PutEvents'],
                resources: [
                    aws_cdk_lib_1.Arn.format({
                        resource: 'event-bus',
                        service: 'events',
                        resourceName: 'default',
                    }, aws_cdk_lib_1.Stack.of(this)),
                ],
            }));
        }
        if (props.endpointSecret.grantRead) {
            props.endpointSecret.grantRead(handler);
        }
        handler.addEnvironment('ENDPOINT_SECRET_STRING', props.endpointSecret.serialize());
        if (props.secretKey.grantRead) {
            props.secretKey.grantRead(handler);
        }
        handler.addEnvironment('SECRET_KEY_STRING', props.secretKey.serialize());
        const api = new aws_cdk_lib_1.aws_apigateway.RestApi(this, 'Endpoint', {
            description: 'Stripe event bridge producer webhook',
            deployOptions: {
                throttlingBurstLimit: props.throttlingBurstLimit,
                throttlingRateLimit: props.throttlingRateLimit,
            },
        });
        api.root.addMethod('POST', new aws_cdk_lib_1.aws_apigateway.LambdaIntegration(handler));
        this.url = api.url;
    }
}
exports.StripeEventBusProducer = StripeEventBusProducer;
_a = JSII_RTTI_SYMBOL_1;
StripeEventBusProducer[_a] = { fqn: "@cloudcomponents/cdk-stripe-webhook.StripeEventBusProducer", version: "2.1.0" };
//# sourceMappingURL=data:application/json;base64,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