"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StripeWebhook = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk_secret_key_1 = require("@cloudcomponents/cdk-secret-key");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class StripeWebhook extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const secretKey = typeof props.secretKey === 'string' ? cdk_secret_key_1.SecretKey.fromPlainText(props.secretKey) : props.secretKey;
        const handler = new aws_cdk_lib_1.aws_lambda.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: 'e9db3870-d793-4cd2-96a9-efe2e318ebbc',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_14_X,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'stripe-webhook')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::StripeWebhook',
            timeout: aws_cdk_lib_1.Duration.minutes(15),
        });
        if (secretKey.grantRead) {
            secretKey.grantRead(handler);
        }
        if (props.endpointSecretStore) {
            props.endpointSecretStore.grantWrite(handler);
        }
        const cr = new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::StripeWebhook',
            pascalCaseProperties: true,
            properties: {
                url: props.url,
                description: props.description,
                events: props.events,
                logLevel: props.logLevel,
                secretKeyString: secretKey.serialize(),
                endpointSecretStoreString: (_b = props.endpointSecretStore) === null || _b === void 0 ? void 0 : _b.serialize(),
            },
        });
        this.id = cr.ref;
    }
}
exports.StripeWebhook = StripeWebhook;
_a = JSII_RTTI_SYMBOL_1;
StripeWebhook[_a] = { fqn: "@cloudcomponents/cdk-stripe-webhook.StripeWebhook", version: "2.1.0" };
//# sourceMappingURL=data:application/json;base64,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