# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AccessPolicyAssignmentArgs', 'AccessPolicyAssignment']

@pulumi.input_type
class AccessPolicyAssignmentArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[str],
                 policy_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a AccessPolicyAssignment resource.
        :param pulumi.Input[str] app_id: The application ID; this value is immutable and can not be updated.
        :param pulumi.Input[str] policy_id: The access policy ID.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "policy_id", policy_id)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[str]:
        """
        The application ID; this value is immutable and can not be updated.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[str]:
        """
        The access policy ID.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_id", value)


@pulumi.input_type
class _AccessPolicyAssignmentState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AccessPolicyAssignment resources.
        :param pulumi.Input[str] app_id: The application ID; this value is immutable and can not be updated.
        :param pulumi.Input[str] policy_id: The access policy ID.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The application ID; this value is immutable and can not be updated.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The access policy ID.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)


class AccessPolicyAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages assignment of Access Policy to an Application.

        **Warning**: do not use as this will update okta_app_*.authentication_policy and vice versa

        Assigns an access policy (colloquially known as a sign-on policy and/or an
        authentication policy) to an application. This resource does not perform true
        delete as it will not delete an application and the app's access policy can't be
        removed; it can only be changed to a different access policy. This resource is
        only logical within the context of an application therefore `app_id` is
        immutable once set. Use this resource to manage assigning an access policy to an
        application. It will assign the given `policy_id` to the application at creation
        and during update.

        > Inside the product a sign-on policy is referenced as an _authentication
        policy_, in the public API the policy is of type
        [`ACCESS_POLICY`](https://developer.okta.com/docs/reference/api/policy/#policy-object).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        access = okta.policy.get_policy(name="Any two factors",
            type="ACCESS_POLICY")
        example = okta.app.get_app(label="Example App")
        assignment = okta.app.AccessPolicyAssignment("assignment",
            app_id=example.id,
            policy_id=access.id)
        ```

        ## Import

        ```sh
        $ pulumi import okta:app/accessPolicyAssignment:AccessPolicyAssignment example &#60;app id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The application ID; this value is immutable and can not be updated.
        :param pulumi.Input[str] policy_id: The access policy ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessPolicyAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages assignment of Access Policy to an Application.

        **Warning**: do not use as this will update okta_app_*.authentication_policy and vice versa

        Assigns an access policy (colloquially known as a sign-on policy and/or an
        authentication policy) to an application. This resource does not perform true
        delete as it will not delete an application and the app's access policy can't be
        removed; it can only be changed to a different access policy. This resource is
        only logical within the context of an application therefore `app_id` is
        immutable once set. Use this resource to manage assigning an access policy to an
        application. It will assign the given `policy_id` to the application at creation
        and during update.

        > Inside the product a sign-on policy is referenced as an _authentication
        policy_, in the public API the policy is of type
        [`ACCESS_POLICY`](https://developer.okta.com/docs/reference/api/policy/#policy-object).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        access = okta.policy.get_policy(name="Any two factors",
            type="ACCESS_POLICY")
        example = okta.app.get_app(label="Example App")
        assignment = okta.app.AccessPolicyAssignment("assignment",
            app_id=example.id,
            policy_id=access.id)
        ```

        ## Import

        ```sh
        $ pulumi import okta:app/accessPolicyAssignment:AccessPolicyAssignment example &#60;app id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param AccessPolicyAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessPolicyAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessPolicyAssignmentArgs.__new__(AccessPolicyAssignmentArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
        super(AccessPolicyAssignment, __self__).__init__(
            'okta:app/accessPolicyAssignment:AccessPolicyAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            policy_id: Optional[pulumi.Input[str]] = None) -> 'AccessPolicyAssignment':
        """
        Get an existing AccessPolicyAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The application ID; this value is immutable and can not be updated.
        :param pulumi.Input[str] policy_id: The access policy ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessPolicyAssignmentState.__new__(_AccessPolicyAssignmentState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["policy_id"] = policy_id
        return AccessPolicyAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        The application ID; this value is immutable and can not be updated.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        The access policy ID.
        """
        return pulumi.get(self, "policy_id")

