# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAppResult',
    'AwaitableGetAppResult',
    'get_app',
    'get_app_output',
]

@pulumi.output_type
class GetAppResult:
    """
    A collection of values returned by getApp.
    """
    def __init__(__self__, active_only=None, groups=None, id=None, label=None, label_prefix=None, links=None, name=None, skip_groups=None, skip_users=None, status=None, users=None):
        if active_only and not isinstance(active_only, bool):
            raise TypeError("Expected argument 'active_only' to be a bool")
        pulumi.set(__self__, "active_only", active_only)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if label_prefix and not isinstance(label_prefix, str):
            raise TypeError("Expected argument 'label_prefix' to be a str")
        pulumi.set(__self__, "label_prefix", label_prefix)
        if links and not isinstance(links, str):
            raise TypeError("Expected argument 'links' to be a str")
        pulumi.set(__self__, "links", links)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if skip_groups and not isinstance(skip_groups, bool):
            raise TypeError("Expected argument 'skip_groups' to be a bool")
        pulumi.set(__self__, "skip_groups", skip_groups)
        if skip_users and not isinstance(skip_users, bool):
            raise TypeError("Expected argument 'skip_users' to be a bool")
        pulumi.set(__self__, "skip_users", skip_users)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="activeOnly")
    def active_only(self) -> Optional[bool]:
        """
        Search only ACTIVE applications.
        """
        return pulumi.get(self, "active_only")

    @property
    @pulumi.getter
    @_utilities.deprecated("""The `groups` field is now deprecated for the data source `app_get_app`, please replace all uses of this with: `AppGroupAssignments`""")
    def groups(self) -> Sequence[str]:
        """
        Groups associated with the application
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Id of application to retrieve, conflicts with label and label_prefix.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        The label of the app to retrieve, conflicts with
        			label_prefix and id. Label uses the ?q=\\n\\n query parameter exposed by
        			Okta's List Apps API. The API will search both name and label using that
        			query. Therefore similarily named and labeled apps may be returned in the query
        			and have the unitended result of associating the wrong app with this data
        			source. See:
        			https://developer.okta.com/docs/reference/api/apps/#list-applications
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="labelPrefix")
    def label_prefix(self) -> Optional[str]:
        """
        Label prefix of the app to retrieve, conflicts with label and id. This will tell the
        			provider to do a starts with query as opposed to an equals query.
        """
        return pulumi.get(self, "label_prefix")

    @property
    @pulumi.getter
    def links(self) -> str:
        """
        Discoverable resources related to the app
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="skipGroups")
    @_utilities.deprecated("""Because groups has been removed, this attribute is a no op and will be removed""")
    def skip_groups(self) -> Optional[bool]:
        """
        Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_groups")

    @property
    @pulumi.getter(name="skipUsers")
    @_utilities.deprecated("""Because users has been removed, this attribute is a no op and will be removed""")
    def skip_users(self) -> Optional[bool]:
        """
        Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
        """
        return pulumi.get(self, "skip_users")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of application.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    @_utilities.deprecated("""The `users` field is now deprecated for the data source `app_get_app`, please replace all uses of this with: `get_app_user_assignments`""")
    def users(self) -> Sequence[str]:
        """
        Users associated with the application
        """
        return pulumi.get(self, "users")


class AwaitableGetAppResult(GetAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppResult(
            active_only=self.active_only,
            groups=self.groups,
            id=self.id,
            label=self.label,
            label_prefix=self.label_prefix,
            links=self.links,
            name=self.name,
            skip_groups=self.skip_groups,
            skip_users=self.skip_users,
            status=self.status,
            users=self.users)


def get_app(active_only: Optional[bool] = None,
            id: Optional[str] = None,
            label: Optional[str] = None,
            label_prefix: Optional[str] = None,
            skip_groups: Optional[bool] = None,
            skip_users: Optional[bool] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppResult:
    """
    Get an application of any kind from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.app.get_app(label="Example App")
    ```


    :param bool active_only: Search only ACTIVE applications.
    :param str id: Id of application to retrieve, conflicts with label and label_prefix.
    :param str label: The label of the app to retrieve, conflicts with
           			label_prefix and id. Label uses the ?q=\\n\\n query parameter exposed by
           			Okta's List Apps API. The API will search both name and label using that
           			query. Therefore similarily named and labeled apps may be returned in the query
           			and have the unitended result of associating the wrong app with this data
           			source. See:
           			https://developer.okta.com/docs/reference/api/apps/#list-applications
    :param str label_prefix: Label prefix of the app to retrieve, conflicts with label and id. This will tell the
           			provider to do a starts with query as opposed to an equals query.
    :param bool skip_groups: Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    :param bool skip_users: Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    """
    __args__ = dict()
    __args__['activeOnly'] = active_only
    __args__['id'] = id
    __args__['label'] = label
    __args__['labelPrefix'] = label_prefix
    __args__['skipGroups'] = skip_groups
    __args__['skipUsers'] = skip_users
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:app/getApp:getApp', __args__, opts=opts, typ=GetAppResult).value

    return AwaitableGetAppResult(
        active_only=pulumi.get(__ret__, 'active_only'),
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        label=pulumi.get(__ret__, 'label'),
        label_prefix=pulumi.get(__ret__, 'label_prefix'),
        links=pulumi.get(__ret__, 'links'),
        name=pulumi.get(__ret__, 'name'),
        skip_groups=pulumi.get(__ret__, 'skip_groups'),
        skip_users=pulumi.get(__ret__, 'skip_users'),
        status=pulumi.get(__ret__, 'status'),
        users=pulumi.get(__ret__, 'users'))


@_utilities.lift_output_func(get_app)
def get_app_output(active_only: Optional[pulumi.Input[Optional[bool]]] = None,
                   id: Optional[pulumi.Input[Optional[str]]] = None,
                   label: Optional[pulumi.Input[Optional[str]]] = None,
                   label_prefix: Optional[pulumi.Input[Optional[str]]] = None,
                   skip_groups: Optional[pulumi.Input[Optional[bool]]] = None,
                   skip_users: Optional[pulumi.Input[Optional[bool]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppResult]:
    """
    Get an application of any kind from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.app.get_app(label="Example App")
    ```


    :param bool active_only: Search only ACTIVE applications.
    :param str id: Id of application to retrieve, conflicts with label and label_prefix.
    :param str label: The label of the app to retrieve, conflicts with
           			label_prefix and id. Label uses the ?q=\\n\\n query parameter exposed by
           			Okta's List Apps API. The API will search both name and label using that
           			query. Therefore similarily named and labeled apps may be returned in the query
           			and have the unitended result of associating the wrong app with this data
           			source. See:
           			https://developer.okta.com/docs/reference/api/apps/#list-applications
    :param str label_prefix: Label prefix of the app to retrieve, conflicts with label and id. This will tell the
           			provider to do a starts with query as opposed to an equals query.
    :param bool skip_groups: Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    :param bool skip_users: Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    """
    ...
