# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['OauthRoleAssignmentArgs', 'OauthRoleAssignment']

@pulumi.input_type
class OauthRoleAssignmentArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 resource_set: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OauthRoleAssignment resource.
        :param pulumi.Input[str] client_id: Client ID for the role to be assigned to
        :param pulumi.Input[str] type: Role type to assign. This can be one of the standard Okta roles, such as `HELP_DESK_ADMIN`, or `CUSTOM`. Using custom requires the `resource_set` and `role` attributes to be set.
        :param pulumi.Input[str] resource_set: Resource set for the custom role to assign, must be the ID of the created resource set.
        :param pulumi.Input[str] role: Custom Role ID
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "type", type)
        if resource_set is not None:
            pulumi.set(__self__, "resource_set", resource_set)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        Client ID for the role to be assigned to
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Role type to assign. This can be one of the standard Okta roles, such as `HELP_DESK_ADMIN`, or `CUSTOM`. Using custom requires the `resource_set` and `role` attributes to be set.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="resourceSet")
    def resource_set(self) -> Optional[pulumi.Input[str]]:
        """
        Resource set for the custom role to assign, must be the ID of the created resource set.
        """
        return pulumi.get(self, "resource_set")

    @resource_set.setter
    def resource_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_set", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Role ID
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class _OauthRoleAssignmentState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 resource_set: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OauthRoleAssignment resources.
        :param pulumi.Input[str] client_id: Client ID for the role to be assigned to
        :param pulumi.Input[str] label: Label of the role assignment
        :param pulumi.Input[str] resource_set: Resource set for the custom role to assign, must be the ID of the created resource set.
        :param pulumi.Input[str] role: Custom Role ID
        :param pulumi.Input[str] status: Status of the role assignment
        :param pulumi.Input[str] type: Role type to assign. This can be one of the standard Okta roles, such as `HELP_DESK_ADMIN`, or `CUSTOM`. Using custom requires the `resource_set` and `role` attributes to be set.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if resource_set is not None:
            pulumi.set(__self__, "resource_set", resource_set)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Client ID for the role to be assigned to
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Label of the role assignment
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="resourceSet")
    def resource_set(self) -> Optional[pulumi.Input[str]]:
        """
        Resource set for the custom role to assign, must be the ID of the created resource set.
        """
        return pulumi.get(self, "resource_set")

    @resource_set.setter
    def resource_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_set", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Role ID
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the role assignment
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Role type to assign. This can be one of the standard Okta roles, such as `HELP_DESK_ADMIN`, or `CUSTOM`. Using custom requires the `resource_set` and `role` attributes to be set.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class OauthRoleAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 resource_set: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages assignment of an admin role to an OAuth application
        		This resource allows you to assign an Okta admin role to a OAuth
        		service application. This requires the Okta tenant feature flag for this function to be enabled.

        ## Import

        ```sh
        $ pulumi import okta:app/oauthRoleAssignment:OauthRoleAssignment test <clientID>/<roleAssignmentID>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_id: Client ID for the role to be assigned to
        :param pulumi.Input[str] resource_set: Resource set for the custom role to assign, must be the ID of the created resource set.
        :param pulumi.Input[str] role: Custom Role ID
        :param pulumi.Input[str] type: Role type to assign. This can be one of the standard Okta roles, such as `HELP_DESK_ADMIN`, or `CUSTOM`. Using custom requires the `resource_set` and `role` attributes to be set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OauthRoleAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages assignment of an admin role to an OAuth application
        		This resource allows you to assign an Okta admin role to a OAuth
        		service application. This requires the Okta tenant feature flag for this function to be enabled.

        ## Import

        ```sh
        $ pulumi import okta:app/oauthRoleAssignment:OauthRoleAssignment test <clientID>/<roleAssignmentID>
        ```

        :param str resource_name: The name of the resource.
        :param OauthRoleAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OauthRoleAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 resource_set: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OauthRoleAssignmentArgs.__new__(OauthRoleAssignmentArgs)

            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["resource_set"] = resource_set
            __props__.__dict__["role"] = role
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["label"] = None
            __props__.__dict__["status"] = None
        super(OauthRoleAssignment, __self__).__init__(
            'okta:app/oauthRoleAssignment:OauthRoleAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            label: Optional[pulumi.Input[str]] = None,
            resource_set: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'OauthRoleAssignment':
        """
        Get an existing OauthRoleAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_id: Client ID for the role to be assigned to
        :param pulumi.Input[str] label: Label of the role assignment
        :param pulumi.Input[str] resource_set: Resource set for the custom role to assign, must be the ID of the created resource set.
        :param pulumi.Input[str] role: Custom Role ID
        :param pulumi.Input[str] status: Status of the role assignment
        :param pulumi.Input[str] type: Role type to assign. This can be one of the standard Okta roles, such as `HELP_DESK_ADMIN`, or `CUSTOM`. Using custom requires the `resource_set` and `role` attributes to be set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OauthRoleAssignmentState.__new__(_OauthRoleAssignmentState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["label"] = label
        __props__.__dict__["resource_set"] = resource_set
        __props__.__dict__["role"] = role
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return OauthRoleAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        Client ID for the role to be assigned to
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        Label of the role assignment
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="resourceSet")
    def resource_set(self) -> pulumi.Output[Optional[str]]:
        """
        Resource set for the custom role to assign, must be the ID of the created resource set.
        """
        return pulumi.get(self, "resource_set")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[str]]:
        """
        Custom Role ID
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the role assignment
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Role type to assign. This can be one of the standard Okta roles, such as `HELP_DESK_ADMIN`, or `CUSTOM`. Using custom requires the `resource_set` and `role` attributes to be set.
        """
        return pulumi.get(self, "type")

