# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'OAuthGroupsClaim',
    'OAuthJwk',
    'SamlAttributeStatement',
    'SamlKey',
    'GetSamlAttributeStatementResult',
]

@pulumi.output_type
class OAuthGroupsClaim(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterType":
            suggest = "filter_type"
        elif key == "issuerMode":
            suggest = "issuer_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OAuthGroupsClaim. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OAuthGroupsClaim.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OAuthGroupsClaim.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 value: str,
                 filter_type: Optional[str] = None,
                 issuer_mode: Optional[str] = None):
        """
        :param str name: Name of the claim that will be used in the token.
        :param str type: Groups claim type.
        :param str value: Value of the claim. Can be an Okta Expression Language statement that evaluates at the time the token is minted.
        :param str filter_type: Groups claim filter. Can only be set if type is FILTER.
        :param str issuer_mode: Issuer mode inherited from OAuth App
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the claim that will be used in the token.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Groups claim type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the claim. Can be an Okta Expression Language statement that evaluates at the time the token is minted.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[str]:
        """
        Groups claim filter. Can only be set if type is FILTER.
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[str]:
        """
        Issuer mode inherited from OAuth App
        """
        return pulumi.get(self, "issuer_mode")


@pulumi.output_type
class OAuthJwk(dict):
    def __init__(__self__, *,
                 kid: str,
                 kty: str,
                 e: Optional[str] = None,
                 n: Optional[str] = None,
                 x: Optional[str] = None,
                 y: Optional[str] = None):
        """
        :param str kid: Key ID
        :param str kty: Key type
        :param str e: RSA Exponent
        :param str n: RSA Modulus
        :param str x: X coordinate of the elliptic curve point
        :param str y: Y coordinate of the elliptic curve point
        """
        pulumi.set(__self__, "kid", kid)
        pulumi.set(__self__, "kty", kty)
        if e is not None:
            pulumi.set(__self__, "e", e)
        if n is not None:
            pulumi.set(__self__, "n", n)
        if x is not None:
            pulumi.set(__self__, "x", x)
        if y is not None:
            pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def kid(self) -> str:
        """
        Key ID
        """
        return pulumi.get(self, "kid")

    @property
    @pulumi.getter
    def kty(self) -> str:
        """
        Key type
        """
        return pulumi.get(self, "kty")

    @property
    @pulumi.getter
    def e(self) -> Optional[str]:
        """
        RSA Exponent
        """
        return pulumi.get(self, "e")

    @property
    @pulumi.getter
    def n(self) -> Optional[str]:
        """
        RSA Modulus
        """
        return pulumi.get(self, "n")

    @property
    @pulumi.getter
    def x(self) -> Optional[str]:
        """
        X coordinate of the elliptic curve point
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> Optional[str]:
        """
        Y coordinate of the elliptic curve point
        """
        return pulumi.get(self, "y")


@pulumi.output_type
class SamlAttributeStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterType":
            suggest = "filter_type"
        elif key == "filterValue":
            suggest = "filter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SamlAttributeStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SamlAttributeStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SamlAttributeStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 filter_type: Optional[str] = None,
                 filter_value: Optional[str] = None,
                 namespace: Optional[str] = None,
                 type: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        :param str name: The reference name of the attribute statement
        :param str filter_type: Type of group attribute filter. Valid values are: `STARTS_WITH`, `EQUALS`, `CONTAINS`, or `REGEX`
        :param str filter_value: Filter value to use
        :param str namespace: The attribute namespace. It can be set to `urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified`, `urn:oasis:names:tc:SAML:2.0:attrname-format:uri`, or `urn:oasis:names:tc:SAML:2.0:attrname-format:basic`
        :param str type: The type of attribute statements object
        """
        pulumi.set(__self__, "name", name)
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if filter_value is not None:
            pulumi.set(__self__, "filter_value", filter_value)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The reference name of the attribute statement
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[str]:
        """
        Type of group attribute filter. Valid values are: `STARTS_WITH`, `EQUALS`, `CONTAINS`, or `REGEX`
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter(name="filterValue")
    def filter_value(self) -> Optional[str]:
        """
        Filter value to use
        """
        return pulumi.get(self, "filter_value")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The attribute namespace. It can be set to `urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified`, `urn:oasis:names:tc:SAML:2.0:attrname-format:uri`, or `urn:oasis:names:tc:SAML:2.0:attrname-format:basic`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of attribute statements object
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "values")


@pulumi.output_type
class SamlKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiresAt":
            suggest = "expires_at"
        elif key == "lastUpdated":
            suggest = "last_updated"
        elif key == "x5tS256":
            suggest = "x5t_s256"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SamlKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SamlKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SamlKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created: Optional[str] = None,
                 e: Optional[str] = None,
                 expires_at: Optional[str] = None,
                 kid: Optional[str] = None,
                 kty: Optional[str] = None,
                 last_updated: Optional[str] = None,
                 n: Optional[str] = None,
                 use: Optional[str] = None,
                 x5cs: Optional[Sequence[str]] = None,
                 x5t_s256: Optional[str] = None):
        """
        :param str created: Created date
        :param str e: RSA exponent
        :param str expires_at: Expiration date
        :param str kid: Key ID
        :param str kty: Key type. Identifies the cryptographic algorithm family used with the key.
        :param str last_updated: Last updated date
        :param str n: RSA modulus
        :param str use: Intended use of the public key.
        :param Sequence[str] x5cs: X.509 Certificate Chain
        :param str x5t_s256: X.509 certificate SHA-256 thumbprint
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if e is not None:
            pulumi.set(__self__, "e", e)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if kid is not None:
            pulumi.set(__self__, "kid", kid)
        if kty is not None:
            pulumi.set(__self__, "kty", kty)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if n is not None:
            pulumi.set(__self__, "n", n)
        if use is not None:
            pulumi.set(__self__, "use", use)
        if x5cs is not None:
            pulumi.set(__self__, "x5cs", x5cs)
        if x5t_s256 is not None:
            pulumi.set(__self__, "x5t_s256", x5t_s256)

    @property
    @pulumi.getter
    def created(self) -> Optional[str]:
        """
        Created date
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def e(self) -> Optional[str]:
        """
        RSA exponent
        """
        return pulumi.get(self, "e")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[str]:
        """
        Expiration date
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def kid(self) -> Optional[str]:
        """
        Key ID
        """
        return pulumi.get(self, "kid")

    @property
    @pulumi.getter
    def kty(self) -> Optional[str]:
        """
        Key type. Identifies the cryptographic algorithm family used with the key.
        """
        return pulumi.get(self, "kty")

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[str]:
        """
        Last updated date
        """
        return pulumi.get(self, "last_updated")

    @property
    @pulumi.getter
    def n(self) -> Optional[str]:
        """
        RSA modulus
        """
        return pulumi.get(self, "n")

    @property
    @pulumi.getter
    def use(self) -> Optional[str]:
        """
        Intended use of the public key.
        """
        return pulumi.get(self, "use")

    @property
    @pulumi.getter
    def x5cs(self) -> Optional[Sequence[str]]:
        """
        X.509 Certificate Chain
        """
        return pulumi.get(self, "x5cs")

    @property
    @pulumi.getter(name="x5tS256")
    def x5t_s256(self) -> Optional[str]:
        """
        X.509 certificate SHA-256 thumbprint
        """
        return pulumi.get(self, "x5t_s256")


@pulumi.output_type
class GetSamlAttributeStatementResult(dict):
    def __init__(__self__, *,
                 filter_type: str,
                 filter_value: str,
                 name: str,
                 namespace: str,
                 type: str,
                 values: Sequence[str]):
        """
        :param str filter_type: Type of group attribute filter
        :param str filter_value: Filter value to use
        :param str name: The reference name of the attribute statement
        :param str namespace: The name format of the attribute
        :param str type: The type of attribute statements object
        """
        pulumi.set(__self__, "filter_type", filter_type)
        pulumi.set(__self__, "filter_value", filter_value)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> str:
        """
        Type of group attribute filter
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter(name="filterValue")
    def filter_value(self) -> str:
        """
        Filter value to use
        """
        return pulumi.get(self, "filter_value")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The reference name of the attribute statement
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The name format of the attribute
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of attribute statements object
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


