# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetServerPolicyResult',
    'AwaitableGetServerPolicyResult',
    'get_server_policy',
    'get_server_policy_output',
]

@pulumi.output_type
class GetServerPolicyResult:
    """
    A collection of values returned by getServerPolicy.
    """
    def __init__(__self__, assigned_clients=None, auth_server_id=None, description=None, id=None, name=None, priority=None):
        if assigned_clients and not isinstance(assigned_clients, list):
            raise TypeError("Expected argument 'assigned_clients' to be a list")
        pulumi.set(__self__, "assigned_clients", assigned_clients)
        if auth_server_id and not isinstance(auth_server_id, str):
            raise TypeError("Expected argument 'auth_server_id' to be a str")
        pulumi.set(__self__, "auth_server_id", auth_server_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter(name="assignedClients")
    def assigned_clients(self) -> Sequence[str]:
        """
        List of clients this policy is assigned to. `[ALL_CLIENTS]` is a special value when policy is assigned to all clients.
        """
        return pulumi.get(self, "assigned_clients")

    @property
    @pulumi.getter(name="authServerId")
    def auth_server_id(self) -> str:
        """
        Auth server ID
        """
        return pulumi.get(self, "auth_server_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of authorization server policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Priority of the auth server policy
        """
        return pulumi.get(self, "priority")


class AwaitableGetServerPolicyResult(GetServerPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerPolicyResult(
            assigned_clients=self.assigned_clients,
            auth_server_id=self.auth_server_id,
            description=self.description,
            id=self.id,
            name=self.name,
            priority=self.priority)


def get_server_policy(auth_server_id: Optional[str] = None,
                      name: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerPolicyResult:
    """
    Get an authorization server policy from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.auth.get_server_policy(auth_server_id="<auth server id>",
        name="staff")
    ```


    :param str auth_server_id: Auth server ID
    :param str name: Name of the policy
    """
    __args__ = dict()
    __args__['authServerId'] = auth_server_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:auth/getServerPolicy:getServerPolicy', __args__, opts=opts, typ=GetServerPolicyResult).value

    return AwaitableGetServerPolicyResult(
        assigned_clients=pulumi.get(__ret__, 'assigned_clients'),
        auth_server_id=pulumi.get(__ret__, 'auth_server_id'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        priority=pulumi.get(__ret__, 'priority'))


@_utilities.lift_output_func(get_server_policy)
def get_server_policy_output(auth_server_id: Optional[pulumi.Input[str]] = None,
                             name: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServerPolicyResult]:
    """
    Get an authorization server policy from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.auth.get_server_policy(auth_server_id="<auth server id>",
        name="staff")
    ```


    :param str auth_server_id: Auth server ID
    :param str name: Name of the policy
    """
    ...
