# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ServerScopeArgs', 'ServerScope']

@pulumi.input_type
class ServerScopeArgs:
    def __init__(__self__, *,
                 auth_server_id: pulumi.Input[str],
                 consent: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 metadata_publish: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ServerScope resource.
        :param pulumi.Input[str] auth_server_id: Auth server ID
        :param pulumi.Input[str] consent: Indicates whether a consent dialog is needed for the scope. It can be set to `REQUIRED` or `IMPLICIT`. Default: `IMPLICIT`
        :param pulumi.Input[bool] default: A default scope will be returned in an access token when the client omits the scope parameter in a token request, provided this scope is allowed as part of the access policy rule.
        :param pulumi.Input[str] description: Description of the Auth Server Scope.
        :param pulumi.Input[str] display_name: Name of the end user displayed in a consent dialog box
        :param pulumi.Input[str] metadata_publish: Whether to publish metadata or not. It can be set to `ALL_CLIENTS` or `NO_CLIENTS`. Default: `ALL_CLIENTS`
        :param pulumi.Input[str] name: Auth server scope name
        :param pulumi.Input[bool] optional: Whether the scope optional
        """
        pulumi.set(__self__, "auth_server_id", auth_server_id)
        if consent is not None:
            pulumi.set(__self__, "consent", consent)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if metadata_publish is not None:
            pulumi.set(__self__, "metadata_publish", metadata_publish)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="authServerId")
    def auth_server_id(self) -> pulumi.Input[str]:
        """
        Auth server ID
        """
        return pulumi.get(self, "auth_server_id")

    @auth_server_id.setter
    def auth_server_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_server_id", value)

    @property
    @pulumi.getter
    def consent(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether a consent dialog is needed for the scope. It can be set to `REQUIRED` or `IMPLICIT`. Default: `IMPLICIT`
        """
        return pulumi.get(self, "consent")

    @consent.setter
    def consent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consent", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        A default scope will be returned in an access token when the client omits the scope parameter in a token request, provided this scope is allowed as part of the access policy rule.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Auth Server Scope.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the end user displayed in a consent dialog box
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="metadataPublish")
    def metadata_publish(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to publish metadata or not. It can be set to `ALL_CLIENTS` or `NO_CLIENTS`. Default: `ALL_CLIENTS`
        """
        return pulumi.get(self, "metadata_publish")

    @metadata_publish.setter
    def metadata_publish(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_publish", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Auth server scope name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the scope optional
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class _ServerScopeState:
    def __init__(__self__, *,
                 auth_server_id: Optional[pulumi.Input[str]] = None,
                 consent: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 metadata_publish: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None,
                 system: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering ServerScope resources.
        :param pulumi.Input[str] auth_server_id: Auth server ID
        :param pulumi.Input[str] consent: Indicates whether a consent dialog is needed for the scope. It can be set to `REQUIRED` or `IMPLICIT`. Default: `IMPLICIT`
        :param pulumi.Input[bool] default: A default scope will be returned in an access token when the client omits the scope parameter in a token request, provided this scope is allowed as part of the access policy rule.
        :param pulumi.Input[str] description: Description of the Auth Server Scope.
        :param pulumi.Input[str] display_name: Name of the end user displayed in a consent dialog box
        :param pulumi.Input[str] metadata_publish: Whether to publish metadata or not. It can be set to `ALL_CLIENTS` or `NO_CLIENTS`. Default: `ALL_CLIENTS`
        :param pulumi.Input[str] name: Auth server scope name
        :param pulumi.Input[bool] optional: Whether the scope optional
        :param pulumi.Input[bool] system: Whether Okta created the Scope
        """
        if auth_server_id is not None:
            pulumi.set(__self__, "auth_server_id", auth_server_id)
        if consent is not None:
            pulumi.set(__self__, "consent", consent)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if metadata_publish is not None:
            pulumi.set(__self__, "metadata_publish", metadata_publish)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)
        if system is not None:
            pulumi.set(__self__, "system", system)

    @property
    @pulumi.getter(name="authServerId")
    def auth_server_id(self) -> Optional[pulumi.Input[str]]:
        """
        Auth server ID
        """
        return pulumi.get(self, "auth_server_id")

    @auth_server_id.setter
    def auth_server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_server_id", value)

    @property
    @pulumi.getter
    def consent(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether a consent dialog is needed for the scope. It can be set to `REQUIRED` or `IMPLICIT`. Default: `IMPLICIT`
        """
        return pulumi.get(self, "consent")

    @consent.setter
    def consent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consent", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        A default scope will be returned in an access token when the client omits the scope parameter in a token request, provided this scope is allowed as part of the access policy rule.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Auth Server Scope.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the end user displayed in a consent dialog box
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="metadataPublish")
    def metadata_publish(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to publish metadata or not. It can be set to `ALL_CLIENTS` or `NO_CLIENTS`. Default: `ALL_CLIENTS`
        """
        return pulumi.get(self, "metadata_publish")

    @metadata_publish.setter
    def metadata_publish(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_publish", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Auth server scope name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the scope optional
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)

    @property
    @pulumi.getter
    def system(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Okta created the Scope
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "system", value)


class ServerScope(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_server_id: Optional[pulumi.Input[str]] = None,
                 consent: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 metadata_publish: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Creates an Authorization Server Scope. This resource allows you to create and configure an Authorization Server Scope.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.auth.ServerScope("example",
            auth_server_id="<auth server id>",
            metadata_publish="NO_CLIENTS",
            name="example",
            consent="IMPLICIT")
        ```

        ## Import

        ```sh
        $ pulumi import okta:auth/serverScope:ServerScope example &#60;auth server id&#62;/&#60;scope id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_server_id: Auth server ID
        :param pulumi.Input[str] consent: Indicates whether a consent dialog is needed for the scope. It can be set to `REQUIRED` or `IMPLICIT`. Default: `IMPLICIT`
        :param pulumi.Input[bool] default: A default scope will be returned in an access token when the client omits the scope parameter in a token request, provided this scope is allowed as part of the access policy rule.
        :param pulumi.Input[str] description: Description of the Auth Server Scope.
        :param pulumi.Input[str] display_name: Name of the end user displayed in a consent dialog box
        :param pulumi.Input[str] metadata_publish: Whether to publish metadata or not. It can be set to `ALL_CLIENTS` or `NO_CLIENTS`. Default: `ALL_CLIENTS`
        :param pulumi.Input[str] name: Auth server scope name
        :param pulumi.Input[bool] optional: Whether the scope optional
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerScopeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Authorization Server Scope. This resource allows you to create and configure an Authorization Server Scope.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.auth.ServerScope("example",
            auth_server_id="<auth server id>",
            metadata_publish="NO_CLIENTS",
            name="example",
            consent="IMPLICIT")
        ```

        ## Import

        ```sh
        $ pulumi import okta:auth/serverScope:ServerScope example &#60;auth server id&#62;/&#60;scope id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param ServerScopeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerScopeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_server_id: Optional[pulumi.Input[str]] = None,
                 consent: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 metadata_publish: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerScopeArgs.__new__(ServerScopeArgs)

            if auth_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'auth_server_id'")
            __props__.__dict__["auth_server_id"] = auth_server_id
            __props__.__dict__["consent"] = consent
            __props__.__dict__["default"] = default
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["metadata_publish"] = metadata_publish
            __props__.__dict__["name"] = name
            __props__.__dict__["optional"] = optional
            __props__.__dict__["system"] = None
        super(ServerScope, __self__).__init__(
            'okta:auth/serverScope:ServerScope',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_server_id: Optional[pulumi.Input[str]] = None,
            consent: Optional[pulumi.Input[str]] = None,
            default: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            metadata_publish: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            optional: Optional[pulumi.Input[bool]] = None,
            system: Optional[pulumi.Input[bool]] = None) -> 'ServerScope':
        """
        Get an existing ServerScope resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_server_id: Auth server ID
        :param pulumi.Input[str] consent: Indicates whether a consent dialog is needed for the scope. It can be set to `REQUIRED` or `IMPLICIT`. Default: `IMPLICIT`
        :param pulumi.Input[bool] default: A default scope will be returned in an access token when the client omits the scope parameter in a token request, provided this scope is allowed as part of the access policy rule.
        :param pulumi.Input[str] description: Description of the Auth Server Scope.
        :param pulumi.Input[str] display_name: Name of the end user displayed in a consent dialog box
        :param pulumi.Input[str] metadata_publish: Whether to publish metadata or not. It can be set to `ALL_CLIENTS` or `NO_CLIENTS`. Default: `ALL_CLIENTS`
        :param pulumi.Input[str] name: Auth server scope name
        :param pulumi.Input[bool] optional: Whether the scope optional
        :param pulumi.Input[bool] system: Whether Okta created the Scope
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerScopeState.__new__(_ServerScopeState)

        __props__.__dict__["auth_server_id"] = auth_server_id
        __props__.__dict__["consent"] = consent
        __props__.__dict__["default"] = default
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["metadata_publish"] = metadata_publish
        __props__.__dict__["name"] = name
        __props__.__dict__["optional"] = optional
        __props__.__dict__["system"] = system
        return ServerScope(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authServerId")
    def auth_server_id(self) -> pulumi.Output[str]:
        """
        Auth server ID
        """
        return pulumi.get(self, "auth_server_id")

    @property
    @pulumi.getter
    def consent(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates whether a consent dialog is needed for the scope. It can be set to `REQUIRED` or `IMPLICIT`. Default: `IMPLICIT`
        """
        return pulumi.get(self, "consent")

    @property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional[bool]]:
        """
        A default scope will be returned in an access token when the client omits the scope parameter in a token request, provided this scope is allowed as part of the access policy rule.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the Auth Server Scope.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the end user displayed in a consent dialog box
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="metadataPublish")
    def metadata_publish(self) -> pulumi.Output[Optional[str]]:
        """
        Whether to publish metadata or not. It can be set to `ALL_CLIENTS` or `NO_CLIENTS`. Default: `ALL_CLIENTS`
        """
        return pulumi.get(self, "metadata_publish")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Auth server scope name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the scope optional
        """
        return pulumi.get(self, "optional")

    @property
    @pulumi.getter
    def system(self) -> pulumi.Output[bool]:
        """
        Whether Okta created the Scope
        """
        return pulumi.get(self, "system")

