# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['EventHookVerificationArgs', 'EventHookVerification']

@pulumi.input_type
class EventHookVerificationArgs:
    def __init__(__self__, *,
                 event_hook_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a EventHookVerification resource.
        :param pulumi.Input[str] event_hook_id: Event hook ID
        """
        pulumi.set(__self__, "event_hook_id", event_hook_id)

    @property
    @pulumi.getter(name="eventHookId")
    def event_hook_id(self) -> pulumi.Input[str]:
        """
        Event hook ID
        """
        return pulumi.get(self, "event_hook_id")

    @event_hook_id.setter
    def event_hook_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_hook_id", value)


@pulumi.input_type
class _EventHookVerificationState:
    def __init__(__self__, *,
                 event_hook_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EventHookVerification resources.
        :param pulumi.Input[str] event_hook_id: Event hook ID
        """
        if event_hook_id is not None:
            pulumi.set(__self__, "event_hook_id", event_hook_id)

    @property
    @pulumi.getter(name="eventHookId")
    def event_hook_id(self) -> Optional[pulumi.Input[str]]:
        """
        Event hook ID
        """
        return pulumi.get(self, "event_hook_id")

    @event_hook_id.setter
    def event_hook_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_hook_id", value)


class EventHookVerification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_hook_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Verifies the Event Hook. The resource won't be created unless the URI provided in the event hook returns a valid JSON object with verification. See [Event Hooks](https://developer.okta.com/docs/concepts/event-hooks/#one-time-verification-request) documentation for details.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.EventHook("example",
            name="example",
            events=[
                "user.lifecycle.create",
                "user.lifecycle.delete.initiated",
            ],
            channel={
                "type": "HTTP",
                "version": "1.0.0",
                "uri": "https://example.com/test",
            },
            auth={
                "type": "HEADER",
                "key": "Authorization",
                "value": "123",
            })
        example_event_hook_verification = okta.EventHookVerification("example", event_hook_id=example.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] event_hook_id: Event hook ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventHookVerificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Verifies the Event Hook. The resource won't be created unless the URI provided in the event hook returns a valid JSON object with verification. See [Event Hooks](https://developer.okta.com/docs/concepts/event-hooks/#one-time-verification-request) documentation for details.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.EventHook("example",
            name="example",
            events=[
                "user.lifecycle.create",
                "user.lifecycle.delete.initiated",
            ],
            channel={
                "type": "HTTP",
                "version": "1.0.0",
                "uri": "https://example.com/test",
            },
            auth={
                "type": "HEADER",
                "key": "Authorization",
                "value": "123",
            })
        example_event_hook_verification = okta.EventHookVerification("example", event_hook_id=example.id)
        ```

        :param str resource_name: The name of the resource.
        :param EventHookVerificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventHookVerificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_hook_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventHookVerificationArgs.__new__(EventHookVerificationArgs)

            if event_hook_id is None and not opts.urn:
                raise TypeError("Missing required property 'event_hook_id'")
            __props__.__dict__["event_hook_id"] = event_hook_id
        super(EventHookVerification, __self__).__init__(
            'okta:index/eventHookVerification:EventHookVerification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            event_hook_id: Optional[pulumi.Input[str]] = None) -> 'EventHookVerification':
        """
        Get an existing EventHookVerification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] event_hook_id: Event hook ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventHookVerificationState.__new__(_EventHookVerificationState)

        __props__.__dict__["event_hook_id"] = event_hook_id
        return EventHookVerification(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="eventHookId")
    def event_hook_id(self) -> pulumi.Output[str]:
        """
        Event hook ID
        """
        return pulumi.get(self, "event_hook_id")

