# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'AppGroupAssignmentsGroup',
    'AppSignonPolicyRulePlatformInclude',
    'AppUserSchemaPropertyArrayOneOf',
    'AppUserSchemaPropertyOneOf',
    'CustomizedSigninPageContentSecurityPolicySetting',
    'CustomizedSigninPageWidgetCustomizations',
    'DomainDnsRecord',
    'EmailDomainDnsValidationRecord',
    'EmailSenderDnsRecord',
    'EventHookHeader',
    'GroupSchemaPropertyArrayOneOf',
    'GroupSchemaPropertyMasterOverridePriority',
    'GroupSchemaPropertyOneOf',
    'LogStreamSettings',
    'PolicyRuleProfileEnrollmentProfileAttribute',
    'PreviewSigninPageContentSecurityPolicySetting',
    'PreviewSigninPageWidgetCustomizations',
    'TemplateSmsTranslation',
    'UserSchemaPropertyArrayOneOf',
    'UserSchemaPropertyMasterOverridePriority',
    'UserSchemaPropertyOneOf',
    'GetAuthServerClaimsClaimResult',
    'GetBehavioursBehaviorResult',
    'GetBrandsBrandResult',
    'GetDefaultSigninPageContentSecurityPolicySettingResult',
    'GetDefaultSigninPageWidgetCustomizationsResult',
    'GetDomainDnsRecordResult',
    'GetEmailCustomizationsEmailCustomizationResult',
    'GetGroupsGroupResult',
    'GetLogStreamSettingsResult',
    'GetOrgMetadataDomainsResult',
    'GetOrgMetadataSettingsResult',
    'GetTemplatesEmailTemplateResult',
    'GetThemesThemeResult',
    'GetTrustedOriginsTrustedOriginResult',
    'GetUserSecurityQuestionsQuestionResult',
]

@pulumi.output_type
class AppGroupAssignmentsGroup(dict):
    def __init__(__self__, *,
                 id: str,
                 profile: str,
                 priority: Optional[int] = None):
        """
        :param str id: A group to associate with the application
        :param str profile: JSON document containing [application profile](https://developer.okta.com/docs/reference/api/apps/#profile-object)
        :param int priority: Priority of group assignment
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "profile", profile)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A group to associate with the application
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def profile(self) -> str:
        """
        JSON document containing [application profile](https://developer.okta.com/docs/reference/api/apps/#profile-object)
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority of group assignment
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class AppSignonPolicyRulePlatformInclude(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osExpression":
            suggest = "os_expression"
        elif key == "osType":
            suggest = "os_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSignonPolicyRulePlatformInclude. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSignonPolicyRulePlatformInclude.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSignonPolicyRulePlatformInclude.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_expression: Optional[str] = None,
                 os_type: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str os_expression: Only available with OTHER OS type
        """
        if os_expression is not None:
            pulumi.set(__self__, "os_expression", os_expression)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="osExpression")
    def os_expression(self) -> Optional[str]:
        """
        Only available with OTHER OS type
        """
        return pulumi.get(self, "os_expression")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class AppUserSchemaPropertyArrayOneOf(dict):
    def __init__(__self__, *,
                 const: str,
                 title: str):
        """
        :param str const: Value mapping to member of `array_enum`
        :param str title: Display name for the enum value.
        """
        pulumi.set(__self__, "const", const)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def const(self) -> str:
        """
        Value mapping to member of `array_enum`
        """
        return pulumi.get(self, "const")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Display name for the enum value.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class AppUserSchemaPropertyOneOf(dict):
    def __init__(__self__, *,
                 const: str,
                 title: str):
        """
        :param str const: Enum value
        :param str title: Enum title
        """
        pulumi.set(__self__, "const", const)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def const(self) -> str:
        """
        Enum value
        """
        return pulumi.get(self, "const")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Enum title
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class CustomizedSigninPageContentSecurityPolicySetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reportUri":
            suggest = "report_uri"
        elif key == "srcLists":
            suggest = "src_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomizedSigninPageContentSecurityPolicySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomizedSigninPageContentSecurityPolicySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomizedSigninPageContentSecurityPolicySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: Optional[str] = None,
                 report_uri: Optional[str] = None,
                 src_lists: Optional[Sequence[str]] = None):
        """
        :param str mode: enforced or report_only
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if report_uri is not None:
            pulumi.set(__self__, "report_uri", report_uri)
        if src_lists is not None:
            pulumi.set(__self__, "src_lists", src_lists)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        enforced or report_only
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="reportUri")
    def report_uri(self) -> Optional[str]:
        return pulumi.get(self, "report_uri")

    @property
    @pulumi.getter(name="srcLists")
    def src_lists(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "src_lists")


@pulumi.output_type
class CustomizedSigninPageWidgetCustomizations(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "widgetGeneration":
            suggest = "widget_generation"
        elif key == "authenticatorPageCustomLinkLabel":
            suggest = "authenticator_page_custom_link_label"
        elif key == "authenticatorPageCustomLinkUrl":
            suggest = "authenticator_page_custom_link_url"
        elif key == "classicRecoveryFlowEmailOrUsernameLabel":
            suggest = "classic_recovery_flow_email_or_username_label"
        elif key == "customLink1Label":
            suggest = "custom_link1_label"
        elif key == "customLink1Url":
            suggest = "custom_link1_url"
        elif key == "customLink2Label":
            suggest = "custom_link2_label"
        elif key == "customLink2Url":
            suggest = "custom_link2_url"
        elif key == "forgotPasswordLabel":
            suggest = "forgot_password_label"
        elif key == "forgotPasswordUrl":
            suggest = "forgot_password_url"
        elif key == "helpLabel":
            suggest = "help_label"
        elif key == "helpUrl":
            suggest = "help_url"
        elif key == "passwordInfoTip":
            suggest = "password_info_tip"
        elif key == "passwordLabel":
            suggest = "password_label"
        elif key == "showPasswordVisibilityToggle":
            suggest = "show_password_visibility_toggle"
        elif key == "showUserIdentifier":
            suggest = "show_user_identifier"
        elif key == "signInLabel":
            suggest = "sign_in_label"
        elif key == "unlockAccountLabel":
            suggest = "unlock_account_label"
        elif key == "unlockAccountUrl":
            suggest = "unlock_account_url"
        elif key == "usernameInfoTip":
            suggest = "username_info_tip"
        elif key == "usernameLabel":
            suggest = "username_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomizedSigninPageWidgetCustomizations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomizedSigninPageWidgetCustomizations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomizedSigninPageWidgetCustomizations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 widget_generation: str,
                 authenticator_page_custom_link_label: Optional[str] = None,
                 authenticator_page_custom_link_url: Optional[str] = None,
                 classic_recovery_flow_email_or_username_label: Optional[str] = None,
                 custom_link1_label: Optional[str] = None,
                 custom_link1_url: Optional[str] = None,
                 custom_link2_label: Optional[str] = None,
                 custom_link2_url: Optional[str] = None,
                 forgot_password_label: Optional[str] = None,
                 forgot_password_url: Optional[str] = None,
                 help_label: Optional[str] = None,
                 help_url: Optional[str] = None,
                 password_info_tip: Optional[str] = None,
                 password_label: Optional[str] = None,
                 show_password_visibility_toggle: Optional[bool] = None,
                 show_user_identifier: Optional[bool] = None,
                 sign_in_label: Optional[str] = None,
                 unlock_account_label: Optional[str] = None,
                 unlock_account_url: Optional[str] = None,
                 username_info_tip: Optional[str] = None,
                 username_label: Optional[str] = None):
        pulumi.set(__self__, "widget_generation", widget_generation)
        if authenticator_page_custom_link_label is not None:
            pulumi.set(__self__, "authenticator_page_custom_link_label", authenticator_page_custom_link_label)
        if authenticator_page_custom_link_url is not None:
            pulumi.set(__self__, "authenticator_page_custom_link_url", authenticator_page_custom_link_url)
        if classic_recovery_flow_email_or_username_label is not None:
            pulumi.set(__self__, "classic_recovery_flow_email_or_username_label", classic_recovery_flow_email_or_username_label)
        if custom_link1_label is not None:
            pulumi.set(__self__, "custom_link1_label", custom_link1_label)
        if custom_link1_url is not None:
            pulumi.set(__self__, "custom_link1_url", custom_link1_url)
        if custom_link2_label is not None:
            pulumi.set(__self__, "custom_link2_label", custom_link2_label)
        if custom_link2_url is not None:
            pulumi.set(__self__, "custom_link2_url", custom_link2_url)
        if forgot_password_label is not None:
            pulumi.set(__self__, "forgot_password_label", forgot_password_label)
        if forgot_password_url is not None:
            pulumi.set(__self__, "forgot_password_url", forgot_password_url)
        if help_label is not None:
            pulumi.set(__self__, "help_label", help_label)
        if help_url is not None:
            pulumi.set(__self__, "help_url", help_url)
        if password_info_tip is not None:
            pulumi.set(__self__, "password_info_tip", password_info_tip)
        if password_label is not None:
            pulumi.set(__self__, "password_label", password_label)
        if show_password_visibility_toggle is not None:
            pulumi.set(__self__, "show_password_visibility_toggle", show_password_visibility_toggle)
        if show_user_identifier is not None:
            pulumi.set(__self__, "show_user_identifier", show_user_identifier)
        if sign_in_label is not None:
            pulumi.set(__self__, "sign_in_label", sign_in_label)
        if unlock_account_label is not None:
            pulumi.set(__self__, "unlock_account_label", unlock_account_label)
        if unlock_account_url is not None:
            pulumi.set(__self__, "unlock_account_url", unlock_account_url)
        if username_info_tip is not None:
            pulumi.set(__self__, "username_info_tip", username_info_tip)
        if username_label is not None:
            pulumi.set(__self__, "username_label", username_label)

    @property
    @pulumi.getter(name="widgetGeneration")
    def widget_generation(self) -> str:
        return pulumi.get(self, "widget_generation")

    @property
    @pulumi.getter(name="authenticatorPageCustomLinkLabel")
    def authenticator_page_custom_link_label(self) -> Optional[str]:
        return pulumi.get(self, "authenticator_page_custom_link_label")

    @property
    @pulumi.getter(name="authenticatorPageCustomLinkUrl")
    def authenticator_page_custom_link_url(self) -> Optional[str]:
        return pulumi.get(self, "authenticator_page_custom_link_url")

    @property
    @pulumi.getter(name="classicRecoveryFlowEmailOrUsernameLabel")
    def classic_recovery_flow_email_or_username_label(self) -> Optional[str]:
        return pulumi.get(self, "classic_recovery_flow_email_or_username_label")

    @property
    @pulumi.getter(name="customLink1Label")
    def custom_link1_label(self) -> Optional[str]:
        return pulumi.get(self, "custom_link1_label")

    @property
    @pulumi.getter(name="customLink1Url")
    def custom_link1_url(self) -> Optional[str]:
        return pulumi.get(self, "custom_link1_url")

    @property
    @pulumi.getter(name="customLink2Label")
    def custom_link2_label(self) -> Optional[str]:
        return pulumi.get(self, "custom_link2_label")

    @property
    @pulumi.getter(name="customLink2Url")
    def custom_link2_url(self) -> Optional[str]:
        return pulumi.get(self, "custom_link2_url")

    @property
    @pulumi.getter(name="forgotPasswordLabel")
    def forgot_password_label(self) -> Optional[str]:
        return pulumi.get(self, "forgot_password_label")

    @property
    @pulumi.getter(name="forgotPasswordUrl")
    def forgot_password_url(self) -> Optional[str]:
        return pulumi.get(self, "forgot_password_url")

    @property
    @pulumi.getter(name="helpLabel")
    def help_label(self) -> Optional[str]:
        return pulumi.get(self, "help_label")

    @property
    @pulumi.getter(name="helpUrl")
    def help_url(self) -> Optional[str]:
        return pulumi.get(self, "help_url")

    @property
    @pulumi.getter(name="passwordInfoTip")
    def password_info_tip(self) -> Optional[str]:
        return pulumi.get(self, "password_info_tip")

    @property
    @pulumi.getter(name="passwordLabel")
    def password_label(self) -> Optional[str]:
        return pulumi.get(self, "password_label")

    @property
    @pulumi.getter(name="showPasswordVisibilityToggle")
    def show_password_visibility_toggle(self) -> Optional[bool]:
        return pulumi.get(self, "show_password_visibility_toggle")

    @property
    @pulumi.getter(name="showUserIdentifier")
    def show_user_identifier(self) -> Optional[bool]:
        return pulumi.get(self, "show_user_identifier")

    @property
    @pulumi.getter(name="signInLabel")
    def sign_in_label(self) -> Optional[str]:
        return pulumi.get(self, "sign_in_label")

    @property
    @pulumi.getter(name="unlockAccountLabel")
    def unlock_account_label(self) -> Optional[str]:
        return pulumi.get(self, "unlock_account_label")

    @property
    @pulumi.getter(name="unlockAccountUrl")
    def unlock_account_url(self) -> Optional[str]:
        return pulumi.get(self, "unlock_account_url")

    @property
    @pulumi.getter(name="usernameInfoTip")
    def username_info_tip(self) -> Optional[str]:
        return pulumi.get(self, "username_info_tip")

    @property
    @pulumi.getter(name="usernameLabel")
    def username_label(self) -> Optional[str]:
        return pulumi.get(self, "username_label")


@pulumi.output_type
class DomainDnsRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordType":
            suggest = "record_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDnsRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDnsRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDnsRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration: Optional[str] = None,
                 fqdn: Optional[str] = None,
                 record_type: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        :param str expiration: TXT record expiration
        :param str fqdn: DNS record name
        :param str record_type: Record type can be TXT or CNAME
        :param Sequence[str] values: DNS verification value
        """
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[str]:
        """
        TXT record expiration
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        DNS record name
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[str]:
        """
        Record type can be TXT or CNAME
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        DNS verification value
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EmailDomainDnsValidationRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordType":
            suggest = "record_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailDomainDnsValidationRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailDomainDnsValidationRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailDomainDnsValidationRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration: Optional[str] = None,
                 fqdn: Optional[str] = None,
                 record_type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str expiration: DNS TXT record expiration
        :param str fqdn: DNS record name
        :param str record_type: Record type can be TXT or cname
        :param str value: DNS record value
        """
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This field has been removed in the newest go sdk version and has become noop""")
    def expiration(self) -> Optional[str]:
        """
        DNS TXT record expiration
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        DNS record name
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[str]:
        """
        Record type can be TXT or cname
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        DNS record value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EmailSenderDnsRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordType":
            suggest = "record_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailSenderDnsRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailSenderDnsRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailSenderDnsRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[str] = None,
                 record_type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str fqdn: DNS record name
        :param str record_type: Record type can be TXT or CNAME
        :param str value: DNS verification value
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        DNS record name
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[str]:
        """
        Record type can be TXT or CNAME
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        DNS verification value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventHookHeader(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GroupSchemaPropertyArrayOneOf(dict):
    def __init__(__self__, *,
                 const: str,
                 title: str):
        """
        :param str const: Value mapping to member of `array_enum`
        :param str title: Display name for the enum value.
        """
        pulumi.set(__self__, "const", const)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def const(self) -> str:
        """
        Value mapping to member of `array_enum`
        """
        return pulumi.get(self, "const")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Display name for the enum value.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GroupSchemaPropertyMasterOverridePriority(dict):
    def __init__(__self__, *,
                 value: str,
                 type: Optional[str] = None):
        pulumi.set(__self__, "value", value)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class GroupSchemaPropertyOneOf(dict):
    def __init__(__self__, *,
                 const: str,
                 title: str):
        """
        :param str const: Enum value
        :param str title: Enum title
        """
        pulumi.set(__self__, "const", const)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def const(self) -> str:
        """
        Enum value
        """
        return pulumi.get(self, "const")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Enum title
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class LogStreamSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "eventSourceName":
            suggest = "event_source_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogStreamSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogStreamSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogStreamSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: Optional[str] = None,
                 edition: Optional[str] = None,
                 event_source_name: Optional[str] = None,
                 host: Optional[str] = None,
                 region: Optional[str] = None,
                 token: Optional[str] = None):
        """
        :param str account_id: AWS account ID. Required only for 'aws_eventbridge' type
        :param str edition: Edition of the Splunk Cloud instance. Could be one of: 'aws', 'aws*govcloud', 'gcp'. Required only for 'splunk*cloud_logstreaming' type
        :param str event_source_name: An alphanumeric name (no spaces) to identify this event source in AWS EventBridge. Required only for 'aws_eventbridge' type
        :param str host: The domain name for Splunk Cloud instance. Don't include http or https in the string. For example: 'acme.splunkcloud.com'. Required only for 'splunk*cloud*logstreaming' type
        :param str region: The destination AWS region where event source is located. Required only for 'aws_eventbridge' type
        :param str token: The HEC token for your Splunk Cloud HTTP Event Collector. Required only for 'splunk*cloud*logstreaming' type
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if event_source_name is not None:
            pulumi.set(__self__, "event_source_name", event_source_name)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        AWS account ID. Required only for 'aws_eventbridge' type
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def edition(self) -> Optional[str]:
        """
        Edition of the Splunk Cloud instance. Could be one of: 'aws', 'aws*govcloud', 'gcp'. Required only for 'splunk*cloud_logstreaming' type
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="eventSourceName")
    def event_source_name(self) -> Optional[str]:
        """
        An alphanumeric name (no spaces) to identify this event source in AWS EventBridge. Required only for 'aws_eventbridge' type
        """
        return pulumi.get(self, "event_source_name")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        The domain name for Splunk Cloud instance. Don't include http or https in the string. For example: 'acme.splunkcloud.com'. Required only for 'splunk*cloud*logstreaming' type
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The destination AWS region where event source is located. Required only for 'aws_eventbridge' type
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        The HEC token for your Splunk Cloud HTTP Event Collector. Required only for 'splunk*cloud*logstreaming' type
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class PolicyRuleProfileEnrollmentProfileAttribute(dict):
    def __init__(__self__, *,
                 label: str,
                 name: str,
                 required: Optional[bool] = None):
        """
        :param str label: A display-friendly label for this property
        :param str name: The name of a User Profile property
        :param bool required: Indicates if this property is required for enrollment
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "name", name)
        if required is not None:
            pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        A display-friendly label for this property
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of a User Profile property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def required(self) -> Optional[bool]:
        """
        Indicates if this property is required for enrollment
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class PreviewSigninPageContentSecurityPolicySetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reportUri":
            suggest = "report_uri"
        elif key == "srcLists":
            suggest = "src_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PreviewSigninPageContentSecurityPolicySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PreviewSigninPageContentSecurityPolicySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PreviewSigninPageContentSecurityPolicySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: Optional[str] = None,
                 report_uri: Optional[str] = None,
                 src_lists: Optional[Sequence[str]] = None):
        """
        :param str mode: enforced or report_only
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if report_uri is not None:
            pulumi.set(__self__, "report_uri", report_uri)
        if src_lists is not None:
            pulumi.set(__self__, "src_lists", src_lists)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        enforced or report_only
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="reportUri")
    def report_uri(self) -> Optional[str]:
        return pulumi.get(self, "report_uri")

    @property
    @pulumi.getter(name="srcLists")
    def src_lists(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "src_lists")


@pulumi.output_type
class PreviewSigninPageWidgetCustomizations(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "widgetGeneration":
            suggest = "widget_generation"
        elif key == "authenticatorPageCustomLinkLabel":
            suggest = "authenticator_page_custom_link_label"
        elif key == "authenticatorPageCustomLinkUrl":
            suggest = "authenticator_page_custom_link_url"
        elif key == "classicRecoveryFlowEmailOrUsernameLabel":
            suggest = "classic_recovery_flow_email_or_username_label"
        elif key == "customLink1Label":
            suggest = "custom_link1_label"
        elif key == "customLink1Url":
            suggest = "custom_link1_url"
        elif key == "customLink2Label":
            suggest = "custom_link2_label"
        elif key == "customLink2Url":
            suggest = "custom_link2_url"
        elif key == "forgotPasswordLabel":
            suggest = "forgot_password_label"
        elif key == "forgotPasswordUrl":
            suggest = "forgot_password_url"
        elif key == "helpLabel":
            suggest = "help_label"
        elif key == "helpUrl":
            suggest = "help_url"
        elif key == "passwordInfoTip":
            suggest = "password_info_tip"
        elif key == "passwordLabel":
            suggest = "password_label"
        elif key == "showPasswordVisibilityToggle":
            suggest = "show_password_visibility_toggle"
        elif key == "showUserIdentifier":
            suggest = "show_user_identifier"
        elif key == "signInLabel":
            suggest = "sign_in_label"
        elif key == "unlockAccountLabel":
            suggest = "unlock_account_label"
        elif key == "unlockAccountUrl":
            suggest = "unlock_account_url"
        elif key == "usernameInfoTip":
            suggest = "username_info_tip"
        elif key == "usernameLabel":
            suggest = "username_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PreviewSigninPageWidgetCustomizations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PreviewSigninPageWidgetCustomizations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PreviewSigninPageWidgetCustomizations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 widget_generation: str,
                 authenticator_page_custom_link_label: Optional[str] = None,
                 authenticator_page_custom_link_url: Optional[str] = None,
                 classic_recovery_flow_email_or_username_label: Optional[str] = None,
                 custom_link1_label: Optional[str] = None,
                 custom_link1_url: Optional[str] = None,
                 custom_link2_label: Optional[str] = None,
                 custom_link2_url: Optional[str] = None,
                 forgot_password_label: Optional[str] = None,
                 forgot_password_url: Optional[str] = None,
                 help_label: Optional[str] = None,
                 help_url: Optional[str] = None,
                 password_info_tip: Optional[str] = None,
                 password_label: Optional[str] = None,
                 show_password_visibility_toggle: Optional[bool] = None,
                 show_user_identifier: Optional[bool] = None,
                 sign_in_label: Optional[str] = None,
                 unlock_account_label: Optional[str] = None,
                 unlock_account_url: Optional[str] = None,
                 username_info_tip: Optional[str] = None,
                 username_label: Optional[str] = None):
        pulumi.set(__self__, "widget_generation", widget_generation)
        if authenticator_page_custom_link_label is not None:
            pulumi.set(__self__, "authenticator_page_custom_link_label", authenticator_page_custom_link_label)
        if authenticator_page_custom_link_url is not None:
            pulumi.set(__self__, "authenticator_page_custom_link_url", authenticator_page_custom_link_url)
        if classic_recovery_flow_email_or_username_label is not None:
            pulumi.set(__self__, "classic_recovery_flow_email_or_username_label", classic_recovery_flow_email_or_username_label)
        if custom_link1_label is not None:
            pulumi.set(__self__, "custom_link1_label", custom_link1_label)
        if custom_link1_url is not None:
            pulumi.set(__self__, "custom_link1_url", custom_link1_url)
        if custom_link2_label is not None:
            pulumi.set(__self__, "custom_link2_label", custom_link2_label)
        if custom_link2_url is not None:
            pulumi.set(__self__, "custom_link2_url", custom_link2_url)
        if forgot_password_label is not None:
            pulumi.set(__self__, "forgot_password_label", forgot_password_label)
        if forgot_password_url is not None:
            pulumi.set(__self__, "forgot_password_url", forgot_password_url)
        if help_label is not None:
            pulumi.set(__self__, "help_label", help_label)
        if help_url is not None:
            pulumi.set(__self__, "help_url", help_url)
        if password_info_tip is not None:
            pulumi.set(__self__, "password_info_tip", password_info_tip)
        if password_label is not None:
            pulumi.set(__self__, "password_label", password_label)
        if show_password_visibility_toggle is not None:
            pulumi.set(__self__, "show_password_visibility_toggle", show_password_visibility_toggle)
        if show_user_identifier is not None:
            pulumi.set(__self__, "show_user_identifier", show_user_identifier)
        if sign_in_label is not None:
            pulumi.set(__self__, "sign_in_label", sign_in_label)
        if unlock_account_label is not None:
            pulumi.set(__self__, "unlock_account_label", unlock_account_label)
        if unlock_account_url is not None:
            pulumi.set(__self__, "unlock_account_url", unlock_account_url)
        if username_info_tip is not None:
            pulumi.set(__self__, "username_info_tip", username_info_tip)
        if username_label is not None:
            pulumi.set(__self__, "username_label", username_label)

    @property
    @pulumi.getter(name="widgetGeneration")
    def widget_generation(self) -> str:
        return pulumi.get(self, "widget_generation")

    @property
    @pulumi.getter(name="authenticatorPageCustomLinkLabel")
    def authenticator_page_custom_link_label(self) -> Optional[str]:
        return pulumi.get(self, "authenticator_page_custom_link_label")

    @property
    @pulumi.getter(name="authenticatorPageCustomLinkUrl")
    def authenticator_page_custom_link_url(self) -> Optional[str]:
        return pulumi.get(self, "authenticator_page_custom_link_url")

    @property
    @pulumi.getter(name="classicRecoveryFlowEmailOrUsernameLabel")
    def classic_recovery_flow_email_or_username_label(self) -> Optional[str]:
        return pulumi.get(self, "classic_recovery_flow_email_or_username_label")

    @property
    @pulumi.getter(name="customLink1Label")
    def custom_link1_label(self) -> Optional[str]:
        return pulumi.get(self, "custom_link1_label")

    @property
    @pulumi.getter(name="customLink1Url")
    def custom_link1_url(self) -> Optional[str]:
        return pulumi.get(self, "custom_link1_url")

    @property
    @pulumi.getter(name="customLink2Label")
    def custom_link2_label(self) -> Optional[str]:
        return pulumi.get(self, "custom_link2_label")

    @property
    @pulumi.getter(name="customLink2Url")
    def custom_link2_url(self) -> Optional[str]:
        return pulumi.get(self, "custom_link2_url")

    @property
    @pulumi.getter(name="forgotPasswordLabel")
    def forgot_password_label(self) -> Optional[str]:
        return pulumi.get(self, "forgot_password_label")

    @property
    @pulumi.getter(name="forgotPasswordUrl")
    def forgot_password_url(self) -> Optional[str]:
        return pulumi.get(self, "forgot_password_url")

    @property
    @pulumi.getter(name="helpLabel")
    def help_label(self) -> Optional[str]:
        return pulumi.get(self, "help_label")

    @property
    @pulumi.getter(name="helpUrl")
    def help_url(self) -> Optional[str]:
        return pulumi.get(self, "help_url")

    @property
    @pulumi.getter(name="passwordInfoTip")
    def password_info_tip(self) -> Optional[str]:
        return pulumi.get(self, "password_info_tip")

    @property
    @pulumi.getter(name="passwordLabel")
    def password_label(self) -> Optional[str]:
        return pulumi.get(self, "password_label")

    @property
    @pulumi.getter(name="showPasswordVisibilityToggle")
    def show_password_visibility_toggle(self) -> Optional[bool]:
        return pulumi.get(self, "show_password_visibility_toggle")

    @property
    @pulumi.getter(name="showUserIdentifier")
    def show_user_identifier(self) -> Optional[bool]:
        return pulumi.get(self, "show_user_identifier")

    @property
    @pulumi.getter(name="signInLabel")
    def sign_in_label(self) -> Optional[str]:
        return pulumi.get(self, "sign_in_label")

    @property
    @pulumi.getter(name="unlockAccountLabel")
    def unlock_account_label(self) -> Optional[str]:
        return pulumi.get(self, "unlock_account_label")

    @property
    @pulumi.getter(name="unlockAccountUrl")
    def unlock_account_url(self) -> Optional[str]:
        return pulumi.get(self, "unlock_account_url")

    @property
    @pulumi.getter(name="usernameInfoTip")
    def username_info_tip(self) -> Optional[str]:
        return pulumi.get(self, "username_info_tip")

    @property
    @pulumi.getter(name="usernameLabel")
    def username_label(self) -> Optional[str]:
        return pulumi.get(self, "username_label")


@pulumi.output_type
class TemplateSmsTranslation(dict):
    def __init__(__self__, *,
                 language: str,
                 template: str):
        """
        :param str language: The language to map the template to.
        :param str template: The SMS message.
        """
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def language(self) -> str:
        """
        The language to map the template to.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def template(self) -> str:
        """
        The SMS message.
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class UserSchemaPropertyArrayOneOf(dict):
    def __init__(__self__, *,
                 const: str,
                 title: str):
        """
        :param str const: Value mapping to member of `array_enum`
        :param str title: Display name for the enum value.
        """
        pulumi.set(__self__, "const", const)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def const(self) -> str:
        """
        Value mapping to member of `array_enum`
        """
        return pulumi.get(self, "const")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Display name for the enum value.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class UserSchemaPropertyMasterOverridePriority(dict):
    def __init__(__self__, *,
                 value: str,
                 type: Optional[str] = None):
        pulumi.set(__self__, "value", value)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class UserSchemaPropertyOneOf(dict):
    def __init__(__self__, *,
                 const: str,
                 title: str):
        """
        :param str const: Enum value
        :param str title: Enum title
        """
        pulumi.set(__self__, "const", const)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def const(self) -> str:
        """
        Enum value
        """
        return pulumi.get(self, "const")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Enum title
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GetAuthServerClaimsClaimResult(dict):
    def __init__(__self__, *,
                 always_include_in_token: bool,
                 claim_type: str,
                 id: str,
                 name: str,
                 scopes: Sequence[str],
                 status: str,
                 value: str,
                 value_type: str):
        """
        :param bool always_include_in_token: Specifies whether to include Claims in the token.
        :param str claim_type: Specifies whether the Claim is for an access token (`RESOURCE`) or ID token (`IDENTITY`).
        :param str id: ID of the claim.
        :param str name: Name of the claim.
        :param Sequence[str] scopes: Specifies the scopes for this Claim.
        :param str status: Status of the claim.
        :param str value: Value of the claim.
        :param str value_type: Specifies whether the Claim is an Okta EL expression (`EXPRESSION`), a set of groups (`GROUPS`), or a system claim (`SYSTEM`)
        """
        pulumi.set(__self__, "always_include_in_token", always_include_in_token)
        pulumi.set(__self__, "claim_type", claim_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scopes", scopes)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="alwaysIncludeInToken")
    def always_include_in_token(self) -> bool:
        """
        Specifies whether to include Claims in the token.
        """
        return pulumi.get(self, "always_include_in_token")

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> str:
        """
        Specifies whether the Claim is for an access token (`RESOURCE`) or ID token (`IDENTITY`).
        """
        return pulumi.get(self, "claim_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the claim.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the claim.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence[str]:
        """
        Specifies the scopes for this Claim.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the claim.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the claim.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        Specifies whether the Claim is an Okta EL expression (`EXPRESSION`), a set of groups (`GROUPS`), or a system claim (`SYSTEM`)
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetBehavioursBehaviorResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 settings: Mapping[str, str],
                 status: str,
                 type: str):
        """
        :param str id: Behavior ID.
        :param str name: Behavior name.
        :param Mapping[str, str] settings: Map of behavior settings.
        :param str status: Behavior status.
        :param str type: Behavior type.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Behavior ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Behavior name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def settings(self) -> Mapping[str, str]:
        """
        Map of behavior settings.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Behavior status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Behavior type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetBrandsBrandResult(dict):
    def __init__(__self__, *,
                 custom_privacy_policy_url: str,
                 id: str,
                 links: str,
                 name: str,
                 remove_powered_by_okta: bool):
        """
        :param str custom_privacy_policy_url: Custom privacy policy URL
        :param str id: The ID of the Brand
        :param str links: Link relations for this object - JSON HAL - Discoverable resources related to the brand
        :param str name: Brand name
        :param bool remove_powered_by_okta: Removes "Powered by Okta" from the Okta-hosted sign-in page and "© 2021 Okta, Inc." from the Okta End-User Dashboard
        """
        pulumi.set(__self__, "custom_privacy_policy_url", custom_privacy_policy_url)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "links", links)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "remove_powered_by_okta", remove_powered_by_okta)

    @property
    @pulumi.getter(name="customPrivacyPolicyUrl")
    def custom_privacy_policy_url(self) -> str:
        """
        Custom privacy policy URL
        """
        return pulumi.get(self, "custom_privacy_policy_url")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Brand
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def links(self) -> str:
        """
        Link relations for this object - JSON HAL - Discoverable resources related to the brand
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Brand name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="removePoweredByOkta")
    def remove_powered_by_okta(self) -> bool:
        """
        Removes "Powered by Okta" from the Okta-hosted sign-in page and "© 2021 Okta, Inc." from the Okta End-User Dashboard
        """
        return pulumi.get(self, "remove_powered_by_okta")


@pulumi.output_type
class GetDefaultSigninPageContentSecurityPolicySettingResult(dict):
    def __init__(__self__, *,
                 mode: str,
                 report_uri: str,
                 src_lists: Sequence[str]):
        """
        :param str mode: enforced or report_only
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "report_uri", report_uri)
        pulumi.set(__self__, "src_lists", src_lists)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        enforced or report_only
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="reportUri")
    def report_uri(self) -> str:
        return pulumi.get(self, "report_uri")

    @property
    @pulumi.getter(name="srcLists")
    def src_lists(self) -> Sequence[str]:
        return pulumi.get(self, "src_lists")


@pulumi.output_type
class GetDefaultSigninPageWidgetCustomizationsResult(dict):
    def __init__(__self__, *,
                 authenticator_page_custom_link_label: str,
                 authenticator_page_custom_link_url: str,
                 classic_recovery_flow_email_or_username_label: str,
                 custom_link1_label: str,
                 custom_link1_url: str,
                 custom_link2_label: str,
                 custom_link2_url: str,
                 forgot_password_label: str,
                 forgot_password_url: str,
                 help_label: str,
                 help_url: str,
                 password_info_tip: str,
                 password_label: str,
                 show_password_visibility_toggle: bool,
                 show_user_identifier: bool,
                 sign_in_label: str,
                 unlock_account_label: str,
                 unlock_account_url: str,
                 username_info_tip: str,
                 username_label: str,
                 widget_generation: str):
        pulumi.set(__self__, "authenticator_page_custom_link_label", authenticator_page_custom_link_label)
        pulumi.set(__self__, "authenticator_page_custom_link_url", authenticator_page_custom_link_url)
        pulumi.set(__self__, "classic_recovery_flow_email_or_username_label", classic_recovery_flow_email_or_username_label)
        pulumi.set(__self__, "custom_link1_label", custom_link1_label)
        pulumi.set(__self__, "custom_link1_url", custom_link1_url)
        pulumi.set(__self__, "custom_link2_label", custom_link2_label)
        pulumi.set(__self__, "custom_link2_url", custom_link2_url)
        pulumi.set(__self__, "forgot_password_label", forgot_password_label)
        pulumi.set(__self__, "forgot_password_url", forgot_password_url)
        pulumi.set(__self__, "help_label", help_label)
        pulumi.set(__self__, "help_url", help_url)
        pulumi.set(__self__, "password_info_tip", password_info_tip)
        pulumi.set(__self__, "password_label", password_label)
        pulumi.set(__self__, "show_password_visibility_toggle", show_password_visibility_toggle)
        pulumi.set(__self__, "show_user_identifier", show_user_identifier)
        pulumi.set(__self__, "sign_in_label", sign_in_label)
        pulumi.set(__self__, "unlock_account_label", unlock_account_label)
        pulumi.set(__self__, "unlock_account_url", unlock_account_url)
        pulumi.set(__self__, "username_info_tip", username_info_tip)
        pulumi.set(__self__, "username_label", username_label)
        pulumi.set(__self__, "widget_generation", widget_generation)

    @property
    @pulumi.getter(name="authenticatorPageCustomLinkLabel")
    def authenticator_page_custom_link_label(self) -> str:
        return pulumi.get(self, "authenticator_page_custom_link_label")

    @property
    @pulumi.getter(name="authenticatorPageCustomLinkUrl")
    def authenticator_page_custom_link_url(self) -> str:
        return pulumi.get(self, "authenticator_page_custom_link_url")

    @property
    @pulumi.getter(name="classicRecoveryFlowEmailOrUsernameLabel")
    def classic_recovery_flow_email_or_username_label(self) -> str:
        return pulumi.get(self, "classic_recovery_flow_email_or_username_label")

    @property
    @pulumi.getter(name="customLink1Label")
    def custom_link1_label(self) -> str:
        return pulumi.get(self, "custom_link1_label")

    @property
    @pulumi.getter(name="customLink1Url")
    def custom_link1_url(self) -> str:
        return pulumi.get(self, "custom_link1_url")

    @property
    @pulumi.getter(name="customLink2Label")
    def custom_link2_label(self) -> str:
        return pulumi.get(self, "custom_link2_label")

    @property
    @pulumi.getter(name="customLink2Url")
    def custom_link2_url(self) -> str:
        return pulumi.get(self, "custom_link2_url")

    @property
    @pulumi.getter(name="forgotPasswordLabel")
    def forgot_password_label(self) -> str:
        return pulumi.get(self, "forgot_password_label")

    @property
    @pulumi.getter(name="forgotPasswordUrl")
    def forgot_password_url(self) -> str:
        return pulumi.get(self, "forgot_password_url")

    @property
    @pulumi.getter(name="helpLabel")
    def help_label(self) -> str:
        return pulumi.get(self, "help_label")

    @property
    @pulumi.getter(name="helpUrl")
    def help_url(self) -> str:
        return pulumi.get(self, "help_url")

    @property
    @pulumi.getter(name="passwordInfoTip")
    def password_info_tip(self) -> str:
        return pulumi.get(self, "password_info_tip")

    @property
    @pulumi.getter(name="passwordLabel")
    def password_label(self) -> str:
        return pulumi.get(self, "password_label")

    @property
    @pulumi.getter(name="showPasswordVisibilityToggle")
    def show_password_visibility_toggle(self) -> bool:
        return pulumi.get(self, "show_password_visibility_toggle")

    @property
    @pulumi.getter(name="showUserIdentifier")
    def show_user_identifier(self) -> bool:
        return pulumi.get(self, "show_user_identifier")

    @property
    @pulumi.getter(name="signInLabel")
    def sign_in_label(self) -> str:
        return pulumi.get(self, "sign_in_label")

    @property
    @pulumi.getter(name="unlockAccountLabel")
    def unlock_account_label(self) -> str:
        return pulumi.get(self, "unlock_account_label")

    @property
    @pulumi.getter(name="unlockAccountUrl")
    def unlock_account_url(self) -> str:
        return pulumi.get(self, "unlock_account_url")

    @property
    @pulumi.getter(name="usernameInfoTip")
    def username_info_tip(self) -> str:
        return pulumi.get(self, "username_info_tip")

    @property
    @pulumi.getter(name="usernameLabel")
    def username_label(self) -> str:
        return pulumi.get(self, "username_label")

    @property
    @pulumi.getter(name="widgetGeneration")
    def widget_generation(self) -> str:
        return pulumi.get(self, "widget_generation")


@pulumi.output_type
class GetDomainDnsRecordResult(dict):
    def __init__(__self__, *,
                 expiration: str,
                 fqdn: str,
                 record_type: str,
                 values: Sequence[str]):
        """
        :param str expiration: TXT record expiration
        :param str fqdn: DNS record name
        :param str record_type: Record type can be TXT or CNAME
        :param Sequence[str] values: DNS verification value
        """
        pulumi.set(__self__, "expiration", expiration)
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "record_type", record_type)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def expiration(self) -> str:
        """
        TXT record expiration
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        DNS record name
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> str:
        """
        Record type can be TXT or CNAME
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        DNS verification value
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetEmailCustomizationsEmailCustomizationResult(dict):
    def __init__(__self__, *,
                 body: str,
                 id: str,
                 is_default: bool,
                 language: str,
                 links: str,
                 subject: str):
        """
        :param str body: The body of the customization
        :param str id: The ID of the customization
        :param bool is_default: Whether the customization is the default
        :param str language: The language supported by the customization
        :param str links: Link relations for this object - JSON HAL - Discoverable resources related to the email template
        :param str subject: The subject of the customization
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "links", links)
        pulumi.set(__self__, "subject", subject)

    @property
    @pulumi.getter
    def body(self) -> str:
        """
        The body of the customization
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the customization
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Whether the customization is the default
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def language(self) -> str:
        """
        The language supported by the customization
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def links(self) -> str:
        """
        Link relations for this object - JSON HAL - Discoverable resources related to the email template
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        The subject of the customization
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class GetGroupsGroupResult(dict):
    def __init__(__self__, *,
                 custom_profile_attributes: str,
                 description: str,
                 id: str,
                 name: str,
                 type: str):
        """
        :param str custom_profile_attributes: Raw JSON containing all custom profile attributes. Likely only useful on groups of type
        :param str description: Group description.
        :param str id: Group ID.
        :param str name: Group name.
        :param str type: Group type.
        """
        pulumi.set(__self__, "custom_profile_attributes", custom_profile_attributes)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="customProfileAttributes")
    def custom_profile_attributes(self) -> str:
        """
        Raw JSON containing all custom profile attributes. Likely only useful on groups of type
        """
        return pulumi.get(self, "custom_profile_attributes")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Group description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Group ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Group type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLogStreamSettingsResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 edition: str,
                 event_source_name: str,
                 host: str,
                 region: str,
                 token: str):
        """
        :param str account_id: AWS account ID. Required only for 'aws_eventbridge' type
        :param str edition: Edition of the Splunk Cloud instance. Could be one of: 'aws', 'aws*govcloud', 'gcp'. Required only for 'splunk*cloud_logstreaming' type
        :param str event_source_name: An alphanumeric name (no spaces) to identify this event source in AWS EventBridge. Required only for 'aws_eventbridge' type
        :param str host: The domain name for Splunk Cloud instance. Don't include http or https in the string. For example: 'acme.splunkcloud.com'. Required only for 'splunk*cloud*logstreaming' type
        :param str region: The destination AWS region where event source is located. Required only for 'aws_eventbridge' type
        :param str token: The HEC token for your Splunk Cloud HTTP Event Collector. Required only for 'splunk*cloud*logstreaming' type
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "event_source_name", event_source_name)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        AWS account ID. Required only for 'aws_eventbridge' type
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def edition(self) -> str:
        """
        Edition of the Splunk Cloud instance. Could be one of: 'aws', 'aws*govcloud', 'gcp'. Required only for 'splunk*cloud_logstreaming' type
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="eventSourceName")
    def event_source_name(self) -> str:
        """
        An alphanumeric name (no spaces) to identify this event source in AWS EventBridge. Required only for 'aws_eventbridge' type
        """
        return pulumi.get(self, "event_source_name")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The domain name for Splunk Cloud instance. Don't include http or https in the string. For example: 'acme.splunkcloud.com'. Required only for 'splunk*cloud*logstreaming' type
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The destination AWS region where event source is located. Required only for 'aws_eventbridge' type
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The HEC token for your Splunk Cloud HTTP Event Collector. Required only for 'splunk*cloud*logstreaming' type
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GetOrgMetadataDomainsResult(dict):
    def __init__(__self__, *,
                 alternate: str,
                 organization: str):
        """
        :param str alternate: Custom Domain Org URI
        :param str organization: Standard Org URI
        """
        pulumi.set(__self__, "alternate", alternate)
        pulumi.set(__self__, "organization", organization)

    @property
    @pulumi.getter
    def alternate(self) -> str:
        """
        Custom Domain Org URI
        """
        return pulumi.get(self, "alternate")

    @property
    @pulumi.getter
    def organization(self) -> str:
        """
        Standard Org URI
        """
        return pulumi.get(self, "organization")


@pulumi.output_type
class GetOrgMetadataSettingsResult(dict):
    def __init__(__self__, *,
                 analytics_collection_enabled: bool,
                 bug_reporting_enabled: bool,
                 om_enabled: bool):
        """
        :param bool om_enabled: Whether the legacy Okta Mobile application is enabled for the org
        """
        pulumi.set(__self__, "analytics_collection_enabled", analytics_collection_enabled)
        pulumi.set(__self__, "bug_reporting_enabled", bug_reporting_enabled)
        pulumi.set(__self__, "om_enabled", om_enabled)

    @property
    @pulumi.getter(name="analyticsCollectionEnabled")
    def analytics_collection_enabled(self) -> bool:
        return pulumi.get(self, "analytics_collection_enabled")

    @property
    @pulumi.getter(name="bugReportingEnabled")
    def bug_reporting_enabled(self) -> bool:
        return pulumi.get(self, "bug_reporting_enabled")

    @property
    @pulumi.getter(name="omEnabled")
    def om_enabled(self) -> bool:
        """
        Whether the legacy Okta Mobile application is enabled for the org
        """
        return pulumi.get(self, "om_enabled")


@pulumi.output_type
class GetTemplatesEmailTemplateResult(dict):
    def __init__(__self__, *,
                 links: str,
                 name: str):
        """
        :param str links: Link relations for this object - JSON HAL - Discoverable resources related to the email template
        :param str name: The name of the email template
        """
        pulumi.set(__self__, "links", links)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def links(self) -> str:
        """
        Link relations for this object - JSON HAL - Discoverable resources related to the email template
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the email template
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetThemesThemeResult(dict):
    def __init__(__self__, *,
                 background_image_url: str,
                 email_template_touch_point_variant: str,
                 end_user_dashboard_touch_point_variant: str,
                 error_page_touch_point_variant: str,
                 favicon_url: str,
                 id: str,
                 links: str,
                 logo_url: str,
                 primary_color_contrast_hex: str,
                 primary_color_hex: str,
                 secondary_color_contrast_hex: str,
                 secondary_color_hex: str,
                 sign_in_page_touch_point_variant: str):
        """
        :param str background_image_url: Background image URL
        :param str email_template_touch_point_variant: Variant for email templates (`OKTA_DEFAULT`, `FULL_THEME`)
        :param str end_user_dashboard_touch_point_variant: Variant for the Okta End-User Dashboard (`OKTA_DEFAULT`, `WHITE_LOGO_BACKGROUND`, `FULL_THEME`, `LOGO_ON_FULL_WHITE_BACKGROUND`)
        :param str error_page_touch_point_variant: Variant for the error page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        :param str favicon_url: Favicon URL
        :param str id: The ID of the theme
        :param str links: Link relations for this object - JSON HAL - Discoverable resources related to the email template
        :param str logo_url: Logo URL
        :param str primary_color_contrast_hex: Primary color contrast hex code
        :param str primary_color_hex: Primary color hex code
        :param str secondary_color_contrast_hex: Secondary color contrast hex code
        :param str secondary_color_hex: Secondary color hex code
        :param str sign_in_page_touch_point_variant: Variant for the Okta Sign-In Page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        """
        pulumi.set(__self__, "background_image_url", background_image_url)
        pulumi.set(__self__, "email_template_touch_point_variant", email_template_touch_point_variant)
        pulumi.set(__self__, "end_user_dashboard_touch_point_variant", end_user_dashboard_touch_point_variant)
        pulumi.set(__self__, "error_page_touch_point_variant", error_page_touch_point_variant)
        pulumi.set(__self__, "favicon_url", favicon_url)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "links", links)
        pulumi.set(__self__, "logo_url", logo_url)
        pulumi.set(__self__, "primary_color_contrast_hex", primary_color_contrast_hex)
        pulumi.set(__self__, "primary_color_hex", primary_color_hex)
        pulumi.set(__self__, "secondary_color_contrast_hex", secondary_color_contrast_hex)
        pulumi.set(__self__, "secondary_color_hex", secondary_color_hex)
        pulumi.set(__self__, "sign_in_page_touch_point_variant", sign_in_page_touch_point_variant)

    @property
    @pulumi.getter(name="backgroundImageUrl")
    def background_image_url(self) -> str:
        """
        Background image URL
        """
        return pulumi.get(self, "background_image_url")

    @property
    @pulumi.getter(name="emailTemplateTouchPointVariant")
    def email_template_touch_point_variant(self) -> str:
        """
        Variant for email templates (`OKTA_DEFAULT`, `FULL_THEME`)
        """
        return pulumi.get(self, "email_template_touch_point_variant")

    @property
    @pulumi.getter(name="endUserDashboardTouchPointVariant")
    def end_user_dashboard_touch_point_variant(self) -> str:
        """
        Variant for the Okta End-User Dashboard (`OKTA_DEFAULT`, `WHITE_LOGO_BACKGROUND`, `FULL_THEME`, `LOGO_ON_FULL_WHITE_BACKGROUND`)
        """
        return pulumi.get(self, "end_user_dashboard_touch_point_variant")

    @property
    @pulumi.getter(name="errorPageTouchPointVariant")
    def error_page_touch_point_variant(self) -> str:
        """
        Variant for the error page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        """
        return pulumi.get(self, "error_page_touch_point_variant")

    @property
    @pulumi.getter(name="faviconUrl")
    def favicon_url(self) -> str:
        """
        Favicon URL
        """
        return pulumi.get(self, "favicon_url")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the theme
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def links(self) -> str:
        """
        Link relations for this object - JSON HAL - Discoverable resources related to the email template
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> str:
        """
        Logo URL
        """
        return pulumi.get(self, "logo_url")

    @property
    @pulumi.getter(name="primaryColorContrastHex")
    def primary_color_contrast_hex(self) -> str:
        """
        Primary color contrast hex code
        """
        return pulumi.get(self, "primary_color_contrast_hex")

    @property
    @pulumi.getter(name="primaryColorHex")
    def primary_color_hex(self) -> str:
        """
        Primary color hex code
        """
        return pulumi.get(self, "primary_color_hex")

    @property
    @pulumi.getter(name="secondaryColorContrastHex")
    def secondary_color_contrast_hex(self) -> str:
        """
        Secondary color contrast hex code
        """
        return pulumi.get(self, "secondary_color_contrast_hex")

    @property
    @pulumi.getter(name="secondaryColorHex")
    def secondary_color_hex(self) -> str:
        """
        Secondary color hex code
        """
        return pulumi.get(self, "secondary_color_hex")

    @property
    @pulumi.getter(name="signInPageTouchPointVariant")
    def sign_in_page_touch_point_variant(self) -> str:
        """
        Variant for the Okta Sign-In Page (`OKTA_DEFAULT`, `BACKGROUND_SECONDARY_COLOR`, `BACKGROUND_IMAGE`)
        """
        return pulumi.get(self, "sign_in_page_touch_point_variant")


@pulumi.output_type
class GetTrustedOriginsTrustedOriginResult(dict):
    def __init__(__self__, *,
                 active: bool,
                 id: str,
                 name: str,
                 origin: str,
                 scopes: Sequence[str]):
        """
        :param bool active: Whether the Trusted Origin is active or not - can only be issued post-creation
        :param str id: Unique identifier
        :param str name: Unique name for this trusted origin
        :param str origin: Unique origin URL for this trusted origin
        :param Sequence[str] scopes: Scopes of the Trusted Origin - can either be CORS or REDIRECT only
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "origin", origin)
        pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def active(self) -> bool:
        """
        Whether the Trusted Origin is active or not - can only be issued post-creation
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name for this trusted origin
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def origin(self) -> str:
        """
        Unique origin URL for this trusted origin
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence[str]:
        """
        Scopes of the Trusted Origin - can either be CORS or REDIRECT only
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class GetUserSecurityQuestionsQuestionResult(dict):
    def __init__(__self__, *,
                 key: str,
                 text: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def text(self) -> str:
        return pulumi.get(self, "text")


