# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DeviceAssuranceIosArgs', 'DeviceAssuranceIos']

@pulumi.input_type
class DeviceAssuranceIosArgs:
    def __init__(__self__, *,
                 jailbreak: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 screenlock_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a DeviceAssuranceIos resource.
        :param pulumi.Input[bool] jailbreak: Is the device jailbroken in the device assurance policy.
        :param pulumi.Input[str] name: Name of the device assurance policy.
        :param pulumi.Input[str] os_version: Minimum os version of the device in the device assurance policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] screenlock_types: List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        """
        if jailbreak is not None:
            pulumi.set(__self__, "jailbreak", jailbreak)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if screenlock_types is not None:
            pulumi.set(__self__, "screenlock_types", screenlock_types)

    @property
    @pulumi.getter
    def jailbreak(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the device jailbroken in the device assurance policy.
        """
        return pulumi.get(self, "jailbreak")

    @jailbreak.setter
    def jailbreak(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jailbreak", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the device assurance policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum os version of the device in the device assurance policy.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)

    @property
    @pulumi.getter(name="screenlockTypes")
    def screenlock_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        """
        return pulumi.get(self, "screenlock_types")

    @screenlock_types.setter
    def screenlock_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "screenlock_types", value)


@pulumi.input_type
class _DeviceAssuranceIosState:
    def __init__(__self__, *,
                 created_by: Optional[pulumi.Input[str]] = None,
                 created_date: Optional[pulumi.Input[str]] = None,
                 jailbreak: Optional[pulumi.Input[bool]] = None,
                 last_update: Optional[pulumi.Input[str]] = None,
                 last_updated_by: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 screenlock_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering DeviceAssuranceIos resources.
        :param pulumi.Input[str] created_by: Created by of the device assurance polic
        :param pulumi.Input[str] created_date: Created date of the device assurance polic
        :param pulumi.Input[bool] jailbreak: Is the device jailbroken in the device assurance policy.
        :param pulumi.Input[str] last_update: Last update of the device assurance polic
        :param pulumi.Input[str] last_updated_by: Last updated by of the device assurance polic
        :param pulumi.Input[str] name: Name of the device assurance policy.
        :param pulumi.Input[str] os_version: Minimum os version of the device in the device assurance policy.
        :param pulumi.Input[str] platform: Policy device assurance platform
        :param pulumi.Input[Sequence[pulumi.Input[str]]] screenlock_types: List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        """
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if jailbreak is not None:
            pulumi.set(__self__, "jailbreak", jailbreak)
        if last_update is not None:
            pulumi.set(__self__, "last_update", last_update)
        if last_updated_by is not None:
            pulumi.set(__self__, "last_updated_by", last_updated_by)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if screenlock_types is not None:
            pulumi.set(__self__, "screenlock_types", screenlock_types)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        Created by of the device assurance polic
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[str]]:
        """
        Created date of the device assurance polic
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_date", value)

    @property
    @pulumi.getter
    def jailbreak(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the device jailbroken in the device assurance policy.
        """
        return pulumi.get(self, "jailbreak")

    @jailbreak.setter
    def jailbreak(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jailbreak", value)

    @property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> Optional[pulumi.Input[str]]:
        """
        Last update of the device assurance polic
        """
        return pulumi.get(self, "last_update")

    @last_update.setter
    def last_update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_update", value)

    @property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> Optional[pulumi.Input[str]]:
        """
        Last updated by of the device assurance polic
        """
        return pulumi.get(self, "last_updated_by")

    @last_updated_by.setter
    def last_updated_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_by", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the device assurance policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum os version of the device in the device assurance policy.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        Policy device assurance platform
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="screenlockTypes")
    def screenlock_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        """
        return pulumi.get(self, "screenlock_types")

    @screenlock_types.setter
    def screenlock_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "screenlock_types", value)


class DeviceAssuranceIos(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 jailbreak: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 screenlock_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages a device assurance policy for ios.

        ## Import

        ```sh
        $ pulumi import okta:policy/deviceAssuranceIos:DeviceAssuranceIos example &#60;device assurance id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] jailbreak: Is the device jailbroken in the device assurance policy.
        :param pulumi.Input[str] name: Name of the device assurance policy.
        :param pulumi.Input[str] os_version: Minimum os version of the device in the device assurance policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] screenlock_types: List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DeviceAssuranceIosArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a device assurance policy for ios.

        ## Import

        ```sh
        $ pulumi import okta:policy/deviceAssuranceIos:DeviceAssuranceIos example &#60;device assurance id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param DeviceAssuranceIosArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeviceAssuranceIosArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 jailbreak: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 screenlock_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeviceAssuranceIosArgs.__new__(DeviceAssuranceIosArgs)

            __props__.__dict__["jailbreak"] = jailbreak
            __props__.__dict__["name"] = name
            __props__.__dict__["os_version"] = os_version
            __props__.__dict__["screenlock_types"] = screenlock_types
            __props__.__dict__["created_by"] = None
            __props__.__dict__["created_date"] = None
            __props__.__dict__["last_update"] = None
            __props__.__dict__["last_updated_by"] = None
            __props__.__dict__["platform"] = None
        super(DeviceAssuranceIos, __self__).__init__(
            'okta:policy/deviceAssuranceIos:DeviceAssuranceIos',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            created_date: Optional[pulumi.Input[str]] = None,
            jailbreak: Optional[pulumi.Input[bool]] = None,
            last_update: Optional[pulumi.Input[str]] = None,
            last_updated_by: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            os_version: Optional[pulumi.Input[str]] = None,
            platform: Optional[pulumi.Input[str]] = None,
            screenlock_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'DeviceAssuranceIos':
        """
        Get an existing DeviceAssuranceIos resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_by: Created by of the device assurance polic
        :param pulumi.Input[str] created_date: Created date of the device assurance polic
        :param pulumi.Input[bool] jailbreak: Is the device jailbroken in the device assurance policy.
        :param pulumi.Input[str] last_update: Last update of the device assurance polic
        :param pulumi.Input[str] last_updated_by: Last updated by of the device assurance polic
        :param pulumi.Input[str] name: Name of the device assurance policy.
        :param pulumi.Input[str] os_version: Minimum os version of the device in the device assurance policy.
        :param pulumi.Input[str] platform: Policy device assurance platform
        :param pulumi.Input[Sequence[pulumi.Input[str]]] screenlock_types: List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeviceAssuranceIosState.__new__(_DeviceAssuranceIosState)

        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_date"] = created_date
        __props__.__dict__["jailbreak"] = jailbreak
        __props__.__dict__["last_update"] = last_update
        __props__.__dict__["last_updated_by"] = last_updated_by
        __props__.__dict__["name"] = name
        __props__.__dict__["os_version"] = os_version
        __props__.__dict__["platform"] = platform
        __props__.__dict__["screenlock_types"] = screenlock_types
        return DeviceAssuranceIos(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        Created by of the device assurance polic
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[str]:
        """
        Created date of the device assurance polic
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter
    def jailbreak(self) -> pulumi.Output[Optional[bool]]:
        """
        Is the device jailbroken in the device assurance policy.
        """
        return pulumi.get(self, "jailbreak")

    @property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> pulumi.Output[str]:
        """
        Last update of the device assurance polic
        """
        return pulumi.get(self, "last_update")

    @property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> pulumi.Output[str]:
        """
        Last updated by of the device assurance polic
        """
        return pulumi.get(self, "last_updated_by")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the device assurance policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> pulumi.Output[Optional[str]]:
        """
        Minimum os version of the device in the device assurance policy.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[str]:
        """
        Policy device assurance platform
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="screenlockTypes")
    def screenlock_types(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        """
        return pulumi.get(self, "screenlock_types")

