/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.xml.model.enums.DimensionOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IM3Reader
extends FormatReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(IM3Reader.class);
    private static final int COOKIE = 1985;
    private static final int REC_CONTAINER = 0;
    private static final int REC_IMAGE = 1;
    private static final int REC_NESTED = 3;
    private static final int REC_INT = 6;
    private static final int REC_FLOAT = 7;
    private static final int REC_BOOLEAN = 9;
    private static final int REC_STRING = 10;
    private static final String FIELD_DATA_SET = "DataSet";
    private static final String FIELD_TIMESTAMP = "TimeStamp";
    private static final String FIELD_AUX_FLAGS = "AuxFlags";
    private static final String FIELD_NUANCE_FLAGS = "NuanceFlags";
    private static final String FIELD_SPECTRA = "Spectra";
    private static final String FIELD_VALUES = "Values";
    private static final String FIELD_PROTOCOL = "Protocol";
    private static final String FIELD_OBJECTIVE = "Objective";
    private static final String FIELD_SPECTRAL_BASIS_INFO = "SpectralBasisInfo";
    private static final String FIELD_FILTER_PAIR = "FilterPair";
    private static final String FIELD_FIXED_FILTER = "FixedFilter";
    private static final String FIELD_BANDS = "Bands";
    private static final String FIELD_SPECTRAL_LIBRARY = "SpectralLibrary";
    private static final String FIELD_SPECTRUM = "Spectrum";
    private static final String FIELD_THUMBNAIL = "Thumbnail";
    private static final String FIELD_DATA = "Data";
    private static final String FIELD_FILE_VERSION = "FileVersion";
    private static final String FIELD_CLASS_ID = "ClassID";
    private static final String FIELD_TYPE_ID = "TypeID";
    private static final String FIELD_SHAPE = "Shape";
    private static final String FIELD_BAND_INDEX = "BandIndex";
    private static final String FIELD_NAME = "Name";
    private static final String FIELD_SAMPLE_ID = "SampleID";
    private static final String FIELD_USER_COMMENTS = "UserComments";
    private static final String FIELD_SOURCE_FILE_NAME = "SourceFileName";
    private static final String FIELD_PROXY_PARENT_FILE_NAME = "ProxyParentFileName";
    private static final String FIELD_MANUFACTURER = "Manufacturer";
    private static final String FIELD_PART_NUMBER = "PartNumber";
    private static final String FIELD_MILLIMETERS_PER_PIXEL = "MillimetersPerPixel";
    private static final String FIELD_EXPOSURE = "Exposure";
    private static final String FIELD_WAVELENGTH = "Wavelength";
    private static final String FIELD_WAVELENGTHS = "Wavelengths";
    private static final String FIELD_MAGNITUDES = "Magnitudes";
    private static final String FIELD_HOMOGENEOUS = "Homogeneous";
    private List<IM3Record> records = new ArrayList<IM3Record>();
    private List<ContainerRecord> dataSets = new ArrayList<ContainerRecord>();
    private List<Spectrum> spectra = new ArrayList<Spectrum>();
    private byte[] data;
    private static final String EMPTY_STRING = new String();

    public IM3Reader() {
        super("Perkin-Elmer Nuance IM3", "im3");
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.data == null) {
            this.data = this.openRaw();
        }
        if (this.data == null) {
            return null;
        }
        int srcWidth = this.getSizeX();
        int srcChannels = this.getSizeC();
        int idx = 0;
        int offset = ((x + y * srcWidth) * srcChannels + no) * 2;
        for (int hidx = 0; hidx < h2; ++hidx) {
            int roffset = offset + hidx * srcWidth * srcChannels * 2;
            for (int widx = 0; widx < w; ++widx) {
                buf[idx++] = this.data[roffset];
                buf[idx++] = this.data[roffset + 1];
                roffset += srcChannels * 2;
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] openRaw() throws IOException {
        try (IRandomAccess is = Location.getHandle(this.getCurrentFile(), false);){
            is.setOrder(ByteOrder.LITTLE_ENDIAN);
            ContainerRecord dataSet = this.dataSets.get(this.getSeries());
            for (IM3Record subRec : dataSet.parseChunks(is)) {
                if (!subRec.name.equals(FIELD_DATA)) continue;
                is.seek(subRec.offset + 4L);
                int width = is.readInt();
                int height = is.readInt();
                int channels = is.readInt();
                byte[] result = new byte[width * height * channels * 2];
                is.read(result);
                byte[] byArray = result;
                return byArray;
            }
        }
        return null;
    }

    public List<Spectrum> getSpectra() {
        return this.spectra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.core.clear();
        try (IRandomAccess is = Location.getHandle(id, false);){
            is.setOrder(ByteOrder.LITTLE_ENDIAN);
            int cookie = is.readInt();
            if (cookie != 1985) {
                throw new FormatException(String.format("Expected file cookie of %d, but got %d.", 1985, cookie));
            }
            long fileLength = is.length();
            while (is.getFilePointer() < fileLength) {
                IM3Record rec = IM3Reader.parseRecord(is);
                if (rec == null) {
                    if (is.getFilePointer() > fileLength - 16L) {
                        break;
                    }
                    int chunkLength = is.readInt();
                    int unknown = is.readInt();
                    int unknown1 = is.readInt();
                    int n = is.readInt();
                    continue;
                }
                if (rec instanceof ContainerRecord) {
                    ContainerRecord bRec = (ContainerRecord)rec;
                    for (IM3Record subDS : bRec.parseChunks(is)) {
                        if (subDS instanceof ContainerRecord && subDS.name.equals(FIELD_DATA_SET)) {
                            ContainerRecord bSubDS = (ContainerRecord)subDS;
                            for (IM3Record subSubDS : bSubDS.parseChunks(is)) {
                                if (!(subSubDS instanceof ContainerRecord)) continue;
                                ContainerRecord bDataSet = (ContainerRecord)subSubDS;
                                this.dataSets.add(bDataSet);
                                List<IM3Record> subRecs = bDataSet.parseChunks(is);
                                CoreMetadata cm = new CoreMetadata();
                                cm.dimensionOrder = DimensionOrder.XYCZT.getValue();
                                cm.littleEndian = true;
                                cm.pixelType = 3;
                                for (IM3Record subRec : subRecs) {
                                    if (!subRec.name.equals(FIELD_SHAPE) || !(subRec instanceof IntIM3Record)) continue;
                                    IntIM3Record iRec = (IntIM3Record)subRec;
                                    cm.sizeX = iRec.getEntry(is, 0);
                                    cm.sizeY = iRec.getEntry(is, 1);
                                    cm.sizeC = iRec.getEntry(is, 2);
                                    cm.sizeZ = 1;
                                    cm.sizeT = 1;
                                    cm.imageCount = cm.sizeC;
                                    cm.metadataComplete = true;
                                }
                                this.core.add(cm);
                            }
                            continue;
                        }
                        if (!(subDS instanceof ContainerRecord) || !subDS.name.equals(FIELD_SPECTRAL_LIBRARY)) continue;
                        for (IM3Record slContainer : ((ContainerRecord)subDS).parseChunks(is)) {
                            if (!(slContainer instanceof ContainerRecord)) continue;
                            for (IM3Record slSpectra : ((ContainerRecord)slContainer).parseChunks(is)) {
                                if (!(slSpectra instanceof ContainerRecord) || !slSpectra.name.equals(FIELD_SPECTRA)) continue;
                                for (IM3Record slRec : ((ContainerRecord)slSpectra).parseChunks(is)) {
                                    if (!slRec.name.equals(FIELD_VALUES) || !(slRec instanceof ContainerRecord)) continue;
                                    for (IM3Record spectrumRec : ((ContainerRecord)slRec).parseChunks(is)) {
                                        if (!(spectrumRec instanceof ContainerRecord)) continue;
                                        this.spectra.add(new Spectrum(is, (ContainerRecord)spectrumRec));
                                    }
                                }
                            }
                        }
                    }
                }
                this.records.add(rec);
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    protected static String parseString(IRandomAccess is) throws IOException {
        int nameLength = is.readInt();
        if (nameLength == 0) {
            return EMPTY_STRING;
        }
        byte[] buf = new byte[nameLength];
        is.read(buf);
        return new String(buf, "UTF-8");
    }

    private static IM3Record parseRecord(IRandomAccess is) throws IOException {
        String name = IM3Reader.parseString(is);
        if (name == null) {
            return null;
        }
        int recLength = is.readInt() - 8;
        int recType = is.readInt();
        long offset = is.getFilePointer();
        is.skipBytes(recLength);
        switch (recType) {
            case 0: {
                return new ContainerRecord(name, recType, offset, recLength);
            }
            case 10: {
                return new StringIM3Record(name, recType, offset, recLength);
            }
            case 6: {
                return new IntIM3Record(name, recType, offset, recLength);
            }
            case 7: {
                return new FloatIM3Record(name, recType, offset, recLength);
            }
            case 9: {
                return new BooleanIM3Record(name, recType, offset, recLength);
            }
        }
        return new IM3Record(name, recType, offset, recLength);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        stream.seek(0L);
        return stream.readInt() == 1985;
    }

    @Override
    public void setSeries(int no) {
        super.setSeries(no);
        this.data = null;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.data = null;
            if (this.records != null) {
                this.records.clear();
            }
            if (this.spectra != null) {
                this.spectra.clear();
            }
            if (this.dataSets != null) {
                this.dataSets.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSummary() throws IOException {
        try (IRandomAccess is = Location.getHandle(this.getCurrentFile(), false);){
            is.setOrder(ByteOrder.LITTLE_ENDIAN);
            for (IM3Record rec : this.records) {
                rec.writeSummary(is, "");
            }
        }
    }

    public static void main(String[] args) throws IOException {
        try (IM3Reader reader = new IM3Reader();){
            reader.setId(args[0]);
            reader.writeSummary();
        }
        catch (FormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Spectrum {
        private String name;
        private float[] wavelengths;
        private float[] magnitudes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Spectrum(IRandomAccess is, ContainerRecord rec) throws IOException {
            long oldPos = is.getFilePointer();
            try {
                for (IM3Record subRec : rec.parseChunks(is)) {
                    if (subRec.name.equals(IM3Reader.FIELD_NAME) && subRec instanceof StringIM3Record) {
                        this.name = ((StringIM3Record)subRec).getValue(is);
                        continue;
                    }
                    if (!subRec.name.equals(IM3Reader.FIELD_SPECTRUM) || !(subRec instanceof ContainerRecord)) continue;
                    this.parseSpectrumRecord(is, (ContainerRecord)subRec);
                }
            }
            finally {
                is.seek(oldPos);
            }
        }

        public String getName() {
            return this.name;
        }

        public float[] getWavelengths() {
            return this.wavelengths;
        }

        public float[] getMagnitudes() {
            return this.magnitudes;
        }

        private void parseSpectrumRecord(IRandomAccess is, ContainerRecord rec) throws IOException {
            for (IM3Record subRec : rec.parseChunks(is)) {
                if (!(subRec instanceof ContainerRecord)) continue;
                for (IM3Record subSubRec : ((ContainerRecord)subRec).parseChunks(is)) {
                    if (subSubRec.name.equals(IM3Reader.FIELD_WAVELENGTHS) && subSubRec instanceof FloatIM3Record) {
                        this.wavelengths = ((FloatIM3Record)subSubRec).getEntries(is);
                        continue;
                    }
                    if (!subSubRec.name.equals(IM3Reader.FIELD_MAGNITUDES) || !(subSubRec instanceof FloatIM3Record)) continue;
                    this.magnitudes = ((FloatIM3Record)subSubRec).getEntries(is);
                }
            }
        }
    }

    protected static class StringIM3Record
    extends IM3Record {
        public StringIM3Record(String name, int recType, long offset, int recLength) {
            super(name, recType, offset, recLength);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getValue(IRandomAccess is) throws IOException {
            long oldPos = is.getFilePointer();
            try {
                is.seek(this.offset + 4L);
                String string = IM3Reader.parseString(is);
                return string;
            }
            finally {
                is.seek(oldPos);
            }
        }

        @Override
        public void writeSummary(IRandomAccess is, String indentation) throws IOException {
            LOGGER.info(indentation + this.toString());
            LOGGER.info(indentation + String.format("Value = %s", this.getValue(is)));
        }
    }

    protected static class BooleanIM3Record
    extends IM3Record {
        public BooleanIM3Record(String name, int recType, long offset, int recLength) {
            super(name, recType, offset, recLength);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumEntries(IRandomAccess is) throws IOException {
            long oldPos = is.getFilePointer();
            try {
                is.seek(this.offset + 4L);
                int n = is.readInt();
                return n;
            }
            finally {
                is.seek(oldPos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getEntry(IRandomAccess is, int index) throws IOException {
            long oldPos = is.getFilePointer();
            try {
                is.seek(this.offset + 8L + (long)index);
                boolean bl = is.readByte() != 0;
                return bl;
            }
            finally {
                is.seek(oldPos);
            }
        }
    }

    protected static class FloatIM3Record
    extends IM3Record {
        public FloatIM3Record(String name, int recType, long offset, int recLength) {
            super(name, recType, offset, recLength);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumEntries(IRandomAccess is) throws IOException {
            long oldPos = is.getFilePointer();
            try {
                is.seek(this.offset);
                if (is.readInt() == 0) {
                    int n = 1;
                    return n;
                }
                int n = is.readInt();
                return n;
            }
            finally {
                is.seek(oldPos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float getEntry(IRandomAccess is, int index) throws IOException {
            long oldPos = is.getFilePointer();
            try {
                is.seek(this.offset);
                if (is.readInt() == 0) {
                    float f = is.readFloat();
                    return f;
                }
                is.seek(this.offset + 8L + (long)(index * 4));
                float f = is.readFloat();
                return f;
            }
            finally {
                is.seek(oldPos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float[] getEntries(IRandomAccess is) throws IOException {
            long oldPos = is.getFilePointer();
            try {
                float[] values = new float[this.getNumEntries(is)];
                is.seek(this.offset + 8L);
                for (int index = 0; index < values.length; ++index) {
                    values[index] = is.readFloat();
                }
                float[] fArray = values;
                return fArray;
            }
            finally {
                is.seek(oldPos);
            }
        }

        @Override
        public void writeSummary(IRandomAccess is, String indentation) throws IOException {
            is.seek(this.offset);
            LOGGER.info(indentation + this.toString());
            int length = this.getNumEntries(is);
            for (int i = 0; i < length && i < 256; i += 16) {
                StringBuilder msg = new StringBuilder(indentation + String.format("%02x:", i));
                for (int j = i; j < i + 16 && j < length; ++j) {
                    msg.append(String.format(" %4.4f", Float.valueOf(this.getEntry(is, j))));
                }
                LOGGER.info(msg.toString());
            }
        }
    }

    protected static class IntIM3Record
    extends IM3Record {
        public IntIM3Record(String name, int recType, long offset, int recLength) {
            super(name, recType, offset, recLength);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumEntries(IRandomAccess is) throws IOException {
            long oldPos = is.getFilePointer();
            try {
                is.seek(this.offset);
                int code = is.readInt();
                if (code == 0) {
                    int n = 1;
                    return n;
                }
                int n = is.readInt();
                return n;
            }
            finally {
                is.seek(oldPos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEntry(IRandomAccess is, int index) throws IOException {
            long oldPos = is.getFilePointer();
            try {
                is.seek(this.offset);
                if (is.readInt() == 0) {
                    int n = is.readInt();
                    return n;
                }
                is.seek(this.offset + (long)(index * 4) + 8L);
                int n = is.readInt();
                return n;
            }
            finally {
                is.seek(oldPos);
            }
        }

        @Override
        public void writeSummary(IRandomAccess is, String indentation) throws IOException {
            is.seek(this.offset);
            LOGGER.info(indentation + this.toString());
            int length = this.getNumEntries(is);
            for (int i = 0; i < length && i < 256; i += 16) {
                StringBuilder msg = new StringBuilder(indentation + String.format("%02x:", i));
                for (int j = i; j < i + 16 && j < length; ++j) {
                    msg.append(String.format(" %7d", this.getEntry(is, j)));
                }
                LOGGER.info(msg.toString());
            }
        }
    }

    protected static class ContainerRecord
    extends IM3Record {
        ContainerRecord(String name, int type, long offset, int length) {
            super(name, type, offset, length);
        }

        List<IM3Record> parseChunks(IRandomAccess is) throws IOException {
            long oldOffset = is.getFilePointer();
            is.seek(this.offset + 8L);
            long end = this.offset + (long)this.length;
            ArrayList<IM3Record> recs = new ArrayList<IM3Record>();
            while (is.getFilePointer() < end - 8L) {
                IM3Record rec = IM3Reader.parseRecord(is);
                if (rec == null) continue;
                recs.add(rec);
            }
            is.seek(oldOffset);
            return recs;
        }

        @Override
        public void writeSummary(IRandomAccess is, String indentation) throws IOException {
            is.seek(this.offset);
            LOGGER.info(indentation + this.toString());
            for (IM3Record rec : this.parseChunks(is)) {
                rec.writeSummary(is, indentation + "  ");
            }
        }
    }

    protected static class IM3Record {
        final String name;
        final int type;
        final long offset;
        final int length;

        IM3Record(String name, int type, long offset, int length) {
            this.name = name;
            this.type = type;
            this.offset = offset;
            this.length = length;
        }

        public void writeSummary(IRandomAccess is, String indentation) throws IOException {
            is.seek(this.offset);
            LOGGER.info(indentation + this.toString());
            for (int i = 0; i < this.length && i < 256; i += 32) {
                StringBuilder msg = new StringBuilder(indentation + String.format("%02x:", i));
                for (int j = i; j < this.length && j < i + 32; ++j) {
                    msg.append(String.format(" %02x", is.readByte()));
                }
                LOGGER.info(msg.toString());
            }
        }

        public String toString() {
            return String.format("[%s: type=%d, offset=%d, length=%d]", this.name, this.type, this.offset, this.length);
        }
    }
}

