/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import loci.common.DebugTools;
import loci.common.Location;
import loci.formats.FormatHandler;
import loci.formats.tools.FakeImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageFaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageFaker.class);
    private String targetDirectoryPath;
    private int plates = 1;
    private int plateAcquisitions = 1;
    private int rows = 1;
    private int columns = 1;
    private int fields = 1;

    public boolean parseArgs(String[] args) {
        if (args == null || args.length == 0) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals("-plates")) {
                    this.plates = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-runs")) {
                    this.plateAcquisitions = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-rows")) {
                    this.rows = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-columns")) {
                    this.columns = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-fields")) {
                    this.fields = Integer.parseInt(args[++i]);
                    continue;
                }
                if (!args[i].equals("-debug")) continue;
                DebugTools.setRootLevel("DEBUG");
                continue;
            }
            if (this.targetDirectoryPath == null) {
                this.targetDirectoryPath = args[i];
                continue;
            }
            LOGGER.error("Found unknown argument: {}; exiting.", (Object)args[i]);
            return false;
        }
        return true;
    }

    public void printUsage() {
        String[] s2 = new String[]{"To generate a fake file / dir structure, run:", "  mkfake path [-plates] [-runs] [-rows] [-columns] ", "    [-fields] [-debug]", "", "        path: the top-level directory for the SPW structure", "     -plates: number of plates (default: 1)", "       -runs: number of plate runs (acquisitions) (default: 1)", "       -rows: number of rows in a plate (default: 1)", "    -columns: number of columns in a plate (default: 1)", "     -fields: number of fields in a plate (default: 1)", "      -debug: turn on debugging output", ""};
        for (int i = 0; i < s2.length; ++i) {
            LOGGER.info(s2[i]);
        }
    }

    public boolean fakeScreen(String[] args) {
        DebugTools.enableLogging("INFO");
        boolean validArgs = this.parseArgs(args);
        if (!validArgs || this.targetDirectoryPath == null) {
            this.printUsage();
            return false;
        }
        if (new Location(this.targetDirectoryPath).exists()) {
            Location p = new Location(this.targetDirectoryPath, "screen.fake");
            int index = 1;
            while (p.exists()) {
                p = new Location(this.targetDirectoryPath, "screen" + index + ".fake");
                ++index;
            }
            this.targetDirectoryPath = p.getAbsolutePath();
        }
        Location directoryRoot = !FormatHandler.checkSuffix(this.targetDirectoryPath, "fake") ? new Location(this.targetDirectoryPath + "." + "fake") : new Location(this.targetDirectoryPath);
        FakeImage fake = new FakeImage(directoryRoot);
        fake.generateScreen(this.plates, this.plateAcquisitions, this.rows, this.columns, this.fields);
        return true;
    }

    public static void main(String[] args) throws Exception {
        if (!new ImageFaker().fakeScreen(args)) {
            System.exit(1);
        }
    }
}

