import com.esotericsoftware.kryo
import java.awt.image
import java.io
import java.lang
import java.math
import java.util
import jpype.protocol
import bioformats_jar._loci
import bioformats_jar._loci.common
import bioformats_jar._loci.formats.cache
import bioformats_jar._loci.formats.codec
import bioformats_jar._loci.formats.gui
import bioformats_jar._loci.formats.in_
import bioformats_jar._loci.formats.meta
import bioformats_jar._loci.formats.ome
import bioformats_jar._loci.formats.out
import bioformats_jar._loci.formats.services
import bioformats_jar._loci.formats.tiff
import bioformats_jar._loci.formats.tools
import ome.units.quantity
import ome.units.unit
import ome.xml.model.enums
import ome.xml.model.primitives
import typing



class AxisGuesser:
    UNKNOWN_AXIS: typing.ClassVar[int] = ...
    Z_AXIS: typing.ClassVar[int] = ...
    T_AXIS: typing.ClassVar[int] = ...
    C_AXIS: typing.ClassVar[int] = ...
    S_AXIS: typing.ClassVar[int] = ...
    Z_PREFIXES: typing.ClassVar[java.util.Set] = ...
    T_PREFIXES: typing.ClassVar[java.util.Set] = ...
    C_PREFIXES: typing.ClassVar[java.util.Set] = ...
    S_PREFIXES: typing.ClassVar[java.util.Set] = ...
    def __init__(self, filePattern: 'FilePattern', string: typing.Union[java.lang.String, str], int: int, int2: int, int3: int, boolean: bool): ...
    def getAdjustedOrder(self) -> java.lang.String: ...
    def getAxisCount(self, int: int) -> int: ...
    def getAxisCountC(self) -> int: ...
    def getAxisCountS(self) -> int: ...
    def getAxisCountT(self) -> int: ...
    def getAxisCountZ(self) -> int: ...
    @staticmethod
    def getAxisType(string: typing.Union[java.lang.String, str]) -> int: ...
    def getAxisTypes(self) -> typing.List[int]: ...
    def getFilePattern(self) -> 'FilePattern': ...
    def getOriginalOrder(self) -> java.lang.String: ...
    def isCertain(self) -> bool: ...
    def setAxisTypes(self, intArray: typing.List[int]) -> None: ...

_ClassList__T = typing.TypeVar('_ClassList__T')  # <T>
class ClassList(typing.Generic[_ClassList__T]):
    @typing.overload
    def __init__(self, class_: typing.Type[_ClassList__T]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], class_: typing.Type[_ClassList__T]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], class_: typing.Type[_ClassList__T], class2: typing.Type[typing.Any]): ...
    @typing.overload
    def addClass(self, int: int, class_: typing.Type[_ClassList__T]) -> None: ...
    @typing.overload
    def addClass(self, class_: typing.Type[_ClassList__T]) -> None: ...
    def addOption(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def append(self, list: java.util.List[typing.Type[_ClassList__T]]) -> None: ...
    @typing.overload
    def append(self, classList: 'ClassList'[_ClassList__T]) -> None: ...
    def getClasses(self) -> typing.List[typing.Type[_ClassList__T]]: ...
    def getOptions(self) -> java.util.Map[java.lang.String, java.lang.String]: ...
    def isAllowedKey(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def isWhitelistedKey(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def parseFile(self, string: typing.Union[java.lang.String, str], class_: typing.Type[typing.Any]) -> None: ...
    def parseLine(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def parseOptions(self, string: typing.Union[java.lang.String, str]) -> java.util.Map[java.lang.String, java.lang.String]: ...
    @typing.overload
    def prepend(self, list: java.util.List[typing.Type[_ClassList__T]]) -> None: ...
    @typing.overload
    def prepend(self, classList: 'ClassList'[_ClassList__T]) -> None: ...
    def removeClass(self, class_: typing.Type[_ClassList__T]) -> None: ...

class CoreMetadata(java.lang.Cloneable):
    sizeX: int = ...
    sizeY: int = ...
    sizeZ: int = ...
    sizeC: int = ...
    sizeT: int = ...
    thumbSizeX: int = ...
    thumbSizeY: int = ...
    pixelType: int = ...
    bitsPerPixel: int = ...
    imageCount: int = ...
    moduloZ: 'Modulo' = ...
    moduloC: 'Modulo' = ...
    moduloT: 'Modulo' = ...
    dimensionOrder: java.lang.String = ...
    orderCertain: bool = ...
    rgb: bool = ...
    littleEndian: bool = ...
    interleaved: bool = ...
    indexed: bool = ...
    falseColor: bool = ...
    metadataComplete: bool = ...
    seriesMetadata: java.util.Hashtable = ...
    thumbnail: bool = ...
    resolutionCount: int = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, coreMetadata: 'CoreMetadata'): ...
    @typing.overload
    def __init__(self, iFormatReader: 'IFormatReader', int: int): ...
    @typing.overload
    def clone(self) -> typing.Any: ...
    @typing.overload
    def clone(self, iFormatReader: 'IFormatReader', int: int) -> 'CoreMetadata': ...
    def toString(self) -> java.lang.String: ...

class FileInfo:
    filename: java.lang.String = ...
    reader: typing.Type = ...
    usedToInitialize: bool = ...
    def __init__(self): ...
    def toString(self) -> java.lang.String: ...

class FilePattern:
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, location: bioformats_jar._loci.common.Location): ...
    @typing.overload
    @staticmethod
    def findPattern(file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def findPattern(string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def findPattern(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def findPattern(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def findPattern(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String], intArray: typing.List[int]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def findPattern(stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def findPattern(location: bioformats_jar._loci.common.Location) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def findSeriesPatterns(string: typing.Union[java.lang.String, str]) -> typing.List[java.lang.String]: ...
    @typing.overload
    @staticmethod
    def findSeriesPatterns(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]) -> typing.List[java.lang.String]: ...
    def getBlock(self, int: int) -> java.lang.String: ...
    def getBlocks(self) -> typing.List[java.lang.String]: ...
    def getCount(self) -> typing.List[int]: ...
    def getElements(self) -> typing.List[typing.List[java.lang.String]]: ...
    def getErrorMessage(self) -> java.lang.String: ...
    def getFiles(self) -> typing.List[java.lang.String]: ...
    def getFirst(self) -> typing.List[java.math.BigInteger]: ...
    def getLast(self) -> typing.List[java.math.BigInteger]: ...
    def getPattern(self) -> java.lang.String: ...
    @typing.overload
    def getPrefix(self) -> java.lang.String: ...
    @typing.overload
    def getPrefix(self, int: int) -> java.lang.String: ...
    def getPrefixes(self) -> typing.List[java.lang.String]: ...
    def getStep(self) -> typing.List[java.math.BigInteger]: ...
    def getSuffix(self) -> java.lang.String: ...
    def isRegex(self) -> bool: ...
    def isValid(self) -> bool: ...

class FilePatternBlock:
    BLOCK_START: typing.ClassVar[java.lang.String] = ...
    BLOCK_END: typing.ClassVar[java.lang.String] = ...
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    def getBlock(self) -> java.lang.String: ...
    def getElements(self) -> typing.List[java.lang.String]: ...
    def getFirst(self) -> java.math.BigInteger: ...
    def getLast(self) -> java.math.BigInteger: ...
    def getStep(self) -> java.math.BigInteger: ...
    def isFixed(self) -> bool: ...
    def isNumeric(self) -> bool: ...

class FormatException(java.lang.Exception):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class FormatTools:
    INT8: typing.ClassVar[int] = ...
    UINT8: typing.ClassVar[int] = ...
    INT16: typing.ClassVar[int] = ...
    UINT16: typing.ClassVar[int] = ...
    INT32: typing.ClassVar[int] = ...
    UINT32: typing.ClassVar[int] = ...
    FLOAT: typing.ClassVar[int] = ...
    DOUBLE: typing.ClassVar[int] = ...
    BIT: typing.ClassVar[int] = ...
    CHANNEL: typing.ClassVar[java.lang.String] = ...
    SPECTRA: typing.ClassVar[java.lang.String] = ...
    LIFETIME: typing.ClassVar[java.lang.String] = ...
    POLARIZATION: typing.ClassVar[java.lang.String] = ...
    PHASE: typing.ClassVar[java.lang.String] = ...
    FREQUENCY: typing.ClassVar[java.lang.String] = ...
    ROTATION: typing.ClassVar[java.lang.String] = ...
    ILLUMINATION: typing.ClassVar[java.lang.String] = ...
    MUST_GROUP: typing.ClassVar[int] = ...
    CAN_GROUP: typing.ClassVar[int] = ...
    CANNOT_GROUP: typing.ClassVar[int] = ...
    SERIES_NUM: typing.ClassVar[java.lang.String] = ...
    SERIES_NAME: typing.ClassVar[java.lang.String] = ...
    CHANNEL_NUM: typing.ClassVar[java.lang.String] = ...
    CHANNEL_NAME: typing.ClassVar[java.lang.String] = ...
    Z_NUM: typing.ClassVar[java.lang.String] = ...
    T_NUM: typing.ClassVar[java.lang.String] = ...
    TIMESTAMP: typing.ClassVar[java.lang.String] = ...
    TILE_X: typing.ClassVar[java.lang.String] = ...
    TILE_Y: typing.ClassVar[java.lang.String] = ...
    TILE_NUM: typing.ClassVar[java.lang.String] = ...
    VERSION_PROPERTIES: typing.ClassVar[java.util.Properties] = ...
    VCS_REVISION: typing.ClassVar[java.lang.String] = ...
    VCS_SHORT_REVISION: typing.ClassVar[java.lang.String] = ...
    DATE: typing.ClassVar[java.lang.String] = ...
    YEAR: typing.ClassVar[java.lang.String] = ...
    VERSION: typing.ClassVar[java.lang.String] = ...
    CREATOR: typing.ClassVar[java.lang.String] = ...
    PROPERTY_FILE: typing.ClassVar[java.lang.String] = ...
    HCS_DOMAIN: typing.ClassVar[java.lang.String] = ...
    LM_DOMAIN: typing.ClassVar[java.lang.String] = ...
    EM_DOMAIN: typing.ClassVar[java.lang.String] = ...
    SPM_DOMAIN: typing.ClassVar[java.lang.String] = ...
    SEM_DOMAIN: typing.ClassVar[java.lang.String] = ...
    FLIM_DOMAIN: typing.ClassVar[java.lang.String] = ...
    MEDICAL_DOMAIN: typing.ClassVar[java.lang.String] = ...
    HISTOLOGY_DOMAIN: typing.ClassVar[java.lang.String] = ...
    GEL_DOMAIN: typing.ClassVar[java.lang.String] = ...
    ASTRONOMY_DOMAIN: typing.ClassVar[java.lang.String] = ...
    GRAPHICS_DOMAIN: typing.ClassVar[java.lang.String] = ...
    UNKNOWN_DOMAIN: typing.ClassVar[java.lang.String] = ...
    NON_GRAPHICS_DOMAINS: typing.ClassVar[typing.List[java.lang.String]] = ...
    NON_HCS_DOMAINS: typing.ClassVar[typing.List[java.lang.String]] = ...
    NON_SPECIAL_DOMAINS: typing.ClassVar[typing.List[java.lang.String]] = ...
    ALL_DOMAINS: typing.ClassVar[typing.List[java.lang.String]] = ...
    URL_BIO_FORMATS: typing.ClassVar[java.lang.String] = ...
    URL_BIO_FORMATS_LIBRARIES: typing.ClassVar[java.lang.String] = ...
    URL_OME_TIFF: typing.ClassVar[java.lang.String] = ...
    @staticmethod
    def assertId(string: typing.Union[java.lang.String, str], boolean: bool, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def checkBufferSize(iFormatReader: 'IFormatReader', int: int) -> None: ...
    @typing.overload
    @staticmethod
    def checkBufferSize(iFormatReader: 'IFormatReader', int: int, int2: int, int3: int) -> None: ...
    @staticmethod
    def checkPlaneNumber(iFormatReader: 'IFormatReader', int: int) -> None: ...
    @staticmethod
    def checkPlaneParameters(iFormatReader: 'IFormatReader', int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> None: ...
    @staticmethod
    def checkTileSize(iFormatReader: 'IFormatReader', int: int, int2: int, int3: int, int4: int) -> None: ...
    @typing.overload
    @staticmethod
    def convert(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    @staticmethod
    def convert(iFormatReader: 'IFormatReader', iFormatWriter: 'IFormatWriter', string: typing.Union[java.lang.String, str]) -> None: ...
    _createAngle_2__T = typing.TypeVar('_createAngle_2__T', bound=ome.xml.model.primitives.PrimitiveNumber)  # <T>
    @typing.overload
    @staticmethod
    def createAngle(double: float, unit: ome.units.unit.Unit[ome.units.quantity.Angle]) -> ome.units.quantity.Angle: ...
    @typing.overload
    @staticmethod
    def createAngle(integer: int, unit: ome.units.unit.Unit[ome.units.quantity.Angle]) -> ome.units.quantity.Angle: ...
    @typing.overload
    @staticmethod
    def createAngle(t: _createAngle_2__T, unit: ome.units.unit.Unit[ome.units.quantity.Angle]) -> ome.units.quantity.Angle: ...
    _createElectricPotential_2__T = typing.TypeVar('_createElectricPotential_2__T', bound=ome.xml.model.primitives.PrimitiveNumber)  # <T>
    @typing.overload
    @staticmethod
    def createElectricPotential(double: float, unit: ome.units.unit.Unit[ome.units.quantity.ElectricPotential]) -> ome.units.quantity.ElectricPotential: ...
    @typing.overload
    @staticmethod
    def createElectricPotential(integer: int, unit: ome.units.unit.Unit[ome.units.quantity.ElectricPotential]) -> ome.units.quantity.ElectricPotential: ...
    @typing.overload
    @staticmethod
    def createElectricPotential(t: _createElectricPotential_2__T, unit: ome.units.unit.Unit[ome.units.quantity.ElectricPotential]) -> ome.units.quantity.ElectricPotential: ...
    _createFrequency_2__T = typing.TypeVar('_createFrequency_2__T', bound=ome.xml.model.primitives.PrimitiveNumber)  # <T>
    @typing.overload
    @staticmethod
    def createFrequency(double: float, unit: ome.units.unit.Unit[ome.units.quantity.Frequency]) -> ome.units.quantity.Frequency: ...
    @typing.overload
    @staticmethod
    def createFrequency(integer: int, unit: ome.units.unit.Unit[ome.units.quantity.Frequency]) -> ome.units.quantity.Frequency: ...
    @typing.overload
    @staticmethod
    def createFrequency(t: _createFrequency_2__T, unit: ome.units.unit.Unit[ome.units.quantity.Frequency]) -> ome.units.quantity.Frequency: ...
    _createLength_2__T = typing.TypeVar('_createLength_2__T', bound=ome.xml.model.primitives.PrimitiveNumber)  # <T>
    @typing.overload
    @staticmethod
    def createLength(double: float, unit: ome.units.unit.Unit[ome.units.quantity.Length]) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def createLength(integer: int, unit: ome.units.unit.Unit[ome.units.quantity.Length]) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def createLength(t: _createLength_2__T, unit: ome.units.unit.Unit[ome.units.quantity.Length]) -> ome.units.quantity.Length: ...
    _createPower_2__T = typing.TypeVar('_createPower_2__T', bound=ome.xml.model.primitives.PrimitiveNumber)  # <T>
    @typing.overload
    @staticmethod
    def createPower(double: float, unit: ome.units.unit.Unit[ome.units.quantity.Power]) -> ome.units.quantity.Power: ...
    @typing.overload
    @staticmethod
    def createPower(integer: int, unit: ome.units.unit.Unit[ome.units.quantity.Power]) -> ome.units.quantity.Power: ...
    @typing.overload
    @staticmethod
    def createPower(t: _createPower_2__T, unit: ome.units.unit.Unit[ome.units.quantity.Power]) -> ome.units.quantity.Power: ...
    _createPressure_2__T = typing.TypeVar('_createPressure_2__T', bound=ome.xml.model.primitives.PrimitiveNumber)  # <T>
    @typing.overload
    @staticmethod
    def createPressure(double: float, unit: ome.units.unit.Unit[ome.units.quantity.Pressure]) -> ome.units.quantity.Pressure: ...
    @typing.overload
    @staticmethod
    def createPressure(integer: int, unit: ome.units.unit.Unit[ome.units.quantity.Pressure]) -> ome.units.quantity.Pressure: ...
    @typing.overload
    @staticmethod
    def createPressure(t: _createPressure_2__T, unit: ome.units.unit.Unit[ome.units.quantity.Pressure]) -> ome.units.quantity.Pressure: ...
    _createTemperature_2__T = typing.TypeVar('_createTemperature_2__T', bound=ome.xml.model.primitives.PrimitiveNumber)  # <T>
    @typing.overload
    @staticmethod
    def createTemperature(double: float, unit: ome.units.unit.Unit[ome.units.quantity.Temperature]) -> ome.units.quantity.Temperature: ...
    @typing.overload
    @staticmethod
    def createTemperature(integer: int, unit: ome.units.unit.Unit[ome.units.quantity.Temperature]) -> ome.units.quantity.Temperature: ...
    @typing.overload
    @staticmethod
    def createTemperature(t: _createTemperature_2__T, unit: ome.units.unit.Unit[ome.units.quantity.Temperature]) -> ome.units.quantity.Temperature: ...
    _createTime_2__T = typing.TypeVar('_createTime_2__T', bound=ome.xml.model.primitives.PrimitiveNumber)  # <T>
    @typing.overload
    @staticmethod
    def createTime(double: float, unit: ome.units.unit.Unit[ome.units.quantity.Time]) -> ome.units.quantity.Time: ...
    @typing.overload
    @staticmethod
    def createTime(integer: int, unit: ome.units.unit.Unit[ome.units.quantity.Time]) -> ome.units.quantity.Time: ...
    @typing.overload
    @staticmethod
    def createTime(t: _createTime_2__T, unit: ome.units.unit.Unit[ome.units.quantity.Time]) -> ome.units.quantity.Time: ...
    @staticmethod
    def defaultMinMax(int: int) -> typing.List[int]: ...
    @staticmethod
    def equalReaders(iFormatReader: 'IFormatReader', iFormatReader2: 'IFormatReader') -> bool: ...
    @typing.overload
    @staticmethod
    def getBytesPerPixel(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def getBytesPerPixel(string: typing.Union[java.lang.String, str]) -> int: ...
    @staticmethod
    def getCutIn(double: float) -> ome.units.quantity.Length: ...
    @staticmethod
    def getCutOut(double: float) -> ome.units.quantity.Length: ...
    @staticmethod
    def getEmissionWavelength(double: float) -> ome.units.quantity.Length: ...
    @staticmethod
    def getExcitationWavelength(double: float) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def getFilename(int: int, int2: int, iFormatReader: 'IFormatReader', string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def getFilename(int: int, int2: int, iFormatReader: 'IFormatReader', string: typing.Union[java.lang.String, str], boolean: bool) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def getFilename(int: int, int2: int, metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve, string: typing.Union[java.lang.String, str], boolean: bool) -> java.lang.String: ...
    @staticmethod
    def getFilenames(string: typing.Union[java.lang.String, str], iFormatReader: 'IFormatReader') -> typing.List[java.lang.String]: ...
    @staticmethod
    def getFontSize(integer: int) -> ome.units.quantity.Length: ...
    @staticmethod
    def getImagesPerFile(string: typing.Union[java.lang.String, str], iFormatReader: 'IFormatReader') -> int: ...
    @typing.overload
    @staticmethod
    def getIndex(string: typing.Union[java.lang.String, str], int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int) -> int: ...
    @typing.overload
    @staticmethod
    def getIndex(string: typing.Union[java.lang.String, str], int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int, int9: int, int10: int, int11: int, int12: int, int13: int) -> int: ...
    @typing.overload
    @staticmethod
    def getIndex(iFormatReader: 'IFormatReader', int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    @staticmethod
    def getIndex(iFormatReader: 'IFormatReader', int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> int: ...
    @staticmethod
    def getMaxFieldCount(integer: int) -> ome.xml.model.primitives.PositiveInteger: ...
    @staticmethod
    def getPhysicalSize(double: float, string: typing.Union[java.lang.String, str]) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def getPhysicalSizeX(double: float) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def getPhysicalSizeX(double: float, string: typing.Union[java.lang.String, str]) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def getPhysicalSizeX(double: float, unit: ome.units.unit.Unit[ome.units.quantity.Length]) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def getPhysicalSizeY(double: float) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def getPhysicalSizeY(double: float, string: typing.Union[java.lang.String, str]) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def getPhysicalSizeY(double: float, unit: ome.units.unit.Unit[ome.units.quantity.Length]) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def getPhysicalSizeZ(double: float) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def getPhysicalSizeZ(double: float, string: typing.Union[java.lang.String, str]) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def getPhysicalSizeZ(double: float, unit: ome.units.unit.Unit[ome.units.quantity.Length]) -> ome.units.quantity.Length: ...
    @staticmethod
    def getPixelTypeString(int: int) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def getPlaneSize(iFormatReader: 'IFormatReader') -> int: ...
    @typing.overload
    @staticmethod
    def getPlaneSize(iFormatReader: 'IFormatReader', int: int, int2: int) -> int: ...
    @staticmethod
    def getRasterLength(intArray: typing.List[int]) -> int: ...
    @staticmethod
    def getReader(iFormatReader: 'IFormatReader', class_: typing.Type['IFormatReader']) -> 'IFormatReader': ...
    @typing.overload
    @staticmethod
    def getReorderedIndex(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], int: int, int2: int, int3: int, int4: int, int5: int) -> int: ...
    @typing.overload
    @staticmethod
    def getReorderedIndex(iFormatReader: 'IFormatReader', string: typing.Union[java.lang.String, str], int: int) -> int: ...
    @staticmethod
    def getRequiredDirectories(stringArray: typing.List[java.lang.String]) -> int: ...
    @typing.overload
    @staticmethod
    def getStagePosition(double: float, string: typing.Union[java.lang.String, str]) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def getStagePosition(double: float, unit: ome.units.unit.Unit[ome.units.quantity.Length]) -> ome.units.quantity.Length: ...
    @staticmethod
    def getTileFilename(int: int, int2: int, int3: int, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @staticmethod
    def getTime(double: float, string: typing.Union[java.lang.String, str]) -> ome.units.quantity.Time: ...
    @typing.overload
    @staticmethod
    def getWavelength(double: float) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def getWavelength(double: float, string: typing.Union[java.lang.String, str]) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def getZCTCoords(string: typing.Union[java.lang.String, str], int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def getZCTCoords(string: typing.Union[java.lang.String, str], int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def getZCTCoords(iFormatReader: 'IFormatReader', int: int) -> typing.List[int]: ...
    @staticmethod
    def getZCTModuloCoords(iFormatReader: 'IFormatReader', int: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def isFloatingPoint(int: int) -> bool: ...
    @typing.overload
    @staticmethod
    def isFloatingPoint(iFormatReader: 'IFormatReader') -> bool: ...
    @staticmethod
    def isPositiveValue(double: float) -> bool: ...
    @staticmethod
    def isSigned(int: int) -> bool: ...
    @staticmethod
    def openThumbBytes(iFormatReader: 'IFormatReader', int: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def parseLength(string: typing.Union[java.lang.String, str]) -> ome.units.quantity.Length: ...
    @typing.overload
    @staticmethod
    def parseLength(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> ome.units.quantity.Length: ...
    @staticmethod
    def pixelTypeFromBytes(int: int, boolean: bool, boolean2: bool) -> int: ...
    @staticmethod
    def pixelTypeFromString(string: typing.Union[java.lang.String, str]) -> int: ...
    @staticmethod
    def positionToRaster(intArray: typing.List[int], intArray2: typing.List[int]) -> int: ...
    @typing.overload
    @staticmethod
    def rasterToPosition(intArray: typing.List[int], int2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def rasterToPosition(intArray: typing.List[int], int2: int, intArray2: typing.List[int]) -> typing.List[int]: ...
    @staticmethod
    def validStream(randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, int: int, boolean: bool) -> bool: ...

class IMetadataConfigurable:
    def getMetadataOptions(self) -> bioformats_jar._loci.formats.in_.MetadataOptions: ...
    def getSupportedMetadataLevels(self) -> java.util.Set[loci.formats.in_.MetadataLevel]: ...
    def setMetadataOptions(self, metadataOptions: bioformats_jar._loci.formats.in_.MetadataOptions) -> None: ...

class IPyramidHandler:
    def getResolution(self) -> int: ...
    def getResolutionCount(self) -> int: ...
    def setResolution(self, int: int) -> None: ...

class IllegalBlockException(java.lang.IllegalArgumentException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class ImageTools:
    @staticmethod
    def autoscale(byteArray: typing.List[int], int: int, int2: int, int3: int, boolean: bool) -> typing.List[int]: ...
    @staticmethod
    def bgrToRgb(byteArray: typing.List[int], boolean: bool, int: int, int2: int) -> None: ...
    @staticmethod
    def getSubimage(byteArray: typing.List[int], byteArray2: typing.List[int], int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int, boolean: bool) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def indexedToRGB(byteArray: typing.List[typing.List[int]], byteArray2: typing.List[int]) -> typing.List[typing.List[int]]: ...
    @typing.overload
    @staticmethod
    def indexedToRGB(shortArray: typing.List[typing.List[int]], byteArray: typing.List[int], boolean: bool) -> typing.List[typing.List[int]]: ...
    @staticmethod
    def interpolate(shortArray: typing.List[int], byteArray: typing.List[int], intArray: typing.List[int], int2: int, int3: int, boolean: bool) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def make24Bits(object: typing.Any, int: int, int2: int, boolean: bool, boolean2: bool) -> typing.List[typing.List[int]]: ...
    @typing.overload
    @staticmethod
    def make24Bits(object: typing.Any, int: int, int2: int, boolean: bool, boolean2: bool, double: float, double2: float) -> typing.List[typing.List[int]]: ...
    @typing.overload
    @staticmethod
    def make24Bits(object: typing.Any, int: int, int2: int, boolean: bool) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def make24Bits(object: typing.Any, int: int, int2: int, boolean: bool, double: float, double2: float) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def padImage(byteArray: typing.List[int], boolean: bool, int: int, int2: int, int3: int, int4: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def padImage(doubleArray: typing.List[float], boolean: bool, int: int, int2: int, int3: int, int4: int) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def padImage(floatArray: typing.List[float], boolean: bool, int: int, int2: int, int3: int, int4: int) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def padImage(intArray: typing.List[int], boolean: bool, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def padImage(shortArray: typing.List[int], boolean: bool, int: int, int2: int, int3: int, int4: int) -> typing.List[int]: ...
    @staticmethod
    def scanData(byteArray: typing.List[int], int: int, boolean: bool) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def splitChannels(byteArray: typing.List[int], byteArray2: typing.List[int], int: int, int2: int, int3: int, boolean: bool, boolean2: bool, int4: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def splitChannels(byteArray: typing.List[int], int: int, int2: int, int3: int, boolean: bool, boolean2: bool) -> typing.List[int]: ...

_MetadataList__T = typing.TypeVar('_MetadataList__T')  # <T>
class MetadataList(typing.Generic[_MetadataList__T]):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, int: int, int2: int): ...
    @typing.overload
    def __init__(self, intArray: typing.List[int]): ...
    @typing.overload
    def __init__(self, metadataList: 'MetadataList'[_MetadataList__T]): ...
    @typing.overload
    def add(self) -> None: ...
    @typing.overload
    def add(self, int: int) -> None: ...
    @typing.overload
    def add(self, int: int, t: _MetadataList__T) -> None: ...
    @typing.overload
    def add(self, t: _MetadataList__T) -> None: ...
    @typing.overload
    def add(self, list: java.util.List[_MetadataList__T]) -> None: ...
    @typing.overload
    def clear(self) -> None: ...
    @typing.overload
    def clear(self, int: int) -> None: ...
    def get(self, int: int, int2: int) -> _MetadataList__T: ...
    def set(self, int: int, int2: int, t: _MetadataList__T) -> None: ...
    @typing.overload
    def size(self) -> int: ...
    @typing.overload
    def size(self, int: int) -> int: ...
    def sizes(self) -> typing.List[int]: ...

class MetadataTools:
    @staticmethod
    def createLSID(string: typing.Union[java.lang.String, str], intArray: typing.List[int]) -> java.lang.String: ...
    @staticmethod
    def createOMEXMLMetadata() -> bioformats_jar._loci.formats.meta.IMetadata: ...
    @staticmethod
    def getAcquisitionMode(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.AcquisitionMode: ...
    @staticmethod
    def getArcType(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.ArcType: ...
    @staticmethod
    def getBinning(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.Binning: ...
    @staticmethod
    def getCompression(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.Compression: ...
    @staticmethod
    def getContrastMethod(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.ContrastMethod: ...
    @staticmethod
    def getCorrection(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.Correction: ...
    @staticmethod
    def getDetectorType(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.DetectorType: ...
    @staticmethod
    def getDimensionOrder(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.DimensionOrder: ...
    @staticmethod
    def getExperimentType(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.ExperimentType: ...
    @staticmethod
    def getFilamentType(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.FilamentType: ...
    @staticmethod
    def getFillRule(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.FillRule: ...
    @staticmethod
    def getFilterType(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.FilterType: ...
    @staticmethod
    def getFontFamily(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.FontFamily: ...
    @staticmethod
    def getFontStyle(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.FontStyle: ...
    @staticmethod
    def getIlluminationType(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.IlluminationType: ...
    @staticmethod
    def getImmersion(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.Immersion: ...
    @staticmethod
    def getLaserMedium(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.LaserMedium: ...
    @staticmethod
    def getLaserType(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.LaserType: ...
    @staticmethod
    def getMarker(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.Marker: ...
    @staticmethod
    def getMedium(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.Medium: ...
    @staticmethod
    def getMicrobeamManipulationType(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.MicrobeamManipulationType: ...
    @staticmethod
    def getMicroscopeType(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.MicroscopeType: ...
    @staticmethod
    def getNamingConvention(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.NamingConvention: ...
    @staticmethod
    def getPixelType(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.PixelType: ...
    @staticmethod
    def getPulse(string: typing.Union[java.lang.String, str]) -> ome.xml.model.enums.Pulse: ...
    @staticmethod
    def keys(hashtable: java.util.Hashtable[typing.Union[java.lang.String, str], typing.Any]) -> typing.List[java.lang.String]: ...
    @staticmethod
    def makeSaneDimensionOrder(string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @staticmethod
    def merge(map: typing.Union[java.util.Map[typing.Union[java.lang.String, str], typing.Any], typing.Mapping[typing.Union[java.lang.String, str], typing.Any]], map2: typing.Union[java.util.Map[typing.Union[java.lang.String, str], typing.Any], typing.Mapping[typing.Union[java.lang.String, str], typing.Any]], string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    @staticmethod
    def populateMetadata(metadataStore: bioformats_jar._loci.formats.meta.MetadataStore, int: int, string: typing.Union[java.lang.String, str], boolean: bool, string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], int2: int, int3: int, int4: int, int5: int, int6: int, int7: int) -> None: ...
    @typing.overload
    @staticmethod
    def populateMetadata(metadataStore: bioformats_jar._loci.formats.meta.MetadataStore, int: int, string: typing.Union[java.lang.String, str], coreMetadata: CoreMetadata) -> None: ...
    @typing.overload
    @staticmethod
    def populateMetadata(metadataStore: bioformats_jar._loci.formats.meta.MetadataStore, string: typing.Union[java.lang.String, str], int: int, string2: typing.Union[java.lang.String, str], boolean: bool, string3: typing.Union[java.lang.String, str], string4: typing.Union[java.lang.String, str], int2: int, int3: int, int4: int, int5: int, int6: int, int7: int) -> None: ...
    @typing.overload
    @staticmethod
    def populatePixels(metadataStore: bioformats_jar._loci.formats.meta.MetadataStore, iFormatReader: 'IFormatReader') -> None: ...
    @typing.overload
    @staticmethod
    def populatePixels(metadataStore: bioformats_jar._loci.formats.meta.MetadataStore, iFormatReader: 'IFormatReader', boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def populatePixels(metadataStore: bioformats_jar._loci.formats.meta.MetadataStore, iFormatReader: 'IFormatReader', boolean: bool, boolean2: bool) -> None: ...
    @typing.overload
    @staticmethod
    def populatePixelsOnly(metadataStore: bioformats_jar._loci.formats.meta.MetadataStore, int: int, boolean: bool, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], int2: int, int3: int, int4: int, int5: int, int6: int, int7: int) -> None: ...
    @typing.overload
    @staticmethod
    def populatePixelsOnly(metadataStore: bioformats_jar._loci.formats.meta.MetadataStore, iFormatReader: 'IFormatReader') -> None: ...
    @staticmethod
    def setDefaultCreationDate(metadataStore: bioformats_jar._loci.formats.meta.MetadataStore, string: typing.Union[java.lang.String, str], int: int) -> None: ...
    @staticmethod
    def setDefaultDateEnabled(boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def verifyMinimumPopulated(metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve) -> None: ...
    @typing.overload
    @staticmethod
    def verifyMinimumPopulated(metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve, int: int) -> None: ...

class Modulo:
    parentDimension: java.lang.String = ...
    start: float = ...
    step: float = ...
    end: float = ...
    parentType: java.lang.String = ...
    type: java.lang.String = ...
    typeDescription: java.lang.String = ...
    unit: java.lang.String = ...
    labels: typing.List[java.lang.String] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, modulo: 'Modulo'): ...
    def length(self) -> int: ...
    def toXMLAnnotation(self) -> java.lang.String: ...

class NumberFilter(java.io.FileFilter):
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def accept(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> bool: ...
    @typing.overload
    def accept(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def getNumber(self, string: typing.Union[java.lang.String, str]) -> java.math.BigInteger: ...

class Resolution:
    sizeX: ome.xml.model.primitives.PositiveInteger = ...
    sizeY: ome.xml.model.primitives.PositiveInteger = ...
    index: int = ...
    @typing.overload
    def __init__(self, int: int, int2: int, int3: int): ...
    @typing.overload
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...

class ResourceNamer:
    PLATE: typing.ClassVar[java.lang.String] = ...
    RUN: typing.ClassVar[java.lang.String] = ...
    WELL: typing.ClassVar[java.lang.String] = ...
    FIELD: typing.ClassVar[java.lang.String] = ...
    FAKE_EXT: typing.ClassVar[java.lang.String] = ...
    DOT: typing.ClassVar[java.lang.String] = ...
    def __init__(self, int: int): ...
    @staticmethod
    def alphabeticIndexCount(string: typing.Union[java.lang.String, str]) -> int: ...
    def getLetter(self) -> java.lang.String: ...
    def getLocationFromResourceName(self, location: bioformats_jar._loci.common.Location, string: typing.Union[java.lang.String, str], int: int, string2: typing.Union[java.lang.String, str]) -> bioformats_jar._loci.common.Location: ...
    def nextLetter(self) -> None: ...
    def restartAlphabet(self) -> None: ...

class UpgradeChecker:
    REGISTRY_IMAGEJ: typing.ClassVar[java.lang.String] = ...
    REGISTRY_LIBRARY: typing.ClassVar[java.lang.String] = ...
    STABLE_VERSION: typing.ClassVar[java.lang.String] = ...
    CI_SERVER: typing.ClassVar[java.lang.String] = ...
    TRUNK_BUILD: typing.ClassVar[java.lang.String] = ...
    DAILY_BUILD: typing.ClassVar[java.lang.String] = ...
    STABLE_BUILD: typing.ClassVar[java.lang.String] = ...
    TOOLS: typing.ClassVar[java.lang.String] = ...
    OLD_TOOLS: typing.ClassVar[java.lang.String] = ...
    OME_TOOLS: typing.ClassVar[java.lang.String] = ...
    INDIVIDUAL_JARS: typing.ClassVar[typing.List[java.lang.String]] = ...
    REGISTRY: typing.ClassVar[java.lang.String] = ...
    DEFAULT_CALLER: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    def alreadyChecked(self) -> bool: ...
    def canDoUpgradeCheck(self) -> bool: ...
    def install(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> bool: ...
    def installIndividualJars(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def newVersionAvailable(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def newVersionAvailable(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> bool: ...
    def setCanDoUpgradeCheck(self, boolean: bool) -> None: ...

class CoreMetadataList(MetadataList[CoreMetadata]):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, int: int, int2: int): ...
    @typing.overload
    def __init__(self, intArray: typing.List[int]): ...
    @typing.overload
    def __init__(self, list: java.util.List[CoreMetadata]): ...
    @typing.overload
    def __init__(self, coreMetadataList: 'CoreMetadataList'): ...
    @typing.overload
    def add(self, int: int, coreMetadata: CoreMetadata) -> None: ...
    @typing.overload
    def add(self) -> None: ...
    @typing.overload
    def add(self, int: int) -> None: ...
    @typing.overload
    def add(self, t: typing.Any) -> None: ...
    @typing.overload
    def add(self, list: java.util.List[typing.Any]) -> None: ...
    def flattenedIndex(self, int: int, int2: int) -> int: ...
    def flattenedIndexes(self, int: int) -> typing.List[int]: ...
    def flattenedSize(self) -> int: ...
    def getFlattenedList(self) -> java.util.List[CoreMetadata]: ...
    def getSeriesList(self) -> java.util.List[CoreMetadata]: ...
    def reorder(self) -> None: ...
    def setFlattenedList(self, list: java.util.List[CoreMetadata]) -> None: ...

class IFormatHandler(java.io.Closeable, IMetadataConfigurable):
    def getFormat(self) -> java.lang.String: ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    def getSuffixes(self) -> typing.List[java.lang.String]: ...
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...

class MissingLibraryException(FormatException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SwappableMetadata(CoreMetadata):
    inputOrder: java.lang.String = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, iFormatReader: 'IFormatReader', int: int): ...
    @typing.overload
    def __init__(self, swappableMetadata: 'SwappableMetadata'): ...
    @typing.overload
    def clone(self) -> typing.Any: ...
    @typing.overload
    def clone(self, iFormatReader: 'IFormatReader', int: int) -> CoreMetadata: ...

class UnknownFormatException(FormatException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class UnsupportedCompressionException(FormatException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class FormatHandler(IFormatHandler):
    COMPRESSION_SUFFIXES: typing.ClassVar[typing.List[java.lang.String]] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    @typing.overload
    @staticmethod
    def checkSuffix(string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    @staticmethod
    def checkSuffix(string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]) -> bool: ...
    def getFormat(self) -> java.lang.String: ...
    def getMetadataOptions(self) -> bioformats_jar._loci.formats.in_.MetadataOptions: ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    def getSuffixes(self) -> typing.List[java.lang.String]: ...
    def getSupportedMetadataLevels(self) -> java.util.Set[loci.formats.in_.MetadataLevel]: ...
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def setMetadataOptions(self, metadataOptions: bioformats_jar._loci.formats.in_.MetadataOptions) -> None: ...

class IFormatReader(IFormatHandler, IPyramidHandler):
    MUST_GROUP: typing.ClassVar[int] = ...
    CAN_GROUP: typing.ClassVar[int] = ...
    CANNOT_GROUP: typing.ClassVar[int] = ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def coreIndexToSeries(self, int: int) -> int: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getAdvancedSeriesUsedFiles(self, boolean: bool) -> typing.List[FileInfo]: ...
    def getAdvancedUsedFiles(self, boolean: bool) -> typing.List[FileInfo]: ...
    def getBitsPerPixel(self) -> int: ...
    def getCoreIndex(self) -> int: ...
    def getCoreMetadataList(self) -> java.util.List[CoreMetadata]: ...
    def getCurrentFile(self) -> java.lang.String: ...
    def getDatasetStructureDescription(self) -> java.lang.String: ...
    def getDimensionOrder(self) -> java.lang.String: ...
    def getDomains(self) -> typing.List[java.lang.String]: ...
    def getEffectiveSizeC(self) -> int: ...
    def getGlobalMetadata(self) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    def getImageCount(self) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> int: ...
    def getMetadataStore(self) -> bioformats_jar._loci.formats.meta.MetadataStore: ...
    def getMetadataStoreRoot(self) -> typing.Any: ...
    def getMetadataValue(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def getModuloC(self) -> Modulo: ...
    def getModuloT(self) -> Modulo: ...
    def getModuloZ(self) -> Modulo: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    def getPixelType(self) -> int: ...
    def getPossibleDomains(self, string: typing.Union[java.lang.String, str]) -> typing.List[java.lang.String]: ...
    def getRGBChannelCount(self) -> int: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    def getSeries(self) -> int: ...
    def getSeriesCount(self) -> int: ...
    def getSeriesMetadata(self) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    def getSeriesMetadataValue(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def getSizeC(self) -> int: ...
    def getSizeT(self) -> int: ...
    def getSizeX(self) -> int: ...
    def getSizeY(self) -> int: ...
    def getSizeZ(self) -> int: ...
    def getThumbSizeX(self) -> int: ...
    def getThumbSizeY(self) -> int: ...
    def getUnderlyingReaders(self) -> typing.List['IFormatReader']: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def getZCTCoords(self, int: int) -> typing.List[int]: ...
    def getZCTModuloCoords(self, int: int) -> typing.List[int]: ...
    def hasCompanionFiles(self) -> bool: ...
    def hasFlattenedResolutions(self) -> bool: ...
    def isFalseColor(self) -> bool: ...
    def isGroupFiles(self) -> bool: ...
    def isIndexed(self) -> bool: ...
    @typing.overload
    def isInterleaved(self) -> bool: ...
    @typing.overload
    def isInterleaved(self, int: int) -> bool: ...
    def isLittleEndian(self) -> bool: ...
    def isMetadataComplete(self) -> bool: ...
    def isMetadataFiltered(self) -> bool: ...
    def isNormalized(self) -> bool: ...
    def isOrderCertain(self) -> bool: ...
    def isOriginalMetadataPopulated(self) -> bool: ...
    def isRGB(self) -> bool: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    def isThumbnailSeries(self) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openPlane(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.Any: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...
    def seriesToCoreIndex(self, int: int) -> int: ...
    def setCoreIndex(self, int: int) -> None: ...
    def setFlattenedResolutions(self, boolean: bool) -> None: ...
    def setGroupFiles(self, boolean: bool) -> None: ...
    def setMetadataFiltered(self, boolean: bool) -> None: ...
    def setMetadataStore(self, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    def setNormalized(self, boolean: bool) -> None: ...
    def setOriginalMetadataPopulated(self, boolean: bool) -> None: ...
    def setSeries(self, int: int) -> None: ...

class IFormatWriter(IFormatHandler, IPyramidHandler):
    def canDoStacks(self) -> bool: ...
    def changeOutputFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def getColorModel(self) -> java.awt.image.ColorModel: ...
    def getCompression(self) -> java.lang.String: ...
    def getCompressionTypes(self) -> typing.List[java.lang.String]: ...
    def getFramesPerSecond(self) -> int: ...
    def getMetadataRetrieve(self) -> bioformats_jar._loci.formats.meta.MetadataRetrieve: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    def getResolutions(self) -> java.util.List[Resolution]: ...
    def getSeries(self) -> int: ...
    def getTileSizeX(self) -> int: ...
    def getTileSizeY(self) -> int: ...
    def isInterleaved(self) -> bool: ...
    def isSupportedType(self, int: int) -> bool: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any, int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any, region: bioformats_jar._loci.common.Region) -> None: ...
    def setCodecOptions(self, codecOptions: bioformats_jar._loci.formats.codec.CodecOptions) -> None: ...
    def setColorModel(self, colorModel: java.awt.image.ColorModel) -> None: ...
    def setCompression(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFramesPerSecond(self, int: int) -> None: ...
    def setInterleaved(self, boolean: bool) -> None: ...
    def setMetadataRetrieve(self, metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve) -> None: ...
    def setResolutions(self, list: java.util.List[Resolution]) -> None: ...
    def setSeries(self, int: int) -> None: ...
    def setTileSizeX(self, int: int) -> int: ...
    def setTileSizeY(self, int: int) -> int: ...
    def setValidBitsPerPixel(self, int: int) -> None: ...
    def setWriteSequentially(self, boolean: bool) -> None: ...

class FormatReader(FormatHandler, IFormatReader):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def coreIndexToSeries(self, int: int) -> int: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getAdvancedSeriesUsedFiles(self, boolean: bool) -> typing.List[FileInfo]: ...
    def getAdvancedUsedFiles(self, boolean: bool) -> typing.List[FileInfo]: ...
    def getBitsPerPixel(self) -> int: ...
    def getCoreIndex(self) -> int: ...
    def getCoreMetadataList(self) -> java.util.List[CoreMetadata]: ...
    def getCurrentFile(self) -> java.lang.String: ...
    def getDatasetStructureDescription(self) -> java.lang.String: ...
    def getDimensionOrder(self) -> java.lang.String: ...
    def getDomains(self) -> typing.List[java.lang.String]: ...
    def getEffectiveSizeC(self) -> int: ...
    def getGlobalMetadata(self) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    def getImageCount(self) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> int: ...
    def getMetadataStore(self) -> bioformats_jar._loci.formats.meta.MetadataStore: ...
    def getMetadataStoreRoot(self) -> typing.Any: ...
    def getMetadataValue(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def getModuloC(self) -> Modulo: ...
    def getModuloT(self) -> Modulo: ...
    def getModuloZ(self) -> Modulo: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    def getPixelType(self) -> int: ...
    def getPossibleDomains(self, string: typing.Union[java.lang.String, str]) -> typing.List[java.lang.String]: ...
    def getRGBChannelCount(self) -> int: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    def getResolution(self) -> int: ...
    def getResolutionCount(self) -> int: ...
    def getSeries(self) -> int: ...
    def getSeriesCount(self) -> int: ...
    def getSeriesMetadata(self) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    def getSeriesMetadataValue(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def getSizeC(self) -> int: ...
    def getSizeT(self) -> int: ...
    def getSizeX(self) -> int: ...
    def getSizeY(self) -> int: ...
    def getSizeZ(self) -> int: ...
    def getThumbSizeX(self) -> int: ...
    def getThumbSizeY(self) -> int: ...
    def getUnderlyingReaders(self) -> typing.List[IFormatReader]: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def getZCTCoords(self, int: int) -> typing.List[int]: ...
    def getZCTModuloCoords(self, int: int) -> typing.List[int]: ...
    def hasCompanionFiles(self) -> bool: ...
    def hasFlattenedResolutions(self) -> bool: ...
    def isFalseColor(self) -> bool: ...
    def isGroupFiles(self) -> bool: ...
    def isIndexed(self) -> bool: ...
    @typing.overload
    def isInterleaved(self) -> bool: ...
    @typing.overload
    def isInterleaved(self, int: int) -> bool: ...
    def isLittleEndian(self) -> bool: ...
    def isMetadataComplete(self) -> bool: ...
    def isMetadataFiltered(self) -> bool: ...
    def isNormalized(self) -> bool: ...
    def isOrderCertain(self) -> bool: ...
    def isOriginalMetadataPopulated(self) -> bool: ...
    def isRGB(self) -> bool: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    def isThumbnailSeries(self) -> bool: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openPlane(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.Any: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...
    def seriesToCoreIndex(self, int: int) -> int: ...
    def setCoreIndex(self, int: int) -> None: ...
    def setFlattenedResolutions(self, boolean: bool) -> None: ...
    def setGroupFiles(self, boolean: bool) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMetadataFiltered(self, boolean: bool) -> None: ...
    def setMetadataStore(self, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    def setNormalized(self, boolean: bool) -> None: ...
    def setOriginalMetadataPopulated(self, boolean: bool) -> None: ...
    def setResolution(self, int: int) -> None: ...
    def setSeries(self, int: int) -> None: ...

class FormatWriter(FormatHandler, IFormatWriter):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    def canDoStacks(self) -> bool: ...
    def changeOutputFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def close(self) -> None: ...
    def getColorModel(self) -> java.awt.image.ColorModel: ...
    def getCompression(self) -> java.lang.String: ...
    def getCompressionTypes(self) -> typing.List[java.lang.String]: ...
    def getFramesPerSecond(self) -> int: ...
    def getMetadataRetrieve(self) -> bioformats_jar._loci.formats.meta.MetadataRetrieve: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    def getResolution(self) -> int: ...
    def getResolutionCount(self) -> int: ...
    def getResolutions(self) -> java.util.List[Resolution]: ...
    def getSeries(self) -> int: ...
    def getTileSizeX(self) -> int: ...
    def getTileSizeY(self) -> int: ...
    def isInterleaved(self) -> bool: ...
    def isSupportedType(self, int: int) -> bool: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any, int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any, region: bioformats_jar._loci.common.Region) -> None: ...
    def setCodecOptions(self, codecOptions: bioformats_jar._loci.formats.codec.CodecOptions) -> None: ...
    def setColorModel(self, colorModel: java.awt.image.ColorModel) -> None: ...
    def setCompression(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFramesPerSecond(self, int: int) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInterleaved(self, boolean: bool) -> None: ...
    def setMetadataRetrieve(self, metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve) -> None: ...
    def setResolution(self, int: int) -> None: ...
    def setResolutions(self, list: java.util.List[Resolution]) -> None: ...
    def setSeries(self, int: int) -> None: ...
    def setTileSizeX(self, int: int) -> int: ...
    def setTileSizeY(self, int: int) -> int: ...
    def setValidBitsPerPixel(self, int: int) -> None: ...
    def setWriteSequentially(self, boolean: bool) -> None: ...

class ImageReader(IFormatReader):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, classList: ClassList[IFormatReader]): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def coreIndexToSeries(self, int: int) -> int: ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getAdvancedSeriesUsedFiles(self, boolean: bool) -> typing.List[FileInfo]: ...
    def getAdvancedUsedFiles(self, boolean: bool) -> typing.List[FileInfo]: ...
    def getBitsPerPixel(self) -> int: ...
    def getCoreIndex(self) -> int: ...
    def getCoreMetadataList(self) -> java.util.List[CoreMetadata]: ...
    def getCurrentFile(self) -> java.lang.String: ...
    def getDatasetStructureDescription(self) -> java.lang.String: ...
    @staticmethod
    def getDefaultReaderClasses() -> ClassList[IFormatReader]: ...
    def getDimensionOrder(self) -> java.lang.String: ...
    def getDomains(self) -> typing.List[java.lang.String]: ...
    def getEffectiveSizeC(self) -> int: ...
    @typing.overload
    def getFormat(self) -> java.lang.String: ...
    @typing.overload
    def getFormat(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def getGlobalMetadata(self) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    def getImageCount(self) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> int: ...
    def getMetadataOptions(self) -> bioformats_jar._loci.formats.in_.MetadataOptions: ...
    def getMetadataStore(self) -> bioformats_jar._loci.formats.meta.MetadataStore: ...
    def getMetadataStoreRoot(self) -> typing.Any: ...
    def getMetadataValue(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def getModuloC(self) -> Modulo: ...
    def getModuloT(self) -> Modulo: ...
    def getModuloZ(self) -> Modulo: ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    def getPixelType(self) -> int: ...
    def getPossibleDomains(self, string: typing.Union[java.lang.String, str]) -> typing.List[java.lang.String]: ...
    def getRGBChannelCount(self) -> int: ...
    @typing.overload
    def getReader(self) -> IFormatReader: ...
    @typing.overload
    def getReader(self, class_: typing.Type[IFormatReader]) -> IFormatReader: ...
    @typing.overload
    def getReader(self, string: typing.Union[java.lang.String, str]) -> IFormatReader: ...
    def getReaders(self) -> typing.List[IFormatReader]: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    def getResolution(self) -> int: ...
    def getResolutionCount(self) -> int: ...
    def getSeries(self) -> int: ...
    def getSeriesCount(self) -> int: ...
    def getSeriesMetadata(self) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    def getSeriesMetadataValue(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def getSizeC(self) -> int: ...
    def getSizeT(self) -> int: ...
    def getSizeX(self) -> int: ...
    def getSizeY(self) -> int: ...
    def getSizeZ(self) -> int: ...
    def getSuffixes(self) -> typing.List[java.lang.String]: ...
    def getSupportedMetadataLevels(self) -> java.util.Set[loci.formats.in_.MetadataLevel]: ...
    def getThumbSizeX(self) -> int: ...
    def getThumbSizeY(self) -> int: ...
    def getUnderlyingReaders(self) -> typing.List[IFormatReader]: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def getZCTCoords(self, int: int) -> typing.List[int]: ...
    def getZCTModuloCoords(self, int: int) -> typing.List[int]: ...
    def hasCompanionFiles(self) -> bool: ...
    def hasFlattenedResolutions(self) -> bool: ...
    def isFalseColor(self) -> bool: ...
    def isGroupFiles(self) -> bool: ...
    def isIndexed(self) -> bool: ...
    @typing.overload
    def isInterleaved(self) -> bool: ...
    @typing.overload
    def isInterleaved(self, int: int) -> bool: ...
    def isLittleEndian(self) -> bool: ...
    def isMetadataComplete(self) -> bool: ...
    def isMetadataFiltered(self) -> bool: ...
    def isNormalized(self) -> bool: ...
    def isOrderCertain(self) -> bool: ...
    def isOriginalMetadataPopulated(self) -> bool: ...
    def isRGB(self) -> bool: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    def isThumbnailSeries(self) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openPlane(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.Any: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...
    def seriesToCoreIndex(self, int: int) -> int: ...
    def setAllowOpenFiles(self, boolean: bool) -> None: ...
    def setCoreIndex(self, int: int) -> None: ...
    def setFlattenedResolutions(self, boolean: bool) -> None: ...
    def setGroupFiles(self, boolean: bool) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMetadataFiltered(self, boolean: bool) -> None: ...
    def setMetadataOptions(self, metadataOptions: bioformats_jar._loci.formats.in_.MetadataOptions) -> None: ...
    def setMetadataStore(self, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    def setNormalized(self, boolean: bool) -> None: ...
    def setOriginalMetadataPopulated(self, boolean: bool) -> None: ...
    def setResolution(self, int: int) -> None: ...
    def setSeries(self, int: int) -> None: ...

class ImageWriter(IFormatWriter):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, classList: ClassList[IFormatWriter]): ...
    def canDoStacks(self) -> bool: ...
    def changeOutputFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def close(self) -> None: ...
    def getColorModel(self) -> java.awt.image.ColorModel: ...
    def getCompression(self) -> java.lang.String: ...
    def getCompressionTypes(self) -> typing.List[java.lang.String]: ...
    @staticmethod
    def getDefaultWriterClasses() -> ClassList[IFormatWriter]: ...
    @typing.overload
    def getFormat(self) -> java.lang.String: ...
    @typing.overload
    def getFormat(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def getFramesPerSecond(self) -> int: ...
    def getMetadataOptions(self) -> bioformats_jar._loci.formats.in_.MetadataOptions: ...
    def getMetadataRetrieve(self) -> bioformats_jar._loci.formats.meta.MetadataRetrieve: ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    def getResolution(self) -> int: ...
    def getResolutionCount(self) -> int: ...
    def getResolutions(self) -> java.util.List[Resolution]: ...
    def getSeries(self) -> int: ...
    def getSuffixes(self) -> typing.List[java.lang.String]: ...
    def getSupportedMetadataLevels(self) -> java.util.Set[loci.formats.in_.MetadataLevel]: ...
    def getTileSizeX(self) -> int: ...
    def getTileSizeY(self) -> int: ...
    @typing.overload
    def getWriter(self) -> IFormatWriter: ...
    @typing.overload
    def getWriter(self, class_: typing.Type[IFormatWriter]) -> IFormatWriter: ...
    @typing.overload
    def getWriter(self, string: typing.Union[java.lang.String, str]) -> IFormatWriter: ...
    def getWriters(self) -> typing.List[IFormatWriter]: ...
    def isInterleaved(self) -> bool: ...
    def isSupportedType(self, int: int) -> bool: ...
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any, int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any, region: bioformats_jar._loci.common.Region) -> None: ...
    def setCodecOptions(self, codecOptions: bioformats_jar._loci.formats.codec.CodecOptions) -> None: ...
    def setColorModel(self, colorModel: java.awt.image.ColorModel) -> None: ...
    def setCompression(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFramesPerSecond(self, int: int) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInterleaved(self, boolean: bool) -> None: ...
    def setMetadataOptions(self, metadataOptions: bioformats_jar._loci.formats.in_.MetadataOptions) -> None: ...
    def setMetadataRetrieve(self, metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve) -> None: ...
    def setResolution(self, int: int) -> None: ...
    def setResolutions(self, list: java.util.List[Resolution]) -> None: ...
    def setSeries(self, int: int) -> None: ...
    def setTileSizeX(self, int: int) -> int: ...
    def setTileSizeY(self, int: int) -> int: ...
    def setValidBitsPerPixel(self, int: int) -> None: ...
    def setWriteSequentially(self, boolean: bool) -> None: ...

class ReaderWrapper(IFormatReader):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, iFormatReader: IFormatReader): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def coreIndexToSeries(self, int: int) -> int: ...
    def duplicate(self, class_: typing.Type[IFormatReader]) -> 'ReaderWrapper': ...
    def fileGroupOption(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getAdvancedSeriesUsedFiles(self, boolean: bool) -> typing.List[FileInfo]: ...
    def getAdvancedUsedFiles(self, boolean: bool) -> typing.List[FileInfo]: ...
    def getBitsPerPixel(self) -> int: ...
    def getCoreIndex(self) -> int: ...
    def getCoreMetadataList(self) -> java.util.List[CoreMetadata]: ...
    def getCurrentFile(self) -> java.lang.String: ...
    def getDatasetStructureDescription(self) -> java.lang.String: ...
    def getDimensionOrder(self) -> java.lang.String: ...
    def getDomains(self) -> typing.List[java.lang.String]: ...
    def getEffectiveSizeC(self) -> int: ...
    def getFormat(self) -> java.lang.String: ...
    def getGlobalMetadata(self) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    def getImageCount(self) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> int: ...
    def getMetadataOptions(self) -> bioformats_jar._loci.formats.in_.MetadataOptions: ...
    def getMetadataStore(self) -> bioformats_jar._loci.formats.meta.MetadataStore: ...
    def getMetadataStoreRoot(self) -> typing.Any: ...
    def getMetadataValue(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def getModuloC(self) -> Modulo: ...
    def getModuloT(self) -> Modulo: ...
    def getModuloZ(self) -> Modulo: ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    def getPixelType(self) -> int: ...
    def getPossibleDomains(self, string: typing.Union[java.lang.String, str]) -> typing.List[java.lang.String]: ...
    def getRGBChannelCount(self) -> int: ...
    def getReader(self) -> IFormatReader: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    def getResolution(self) -> int: ...
    def getResolutionCount(self) -> int: ...
    def getSeries(self) -> int: ...
    def getSeriesCount(self) -> int: ...
    def getSeriesMetadata(self) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    def getSeriesMetadataValue(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def getSizeC(self) -> int: ...
    def getSizeT(self) -> int: ...
    def getSizeX(self) -> int: ...
    def getSizeY(self) -> int: ...
    def getSizeZ(self) -> int: ...
    def getSuffixes(self) -> typing.List[java.lang.String]: ...
    def getSupportedMetadataLevels(self) -> java.util.Set[loci.formats.in_.MetadataLevel]: ...
    def getThumbSizeX(self) -> int: ...
    def getThumbSizeY(self) -> int: ...
    def getUnderlyingReaders(self) -> typing.List[IFormatReader]: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def getZCTCoords(self, int: int) -> typing.List[int]: ...
    def getZCTModuloCoords(self, int: int) -> typing.List[int]: ...
    def hasCompanionFiles(self) -> bool: ...
    def hasFlattenedResolutions(self) -> bool: ...
    def isFalseColor(self) -> bool: ...
    def isGroupFiles(self) -> bool: ...
    def isIndexed(self) -> bool: ...
    @typing.overload
    def isInterleaved(self) -> bool: ...
    @typing.overload
    def isInterleaved(self, int: int) -> bool: ...
    def isLittleEndian(self) -> bool: ...
    def isMetadataComplete(self) -> bool: ...
    def isMetadataFiltered(self) -> bool: ...
    def isNormalized(self) -> bool: ...
    def isOrderCertain(self) -> bool: ...
    def isOriginalMetadataPopulated(self) -> bool: ...
    def isRGB(self) -> bool: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    def isThumbnailSeries(self) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openPlane(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.Any: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...
    def seriesToCoreIndex(self, int: int) -> int: ...
    def setCoreIndex(self, int: int) -> None: ...
    def setFlattenedResolutions(self, boolean: bool) -> None: ...
    def setGroupFiles(self, boolean: bool) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMetadataFiltered(self, boolean: bool) -> None: ...
    def setMetadataOptions(self, metadataOptions: bioformats_jar._loci.formats.in_.MetadataOptions) -> None: ...
    def setMetadataStore(self, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    def setNormalized(self, boolean: bool) -> None: ...
    def setOriginalMetadataPopulated(self, boolean: bool) -> None: ...
    def setResolution(self, int: int) -> None: ...
    def setSeries(self, int: int) -> None: ...
    @typing.overload
    def unwrap(self) -> IFormatReader: ...
    @typing.overload
    def unwrap(self, class_: typing.Type[IFormatReader], string: typing.Union[java.lang.String, str]) -> IFormatReader: ...
    @typing.overload
    def unwrap(self, string: typing.Union[java.lang.String, str]) -> IFormatReader: ...

class WriterWrapper(IFormatWriter):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, iFormatWriter: IFormatWriter): ...
    def canDoStacks(self) -> bool: ...
    def changeOutputFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def close(self) -> None: ...
    def duplicate(self, class_: typing.Type[IFormatWriter]) -> 'WriterWrapper': ...
    def getColorModel(self) -> java.awt.image.ColorModel: ...
    def getCompression(self) -> java.lang.String: ...
    def getCompressionTypes(self) -> typing.List[java.lang.String]: ...
    def getFormat(self) -> java.lang.String: ...
    def getFramesPerSecond(self) -> int: ...
    def getMetadataOptions(self) -> bioformats_jar._loci.formats.in_.MetadataOptions: ...
    def getMetadataRetrieve(self) -> bioformats_jar._loci.formats.meta.MetadataRetrieve: ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    def getResolution(self) -> int: ...
    def getResolutionCount(self) -> int: ...
    def getResolutions(self) -> java.util.List[Resolution]: ...
    def getSeries(self) -> int: ...
    def getSuffixes(self) -> typing.List[java.lang.String]: ...
    def getSupportedMetadataLevels(self) -> java.util.Set[loci.formats.in_.MetadataLevel]: ...
    def getTileSizeX(self) -> int: ...
    def getTileSizeY(self) -> int: ...
    def getWriter(self) -> IFormatWriter: ...
    def isInterleaved(self) -> bool: ...
    def isSupportedType(self, int: int) -> bool: ...
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any, int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any, region: bioformats_jar._loci.common.Region) -> None: ...
    def setCodecOptions(self, codecOptions: bioformats_jar._loci.formats.codec.CodecOptions) -> None: ...
    def setColorModel(self, colorModel: java.awt.image.ColorModel) -> None: ...
    def setCompression(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFramesPerSecond(self, int: int) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInterleaved(self, boolean: bool) -> None: ...
    def setMetadataOptions(self, metadataOptions: bioformats_jar._loci.formats.in_.MetadataOptions) -> None: ...
    def setMetadataRetrieve(self, metadataRetrieve: bioformats_jar._loci.formats.meta.MetadataRetrieve) -> None: ...
    def setResolution(self, int: int) -> None: ...
    def setResolutions(self, list: java.util.List[Resolution]) -> None: ...
    def setSeries(self, int: int) -> None: ...
    def setTileSizeX(self, int: int) -> int: ...
    def setTileSizeY(self, int: int) -> int: ...
    def setValidBitsPerPixel(self, int: int) -> None: ...
    def setWriteSequentially(self, boolean: bool) -> None: ...
    @typing.overload
    def unwrap(self) -> IFormatWriter: ...
    @typing.overload
    def unwrap(self, class_: typing.Type[IFormatWriter], string: typing.Union[java.lang.String, str]) -> IFormatWriter: ...
    @typing.overload
    def unwrap(self, string: typing.Union[java.lang.String, str]) -> IFormatWriter: ...

class ChannelFiller(ReaderWrapper):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, iFormatReader: IFormatReader): ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getBitsPerPixel(self) -> int: ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    def getSizeC(self) -> int: ...
    def isFilled(self) -> bool: ...
    def isIndexed(self) -> bool: ...
    def isRGB(self) -> bool: ...
    @staticmethod
    def makeChannelFiller(iFormatReader: IFormatReader) -> 'ChannelFiller': ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def setFilled(self, boolean: bool) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...

class ChannelMerger(ReaderWrapper):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, iFormatReader: IFormatReader): ...
    def canMerge(self) -> bool: ...
    def getDimensionOrder(self) -> java.lang.String: ...
    def getImageCount(self) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> int: ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    def getOriginalIndex(self, int: int) -> int: ...
    def getZCTCoords(self, int: int) -> typing.List[int]: ...
    def getZCTModuloCoords(self, int: int) -> typing.List[int]: ...
    def isIndexed(self) -> bool: ...
    @typing.overload
    def isInterleaved(self) -> bool: ...
    @typing.overload
    def isInterleaved(self, int: int) -> bool: ...
    def isRGB(self) -> bool: ...
    @staticmethod
    def makeChannelMerger(iFormatReader: IFormatReader) -> 'ChannelMerger': ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...

class ChannelSeparator(ReaderWrapper):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, iFormatReader: IFormatReader): ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def close(self) -> None: ...
    def getDimensionOrder(self) -> java.lang.String: ...
    def getImageCount(self) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> int: ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    def getOriginalIndex(self, int: int) -> int: ...
    def getZCTCoords(self, int: int) -> typing.List[int]: ...
    def getZCTModuloCoords(self, int: int) -> typing.List[int]: ...
    def isRGB(self) -> bool: ...
    @staticmethod
    def makeChannelSeparator(iFormatReader: IFormatReader) -> 'ChannelSeparator': ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...

class DelegateReader(FormatReader):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def close(self) -> None: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getMetadataOptions(self) -> bioformats_jar._loci.formats.in_.MetadataOptions: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    def getSupportedMetadataLevels(self) -> java.util.Set[loci.formats.in_.MetadataLevel]: ...
    def isLegacy(self) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def isThisType(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> bool: ...
    @typing.overload
    def isThisType(self, byteArray: typing.List[int]) -> bool: ...
    @typing.overload
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...
    def setCoreIndex(self, int: int) -> None: ...
    def setFlattenedResolutions(self, boolean: bool) -> None: ...
    def setGroupFiles(self, boolean: bool) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLegacy(self, boolean: bool) -> None: ...
    def setMetadataFiltered(self, boolean: bool) -> None: ...
    def setMetadataOptions(self, metadataOptions: bioformats_jar._loci.formats.in_.MetadataOptions) -> None: ...
    def setMetadataStore(self, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    def setNormalized(self, boolean: bool) -> None: ...
    def setOriginalMetadataPopulated(self, boolean: bool) -> None: ...
    def setResolution(self, int: int) -> None: ...
    def setSeries(self, int: int) -> None: ...

class DimensionSwapper(ReaderWrapper):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, iFormatReader: IFormatReader): ...
    def getCoreMetadataList(self) -> java.util.List[CoreMetadata]: ...
    def getDimensionOrder(self) -> java.lang.String: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> int: ...
    def getInputOrder(self) -> java.lang.String: ...
    def getSizeC(self) -> int: ...
    def getSizeT(self) -> int: ...
    def getSizeX(self) -> int: ...
    def getSizeY(self) -> int: ...
    def getSizeZ(self) -> int: ...
    def getZCTCoords(self, int: int) -> typing.List[int]: ...
    def getZCTModuloCoords(self, int: int) -> typing.List[int]: ...
    @staticmethod
    def makeDimensionSwapper(iFormatReader: IFormatReader) -> 'DimensionSwapper': ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setOutputOrder(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def swapDimensions(self, string: typing.Union[java.lang.String, str]) -> None: ...

class FileStitcher(ReaderWrapper):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, boolean: bool): ...
    @typing.overload
    def __init__(self, iFormatReader: IFormatReader): ...
    @typing.overload
    def __init__(self, iFormatReader: IFormatReader, boolean: bool): ...
    def canChangePattern(self) -> bool: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def coreIndexToSeries(self, int: int) -> int: ...
    def findPattern(self, string: typing.Union[java.lang.String, str]) -> FilePattern: ...
    def findPatterns(self, string: typing.Union[java.lang.String, str]) -> typing.List[java.lang.String]: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getAdjustedIndex(self, int: int) -> int: ...
    def getAdvancedSeriesUsedFiles(self, boolean: bool) -> typing.List[FileInfo]: ...
    def getAdvancedUsedFiles(self, boolean: bool) -> typing.List[FileInfo]: ...
    def getAxisGuesser(self) -> AxisGuesser: ...
    def getAxisTypes(self) -> typing.List[int]: ...
    def getBitsPerPixel(self) -> int: ...
    def getCoreIndex(self) -> int: ...
    def getCoreMetadataList(self) -> java.util.List[CoreMetadata]: ...
    def getDimensionOrder(self) -> java.lang.String: ...
    def getFilePattern(self) -> FilePattern: ...
    def getImageCount(self) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> int: ...
    def getMetadataStore(self) -> bioformats_jar._loci.formats.meta.MetadataStore: ...
    def getMetadataStoreRoot(self) -> typing.Any: ...
    def getPixelType(self) -> int: ...
    @typing.overload
    def getReader(self, int: int, int2: int) -> DimensionSwapper: ...
    @typing.overload
    def getReader(self) -> IFormatReader: ...
    @typing.overload
    def getReader(self, int: int) -> IFormatReader: ...
    def getRequiredDirectories(self, stringArray: typing.List[java.lang.String]) -> int: ...
    def getResolution(self) -> int: ...
    def getSeries(self) -> int: ...
    def getSeriesCount(self) -> int: ...
    def getSeriesMetadata(self) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def getSizeC(self) -> int: ...
    def getSizeT(self) -> int: ...
    def getSizeX(self) -> int: ...
    def getSizeY(self) -> int: ...
    def getSizeZ(self) -> int: ...
    def getThumbSizeX(self) -> int: ...
    def getThumbSizeY(self) -> int: ...
    def getUnderlyingReaders(self) -> typing.List[IFormatReader]: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def getZCTCoords(self, int: int) -> typing.List[int]: ...
    def getZCTModuloCoords(self, int: int) -> typing.List[int]: ...
    def isFalseColor(self) -> bool: ...
    def isGroupFiles(self) -> bool: ...
    def isIndexed(self) -> bool: ...
    @typing.overload
    def isInterleaved(self) -> bool: ...
    @typing.overload
    def isInterleaved(self, int: int) -> bool: ...
    def isLittleEndian(self) -> bool: ...
    def isOrderCertain(self) -> bool: ...
    def isRGB(self) -> bool: ...
    def isThumbnailSeries(self) -> bool: ...
    def isUsingPatternIds(self) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openPlane(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.Any: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...
    def seriesToCoreIndex(self, int: int) -> int: ...
    def setAxisTypes(self, intArray: typing.List[int]) -> None: ...
    def setCanChangePattern(self, boolean: bool) -> None: ...
    def setCoreIndex(self, int: int) -> None: ...
    def setFlattenedResolutions(self, boolean: bool) -> None: ...
    def setGroupFiles(self, boolean: bool) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMetadataOptions(self, metadataOptions: bioformats_jar._loci.formats.in_.MetadataOptions) -> None: ...
    def setMetadataStore(self, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    def setNormalized(self, boolean: bool) -> None: ...
    def setOriginalMetadataPopulated(self, boolean: bool) -> None: ...
    def setReaderClassList(self, classList: ClassList[IFormatReader]) -> None: ...
    def setResolution(self, int: int) -> None: ...
    def setSeries(self, int: int) -> None: ...
    def setUsingPatternIds(self, boolean: bool) -> None: ...

class MinMaxCalculator(ReaderWrapper):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, iFormatReader: IFormatReader): ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    @typing.overload
    def close(self) -> None: ...
    def getChannelGlobalMaximum(self, int: int) -> float: ...
    def getChannelGlobalMinimum(self, int: int) -> float: ...
    def getChannelKnownMaximum(self, int: int) -> float: ...
    def getChannelKnownMinimum(self, int: int) -> float: ...
    def getMinMaxStore(self) -> bioformats_jar._loci.formats.meta.IMinMaxStore: ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    def getPlaneMaximum(self, int: int) -> typing.List[float]: ...
    def getPlaneMinimum(self, int: int) -> typing.List[float]: ...
    def isMinMaxPopulated(self) -> bool: ...
    @staticmethod
    def makeMinMaxCalculator(iFormatReader: IFormatReader) -> 'MinMaxCalculator': ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def setMinMaxStore(self, iMinMaxStore: bioformats_jar._loci.formats.meta.IMinMaxStore) -> None: ...

class SubResolutionFormatReader(FormatReader):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def coreIndexToSeries(self, int: int) -> int: ...
    def getCoreIndex(self) -> int: ...
    def getCoreMetadataList(self) -> java.util.List[CoreMetadata]: ...
    def getResolution(self) -> int: ...
    def getResolutionCount(self) -> int: ...
    def getSeries(self) -> int: ...
    def getSeriesCount(self) -> int: ...
    def seriesToCoreIndex(self, int: int) -> int: ...
    def setCoreIndex(self, int: int) -> None: ...
    def setResolution(self, int: int) -> None: ...
    def setSeries(self, int: int) -> None: ...

class TileStitcher(ReaderWrapper):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, iFormatReader: IFormatReader): ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    def getSeriesCount(self) -> int: ...
    def getSizeX(self) -> int: ...
    def getSizeY(self) -> int: ...
    @staticmethod
    def makeTileStitcher(iFormatReader: IFormatReader) -> 'TileStitcher': ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...

class WrappedReader(FormatReader):
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def coreIndexToSeries(self, int: int) -> int: ...
    def get16BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def get8BitLookupTable(self) -> typing.List[typing.List[int]]: ...
    def getBitsPerPixel(self) -> int: ...
    def getCoreIndex(self) -> int: ...
    def getCoreMetadataList(self) -> java.util.List[CoreMetadata]: ...
    def getDatasetStructureDescription(self) -> java.lang.String: ...
    def getDimensionOrder(self) -> java.lang.String: ...
    def getDomains(self) -> typing.List[java.lang.String]: ...
    def getEffectiveSizeC(self) -> int: ...
    def getGlobalMetadata(self) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    def getImageCount(self) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> int: ...
    @typing.overload
    def getIndex(self, int: int, int2: int, int3: int) -> int: ...
    def getMetadataStoreRoot(self) -> typing.Any: ...
    def getMetadataValue(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    def getModuloC(self) -> Modulo: ...
    def getModuloT(self) -> Modulo: ...
    def getModuloZ(self) -> Modulo: ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    def getOptimalTileHeight(self) -> int: ...
    def getOptimalTileWidth(self) -> int: ...
    def getPixelType(self) -> int: ...
    def getPossibleDomains(self, string: typing.Union[java.lang.String, str]) -> typing.List[java.lang.String]: ...
    def getRGBChannelCount(self) -> int: ...
    def getResolution(self) -> int: ...
    def getResolutionCount(self) -> int: ...
    def getSeries(self) -> int: ...
    def getSeriesCount(self) -> int: ...
    def getSeriesMetadata(self) -> java.util.Hashtable[java.lang.String, typing.Any]: ...
    def getSeriesMetadataValue(self, string: typing.Union[java.lang.String, str]) -> typing.Any: ...
    @typing.overload
    def getSeriesUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getSeriesUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def getSizeC(self) -> int: ...
    def getSizeT(self) -> int: ...
    def getSizeX(self) -> int: ...
    def getSizeY(self) -> int: ...
    def getSizeZ(self) -> int: ...
    def getThumbSizeX(self) -> int: ...
    def getThumbSizeY(self) -> int: ...
    def getUnderlyingReaders(self) -> typing.List[IFormatReader]: ...
    @typing.overload
    def getUsedFiles(self) -> typing.List[java.lang.String]: ...
    @typing.overload
    def getUsedFiles(self, boolean: bool) -> typing.List[java.lang.String]: ...
    def getZCTCoords(self, int: int) -> typing.List[int]: ...
    def hasCompanionFiles(self) -> bool: ...
    def isFalseColor(self) -> bool: ...
    def isIndexed(self) -> bool: ...
    @typing.overload
    def isInterleaved(self) -> bool: ...
    @typing.overload
    def isInterleaved(self, int: int) -> bool: ...
    def isLittleEndian(self) -> bool: ...
    def isMetadataComplete(self) -> bool: ...
    def isOrderCertain(self) -> bool: ...
    def isRGB(self) -> bool: ...
    def isSingleFile(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def isThumbnailSeries(self) -> bool: ...
    @typing.overload
    def openBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def openBytes(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    def openPlane(self, int: int, int2: int, int3: int, int4: int, int5: int) -> typing.Any: ...
    def openThumbBytes(self, int: int) -> typing.List[int]: ...
    def reopenFile(self) -> None: ...
    def seriesToCoreIndex(self, int: int) -> int: ...
    def setCoreIndex(self, int: int) -> None: ...
    def setResolution(self, int: int) -> None: ...
    def setSeries(self, int: int) -> None: ...

class Memoizer(ReaderWrapper):
    VERSION: typing.ClassVar[int] = ...
    DEFAULT_MINIMUM_ELAPSED: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, iFormatReader: IFormatReader): ...
    @typing.overload
    def __init__(self, iFormatReader: IFormatReader, long: int): ...
    @typing.overload
    def __init__(self, iFormatReader: IFormatReader, long: int, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, long: int): ...
    @typing.overload
    def __init__(self, long: int, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def close(self, boolean: bool) -> None: ...
    def generateMemo(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def getMemoFile(self, string: typing.Union[java.lang.String, str]) -> java.io.File: ...
    def getMetadataStore(self) -> bioformats_jar._loci.formats.meta.MetadataStore: ...
    def isLoadedFromMemo(self) -> bool: ...
    def isSavedToMemo(self) -> bool: ...
    def isVersionChecking(self) -> bool: ...
    def loadMemo(self) -> IFormatReader: ...
    @staticmethod
    def main(stringArray: typing.List[java.lang.String]) -> None: ...
    def saveMemo(self) -> bool: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMetadataStore(self, metadataStore: bioformats_jar._loci.formats.meta.MetadataStore) -> None: ...
    def setVersionChecking(self, boolean: bool) -> None: ...
    def skipSave(self, boolean: bool) -> None: ...
    def versionMismatch(self) -> bool: ...
    class Deser:
        def close(self) -> None: ...
        def loadReader(self) -> IFormatReader: ...
        def loadReleaseVersion(self) -> java.lang.String: ...
        def loadRevision(self) -> java.lang.String: ...
        def loadStart(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
        def loadStop(self) -> None: ...
        def loadVersion(self) -> int: ...
        def saveReader(self, iFormatReader: IFormatReader) -> None: ...
        def saveReleaseVersion(self, string: typing.Union[java.lang.String, str]) -> None: ...
        def saveRevision(self, string: typing.Union[java.lang.String, str]) -> None: ...
        def saveStart(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
        def saveStop(self) -> None: ...
        def saveVersion(self, integer: int) -> None: ...
    class KryoDeser(loci.formats.Memoizer.Deser):
        kryo: com.esotericsoftware.kryo.Kryo = ...
        def __init__(self): ...
        def close(self) -> None: ...
        def loadReader(self) -> IFormatReader: ...
        def loadReleaseVersion(self) -> java.lang.String: ...
        def loadRevision(self) -> java.lang.String: ...
        def loadStart(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
        def loadStop(self) -> None: ...
        def loadVersion(self) -> int: ...
        def saveReader(self, iFormatReader: IFormatReader) -> None: ...
        def saveReleaseVersion(self, string: typing.Union[java.lang.String, str]) -> None: ...
        def saveRevision(self, string: typing.Union[java.lang.String, str]) -> None: ...
        def saveStart(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
        def saveStop(self) -> None: ...
        def saveVersion(self, integer: int) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.formats")``.

    AxisGuesser: typing.Type[AxisGuesser]
    ChannelFiller: typing.Type[ChannelFiller]
    ChannelMerger: typing.Type[ChannelMerger]
    ChannelSeparator: typing.Type[ChannelSeparator]
    ClassList: typing.Type[ClassList]
    CoreMetadata: typing.Type[CoreMetadata]
    CoreMetadataList: typing.Type[CoreMetadataList]
    DelegateReader: typing.Type[DelegateReader]
    DimensionSwapper: typing.Type[DimensionSwapper]
    FileInfo: typing.Type[FileInfo]
    FilePattern: typing.Type[FilePattern]
    FilePatternBlock: typing.Type[FilePatternBlock]
    FileStitcher: typing.Type[FileStitcher]
    FormatException: typing.Type[FormatException]
    FormatHandler: typing.Type[FormatHandler]
    FormatReader: typing.Type[FormatReader]
    FormatTools: typing.Type[FormatTools]
    FormatWriter: typing.Type[FormatWriter]
    IFormatHandler: typing.Type[IFormatHandler]
    IFormatReader: typing.Type[IFormatReader]
    IFormatWriter: typing.Type[IFormatWriter]
    IMetadataConfigurable: typing.Type[IMetadataConfigurable]
    IPyramidHandler: typing.Type[IPyramidHandler]
    IllegalBlockException: typing.Type[IllegalBlockException]
    ImageReader: typing.Type[ImageReader]
    ImageTools: typing.Type[ImageTools]
    ImageWriter: typing.Type[ImageWriter]
    Memoizer: typing.Type[Memoizer]
    MetadataList: typing.Type[MetadataList]
    MetadataTools: typing.Type[MetadataTools]
    MinMaxCalculator: typing.Type[MinMaxCalculator]
    MissingLibraryException: typing.Type[MissingLibraryException]
    Modulo: typing.Type[Modulo]
    NumberFilter: typing.Type[NumberFilter]
    ReaderWrapper: typing.Type[ReaderWrapper]
    Resolution: typing.Type[Resolution]
    ResourceNamer: typing.Type[ResourceNamer]
    SubResolutionFormatReader: typing.Type[SubResolutionFormatReader]
    SwappableMetadata: typing.Type[SwappableMetadata]
    TileStitcher: typing.Type[TileStitcher]
    UnknownFormatException: typing.Type[UnknownFormatException]
    UnsupportedCompressionException: typing.Type[UnsupportedCompressionException]
    UpgradeChecker: typing.Type[UpgradeChecker]
    WrappedReader: typing.Type[WrappedReader]
    WriterWrapper: typing.Type[WriterWrapper]
    cache: bioformats_jar._loci.formats.cache.__module_protocol__
    codec: bioformats_jar._loci.formats.codec.__module_protocol__
    gui: bioformats_jar._loci.formats.gui.__module_protocol__
    in_: bioformats_jar._loci.formats.in_.__module_protocol__
    meta: bioformats_jar._loci.formats.meta.__module_protocol__
    ome: bioformats_jar._loci.formats.ome.__module_protocol__
    out: bioformats_jar._loci.formats.out.__module_protocol__
    services: bioformats_jar._loci.formats.services.__module_protocol__
    tiff: bioformats_jar._loci.formats.tiff.__module_protocol__
    tools: bioformats_jar._loci.formats.tools.__module_protocol__
