import java.lang
import bioformats_jar._loci.common
import bioformats_jar._loci.formats
import bioformats_jar._loci.formats.tiff
import typing



class APNGWriter(loci.formats.FormatWriter):
    def __init__(self): ...
    def canDoStacks(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...

class AVIWriter(loci.formats.FormatWriter):
    def __init__(self): ...
    def canDoStacks(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...

class CellH5Writer(loci.formats.FormatWriter):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    def canDoStacks(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    def getPlaneCount(self) -> int: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...

class EPSWriter(loci.formats.FormatWriter):
    def __init__(self): ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...

class ICSWriter(loci.formats.FormatWriter):
    def __init__(self): ...
    def canDoStacks(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setOutputOrder(self, string: typing.Union[java.lang.String, str]) -> None: ...

class ImageIOWriter(loci.formats.FormatWriter):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String], string3: typing.Union[java.lang.String, str]): ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any, region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any, int2: int, int3: int, int4: int, int5: int) -> None: ...

class JPEG2000Writer(loci.formats.FormatWriter):
    def __init__(self): ...
    def canDoStacks(self) -> bool: ...
    def compressBuffer(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...

class JavaWriter(loci.formats.FormatWriter):
    def __init__(self): ...
    def canDoStacks(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...

class LegacyQTWriter(loci.formats.FormatWriter):
    def __init__(self): ...
    def canDoStacks(self) -> bool: ...
    def close(self) -> None: ...
    def getNativeDataType(self) -> typing.Type[typing.Any]: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any, region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def savePlane(self, int: int, object: typing.Any, int2: int, int3: int, int4: int, int5: int) -> None: ...
    def setCodec(self, int: int) -> None: ...
    def setQuality(self, int: int) -> None: ...

class OMEXMLWriter(loci.formats.FormatWriter):
    def __init__(self): ...
    def canDoStacks(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...

class QTWriter(loci.formats.FormatWriter):
    CODEC_MOTION_JPEG_B: typing.ClassVar[int] = ...
    CODEC_CINEPAK: typing.ClassVar[int] = ...
    CODEC_ANIMATION: typing.ClassVar[int] = ...
    CODEC_H_263: typing.ClassVar[int] = ...
    CODEC_SORENSON: typing.ClassVar[int] = ...
    CODEC_SORENSON_3: typing.ClassVar[int] = ...
    CODEC_MPEG_4: typing.ClassVar[int] = ...
    CODEC_RAW: typing.ClassVar[int] = ...
    QUALITY_LOW: typing.ClassVar[int] = ...
    QUALITY_NORMAL: typing.ClassVar[int] = ...
    QUALITY_HIGH: typing.ClassVar[int] = ...
    QUALITY_MAXIMUM: typing.ClassVar[int] = ...
    def __init__(self): ...
    def canDoStacks(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    def setCodec(self, int: int) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setQuality(self, int: int) -> None: ...

class TiffWriter(loci.formats.FormatWriter):
    COMPRESSION_UNCOMPRESSED: typing.ClassVar[java.lang.String] = ...
    COMPRESSION_LZW: typing.ClassVar[java.lang.String] = ...
    COMPRESSION_J2K: typing.ClassVar[java.lang.String] = ...
    COMPRESSION_J2K_LOSSY: typing.ClassVar[java.lang.String] = ...
    COMPRESSION_JPEG: typing.ClassVar[java.lang.String] = ...
    COMPRESSION_ZLIB: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], stringArray: typing.List[java.lang.String]): ...
    def canDoStacks(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    def getPlaneCount(self) -> int: ...
    def getTileSizeX(self) -> int: ...
    def getTileSizeY(self) -> int: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], iFD: bioformats_jar._loci.formats.tiff.IFD) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], iFD: bioformats_jar._loci.formats.tiff.IFD, int2: int, int3: int, int4: int, int5: int) -> None: ...
    def setBigTiff(self, boolean: bool) -> None: ...
    def setCanDetectBigTiff(self, boolean: bool) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTileSizeX(self, int: int) -> int: ...
    def setTileSizeY(self, int: int) -> int: ...

class V3DrawWriter(loci.formats.FormatWriter):
    def __init__(self): ...
    def canDoStacks(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setOutputOrder(self, string: typing.Union[java.lang.String, str]) -> None: ...

class WlzWriter(loci.formats.FormatWriter):
    NO_WLZ_MSG: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    def canDoStacks(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setOutputOrder(self, string: typing.Union[java.lang.String, str]) -> None: ...

class JPEGWriter(ImageIOWriter):
    def __init__(self): ...
    @typing.overload
    def getPixelTypes(self) -> typing.List[int]: ...
    @typing.overload
    def getPixelTypes(self, string: typing.Union[java.lang.String, str]) -> typing.List[int]: ...

class OMETiffWriter(TiffWriter):
    COMPANION_KEY: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    def close(self) -> None: ...
    def getCompanion(self) -> java.lang.String: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], iFD: bioformats_jar._loci.formats.tiff.IFD, int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], iFD: bioformats_jar._loci.formats.tiff.IFD) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...

class PyramidOMETiffWriter(OMETiffWriter):
    def __init__(self): ...
    def close(self) -> None: ...
    def isThisType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], region: bioformats_jar._loci.common.Region) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], iFD: bioformats_jar._loci.formats.tiff.IFD, int2: int, int3: int, int4: int, int5: int) -> None: ...
    @typing.overload
    def saveBytes(self, int: int, byteArray: typing.List[int], iFD: bioformats_jar._loci.formats.tiff.IFD) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.formats.out")``.

    APNGWriter: typing.Type[APNGWriter]
    AVIWriter: typing.Type[AVIWriter]
    CellH5Writer: typing.Type[CellH5Writer]
    EPSWriter: typing.Type[EPSWriter]
    ICSWriter: typing.Type[ICSWriter]
    ImageIOWriter: typing.Type[ImageIOWriter]
    JPEG2000Writer: typing.Type[JPEG2000Writer]
    JPEGWriter: typing.Type[JPEGWriter]
    JavaWriter: typing.Type[JavaWriter]
    LegacyQTWriter: typing.Type[LegacyQTWriter]
    OMETiffWriter: typing.Type[OMETiffWriter]
    OMEXMLWriter: typing.Type[OMEXMLWriter]
    PyramidOMETiffWriter: typing.Type[PyramidOMETiffWriter]
    QTWriter: typing.Type[QTWriter]
    TiffWriter: typing.Type[TiffWriter]
    V3DrawWriter: typing.Type[V3DrawWriter]
    WlzWriter: typing.Type[WlzWriter]
