import ij
import ij.process
import java.awt
import java.awt.event
import java.lang
import java.util
import bioformats_jar._loci
import bioformats_jar._loci.common
import bioformats_jar._loci.formats
import bioformats_jar._loci.formats.gui
import bioformats_jar._loci.formats.meta
import bioformats_jar._loci.plugins
import bioformats_jar._loci.plugins.prefs
import bioformats_jar._loci.plugins.util
import typing



class Calibrator:
    def __init__(self, importProcess: 'ImportProcess'): ...
    def applyCalibration(self, imagePlus: ij.ImagePlus) -> None: ...

class ColorDialog(loci.plugins.in_.ImporterDialog):
    def __init__(self, importProcess: 'ImportProcess'): ...

class Colorizer:
    def __init__(self, importProcess: 'ImportProcess'): ...
    def applyColors(self, list: java.util.List[ij.ImagePlus]) -> java.util.List[ij.ImagePlus]: ...

class Concatenator:
    def __init__(self): ...
    def concatenate(self, list: java.util.List[ij.ImagePlus]) -> java.util.List[ij.ImagePlus]: ...

class CropDialog(loci.plugins.in_.ImporterDialog):
    def __init__(self, importProcess: 'ImportProcess'): ...

class DisplayHandler(loci.common.StatusListener):
    def __init__(self, importProcess: 'ImportProcess'): ...
    def displayDataBrowser(self, imagePlus: ij.ImagePlus) -> None: ...
    def displayImage(self, imagePlus: ij.ImagePlus) -> None: ...
    def displayImage5D(self, imagePlus: ij.ImagePlus) -> None: ...
    def displayImages(self, imagePlusArray: typing.List[ij.ImagePlus]) -> None: ...
    def displayNormal(self, imagePlus: ij.ImagePlus) -> None: ...
    def displayOMEXML(self) -> bioformats_jar._loci.formats.gui.XMLWindow: ...
    def displayOriginalMetadata(self) -> bioformats_jar._loci.plugins.util.SearchableWindow: ...
    def displayROIs(self, imagePlusArray: typing.List[ij.ImagePlus]) -> None: ...
    def displayView5D(self, imagePlus: ij.ImagePlus) -> None: ...
    def statusUpdated(self, statusEvent: bioformats_jar._loci.common.StatusEvent) -> None: ...

class FilePatternDialog(loci.plugins.in_.ImporterDialog):
    def __init__(self, importProcess: 'ImportProcess'): ...

class IdDialog(loci.plugins.in_.ImporterDialog):
    def __init__(self, importProcess: 'ImportProcess'): ...

class ImagePlusReader(loci.common.StatusReporter):
    PROP_SERIES: typing.ClassVar[java.lang.String] = ...
    PROP_LUT: typing.ClassVar[java.lang.String] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, importProcess: 'ImportProcess'): ...
    def addStatusListener(self, statusListener: bioformats_jar._loci.common.StatusListener) -> None: ...
    @typing.overload
    @staticmethod
    def createImage(string: typing.Union[java.lang.String, str], imageStack: ij.ImageStack, list: java.util.List[ij.process.LUT]) -> ij.ImagePlus: ...
    @typing.overload
    @staticmethod
    def createImage(string: typing.Union[java.lang.String, str], list: java.util.List[ij.process.ImageProcessor]) -> ij.ImagePlus: ...
    @staticmethod
    def createStack(list: java.util.List[ij.process.ImageProcessor], list2: java.util.List[typing.Union[java.lang.String, str]], list3: java.util.List[ij.process.LUT]) -> ij.ImageStack: ...
    def notifyListeners(self, statusEvent: bioformats_jar._loci.common.StatusEvent) -> None: ...
    def openImagePlus(self) -> typing.List[ij.ImagePlus]: ...
    def openThumbImagePlus(self) -> typing.List[ij.ImagePlus]: ...
    def removeStatusListener(self, statusListener: bioformats_jar._loci.common.StatusListener) -> None: ...

class ImportProcess(loci.common.StatusReporter):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, importerOptions: 'ImporterOptions'): ...
    def addStatusListener(self, statusListener: bioformats_jar._loci.common.StatusListener) -> None: ...
    def cancel(self) -> None: ...
    def execute(self) -> bool: ...
    def getBaseReader(self) -> bioformats_jar._loci.formats.IFormatReader: ...
    def getCBegin(self, int: int) -> int: ...
    def getCCount(self, int: int) -> int: ...
    def getCEnd(self, int: int) -> int: ...
    def getCStep(self, int: int) -> int: ...
    def getChannelFiller(self) -> bioformats_jar._loci.formats.ChannelFiller: ...
    def getChannelSeparator(self) -> bioformats_jar._loci.formats.ChannelSeparator: ...
    def getCropRegion(self, int: int) -> bioformats_jar._loci.common.Region: ...
    def getCurrentFile(self) -> java.lang.String: ...
    def getDimensionSwapper(self) -> bioformats_jar._loci.formats.DimensionSwapper: ...
    def getFileStitcher(self) -> bioformats_jar._loci.formats.FileStitcher: ...
    def getIdLocation(self) -> bioformats_jar._loci.common.Location: ...
    def getIdName(self) -> java.lang.String: ...
    def getImageReader(self) -> bioformats_jar._loci.formats.ImageReader: ...
    def getMemoryUsage(self) -> int: ...
    def getMinMaxCalculator(self) -> bioformats_jar._loci.formats.MinMaxCalculator: ...
    def getOMEMetadata(self) -> bioformats_jar._loci.formats.meta.IMetadata: ...
    def getOMEXML(self) -> java.lang.String: ...
    def getOptions(self) -> 'ImporterOptions': ...
    def getOriginalMetadata(self) -> 'ImporterMetadata': ...
    def getReader(self) -> bioformats_jar._loci.plugins.util.ImageProcessorReader: ...
    def getSeriesCount(self) -> int: ...
    def getSeriesLabel(self, int: int) -> java.lang.String: ...
    def getStackOrder(self) -> java.lang.String: ...
    def getTBegin(self, int: int) -> int: ...
    def getTCount(self, int: int) -> int: ...
    def getTEnd(self, int: int) -> int: ...
    def getTStep(self, int: int) -> int: ...
    def getVirtualReader(self) -> bioformats_jar._loci.plugins.util.VirtualReader: ...
    def getZBegin(self, int: int) -> int: ...
    def getZCount(self, int: int) -> int: ...
    def getZEnd(self, int: int) -> int: ...
    def getZStep(self, int: int) -> int: ...
    def isWindowless(self) -> bool: ...
    def notifyListeners(self, statusEvent: bioformats_jar._loci.common.StatusEvent) -> None: ...
    def removeStatusListener(self, statusListener: bioformats_jar._loci.common.StatusListener) -> None: ...
    def setSeriesList(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def wasCanceled(self) -> bool: ...

class ImportStep(java.lang.Enum['ImportStep']):
    READER: typing.ClassVar['ImportStep'] = ...
    FILE: typing.ClassVar['ImportStep'] = ...
    STACK: typing.ClassVar['ImportStep'] = ...
    SERIES: typing.ClassVar['ImportStep'] = ...
    DIM_ORDER: typing.ClassVar['ImportStep'] = ...
    RANGE: typing.ClassVar['ImportStep'] = ...
    CROP: typing.ClassVar['ImportStep'] = ...
    COLORS: typing.ClassVar['ImportStep'] = ...
    METADATA: typing.ClassVar['ImportStep'] = ...
    COMPLETE: typing.ClassVar['ImportStep'] = ...
    def getMessage(self) -> java.lang.String: ...
    @typing.overload
    def getStep(self) -> int: ...
    @typing.overload
    @staticmethod
    def getStep(int: int) -> 'ImportStep': ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'ImportStep': ...
    @staticmethod
    def values() -> typing.List['ImportStep']: ...

class Importer:
    def __init__(self, lociImporter: bioformats_jar._loci.plugins.LociImporter): ...
    def finish(self, importProcess: ImportProcess) -> None: ...
    @staticmethod
    def main(stringArray: typing.List[java.lang.String]) -> None: ...
    def parseOptions(self, string: typing.Union[java.lang.String, str]) -> 'ImporterOptions': ...
    def readPixels(self, imagePlusReader: ImagePlusReader, importerOptions: 'ImporterOptions', displayHandler: DisplayHandler) -> typing.List[ij.ImagePlus]: ...
    def run(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def showDialogs(self, importProcess: ImportProcess) -> None: ...

class ImporterDialog(loci.plugins.prefs.OptionsDialog):
    def __init__(self, importProcess: ImportProcess): ...
    def showDialog(self) -> int: ...

class ImporterMetadata(java.util.HashMap[java.lang.String, typing.Any]):
    def __init__(self, iFormatReader: bioformats_jar._loci.formats.IFormatReader, importProcess: ImportProcess, boolean: bool): ...
    def getMetadataString(self, string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...

class ImporterOptions(loci.plugins.prefs.OptionsList):
    KEY_AUTOSCALE: typing.ClassVar[java.lang.String] = ...
    KEY_COLOR_MODE: typing.ClassVar[java.lang.String] = ...
    KEY_CONCATENATE: typing.ClassVar[java.lang.String] = ...
    KEY_CROP: typing.ClassVar[java.lang.String] = ...
    KEY_FIRST: typing.ClassVar[java.lang.String] = ...
    KEY_FORCE_THUMBS: typing.ClassVar[java.lang.String] = ...
    KEY_GROUP_FILES: typing.ClassVar[java.lang.String] = ...
    KEY_UNGROUP_FILES: typing.ClassVar[java.lang.String] = ...
    KEY_ID: typing.ClassVar[java.lang.String] = ...
    KEY_LOCATION: typing.ClassVar[java.lang.String] = ...
    KEY_OPEN_ALL_SERIES: typing.ClassVar[java.lang.String] = ...
    KEY_QUIET: typing.ClassVar[java.lang.String] = ...
    KEY_SHOW_METADATA: typing.ClassVar[java.lang.String] = ...
    KEY_SHOW_OME_XML: typing.ClassVar[java.lang.String] = ...
    KEY_SHOW_ROIS: typing.ClassVar[java.lang.String] = ...
    KEY_ROIS_MODE: typing.ClassVar[java.lang.String] = ...
    KEY_SPECIFY_RANGES: typing.ClassVar[java.lang.String] = ...
    KEY_SPLIT_Z: typing.ClassVar[java.lang.String] = ...
    KEY_SPLIT_T: typing.ClassVar[java.lang.String] = ...
    KEY_SPLIT_C: typing.ClassVar[java.lang.String] = ...
    KEY_STACK_FORMAT: typing.ClassVar[java.lang.String] = ...
    KEY_STACK_ORDER: typing.ClassVar[java.lang.String] = ...
    KEY_SWAP_DIMS: typing.ClassVar[java.lang.String] = ...
    KEY_UPGRADE_CHECK: typing.ClassVar[java.lang.String] = ...
    KEY_VIRTUAL: typing.ClassVar[java.lang.String] = ...
    KEY_WINDOWLESS: typing.ClassVar[java.lang.String] = ...
    KEY_STITCH_TILES: typing.ClassVar[java.lang.String] = ...
    KEY_MUST_GROUP: typing.ClassVar[java.lang.String] = ...
    COLOR_MODE_DEFAULT: typing.ClassVar[java.lang.String] = ...
    COLOR_MODE_COMPOSITE: typing.ClassVar[java.lang.String] = ...
    COLOR_MODE_COLORIZED: typing.ClassVar[java.lang.String] = ...
    COLOR_MODE_GRAYSCALE: typing.ClassVar[java.lang.String] = ...
    COLOR_MODE_CUSTOM: typing.ClassVar[java.lang.String] = ...
    LOCATION_LOCAL: typing.ClassVar[java.lang.String] = ...
    LOCATION_HTTP: typing.ClassVar[java.lang.String] = ...
    LOCATION_OMERO: typing.ClassVar[java.lang.String] = ...
    ROIS_MODE_MANAGER: typing.ClassVar[java.lang.String] = ...
    ROIS_MODE_OVERLAY: typing.ClassVar[java.lang.String] = ...
    VIEW_NONE: typing.ClassVar[java.lang.String] = ...
    VIEW_STANDARD: typing.ClassVar[java.lang.String] = ...
    VIEW_HYPERSTACK: typing.ClassVar[java.lang.String] = ...
    VIEW_BROWSER: typing.ClassVar[java.lang.String] = ...
    VIEW_IMAGE_5D: typing.ClassVar[java.lang.String] = ...
    VIEW_VIEW_5D: typing.ClassVar[java.lang.String] = ...
    ORDER_DEFAULT: typing.ClassVar[java.lang.String] = ...
    ORDER_XYZCT: typing.ClassVar[java.lang.String] = ...
    ORDER_XYZTC: typing.ClassVar[java.lang.String] = ...
    ORDER_XYCZT: typing.ClassVar[java.lang.String] = ...
    ORDER_XYTCZ: typing.ClassVar[java.lang.String] = ...
    ORDER_XYCTZ: typing.ClassVar[java.lang.String] = ...
    ORDER_XYTZC: typing.ClassVar[java.lang.String] = ...
    def __init__(self): ...
    def checkObsoleteOptions(self) -> None: ...
    def clearSeries(self) -> None: ...
    def doCrop(self) -> bool: ...
    def doMustGroup(self) -> bool: ...
    def doStitchTiles(self) -> bool: ...
    def doUpgradeCheck(self) -> bool: ...
    def getAutoscaleInfo(self) -> java.lang.String: ...
    def getCBegin(self, int: int) -> int: ...
    def getCEnd(self, int: int) -> int: ...
    def getCStep(self, int: int) -> int: ...
    def getColorMode(self) -> java.lang.String: ...
    def getColorModeInfo(self) -> java.lang.String: ...
    def getColorModes(self) -> typing.List[java.lang.String]: ...
    def getConcatenateInfo(self) -> java.lang.String: ...
    def getCropInfo(self) -> java.lang.String: ...
    def getCropRegion(self, int: int) -> bioformats_jar._loci.common.Region: ...
    def getCustomColor(self, int: int, int2: int) -> java.awt.Color: ...
    def getCustomColorKey(self, int: int, int2: int) -> java.lang.String: ...
    def getDefaultCustomColor(self, int: int) -> java.awt.Color: ...
    def getFirstTimeInfo(self) -> java.lang.String: ...
    def getForceThumbnailsInfo(self) -> java.lang.String: ...
    def getGroupFilesInfo(self) -> java.lang.String: ...
    def getId(self) -> java.lang.String: ...
    def getIdInfo(self) -> java.lang.String: ...
    def getInputOrder(self, int: int) -> java.lang.String: ...
    def getLocation(self) -> java.lang.String: ...
    def getLocationInfo(self) -> java.lang.String: ...
    def getLocations(self) -> typing.List[java.lang.String]: ...
    def getMustGroupInfo(self) -> java.lang.String: ...
    def getOpenAllSeriesInfo(self) -> java.lang.String: ...
    def getQuietInfo(self) -> java.lang.String: ...
    def getROIsMode(self) -> java.lang.String: ...
    def getROIsModeInfo(self) -> java.lang.String: ...
    def getROIsModes(self) -> typing.List[java.lang.String]: ...
    def getShowMetadataInfo(self) -> java.lang.String: ...
    def getShowOMEXMLInfo(self) -> java.lang.String: ...
    def getShowROIsInfo(self) -> java.lang.String: ...
    def getSpecifyRangesInfo(self) -> java.lang.String: ...
    def getSplitChannelsInfo(self) -> java.lang.String: ...
    def getSplitFocalPlanesInfo(self) -> java.lang.String: ...
    def getSplitTimepointsInfo(self) -> java.lang.String: ...
    def getStackFormat(self) -> java.lang.String: ...
    def getStackFormatInfo(self) -> java.lang.String: ...
    def getStackFormats(self) -> typing.List[java.lang.String]: ...
    def getStackOrder(self) -> java.lang.String: ...
    def getStackOrderInfo(self) -> java.lang.String: ...
    def getStackOrders(self) -> typing.List[java.lang.String]: ...
    def getStitchTilesInfo(self) -> java.lang.String: ...
    def getSwapDimensionsInfo(self) -> java.lang.String: ...
    def getTBegin(self, int: int) -> int: ...
    def getTEnd(self, int: int) -> int: ...
    def getTStep(self, int: int) -> int: ...
    def getUngroupFilesInfo(self) -> java.lang.String: ...
    def getUpgradeCheckInfo(self) -> java.lang.String: ...
    def getVirtualInfo(self) -> java.lang.String: ...
    def getWindowlessInfo(self) -> java.lang.String: ...
    def getZBegin(self, int: int) -> int: ...
    def getZEnd(self, int: int) -> int: ...
    def getZStep(self, int: int) -> int: ...
    def isAutoscale(self) -> bool: ...
    def isColorModeColorized(self) -> bool: ...
    def isColorModeComposite(self) -> bool: ...
    def isColorModeCustom(self) -> bool: ...
    def isColorModeDefault(self) -> bool: ...
    def isColorModeGrayscale(self) -> bool: ...
    def isConcatenate(self) -> bool: ...
    def isFirstTime(self) -> bool: ...
    def isForceThumbnails(self) -> bool: ...
    def isGroupFiles(self) -> bool: ...
    def isHTTP(self) -> bool: ...
    def isLocal(self) -> bool: ...
    def isOMERO(self) -> bool: ...
    def isQuiet(self) -> bool: ...
    def isSeriesOn(self, int: int) -> bool: ...
    def isShowMetadata(self) -> bool: ...
    def isShowOMEXML(self) -> bool: ...
    def isSpecifyRanges(self) -> bool: ...
    def isSplitChannels(self) -> bool: ...
    def isSplitFocalPlanes(self) -> bool: ...
    def isSplitTimepoints(self) -> bool: ...
    def isSwapDimensions(self) -> bool: ...
    def isUngroupFiles(self) -> bool: ...
    def isUsingPatternIds(self) -> bool: ...
    def isViewBrowser(self) -> bool: ...
    def isViewHyperstack(self) -> bool: ...
    def isViewImage5D(self) -> bool: ...
    def isViewNone(self) -> bool: ...
    def isViewStandard(self) -> bool: ...
    def isViewView5D(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def isWindowless(self) -> bool: ...
    def openAllSeries(self) -> bool: ...
    def parseArg(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setAutoscale(self, boolean: bool) -> None: ...
    def setCBegin(self, int: int, int2: int) -> None: ...
    def setCEnd(self, int: int, int2: int) -> None: ...
    def setCStep(self, int: int, int2: int) -> None: ...
    def setColorMode(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setConcatenate(self, boolean: bool) -> None: ...
    def setCrop(self, boolean: bool) -> None: ...
    def setCropRegion(self, int: int, region: bioformats_jar._loci.common.Region) -> None: ...
    def setCustomColor(self, int: int, int2: int, color: java.awt.Color) -> None: ...
    def setFirstTime(self, boolean: bool) -> None: ...
    def setForceThumbnails(self, boolean: bool) -> None: ...
    def setGroupFiles(self, boolean: bool) -> None: ...
    def setId(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setInputOrder(self, int: int, string: typing.Union[java.lang.String, str]) -> None: ...
    def setLocation(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMustGroup(self, boolean: bool) -> None: ...
    def setOpenAllSeries(self, boolean: bool) -> None: ...
    def setQuiet(self, boolean: bool) -> None: ...
    def setROIsMode(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setSeriesOn(self, int: int, boolean: bool) -> None: ...
    def setShowMetadata(self, boolean: bool) -> None: ...
    def setShowOMEXML(self, boolean: bool) -> None: ...
    def setShowROIs(self, boolean: bool) -> None: ...
    def setSpecifyRanges(self, boolean: bool) -> None: ...
    def setSplitChannels(self, boolean: bool) -> None: ...
    def setSplitFocalPlanes(self, boolean: bool) -> None: ...
    def setSplitTimepoints(self, boolean: bool) -> None: ...
    def setStackFormat(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setStackOrder(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setStitchTiles(self, boolean: bool) -> None: ...
    def setSwapDimensions(self, boolean: bool) -> None: ...
    def setTBegin(self, int: int, int2: int) -> None: ...
    def setTEnd(self, int: int, int2: int) -> None: ...
    def setTStep(self, int: int, int2: int) -> None: ...
    def setUngroupFiles(self, boolean: bool) -> None: ...
    def setUpgradeCheck(self, boolean: bool) -> None: ...
    def setUsingPatternIds(self, boolean: bool) -> None: ...
    def setVirtual(self, boolean: bool) -> None: ...
    def setWindowless(self, boolean: bool) -> None: ...
    def setZBegin(self, int: int, int2: int) -> None: ...
    def setZEnd(self, int: int, int2: int) -> None: ...
    def setZStep(self, int: int, int2: int) -> None: ...
    def showROIs(self) -> bool: ...

class ImporterPrompter(loci.common.StatusListener):
    def __init__(self, importProcess: ImportProcess): ...
    def statusUpdated(self, statusEvent: bioformats_jar._loci.common.StatusEvent) -> None: ...

class LocationDialog(ImporterDialog):
    def __init__(self, importProcess: ImportProcess): ...

class MainDialog(ImporterDialog, java.awt.event.FocusListener, java.awt.event.ItemListener, java.awt.event.MouseListener):
    INFO_DEFAULT: typing.ClassVar[java.lang.String] = ...
    def __init__(self, importProcess: ImportProcess): ...
    def focusGained(self, focusEvent: java.awt.event.FocusEvent) -> None: ...
    def focusLost(self, focusEvent: java.awt.event.FocusEvent) -> None: ...
    def itemStateChanged(self, itemEvent: java.awt.event.ItemEvent) -> None: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...

class MemoryDialog(ImporterDialog):
    def __init__(self, importProcess: ImportProcess): ...

class RangeDialog(ImporterDialog):
    def __init__(self, importProcess: ImportProcess): ...

class SeriesDialog(ImporterDialog, java.awt.event.ActionListener):
    MAX_COMPONENTS: typing.ClassVar[int] = ...
    MAX_SERIES_THUMBS: typing.ClassVar[int] = ...
    MAX_SERIES_TOGGLES: typing.ClassVar[int] = ...
    def __init__(self, importProcess: ImportProcess): ...
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...

class SwapDialog(ImporterDialog, java.awt.event.ItemListener):
    def __init__(self, importProcess: ImportProcess): ...
    def itemStateChanged(self, itemEvent: java.awt.event.ItemEvent) -> None: ...

class ThumbLoader(java.lang.Runnable):
    def __init__(self, iFormatReader: bioformats_jar._loci.formats.IFormatReader, panelArray: typing.List[java.awt.Panel], dialog: java.awt.Dialog): ...
    @staticmethod
    def loadThumb(bufferedImageReader: bioformats_jar._loci.formats.gui.BufferedImageReader, int: int, panel: java.awt.Panel, boolean: bool) -> None: ...
    def run(self) -> None: ...
    def stop(self) -> None: ...
    class SeriesInfo(java.lang.Comparable['ThumbLoader.SeriesInfo']):
        def __init__(self, thumbLoader: 'ThumbLoader', int: int, int2: int): ...
        def compareTo(self, seriesInfo: 'ThumbLoader.SeriesInfo') -> int: ...

class UpgradeDialog(ImporterDialog):
    def __init__(self, importProcess: ImportProcess): ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.plugins.in_")``.

    Calibrator: typing.Type[Calibrator]
    ColorDialog: typing.Type[ColorDialog]
    Colorizer: typing.Type[Colorizer]
    Concatenator: typing.Type[Concatenator]
    CropDialog: typing.Type[CropDialog]
    DisplayHandler: typing.Type[DisplayHandler]
    FilePatternDialog: typing.Type[FilePatternDialog]
    IdDialog: typing.Type[IdDialog]
    ImagePlusReader: typing.Type[ImagePlusReader]
    ImportProcess: typing.Type[ImportProcess]
    ImportStep: typing.Type[ImportStep]
    Importer: typing.Type[Importer]
    ImporterDialog: typing.Type[ImporterDialog]
    ImporterMetadata: typing.Type[ImporterMetadata]
    ImporterOptions: typing.Type[ImporterOptions]
    ImporterPrompter: typing.Type[ImporterPrompter]
    LocationDialog: typing.Type[LocationDialog]
    MainDialog: typing.Type[MainDialog]
    MemoryDialog: typing.Type[MemoryDialog]
    RangeDialog: typing.Type[RangeDialog]
    SeriesDialog: typing.Type[SeriesDialog]
    SwapDialog: typing.Type[SwapDialog]
    ThumbLoader: typing.Type[ThumbLoader]
    UpgradeDialog: typing.Type[UpgradeDialog]
