import java.lang
import java.util
import bioformats_jar._loci.poi.ddf
import bioformats_jar._loci.poi.hssf.record
import bioformats_jar._loci.poi.hssf.record.formula
import bioformats_jar._loci.poi.hssf.usermodel
import bioformats_jar._loci.poi.hssf.util
import typing



class AbstractShape:
    @staticmethod
    def createShape(hSSFShape: bioformats_jar._loci.poi.hssf.usermodel.HSSFShape, int: int) -> 'AbstractShape': ...
    def getObjRecord(self) -> bioformats_jar._loci.poi.hssf.record.ObjRecord: ...
    def getSpContainer(self) -> bioformats_jar._loci.poi.ddf.EscherContainerRecord: ...

class ConvertAnchor:
    def __init__(self): ...
    @staticmethod
    def createAnchor(hSSFAnchor: bioformats_jar._loci.poi.hssf.usermodel.HSSFAnchor) -> bioformats_jar._loci.poi.ddf.EscherRecord: ...

class DrawingManager:
    def __init__(self, escherDggRecord: bioformats_jar._loci.poi.ddf.EscherDggRecord): ...
    def allocateShapeId(self, short: int) -> int: ...
    def createDgRecord(self) -> bioformats_jar._loci.poi.ddf.EscherDgRecord: ...
    def getDgg(self) -> bioformats_jar._loci.poi.ddf.EscherDggRecord: ...

class DrawingManager2:
    def __init__(self, escherDggRecord: bioformats_jar._loci.poi.ddf.EscherDggRecord): ...
    def allocateShapeId(self, short: int) -> int: ...
    def createDgRecord(self) -> bioformats_jar._loci.poi.ddf.EscherDgRecord: ...
    def getDgg(self) -> bioformats_jar._loci.poi.ddf.EscherDggRecord: ...

class FormulaParser:
    FORMULA_TYPE_CELL: typing.ClassVar[int] = ...
    FORMULA_TYPE_SHARED: typing.ClassVar[int] = ...
    FORMULA_TYPE_ARRAY: typing.ClassVar[int] = ...
    FORMULA_TYPE_CONDFOMRAT: typing.ClassVar[int] = ...
    FORMULA_TYPE_NAMEDRANGE: typing.ClassVar[int] = ...
    def __init__(self, string: typing.Union[java.lang.String, str], workbook: 'Workbook'): ...
    @typing.overload
    def getRPNPtg(self) -> typing.List[loci.poi.hssf.record.formula.Ptg]: ...
    @typing.overload
    def getRPNPtg(self, int: int) -> typing.List[loci.poi.hssf.record.formula.Ptg]: ...
    def parse(self) -> None: ...
    @typing.overload
    def toFormulaString(self, list: java.util.List) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, ptgArray: typing.List[loci.poi.hssf.record.formula.Ptg]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def toFormulaString(workbook: 'Workbook', list: java.util.List) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def toFormulaString(workbook: 'Workbook', ptgArray: typing.List[loci.poi.hssf.record.formula.Ptg]) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...

class Model: ...

class WorkbookRecordList:
    def __init__(self): ...
    def add(self, int: int, record: bioformats_jar._loci.poi.hssf.record.Record) -> None: ...
    def get(self, int: int) -> bioformats_jar._loci.poi.hssf.record.Record: ...
    def getBackuppos(self) -> int: ...
    def getBspos(self) -> int: ...
    def getExternsheetPos(self) -> int: ...
    def getFontpos(self) -> int: ...
    def getNamepos(self) -> int: ...
    def getPalettepos(self) -> int: ...
    def getProtpos(self) -> int: ...
    def getRecords(self) -> java.util.List: ...
    def getSupbookpos(self) -> int: ...
    def getTabpos(self) -> int: ...
    def getXfpos(self) -> int: ...
    def iterator(self) -> java.util.Iterator: ...
    @typing.overload
    def remove(self, int: int) -> None: ...
    @typing.overload
    def remove(self, object: typing.Any) -> None: ...
    def setBackuppos(self, int: int) -> None: ...
    def setBspos(self, int: int) -> None: ...
    def setExternsheetPos(self, int: int) -> None: ...
    def setFontpos(self, int: int) -> None: ...
    def setNamepos(self, int: int) -> None: ...
    def setPalettepos(self, int: int) -> None: ...
    def setProtpos(self, int: int) -> None: ...
    def setRecords(self, list: java.util.List) -> None: ...
    def setSupbookpos(self, int: int) -> None: ...
    def setTabpos(self, int: int) -> None: ...
    def setXfpos(self, int: int) -> None: ...
    def size(self) -> int: ...

class LineShape(AbstractShape):
    def getObjRecord(self) -> bioformats_jar._loci.poi.hssf.record.ObjRecord: ...
    def getSpContainer(self) -> bioformats_jar._loci.poi.ddf.EscherContainerRecord: ...

class PictureShape(AbstractShape):
    def getObjRecord(self) -> bioformats_jar._loci.poi.hssf.record.ObjRecord: ...
    def getSpContainer(self) -> bioformats_jar._loci.poi.ddf.EscherContainerRecord: ...

class PolygonShape(AbstractShape):
    OBJECT_TYPE_MICROSOFT_OFFICE_DRAWING: typing.ClassVar[int] = ...
    def getObjRecord(self) -> bioformats_jar._loci.poi.hssf.record.ObjRecord: ...
    def getSpContainer(self) -> bioformats_jar._loci.poi.ddf.EscherContainerRecord: ...

class Sheet(Model):
    LeftMargin: typing.ClassVar[int] = ...
    RightMargin: typing.ClassVar[int] = ...
    TopMargin: typing.ClassVar[int] = ...
    BottomMargin: typing.ClassVar[int] = ...
    PANE_LOWER_RIGHT: typing.ClassVar[int] = ...
    PANE_UPPER_RIGHT: typing.ClassVar[int] = ...
    PANE_LOWER_LEFT: typing.ClassVar[int] = ...
    PANE_UPPER_LEFT: typing.ClassVar[int] = ...
    def __init__(self): ...
    def addMergedRegion(self, int: int, short: int, int2: int, short2: int) -> int: ...
    def addRow(self, rowRecord: bioformats_jar._loci.poi.hssf.record.RowRecord) -> None: ...
    def addValueRecord(self, int: int, cellValueRecordInterface: bioformats_jar._loci.poi.hssf.record.CellValueRecordInterface) -> None: ...
    def aggregateDrawingRecords(self, drawingManager2: DrawingManager2) -> int: ...
    def checkDimsLoc(self, record: bioformats_jar._loci.poi.hssf.record.Record, int: int) -> None: ...
    def cloneSheet(self) -> 'Sheet': ...
    def createBlank(self, int: int, short: int) -> bioformats_jar._loci.poi.hssf.record.BlankRecord: ...
    def createFormula(self, int: int, short: int, string: typing.Union[java.lang.String, str]) -> bioformats_jar._loci.poi.hssf.record.FormulaRecord: ...
    def createFreezePane(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    def createLabelSST(self, int: int, short: int, int2: int) -> bioformats_jar._loci.poi.hssf.record.LabelSSTRecord: ...
    def createNumber(self, int: int, short: int, double: float) -> bioformats_jar._loci.poi.hssf.record.NumberRecord: ...
    def createRow(self, int: int) -> bioformats_jar._loci.poi.hssf.record.RowRecord: ...
    @typing.overload
    @staticmethod
    def createSheet() -> 'Sheet': ...
    @typing.overload
    @staticmethod
    def createSheet(list: java.util.List, int: int) -> 'Sheet': ...
    @typing.overload
    @staticmethod
    def createSheet(list: java.util.List, int: int, int2: int) -> 'Sheet': ...
    def createSplitPane(self, int: int, int2: int, int3: int, int4: int, int5: int) -> None: ...
    def findFirstRecordBySid(self, short: int) -> bioformats_jar._loci.poi.hssf.record.Record: ...
    def findFirstRecordLocBySid(self, short: int) -> int: ...
    def getActiveCellCol(self) -> int: ...
    def getActiveCellRow(self) -> int: ...
    def getColumnBreaks(self) -> java.util.Iterator: ...
    def getColumnWidth(self, short: int) -> int: ...
    def getDefaultColumnWidth(self) -> int: ...
    def getDefaultRowHeight(self) -> int: ...
    def getDimsLoc(self) -> int: ...
    def getEofLoc(self) -> int: ...
    def getFooter(self) -> bioformats_jar._loci.poi.hssf.record.FooterRecord: ...
    def getGridsetRecord(self) -> bioformats_jar._loci.poi.hssf.record.GridsetRecord: ...
    def getHeader(self) -> bioformats_jar._loci.poi.hssf.record.HeaderRecord: ...
    def getLeftCol(self) -> int: ...
    def getLoc(self) -> int: ...
    def getMargin(self, short: int) -> float: ...
    def getMergedRegionAt(self, int: int) -> bioformats_jar._loci.poi.hssf.record.MergeCellsRecord.MergedRegion: ...
    def getNextRow(self) -> bioformats_jar._loci.poi.hssf.record.RowRecord: ...
    def getNextValueRecord(self) -> bioformats_jar._loci.poi.hssf.record.CellValueRecordInterface: ...
    def getNumColumnBreaks(self) -> int: ...
    def getNumMergedRegions(self) -> int: ...
    def getNumRecords(self) -> int: ...
    def getNumRowBreaks(self) -> int: ...
    def getPaneInformation(self) -> bioformats_jar._loci.poi.hssf.util.PaneInformation: ...
    def getPassword(self) -> bioformats_jar._loci.poi.hssf.record.PasswordRecord: ...
    def getPreOffset(self) -> int: ...
    def getPrintGridlines(self) -> bioformats_jar._loci.poi.hssf.record.PrintGridlinesRecord: ...
    def getPrintSetup(self) -> bioformats_jar._loci.poi.hssf.record.PrintSetupRecord: ...
    def getProtect(self) -> bioformats_jar._loci.poi.hssf.record.ProtectRecord: ...
    def getRecords(self) -> java.util.List: ...
    def getRow(self, int: int) -> bioformats_jar._loci.poi.hssf.record.RowRecord: ...
    def getRowBreaks(self) -> java.util.Iterator: ...
    def getSelection(self) -> bioformats_jar._loci.poi.hssf.record.SelectionRecord: ...
    def getSize(self) -> int: ...
    def getTopRow(self) -> int: ...
    def getXFIndexForColAt(self, short: int) -> int: ...
    def groupColumnRange(self, short: int, short2: int, boolean: bool) -> None: ...
    def groupRowRange(self, int: int, int2: int, boolean: bool) -> None: ...
    def isColumnBroken(self, short: int) -> bool: ...
    def isColumnHidden(self, short: int) -> bool: ...
    def isDisplayFormulas(self) -> bool: ...
    def isDisplayGridlines(self) -> bool: ...
    def isDisplayRowColHeadings(self) -> bool: ...
    def isGridsPrinted(self) -> bool: ...
    def isProtected(self) -> typing.List[bool]: ...
    def isRowBroken(self, int: int) -> bool: ...
    def preSerialize(self) -> None: ...
    def protectSheet(self, string: typing.Union[java.lang.String, str], boolean: bool, boolean2: bool) -> None: ...
    def removeColumnBreak(self, short: int) -> None: ...
    def removeMergedRegion(self, int: int) -> None: ...
    def removeRow(self, rowRecord: bioformats_jar._loci.poi.hssf.record.RowRecord) -> None: ...
    def removeRowBreak(self, int: int) -> None: ...
    def removeValueRecord(self, int: int, cellValueRecordInterface: bioformats_jar._loci.poi.hssf.record.CellValueRecordInterface) -> None: ...
    def replaceValueRecord(self, cellValueRecordInterface: bioformats_jar._loci.poi.hssf.record.CellValueRecordInterface) -> None: ...
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setActiveCellCol(self, short: int) -> None: ...
    def setActiveCellRow(self, int: int) -> None: ...
    @typing.overload
    def setColumn(self, short: int, short2: int, integer: int, boolean: bool, boolean2: bool) -> None: ...
    @typing.overload
    def setColumn(self, short: int, short2: int, short3: int, integer: int, boolean: bool, boolean2: bool) -> None: ...
    def setColumnBreak(self, short: int, short2: int, short3: int) -> None: ...
    def setColumnGroupCollapsed(self, short: int, boolean: bool) -> None: ...
    def setColumnHidden(self, short: int, boolean: bool) -> None: ...
    def setColumnWidth(self, short: int, short2: int) -> None: ...
    def setDefaultColumnWidth(self, short: int) -> None: ...
    def setDefaultRowHeight(self, short: int) -> None: ...
    def setDimensions(self, int: int, short: int, int2: int, short2: int) -> None: ...
    def setDisplayFormulas(self, boolean: bool) -> None: ...
    def setDisplayGridlines(self, boolean: bool) -> None: ...
    def setDisplayRowColHeadings(self, boolean: bool) -> None: ...
    def setFooter(self, footerRecord: bioformats_jar._loci.poi.hssf.record.FooterRecord) -> None: ...
    def setGridsPrinted(self, boolean: bool) -> None: ...
    def setHeader(self, headerRecord: bioformats_jar._loci.poi.hssf.record.HeaderRecord) -> None: ...
    def setLeftCol(self, short: int) -> None: ...
    def setLoc(self, int: int) -> None: ...
    def setMargin(self, short: int, double: float) -> None: ...
    def setPreOffset(self, int: int) -> None: ...
    def setPrintGridlines(self, printGridlinesRecord: bioformats_jar._loci.poi.hssf.record.PrintGridlinesRecord) -> None: ...
    def setPrintSetup(self, printSetupRecord: bioformats_jar._loci.poi.hssf.record.PrintSetupRecord) -> None: ...
    def setRowBreak(self, int: int, short: int, short2: int) -> None: ...
    def setRowGroupCollapsed(self, int: int, boolean: bool) -> None: ...
    def setSCLRecord(self, sCLRecord: bioformats_jar._loci.poi.hssf.record.SCLRecord) -> None: ...
    def setSelected(self, boolean: bool) -> None: ...
    def setSelection(self, selectionRecord: bioformats_jar._loci.poi.hssf.record.SelectionRecord) -> None: ...
    def setTopRow(self, short: int) -> None: ...
    def shiftBreaks(self, pageBreakRecord: bioformats_jar._loci.poi.hssf.record.PageBreakRecord, short: int, short2: int, int: int) -> None: ...
    def shiftColumnBreaks(self, short: int, short2: int, short3: int) -> None: ...
    def shiftRowBreaks(self, int: int, int2: int, int3: int) -> None: ...
    def unprotectSheet(self, boolean: bool, boolean2: bool, boolean3: bool) -> None: ...

class SimpleFilledShape(AbstractShape):
    def getObjRecord(self) -> bioformats_jar._loci.poi.hssf.record.ObjRecord: ...
    def getSpContainer(self) -> bioformats_jar._loci.poi.ddf.EscherContainerRecord: ...

class TextboxShape(AbstractShape):
    def getEscherTextbox(self) -> bioformats_jar._loci.poi.ddf.EscherRecord: ...
    def getObjRecord(self) -> bioformats_jar._loci.poi.hssf.record.ObjRecord: ...
    def getSpContainer(self) -> bioformats_jar._loci.poi.ddf.EscherContainerRecord: ...
    def getTextObjectRecord(self) -> bioformats_jar._loci.poi.hssf.record.TextObjectRecord: ...

class Workbook(Model):
    def __init__(self): ...
    def addBSERecord(self, escherBSERecord: bioformats_jar._loci.poi.ddf.EscherBSERecord) -> int: ...
    def addName(self, nameRecord: bioformats_jar._loci.poi.hssf.record.NameRecord) -> bioformats_jar._loci.poi.hssf.record.NameRecord: ...
    def addSSTString(self, unicodeString: bioformats_jar._loci.poi.hssf.record.UnicodeString) -> int: ...
    def checkExternSheet(self, int: int) -> int: ...
    def createBuiltInName(self, byte: int, int: int) -> bioformats_jar._loci.poi.hssf.record.NameRecord: ...
    def createCellXF(self) -> bioformats_jar._loci.poi.hssf.record.ExtendedFormatRecord: ...
    def createDrawingGroup(self) -> None: ...
    def createFormat(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def createName(self) -> bioformats_jar._loci.poi.hssf.record.NameRecord: ...
    def createNewFont(self) -> bioformats_jar._loci.poi.hssf.record.FontRecord: ...
    @typing.overload
    @staticmethod
    def createWorkbook() -> 'Workbook': ...
    @typing.overload
    @staticmethod
    def createWorkbook(list: java.util.List) -> 'Workbook': ...
    def doesContainsSheetName(self, string: typing.Union[java.lang.String, str], int: int) -> bool: ...
    def findFirstRecordBySid(self, short: int) -> bioformats_jar._loci.poi.hssf.record.Record: ...
    def findFirstRecordLocBySid(self, short: int) -> int: ...
    def findNextRecordBySid(self, short: int, int: int) -> bioformats_jar._loci.poi.hssf.record.Record: ...
    def findSheetNameFromExternSheet(self, short: int) -> java.lang.String: ...
    def getBSERecord(self, int: int) -> bioformats_jar._loci.poi.ddf.EscherBSERecord: ...
    def getBackupRecord(self) -> bioformats_jar._loci.poi.hssf.record.BackupRecord: ...
    def getCustomPalette(self) -> bioformats_jar._loci.poi.hssf.record.PaletteRecord: ...
    def getDrawingManager(self) -> DrawingManager2: ...
    def getExFormatAt(self, int: int) -> bioformats_jar._loci.poi.hssf.record.ExtendedFormatRecord: ...
    def getFileSharing(self) -> bioformats_jar._loci.poi.hssf.record.FileSharingRecord: ...
    def getFontRecordAt(self, int: int) -> bioformats_jar._loci.poi.hssf.record.FontRecord: ...
    def getFormat(self, string: typing.Union[java.lang.String, str], boolean: bool) -> int: ...
    def getFormats(self) -> java.util.ArrayList: ...
    def getNameRecord(self, int: int) -> bioformats_jar._loci.poi.hssf.record.NameRecord: ...
    def getNumExFormats(self) -> int: ...
    def getNumNames(self) -> int: ...
    def getNumRecords(self) -> int: ...
    def getNumSheets(self) -> int: ...
    def getNumberOfFontRecords(self) -> int: ...
    def getRecords(self) -> java.util.List: ...
    def getSSTString(self, int: int) -> bioformats_jar._loci.poi.hssf.record.UnicodeString: ...
    def getSheetIndex(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getSheetIndexFromExternSheetIndex(self, int: int) -> int: ...
    def getSheetName(self, int: int) -> java.lang.String: ...
    def getSheetReferences(self) -> bioformats_jar._loci.poi.hssf.util.SheetReferences: ...
    def getSize(self) -> int: ...
    def getSpecificBuiltinRecord(self, byte: int, int: int) -> bioformats_jar._loci.poi.hssf.record.NameRecord: ...
    def getWindowOne(self) -> bioformats_jar._loci.poi.hssf.record.WindowOneRecord: ...
    def getWriteAccess(self) -> bioformats_jar._loci.poi.hssf.record.WriteAccessRecord: ...
    def getWriteProtect(self) -> bioformats_jar._loci.poi.hssf.record.WriteProtectRecord: ...
    def insertSST(self) -> None: ...
    def isUsing1904DateWindowing(self) -> bool: ...
    def removeBuiltinRecord(self, byte: int, int: int) -> None: ...
    def removeName(self, int: int) -> None: ...
    def removeSheet(self, int: int) -> None: ...
    def serialize(self, int: int, byteArray: typing.List[int]) -> int: ...
    def setSheetBof(self, int: int, int2: int) -> None: ...
    @typing.overload
    def setSheetName(self, int: int, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setSheetName(self, int: int, string: typing.Union[java.lang.String, str], short: int) -> None: ...
    def setSheetOrder(self, string: typing.Union[java.lang.String, str], int: int) -> None: ...
    def unwriteProtectWorkbook(self) -> None: ...
    def writeProtectWorkbook(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...

class CommentShape(TextboxShape):
    def __init__(self, hSSFComment: bioformats_jar._loci.poi.hssf.usermodel.HSSFComment, int: int): ...
    def getNoteRecord(self) -> bioformats_jar._loci.poi.hssf.record.NoteRecord: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.poi.hssf.model")``.

    AbstractShape: typing.Type[AbstractShape]
    CommentShape: typing.Type[CommentShape]
    ConvertAnchor: typing.Type[ConvertAnchor]
    DrawingManager: typing.Type[DrawingManager]
    DrawingManager2: typing.Type[DrawingManager2]
    FormulaParser: typing.Type[FormulaParser]
    LineShape: typing.Type[LineShape]
    Model: typing.Type[Model]
    PictureShape: typing.Type[PictureShape]
    PolygonShape: typing.Type[PolygonShape]
    Sheet: typing.Type[Sheet]
    SimpleFilledShape: typing.Type[SimpleFilledShape]
    TextboxShape: typing.Type[TextboxShape]
    Workbook: typing.Type[Workbook]
    WorkbookRecordList: typing.Type[WorkbookRecordList]
