import java.lang
import java.util
import bioformats_jar._loci.poi.hssf.model
import bioformats_jar._loci.poi.hssf.record
import typing



class Ptg:
    CLASS_REF: typing.ClassVar[int] = ...
    CLASS_VALUE: typing.ClassVar[int] = ...
    CLASS_ARRAY: typing.ClassVar[int] = ...
    def __init__(self): ...
    def clone(self) -> typing.Any: ...
    @staticmethod
    def createParsedExpressionTokens(short: int, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream) -> java.util.Stack: ...
    @staticmethod
    def createPtg(recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream) -> 'Ptg': ...
    def getBytes(self) -> typing.List[int]: ...
    def getDefaultOperandClass(self) -> int: ...
    def getPtgClass(self) -> int: ...
    def getSize(self) -> int: ...
    @staticmethod
    def serializePtgStack(stack: java.util.Stack, byteArray: typing.List[int], int: int) -> int: ...
    def setClass(self, byte: int) -> None: ...
    def toDebugString(self) -> java.lang.String: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class Area3DPtg(Ptg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], short: int): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getDefaultOperandClass(self) -> int: ...
    def getExternSheetIndex(self) -> int: ...
    def getFirstColumn(self) -> int: ...
    def getFirstColumnRaw(self) -> int: ...
    def getFirstRow(self) -> int: ...
    def getLastColumn(self) -> int: ...
    def getLastColumnRaw(self) -> int: ...
    def getLastRow(self) -> int: ...
    def getSize(self) -> int: ...
    def hashCode(self) -> int: ...
    def isFirstColRelative(self) -> bool: ...
    def isFirstRowRelative(self) -> bool: ...
    def isLastColRelative(self) -> bool: ...
    def isLastRowRelative(self) -> bool: ...
    def setArea(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setExternSheetIndex(self, short: int) -> None: ...
    def setFirstColRelative(self, boolean: bool) -> None: ...
    def setFirstColumn(self, short: int) -> None: ...
    def setFirstColumnRaw(self, short: int) -> None: ...
    def setFirstRow(self, short: int) -> None: ...
    def setFirstRowRelative(self, boolean: bool) -> None: ...
    def setLastColRelative(self, boolean: bool) -> None: ...
    def setLastColumn(self, short: int) -> None: ...
    def setLastColumnRaw(self, short: int) -> None: ...
    def setLastRow(self, short: int) -> None: ...
    def setLastRowRelative(self, boolean: bool) -> None: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class AreaPtg(Ptg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    @typing.overload
    def __init__(self, short: int, short2: int, short3: int, short4: int, boolean: bool, boolean2: bool, boolean3: bool, boolean4: bool): ...
    def clone(self) -> typing.Any: ...
    def getAreaPtgName(self) -> java.lang.String: ...
    def getDefaultOperandClass(self) -> int: ...
    def getFirstColumn(self) -> int: ...
    def getFirstColumnRaw(self) -> int: ...
    def getFirstRow(self) -> int: ...
    def getLastColumn(self) -> int: ...
    def getLastColumnRaw(self) -> int: ...
    def getLastRow(self) -> int: ...
    def getSize(self) -> int: ...
    def isFirstColRelative(self) -> bool: ...
    def isFirstRowRelative(self) -> bool: ...
    def isLastColRelative(self) -> bool: ...
    def isLastRowRelative(self) -> bool: ...
    def setFirstColRelative(self, boolean: bool) -> None: ...
    def setFirstColumn(self, short: int) -> None: ...
    def setFirstColumnRaw(self, short: int) -> None: ...
    def setFirstRow(self, short: int) -> None: ...
    def setFirstRowRelative(self, boolean: bool) -> None: ...
    def setLastColRelative(self, boolean: bool) -> None: ...
    def setLastColumn(self, short: int) -> None: ...
    def setLastColumnRaw(self, short: int) -> None: ...
    def setLastRow(self, short: int) -> None: ...
    def setLastRowRelative(self, boolean: bool) -> None: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class ArrayPtg(Ptg):
    sid: typing.ClassVar[int] = ...
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getColumnCount(self) -> int: ...
    def getDefaultOperandClass(self) -> int: ...
    def getRowCount(self) -> int: ...
    def getSize(self) -> int: ...
    def readTokenValues(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream) -> None: ...
    def setColumnCount(self, short: int) -> None: ...
    def setRowCount(self, short: int) -> None: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...
    def writeTokenValueBytes(self, byteArray: typing.List[int], int: int) -> int: ...

class BoolPtg(Ptg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getSize(self) -> int: ...
    def getValue(self) -> bool: ...
    def setValue(self, boolean: bool) -> None: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class ControlPtg(Ptg):
    def __init__(self): ...

class ErrPtg(Ptg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getSize(self) -> int: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class ExpPtg(Ptg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getColumn(self) -> int: ...
    def getDefaultOperandClass(self) -> int: ...
    def getRow(self) -> int: ...
    def getSize(self) -> int: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class IntPtg(Ptg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getSize(self) -> int: ...
    def getValue(self) -> int: ...
    def setValue(self, short: int) -> None: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class MemAreaPtg(Ptg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getReserved(self) -> int: ...
    def getSize(self) -> int: ...
    def getSubexpressionLength(self) -> int: ...
    def setReserved(self, int: int) -> None: ...
    def setSubexpressionLength(self, short: int) -> None: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class MissingArgPtg(Ptg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getSize(self) -> int: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class NamePtg(Ptg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], workbook: bioformats_jar._loci.poi.hssf.model.Workbook): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getSize(self) -> int: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class NameXPtg(Ptg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getSize(self) -> int: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class NumberPtg(Ptg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getSize(self) -> int: ...
    def getValue(self) -> float: ...
    def setValue(self, double: float) -> None: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class OperationPtg(Ptg):
    TYPE_UNARY: typing.ClassVar[int] = ...
    TYPE_BINARY: typing.ClassVar[int] = ...
    TYPE_FUNCTION: typing.ClassVar[int] = ...
    def __init__(self): ...
    def getDefaultOperandClass(self) -> int: ...
    def getNumberOfOperands(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...

class Ref3DPtg(Ptg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], short: int): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getColumn(self) -> int: ...
    def getColumnRaw(self) -> int: ...
    def getDefaultOperandClass(self) -> int: ...
    def getExternSheetIndex(self) -> int: ...
    def getRow(self) -> int: ...
    def getSize(self) -> int: ...
    def isColRelative(self) -> bool: ...
    def isRowRelative(self) -> bool: ...
    def setArea(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setColRelative(self, boolean: bool) -> None: ...
    def setColumn(self, short: int) -> None: ...
    def setColumnRaw(self, short: int) -> None: ...
    def setExternSheetIndex(self, short: int) -> None: ...
    def setRow(self, short: int) -> None: ...
    def setRowRelative(self, boolean: bool) -> None: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class RefErrorPtg(Ptg):
    sid: typing.ClassVar[int] = ...
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getReserved(self) -> int: ...
    def getSize(self) -> int: ...
    def setReserved(self, int: int) -> None: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class ReferencePtg(Ptg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    @typing.overload
    def __init__(self, short: int, short2: int, boolean: bool, boolean2: bool): ...
    def clone(self) -> typing.Any: ...
    def getColumn(self) -> int: ...
    def getColumnRaw(self) -> int: ...
    def getDefaultOperandClass(self) -> int: ...
    def getRefPtgName(self) -> java.lang.String: ...
    def getRow(self) -> int: ...
    def getRowAsInt(self) -> int: ...
    def getSize(self) -> int: ...
    def isColRelative(self) -> bool: ...
    def isRowRelative(self) -> bool: ...
    def setColRelative(self, boolean: bool) -> None: ...
    def setColumn(self, short: int) -> None: ...
    def setColumnRaw(self, short: int) -> None: ...
    @typing.overload
    def setRow(self, int: int) -> None: ...
    @typing.overload
    def setRow(self, short: int) -> None: ...
    def setRowRelative(self, boolean: bool) -> None: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class StringPtg(Ptg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getSize(self) -> int: ...
    def getValue(self) -> java.lang.String: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class UnknownPtg(Ptg):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getSize(self) -> int: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class AbstractFunctionPtg(OperationPtg):
    ATTR_NAME: typing.ClassVar[java.lang.String] = ...
    INDEX_EXTERNAL: typing.ClassVar[int] = ...
    def __init__(self): ...
    def getDefaultOperandClass(self) -> int: ...
    def getFunctionIndex(self) -> int: ...
    def getName(self) -> java.lang.String: ...
    def getParameterClass(self, int: int) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class AddPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class AreaAPtg(AreaPtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    @typing.overload
    def __init__(self, short: int, short2: int, short3: int, short4: int, boolean: bool, boolean2: bool, boolean3: bool, boolean4: bool): ...
    def clone(self) -> typing.Any: ...
    def getAreaPtgName(self) -> java.lang.String: ...

class AreaErrPtg(AreaPtg):
    sid: typing.ClassVar[int] = ...
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class AreaNAPtg(AreaPtg):
    sid: typing.ClassVar[int] = ...
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getAreaPtgName(self) -> java.lang.String: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class AreaNPtg(AreaPtg):
    sid: typing.ClassVar[int] = ...
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getAreaPtgName(self) -> java.lang.String: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class AreaNVPtg(AreaPtg):
    sid: typing.ClassVar[int] = ...
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getAreaPtgName(self) -> java.lang.String: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class AreaVPtg(AreaPtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    @typing.overload
    def __init__(self, short: int, short2: int, short3: int, short4: int, boolean: bool, boolean2: bool, boolean3: bool, boolean4: bool): ...
    def clone(self) -> typing.Any: ...
    def getAreaPtgName(self) -> java.lang.String: ...

class ArrayPtgA(ArrayPtg):
    sid: typing.ClassVar[int] = ...
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...

class ArrayPtgV(ArrayPtg):
    sid: typing.ClassVar[int] = ...
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...

class AttrPtg(OperationPtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getData(self) -> int: ...
    def getDefaultOperandClass(self) -> int: ...
    def getNumberOfOperands(self) -> int: ...
    def getOptions(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    def isBaxcel(self) -> bool: ...
    def isGoto(self) -> bool: ...
    def isOptimizedChoose(self) -> bool: ...
    def isOptimizedIf(self) -> bool: ...
    def isSemiVolatile(self) -> bool: ...
    def isSpace(self) -> bool: ...
    def isSum(self) -> bool: ...
    def setData(self, short: int) -> None: ...
    def setGoto(self, boolean: bool) -> None: ...
    def setOptimizedIf(self, boolean: bool) -> None: ...
    def setOptions(self, byte: int) -> None: ...
    def setSum(self, boolean: bool) -> None: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class ConcatPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class DeletedArea3DPtg(Area3DPtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], short: int): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...

class DeletedRef3DPtg(Ref3DPtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], short: int): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...

class DividePtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class EqualPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class GreaterEqualPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class GreaterThanPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class IntersectionPtg(OperationPtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class LessEqualPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class LessThanPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class MemErrPtg(MemAreaPtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class MemFuncPtg(ControlPtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getLenRefSubexpression(self) -> int: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def setLenRefSubexpression(self, int: int) -> None: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class MultiplyPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getStringLength(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, ptgArray: typing.List[Ptg]) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class NotEqualPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class ParenthesisPtg(OperationPtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class PercentPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class PowerPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class RangePtg(OperationPtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class RefAPtg(ReferencePtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    @typing.overload
    def __init__(self, short: int, short2: int, boolean: bool, boolean2: bool): ...
    def clone(self) -> typing.Any: ...
    def getRefPtgName(self) -> java.lang.String: ...

class RefNAPtg(ReferencePtg):
    sid: typing.ClassVar[int] = ...
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getRefPtgName(self) -> java.lang.String: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class RefNPtg(ReferencePtg):
    sid: typing.ClassVar[int] = ...
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getRefPtgName(self) -> java.lang.String: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class RefNVPtg(ReferencePtg):
    sid: typing.ClassVar[int] = ...
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getRefPtgName(self) -> java.lang.String: ...
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class RefVPtg(ReferencePtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    @typing.overload
    def __init__(self, short: int, short2: int, boolean: bool, boolean2: bool): ...
    def clone(self) -> typing.Any: ...
    def getRefPtgName(self) -> java.lang.String: ...

class SubtractPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class UnaryMinusPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class UnaryPlusPtg(OperationPtg):
    SIZE: typing.ClassVar[int] = ...
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getDefaultOperandClass(self) -> int: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class UnionPtg(OperationPtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def getType(self) -> int: ...
    @typing.overload
    def toFormulaString(self, stringArray: typing.List[java.lang.String]) -> java.lang.String: ...
    @typing.overload
    def toFormulaString(self, workbook: bioformats_jar._loci.poi.hssf.model.Workbook) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class FuncPtg(AbstractFunctionPtg):
    sid: typing.ClassVar[int] = ...
    SIZE: typing.ClassVar[int] = ...
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def toString(self) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...

class FuncVarPtg(AbstractFunctionPtg):
    sid: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], byte: int): ...
    @typing.overload
    def __init__(self, recordInputStream: bioformats_jar._loci.poi.hssf.record.RecordInputStream): ...
    def clone(self) -> typing.Any: ...
    def getNumberOfOperands(self) -> int: ...
    def getSize(self) -> int: ...
    def toString(self) -> java.lang.String: ...
    def writeBytes(self, byteArray: typing.List[int], int: int) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.poi.hssf.record.formula")``.

    AbstractFunctionPtg: typing.Type[AbstractFunctionPtg]
    AddPtg: typing.Type[AddPtg]
    Area3DPtg: typing.Type[Area3DPtg]
    AreaAPtg: typing.Type[AreaAPtg]
    AreaErrPtg: typing.Type[AreaErrPtg]
    AreaNAPtg: typing.Type[AreaNAPtg]
    AreaNPtg: typing.Type[AreaNPtg]
    AreaNVPtg: typing.Type[AreaNVPtg]
    AreaPtg: typing.Type[AreaPtg]
    AreaVPtg: typing.Type[AreaVPtg]
    ArrayPtg: typing.Type[ArrayPtg]
    ArrayPtgA: typing.Type[ArrayPtgA]
    ArrayPtgV: typing.Type[ArrayPtgV]
    AttrPtg: typing.Type[AttrPtg]
    BoolPtg: typing.Type[BoolPtg]
    ConcatPtg: typing.Type[ConcatPtg]
    ControlPtg: typing.Type[ControlPtg]
    DeletedArea3DPtg: typing.Type[DeletedArea3DPtg]
    DeletedRef3DPtg: typing.Type[DeletedRef3DPtg]
    DividePtg: typing.Type[DividePtg]
    EqualPtg: typing.Type[EqualPtg]
    ErrPtg: typing.Type[ErrPtg]
    ExpPtg: typing.Type[ExpPtg]
    FuncPtg: typing.Type[FuncPtg]
    FuncVarPtg: typing.Type[FuncVarPtg]
    GreaterEqualPtg: typing.Type[GreaterEqualPtg]
    GreaterThanPtg: typing.Type[GreaterThanPtg]
    IntPtg: typing.Type[IntPtg]
    IntersectionPtg: typing.Type[IntersectionPtg]
    LessEqualPtg: typing.Type[LessEqualPtg]
    LessThanPtg: typing.Type[LessThanPtg]
    MemAreaPtg: typing.Type[MemAreaPtg]
    MemErrPtg: typing.Type[MemErrPtg]
    MemFuncPtg: typing.Type[MemFuncPtg]
    MissingArgPtg: typing.Type[MissingArgPtg]
    MultiplyPtg: typing.Type[MultiplyPtg]
    NamePtg: typing.Type[NamePtg]
    NameXPtg: typing.Type[NameXPtg]
    NotEqualPtg: typing.Type[NotEqualPtg]
    NumberPtg: typing.Type[NumberPtg]
    OperationPtg: typing.Type[OperationPtg]
    ParenthesisPtg: typing.Type[ParenthesisPtg]
    PercentPtg: typing.Type[PercentPtg]
    PowerPtg: typing.Type[PowerPtg]
    Ptg: typing.Type[Ptg]
    RangePtg: typing.Type[RangePtg]
    Ref3DPtg: typing.Type[Ref3DPtg]
    RefAPtg: typing.Type[RefAPtg]
    RefErrorPtg: typing.Type[RefErrorPtg]
    RefNAPtg: typing.Type[RefNAPtg]
    RefNPtg: typing.Type[RefNPtg]
    RefNVPtg: typing.Type[RefNVPtg]
    RefVPtg: typing.Type[RefVPtg]
    ReferencePtg: typing.Type[ReferencePtg]
    StringPtg: typing.Type[StringPtg]
    SubtractPtg: typing.Type[SubtractPtg]
    UnaryMinusPtg: typing.Type[UnaryMinusPtg]
    UnaryPlusPtg: typing.Type[UnaryPlusPtg]
    UnionPtg: typing.Type[UnionPtg]
    UnknownPtg: typing.Type[UnknownPtg]
