import java.io
import java.lang
import java.util
import bioformats_jar._loci.common
import bioformats_jar._loci.poi.hpsf
import bioformats_jar._loci.poi.poifs.dev
import bioformats_jar._loci.poi.poifs.storage
import typing



class BATManaged:
    def countBlocks(self) -> int: ...
    def setStartBlock(self, int: int) -> None: ...

class DocumentDescriptor:
    def __init__(self, pOIFSDocumentPath: 'POIFSDocumentPath', string: typing.Union[java.lang.String, str]): ...
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> java.lang.String: ...

class DocumentInputStream(java.io.InputStream):
    @typing.overload
    def __init__(self, documentEntry: 'DocumentEntry', randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream): ...
    @typing.overload
    def __init__(self, pOIFSDocument: 'POIFSDocument', randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class DocumentOutputStream(java.io.OutputStream):
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...

class Entry:
    def delete(self) -> bool: ...
    def getName(self) -> java.lang.String: ...
    def getParent(self) -> 'DirectoryEntry': ...
    def isDirectoryEntry(self) -> bool: ...
    def isDocumentEntry(self) -> bool: ...
    def renameTo(self, string: typing.Union[java.lang.String, str]) -> bool: ...

class OfficeXmlFileException(java.lang.IllegalArgumentException):
    def __init__(self, string: typing.Union[java.lang.String, str]): ...

class POIFSDocumentPath:
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, stringArray: typing.List[java.lang.String]): ...
    @typing.overload
    def __init__(self, pOIFSDocumentPath: 'POIFSDocumentPath', stringArray: typing.List[java.lang.String]): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getComponent(self, int: int) -> java.lang.String: ...
    def getParent(self) -> 'POIFSDocumentPath': ...
    def hashCode(self) -> int: ...
    def length(self) -> int: ...
    def toString(self) -> java.lang.String: ...

class POIFSFileSystem(loci.poi.poifs.dev.POIFSViewable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, int: int): ...
    def createDirectory(self, string: typing.Union[java.lang.String, str]) -> 'DirectoryEntry': ...
    @typing.overload
    def createDocument(self, string: typing.Union[java.lang.String, str], int: int, pOIFSWriterListener: 'POIFSWriterListener') -> 'DocumentEntry': ...
    @typing.overload
    def createDocument(self, randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, string: typing.Union[java.lang.String, str]) -> 'DocumentEntry': ...
    def createDocumentInputStream(self, string: typing.Union[java.lang.String, str]) -> DocumentInputStream: ...
    def getRoot(self) -> 'DirectoryEntry': ...
    def getShortDescription(self) -> java.lang.String: ...
    def getViewableArray(self) -> typing.List[typing.Any]: ...
    def getViewableIterator(self) -> java.util.Iterator: ...
    @staticmethod
    def main(stringArray: typing.List[java.lang.String]) -> None: ...
    def preferArray(self) -> bool: ...
    def writeFilesystem(self, outputStream: java.io.OutputStream) -> None: ...

class POIFSWriterEvent:
    def getLimit(self) -> int: ...
    def getName(self) -> java.lang.String: ...
    def getPath(self) -> POIFSDocumentPath: ...
    def getStream(self) -> DocumentOutputStream: ...

class POIFSWriterListener:
    def processPOIFSWriterEvent(self, pOIFSWriterEvent: POIFSWriterEvent) -> None: ...

class DirectoryEntry(Entry):
    def createDirectory(self, string: typing.Union[java.lang.String, str]) -> 'DirectoryEntry': ...
    @typing.overload
    def createDocument(self, string: typing.Union[java.lang.String, str], int: int, pOIFSWriterListener: POIFSWriterListener) -> 'DocumentEntry': ...
    @typing.overload
    def createDocument(self, string: typing.Union[java.lang.String, str], randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> 'DocumentEntry': ...
    def getEntries(self) -> java.util.Iterator: ...
    def getEntry(self, string: typing.Union[java.lang.String, str]) -> Entry: ...
    def getEntryCount(self) -> int: ...
    def getStorageClsid(self) -> bioformats_jar._loci.poi.hpsf.ClassID: ...
    def isEmpty(self) -> bool: ...
    def setStorageClsid(self, classID: bioformats_jar._loci.poi.hpsf.ClassID) -> None: ...

class DocumentEntry(Entry):
    def getSize(self) -> int: ...

class EntryNode(Entry):
    def delete(self) -> bool: ...
    def getName(self) -> java.lang.String: ...
    def getParent(self) -> DirectoryEntry: ...
    def isDirectoryEntry(self) -> bool: ...
    def isDocumentEntry(self) -> bool: ...
    def renameTo(self, string: typing.Union[java.lang.String, str]) -> bool: ...

class POIFSDocument(BATManaged, bioformats_jar._loci.poi.poifs.storage.BlockWritable, bioformats_jar._loci.poi.poifs.dev.POIFSViewable):
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], int: int, pOIFSDocumentPath: POIFSDocumentPath, pOIFSWriterListener: POIFSWriterListener, int2: int): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream, int: int): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], listManagedBlockArray: typing.List[loci.poi.poifs.storage.ListManagedBlock], int: int, int2: int): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], rawDataBlockArray: typing.List[loci.poi.poifs.storage.RawDataBlock], int: int): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], smallDocumentBlockArray: typing.List[loci.poi.poifs.storage.SmallDocumentBlock], int: int): ...
    def countBlocks(self) -> int: ...
    def getBigBlockSize(self) -> int: ...
    def getBigBlocks(self) -> typing.List[loci.poi.poifs.storage.DocumentBlock]: ...
    def getShortDescription(self) -> java.lang.String: ...
    def getSize(self) -> int: ...
    def getSmallBlocks(self) -> typing.List[loci.poi.poifs.storage.BlockWritable]: ...
    def getViewableArray(self) -> typing.List[typing.Any]: ...
    def getViewableIterator(self) -> java.util.Iterator: ...
    def preferArray(self) -> bool: ...
    def setStartBlock(self, int: int) -> None: ...
    def writeBlocks(self, outputStream: java.io.OutputStream) -> None: ...

class DirectoryNode(EntryNode, DirectoryEntry, bioformats_jar._loci.poi.poifs.dev.POIFSViewable):
    def createDirectory(self, string: typing.Union[java.lang.String, str]) -> DirectoryEntry: ...
    @typing.overload
    def createDocument(self, string: typing.Union[java.lang.String, str], int: int, pOIFSWriterListener: POIFSWriterListener) -> DocumentEntry: ...
    @typing.overload
    def createDocument(self, string: typing.Union[java.lang.String, str], randomAccessInputStream: bioformats_jar._loci.common.RandomAccessInputStream) -> DocumentEntry: ...
    def getEntries(self) -> java.util.Iterator: ...
    def getEntry(self, string: typing.Union[java.lang.String, str]) -> Entry: ...
    def getEntryCount(self) -> int: ...
    def getPath(self) -> POIFSDocumentPath: ...
    def getShortDescription(self) -> java.lang.String: ...
    def getStorageClsid(self) -> bioformats_jar._loci.poi.hpsf.ClassID: ...
    def getViewableArray(self) -> typing.List[typing.Any]: ...
    def getViewableIterator(self) -> java.util.Iterator: ...
    def isDirectoryEntry(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def preferArray(self) -> bool: ...
    def setStorageClsid(self, classID: bioformats_jar._loci.poi.hpsf.ClassID) -> None: ...

class DocumentNode(EntryNode, DocumentEntry, bioformats_jar._loci.poi.poifs.dev.POIFSViewable):
    def getDocument(self) -> POIFSDocument: ...
    def getShortDescription(self) -> java.lang.String: ...
    def getSize(self) -> int: ...
    def getViewableArray(self) -> typing.List[typing.Any]: ...
    def getViewableIterator(self) -> java.util.Iterator: ...
    def isDocumentEntry(self) -> bool: ...
    def preferArray(self) -> bool: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("loci.poi.poifs.filesystem")``.

    BATManaged: typing.Type[BATManaged]
    DirectoryEntry: typing.Type[DirectoryEntry]
    DirectoryNode: typing.Type[DirectoryNode]
    DocumentDescriptor: typing.Type[DocumentDescriptor]
    DocumentEntry: typing.Type[DocumentEntry]
    DocumentInputStream: typing.Type[DocumentInputStream]
    DocumentNode: typing.Type[DocumentNode]
    DocumentOutputStream: typing.Type[DocumentOutputStream]
    Entry: typing.Type[Entry]
    EntryNode: typing.Type[EntryNode]
    OfficeXmlFileException: typing.Type[OfficeXmlFileException]
    POIFSDocument: typing.Type[POIFSDocument]
    POIFSDocumentPath: typing.Type[POIFSDocumentPath]
    POIFSFileSystem: typing.Type[POIFSFileSystem]
    POIFSWriterEvent: typing.Type[POIFSWriterEvent]
    POIFSWriterListener: typing.Type[POIFSWriterListener]
