"""
API error codes for Backpack Exchange SDK.
"""

from enum import Enum


class ApiErrorCode(Enum):
    """API error codes."""
    ACCOUNT_DEACTIVATED = "ACCOUNT_DEACTIVATED"
    ACCOUNT_LIQUIDATING = "ACCOUNT_LIQUIDATING"
    BORROW_LIMIT = "BORROW_LIMIT"
    BORROW_REQUIRES_LEND_REDEEM = "BORROW_REQUIRES_LEND_REDEEM"
    FORBIDDEN = "FORBIDDEN"
    INSUFFICIENT_FUNDS = "INSUFFICIENT_FUNDS"
    INSUFFICIENT_MARGIN = "INSUFFICIENT_MARGIN"
    INSUFFICIENT_SUPPLY = "INSUFFICIENT_SUPPLY"
    INVALID_ASSET = "INVALID_ASSET"
    INVALID_CLIENT_REQUEST = "INVALID_CLIENT_REQUEST"
    INVALID_DESTINATION_ADDRESS = "INVALID_DESTINATION_ADDRESS"
    INVALID_MARKET = "INVALID_MARKET"
    INVALID_ORDER_TYPE = "INVALID_ORDER_TYPE"
    INVALID_PRICE = "INVALID_PRICE"
    INVALID_QUANTITY = "INVALID_QUANTITY"
    INVALID_SIDE = "INVALID_SIDE"
    INVALID_TIME_IN_FORCE = "INVALID_TIME_IN_FORCE"
    MAX_OPEN_ORDERS = "MAX_OPEN_ORDERS"
    MAX_POSITION_SIZE = "MAX_POSITION_SIZE"
    NOT_FOUND = "NOT_FOUND"
    ORDER_NOT_FOUND = "ORDER_NOT_FOUND"
    POSITION_LIMIT = "POSITION_LIMIT"
    RATE_LIMIT = "RATE_LIMIT"
    SELF_TRADE = "SELF_TRADE"
    SIGNATURE_INVALID = "SIGNATURE_INVALID"
    SYSTEM_ERROR = "SYSTEM_ERROR"
    TIMESTAMP_INVALID = "TIMESTAMP_INVALID"
    UNAUTHORIZED = "UNAUTHORIZED"
    WITHDRAWAL_ADDRESS_NOT_ALLOWED = "WITHDRAWAL_ADDRESS_NOT_ALLOWED"
    WITHDRAWAL_LIMIT = "WITHDRAWAL_LIMIT"
